/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef INTROSPECT_ORG_FREEDESKTOP_DBUS_INTROSPECTABLEPROXY_H
#define INTROSPECT_ORG_FREEDESKTOP_DBUS_INTROSPECTABLEPROXY_H

#include "asf/core/Logger.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusProxy.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "introspect/org/freedesktop/DBus/Introspectable.h"
#include <dbus/dbus.h>

namespace introspect {
namespace org {
namespace freedesktop {
namespace DBus {
namespace Introspectable {

class IntrospectableProxy;

class IntrospectCallbackIF {
public:
    virtual ~IntrospectCallbackIF() {}

    virtual void onIntrospectError(const ::boost::shared_ptr< IntrospectableProxy >& proxy, const ::boost::shared_ptr< IntrospectError >& error) = 0;

    virtual void onIntrospectResponse(const ::boost::shared_ptr< IntrospectableProxy >& proxy, const ::boost::shared_ptr< IntrospectResponse >& response) = 0;
};


/**
 * IntrospectableProxy is the client side representation of the D-Bus
 * service interface 'org.freedesktop.DBus.Introspectable' (specified in
 * file org_freedesktop_dbus_introspectable.xml).
 *
 * If the meaning of "org.freedesktop.DBus.Introspectable" isn't clear, then there should be a description here.
 */
class IntrospectableProxy : public ::asf::dbus::DBusProxy
{
public:
    /**
     * Create a new instance of IntrospectableProxy.
     */
    static ::boost::shared_ptr< IntrospectableProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Create a new instance of IntrospectableProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @deprecated use the createProxy() method with the parameter
     * ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector instead.
     */
    static ::boost::shared_ptr< IntrospectableProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        ::DBusBusType busType,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector connectorOptions;
        connectorOptions.setBusType(::asf::dbus::DBusUtils::toOptions(busType).getBusType());
        return createProxy(portName, busName, objectPath, connectorOptions, serviceAvailable);
    }

    /**
     * Create a new instance of IntrospectableProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     */
    static ::boost::shared_ptr< IntrospectableProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        const ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector& connectorOptions,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< IntrospectableProxy > proxyNew(new IntrospectableProxy(portName, serviceAvailable));
        ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew, busName, objectPath, connectorOptions);
        proxyNew->createHelperProxies(false);
        return proxyNew;
    }

    virtual ~IntrospectableProxy ();




    // Method 'Introspect'

    /**
     * Call the method 'Introspect'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'Introspect'</b>:
     *
     * If the meaning of "Introspect" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendIntrospectRequest(IntrospectCallbackIF& cb) const;


private:

    IntrospectableProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    act_t addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const;

    act_t addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const;


    DECLARE_CLASS_LOGGER();

    friend class IntrospectableProxyCallback;
};

} // namespace Introspectable
} // namespace DBus
} // namespace freedesktop
} // namespace org
} // namespace introspect

#endif // INTROSPECT_ORG_FREEDESKTOP_DBUS_INTROSPECTABLEPROXY_H
