/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "introspect/org/freedesktop/DBus/Introspectable.h"
#include "introspect/org/freedesktop/DBus/IntrospectableDBus.h"
#include "introspect/org/freedesktop/DBus/IntrospectableJson.h"
#include "introspect/org/freedesktop/DBus/IntrospectableProxy.h"

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace introspect {
namespace org {
namespace freedesktop {
namespace DBus {
namespace Introspectable {

DEFINE_CLASS_LOGGER("//xyz/org/freedesktop/DBus/Introspectable", IntrospectableProxy);

class IntrospectableProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    IntrospectableProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< IntrospectableProxy >& proxyShared = ::boost::static_pointer_cast< IntrospectableProxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_Introspect:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), IntrospectError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "Introspect", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<IntrospectError> payload = ::boost::static_pointer_cast<IntrospectError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((IntrospectCallbackIF*) _callback)->onIntrospectError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), IntrospectResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "Introspect", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<IntrospectResponse> payload = ::boost::static_pointer_cast<IntrospectResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((IntrospectCallbackIF*) _callback)->onIntrospectResponse (proxyShared, payload);
                        return true;
                    }
                }
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_Introspect: {
                ::boost::shared_ptr< IntrospectError > payload = ::boost::shared_ptr< IntrospectError >
                (new IntrospectError(DBUS_ERROR_NO_SERVER, "The DBus service Introspectable is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Introspect", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<IntrospectableProxy> proxyShared = ::boost::static_pointer_cast<IntrospectableProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((IntrospectCallbackIF*) _callback)->onIntrospectError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& IntrospectableProxyCallback::_logger (IntrospectableProxy::_logger);

IntrospectableProxy::IntrospectableProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "org.freedesktop.DBus.Introspectable", serviceAvailable, _logger) {
}

IntrospectableProxy::~IntrospectableProxy()
{
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< IntrospectableProxy > IntrospectableProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<IntrospectableProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< IntrospectableProxy > proxyNew(new IntrospectableProxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(false);
    return proxyNew;
}

act_t IntrospectableProxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    IntrospectableProxyCallback* callback = new IntrospectableProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t IntrospectableProxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    IntrospectableProxyCallback* callback = new IntrospectableProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}



act_t IntrospectableProxy::sendIntrospectRequest(IntrospectCallbackIF& cb) const {
    IntrospectRequest* payload = new IntrospectRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "Introspect", IntrospectRequest, payload, true)
    act_t act = addMethodCallback(ID_Introspect, dbusMessage.getUniqueSerial(), "Introspect", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "Introspect", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

} // namespace Introspectable
} // namespace DBus
} // namespace freedesktop
} // namespace org
} // namespace introspect
