/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusVariant.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "getall/org/freedesktop/DBus/Properties.h"
#include "getall/org/freedesktop/DBus/PropertiesDBus.h"
#include "getall/org/freedesktop/DBus/PropertiesJson.h"
#include "getall/org/freedesktop/DBus/PropertiesProxy.h"
#include <string>

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace getall {
namespace org {
namespace freedesktop {
namespace DBus {
namespace Properties {

DEFINE_CLASS_LOGGER("//xyz/org/freedesktop/DBus/Properties", PropertiesProxy);

class PropertiesProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    PropertiesProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< PropertiesProxy >& proxyShared = ::boost::static_pointer_cast< PropertiesProxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_PropertiesChanged:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), PropertiesChangedSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "PropertiesChanged", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<PropertiesChangedSignal> payload = ::boost::static_pointer_cast<PropertiesChangedSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((PropertiesChangedCallbackIF*) _callback)->onPropertiesChangedSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_Get:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), GetError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "Get", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetError> payload = ::boost::static_pointer_cast<GetError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetCallbackIF*) _callback)->onGetError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "Get", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetResponse> payload = ::boost::static_pointer_cast<GetResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetCallbackIF*) _callback)->onGetResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_Set:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), SetError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "Set", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetError> payload = ::boost::static_pointer_cast<SetError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetCallbackIF*) _callback)->onSetError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "Set", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetResponse> payload = ::boost::static_pointer_cast<SetResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetCallbackIF*) _callback)->onSetResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_GetAll:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), GetAllError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetAll", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetAllError> payload = ::boost::static_pointer_cast<GetAllError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetAllCallbackIF*) _callback)->onGetAllError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetAllResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetAll", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetAllResponse> payload = ::boost::static_pointer_cast<GetAllResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetAllCallbackIF*) _callback)->onGetAllResponse (proxyShared, payload);
                        return true;
                    }
                }
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_PropertiesChanged: {
                ::boost::shared_ptr< PropertiesChangedError > payload = ::boost::shared_ptr< PropertiesChangedError >
                (new PropertiesChangedError(DBUS_ERROR_NO_SERVER, "The DBus service Properties is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "PropertiesChanged", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<PropertiesProxy> proxyShared = ::boost::static_pointer_cast<PropertiesProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((PropertiesChangedCallbackIF*) _callback)->onPropertiesChangedError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Get: {
                ::boost::shared_ptr< GetError > payload = ::boost::shared_ptr< GetError >
                (new GetError(DBUS_ERROR_NO_SERVER, "The DBus service Properties is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Get", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<PropertiesProxy> proxyShared = ::boost::static_pointer_cast<PropertiesProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((GetCallbackIF*) _callback)->onGetError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Set: {
                ::boost::shared_ptr< SetError > payload = ::boost::shared_ptr< SetError >
                (new SetError(DBUS_ERROR_NO_SERVER, "The DBus service Properties is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Set", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<PropertiesProxy> proxyShared = ::boost::static_pointer_cast<PropertiesProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SetCallbackIF*) _callback)->onSetError (proxyShared,payload);
                return true;
            }
            break;
            case ID_GetAll: {
                ::boost::shared_ptr< GetAllError > payload = ::boost::shared_ptr< GetAllError >
                (new GetAllError(DBUS_ERROR_NO_SERVER, "The DBus service Properties is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "GetAll", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<PropertiesProxy> proxyShared = ::boost::static_pointer_cast<PropertiesProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((GetAllCallbackIF*) _callback)->onGetAllError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& PropertiesProxyCallback::_logger (PropertiesProxy::_logger);

PropertiesProxy::PropertiesProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "org.freedesktop.DBus.Properties", serviceAvailable, _logger) {
}

PropertiesProxy::~PropertiesProxy()
{
    sendDeregisterAll();
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< PropertiesProxy > PropertiesProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<PropertiesProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< PropertiesProxy > proxyNew(new PropertiesProxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(false);
    return proxyNew;
}

act_t PropertiesProxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    PropertiesProxyCallback* callback = new PropertiesProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t PropertiesProxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    PropertiesProxyCallback* callback = new PropertiesProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


void PropertiesProxy::sendDeregisterAll () const
{
    sendPropertiesChangedDeregisterAll();
}

act_t PropertiesProxy::sendPropertiesChangedRegister(PropertiesChangedCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "PropertiesChanged");
    act_t act = addSignalCallback(ID_PropertiesChanged, "PropertiesChanged", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "PropertiesChanged", &cb, act);
    return act;
}

bool PropertiesProxy::sendPropertiesChangedDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("PropertiesChanged", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "PropertiesChanged", act, static_cast<int>(rv));
    return rv;
}

void PropertiesProxy::sendPropertiesChangedDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "PropertiesChanged");
    _dbusProxyDelegate->deregisterSignalCallback("PropertiesChanged", 0, _dbusDaemonProxy.get(), false);
}

act_t PropertiesProxy::sendGetRequest(GetCallbackIF& cb, const ::std::string& interface, const ::std::string& name) const {
    GetRequest* payload = new GetRequest();
    CHECK_ALLOCATION(payload);
    payload->setInterface(interface);
    payload->setName(name);
    DBUS_MESSAGE_CALL(dbusMessage, "Get", GetRequest, payload, true)
    act_t act = addMethodCallback(ID_Get, dbusMessage.getUniqueSerial(), "Get", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "Get", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t PropertiesProxy::sendSetRequest(SetCallbackIF& cb, const ::std::string& interface, const ::std::string& name, const ::asf::dbus::DBusVariant& value) const {
    SetRequest* payload = new SetRequest();
    CHECK_ALLOCATION(payload);
    payload->setInterface(interface);
    payload->setName(name);
    payload->setValue(value);
    DBUS_MESSAGE_CALL(dbusMessage, "Set", SetRequest, payload, true)
    act_t act = addMethodCallback(ID_Set, dbusMessage.getUniqueSerial(), "Set", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "Set", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t PropertiesProxy::sendGetAllRequest(GetAllCallbackIF& cb, const ::std::string& interface) const {
    GetAllRequest* payload = new GetAllRequest();
    CHECK_ALLOCATION(payload);
    payload->setInterface(interface);
    DBUS_MESSAGE_CALL(dbusMessage, "GetAll", GetAllRequest, payload, true)
    act_t act = addMethodCallback(ID_GetAll, dbusMessage.getUniqueSerial(), "GetAll", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "GetAll", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

} // namespace Properties
} // namespace DBus
} // namespace freedesktop
} // namespace org
} // namespace getall
