#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef GETALL_ORG_FREEDESKTOP_DBUS_PROPERTIES_H
#define GETALL_ORG_FREEDESKTOP_DBUS_PROPERTIES_H

#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "asf/dbus/DBusTypes.h"
#include "asf/dbus/DBusVariant.h"
#include <cstddef>
#include <cstring>
#include <map>
#include <string>
#include <vector>

/**
 * If the meaning of "Properties" isn't clear, then there should be a description here.
 */

namespace getall {
namespace org {
namespace freedesktop {
namespace DBus {
namespace Properties {

// method IDs
static const uint16 ID_Get = 0;
static const uint16 ID_Set = 1;
static const uint16 ID_GetAll = 2;

// signal IDs
static const uint16 ID_PropertiesChanged = 3;

// property IDs

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class GetRequest;

class GetResponse;

class SetRequest;

class GetAllRequest;

class GetAllResponse;

class PropertiesChangedSignal;

// type definitions
/**
 * If the meaning of "GetError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError GetError;

/**
 * If the meaning of "SetResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage SetResponse;

/**
 * If the meaning of "SetError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SetError;

/**
 * If the meaning of "GetAllError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError GetAllError;

/**
 * If the meaning of "PropertiesChangedError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError PropertiesChangedError;


/**
 * If the meaning of "GetRequest" isn't clear, then there should be a description here.
 */
class GetRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetRequest ();

    /**
     * Copy constructor
     */
    inline  GetRequest (const GetRequest &rhs);

    /**
     * All fields constructor
     */
    inline  GetRequest (const ::std::string& interface_, const ::std::string& name_);

    /**
     * Destructor
     */
    inline virtual  ~GetRequest();

    /**
     * Assignment operator
     */
    inline GetRequest& operator = (const GetRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "interface"

    static const int kInterface = 0;

    /**
     * Clears the field "interface".
     *
     * The field will be set to its default value. The hasInterface()
     * method will return false.
     */
    inline void clearInterface();

    /**
     * Checks whether the field "interface" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setInterface()). Otherwise it will return false.
     */
    inline bool hasInterface () const;

    /**
     * Returns the value of the member "interface".
     *
     * If the meaning of "interface" isn't clear, then there should be a description here.
     *
     * @return The value of the field "interface"
     */
    inline const ::std::string& getInterface () const;

    /**
     * Retrieves the value of the field "interface" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "interface".
     */
    inline ::std::string& getInterfaceMutable ();

    /**
     * Sets the value of the member "interface".
     *
     * If the meaning of "interface" isn't clear, then there should be a description here.
     *
     * @param interface The value which will be set
     */
    inline void setInterface (const ::std::string& interface_);

    /**
     * Sets the value of the member "interface".
     *
     * If the meaning of "interface" isn't clear, then there should be a description here.
     *
     * @param interface The value which will be set
     */
    inline void setInterface (const char* interface_);

    /**
     * Sets the value of the member "interface".
     *
     * If the meaning of "interface" isn't clear, then there should be a description here.
     *
     * @param interface The value which will be set
     */
    inline void setInterface (const char* value, size_t size);

    // API of field "name"

    static const int kName = 1;

    /**
     * Clears the field "name".
     *
     * The field will be set to its default value. The hasName()
     * method will return false.
     */
    inline void clearName();

    /**
     * Checks whether the field "name" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setName()). Otherwise it will return false.
     */
    inline bool hasName () const;

    /**
     * Returns the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @return The value of the field "name"
     */
    inline const ::std::string& getName () const;

    /**
     * Retrieves the value of the field "name" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "name".
     */
    inline ::std::string& getNameMutable ();

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const ::std::string& name_);

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const char* name_);

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const char* value, size_t size);

    static const GetRequest &getDefaultInstance();

private:

    inline void set_has_interface ();

    inline void clear_has_interface ();

    inline void set_has_name ();

    inline void clear_has_name ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _interface;

    ::std::string _name;

};

/**
 * If the meaning of "GetResponse" isn't clear, then there should be a description here.
 */
class GetResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetResponse ();

    /**
     * Copy constructor
     */
    inline  GetResponse (const GetResponse &rhs);

    /**
     * All fields constructor
     */
    inline  GetResponse (const ::asf::dbus::DBusVariant& value_);

    /**
     * Destructor
     */
    inline virtual  ~GetResponse();

    /**
     * Assignment operator
     */
    inline GetResponse& operator = (const GetResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "value"

    static const int kValue = 0;

    /**
     * Clears the field "value".
     *
     * The field will be set to its default value. The hasValue()
     * method will return false.
     */
    inline void clearValue();

    /**
     * Checks whether the field "value" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setValue()). Otherwise it will return false.
     */
    inline bool hasValue () const;

    /**
     * Returns the value of the member "value".
     *
     * If the meaning of "value" isn't clear, then there should be a description here.
     *
     * @return The value of the field "value"
     */
    inline const ::asf::dbus::DBusVariant& getValue () const;

    /**
     * Retrieves the value of the field "value" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "value".
     */
    inline ::asf::dbus::DBusVariant& getValueMutable ();

    /**
     * Sets the value of the member "value".
     *
     * If the meaning of "value" isn't clear, then there should be a description here.
     *
     * @param value The value which will be set
     */
    inline void setValue (const ::asf::dbus::DBusVariant& value_);

    static const GetResponse &getDefaultInstance();

private:

    inline void set_has_value ();

    inline void clear_has_value ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::asf::dbus::DBusVariant _value;

};

/**
 * If the meaning of "SetRequest" isn't clear, then there should be a description here.
 */
class SetRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetRequest ();

    /**
     * Copy constructor
     */
    inline  SetRequest (const SetRequest &rhs);

    /**
     * All fields constructor
     */
    inline  SetRequest (const ::std::string& interface_, const ::std::string& name_, const ::asf::dbus::DBusVariant& value_);

    /**
     * Destructor
     */
    inline virtual  ~SetRequest();

    /**
     * Assignment operator
     */
    inline SetRequest& operator = (const SetRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "interface"

    static const int kInterface = 0;

    /**
     * Clears the field "interface".
     *
     * The field will be set to its default value. The hasInterface()
     * method will return false.
     */
    inline void clearInterface();

    /**
     * Checks whether the field "interface" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setInterface()). Otherwise it will return false.
     */
    inline bool hasInterface () const;

    /**
     * Returns the value of the member "interface".
     *
     * If the meaning of "interface" isn't clear, then there should be a description here.
     *
     * @return The value of the field "interface"
     */
    inline const ::std::string& getInterface () const;

    /**
     * Retrieves the value of the field "interface" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "interface".
     */
    inline ::std::string& getInterfaceMutable ();

    /**
     * Sets the value of the member "interface".
     *
     * If the meaning of "interface" isn't clear, then there should be a description here.
     *
     * @param interface The value which will be set
     */
    inline void setInterface (const ::std::string& interface_);

    /**
     * Sets the value of the member "interface".
     *
     * If the meaning of "interface" isn't clear, then there should be a description here.
     *
     * @param interface The value which will be set
     */
    inline void setInterface (const char* interface_);

    /**
     * Sets the value of the member "interface".
     *
     * If the meaning of "interface" isn't clear, then there should be a description here.
     *
     * @param interface The value which will be set
     */
    inline void setInterface (const char* value, size_t size);

    // API of field "name"

    static const int kName = 1;

    /**
     * Clears the field "name".
     *
     * The field will be set to its default value. The hasName()
     * method will return false.
     */
    inline void clearName();

    /**
     * Checks whether the field "name" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setName()). Otherwise it will return false.
     */
    inline bool hasName () const;

    /**
     * Returns the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @return The value of the field "name"
     */
    inline const ::std::string& getName () const;

    /**
     * Retrieves the value of the field "name" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "name".
     */
    inline ::std::string& getNameMutable ();

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const ::std::string& name_);

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const char* name_);

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const char* value, size_t size);

    // API of field "value"

    static const int kValue = 2;

    /**
     * Clears the field "value".
     *
     * The field will be set to its default value. The hasValue()
     * method will return false.
     */
    inline void clearValue();

    /**
     * Checks whether the field "value" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setValue()). Otherwise it will return false.
     */
    inline bool hasValue () const;

    /**
     * Returns the value of the member "value".
     *
     * If the meaning of "value" isn't clear, then there should be a description here.
     *
     * @return The value of the field "value"
     */
    inline const ::asf::dbus::DBusVariant& getValue () const;

    /**
     * Retrieves the value of the field "value" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "value".
     */
    inline ::asf::dbus::DBusVariant& getValueMutable ();

    /**
     * Sets the value of the member "value".
     *
     * If the meaning of "value" isn't clear, then there should be a description here.
     *
     * @param value The value which will be set
     */
    inline void setValue (const ::asf::dbus::DBusVariant& value_);

    static const SetRequest &getDefaultInstance();

private:

    inline void set_has_interface ();

    inline void clear_has_interface ();

    inline void set_has_name ();

    inline void clear_has_name ();

    inline void set_has_value ();

    inline void clear_has_value ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::std::string _interface;

    ::std::string _name;

    ::asf::dbus::DBusVariant _value;

};

/**
 * If the meaning of "GetAllRequest" isn't clear, then there should be a description here.
 */
class GetAllRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetAllRequest ();

    /**
     * Copy constructor
     */
    inline  GetAllRequest (const GetAllRequest &rhs);

    /**
     * All fields constructor
     */
    inline  GetAllRequest (const ::std::string& interface_);

    /**
     * Destructor
     */
    inline virtual  ~GetAllRequest();

    /**
     * Assignment operator
     */
    inline GetAllRequest& operator = (const GetAllRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetAllRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetAllRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetAllRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetAllRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "interface"

    static const int kInterface = 0;

    /**
     * Clears the field "interface".
     *
     * The field will be set to its default value. The hasInterface()
     * method will return false.
     */
    inline void clearInterface();

    /**
     * Checks whether the field "interface" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setInterface()). Otherwise it will return false.
     */
    inline bool hasInterface () const;

    /**
     * Returns the value of the member "interface".
     *
     * If the meaning of "interface" isn't clear, then there should be a description here.
     *
     * @return The value of the field "interface"
     */
    inline const ::std::string& getInterface () const;

    /**
     * Retrieves the value of the field "interface" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "interface".
     */
    inline ::std::string& getInterfaceMutable ();

    /**
     * Sets the value of the member "interface".
     *
     * If the meaning of "interface" isn't clear, then there should be a description here.
     *
     * @param interface The value which will be set
     */
    inline void setInterface (const ::std::string& interface_);

    /**
     * Sets the value of the member "interface".
     *
     * If the meaning of "interface" isn't clear, then there should be a description here.
     *
     * @param interface The value which will be set
     */
    inline void setInterface (const char* interface_);

    /**
     * Sets the value of the member "interface".
     *
     * If the meaning of "interface" isn't clear, then there should be a description here.
     *
     * @param interface The value which will be set
     */
    inline void setInterface (const char* value, size_t size);

    static const GetAllRequest &getDefaultInstance();

private:

    inline void set_has_interface ();

    inline void clear_has_interface ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _interface;

};

/**
 * If the meaning of "GetAllResponse" isn't clear, then there should be a description here.
 */
class GetAllResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetAllResponse ();

    /**
     * Copy constructor
     */
    inline  GetAllResponse (const GetAllResponse &rhs);

    /**
     * All fields constructor
     */
    inline  GetAllResponse (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties_);

    /**
     * Destructor
     */
    inline virtual  ~GetAllResponse();

    /**
     * Assignment operator
     */
    inline GetAllResponse& operator = (const GetAllResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetAllResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetAllResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetAllResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetAllResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "properties"

    static const int kProperties = 0;

    /**
     * Clears the field "properties".
     *
     * The field will be set to its default value. The hasProperties()
     * method will return false.
     */
    inline void clearProperties();

    /**
     * Checks whether the field "properties" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setProperties()). Otherwise it will return false.
     */
    inline bool hasProperties () const;

    /**
     * Returns the value of the member "properties".
     *
     * If the meaning of "properties" isn't clear, then there should be a description here.
     *
     * @return The value of the field "properties"
     */
    inline const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getProperties () const;

    /**
     * Retrieves the value of the field "properties" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "properties".
     */
    inline ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getPropertiesMutable ();

    /**
     * Sets the value of the member "properties".
     *
     * If the meaning of "properties" isn't clear, then there should be a description here.
     *
     * @param properties The value which will be set
     */
    inline void setProperties (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties_);

    static const GetAllResponse &getDefaultInstance();

private:

    static const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getStringTo__asf__dbus__DBusVariantMap_DefaultInstance ();

    inline void set_has_properties ();

    inline void clear_has_properties ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::map< ::std::string, ::asf::dbus::DBusVariant > _properties;

};

/**
 * If the meaning of "PropertiesChangedSignal" isn't clear, then there should be a description here.
 */
class PropertiesChangedSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PropertiesChangedSignal ();

    /**
     * Copy constructor
     */
    inline  PropertiesChangedSignal (const PropertiesChangedSignal &rhs);

    /**
     * All fields constructor
     */
    inline  PropertiesChangedSignal (const ::std::string& interface_, const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& changed_properties_, const ::std::vector< ::std::string >& invalidated_properties_);

    /**
     * Destructor
     */
    inline virtual  ~PropertiesChangedSignal();

    /**
     * Assignment operator
     */
    inline PropertiesChangedSignal& operator = (const PropertiesChangedSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PropertiesChangedSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PropertiesChangedSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PropertiesChangedSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PropertiesChangedSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "interface"

    static const int kInterface = 0;

    /**
     * Clears the field "interface".
     *
     * The field will be set to its default value. The hasInterface()
     * method will return false.
     */
    inline void clearInterface();

    /**
     * Checks whether the field "interface" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setInterface()). Otherwise it will return false.
     */
    inline bool hasInterface () const;

    /**
     * Returns the value of the member "interface".
     *
     * If the meaning of "interface" isn't clear, then there should be a description here.
     *
     * @return The value of the field "interface"
     */
    inline const ::std::string& getInterface () const;

    /**
     * Retrieves the value of the field "interface" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "interface".
     */
    inline ::std::string& getInterfaceMutable ();

    /**
     * Sets the value of the member "interface".
     *
     * If the meaning of "interface" isn't clear, then there should be a description here.
     *
     * @param interface The value which will be set
     */
    inline void setInterface (const ::std::string& interface_);

    /**
     * Sets the value of the member "interface".
     *
     * If the meaning of "interface" isn't clear, then there should be a description here.
     *
     * @param interface The value which will be set
     */
    inline void setInterface (const char* interface_);

    /**
     * Sets the value of the member "interface".
     *
     * If the meaning of "interface" isn't clear, then there should be a description here.
     *
     * @param interface The value which will be set
     */
    inline void setInterface (const char* value, size_t size);

    // API of field "changed_properties"

    static const int kChanged_properties = 1;

    /**
     * Clears the field "changed_properties".
     *
     * The field will be set to its default value. The hasChanged_properties()
     * method will return false.
     */
    inline void clearChanged_properties();

    /**
     * Checks whether the field "changed_properties" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChanged_properties()). Otherwise it will return false.
     */
    inline bool hasChanged_properties () const;

    /**
     * Returns the value of the member "changed_properties".
     *
     * If the meaning of "changed_properties" isn't clear, then there should be a description here.
     *
     * @return The value of the field "changed_properties"
     */
    inline const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getChanged_properties () const;

    /**
     * Retrieves the value of the field "changed_properties" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "changed_properties".
     */
    inline ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getChanged_propertiesMutable ();

    /**
     * Sets the value of the member "changed_properties".
     *
     * If the meaning of "changed_properties" isn't clear, then there should be a description here.
     *
     * @param changed_properties The value which will be set
     */
    inline void setChanged_properties (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& changed_properties_);

    // API of field "invalidated_properties"

    static const int kInvalidated_properties = 2;

    /**
     * Clears the field "invalidated_properties".
     *
     * The field will be set to its default value. The hasInvalidated_properties()
     * method will return false.
     */
    inline void clearInvalidated_properties();

    /**
     * Checks whether the field "invalidated_properties" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setInvalidated_properties()). Otherwise it will return false.
     */
    inline bool hasInvalidated_properties () const;

    /**
     * Returns the value of the member "invalidated_properties".
     *
     * If the meaning of "invalidated_properties" isn't clear, then there should be a description here.
     *
     * @return The value of the field "invalidated_properties"
     */
    inline const ::std::vector< ::std::string >& getInvalidated_properties () const;

    /**
     * Retrieves the value of the field "invalidated_properties" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "invalidated_properties".
     */
    inline ::std::vector< ::std::string >& getInvalidated_propertiesMutable ();

    /**
     * Sets the value of the member "invalidated_properties".
     *
     * If the meaning of "invalidated_properties" isn't clear, then there should be a description here.
     *
     * @param invalidated_properties The value which will be set
     */
    inline void setInvalidated_properties (const ::std::vector< ::std::string >& invalidated_properties_);

    static const PropertiesChangedSignal &getDefaultInstance();

private:

    static const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getStringTo__asf__dbus__DBusVariantMap_DefaultInstance ();

    static const ::std::vector< ::std::string >& getStringList_DefaultInstance ();

    inline void set_has_interface ();

    inline void clear_has_interface ();

    inline void set_has_changed_properties ();

    inline void clear_has_changed_properties ();

    inline void set_has_invalidated_properties ();

    inline void clear_has_invalidated_properties ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::std::string _interface;

    ::std::map< ::std::string, ::asf::dbus::DBusVariant > _changed_properties;

    ::std::vector< ::std::string > _invalidated_properties;

};

inline  GetRequest::GetRequest ()  :
    _interface (),
    _name ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetRequest::GetRequest (const GetRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _interface (),
    _name ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetRequest::GetRequest (const ::std::string& interface_, const ::std::string& name_)  :
    _interface (interface_),
    _name (name_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (interface_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetRequest::~GetRequest() {
}

inline GetRequest& GetRequest::operator = (const GetRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasInterface()) {
            setInterface(rhs.getInterface());
        } else {
            clearInterface();
        }
        if (rhs.hasName()) {
            setName(rhs.getName());
        } else {
            clearName();
        }
    }
    return *this;
}

inline bool GetRequest::operator == (const GetRequest& rhs) const {
    return (((!hasInterface() && !rhs.hasInterface()) || getInterface() == rhs.getInterface()) &&
        ((!hasName() && !rhs.hasName()) || getName() == rhs.getName()));
}

inline bool GetRequest::operator != (const GetRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool GetRequest::operator < (const GetRequest& rhs) const {
    if (hasInterface() || rhs.hasInterface()) {
        if (getInterface() < rhs.getInterface()) return true;
        if (getInterface() > rhs.getInterface()) return false;
    }
    if (hasName() || rhs.hasName()) {
        if (getName() < rhs.getName()) return true;
        if (getName() > rhs.getName()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetRequest::clone() {
    return new GetRequest(*this);
}

inline bool GetRequest::operator > (const GetRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetRequest::clear() {
    clearInterface();
    clearName();
}

inline void GetRequest::clearInterface() {
    if (hasInterface()) {
         clear_has_interface();
        _interface.clear();
     }
}

inline bool GetRequest::hasInterface () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& GetRequest::getInterface () const {
    return _interface;
}

inline ::std::string& GetRequest::getInterfaceMutable () {
    set_has_interface();
    return _interface;
}

inline void GetRequest::setInterface (const ::std::string& interface_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (interface_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_interface();
    this->_interface = interface_;
}

inline void GetRequest::setInterface (const char* interface_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (interface_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_interface();
    this->_interface.assign(interface_);
}

inline void GetRequest::setInterface (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_interface();
    this->_interface.assign(value, size);
}

inline void GetRequest::clearName() {
    if (hasName()) {
         clear_has_name();
        _name.clear();
     }
}

inline bool GetRequest::hasName () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& GetRequest::getName () const {
    return _name;
}

inline ::std::string& GetRequest::getNameMutable () {
    set_has_name();
    return _name;
}

inline void GetRequest::setName (const ::std::string& name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name = name_;
}

inline void GetRequest::setName (const char* name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name.assign(name_);
}

inline void GetRequest::setName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name.assign(value, size);
}

inline void GetRequest::set_has_interface () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetRequest::clear_has_interface () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GetRequest::set_has_name () {
    _has_bits_[0] |= 1u << 1;
}

inline void GetRequest::clear_has_name () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  GetResponse::GetResponse ()  :
    _value ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetResponse::GetResponse (const GetResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _value ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetResponse::GetResponse (const ::asf::dbus::DBusVariant& value_)  :
    _value (value_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetResponse::~GetResponse() {
}

inline GetResponse& GetResponse::operator = (const GetResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasValue()) {
            setValue(rhs.getValue());
        } else {
            clearValue();
        }
    }
    return *this;
}

inline bool GetResponse::operator == (const GetResponse& rhs) const {
    return (((!hasValue() && !rhs.hasValue()) || getValue() == rhs.getValue()));
}

inline bool GetResponse::operator != (const GetResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool GetResponse::operator < (const GetResponse& rhs) const {
    if (hasValue() || rhs.hasValue()) {
        if (getValue() < rhs.getValue()) return true;
        if (getValue() > rhs.getValue()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetResponse::clone() {
    return new GetResponse(*this);
}

inline bool GetResponse::operator > (const GetResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetResponse::clear() {
    clearValue();
}

inline void GetResponse::clearValue() {
    if (hasValue()) {
         clear_has_value();
        _value = ::asf::dbus::DBusVariant ();
     }
}

inline bool GetResponse::hasValue () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::asf::dbus::DBusVariant& GetResponse::getValue () const {
    return _value;
}

inline ::asf::dbus::DBusVariant& GetResponse::getValueMutable () {
    set_has_value();
    return _value;
}

inline void GetResponse::setValue (const ::asf::dbus::DBusVariant& value_) {
    set_has_value();
    this->_value = value_;
}

inline void GetResponse::set_has_value () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetResponse::clear_has_value () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SetRequest::SetRequest ()  :
    _interface (),
    _name (),
    _value ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetRequest::SetRequest (const SetRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _interface (),
    _name (),
    _value ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetRequest::SetRequest (const ::std::string& interface_, const ::std::string& name_, const ::asf::dbus::DBusVariant& value_)  :
    _interface (interface_),
    _name (name_),
    _value (value_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (interface_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetRequest::~SetRequest() {
}

inline SetRequest& SetRequest::operator = (const SetRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasInterface()) {
            setInterface(rhs.getInterface());
        } else {
            clearInterface();
        }
        if (rhs.hasName()) {
            setName(rhs.getName());
        } else {
            clearName();
        }
        if (rhs.hasValue()) {
            setValue(rhs.getValue());
        } else {
            clearValue();
        }
    }
    return *this;
}

inline bool SetRequest::operator == (const SetRequest& rhs) const {
    return (((!hasInterface() && !rhs.hasInterface()) || getInterface() == rhs.getInterface()) &&
        ((!hasName() && !rhs.hasName()) || getName() == rhs.getName()) &&
        ((!hasValue() && !rhs.hasValue()) || getValue() == rhs.getValue()));
}

inline bool SetRequest::operator != (const SetRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool SetRequest::operator < (const SetRequest& rhs) const {
    if (hasInterface() || rhs.hasInterface()) {
        if (getInterface() < rhs.getInterface()) return true;
        if (getInterface() > rhs.getInterface()) return false;
    }
    if (hasName() || rhs.hasName()) {
        if (getName() < rhs.getName()) return true;
        if (getName() > rhs.getName()) return false;
    }
    if (hasValue() || rhs.hasValue()) {
        if (getValue() < rhs.getValue()) return true;
        if (getValue() > rhs.getValue()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetRequest::clone() {
    return new SetRequest(*this);
}

inline bool SetRequest::operator > (const SetRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetRequest::clear() {
    clearInterface();
    clearName();
    clearValue();
}

inline void SetRequest::clearInterface() {
    if (hasInterface()) {
         clear_has_interface();
        _interface.clear();
     }
}

inline bool SetRequest::hasInterface () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& SetRequest::getInterface () const {
    return _interface;
}

inline ::std::string& SetRequest::getInterfaceMutable () {
    set_has_interface();
    return _interface;
}

inline void SetRequest::setInterface (const ::std::string& interface_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (interface_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_interface();
    this->_interface = interface_;
}

inline void SetRequest::setInterface (const char* interface_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (interface_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_interface();
    this->_interface.assign(interface_);
}

inline void SetRequest::setInterface (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_interface();
    this->_interface.assign(value, size);
}

inline void SetRequest::clearName() {
    if (hasName()) {
         clear_has_name();
        _name.clear();
     }
}

inline bool SetRequest::hasName () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& SetRequest::getName () const {
    return _name;
}

inline ::std::string& SetRequest::getNameMutable () {
    set_has_name();
    return _name;
}

inline void SetRequest::setName (const ::std::string& name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name = name_;
}

inline void SetRequest::setName (const char* name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name.assign(name_);
}

inline void SetRequest::setName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name.assign(value, size);
}

inline void SetRequest::clearValue() {
    if (hasValue()) {
         clear_has_value();
        _value = ::asf::dbus::DBusVariant ();
     }
}

inline bool SetRequest::hasValue () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::asf::dbus::DBusVariant& SetRequest::getValue () const {
    return _value;
}

inline ::asf::dbus::DBusVariant& SetRequest::getValueMutable () {
    set_has_value();
    return _value;
}

inline void SetRequest::setValue (const ::asf::dbus::DBusVariant& value_) {
    set_has_value();
    this->_value = value_;
}

inline void SetRequest::set_has_interface () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetRequest::clear_has_interface () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SetRequest::set_has_name () {
    _has_bits_[0] |= 1u << 1;
}

inline void SetRequest::clear_has_name () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void SetRequest::set_has_value () {
    _has_bits_[0] |= 1u << 2;
}

inline void SetRequest::clear_has_value () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  GetAllRequest::GetAllRequest ()  :
    _interface ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetAllRequest::GetAllRequest (const GetAllRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _interface ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetAllRequest::GetAllRequest (const ::std::string& interface_)  :
    _interface (interface_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (interface_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetAllRequest::~GetAllRequest() {
}

inline GetAllRequest& GetAllRequest::operator = (const GetAllRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasInterface()) {
            setInterface(rhs.getInterface());
        } else {
            clearInterface();
        }
    }
    return *this;
}

inline bool GetAllRequest::operator == (const GetAllRequest& rhs) const {
    return (((!hasInterface() && !rhs.hasInterface()) || getInterface() == rhs.getInterface()));
}

inline bool GetAllRequest::operator != (const GetAllRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool GetAllRequest::operator < (const GetAllRequest& rhs) const {
    if (hasInterface() || rhs.hasInterface()) {
        if (getInterface() < rhs.getInterface()) return true;
        if (getInterface() > rhs.getInterface()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetAllRequest::clone() {
    return new GetAllRequest(*this);
}

inline bool GetAllRequest::operator > (const GetAllRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetAllRequest::clear() {
    clearInterface();
}

inline void GetAllRequest::clearInterface() {
    if (hasInterface()) {
         clear_has_interface();
        _interface.clear();
     }
}

inline bool GetAllRequest::hasInterface () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& GetAllRequest::getInterface () const {
    return _interface;
}

inline ::std::string& GetAllRequest::getInterfaceMutable () {
    set_has_interface();
    return _interface;
}

inline void GetAllRequest::setInterface (const ::std::string& interface_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (interface_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_interface();
    this->_interface = interface_;
}

inline void GetAllRequest::setInterface (const char* interface_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (interface_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_interface();
    this->_interface.assign(interface_);
}

inline void GetAllRequest::setInterface (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_interface();
    this->_interface.assign(value, size);
}

inline void GetAllRequest::set_has_interface () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetAllRequest::clear_has_interface () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GetAllResponse::GetAllResponse ()  :
    _properties ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetAllResponse::GetAllResponse (const GetAllResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _properties ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetAllResponse::GetAllResponse (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties_)  :
    _properties (properties_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetAllResponse::~GetAllResponse() {
}

inline GetAllResponse& GetAllResponse::operator = (const GetAllResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasProperties()) {
            setProperties(rhs.getProperties());
        } else {
            clearProperties();
        }
    }
    return *this;
}

inline bool GetAllResponse::operator == (const GetAllResponse& rhs) const {
    return (((!hasProperties() && !rhs.hasProperties()) || getProperties() == rhs.getProperties()));
}

inline bool GetAllResponse::operator != (const GetAllResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool GetAllResponse::operator < (const GetAllResponse& rhs) const {
    if (hasProperties() || rhs.hasProperties()) {
        if (getProperties() < rhs.getProperties()) return true;
        if (getProperties() > rhs.getProperties()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetAllResponse::clone() {
    return new GetAllResponse(*this);
}

inline bool GetAllResponse::operator > (const GetAllResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetAllResponse::clear() {
    clearProperties();
}

inline void GetAllResponse::clearProperties() {
    if (hasProperties()) {
         clear_has_properties();
        _properties.clear();
     }
}

inline bool GetAllResponse::hasProperties () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& GetAllResponse::getProperties () const {
    return _properties;
}

inline ::std::map< ::std::string, ::asf::dbus::DBusVariant >& GetAllResponse::getPropertiesMutable () {
    set_has_properties();
    return _properties;
}

inline void GetAllResponse::setProperties (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties_) {
    set_has_properties();
    this->_properties = properties_;
}

inline void GetAllResponse::set_has_properties () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetAllResponse::clear_has_properties () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  PropertiesChangedSignal::PropertiesChangedSignal ()  :
    _interface (),
    _changed_properties (),
    _invalidated_properties ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  PropertiesChangedSignal::PropertiesChangedSignal (const PropertiesChangedSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _interface (),
    _changed_properties (),
    _invalidated_properties ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  PropertiesChangedSignal::PropertiesChangedSignal (const ::std::string& interface_, const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& changed_properties_, const ::std::vector< ::std::string >& invalidated_properties_)  :
    _interface (interface_),
    _changed_properties (changed_properties_),
    _invalidated_properties (invalidated_properties_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (interface_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  PropertiesChangedSignal::~PropertiesChangedSignal() {
}

inline PropertiesChangedSignal& PropertiesChangedSignal::operator = (const PropertiesChangedSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasInterface()) {
            setInterface(rhs.getInterface());
        } else {
            clearInterface();
        }
        if (rhs.hasChanged_properties()) {
            setChanged_properties(rhs.getChanged_properties());
        } else {
            clearChanged_properties();
        }
        if (rhs.hasInvalidated_properties()) {
            setInvalidated_properties(rhs.getInvalidated_properties());
        } else {
            clearInvalidated_properties();
        }
    }
    return *this;
}

inline bool PropertiesChangedSignal::operator == (const PropertiesChangedSignal& rhs) const {
    return (((!hasInterface() && !rhs.hasInterface()) || getInterface() == rhs.getInterface()) &&
        ((!hasChanged_properties() && !rhs.hasChanged_properties()) || getChanged_properties() == rhs.getChanged_properties()) &&
        ((!hasInvalidated_properties() && !rhs.hasInvalidated_properties()) || getInvalidated_properties() == rhs.getInvalidated_properties()));
}

inline bool PropertiesChangedSignal::operator != (const PropertiesChangedSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool PropertiesChangedSignal::operator < (const PropertiesChangedSignal& rhs) const {
    if (hasInterface() || rhs.hasInterface()) {
        if (getInterface() < rhs.getInterface()) return true;
        if (getInterface() > rhs.getInterface()) return false;
    }
    if (hasChanged_properties() || rhs.hasChanged_properties()) {
        if (getChanged_properties() < rhs.getChanged_properties()) return true;
        if (getChanged_properties() > rhs.getChanged_properties()) return false;
    }
    if (hasInvalidated_properties() || rhs.hasInvalidated_properties()) {
        if (getInvalidated_properties() < rhs.getInvalidated_properties()) return true;
        if (getInvalidated_properties() > rhs.getInvalidated_properties()) return false;
    }
    return false;
}

inline ::asf::core::Payload* PropertiesChangedSignal::clone() {
    return new PropertiesChangedSignal(*this);
}

inline bool PropertiesChangedSignal::operator > (const PropertiesChangedSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void PropertiesChangedSignal::clear() {
    clearInterface();
    clearChanged_properties();
    clearInvalidated_properties();
}

inline void PropertiesChangedSignal::clearInterface() {
    if (hasInterface()) {
         clear_has_interface();
        _interface.clear();
     }
}

inline bool PropertiesChangedSignal::hasInterface () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& PropertiesChangedSignal::getInterface () const {
    return _interface;
}

inline ::std::string& PropertiesChangedSignal::getInterfaceMutable () {
    set_has_interface();
    return _interface;
}

inline void PropertiesChangedSignal::setInterface (const ::std::string& interface_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (interface_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_interface();
    this->_interface = interface_;
}

inline void PropertiesChangedSignal::setInterface (const char* interface_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (interface_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_interface();
    this->_interface.assign(interface_);
}

inline void PropertiesChangedSignal::setInterface (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_interface();
    this->_interface.assign(value, size);
}

inline void PropertiesChangedSignal::clearChanged_properties() {
    if (hasChanged_properties()) {
         clear_has_changed_properties();
        _changed_properties.clear();
     }
}

inline bool PropertiesChangedSignal::hasChanged_properties () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& PropertiesChangedSignal::getChanged_properties () const {
    return _changed_properties;
}

inline ::std::map< ::std::string, ::asf::dbus::DBusVariant >& PropertiesChangedSignal::getChanged_propertiesMutable () {
    set_has_changed_properties();
    return _changed_properties;
}

inline void PropertiesChangedSignal::setChanged_properties (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& changed_properties_) {
    set_has_changed_properties();
    this->_changed_properties = changed_properties_;
}

inline void PropertiesChangedSignal::clearInvalidated_properties() {
    if (hasInvalidated_properties()) {
         clear_has_invalidated_properties();
        _invalidated_properties.clear();
     }
}

inline bool PropertiesChangedSignal::hasInvalidated_properties () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::vector< ::std::string >& PropertiesChangedSignal::getInvalidated_properties () const {
    return _invalidated_properties;
}

inline ::std::vector< ::std::string >& PropertiesChangedSignal::getInvalidated_propertiesMutable () {
    set_has_invalidated_properties();
    return _invalidated_properties;
}

inline void PropertiesChangedSignal::setInvalidated_properties (const ::std::vector< ::std::string >& invalidated_properties_) {
    set_has_invalidated_properties();
    this->_invalidated_properties = invalidated_properties_;
}

inline void PropertiesChangedSignal::set_has_interface () {
    _has_bits_[0] |= 1u << 0;
}

inline void PropertiesChangedSignal::clear_has_interface () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void PropertiesChangedSignal::set_has_changed_properties () {
    _has_bits_[0] |= 1u << 1;
}

inline void PropertiesChangedSignal::clear_has_changed_properties () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void PropertiesChangedSignal::set_has_invalidated_properties () {
    _has_bits_[0] |= 1u << 2;
}

inline void PropertiesChangedSignal::clear_has_invalidated_properties () {
    _has_bits_[0] &= ~ (1u << 2);
}

} // namespace Properties
} // namespace DBus
} // namespace freedesktop
} // namespace org
} // namespace getall

#endif // GETALL_ORG_FREEDESKTOP_DBUS_PROPERTIES_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
