/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "conndbus/org/freedesktop/DBus.h"
#include "conndbus/org/freedesktop/DBusDBus.h"
#include "conndbus/org/freedesktop/DBusJson.h"
#include "conndbus/org/freedesktop/DBusProxy.h"
#include <string>

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace conndbus {
namespace org {
namespace freedesktop {
namespace DBus {

DEFINE_CLASS_LOGGER("///org/freedesktop/DBus", DBusProxy);

class DBusProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    DBusProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< DBusProxy >& proxyShared = ::boost::static_pointer_cast< DBusProxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_NameOwnerChanged:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), NameOwnerChangedSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "NameOwnerChanged", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<NameOwnerChangedSignal> payload = ::boost::static_pointer_cast<NameOwnerChangedSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((NameOwnerChangedCallbackIF*) _callback)->onNameOwnerChangedSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_GetNameOwner:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), GetNameOwnerError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetNameOwner", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetNameOwnerError> payload = ::boost::static_pointer_cast<GetNameOwnerError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetNameOwnerCallbackIF*) _callback)->onGetNameOwnerError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetNameOwnerResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetNameOwner", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetNameOwnerResponse> payload = ::boost::static_pointer_cast<GetNameOwnerResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetNameOwnerCallbackIF*) _callback)->onGetNameOwnerResponse (proxyShared, payload);
                        return true;
                    }
                }
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_NameOwnerChanged: {
                ::boost::shared_ptr< NameOwnerChangedError > payload = ::boost::shared_ptr< NameOwnerChangedError >
                (new NameOwnerChangedError(DBUS_ERROR_NO_SERVER, "The DBus service DBus is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "NameOwnerChanged", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<DBusProxy> proxyShared = ::boost::static_pointer_cast<DBusProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((NameOwnerChangedCallbackIF*) _callback)->onNameOwnerChangedError (proxyShared,payload);
                return true;
            }
            break;
            case ID_GetNameOwner: {
                ::boost::shared_ptr< GetNameOwnerError > payload = ::boost::shared_ptr< GetNameOwnerError >
                (new GetNameOwnerError(DBUS_ERROR_NO_SERVER, "The DBus service DBus is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "GetNameOwner", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<DBusProxy> proxyShared = ::boost::static_pointer_cast<DBusProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((GetNameOwnerCallbackIF*) _callback)->onGetNameOwnerError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& DBusProxyCallback::_logger (DBusProxy::_logger);

DBusProxy::DBusProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "org.freedesktop.DBus", serviceAvailable, _logger) {
}

DBusProxy::~DBusProxy()
{
    sendDeregisterAll();
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< DBusProxy > DBusProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<DBusProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< DBusProxy > proxyNew(new DBusProxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(false);
    return proxyNew;
}

act_t DBusProxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    DBusProxyCallback* callback = new DBusProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t DBusProxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    DBusProxyCallback* callback = new DBusProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


void DBusProxy::sendDeregisterAll () const
{
    sendNameOwnerChangedDeregisterAll();
}

act_t DBusProxy::sendNameOwnerChangedRegister(NameOwnerChangedCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "NameOwnerChanged");
    act_t act = addSignalCallback(ID_NameOwnerChanged, "NameOwnerChanged", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "NameOwnerChanged", &cb, act);
    return act;
}

bool DBusProxy::sendNameOwnerChangedDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("NameOwnerChanged", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "NameOwnerChanged", act, static_cast<int>(rv));
    return rv;
}

void DBusProxy::sendNameOwnerChangedDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "NameOwnerChanged");
    _dbusProxyDelegate->deregisterSignalCallback("NameOwnerChanged", 0, _dbusDaemonProxy.get(), false);
}

act_t DBusProxy::sendGetNameOwnerRequest(GetNameOwnerCallbackIF& cb, const ::std::string& name) const {
    GetNameOwnerRequest* payload = new GetNameOwnerRequest();
    CHECK_ALLOCATION(payload);
    payload->setName(name);
    DBUS_MESSAGE_CALL(dbusMessage, "GetNameOwner", GetNameOwnerRequest, payload, true)
    act_t act = addMethodCallback(ID_GetNameOwner, dbusMessage.getUniqueSerial(), "GetNameOwner", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "GetNameOwner", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

} // namespace DBus
} // namespace freedesktop
} // namespace org
} // namespace conndbus
