/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_BOSCH_ECNR_DBUGSTUB_H
#define ORG_BOSCH_ECNR_DBUGSTUB_H

#include "asf/core/Logger.h"
#include "asf/dbus/DBusStub.h"
#include "asf/dbus/DBusVariant.h"
#include "boost/shared_ptr.hpp"
#include "org/bosch/ecnr/dbug.h"

namespace org {
namespace bosch {
namespace ecnr {
namespace dbug {

class DbugStubDelegate;

class DbugStub : public ::asf::dbus::DBusStub
{
public:

    /**
     * Create an instance of the DbugStub
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     */
    DbugStub (const std::string& portName);

    /**
     * Create an instance of the DbugStub
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     * @param objectPath the dbus object path, see
     * http://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-marshaling-object-path
     */
    DbugStub (const std::string& portName, const std::string& objectPath);

    virtual ~DbugStub();

    // method 'ecnrStartDebugData'

    /**
     * The method onEcnrStartDebugData() is called by ASF when a client
     * invokes the method 'ecnrStartDebugData'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendEcnrStartDebugData() or sendEcnrStartDebugDataError() method. Do
     * not invoke this method on your own.
     *
     * <b>Documentation of 'ecnrStartDebugData'</b>:
     *
     * If the meaning of "ecnrStartDebugData" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onEcnrStartDebugDataRequest (const ::boost::shared_ptr< EcnrStartDebugDataRequest >& request) = 0;

    /**
     * The method sendEcnrStartDebugDataResponse() sends a response of a
     * previous method invocation of 'ecnrStartDebugData' back to the client.
     *
     * <b>Documentation of 'ecnrStartDebugData'</b>:
     *
     * If the meaning of "ecnrStartDebugData" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onEcnrStartDebugData(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendEcnrStartDebugDataResponse (act_t act = 0);

    /**
     * The method sendEcnrStartDebugDataError() sends an error response of a
     * previous method invocation of 'ecnrStartDebugData' back to the client.
     *
     * <b>Documentation of 'ecnrStartDebugData'</b>:
     *
     * If the meaning of "ecnrStartDebugData" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onEcnrStartDebugData().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendEcnrStartDebugDataError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'ecnrEndDebugData'

    /**
     * The method onEcnrEndDebugData() is called by ASF when a client invokes
     * the method 'ecnrEndDebugData'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendEcnrEndDebugData() or sendEcnrEndDebugDataError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'ecnrEndDebugData'</b>:
     *
     * If the meaning of "ecnrEndDebugData" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onEcnrEndDebugDataRequest (const ::boost::shared_ptr< EcnrEndDebugDataRequest >& request) = 0;

    /**
     * The method sendEcnrEndDebugDataResponse() sends a response of a
     * previous method invocation of 'ecnrEndDebugData' back to the client.
     *
     * <b>Documentation of 'ecnrEndDebugData'</b>:
     *
     * If the meaning of "ecnrEndDebugData" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onEcnrEndDebugData(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendEcnrEndDebugDataResponse (act_t act = 0);

    /**
     * The method sendEcnrEndDebugDataError() sends an error response of a
     * previous method invocation of 'ecnrEndDebugData' back to the client.
     *
     * <b>Documentation of 'ecnrEndDebugData'</b>:
     *
     * If the meaning of "ecnrEndDebugData" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onEcnrEndDebugData(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendEcnrEndDebugDataError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

private:
    void onGetAll(std::map<std::basic_string<char>, ::asf::dbus::DBusVariant>&) const;

    friend class DbugStubDelegate;

    DECLARE_CLASS_LOGGER();
};

} // namespace dbug
} // namespace ecnr
} // namespace bosch
} // namespace org

#endif // ORG_BOSCH_ECNR_DBUGSTUB_H
