/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "org/bosch/ecnr/dbug.h"
#include "org/bosch/ecnr/dbugDBus.h"
#include "org/bosch/ecnr/dbugJson.h"
#include "org/bosch/ecnr/dbugStub.h"

#include "asf/dbus/DBusMessage.h"

namespace org {
namespace bosch {
namespace ecnr {
namespace dbug {

DEFINE_CLASS_LOGGER("///org/bosch/ecnr/dbug", DbugStub);

static ::asf::dbus::DBusUtils::stringEntry methodsTable[] = {
    { 16, "ecnrEndDebugData", 1 },
    { 18, "ecnrStartDebugData", 0 },
};


class DbugStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    DbugStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    DbugStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    DbugStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "org.bosch.ecnr.dbug"),
          _logger(logger) {}

    virtual ~DbugStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void DbugStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    unsigned int methodIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (message.getMemberName().c_str(), message.getMemberName().length(), methodsTable, 2, methodIndex)) {
        switch (methodIndex) {
        case 0: {

            // method 'ecnrStartDebugData'

            LOG_DEBUG_STUB("process method '%s'", "ecnrStartDebugData");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EcnrStartDebugDataRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "EcnrStartDebugData", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< EcnrStartDebugDataRequest > payload = ::boost::static_pointer_cast<EcnrStartDebugDataRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<DbugStub*>(getStub())->onEcnrStartDebugDataRequest(payload);
            return;
        }
        case 1: {

            // method 'ecnrEndDebugData'

            LOG_DEBUG_STUB("process method '%s'", "ecnrEndDebugData");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EcnrEndDebugDataRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "EcnrEndDebugData", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< EcnrEndDebugDataRequest > payload = ::boost::static_pointer_cast<EcnrEndDebugDataRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<DbugStub*>(getStub())->onEcnrEndDebugDataRequest(payload);
            return;
        }
        default:
            break;
        }
    }
    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* DbugStubDelegate::introspect() const {
    return     "<interface name=\"org.bosch.ecnr.dbug\">\n"
            "      <method name=\"ecnrStartDebugData\">\n"
            "        <arg direction=\"in\" name=\"ecnrDebugMode\" type=\"y\"/>\n"
            "      </method>\n"
            "      <method name=\"ecnrEndDebugData\">\n"
            "        <arg direction=\"in\" name=\"ecnrDebugMode\" type=\"y\"/>\n"
            "      </method>\n"
            "</interface>\n";
}

void DbugStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<DbugStub*>(getStub()))->onGetAll (properties);
}

void DbugStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    ((void)value);  // to get rid of unused variable warning
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void DbugStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

DbugStub::DbugStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new DbugStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

DbugStub::DbugStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new DbugStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

DbugStub::~DbugStub() {
    delete _stubDelegate;
}

void  DbugStub::sendEcnrStartDebugDataResponse (act_t act) {
    EcnrStartDebugDataResponse* payload = new EcnrStartDebugDataResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "ecnrStartDebugData", EcnrStartDebugDataResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "EcnrStartDebugData", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  DbugStub::sendEcnrStartDebugDataError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    EcnrStartDebugDataError* payload = new EcnrStartDebugDataError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "ecnrStartDebugData", EcnrStartDebugDataError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "EcnrStartDebugData", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  DbugStub::sendEcnrEndDebugDataResponse (act_t act) {
    EcnrEndDebugDataResponse* payload = new EcnrEndDebugDataResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "ecnrEndDebugData", EcnrEndDebugDataResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "EcnrEndDebugData", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  DbugStub::sendEcnrEndDebugDataError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    EcnrEndDebugDataError* payload = new EcnrEndDebugDataError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "ecnrEndDebugData", EcnrEndDebugDataError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "EcnrEndDebugData", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void DbugStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {
    ((void)properties);  // to get rid of unused variable warning
}

} // namespace dbug
} // namespace ecnr
} // namespace bosch
} // namespace org
