/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_BOSCH_ECNR_ALSASTUB_H
#define ORG_BOSCH_ECNR_ALSASTUB_H

#include "asf/core/Logger.h"
#include "asf/dbus/DBusStub.h"
#include "asf/dbus/DBusVariant.h"
#include "boost/shared_ptr.hpp"
#include "org/bosch/ecnr/alsa.h"

namespace org {
namespace bosch {
namespace ecnr {
namespace alsa {

class AlsaStubDelegate;

class AlsaStub : public ::asf::dbus::DBusStub
{
public:

    /**
     * Create an instance of the AlsaStub
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     */
    AlsaStub (const std::string& portName);

    /**
     * Create an instance of the AlsaStub
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     * @param objectPath the dbus object path, see
     * http://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-marshaling-object-path
     */
    AlsaStub (const std::string& portName, const std::string& objectPath);

    virtual ~AlsaStub();

    // method 'ecnrAlsaSetDevice'

    /**
     * The method onEcnrAlsaSetDevice() is called by ASF when a client invokes
     * the method 'ecnrAlsaSetDevice'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendEcnrAlsaSetDevice() or sendEcnrAlsaSetDeviceError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'ecnrAlsaSetDevice'</b>:
     *
     * If the meaning of "ecnrAlsaSetDevice" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onEcnrAlsaSetDeviceRequest (const ::boost::shared_ptr< EcnrAlsaSetDeviceRequest >& request) = 0;

    /**
     * The method sendEcnrAlsaSetDeviceResponse() sends a response of a
     * previous method invocation of 'ecnrAlsaSetDevice' back to the client.
     *
     * <b>Documentation of 'ecnrAlsaSetDevice'</b>:
     *
     * If the meaning of "ecnrAlsaSetDevice" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onEcnrAlsaSetDevice(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendEcnrAlsaSetDeviceResponse (act_t act = 0);

    /**
     * The method sendEcnrAlsaSetDeviceError() sends an error response of a
     * previous method invocation of 'ecnrAlsaSetDevice' back to the client.
     *
     * <b>Documentation of 'ecnrAlsaSetDevice'</b>:
     *
     * If the meaning of "ecnrAlsaSetDevice" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onEcnrAlsaSetDevice().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendEcnrAlsaSetDeviceError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'ecnrAlsaSetThreadPriority'

    /**
     * The method onEcnrAlsaSetThreadPriority() is called by ASF when a client
     * invokes the method 'ecnrAlsaSetThreadPriority'. A subclass has to
     * implement this method and send back a response to the client either
     * with the sendEcnrAlsaSetThreadPriority() or
     * sendEcnrAlsaSetThreadPriorityError() method. Do not invoke this method
     * on your own.
     *
     * <b>Documentation of 'ecnrAlsaSetThreadPriority'</b>:
     *
     * If the meaning of "ecnrAlsaSetThreadPriority" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onEcnrAlsaSetThreadPriorityRequest (const ::boost::shared_ptr< EcnrAlsaSetThreadPriorityRequest >& request) = 0;

    /**
     * The method sendEcnrAlsaSetThreadPriorityResponse() sends a response of
     * a previous method invocation of 'ecnrAlsaSetThreadPriority' back to the
     * client.
     *
     * <b>Documentation of 'ecnrAlsaSetThreadPriority'</b>:
     *
     * If the meaning of "ecnrAlsaSetThreadPriority" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onEcnrAlsaSetThreadPriority(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendEcnrAlsaSetThreadPriorityResponse (act_t act = 0);

    /**
     * The method sendEcnrAlsaSetThreadPriorityError() sends an error response
     * of a previous method invocation of 'ecnrAlsaSetThreadPriority' back to
     * the client.
     *
     * <b>Documentation of 'ecnrAlsaSetThreadPriority'</b>:
     *
     * If the meaning of "ecnrAlsaSetThreadPriority" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onEcnrAlsaSetThreadPriority(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendEcnrAlsaSetThreadPriorityError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'ecnrAlsaSetWideBand'

    /**
     * The method onEcnrAlsaSetWideBand() is called by ASF when a client
     * invokes the method 'ecnrAlsaSetWideBand'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendEcnrAlsaSetWideBand() or sendEcnrAlsaSetWideBandError() method. Do
     * not invoke this method on your own.
     *
     * <b>Documentation of 'ecnrAlsaSetWideBand'</b>:
     *
     * If the meaning of "ecnrAlsaSetWideBand" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onEcnrAlsaSetWideBandRequest (const ::boost::shared_ptr< EcnrAlsaSetWideBandRequest >& request) = 0;

    /**
     * The method sendEcnrAlsaSetWideBandResponse() sends a response of a
     * previous method invocation of 'ecnrAlsaSetWideBand' back to the client.
     *
     * <b>Documentation of 'ecnrAlsaSetWideBand'</b>:
     *
     * If the meaning of "ecnrAlsaSetWideBand" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onEcnrAlsaSetWideBand(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendEcnrAlsaSetWideBandResponse (act_t act = 0);

    /**
     * The method sendEcnrAlsaSetWideBandError() sends an error response of a
     * previous method invocation of 'ecnrAlsaSetWideBand' back to the client.
     *
     * <b>Documentation of 'ecnrAlsaSetWideBand'</b>:
     *
     * If the meaning of "ecnrAlsaSetWideBand" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onEcnrAlsaSetWideBand().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendEcnrAlsaSetWideBandError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'ecnrAlsaSetDeviceProperties'

    /**
     * The method onEcnrAlsaSetDeviceProperties() is called by ASF when a
     * client invokes the method 'ecnrAlsaSetDeviceProperties'. A subclass has
     * to implement this method and send back a response to the client either
     * with the sendEcnrAlsaSetDeviceProperties() or
     * sendEcnrAlsaSetDevicePropertiesError() method. Do not invoke this
     * method on your own.
     *
     * <b>Documentation of 'ecnrAlsaSetDeviceProperties'</b>:
     *
     * If the meaning of "ecnrAlsaSetDeviceProperties" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onEcnrAlsaSetDevicePropertiesRequest (const ::boost::shared_ptr< EcnrAlsaSetDevicePropertiesRequest >& request) = 0;

    /**
     * The method sendEcnrAlsaSetDevicePropertiesResponse() sends a response
     * of a previous method invocation of 'ecnrAlsaSetDeviceProperties' back
     * to the client.
     *
     * <b>Documentation of 'ecnrAlsaSetDeviceProperties'</b>:
     *
     * If the meaning of "ecnrAlsaSetDeviceProperties" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onEcnrAlsaSetDeviceProperties(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendEcnrAlsaSetDevicePropertiesResponse (act_t act = 0);

    /**
     * The method sendEcnrAlsaSetDevicePropertiesError() sends an error
     * response of a previous method invocation of
     * 'ecnrAlsaSetDeviceProperties' back to the client.
     *
     * <b>Documentation of 'ecnrAlsaSetDeviceProperties'</b>:
     *
     * If the meaning of "ecnrAlsaSetDeviceProperties" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onEcnrAlsaSetDeviceProperties(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendEcnrAlsaSetDevicePropertiesError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

private:
    void onGetAll(std::map<std::basic_string<char>, ::asf::dbus::DBusVariant>&) const;

    friend class AlsaStubDelegate;

    DECLARE_CLASS_LOGGER();
};

} // namespace alsa
} // namespace ecnr
} // namespace bosch
} // namespace org

#endif // ORG_BOSCH_ECNR_ALSASTUB_H
