/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef NET_CONNMAN_TECHNOLOGYPROXY_H
#define NET_CONNMAN_TECHNOLOGYPROXY_H

#include "asf/core/Logger.h"
#include "asf/core/nullable.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusProxy.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DBusVariant.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "net/connman/Technology.h"
#include <dbus/dbus.h>
#include <string>

namespace net {
namespace connman {
namespace Technology {

class TechnologyProxy;

class ConnectedCallbackIF {
public:
    virtual ~ConnectedCallbackIF() {}

    virtual void onConnectedError(const ::boost::shared_ptr< TechnologyProxy >& proxy, const ::boost::shared_ptr< ConnectedError >& error) = 0;

    virtual void onConnectedUpdate(const ::boost::shared_ptr< TechnologyProxy >& proxy, const ::boost::shared_ptr< ConnectedUpdate >& update) = 0;
};

class GetPropertiesCallbackIF {
public:
    virtual ~GetPropertiesCallbackIF() {}

    virtual void onGetPropertiesError(const ::boost::shared_ptr< TechnologyProxy >& proxy, const ::boost::shared_ptr< GetPropertiesError >& error) = 0;

    virtual void onGetPropertiesResponse(const ::boost::shared_ptr< TechnologyProxy >& proxy, const ::boost::shared_ptr< GetPropertiesResponse >& response) = 0;
};

class NameCallbackIF {
public:
    virtual ~NameCallbackIF() {}

    virtual void onNameError(const ::boost::shared_ptr< TechnologyProxy >& proxy, const ::boost::shared_ptr< NameError >& error) = 0;

    virtual void onNameUpdate(const ::boost::shared_ptr< TechnologyProxy >& proxy, const ::boost::shared_ptr< NameUpdate >& update) = 0;
};

class PoweredCallbackIF {
public:
    virtual ~PoweredCallbackIF() {}

    virtual void onPoweredError(const ::boost::shared_ptr< TechnologyProxy >& proxy, const ::boost::shared_ptr< PoweredError >& error) = 0;

    virtual void onPoweredUpdate(const ::boost::shared_ptr< TechnologyProxy >& proxy, const ::boost::shared_ptr< PoweredUpdate >& update) = 0;
};

class PropertyChangedCallbackIF {
public:
    virtual ~PropertyChangedCallbackIF() {}

    virtual void onPropertyChangedError(const ::boost::shared_ptr< TechnologyProxy >& proxy, const ::boost::shared_ptr< PropertyChangedError >& error) = 0;

    virtual void onPropertyChangedSignal(const ::boost::shared_ptr< TechnologyProxy >& proxy, const ::boost::shared_ptr< PropertyChangedSignal >& signal) = 0;
};

class ScanCallbackIF {
public:
    virtual ~ScanCallbackIF() {}

    virtual void onScanError(const ::boost::shared_ptr< TechnologyProxy >& proxy, const ::boost::shared_ptr< ScanError >& error) = 0;

    virtual void onScanResponse(const ::boost::shared_ptr< TechnologyProxy >& proxy, const ::boost::shared_ptr< ScanResponse >& response) = 0;
};

class SetPropertyCallbackIF {
public:
    virtual ~SetPropertyCallbackIF() {}

    virtual void onSetPropertyError(const ::boost::shared_ptr< TechnologyProxy >& proxy, const ::boost::shared_ptr< SetPropertyError >& error) = 0;

    virtual void onSetPropertyResponse(const ::boost::shared_ptr< TechnologyProxy >& proxy, const ::boost::shared_ptr< SetPropertyResponse >& response) = 0;
};

class TetheringCallbackIF {
public:
    virtual ~TetheringCallbackIF() {}

    virtual void onTetheringError(const ::boost::shared_ptr< TechnologyProxy >& proxy, const ::boost::shared_ptr< TetheringError >& error) = 0;

    virtual void onTetheringUpdate(const ::boost::shared_ptr< TechnologyProxy >& proxy, const ::boost::shared_ptr< TetheringUpdate >& update) = 0;
};

class TypeCallbackIF {
public:
    virtual ~TypeCallbackIF() {}

    virtual void onTypeError(const ::boost::shared_ptr< TechnologyProxy >& proxy, const ::boost::shared_ptr< TypeError >& error) = 0;

    virtual void onTypeUpdate(const ::boost::shared_ptr< TechnologyProxy >& proxy, const ::boost::shared_ptr< TypeUpdate >& update) = 0;
};


/**
 * TechnologyProxy is the client side representation of the D-Bus service
 * interface 'net.connman.Technology' (specified in file
 * connman_technology.xml).
 *
 * If the meaning of "net.connman.Technology" isn't clear, then there should be a description here.
 */
class TechnologyProxy : public ::asf::dbus::DBusProxy
{
public:
    /**
     * Create a new instance of TechnologyProxy.
     */
    static ::boost::shared_ptr< TechnologyProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Create a new instance of TechnologyProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @deprecated use the createProxy() method with the parameter
     * ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector instead.
     */
    static ::boost::shared_ptr< TechnologyProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        ::DBusBusType busType,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector connectorOptions;
        connectorOptions.setBusType(::asf::dbus::DBusUtils::toOptions(busType).getBusType());
        return createProxy(portName, busName, objectPath, connectorOptions, serviceAvailable);
    }

    /**
     * Create a new instance of TechnologyProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     */
    static ::boost::shared_ptr< TechnologyProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        const ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector& connectorOptions,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< TechnologyProxy > proxyNew(new TechnologyProxy(portName, serviceAvailable));
        ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew, busName, objectPath, connectorOptions);
        proxyNew->createHelperProxies(true);
        return proxyNew;
    }

    virtual ~TechnologyProxy ();


    // Signal 'PropertyChanged'

    /**
     * Notify on the signal 'PropertyChanged'. This method registers for
     * signal changes by D-Bus service.
     *
     * <b>Documentation of 'PropertyChanged'</b>:
     *
     * If the meaning of "PropertyChanged" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendPropertyChangedRegister(PropertyChangedCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'PropertyChanged'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'PropertyChanged'</b>:
     *
     * If the meaning of "PropertyChanged" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendPropertyChangedRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendPropertyChangedDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'PropertyChanged'.
     */
    void sendPropertyChangedDeregisterAll () const;


    // Property 'Powered'

    /**
     * Notify on the property 'Powered'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'Powered'</b>:
     *
     * If the meaning of "Powered" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendPoweredRegister(PoweredCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'Powered'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'Powered'</b>:
     *
     * If the meaning of "Powered" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendPoweredRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendPoweredDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'Powered'.
     */
    void sendPoweredDeregisterAll() const;

    /**
     * Request the value of the property 'Powered' from the D-Bus server. This
     * method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'Powered'</b>:
     *
     * If the meaning of "Powered" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendPoweredGet(PoweredCallbackIF& cb);

    /**
     * Set the value of the property 'Powered'. This method sends a Set
     * message to the D-Bus server.
     *
     * @deprecated use the sendPoweredSet(PoweredCallbackIF& cb, bool powered)
     * method instead.
     *
     * <b>Documentation of 'Powered'</b>:
     *
     * If the meaning of "Powered" isn't clear, then there should be a description here.
     */
    void sendPoweredSet(bool powered);

    /**
     * Set the value of the property 'Powered'. This method sends a Set
     * message to the D-Bus server.
     *
     * <b>Documentation of 'Powered'</b>:
     *
     * If the meaning of "Powered" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Set message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendPoweredSet(PoweredCallbackIF& cb, bool powered);

    /**
     * Returns the current value of the property 'Powered' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasPowered()
     * returns true.
     *
     * @return the previously received value of the property 'Powered'.
     */
    bool getPowered() const;

    /**
     * Determines whether a status message for the property 'Powered' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasPowered() const;

    // Property 'Connected'

    /**
     * Notify on the property 'Connected'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'Connected'</b>:
     *
     * If the meaning of "Connected" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendConnectedRegister(ConnectedCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'Connected'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'Connected'</b>:
     *
     * If the meaning of "Connected" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendConnectedRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendConnectedDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'Connected'.
     */
    void sendConnectedDeregisterAll() const;

    /**
     * Request the value of the property 'Connected' from the D-Bus server.
     * This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'Connected'</b>:
     *
     * If the meaning of "Connected" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendConnectedGet(ConnectedCallbackIF& cb);


    /**
     * Returns the current value of the property 'Connected' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasConnected()
     * returns true.
     *
     * @return the previously received value of the property 'Connected'.
     */
    bool getConnected() const;

    /**
     * Determines whether a status message for the property 'Connected' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasConnected() const;

    // Property 'Name'

    /**
     * Notify on the property 'Name'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'Name'</b>:
     *
     * If the meaning of "Name" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendNameRegister(NameCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'Name'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'Name'</b>:
     *
     * If the meaning of "Name" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendNameRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendNameDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'Name'.
     */
    void sendNameDeregisterAll() const;

    /**
     * Request the value of the property 'Name' from the D-Bus server. This
     * method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'Name'</b>:
     *
     * If the meaning of "Name" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendNameGet(NameCallbackIF& cb);


    /**
     * Returns the current value of the property 'Name' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasName()
     * returns true.
     *
     * @return the previously received value of the property 'Name'.
     */
    const ::std::string& getName() const;

    /**
     * Determines whether a status message for the property 'Name' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasName() const;

    // Property 'Type'

    /**
     * Notify on the property 'Type'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'Type'</b>:
     *
     * If the meaning of "Type" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendTypeRegister(TypeCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'Type'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'Type'</b>:
     *
     * If the meaning of "Type" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendTypeRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendTypeDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'Type'.
     */
    void sendTypeDeregisterAll() const;

    /**
     * Request the value of the property 'Type' from the D-Bus server. This
     * method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'Type'</b>:
     *
     * If the meaning of "Type" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendTypeGet(TypeCallbackIF& cb);


    /**
     * Returns the current value of the property 'Type' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasType()
     * returns true.
     *
     * @return the previously received value of the property 'Type'.
     */
    const ::std::string& getType() const;

    /**
     * Determines whether a status message for the property 'Type' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasType() const;

    // Property 'Tethering'

    /**
     * Notify on the property 'Tethering'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'Tethering'</b>:
     *
     * If the meaning of "Tethering" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendTetheringRegister(TetheringCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'Tethering'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'Tethering'</b>:
     *
     * If the meaning of "Tethering" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendTetheringRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendTetheringDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'Tethering'.
     */
    void sendTetheringDeregisterAll() const;

    /**
     * Request the value of the property 'Tethering' from the D-Bus server.
     * This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'Tethering'</b>:
     *
     * If the meaning of "Tethering" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendTetheringGet(TetheringCallbackIF& cb);

    /**
     * Set the value of the property 'Tethering'. This method sends a Set
     * message to the D-Bus server.
     *
     * @deprecated use the sendTetheringSet(TetheringCallbackIF& cb, bool
     * tethering) method instead.
     *
     * <b>Documentation of 'Tethering'</b>:
     *
     * If the meaning of "Tethering" isn't clear, then there should be a description here.
     */
    void sendTetheringSet(bool tethering);

    /**
     * Set the value of the property 'Tethering'. This method sends a Set
     * message to the D-Bus server.
     *
     * <b>Documentation of 'Tethering'</b>:
     *
     * If the meaning of "Tethering" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Set message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendTetheringSet(TetheringCallbackIF& cb, bool tethering);

    /**
     * Returns the current value of the property 'Tethering' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasTethering()
     * returns true.
     *
     * @return the previously received value of the property 'Tethering'.
     */
    bool getTethering() const;

    /**
     * Determines whether a status message for the property 'Tethering' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasTethering() const;


    // Method 'GetProperties'

    /**
     * Call the method 'GetProperties'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'GetProperties'</b>:
     *
     * If the meaning of "GetProperties" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetPropertiesRequest(GetPropertiesCallbackIF& cb) const;

    // Method 'SetProperty'

    /**
     * Call the method 'SetProperty'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'SetProperty'</b>:
     *
     * If the meaning of "SetProperty" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param name If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param value If the meaning of "value" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetPropertyRequest(SetPropertyCallbackIF& cb, const ::std::string& name, const ::asf::dbus::DBusVariant& value) const;

    // Method 'Scan'

    /**
     * Call the method 'Scan'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'Scan'</b>:
     *
     * If the meaning of "Scan" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendScanRequest(ScanCallbackIF& cb) const;

    /**
     * Release all property and signal notifications.
     */
    void sendDeregisterAll () const;

private:

    TechnologyProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    act_t addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const;

    act_t addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const;

    virtual void clearAllProperties ();

    // Property 'Powered'

    ::asf::core::nullable< PoweredUpdate > _powered;

    // Property 'Connected'

    ::asf::core::nullable< ConnectedUpdate > _connected;

    // Property 'Name'

    ::asf::core::nullable< NameUpdate > _name;

    // Property 'Type'

    ::asf::core::nullable< TypeUpdate > _type;

    // Property 'Tethering'

    ::asf::core::nullable< TetheringUpdate > _tethering;

    DECLARE_CLASS_LOGGER();

    friend class TechnologyProxyCallback;
};

} // namespace Technology
} // namespace connman
} // namespace net

#endif // NET_CONNMAN_TECHNOLOGYPROXY_H
