#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef NET_CONNMAN_TECHNOLOGY_H
#define NET_CONNMAN_TECHNOLOGY_H

#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "asf/dbus/DBusTypes.h"
#include "asf/dbus/DBusVariant.h"
#include <cstddef>
#include <cstring>
#include <map>
#include <string>

/**
 * If the meaning of "Technology" isn't clear, then there should be a description here.
 */

namespace net {
namespace connman {
namespace Technology {

// method IDs
static const uint16 ID_GetProperties = 0;
static const uint16 ID_SetProperty = 1;
static const uint16 ID_Scan = 2;

// signal IDs
static const uint16 ID_PropertyChanged = 3;

// property IDs
static const uint16 ID_Powered = 4;
static const uint16 ID_Connected = 5;
static const uint16 ID_Name = 6;
static const uint16 ID_Type = 7;
static const uint16 ID_Tethering = 8;

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class GetPropertiesResponse;

class SetPropertyRequest;

class PoweredUpdate;

class PoweredRegister;

class ConnectedUpdate;

class ConnectedRegister;

class NameUpdate;

class NameRegister;

class TypeUpdate;

class TypeRegister;

class TetheringUpdate;

class TetheringRegister;

class PropertyChangedSignal;

// type definitions
/**
 * If the meaning of "GetPropertiesRequest" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage GetPropertiesRequest;

/**
 * If the meaning of "GetPropertiesError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError GetPropertiesError;

/**
 * If the meaning of "SetPropertyResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage SetPropertyResponse;

/**
 * If the meaning of "SetPropertyError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SetPropertyError;

/**
 * If the meaning of "ScanRequest" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage ScanRequest;

/**
 * If the meaning of "ScanResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage ScanResponse;

/**
 * If the meaning of "ScanError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ScanError;

/**
 * If the meaning of "PoweredSet" isn't clear, then there should be a description here.
 */
typedef PoweredUpdate PoweredSet;

/**
 * If the meaning of "PoweredGet" isn't clear, then there should be a description here.
 */
typedef PoweredUpdate PoweredGet;

/**
 * If the meaning of "PoweredError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError PoweredError;

/**
 * If the meaning of "ConnectedSet" isn't clear, then there should be a description here.
 */
typedef ConnectedUpdate ConnectedSet;

/**
 * If the meaning of "ConnectedGet" isn't clear, then there should be a description here.
 */
typedef ConnectedUpdate ConnectedGet;

/**
 * If the meaning of "ConnectedError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ConnectedError;

/**
 * If the meaning of "NameSet" isn't clear, then there should be a description here.
 */
typedef NameUpdate NameSet;

/**
 * If the meaning of "NameGet" isn't clear, then there should be a description here.
 */
typedef NameUpdate NameGet;

/**
 * If the meaning of "NameError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError NameError;

/**
 * If the meaning of "TypeSet" isn't clear, then there should be a description here.
 */
typedef TypeUpdate TypeSet;

/**
 * If the meaning of "TypeGet" isn't clear, then there should be a description here.
 */
typedef TypeUpdate TypeGet;

/**
 * If the meaning of "TypeError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError TypeError;

/**
 * If the meaning of "TetheringSet" isn't clear, then there should be a description here.
 */
typedef TetheringUpdate TetheringSet;

/**
 * If the meaning of "TetheringGet" isn't clear, then there should be a description here.
 */
typedef TetheringUpdate TetheringGet;

/**
 * If the meaning of "TetheringError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError TetheringError;

/**
 * If the meaning of "PropertyChangedError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError PropertyChangedError;


/**
 * If the meaning of "GetPropertiesResponse" isn't clear, then there should be a description here.
 */
class GetPropertiesResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetPropertiesResponse ();

    /**
     * Copy constructor
     */
    inline  GetPropertiesResponse (const GetPropertiesResponse &rhs);

    /**
     * All fields constructor
     */
    inline  GetPropertiesResponse (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties_);

    /**
     * Destructor
     */
    inline virtual  ~GetPropertiesResponse();

    /**
     * Assignment operator
     */
    inline GetPropertiesResponse& operator = (const GetPropertiesResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetPropertiesResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetPropertiesResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetPropertiesResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetPropertiesResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "properties"

    static const int kProperties = 0;

    /**
     * Clears the field "properties".
     *
     * The field will be set to its default value. The hasProperties()
     * method will return false.
     */
    inline void clearProperties();

    /**
     * Checks whether the field "properties" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setProperties()). Otherwise it will return false.
     */
    inline bool hasProperties () const;

    /**
     * Returns the value of the member "properties".
     *
     * If the meaning of "properties" isn't clear, then there should be a description here.
     *
     * @return The value of the field "properties"
     */
    inline const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getProperties () const;

    /**
     * Retrieves the value of the field "properties" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "properties".
     */
    inline ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getPropertiesMutable ();

    /**
     * Sets the value of the member "properties".
     *
     * If the meaning of "properties" isn't clear, then there should be a description here.
     *
     * @param properties The value which will be set
     */
    inline void setProperties (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties_);

    static const GetPropertiesResponse &getDefaultInstance();

private:

    static const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getStringTo__asf__dbus__DBusVariantMap_DefaultInstance ();

    inline void set_has_properties ();

    inline void clear_has_properties ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::map< ::std::string, ::asf::dbus::DBusVariant > _properties;

};

/**
 * If the meaning of "SetPropertyRequest" isn't clear, then there should be a description here.
 */
class SetPropertyRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetPropertyRequest ();

    /**
     * Copy constructor
     */
    inline  SetPropertyRequest (const SetPropertyRequest &rhs);

    /**
     * All fields constructor
     */
    inline  SetPropertyRequest (const ::std::string& name_, const ::asf::dbus::DBusVariant& value_);

    /**
     * Destructor
     */
    inline virtual  ~SetPropertyRequest();

    /**
     * Assignment operator
     */
    inline SetPropertyRequest& operator = (const SetPropertyRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetPropertyRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetPropertyRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetPropertyRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetPropertyRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "name"

    static const int kName = 0;

    /**
     * Clears the field "name".
     *
     * The field will be set to its default value. The hasName()
     * method will return false.
     */
    inline void clearName();

    /**
     * Checks whether the field "name" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setName()). Otherwise it will return false.
     */
    inline bool hasName () const;

    /**
     * Returns the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @return The value of the field "name"
     */
    inline const ::std::string& getName () const;

    /**
     * Retrieves the value of the field "name" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "name".
     */
    inline ::std::string& getNameMutable ();

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const ::std::string& name_);

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const char* name_);

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const char* value, size_t size);

    // API of field "value"

    static const int kValue = 1;

    /**
     * Clears the field "value".
     *
     * The field will be set to its default value. The hasValue()
     * method will return false.
     */
    inline void clearValue();

    /**
     * Checks whether the field "value" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setValue()). Otherwise it will return false.
     */
    inline bool hasValue () const;

    /**
     * Returns the value of the member "value".
     *
     * If the meaning of "value" isn't clear, then there should be a description here.
     *
     * @return The value of the field "value"
     */
    inline const ::asf::dbus::DBusVariant& getValue () const;

    /**
     * Retrieves the value of the field "value" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "value".
     */
    inline ::asf::dbus::DBusVariant& getValueMutable ();

    /**
     * Sets the value of the member "value".
     *
     * If the meaning of "value" isn't clear, then there should be a description here.
     *
     * @param value The value which will be set
     */
    inline void setValue (const ::asf::dbus::DBusVariant& value_);

    static const SetPropertyRequest &getDefaultInstance();

private:

    inline void set_has_name ();

    inline void clear_has_name ();

    inline void set_has_value ();

    inline void clear_has_value ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _name;

    ::asf::dbus::DBusVariant _value;

};

/**
 * If the meaning of "PoweredUpdate" isn't clear, then there should be a description here.
 */
class PoweredUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PoweredUpdate ();

    /**
     * Copy constructor
     */
    inline  PoweredUpdate (const PoweredUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  PoweredUpdate (bool Powered_);

    /**
     * Destructor
     */
    inline virtual  ~PoweredUpdate();

    /**
     * Assignment operator
     */
    inline PoweredUpdate& operator = (const PoweredUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PoweredUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PoweredUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PoweredUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PoweredUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Powered"

    static const int kPowered = 0;

    /**
     * Clears the field "Powered".
     *
     * The field will be set to its default value. The hasPowered()
     * method will return false.
     */
    inline void clearPowered();

    /**
     * Checks whether the field "Powered" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPowered()). Otherwise it will return false.
     */
    inline bool hasPowered () const;

    /**
     * Returns the value of the member "Powered".
     *
     * If the meaning of "Powered" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Powered"
     */
    inline bool getPowered () const;

    /**
     * Sets the value of the member "Powered".
     *
     * If the meaning of "Powered" isn't clear, then there should be a description here.
     *
     * @param Powered The value which will be set
     */
    inline void setPowered (bool Powered_);

    static const PoweredUpdate &getDefaultInstance();

private:

    inline void set_has_Powered ();

    inline void clear_has_Powered ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _Powered;

};

/**
 * If the meaning of "PoweredRegister" isn't clear, then there should be a description here.
 */
class PoweredRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PoweredRegister ();

    /**
     * Copy constructor
     */
    inline  PoweredRegister (const PoweredRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~PoweredRegister();

    /**
     * Assignment operator
     */
    inline PoweredRegister& operator = (const PoweredRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PoweredRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PoweredRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PoweredRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PoweredRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const PoweredRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "ConnectedUpdate" isn't clear, then there should be a description here.
 */
class ConnectedUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ConnectedUpdate ();

    /**
     * Copy constructor
     */
    inline  ConnectedUpdate (const ConnectedUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  ConnectedUpdate (bool Connected_);

    /**
     * Destructor
     */
    inline virtual  ~ConnectedUpdate();

    /**
     * Assignment operator
     */
    inline ConnectedUpdate& operator = (const ConnectedUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ConnectedUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ConnectedUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ConnectedUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ConnectedUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Connected"

    static const int kConnected = 0;

    /**
     * Clears the field "Connected".
     *
     * The field will be set to its default value. The hasConnected()
     * method will return false.
     */
    inline void clearConnected();

    /**
     * Checks whether the field "Connected" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setConnected()). Otherwise it will return false.
     */
    inline bool hasConnected () const;

    /**
     * Returns the value of the member "Connected".
     *
     * If the meaning of "Connected" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Connected"
     */
    inline bool getConnected () const;

    /**
     * Sets the value of the member "Connected".
     *
     * If the meaning of "Connected" isn't clear, then there should be a description here.
     *
     * @param Connected The value which will be set
     */
    inline void setConnected (bool Connected_);

    static const ConnectedUpdate &getDefaultInstance();

private:

    inline void set_has_Connected ();

    inline void clear_has_Connected ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _Connected;

};

/**
 * If the meaning of "ConnectedRegister" isn't clear, then there should be a description here.
 */
class ConnectedRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ConnectedRegister ();

    /**
     * Copy constructor
     */
    inline  ConnectedRegister (const ConnectedRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~ConnectedRegister();

    /**
     * Assignment operator
     */
    inline ConnectedRegister& operator = (const ConnectedRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ConnectedRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ConnectedRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ConnectedRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ConnectedRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const ConnectedRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "NameUpdate" isn't clear, then there should be a description here.
 */
class NameUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  NameUpdate ();

    /**
     * Copy constructor
     */
    inline  NameUpdate (const NameUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  NameUpdate (const ::std::string& Name_);

    /**
     * Destructor
     */
    inline virtual  ~NameUpdate();

    /**
     * Assignment operator
     */
    inline NameUpdate& operator = (const NameUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const NameUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const NameUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const NameUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const NameUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Name"

    static const int kName = 0;

    /**
     * Clears the field "Name".
     *
     * The field will be set to its default value. The hasName()
     * method will return false.
     */
    inline void clearName();

    /**
     * Checks whether the field "Name" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setName()). Otherwise it will return false.
     */
    inline bool hasName () const;

    /**
     * Returns the value of the member "Name".
     *
     * If the meaning of "Name" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Name"
     */
    inline const ::std::string& getName () const;

    /**
     * Retrieves the value of the field "Name" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Name".
     */
    inline ::std::string& getNameMutable ();

    /**
     * Sets the value of the member "Name".
     *
     * If the meaning of "Name" isn't clear, then there should be a description here.
     *
     * @param Name The value which will be set
     */
    inline void setName (const ::std::string& Name_);

    /**
     * Sets the value of the member "Name".
     *
     * If the meaning of "Name" isn't clear, then there should be a description here.
     *
     * @param Name The value which will be set
     */
    inline void setName (const char* Name_);

    /**
     * Sets the value of the member "Name".
     *
     * If the meaning of "Name" isn't clear, then there should be a description here.
     *
     * @param Name The value which will be set
     */
    inline void setName (const char* value, size_t size);

    static const NameUpdate &getDefaultInstance();

private:

    inline void set_has_Name ();

    inline void clear_has_Name ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _Name;

};

/**
 * If the meaning of "NameRegister" isn't clear, then there should be a description here.
 */
class NameRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  NameRegister ();

    /**
     * Copy constructor
     */
    inline  NameRegister (const NameRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~NameRegister();

    /**
     * Assignment operator
     */
    inline NameRegister& operator = (const NameRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const NameRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const NameRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const NameRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const NameRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const NameRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "TypeUpdate" isn't clear, then there should be a description here.
 */
class TypeUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TypeUpdate ();

    /**
     * Copy constructor
     */
    inline  TypeUpdate (const TypeUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  TypeUpdate (const ::std::string& Type_);

    /**
     * Destructor
     */
    inline virtual  ~TypeUpdate();

    /**
     * Assignment operator
     */
    inline TypeUpdate& operator = (const TypeUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TypeUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TypeUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TypeUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TypeUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Type"

    static const int kType = 0;

    /**
     * Clears the field "Type".
     *
     * The field will be set to its default value. The hasType()
     * method will return false.
     */
    inline void clearType();

    /**
     * Checks whether the field "Type" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setType()). Otherwise it will return false.
     */
    inline bool hasType () const;

    /**
     * Returns the value of the member "Type".
     *
     * If the meaning of "Type" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Type"
     */
    inline const ::std::string& getType () const;

    /**
     * Retrieves the value of the field "Type" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Type".
     */
    inline ::std::string& getTypeMutable ();

    /**
     * Sets the value of the member "Type".
     *
     * If the meaning of "Type" isn't clear, then there should be a description here.
     *
     * @param Type The value which will be set
     */
    inline void setType (const ::std::string& Type_);

    /**
     * Sets the value of the member "Type".
     *
     * If the meaning of "Type" isn't clear, then there should be a description here.
     *
     * @param Type The value which will be set
     */
    inline void setType (const char* Type_);

    /**
     * Sets the value of the member "Type".
     *
     * If the meaning of "Type" isn't clear, then there should be a description here.
     *
     * @param Type The value which will be set
     */
    inline void setType (const char* value, size_t size);

    static const TypeUpdate &getDefaultInstance();

private:

    inline void set_has_Type ();

    inline void clear_has_Type ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _Type;

};

/**
 * If the meaning of "TypeRegister" isn't clear, then there should be a description here.
 */
class TypeRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TypeRegister ();

    /**
     * Copy constructor
     */
    inline  TypeRegister (const TypeRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~TypeRegister();

    /**
     * Assignment operator
     */
    inline TypeRegister& operator = (const TypeRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TypeRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TypeRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TypeRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TypeRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const TypeRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "TetheringUpdate" isn't clear, then there should be a description here.
 */
class TetheringUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TetheringUpdate ();

    /**
     * Copy constructor
     */
    inline  TetheringUpdate (const TetheringUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  TetheringUpdate (bool Tethering_);

    /**
     * Destructor
     */
    inline virtual  ~TetheringUpdate();

    /**
     * Assignment operator
     */
    inline TetheringUpdate& operator = (const TetheringUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TetheringUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TetheringUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TetheringUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TetheringUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Tethering"

    static const int kTethering = 0;

    /**
     * Clears the field "Tethering".
     *
     * The field will be set to its default value. The hasTethering()
     * method will return false.
     */
    inline void clearTethering();

    /**
     * Checks whether the field "Tethering" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTethering()). Otherwise it will return false.
     */
    inline bool hasTethering () const;

    /**
     * Returns the value of the member "Tethering".
     *
     * If the meaning of "Tethering" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Tethering"
     */
    inline bool getTethering () const;

    /**
     * Sets the value of the member "Tethering".
     *
     * If the meaning of "Tethering" isn't clear, then there should be a description here.
     *
     * @param Tethering The value which will be set
     */
    inline void setTethering (bool Tethering_);

    static const TetheringUpdate &getDefaultInstance();

private:

    inline void set_has_Tethering ();

    inline void clear_has_Tethering ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _Tethering;

};

/**
 * If the meaning of "TetheringRegister" isn't clear, then there should be a description here.
 */
class TetheringRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TetheringRegister ();

    /**
     * Copy constructor
     */
    inline  TetheringRegister (const TetheringRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~TetheringRegister();

    /**
     * Assignment operator
     */
    inline TetheringRegister& operator = (const TetheringRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TetheringRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TetheringRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TetheringRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TetheringRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const TetheringRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "PropertyChangedSignal" isn't clear, then there should be a description here.
 */
class PropertyChangedSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PropertyChangedSignal ();

    /**
     * Copy constructor
     */
    inline  PropertyChangedSignal (const PropertyChangedSignal &rhs);

    /**
     * All fields constructor
     */
    inline  PropertyChangedSignal (const ::std::string& name_, const ::asf::dbus::DBusVariant& value_);

    /**
     * Destructor
     */
    inline virtual  ~PropertyChangedSignal();

    /**
     * Assignment operator
     */
    inline PropertyChangedSignal& operator = (const PropertyChangedSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PropertyChangedSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PropertyChangedSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PropertyChangedSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PropertyChangedSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "name"

    static const int kName = 0;

    /**
     * Clears the field "name".
     *
     * The field will be set to its default value. The hasName()
     * method will return false.
     */
    inline void clearName();

    /**
     * Checks whether the field "name" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setName()). Otherwise it will return false.
     */
    inline bool hasName () const;

    /**
     * Returns the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @return The value of the field "name"
     */
    inline const ::std::string& getName () const;

    /**
     * Retrieves the value of the field "name" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "name".
     */
    inline ::std::string& getNameMutable ();

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const ::std::string& name_);

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const char* name_);

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const char* value, size_t size);

    // API of field "value"

    static const int kValue = 1;

    /**
     * Clears the field "value".
     *
     * The field will be set to its default value. The hasValue()
     * method will return false.
     */
    inline void clearValue();

    /**
     * Checks whether the field "value" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setValue()). Otherwise it will return false.
     */
    inline bool hasValue () const;

    /**
     * Returns the value of the member "value".
     *
     * If the meaning of "value" isn't clear, then there should be a description here.
     *
     * @return The value of the field "value"
     */
    inline const ::asf::dbus::DBusVariant& getValue () const;

    /**
     * Retrieves the value of the field "value" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "value".
     */
    inline ::asf::dbus::DBusVariant& getValueMutable ();

    /**
     * Sets the value of the member "value".
     *
     * If the meaning of "value" isn't clear, then there should be a description here.
     *
     * @param value The value which will be set
     */
    inline void setValue (const ::asf::dbus::DBusVariant& value_);

    static const PropertyChangedSignal &getDefaultInstance();

private:

    inline void set_has_name ();

    inline void clear_has_name ();

    inline void set_has_value ();

    inline void clear_has_value ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _name;

    ::asf::dbus::DBusVariant _value;

};

inline  GetPropertiesResponse::GetPropertiesResponse ()  :
    _properties ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetPropertiesResponse::GetPropertiesResponse (const GetPropertiesResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _properties ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetPropertiesResponse::GetPropertiesResponse (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties_)  :
    _properties (properties_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetPropertiesResponse::~GetPropertiesResponse() {
}

inline GetPropertiesResponse& GetPropertiesResponse::operator = (const GetPropertiesResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasProperties()) {
            setProperties(rhs.getProperties());
        } else {
            clearProperties();
        }
    }
    return *this;
}

inline bool GetPropertiesResponse::operator == (const GetPropertiesResponse& rhs) const {
    return (((!hasProperties() && !rhs.hasProperties()) || getProperties() == rhs.getProperties()));
}

inline bool GetPropertiesResponse::operator != (const GetPropertiesResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool GetPropertiesResponse::operator < (const GetPropertiesResponse& rhs) const {
    if (hasProperties() || rhs.hasProperties()) {
        if (getProperties() < rhs.getProperties()) return true;
        if (getProperties() > rhs.getProperties()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetPropertiesResponse::clone() {
    return new GetPropertiesResponse(*this);
}

inline bool GetPropertiesResponse::operator > (const GetPropertiesResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetPropertiesResponse::clear() {
    clearProperties();
}

inline void GetPropertiesResponse::clearProperties() {
    if (hasProperties()) {
         clear_has_properties();
        _properties.clear();
     }
}

inline bool GetPropertiesResponse::hasProperties () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& GetPropertiesResponse::getProperties () const {
    return _properties;
}

inline ::std::map< ::std::string, ::asf::dbus::DBusVariant >& GetPropertiesResponse::getPropertiesMutable () {
    set_has_properties();
    return _properties;
}

inline void GetPropertiesResponse::setProperties (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties_) {
    set_has_properties();
    this->_properties = properties_;
}

inline void GetPropertiesResponse::set_has_properties () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetPropertiesResponse::clear_has_properties () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SetPropertyRequest::SetPropertyRequest ()  :
    _name (),
    _value ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetPropertyRequest::SetPropertyRequest (const SetPropertyRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _name (),
    _value ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetPropertyRequest::SetPropertyRequest (const ::std::string& name_, const ::asf::dbus::DBusVariant& value_)  :
    _name (name_),
    _value (value_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetPropertyRequest::~SetPropertyRequest() {
}

inline SetPropertyRequest& SetPropertyRequest::operator = (const SetPropertyRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasName()) {
            setName(rhs.getName());
        } else {
            clearName();
        }
        if (rhs.hasValue()) {
            setValue(rhs.getValue());
        } else {
            clearValue();
        }
    }
    return *this;
}

inline bool SetPropertyRequest::operator == (const SetPropertyRequest& rhs) const {
    return (((!hasName() && !rhs.hasName()) || getName() == rhs.getName()) &&
        ((!hasValue() && !rhs.hasValue()) || getValue() == rhs.getValue()));
}

inline bool SetPropertyRequest::operator != (const SetPropertyRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool SetPropertyRequest::operator < (const SetPropertyRequest& rhs) const {
    if (hasName() || rhs.hasName()) {
        if (getName() < rhs.getName()) return true;
        if (getName() > rhs.getName()) return false;
    }
    if (hasValue() || rhs.hasValue()) {
        if (getValue() < rhs.getValue()) return true;
        if (getValue() > rhs.getValue()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetPropertyRequest::clone() {
    return new SetPropertyRequest(*this);
}

inline bool SetPropertyRequest::operator > (const SetPropertyRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetPropertyRequest::clear() {
    clearName();
    clearValue();
}

inline void SetPropertyRequest::clearName() {
    if (hasName()) {
         clear_has_name();
        _name.clear();
     }
}

inline bool SetPropertyRequest::hasName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& SetPropertyRequest::getName () const {
    return _name;
}

inline ::std::string& SetPropertyRequest::getNameMutable () {
    set_has_name();
    return _name;
}

inline void SetPropertyRequest::setName (const ::std::string& name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name = name_;
}

inline void SetPropertyRequest::setName (const char* name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name.assign(name_);
}

inline void SetPropertyRequest::setName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name.assign(value, size);
}

inline void SetPropertyRequest::clearValue() {
    if (hasValue()) {
         clear_has_value();
        _value = ::asf::dbus::DBusVariant ();
     }
}

inline bool SetPropertyRequest::hasValue () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::asf::dbus::DBusVariant& SetPropertyRequest::getValue () const {
    return _value;
}

inline ::asf::dbus::DBusVariant& SetPropertyRequest::getValueMutable () {
    set_has_value();
    return _value;
}

inline void SetPropertyRequest::setValue (const ::asf::dbus::DBusVariant& value_) {
    set_has_value();
    this->_value = value_;
}

inline void SetPropertyRequest::set_has_name () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetPropertyRequest::clear_has_name () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SetPropertyRequest::set_has_value () {
    _has_bits_[0] |= 1u << 1;
}

inline void SetPropertyRequest::clear_has_value () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  PoweredUpdate::PoweredUpdate ()  :
    _Powered (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  PoweredUpdate::PoweredUpdate (const PoweredUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _Powered (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  PoweredUpdate::PoweredUpdate (bool Powered_)  :
    _Powered (Powered_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  PoweredUpdate::~PoweredUpdate() {
}

inline PoweredUpdate& PoweredUpdate::operator = (const PoweredUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPowered()) {
            setPowered(rhs.getPowered());
        } else {
            clearPowered();
        }
    }
    return *this;
}

inline bool PoweredUpdate::operator == (const PoweredUpdate& rhs) const {
    return (((!hasPowered() && !rhs.hasPowered()) || getPowered() == rhs.getPowered()));
}

inline bool PoweredUpdate::operator != (const PoweredUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool PoweredUpdate::operator < (const PoweredUpdate& rhs) const {
    if (hasPowered() || rhs.hasPowered()) {
        if (getPowered() < rhs.getPowered()) return true;
        if (getPowered() > rhs.getPowered()) return false;
    }
    return false;
}

inline ::asf::core::Payload* PoweredUpdate::clone() {
    return new PoweredUpdate(*this);
}

inline bool PoweredUpdate::operator > (const PoweredUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void PoweredUpdate::clear() {
    clearPowered();
}

inline void PoweredUpdate::clearPowered() {
    if (hasPowered()) {
         clear_has_Powered();
        _Powered = false;
     }
}

inline bool PoweredUpdate::hasPowered () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool PoweredUpdate::getPowered () const {
    return _Powered;
}

inline void PoweredUpdate::setPowered (bool Powered_) {
    set_has_Powered();
    this->_Powered = Powered_;
}

inline void PoweredUpdate::set_has_Powered () {
    _has_bits_[0] |= 1u << 0;
}

inline void PoweredUpdate::clear_has_Powered () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  PoweredRegister::PoweredRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  PoweredRegister::PoweredRegister (const PoweredRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  PoweredRegister::~PoweredRegister() {
}

inline PoweredRegister& PoweredRegister::operator = (const PoweredRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool PoweredRegister::operator == (const PoweredRegister& ) const {
    return true;
}

inline bool PoweredRegister::operator != (const PoweredRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool PoweredRegister::operator < (const PoweredRegister& ) const {
    return false;
}

inline ::asf::core::Payload* PoweredRegister::clone() {
    return new PoweredRegister(*this);
}

inline bool PoweredRegister::operator > (const PoweredRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void PoweredRegister::clear() {
}

inline  ConnectedUpdate::ConnectedUpdate ()  :
    _Connected (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ConnectedUpdate::ConnectedUpdate (const ConnectedUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _Connected (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ConnectedUpdate::ConnectedUpdate (bool Connected_)  :
    _Connected (Connected_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ConnectedUpdate::~ConnectedUpdate() {
}

inline ConnectedUpdate& ConnectedUpdate::operator = (const ConnectedUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasConnected()) {
            setConnected(rhs.getConnected());
        } else {
            clearConnected();
        }
    }
    return *this;
}

inline bool ConnectedUpdate::operator == (const ConnectedUpdate& rhs) const {
    return (((!hasConnected() && !rhs.hasConnected()) || getConnected() == rhs.getConnected()));
}

inline bool ConnectedUpdate::operator != (const ConnectedUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool ConnectedUpdate::operator < (const ConnectedUpdate& rhs) const {
    if (hasConnected() || rhs.hasConnected()) {
        if (getConnected() < rhs.getConnected()) return true;
        if (getConnected() > rhs.getConnected()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ConnectedUpdate::clone() {
    return new ConnectedUpdate(*this);
}

inline bool ConnectedUpdate::operator > (const ConnectedUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ConnectedUpdate::clear() {
    clearConnected();
}

inline void ConnectedUpdate::clearConnected() {
    if (hasConnected()) {
         clear_has_Connected();
        _Connected = false;
     }
}

inline bool ConnectedUpdate::hasConnected () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool ConnectedUpdate::getConnected () const {
    return _Connected;
}

inline void ConnectedUpdate::setConnected (bool Connected_) {
    set_has_Connected();
    this->_Connected = Connected_;
}

inline void ConnectedUpdate::set_has_Connected () {
    _has_bits_[0] |= 1u << 0;
}

inline void ConnectedUpdate::clear_has_Connected () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ConnectedRegister::ConnectedRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ConnectedRegister::ConnectedRegister (const ConnectedRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ConnectedRegister::~ConnectedRegister() {
}

inline ConnectedRegister& ConnectedRegister::operator = (const ConnectedRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool ConnectedRegister::operator == (const ConnectedRegister& ) const {
    return true;
}

inline bool ConnectedRegister::operator != (const ConnectedRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool ConnectedRegister::operator < (const ConnectedRegister& ) const {
    return false;
}

inline ::asf::core::Payload* ConnectedRegister::clone() {
    return new ConnectedRegister(*this);
}

inline bool ConnectedRegister::operator > (const ConnectedRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ConnectedRegister::clear() {
}

inline  NameUpdate::NameUpdate ()  :
    _Name ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  NameUpdate::NameUpdate (const NameUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _Name ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  NameUpdate::NameUpdate (const ::std::string& Name_)  :
    _Name (Name_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Name_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  NameUpdate::~NameUpdate() {
}

inline NameUpdate& NameUpdate::operator = (const NameUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasName()) {
            setName(rhs.getName());
        } else {
            clearName();
        }
    }
    return *this;
}

inline bool NameUpdate::operator == (const NameUpdate& rhs) const {
    return (((!hasName() && !rhs.hasName()) || getName() == rhs.getName()));
}

inline bool NameUpdate::operator != (const NameUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool NameUpdate::operator < (const NameUpdate& rhs) const {
    if (hasName() || rhs.hasName()) {
        if (getName() < rhs.getName()) return true;
        if (getName() > rhs.getName()) return false;
    }
    return false;
}

inline ::asf::core::Payload* NameUpdate::clone() {
    return new NameUpdate(*this);
}

inline bool NameUpdate::operator > (const NameUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void NameUpdate::clear() {
    clearName();
}

inline void NameUpdate::clearName() {
    if (hasName()) {
         clear_has_Name();
        _Name.clear();
     }
}

inline bool NameUpdate::hasName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& NameUpdate::getName () const {
    return _Name;
}

inline ::std::string& NameUpdate::getNameMutable () {
    set_has_Name();
    return _Name;
}

inline void NameUpdate::setName (const ::std::string& Name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Name();
    this->_Name = Name_;
}

inline void NameUpdate::setName (const char* Name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Name();
    this->_Name.assign(Name_);
}

inline void NameUpdate::setName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Name();
    this->_Name.assign(value, size);
}

inline void NameUpdate::set_has_Name () {
    _has_bits_[0] |= 1u << 0;
}

inline void NameUpdate::clear_has_Name () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  NameRegister::NameRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  NameRegister::NameRegister (const NameRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  NameRegister::~NameRegister() {
}

inline NameRegister& NameRegister::operator = (const NameRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool NameRegister::operator == (const NameRegister& ) const {
    return true;
}

inline bool NameRegister::operator != (const NameRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool NameRegister::operator < (const NameRegister& ) const {
    return false;
}

inline ::asf::core::Payload* NameRegister::clone() {
    return new NameRegister(*this);
}

inline bool NameRegister::operator > (const NameRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void NameRegister::clear() {
}

inline  TypeUpdate::TypeUpdate ()  :
    _Type ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  TypeUpdate::TypeUpdate (const TypeUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _Type ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  TypeUpdate::TypeUpdate (const ::std::string& Type_)  :
    _Type (Type_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Type_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  TypeUpdate::~TypeUpdate() {
}

inline TypeUpdate& TypeUpdate::operator = (const TypeUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasType()) {
            setType(rhs.getType());
        } else {
            clearType();
        }
    }
    return *this;
}

inline bool TypeUpdate::operator == (const TypeUpdate& rhs) const {
    return (((!hasType() && !rhs.hasType()) || getType() == rhs.getType()));
}

inline bool TypeUpdate::operator != (const TypeUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool TypeUpdate::operator < (const TypeUpdate& rhs) const {
    if (hasType() || rhs.hasType()) {
        if (getType() < rhs.getType()) return true;
        if (getType() > rhs.getType()) return false;
    }
    return false;
}

inline ::asf::core::Payload* TypeUpdate::clone() {
    return new TypeUpdate(*this);
}

inline bool TypeUpdate::operator > (const TypeUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void TypeUpdate::clear() {
    clearType();
}

inline void TypeUpdate::clearType() {
    if (hasType()) {
         clear_has_Type();
        _Type.clear();
     }
}

inline bool TypeUpdate::hasType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& TypeUpdate::getType () const {
    return _Type;
}

inline ::std::string& TypeUpdate::getTypeMutable () {
    set_has_Type();
    return _Type;
}

inline void TypeUpdate::setType (const ::std::string& Type_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Type_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Type();
    this->_Type = Type_;
}

inline void TypeUpdate::setType (const char* Type_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Type_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Type();
    this->_Type.assign(Type_);
}

inline void TypeUpdate::setType (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Type();
    this->_Type.assign(value, size);
}

inline void TypeUpdate::set_has_Type () {
    _has_bits_[0] |= 1u << 0;
}

inline void TypeUpdate::clear_has_Type () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  TypeRegister::TypeRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  TypeRegister::TypeRegister (const TypeRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  TypeRegister::~TypeRegister() {
}

inline TypeRegister& TypeRegister::operator = (const TypeRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool TypeRegister::operator == (const TypeRegister& ) const {
    return true;
}

inline bool TypeRegister::operator != (const TypeRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool TypeRegister::operator < (const TypeRegister& ) const {
    return false;
}

inline ::asf::core::Payload* TypeRegister::clone() {
    return new TypeRegister(*this);
}

inline bool TypeRegister::operator > (const TypeRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void TypeRegister::clear() {
}

inline  TetheringUpdate::TetheringUpdate ()  :
    _Tethering (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  TetheringUpdate::TetheringUpdate (const TetheringUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _Tethering (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  TetheringUpdate::TetheringUpdate (bool Tethering_)  :
    _Tethering (Tethering_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  TetheringUpdate::~TetheringUpdate() {
}

inline TetheringUpdate& TetheringUpdate::operator = (const TetheringUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTethering()) {
            setTethering(rhs.getTethering());
        } else {
            clearTethering();
        }
    }
    return *this;
}

inline bool TetheringUpdate::operator == (const TetheringUpdate& rhs) const {
    return (((!hasTethering() && !rhs.hasTethering()) || getTethering() == rhs.getTethering()));
}

inline bool TetheringUpdate::operator != (const TetheringUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool TetheringUpdate::operator < (const TetheringUpdate& rhs) const {
    if (hasTethering() || rhs.hasTethering()) {
        if (getTethering() < rhs.getTethering()) return true;
        if (getTethering() > rhs.getTethering()) return false;
    }
    return false;
}

inline ::asf::core::Payload* TetheringUpdate::clone() {
    return new TetheringUpdate(*this);
}

inline bool TetheringUpdate::operator > (const TetheringUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void TetheringUpdate::clear() {
    clearTethering();
}

inline void TetheringUpdate::clearTethering() {
    if (hasTethering()) {
         clear_has_Tethering();
        _Tethering = false;
     }
}

inline bool TetheringUpdate::hasTethering () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool TetheringUpdate::getTethering () const {
    return _Tethering;
}

inline void TetheringUpdate::setTethering (bool Tethering_) {
    set_has_Tethering();
    this->_Tethering = Tethering_;
}

inline void TetheringUpdate::set_has_Tethering () {
    _has_bits_[0] |= 1u << 0;
}

inline void TetheringUpdate::clear_has_Tethering () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  TetheringRegister::TetheringRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  TetheringRegister::TetheringRegister (const TetheringRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  TetheringRegister::~TetheringRegister() {
}

inline TetheringRegister& TetheringRegister::operator = (const TetheringRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool TetheringRegister::operator == (const TetheringRegister& ) const {
    return true;
}

inline bool TetheringRegister::operator != (const TetheringRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool TetheringRegister::operator < (const TetheringRegister& ) const {
    return false;
}

inline ::asf::core::Payload* TetheringRegister::clone() {
    return new TetheringRegister(*this);
}

inline bool TetheringRegister::operator > (const TetheringRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void TetheringRegister::clear() {
}

inline  PropertyChangedSignal::PropertyChangedSignal ()  :
    _name (),
    _value ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  PropertyChangedSignal::PropertyChangedSignal (const PropertyChangedSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _name (),
    _value ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  PropertyChangedSignal::PropertyChangedSignal (const ::std::string& name_, const ::asf::dbus::DBusVariant& value_)  :
    _name (name_),
    _value (value_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  PropertyChangedSignal::~PropertyChangedSignal() {
}

inline PropertyChangedSignal& PropertyChangedSignal::operator = (const PropertyChangedSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasName()) {
            setName(rhs.getName());
        } else {
            clearName();
        }
        if (rhs.hasValue()) {
            setValue(rhs.getValue());
        } else {
            clearValue();
        }
    }
    return *this;
}

inline bool PropertyChangedSignal::operator == (const PropertyChangedSignal& rhs) const {
    return (((!hasName() && !rhs.hasName()) || getName() == rhs.getName()) &&
        ((!hasValue() && !rhs.hasValue()) || getValue() == rhs.getValue()));
}

inline bool PropertyChangedSignal::operator != (const PropertyChangedSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool PropertyChangedSignal::operator < (const PropertyChangedSignal& rhs) const {
    if (hasName() || rhs.hasName()) {
        if (getName() < rhs.getName()) return true;
        if (getName() > rhs.getName()) return false;
    }
    if (hasValue() || rhs.hasValue()) {
        if (getValue() < rhs.getValue()) return true;
        if (getValue() > rhs.getValue()) return false;
    }
    return false;
}

inline ::asf::core::Payload* PropertyChangedSignal::clone() {
    return new PropertyChangedSignal(*this);
}

inline bool PropertyChangedSignal::operator > (const PropertyChangedSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void PropertyChangedSignal::clear() {
    clearName();
    clearValue();
}

inline void PropertyChangedSignal::clearName() {
    if (hasName()) {
         clear_has_name();
        _name.clear();
     }
}

inline bool PropertyChangedSignal::hasName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& PropertyChangedSignal::getName () const {
    return _name;
}

inline ::std::string& PropertyChangedSignal::getNameMutable () {
    set_has_name();
    return _name;
}

inline void PropertyChangedSignal::setName (const ::std::string& name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name = name_;
}

inline void PropertyChangedSignal::setName (const char* name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name.assign(name_);
}

inline void PropertyChangedSignal::setName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name.assign(value, size);
}

inline void PropertyChangedSignal::clearValue() {
    if (hasValue()) {
         clear_has_value();
        _value = ::asf::dbus::DBusVariant ();
     }
}

inline bool PropertyChangedSignal::hasValue () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::asf::dbus::DBusVariant& PropertyChangedSignal::getValue () const {
    return _value;
}

inline ::asf::dbus::DBusVariant& PropertyChangedSignal::getValueMutable () {
    set_has_value();
    return _value;
}

inline void PropertyChangedSignal::setValue (const ::asf::dbus::DBusVariant& value_) {
    set_has_value();
    this->_value = value_;
}

inline void PropertyChangedSignal::set_has_name () {
    _has_bits_[0] |= 1u << 0;
}

inline void PropertyChangedSignal::clear_has_name () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void PropertyChangedSignal::set_has_value () {
    _has_bits_[0] |= 1u << 1;
}

inline void PropertyChangedSignal::clear_has_value () {
    _has_bits_[0] &= ~ (1u << 1);
}

} // namespace Technology
} // namespace connman
} // namespace net

#endif // NET_CONNMAN_TECHNOLOGY_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
