/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "net/connman/Notification.h"
#include "net/connman/NotificationDBus.h"
#include "net/connman/NotificationJson.h"
#include "net/connman/NotificationStub.h"

#include "asf/dbus/DBusMessage.h"

namespace net {
namespace connman {
namespace Notification {

DEFINE_CLASS_LOGGER("//xyz/net/connman/Notification", NotificationStub);

static ::asf::dbus::DBusUtils::stringEntry methodsTable[] = {
    { 6, "Update", 1 },
    { 7, "Release", 0 },
};


class NotificationStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    NotificationStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    NotificationStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    NotificationStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "net.connman.Notification"),
          _logger(logger) {}

    virtual ~NotificationStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void NotificationStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    unsigned int methodIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (message.getMemberName().c_str(), message.getMemberName().length(), methodsTable, 2, methodIndex)) {
        switch (methodIndex) {
        case 0: {

            // method 'Release'

            LOG_DEBUG_STUB("process method '%s'", "Release");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ReleaseRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "Release", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ReleaseRequest > payload = ::boost::static_pointer_cast<ReleaseRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NotificationStub*>(getStub())->onReleaseRequest(payload);
            return;
        }
        case 1: {

            // method 'Update'

            LOG_DEBUG_STUB("process method '%s'", "Update");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UpdateRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "Update", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< UpdateRequest > payload = ::boost::static_pointer_cast<UpdateRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NotificationStub*>(getStub())->onUpdateRequest(payload);
            return;
        }
        default:
            break;
        }
    }
    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* NotificationStubDelegate::introspect() const {
    return     "<interface name=\"net.connman.Notification\">\n"
            "      <method name=\"Release\"/>\n"
            "      <method name=\"Update\">\n"
            "        <arg direction=\"in\" name=\"settings\" type=\"a{sv}\"/>\n"
            "      </method>\n"
            "</interface>\n";
}

void NotificationStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<NotificationStub*>(getStub()))->onGetAll (properties);
}

void NotificationStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    ((void)value);  // to get rid of unused variable warning
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void NotificationStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

NotificationStub::NotificationStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new NotificationStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

NotificationStub::NotificationStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new NotificationStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

NotificationStub::~NotificationStub() {
    delete _stubDelegate;
}

void  NotificationStub::sendReleaseResponse (act_t act) {
    ReleaseResponse* payload = new ReleaseResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "Release", ReleaseResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "Release", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NotificationStub::sendReleaseError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ReleaseError* payload = new ReleaseError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "Release", ReleaseError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "Release", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NotificationStub::sendUpdateResponse (act_t act) {
    UpdateResponse* payload = new UpdateResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "Update", UpdateResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "Update", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NotificationStub::sendUpdateError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    UpdateError* payload = new UpdateError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "Update", UpdateError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "Update", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void NotificationStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {
    ((void)properties);  // to get rid of unused variable warning
}

} // namespace Notification
} // namespace connman
} // namespace net
