/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef NET_CONNMAN_NOTIFICATIONPROXY_H
#define NET_CONNMAN_NOTIFICATIONPROXY_H

#include "asf/core/Logger.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusProxy.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DBusVariant.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "net/connman/Notification.h"
#include <dbus/dbus.h>
#include <map>
#include <string>

namespace net {
namespace connman {
namespace Notification {

class NotificationProxy;

class ReleaseCallbackIF {
public:
    virtual ~ReleaseCallbackIF() {}

    virtual void onReleaseError(const ::boost::shared_ptr< NotificationProxy >& proxy, const ::boost::shared_ptr< ReleaseError >& error) = 0;

    virtual void onReleaseResponse(const ::boost::shared_ptr< NotificationProxy >& proxy, const ::boost::shared_ptr< ReleaseResponse >& response) = 0;
};

class UpdateCallbackIF {
public:
    virtual ~UpdateCallbackIF() {}

    virtual void onUpdateError(const ::boost::shared_ptr< NotificationProxy >& proxy, const ::boost::shared_ptr< UpdateError >& error) = 0;

    virtual void onUpdateResponse(const ::boost::shared_ptr< NotificationProxy >& proxy, const ::boost::shared_ptr< UpdateResponse >& response) = 0;
};


/**
 * NotificationProxy is the client side representation of the D-Bus
 * service interface 'net.connman.Notification' (specified in file
 * connman_notification.xml).
 *
 * If the meaning of "net.connman.Notification" isn't clear, then there should be a description here.
 */
class NotificationProxy : public ::asf::dbus::DBusProxy
{
public:
    /**
     * Create a new instance of NotificationProxy.
     */
    static ::boost::shared_ptr< NotificationProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Create a new instance of NotificationProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @deprecated use the createProxy() method with the parameter
     * ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector instead.
     */
    static ::boost::shared_ptr< NotificationProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        ::DBusBusType busType,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector connectorOptions;
        connectorOptions.setBusType(::asf::dbus::DBusUtils::toOptions(busType).getBusType());
        return createProxy(portName, busName, objectPath, connectorOptions, serviceAvailable);
    }

    /**
     * Create a new instance of NotificationProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     */
    static ::boost::shared_ptr< NotificationProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        const ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector& connectorOptions,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< NotificationProxy > proxyNew(new NotificationProxy(portName, serviceAvailable));
        ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew, busName, objectPath, connectorOptions);
        proxyNew->createHelperProxies(false);
        return proxyNew;
    }

    virtual ~NotificationProxy ();




    // Method 'Release'

    /**
     * Call the method 'Release'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'Release'</b>:
     *
     * If the meaning of "Release" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendReleaseRequest(ReleaseCallbackIF& cb) const;

    // Method 'Update'

    /**
     * Call the method 'Update'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'Update'</b>:
     *
     * If the meaning of "Update" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param settings If the meaning of "settings" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendUpdateRequest(UpdateCallbackIF& cb, const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& settings) const;


private:

    NotificationProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    act_t addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const;

    act_t addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const;


    DECLARE_CLASS_LOGGER();

    friend class NotificationProxyCallback;
};

} // namespace Notification
} // namespace connman
} // namespace net

#endif // NET_CONNMAN_NOTIFICATIONPROXY_H
