/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusVariant.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "net/connman/Notification.h"
#include "net/connman/NotificationDBus.h"
#include "net/connman/NotificationJson.h"
#include "net/connman/NotificationProxy.h"
#include <map>
#include <string>

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace net {
namespace connman {
namespace Notification {

DEFINE_CLASS_LOGGER("//xyz/net/connman/Notification", NotificationProxy);

class NotificationProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    NotificationProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< NotificationProxy >& proxyShared = ::boost::static_pointer_cast< NotificationProxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_Release:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), ReleaseError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "Release", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ReleaseError> payload = ::boost::static_pointer_cast<ReleaseError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ReleaseCallbackIF*) _callback)->onReleaseError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ReleaseResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "Release", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ReleaseResponse> payload = ::boost::static_pointer_cast<ReleaseResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ReleaseCallbackIF*) _callback)->onReleaseResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_Update:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), UpdateError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "Update", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<UpdateError> payload = ::boost::static_pointer_cast<UpdateError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((UpdateCallbackIF*) _callback)->onUpdateError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UpdateResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "Update", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<UpdateResponse> payload = ::boost::static_pointer_cast<UpdateResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((UpdateCallbackIF*) _callback)->onUpdateResponse (proxyShared, payload);
                        return true;
                    }
                }
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_Release: {
                ::boost::shared_ptr< ReleaseError > payload = ::boost::shared_ptr< ReleaseError >
                (new ReleaseError(DBUS_ERROR_NO_SERVER, "The DBus service Notification is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Release", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NotificationProxy> proxyShared = ::boost::static_pointer_cast<NotificationProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ReleaseCallbackIF*) _callback)->onReleaseError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Update: {
                ::boost::shared_ptr< UpdateError > payload = ::boost::shared_ptr< UpdateError >
                (new UpdateError(DBUS_ERROR_NO_SERVER, "The DBus service Notification is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Update", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NotificationProxy> proxyShared = ::boost::static_pointer_cast<NotificationProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((UpdateCallbackIF*) _callback)->onUpdateError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& NotificationProxyCallback::_logger (NotificationProxy::_logger);

NotificationProxy::NotificationProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "net.connman.Notification", serviceAvailable, _logger) {
}

NotificationProxy::~NotificationProxy()
{
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< NotificationProxy > NotificationProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<NotificationProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< NotificationProxy > proxyNew(new NotificationProxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(false);
    return proxyNew;
}

act_t NotificationProxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    NotificationProxyCallback* callback = new NotificationProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t NotificationProxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    NotificationProxyCallback* callback = new NotificationProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}



act_t NotificationProxy::sendReleaseRequest(ReleaseCallbackIF& cb) const {
    ReleaseRequest* payload = new ReleaseRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "Release", ReleaseRequest, payload, true)
    act_t act = addMethodCallback(ID_Release, dbusMessage.getUniqueSerial(), "Release", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "Release", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NotificationProxy::sendUpdateRequest(UpdateCallbackIF& cb, const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& settings) const {
    UpdateRequest* payload = new UpdateRequest();
    CHECK_ALLOCATION(payload);
    payload->setSettings(settings);
    DBUS_MESSAGE_CALL(dbusMessage, "Update", UpdateRequest, payload, true)
    act_t act = addMethodCallback(ID_Update, dbusMessage.getUniqueSerial(), "Update", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "Update", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

} // namespace Notification
} // namespace connman
} // namespace net
