/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef NET_CONNMAN_MANAGERSTUB_H
#define NET_CONNMAN_MANAGERSTUB_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStub.h"
#include "asf/dbus/DBusVariant.h"
#include "boost/shared_ptr.hpp"
#include "net/connman/Manager.h"
#include <map>
#include <string>
#include <vector>

namespace net {
namespace connman {
namespace Manager {

class ManagerStubDelegate;

class ManagerStub : public ::asf::dbus::DBusStub
{
public:

    /**
     * Create an instance of the ManagerStub
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     */
    ManagerStub (const std::string& portName);

    /**
     * Create an instance of the ManagerStub
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     * @param objectPath the dbus object path, see
     * http://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-marshaling-object-path
     */
    ManagerStub (const std::string& portName, const std::string& objectPath);

    virtual ~ManagerStub();

    // signal 'PropertyChanged'

    /**
     * Raise the signal 'PropertyChanged' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'PropertyChanged'</b>:
     *
     * If the meaning of "PropertyChanged" isn't clear, then there should be a description here.
     */
    void sendPropertyChangedSignal(const ::std::string& name, const ::asf::dbus::DBusVariant& value);

    // signal 'TechnologyAdded'

    /**
     * Raise the signal 'TechnologyAdded' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'TechnologyAdded'</b>:
     *
     * If the meaning of "TechnologyAdded" isn't clear, then there should be a description here.
     */
    void sendTechnologyAddedSignal(const ::std::string& path, const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    // signal 'TechnologyRemoved'

    /**
     * Raise the signal 'TechnologyRemoved' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'TechnologyRemoved'</b>:
     *
     * If the meaning of "TechnologyRemoved" isn't clear, then there should be a description here.
     */
    void sendTechnologyRemovedSignal(const ::std::string& path);

    // signal 'ServicesChanged'

    /**
     * Raise the signal 'ServicesChanged' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'ServicesChanged'</b>:
     *
     * If the meaning of "ServicesChanged" isn't clear, then there should be a description here.
     */
    void sendServicesChangedSignal(const ::std::vector< ServicesChangedSignalChangedStruct >& changed, const ::std::vector< ::std::string >& removed);

    // method 'GetProperties'

    /**
     * The method onGetProperties() is called by ASF when a client invokes the
     * method 'GetProperties'. A subclass has to implement this method and
     * send back a response to the client either with the sendGetProperties()
     * or sendGetPropertiesError() method. Do not invoke this method on your
     * own.
     *
     * <b>Documentation of 'GetProperties'</b>:
     *
     * If the meaning of "GetProperties" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onGetPropertiesRequest (const ::boost::shared_ptr< GetPropertiesRequest >& request) = 0;

    /**
     * The method sendGetPropertiesResponse() sends a response of a previous
     * method invocation of 'GetProperties' back to the client.
     *
     * <b>Documentation of 'GetProperties'</b>:
     *
     * If the meaning of "GetProperties" isn't clear, then there should be a description here.
     *
     * @param properties If the meaning of "properties" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onGetProperties(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendGetPropertiesResponse (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties, act_t act = 0);

    /**
     * The method sendGetPropertiesError() sends an error response of a
     * previous method invocation of 'GetProperties' back to the client.
     *
     * <b>Documentation of 'GetProperties'</b>:
     *
     * If the meaning of "GetProperties" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onGetProperties(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendGetPropertiesError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'SetProperty'

    /**
     * The method onSetProperty() is called by ASF when a client invokes the
     * method 'SetProperty'. A subclass has to implement this method and send
     * back a response to the client either with the sendSetProperty() or
     * sendSetPropertyError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'SetProperty'</b>:
     *
     * If the meaning of "SetProperty" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onSetPropertyRequest (const ::boost::shared_ptr< SetPropertyRequest >& request) = 0;

    /**
     * The method sendSetPropertyResponse() sends a response of a previous
     * method invocation of 'SetProperty' back to the client.
     *
     * <b>Documentation of 'SetProperty'</b>:
     *
     * If the meaning of "SetProperty" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onSetProperty(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendSetPropertyResponse (act_t act = 0);

    /**
     * The method sendSetPropertyError() sends an error response of a previous
     * method invocation of 'SetProperty' back to the client.
     *
     * <b>Documentation of 'SetProperty'</b>:
     *
     * If the meaning of "SetProperty" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onSetProperty(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendSetPropertyError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'GetTechnologies'

    /**
     * The method onGetTechnologies() is called by ASF when a client invokes
     * the method 'GetTechnologies'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendGetTechnologies() or sendGetTechnologiesError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'GetTechnologies'</b>:
     *
     * If the meaning of "GetTechnologies" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onGetTechnologiesRequest (const ::boost::shared_ptr< GetTechnologiesRequest >& request) = 0;

    /**
     * The method sendGetTechnologiesResponse() sends a response of a previous
     * method invocation of 'GetTechnologies' back to the client.
     *
     * <b>Documentation of 'GetTechnologies'</b>:
     *
     * If the meaning of "GetTechnologies" isn't clear, then there should be a description here.
     *
     * @param technologies If the meaning of "technologies" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onGetTechnologies(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendGetTechnologiesResponse (const ::std::vector< GetTechnologiesResponseTechnologiesStruct >& technologies, act_t act = 0);

    /**
     * The method sendGetTechnologiesError() sends an error response of a
     * previous method invocation of 'GetTechnologies' back to the client.
     *
     * <b>Documentation of 'GetTechnologies'</b>:
     *
     * If the meaning of "GetTechnologies" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onGetTechnologies(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendGetTechnologiesError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'RemoveProvider'

    /**
     * The method onRemoveProvider() is called by ASF when a client invokes
     * the method 'RemoveProvider'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendRemoveProvider() or sendRemoveProviderError() method. Do not invoke
     * this method on your own.
     *
     * <b>Documentation of 'RemoveProvider'</b>:
     *
     * If the meaning of "RemoveProvider" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onRemoveProviderRequest (const ::boost::shared_ptr< RemoveProviderRequest >& request) = 0;

    /**
     * The method sendRemoveProviderResponse() sends a response of a previous
     * method invocation of 'RemoveProvider' back to the client.
     *
     * <b>Documentation of 'RemoveProvider'</b>:
     *
     * If the meaning of "RemoveProvider" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onRemoveProvider(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendRemoveProviderResponse (act_t act = 0);

    /**
     * The method sendRemoveProviderError() sends an error response of a
     * previous method invocation of 'RemoveProvider' back to the client.
     *
     * <b>Documentation of 'RemoveProvider'</b>:
     *
     * If the meaning of "RemoveProvider" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onRemoveProvider(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendRemoveProviderError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'GetServices'

    /**
     * The method onGetServices() is called by ASF when a client invokes the
     * method 'GetServices'. A subclass has to implement this method and send
     * back a response to the client either with the sendGetServices() or
     * sendGetServicesError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'GetServices'</b>:
     *
     * If the meaning of "GetServices" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onGetServicesRequest (const ::boost::shared_ptr< GetServicesRequest >& request) = 0;

    /**
     * The method sendGetServicesResponse() sends a response of a previous
     * method invocation of 'GetServices' back to the client.
     *
     * <b>Documentation of 'GetServices'</b>:
     *
     * If the meaning of "GetServices" isn't clear, then there should be a description here.
     *
     * @param services If the meaning of "services" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onGetServices(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendGetServicesResponse (const ::std::vector< GetServicesResponseServicesStruct >& services, act_t act = 0);

    /**
     * The method sendGetServicesError() sends an error response of a previous
     * method invocation of 'GetServices' back to the client.
     *
     * <b>Documentation of 'GetServices'</b>:
     *
     * If the meaning of "GetServices" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onGetServices(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendGetServicesError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'ConnectProvider'

    /**
     * The method onConnectProvider() is called by ASF when a client invokes
     * the method 'ConnectProvider'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendConnectProvider() or sendConnectProviderError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'ConnectProvider'</b>:
     *
     * If the meaning of "ConnectProvider" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onConnectProviderRequest (const ::boost::shared_ptr< ConnectProviderRequest >& request) = 0;

    /**
     * The method sendConnectProviderResponse() sends a response of a previous
     * method invocation of 'ConnectProvider' back to the client.
     *
     * <b>Documentation of 'ConnectProvider'</b>:
     *
     * If the meaning of "ConnectProvider" isn't clear, then there should be a description here.
     *
     * @param path If the meaning of "path" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onConnectProvider(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendConnectProviderResponse (const ::std::string& path, act_t act = 0);

    /**
     * The method sendConnectProviderError() sends an error response of a
     * previous method invocation of 'ConnectProvider' back to the client.
     *
     * <b>Documentation of 'ConnectProvider'</b>:
     *
     * If the meaning of "ConnectProvider" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onConnectProvider(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendConnectProviderError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'RegisterAgent'

    /**
     * The method onRegisterAgent() is called by ASF when a client invokes the
     * method 'RegisterAgent'. A subclass has to implement this method and
     * send back a response to the client either with the sendRegisterAgent()
     * or sendRegisterAgentError() method. Do not invoke this method on your
     * own.
     *
     * <b>Documentation of 'RegisterAgent'</b>:
     *
     * If the meaning of "RegisterAgent" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onRegisterAgentRequest (const ::boost::shared_ptr< RegisterAgentRequest >& request) = 0;

    /**
     * The method sendRegisterAgentResponse() sends a response of a previous
     * method invocation of 'RegisterAgent' back to the client.
     *
     * <b>Documentation of 'RegisterAgent'</b>:
     *
     * If the meaning of "RegisterAgent" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onRegisterAgent(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendRegisterAgentResponse (act_t act = 0);

    /**
     * The method sendRegisterAgentError() sends an error response of a
     * previous method invocation of 'RegisterAgent' back to the client.
     *
     * <b>Documentation of 'RegisterAgent'</b>:
     *
     * If the meaning of "RegisterAgent" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onRegisterAgent(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendRegisterAgentError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'UnregisterAgent'

    /**
     * The method onUnregisterAgent() is called by ASF when a client invokes
     * the method 'UnregisterAgent'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendUnregisterAgent() or sendUnregisterAgentError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'UnregisterAgent'</b>:
     *
     * If the meaning of "UnregisterAgent" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onUnregisterAgentRequest (const ::boost::shared_ptr< UnregisterAgentRequest >& request) = 0;

    /**
     * The method sendUnregisterAgentResponse() sends a response of a previous
     * method invocation of 'UnregisterAgent' back to the client.
     *
     * <b>Documentation of 'UnregisterAgent'</b>:
     *
     * If the meaning of "UnregisterAgent" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onUnregisterAgent(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendUnregisterAgentResponse (act_t act = 0);

    /**
     * The method sendUnregisterAgentError() sends an error response of a
     * previous method invocation of 'UnregisterAgent' back to the client.
     *
     * <b>Documentation of 'UnregisterAgent'</b>:
     *
     * If the meaning of "UnregisterAgent" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onUnregisterAgent(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendUnregisterAgentError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'RegisterCounter'

    /**
     * The method onRegisterCounter() is called by ASF when a client invokes
     * the method 'RegisterCounter'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendRegisterCounter() or sendRegisterCounterError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'RegisterCounter'</b>:
     *
     * If the meaning of "RegisterCounter" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onRegisterCounterRequest (const ::boost::shared_ptr< RegisterCounterRequest >& request) = 0;

    /**
     * The method sendRegisterCounterResponse() sends a response of a previous
     * method invocation of 'RegisterCounter' back to the client.
     *
     * <b>Documentation of 'RegisterCounter'</b>:
     *
     * If the meaning of "RegisterCounter" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onRegisterCounter(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendRegisterCounterResponse (act_t act = 0);

    /**
     * The method sendRegisterCounterError() sends an error response of a
     * previous method invocation of 'RegisterCounter' back to the client.
     *
     * <b>Documentation of 'RegisterCounter'</b>:
     *
     * If the meaning of "RegisterCounter" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onRegisterCounter(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendRegisterCounterError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'UnregisterCounter'

    /**
     * The method onUnregisterCounter() is called by ASF when a client invokes
     * the method 'UnregisterCounter'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendUnregisterCounter() or sendUnregisterCounterError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'UnregisterCounter'</b>:
     *
     * If the meaning of "UnregisterCounter" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onUnregisterCounterRequest (const ::boost::shared_ptr< UnregisterCounterRequest >& request) = 0;

    /**
     * The method sendUnregisterCounterResponse() sends a response of a
     * previous method invocation of 'UnregisterCounter' back to the client.
     *
     * <b>Documentation of 'UnregisterCounter'</b>:
     *
     * If the meaning of "UnregisterCounter" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onUnregisterCounter(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendUnregisterCounterResponse (act_t act = 0);

    /**
     * The method sendUnregisterCounterError() sends an error response of a
     * previous method invocation of 'UnregisterCounter' back to the client.
     *
     * <b>Documentation of 'UnregisterCounter'</b>:
     *
     * If the meaning of "UnregisterCounter" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onUnregisterCounter().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendUnregisterCounterError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'CreateSession'

    /**
     * The method onCreateSession() is called by ASF when a client invokes the
     * method 'CreateSession'. A subclass has to implement this method and
     * send back a response to the client either with the sendCreateSession()
     * or sendCreateSessionError() method. Do not invoke this method on your
     * own.
     *
     * <b>Documentation of 'CreateSession'</b>:
     *
     * If the meaning of "CreateSession" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onCreateSessionRequest (const ::boost::shared_ptr< CreateSessionRequest >& request) = 0;

    /**
     * The method sendCreateSessionResponse() sends a response of a previous
     * method invocation of 'CreateSession' back to the client.
     *
     * <b>Documentation of 'CreateSession'</b>:
     *
     * If the meaning of "CreateSession" isn't clear, then there should be a description here.
     *
     * @param session If the meaning of "session" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onCreateSession(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendCreateSessionResponse (const ::std::string& session, act_t act = 0);

    /**
     * The method sendCreateSessionError() sends an error response of a
     * previous method invocation of 'CreateSession' back to the client.
     *
     * <b>Documentation of 'CreateSession'</b>:
     *
     * If the meaning of "CreateSession" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onCreateSession(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendCreateSessionError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'DestroySession'

    /**
     * The method onDestroySession() is called by ASF when a client invokes
     * the method 'DestroySession'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendDestroySession() or sendDestroySessionError() method. Do not invoke
     * this method on your own.
     *
     * <b>Documentation of 'DestroySession'</b>:
     *
     * If the meaning of "DestroySession" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onDestroySessionRequest (const ::boost::shared_ptr< DestroySessionRequest >& request) = 0;

    /**
     * The method sendDestroySessionResponse() sends a response of a previous
     * method invocation of 'DestroySession' back to the client.
     *
     * <b>Documentation of 'DestroySession'</b>:
     *
     * If the meaning of "DestroySession" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onDestroySession(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendDestroySessionResponse (act_t act = 0);

    /**
     * The method sendDestroySessionError() sends an error response of a
     * previous method invocation of 'DestroySession' back to the client.
     *
     * <b>Documentation of 'DestroySession'</b>:
     *
     * If the meaning of "DestroySession" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onDestroySession(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendDestroySessionError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'RequestPrivateNetwork'

    /**
     * The method onRequestPrivateNetwork() is called by ASF when a client
     * invokes the method 'RequestPrivateNetwork'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendRequestPrivateNetwork() or sendRequestPrivateNetworkError() method.
     * Do not invoke this method on your own.
     *
     * <b>Documentation of 'RequestPrivateNetwork'</b>:
     *
     * If the meaning of "RequestPrivateNetwork" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onRequestPrivateNetworkRequest (const ::boost::shared_ptr< RequestPrivateNetworkRequest >& request) = 0;

    /**
     * The method sendRequestPrivateNetworkResponse() sends a response of a
     * previous method invocation of 'RequestPrivateNetwork' back to the
     * client.
     *
     * <b>Documentation of 'RequestPrivateNetwork'</b>:
     *
     * If the meaning of "RequestPrivateNetwork" isn't clear, then there should be a description here.
     *
     * @param path If the meaning of "path" isn't clear, then there should be a description here.
     *
     * @param settings If the meaning of "settings" isn't clear, then there should be a description here.
     *
     * @param socket If the meaning of "socket" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onRequestPrivateNetwork(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendRequestPrivateNetworkResponse (const ::std::string& path, const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& settings, uint32 socket, act_t act = 0);

    /**
     * The method sendRequestPrivateNetworkError() sends an error response of
     * a previous method invocation of 'RequestPrivateNetwork' back to the
     * client.
     *
     * <b>Documentation of 'RequestPrivateNetwork'</b>:
     *
     * If the meaning of "RequestPrivateNetwork" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onRequestPrivateNetwork(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendRequestPrivateNetworkError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'ReleasePrivateNetwork'

    /**
     * The method onReleasePrivateNetwork() is called by ASF when a client
     * invokes the method 'ReleasePrivateNetwork'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendReleasePrivateNetwork() or sendReleasePrivateNetworkError() method.
     * Do not invoke this method on your own.
     *
     * <b>Documentation of 'ReleasePrivateNetwork'</b>:
     *
     * If the meaning of "ReleasePrivateNetwork" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onReleasePrivateNetworkRequest (const ::boost::shared_ptr< ReleasePrivateNetworkRequest >& request) = 0;

    /**
     * The method sendReleasePrivateNetworkResponse() sends a response of a
     * previous method invocation of 'ReleasePrivateNetwork' back to the
     * client.
     *
     * <b>Documentation of 'ReleasePrivateNetwork'</b>:
     *
     * If the meaning of "ReleasePrivateNetwork" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onReleasePrivateNetwork(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendReleasePrivateNetworkResponse (act_t act = 0);

    /**
     * The method sendReleasePrivateNetworkError() sends an error response of
     * a previous method invocation of 'ReleasePrivateNetwork' back to the
     * client.
     *
     * <b>Documentation of 'ReleasePrivateNetwork'</b>:
     *
     * If the meaning of "ReleasePrivateNetwork" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onReleasePrivateNetwork(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendReleasePrivateNetworkError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

private:
    void onGetAll(std::map<std::basic_string<char>, ::asf::dbus::DBusVariant>&) const;

    friend class ManagerStubDelegate;

    DECLARE_CLASS_LOGGER();
};

} // namespace Manager
} // namespace connman
} // namespace net

#endif // NET_CONNMAN_MANAGERSTUB_H
