/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DBusVariant.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "net/connman/Agent.h"
#include "net/connman/AgentDBus.h"
#include "net/connman/AgentJson.h"
#include "net/connman/AgentStub.h"
#include <map>
#include <string>

#include "asf/dbus/DBusMessage.h"

namespace net {
namespace connman {
namespace Agent {

DEFINE_CLASS_LOGGER("//xyz/net/connman/Agent", AgentStub);

static ::asf::dbus::DBusUtils::stringEntry methodsTable[] = {
    { 6, "Cancel", 4 },
    { 7, "Release", 0 },
    { 11, "ReportError", 1 },
    { 12, "RequestInput", 3 },
    { 14, "RequestBrowser", 2 },
};


class AgentStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    AgentStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    AgentStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    AgentStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "net.connman.Agent"),
          _logger(logger) {}

    virtual ~AgentStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void AgentStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    unsigned int methodIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (message.getMemberName().c_str(), message.getMemberName().length(), methodsTable, 5, methodIndex)) {
        switch (methodIndex) {
        case 0: {

            // method 'Release'

            LOG_DEBUG_STUB("process method '%s'", "Release");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ReleaseRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "Release", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ReleaseRequest > payload = ::boost::static_pointer_cast<ReleaseRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<AgentStub*>(getStub())->onReleaseRequest(payload);
            return;
        }
        case 1: {

            // method 'ReportError'

            LOG_DEBUG_STUB("process method '%s'", "ReportError");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ReportErrorRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "ReportError", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ReportErrorRequest > payload = ::boost::static_pointer_cast<ReportErrorRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<AgentStub*>(getStub())->onReportErrorRequest(payload);
            return;
        }
        case 2: {

            // method 'RequestBrowser'

            LOG_DEBUG_STUB("process method '%s'", "RequestBrowser");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RequestBrowserRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "RequestBrowser", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< RequestBrowserRequest > payload = ::boost::static_pointer_cast<RequestBrowserRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<AgentStub*>(getStub())->onRequestBrowserRequest(payload);
            return;
        }
        case 3: {

            // method 'RequestInput'

            LOG_DEBUG_STUB("process method '%s'", "RequestInput");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RequestInputRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "RequestInput", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< RequestInputRequest > payload = ::boost::static_pointer_cast<RequestInputRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<AgentStub*>(getStub())->onRequestInputRequest(payload);
            return;
        }
        case 4: {

            // method 'Cancel'

            LOG_DEBUG_STUB("process method '%s'", "Cancel");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CancelRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "Cancel", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< CancelRequest > payload = ::boost::static_pointer_cast<CancelRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<AgentStub*>(getStub())->onCancelRequest(payload);
            return;
        }
        default:
            break;
        }
    }
    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* AgentStubDelegate::introspect() const {
    return     "<interface name=\"net.connman.Agent\">\n"
            "      <method name=\"Release\"/>\n"
            "      <method name=\"ReportError\">\n"
            "        <arg direction=\"in\" name=\"service\" type=\"o\"/>\n"
            "        <arg direction=\"in\" name=\"error\" type=\"s\"/>\n"
            "      </method>\n"
            "      <method name=\"RequestBrowser\">\n"
            "        <arg direction=\"in\" name=\"service\" type=\"o\"/>\n"
            "        <arg direction=\"in\" name=\"url\" type=\"s\"/>\n"
            "      </method>\n"
            "      <method name=\"RequestInput\">\n"
            "        <arg direction=\"in\" name=\"service\" type=\"o\"/>\n"
            "        <arg direction=\"in\" name=\"fields\" type=\"a{sv}\"/>\n"
            "        <arg direction=\"out\" name=\"fields\" type=\"a{sv}\"/>\n"
            "      </method>\n"
            "      <method name=\"Cancel\"/>\n"
            "</interface>\n";
}

void AgentStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<AgentStub*>(getStub()))->onGetAll (properties);
}

void AgentStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    ((void)value);  // to get rid of unused variable warning
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void AgentStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

AgentStub::AgentStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new AgentStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

AgentStub::AgentStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new AgentStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

AgentStub::~AgentStub() {
    delete _stubDelegate;
}

void  AgentStub::sendReleaseResponse (act_t act) {
    ReleaseResponse* payload = new ReleaseResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "Release", ReleaseResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "Release", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  AgentStub::sendReleaseError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ReleaseError* payload = new ReleaseError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "Release", ReleaseError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "Release", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  AgentStub::sendReportErrorResponse (act_t act) {
    ReportErrorResponse* payload = new ReportErrorResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "ReportError", ReportErrorResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "ReportError", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  AgentStub::sendReportErrorError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ReportErrorError* payload = new ReportErrorError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "ReportError", ReportErrorError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "ReportError", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  AgentStub::sendRequestBrowserResponse (act_t act) {
    RequestBrowserResponse* payload = new RequestBrowserResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "RequestBrowser", RequestBrowserResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "RequestBrowser", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  AgentStub::sendRequestBrowserError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    RequestBrowserError* payload = new RequestBrowserError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "RequestBrowser", RequestBrowserError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "RequestBrowser", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  AgentStub::sendRequestInputResponse (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& fields, act_t act) {
    RequestInputResponse* payload = new RequestInputResponse(fields);
    DBUS_MESSAGE_REPLY(dbusMessage, "RequestInput", RequestInputResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "RequestInput", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  AgentStub::sendRequestInputError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    RequestInputError* payload = new RequestInputError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "RequestInput", RequestInputError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "RequestInput", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  AgentStub::sendCancelResponse (act_t act) {
    CancelResponse* payload = new CancelResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "Cancel", CancelResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "Cancel", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  AgentStub::sendCancelError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    CancelError* payload = new CancelError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "Cancel", CancelError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "Cancel", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void AgentStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {
    ((void)properties);  // to get rid of unused variable warning
}

} // namespace Agent
} // namespace connman
} // namespace net
