/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_BLUEZ_SEAMLESSPAIRINGSTUB_H
#define ORG_BLUEZ_SEAMLESSPAIRINGSTUB_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStub.h"
#include "asf/dbus/DBusVariant.h"
#include "boost/shared_ptr.hpp"
#include "org/bluez/SeamlessPairing.h"
#include <vector>

namespace org {
namespace bluez {
namespace SeamlessPairing {

class SeamlessPairingStubDelegate;

class SeamlessPairingStub : public ::asf::dbus::DBusStub
{
public:

    /**
     * Create an instance of the SeamlessPairingStub
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     */
    SeamlessPairingStub (const std::string& portName);

    /**
     * Create an instance of the SeamlessPairingStub
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     * @param objectPath the dbus object path, see
     * http://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-marshaling-object-path
     */
    SeamlessPairingStub (const std::string& portName, const std::string& objectPath);

    virtual ~SeamlessPairingStub();

    // signal 'ErrorCodeReceived'

    /**
     * Raise the signal 'ErrorCodeReceived' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'ErrorCodeReceived'</b>:
     *
     * If the meaning of "ErrorCodeReceived" isn't clear, then there should be a description here.
     */
    void sendErrorCodeReceivedSignal(uint8 status);

    // signal 'AccessRequest'

    /**
     * Raise the signal 'AccessRequest' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'AccessRequest'</b>:
     *
     * If the meaning of "AccessRequest" isn't clear, then there should be a description here.
     */
    void sendAccessRequestSignal();

    // property 'PairingData'

    /**
     * The method onPairingDataGet() is called by ASF when a client invokes
     * the read method for the property 'PairingData'. The onPairingDataGet()
     * method returns by default the current property value to the caller. In
     * case this default behavior doesn't match your needs feel free to
     * override this method.
     *
     * <b>Documentation of 'PairingData'</b>:
     *
     * If the meaning of "PairingData" isn't clear, then there should be a description here.
     */
    virtual void onPairingDataGet(const ::boost::shared_ptr< PairingDataGet >& payload);

    /**
     * Sends back the update to a previous onPairingDataGet().
     *
     * <b>Documentation of 'PairingData'</b>:
     *
     * If the meaning of "PairingData" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onPairingDataGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendPairingDataGetUpdate(const ::std::vector< uint8 >& pairingData, act_t act = 0);

    /**
     * The method onPairingDataSet() is called by ASF when a client invokes
     * the write method for the property 'PairingData'. The onPairingDataSet()
     * method set property value to the given parameter PairingData by
     * default. If this default behavior doesn't match your needs feel free to
     * override this method.
     *
     * <b>Documentation of 'PairingData'</b>:
     *
     * If the meaning of "PairingData" isn't clear, then there should be a description here.
     */
    virtual void onPairingDataSet(const ::boost::shared_ptr< PairingDataSet >& payload);

    /**
     * Sends back the update to a previous onPairingDataSet().
     *
     * <b>Documentation of 'PairingData'</b>:
     *
     * If the meaning of "PairingData" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onPairingDataSet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendPairingDataSetUpdate(act_t act = 0);

    /**
     * Set the value of the property 'PairingData' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'PairingData'</b>:
     *
     * If the meaning of "PairingData" isn't clear, then there should be a description here.
     */
    void setPairingData(const ::std::vector< uint8 >& pairingData);

    /**
     * Returns the current value of the property 'PairingData'.
     *
     * <b>Documentation of 'PairingData'</b>:
     *
     * If the meaning of "PairingData" isn't clear, then there should be a description here.
     */
    const ::std::vector< uint8 >& getPairingData() const;

    /**
     * Returns the current value of the property 'PairingData' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendPairingDataUpdate() method.
     *
     * <b>Documentation of 'PairingData'</b>:
     *
     * If the meaning of "PairingData" isn't clear, then there should be a description here.
     */
    ::std::vector< uint8 >& getPairingDataMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendPairingDataUpdate().
     *
     * <b>Documentation of 'PairingData'</b>:
     *
     * If the meaning of "PairingData" isn't clear, then there should be a description here.
     */
    void sendPairingDataUpdate();

    // method 'SendErrorCode'

    /**
     * The method onSendErrorCode() is called by ASF when a client invokes the
     * method 'SendErrorCode'. A subclass has to implement this method and
     * send back a response to the client either with the sendSendErrorCode()
     * or sendSendErrorCodeError() method. Do not invoke this method on your
     * own.
     *
     * <b>Documentation of 'SendErrorCode'</b>:
     *
     * If the meaning of "SendErrorCode" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onSendErrorCodeRequest (const ::boost::shared_ptr< SendErrorCodeRequest >& request) = 0;

    /**
     * The method sendSendErrorCodeResponse() sends a response of a previous
     * method invocation of 'SendErrorCode' back to the client.
     *
     * <b>Documentation of 'SendErrorCode'</b>:
     *
     * If the meaning of "SendErrorCode" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onSendErrorCode(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendSendErrorCodeResponse (act_t act = 0);

    /**
     * The method sendSendErrorCodeError() sends an error response of a
     * previous method invocation of 'SendErrorCode' back to the client.
     *
     * <b>Documentation of 'SendErrorCode'</b>:
     *
     * If the meaning of "SendErrorCode" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onSendErrorCode(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendSendErrorCodeError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'AllowAccess'

    /**
     * The method onAllowAccess() is called by ASF when a client invokes the
     * method 'AllowAccess'. A subclass has to implement this method and send
     * back a response to the client either with the sendAllowAccess() or
     * sendAllowAccessError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'AllowAccess'</b>:
     *
     * If the meaning of "AllowAccess" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onAllowAccessRequest (const ::boost::shared_ptr< AllowAccessRequest >& request) = 0;

    /**
     * The method sendAllowAccessResponse() sends a response of a previous
     * method invocation of 'AllowAccess' back to the client.
     *
     * <b>Documentation of 'AllowAccess'</b>:
     *
     * If the meaning of "AllowAccess" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onAllowAccess(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendAllowAccessResponse (act_t act = 0);

    /**
     * The method sendAllowAccessError() sends an error response of a previous
     * method invocation of 'AllowAccess' back to the client.
     *
     * <b>Documentation of 'AllowAccess'</b>:
     *
     * If the meaning of "AllowAccess" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onAllowAccess(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendAllowAccessError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

private:
    void onGetAll(std::map<std::basic_string<char>, ::asf::dbus::DBusVariant>&) const;

    PairingDataUpdate _PairingDataProperty;

    friend class SeamlessPairingStubDelegate;

    DECLARE_CLASS_LOGGER();
};

} // namespace SeamlessPairing
} // namespace bluez
} // namespace org

#endif // ORG_BLUEZ_SEAMLESSPAIRINGSTUB_H
