/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "org/bluez/SeamlessPairing.h"
#include "org/bluez/SeamlessPairingDBus.h"
#include "org/bluez/SeamlessPairingJson.h"
#include "org/bluez/SeamlessPairingStub.h"
#include <vector>

#include "asf/dbus/DBusMessage.h"

namespace org {
namespace bluez {
namespace SeamlessPairing {

DEFINE_CLASS_LOGGER("//org/bluez/hci1/dev_addr/created/during/runtime/org/bluez/SeamlessPairing", SeamlessPairingStub);

static ::asf::dbus::DBusUtils::stringEntry methodsTable[] = {
    { 11, "AllowAccess", 1 },
    { 13, "SendErrorCode", 0 },
};

static ::asf::dbus::DBusUtils::stringEntry propertiesTable[] = {
    { 11, "PairingData", 0 },
};

class SeamlessPairingStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    SeamlessPairingStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    SeamlessPairingStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    SeamlessPairingStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "org.bluez.SeamlessPairing"),
          _logger(logger) {}

    virtual ~SeamlessPairingStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void SeamlessPairingStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    unsigned int methodIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (message.getMemberName().c_str(), message.getMemberName().length(), methodsTable, 2, methodIndex)) {
        switch (methodIndex) {
        case 0: {

            // method 'SendErrorCode'

            LOG_DEBUG_STUB("process method '%s'", "SendErrorCode");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SendErrorCodeRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SendErrorCode", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SendErrorCodeRequest > payload = ::boost::static_pointer_cast<SendErrorCodeRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<SeamlessPairingStub*>(getStub())->onSendErrorCodeRequest(payload);
            return;
        }
        case 1: {

            // method 'AllowAccess'

            LOG_DEBUG_STUB("process method '%s'", "AllowAccess");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AllowAccessRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "AllowAccess", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< AllowAccessRequest > payload = ::boost::static_pointer_cast<AllowAccessRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<SeamlessPairingStub*>(getStub())->onAllowAccessRequest(payload);
            return;
        }
        default:
            break;
        }
    }
    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* SeamlessPairingStubDelegate::introspect() const {
    return     "<interface name=\"org.bluez.SeamlessPairing\">\n"
            "      <method name=\"SendErrorCode\">\n"
            "        <arg direction=\"in\" name=\"error_code\" type=\"s\"/>\n"
            "      </method>\n"
            "      <method name=\"AllowAccess\">\n"
            "        <arg direction=\"in\" name=\"accept\" type=\"b\"/>\n"
            "      </method>\n"
            "      <signal name=\"ErrorCodeReceived\">\n"
            "        <arg name=\"status\" type=\"y\"/>\n"
            "      </signal>\n"
            "      <signal name=\"AccessRequest\"/>\n"
            "      <property access=\"readwrite\" name=\"PairingData\" type=\"ay\"/>\n"
            "</interface>\n";
}

void SeamlessPairingStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<SeamlessPairingStub*>(getStub()))->onGetAll (properties);
}

void SeamlessPairingStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 1, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "PairingData");
            ::boost::shared_ptr< PairingDataSet > payload(new PairingDataSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<SeamlessPairingStub*>(getStub())->onPairingDataSet (payload);
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void SeamlessPairingStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 1, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "PairingData");
            ::boost::shared_ptr< PairingDataGet > payload(new PairingDataGet());
            payload->setAct(act);
            static_cast<SeamlessPairingStub*>(getStub())->onPairingDataGet (payload);
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

SeamlessPairingStub::SeamlessPairingStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new SeamlessPairingStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

SeamlessPairingStub::SeamlessPairingStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new SeamlessPairingStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

SeamlessPairingStub::~SeamlessPairingStub() {
    delete _stubDelegate;
}

void SeamlessPairingStub::sendErrorCodeReceivedSignal(uint8 status) {
    if (_stubDelegate->isConnected()) {
        ErrorCodeReceivedSignal* payload = new ErrorCodeReceivedSignal(status);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "ErrorCodeReceived", ErrorCodeReceivedSignal, payload)
        LOG_INFO ("-> send%sSignal", "ErrorCodeReceived");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "ErrorCodeReceived");
    }
}

void SeamlessPairingStub::sendAccessRequestSignal() {
    if (_stubDelegate->isConnected()) {
        AccessRequestSignal* payload = new AccessRequestSignal;
        DBUS_MESSAGE_SIGNAL(dbusMessage, "AccessRequest", AccessRequestSignal, payload)
        LOG_INFO ("-> send%sSignal", "AccessRequest");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "AccessRequest");
    }
}

void SeamlessPairingStub::sendPairingDataUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        PairingDataUpdate payload(_PairingDataProperty);

        LOG_INFO ("-> send%s", "PairingDataUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("PairingData", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bluez.SeamlessPairing", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "PairingDataUpdate");
    }
}

void SeamlessPairingStub::onPairingDataGet(const ::boost::shared_ptr< PairingDataGet >& pairingData) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "PairingDataGet", pairingData->getAct());
    sendPairingDataGetUpdate(_PairingDataProperty.getPairingData(), pairingData->getAct());
}

void SeamlessPairingStub::sendPairingDataGetUpdate(const ::std::vector< uint8 >& pairingData, act_t act) {
    ::asf::dbus::DBusVariant variant;
    PairingDataGet payload(pairingData);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "PairingDataGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void SeamlessPairingStub::onPairingDataSet(const ::boost::shared_ptr< PairingDataSet >& pairingData) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "PairingDataSet", pairingData->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*pairingData, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setPairingData (pairingData->getPairingData());
    sendPairingDataSetUpdate(pairingData->getAct());
}

void SeamlessPairingStub::sendPairingDataSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "PairingDataSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void SeamlessPairingStub::setPairingData(const ::std::vector< uint8 >& pairingData) {
    if(pairingData!=_PairingDataProperty.getPairingData()) {
        _PairingDataProperty.setPairingData(pairingData);
        sendPairingDataUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< uint8 >& SeamlessPairingStub::getPairingData() const {
    return _PairingDataProperty.getPairingData();
}

::std::vector< uint8 >& SeamlessPairingStub::getPairingDataMutable() {
    return _PairingDataProperty.getPairingDataMutable();
}

void  SeamlessPairingStub::sendSendErrorCodeResponse (act_t act) {
    SendErrorCodeResponse* payload = new SendErrorCodeResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "SendErrorCode", SendErrorCodeResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SendErrorCode", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  SeamlessPairingStub::sendSendErrorCodeError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SendErrorCodeError* payload = new SendErrorCodeError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "SendErrorCode", SendErrorCodeError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SendErrorCode", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  SeamlessPairingStub::sendAllowAccessResponse (act_t act) {
    AllowAccessResponse* payload = new AllowAccessResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "AllowAccess", AllowAccessResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "AllowAccess", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  SeamlessPairingStub::sendAllowAccessError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    AllowAccessError* payload = new AllowAccessError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "AllowAccess", AllowAccessError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "AllowAccess", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void SeamlessPairingStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {

    //property 'PairingData'
    {
        ::asf::dbus::DBusVariant variant;
        PairingDataGet payload(_PairingDataProperty.getPairingData());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("PairingData", variant));
    }
}

} // namespace SeamlessPairing
} // namespace bluez
} // namespace org
