/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_BLUEZ_SEAMLESSPAIRINGPROXY_H
#define ORG_BLUEZ_SEAMLESSPAIRINGPROXY_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/nullable.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusProxy.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "org/bluez/SeamlessPairing.h"
#include <dbus/dbus.h>
#include <string>
#include <vector>

namespace org {
namespace bluez {
namespace SeamlessPairing {

class SeamlessPairingProxy;

class AccessRequestCallbackIF {
public:
    virtual ~AccessRequestCallbackIF() {}

    virtual void onAccessRequestError(const ::boost::shared_ptr< SeamlessPairingProxy >& proxy, const ::boost::shared_ptr< AccessRequestError >& error) = 0;

    virtual void onAccessRequestSignal(const ::boost::shared_ptr< SeamlessPairingProxy >& proxy, const ::boost::shared_ptr< AccessRequestSignal >& signal) = 0;
};

class AllowAccessCallbackIF {
public:
    virtual ~AllowAccessCallbackIF() {}

    virtual void onAllowAccessError(const ::boost::shared_ptr< SeamlessPairingProxy >& proxy, const ::boost::shared_ptr< AllowAccessError >& error) = 0;

    virtual void onAllowAccessResponse(const ::boost::shared_ptr< SeamlessPairingProxy >& proxy, const ::boost::shared_ptr< AllowAccessResponse >& response) = 0;
};

class ErrorCodeReceivedCallbackIF {
public:
    virtual ~ErrorCodeReceivedCallbackIF() {}

    virtual void onErrorCodeReceivedError(const ::boost::shared_ptr< SeamlessPairingProxy >& proxy, const ::boost::shared_ptr< ErrorCodeReceivedError >& error) = 0;

    virtual void onErrorCodeReceivedSignal(const ::boost::shared_ptr< SeamlessPairingProxy >& proxy, const ::boost::shared_ptr< ErrorCodeReceivedSignal >& signal) = 0;
};

class PairingDataCallbackIF {
public:
    virtual ~PairingDataCallbackIF() {}

    virtual void onPairingDataError(const ::boost::shared_ptr< SeamlessPairingProxy >& proxy, const ::boost::shared_ptr< PairingDataError >& error) = 0;

    virtual void onPairingDataUpdate(const ::boost::shared_ptr< SeamlessPairingProxy >& proxy, const ::boost::shared_ptr< PairingDataUpdate >& update) = 0;
};

class SendErrorCodeCallbackIF {
public:
    virtual ~SendErrorCodeCallbackIF() {}

    virtual void onSendErrorCodeError(const ::boost::shared_ptr< SeamlessPairingProxy >& proxy, const ::boost::shared_ptr< SendErrorCodeError >& error) = 0;

    virtual void onSendErrorCodeResponse(const ::boost::shared_ptr< SeamlessPairingProxy >& proxy, const ::boost::shared_ptr< SendErrorCodeResponse >& response) = 0;
};


/**
 * SeamlessPairingProxy is the client side representation of the D-Bus
 * service interface 'org.bluez.SeamlessPairing' (specified in file
 * ble_seamless_pairing.xml).
 *
 * If the meaning of "org.bluez.SeamlessPairing" isn't clear, then there should be a description here.
 */
class SeamlessPairingProxy : public ::asf::dbus::DBusProxy
{
public:
    /**
     * Create a new instance of SeamlessPairingProxy.
     */
    static ::boost::shared_ptr< SeamlessPairingProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Create a new instance of SeamlessPairingProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @deprecated use the createProxy() method with the parameter
     * ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector instead.
     */
    static ::boost::shared_ptr< SeamlessPairingProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        ::DBusBusType busType,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector connectorOptions;
        connectorOptions.setBusType(::asf::dbus::DBusUtils::toOptions(busType).getBusType());
        return createProxy(portName, busName, objectPath, connectorOptions, serviceAvailable);
    }

    /**
     * Create a new instance of SeamlessPairingProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     */
    static ::boost::shared_ptr< SeamlessPairingProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        const ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector& connectorOptions,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< SeamlessPairingProxy > proxyNew(new SeamlessPairingProxy(portName, serviceAvailable));
        ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew, busName, objectPath, connectorOptions);
        proxyNew->createHelperProxies(true);
        return proxyNew;
    }

    virtual ~SeamlessPairingProxy ();


    // Signal 'ErrorCodeReceived'

    /**
     * Notify on the signal 'ErrorCodeReceived'. This method registers for
     * signal changes by D-Bus service.
     *
     * <b>Documentation of 'ErrorCodeReceived'</b>:
     *
     * If the meaning of "ErrorCodeReceived" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendErrorCodeReceivedRegister(ErrorCodeReceivedCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'ErrorCodeReceived'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'ErrorCodeReceived'</b>:
     *
     * If the meaning of "ErrorCodeReceived" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendErrorCodeReceivedRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendErrorCodeReceivedDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'ErrorCodeReceived'.
     */
    void sendErrorCodeReceivedDeregisterAll () const;

    // Signal 'AccessRequest'

    /**
     * Notify on the signal 'AccessRequest'. This method registers for signal
     * changes by D-Bus service.
     *
     * <b>Documentation of 'AccessRequest'</b>:
     *
     * If the meaning of "AccessRequest" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAccessRequestRegister(AccessRequestCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'AccessRequest'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'AccessRequest'</b>:
     *
     * If the meaning of "AccessRequest" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendAccessRequestRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendAccessRequestDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'AccessRequest'.
     */
    void sendAccessRequestDeregisterAll () const;


    // Property 'PairingData'

    /**
     * Notify on the property 'PairingData'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'PairingData'</b>:
     *
     * If the meaning of "PairingData" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendPairingDataRegister(PairingDataCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'PairingData'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'PairingData'</b>:
     *
     * If the meaning of "PairingData" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendPairingDataRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendPairingDataDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'PairingData'.
     */
    void sendPairingDataDeregisterAll() const;

    /**
     * Request the value of the property 'PairingData' from the D-Bus server.
     * This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'PairingData'</b>:
     *
     * If the meaning of "PairingData" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendPairingDataGet(PairingDataCallbackIF& cb);

    /**
     * Set the value of the property 'PairingData'. This method sends a Set
     * message to the D-Bus server.
     *
     * @deprecated use the sendPairingDataSet(PairingDataCallbackIF& cb, const
     * ::std::vector< uint8 >& pairingData) method instead.
     *
     * <b>Documentation of 'PairingData'</b>:
     *
     * If the meaning of "PairingData" isn't clear, then there should be a description here.
     */
    void sendPairingDataSet(const ::std::vector< uint8 >& pairingData);

    /**
     * Set the value of the property 'PairingData'. This method sends a Set
     * message to the D-Bus server.
     *
     * <b>Documentation of 'PairingData'</b>:
     *
     * If the meaning of "PairingData" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Set message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendPairingDataSet(PairingDataCallbackIF& cb, const ::std::vector< uint8 >& pairingData);

    /**
     * Returns the current value of the property 'PairingData' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasPairingData() returns true.
     *
     * @return the previously received value of the property 'PairingData'.
     */
    const ::std::vector< uint8 >& getPairingData() const;

    /**
     * Determines whether a status message for the property 'PairingData' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasPairingData() const;


    // Method 'SendErrorCode'

    /**
     * Call the method 'SendErrorCode'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'SendErrorCode'</b>:
     *
     * If the meaning of "SendErrorCode" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param error_code If the meaning of "error_code" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSendErrorCodeRequest(SendErrorCodeCallbackIF& cb, const ::std::string& error_code) const;

    // Method 'AllowAccess'

    /**
     * Call the method 'AllowAccess'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'AllowAccess'</b>:
     *
     * If the meaning of "AllowAccess" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param accept If the meaning of "accept" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAllowAccessRequest(AllowAccessCallbackIF& cb, bool accept) const;

    /**
     * Release all property and signal notifications.
     */
    void sendDeregisterAll () const;

private:

    SeamlessPairingProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    act_t addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const;

    act_t addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const;

    virtual void clearAllProperties ();

    // Property 'PairingData'

    ::asf::core::nullable< PairingDataUpdate > _pairingData;

    DECLARE_CLASS_LOGGER();

    friend class SeamlessPairingProxyCallback;
};

} // namespace SeamlessPairing
} // namespace bluez
} // namespace org

#endif // ORG_BLUEZ_SEAMLESSPAIRINGPROXY_H
