#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_BLUEZ_SEAMLESSPAIRING_H
#define ORG_BLUEZ_SEAMLESSPAIRING_H

#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "asf/dbus/DBusTypes.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

/**
 * If the meaning of "SeamlessPairing" isn't clear, then there should be a description here.
 */

namespace org {
namespace bluez {
namespace SeamlessPairing {

// method IDs
static const uint16 ID_SendErrorCode = 0;
static const uint16 ID_AllowAccess = 1;

// signal IDs
static const uint16 ID_ErrorCodeReceived = 2;
static const uint16 ID_AccessRequest = 3;

// property IDs
static const uint16 ID_PairingData = 4;

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class SendErrorCodeRequest;

class AllowAccessRequest;

class PairingDataUpdate;

class PairingDataRegister;

class ErrorCodeReceivedSignal;

// type definitions
/**
 * If the meaning of "SendErrorCodeResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage SendErrorCodeResponse;

/**
 * If the meaning of "SendErrorCodeError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SendErrorCodeError;

/**
 * If the meaning of "AllowAccessResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage AllowAccessResponse;

/**
 * If the meaning of "AllowAccessError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError AllowAccessError;

/**
 * If the meaning of "PairingDataSet" isn't clear, then there should be a description here.
 */
typedef PairingDataUpdate PairingDataSet;

/**
 * If the meaning of "PairingDataGet" isn't clear, then there should be a description here.
 */
typedef PairingDataUpdate PairingDataGet;

/**
 * If the meaning of "PairingDataError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError PairingDataError;

/**
 * If the meaning of "ErrorCodeReceivedError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ErrorCodeReceivedError;

/**
 * If the meaning of "AccessRequestSignal" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage AccessRequestSignal;

/**
 * If the meaning of "AccessRequestError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError AccessRequestError;


/**
 * If the meaning of "SendErrorCodeRequest" isn't clear, then there should be a description here.
 */
class SendErrorCodeRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SendErrorCodeRequest ();

    /**
     * Copy constructor
     */
    inline  SendErrorCodeRequest (const SendErrorCodeRequest &rhs);

    /**
     * All fields constructor
     */
    inline  SendErrorCodeRequest (const ::std::string& error_code_);

    /**
     * Destructor
     */
    inline virtual  ~SendErrorCodeRequest();

    /**
     * Assignment operator
     */
    inline SendErrorCodeRequest& operator = (const SendErrorCodeRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SendErrorCodeRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SendErrorCodeRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SendErrorCodeRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SendErrorCodeRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "error_code"

    static const int kError_code = 0;

    /**
     * Clears the field "error_code".
     *
     * The field will be set to its default value. The hasError_code()
     * method will return false.
     */
    inline void clearError_code();

    /**
     * Checks whether the field "error_code" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setError_code()). Otherwise it will return false.
     */
    inline bool hasError_code () const;

    /**
     * Returns the value of the member "error_code".
     *
     * If the meaning of "error_code" isn't clear, then there should be a description here.
     *
     * @return The value of the field "error_code"
     */
    inline const ::std::string& getError_code () const;

    /**
     * Retrieves the value of the field "error_code" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "error_code".
     */
    inline ::std::string& getError_codeMutable ();

    /**
     * Sets the value of the member "error_code".
     *
     * If the meaning of "error_code" isn't clear, then there should be a description here.
     *
     * @param error_code The value which will be set
     */
    inline void setError_code (const ::std::string& error_code_);

    /**
     * Sets the value of the member "error_code".
     *
     * If the meaning of "error_code" isn't clear, then there should be a description here.
     *
     * @param error_code The value which will be set
     */
    inline void setError_code (const char* error_code_);

    /**
     * Sets the value of the member "error_code".
     *
     * If the meaning of "error_code" isn't clear, then there should be a description here.
     *
     * @param error_code The value which will be set
     */
    inline void setError_code (const char* value, size_t size);

    static const SendErrorCodeRequest &getDefaultInstance();

private:

    inline void set_has_error_code ();

    inline void clear_has_error_code ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _error_code;

};

/**
 * If the meaning of "AllowAccessRequest" isn't clear, then there should be a description here.
 */
class AllowAccessRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AllowAccessRequest ();

    /**
     * Copy constructor
     */
    inline  AllowAccessRequest (const AllowAccessRequest &rhs);

    /**
     * All fields constructor
     */
    inline  AllowAccessRequest (bool accept_);

    /**
     * Destructor
     */
    inline virtual  ~AllowAccessRequest();

    /**
     * Assignment operator
     */
    inline AllowAccessRequest& operator = (const AllowAccessRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AllowAccessRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AllowAccessRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AllowAccessRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AllowAccessRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "accept"

    static const int kAccept = 0;

    /**
     * Clears the field "accept".
     *
     * The field will be set to its default value. The hasAccept()
     * method will return false.
     */
    inline void clearAccept();

    /**
     * Checks whether the field "accept" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAccept()). Otherwise it will return false.
     */
    inline bool hasAccept () const;

    /**
     * Returns the value of the member "accept".
     *
     * If the meaning of "accept" isn't clear, then there should be a description here.
     *
     * @return The value of the field "accept"
     */
    inline bool getAccept () const;

    /**
     * Sets the value of the member "accept".
     *
     * If the meaning of "accept" isn't clear, then there should be a description here.
     *
     * @param accept The value which will be set
     */
    inline void setAccept (bool accept_);

    static const AllowAccessRequest &getDefaultInstance();

private:

    inline void set_has_accept ();

    inline void clear_has_accept ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _accept;

};

/**
 * If the meaning of "PairingDataUpdate" isn't clear, then there should be a description here.
 */
class PairingDataUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PairingDataUpdate ();

    /**
     * Copy constructor
     */
    inline  PairingDataUpdate (const PairingDataUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  PairingDataUpdate (const ::std::vector< uint8 >& PairingData_);

    /**
     * Destructor
     */
    inline virtual  ~PairingDataUpdate();

    /**
     * Assignment operator
     */
    inline PairingDataUpdate& operator = (const PairingDataUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PairingDataUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PairingDataUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PairingDataUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PairingDataUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "PairingData"

    static const int kPairingData = 0;

    /**
     * Clears the field "PairingData".
     *
     * The field will be set to its default value. The hasPairingData()
     * method will return false.
     */
    inline void clearPairingData();

    /**
     * Checks whether the field "PairingData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPairingData()). Otherwise it will return false.
     */
    inline bool hasPairingData () const;

    /**
     * Returns the value of the member "PairingData".
     *
     * If the meaning of "PairingData" isn't clear, then there should be a description here.
     *
     * @return The value of the field "PairingData"
     */
    inline const ::std::vector< uint8 >& getPairingData () const;

    /**
     * Retrieves the value of the field "PairingData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "PairingData".
     */
    inline ::std::vector< uint8 >& getPairingDataMutable ();

    /**
     * Sets the value of the member "PairingData".
     *
     * If the meaning of "PairingData" isn't clear, then there should be a description here.
     *
     * @param PairingData The value which will be set
     */
    inline void setPairingData (const ::std::vector< uint8 >& PairingData_);

    static const PairingDataUpdate &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_PairingData ();

    inline void clear_has_PairingData ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< uint8 > _PairingData;

};

/**
 * If the meaning of "PairingDataRegister" isn't clear, then there should be a description here.
 */
class PairingDataRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PairingDataRegister ();

    /**
     * Copy constructor
     */
    inline  PairingDataRegister (const PairingDataRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~PairingDataRegister();

    /**
     * Assignment operator
     */
    inline PairingDataRegister& operator = (const PairingDataRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PairingDataRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PairingDataRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PairingDataRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PairingDataRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const PairingDataRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "ErrorCodeReceivedSignal" isn't clear, then there should be a description here.
 */
class ErrorCodeReceivedSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ErrorCodeReceivedSignal ();

    /**
     * Copy constructor
     */
    inline  ErrorCodeReceivedSignal (const ErrorCodeReceivedSignal &rhs);

    /**
     * All fields constructor
     */
    inline  ErrorCodeReceivedSignal (uint8 status_);

    /**
     * Destructor
     */
    inline virtual  ~ErrorCodeReceivedSignal();

    /**
     * Assignment operator
     */
    inline ErrorCodeReceivedSignal& operator = (const ErrorCodeReceivedSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ErrorCodeReceivedSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ErrorCodeReceivedSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ErrorCodeReceivedSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ErrorCodeReceivedSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "status"

    static const int kStatus = 0;

    /**
     * Clears the field "status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @return The value of the field "status"
     */
    inline uint8 getStatus () const;

    /**
     * Sets the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @param status The value which will be set
     */
    inline void setStatus (uint8 status_);

    static const ErrorCodeReceivedSignal &getDefaultInstance();

private:

    inline void set_has_status ();

    inline void clear_has_status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _status;

};

inline  SendErrorCodeRequest::SendErrorCodeRequest ()  :
    _error_code ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SendErrorCodeRequest::SendErrorCodeRequest (const SendErrorCodeRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _error_code ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SendErrorCodeRequest::SendErrorCodeRequest (const ::std::string& error_code_)  :
    _error_code (error_code_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (error_code_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SendErrorCodeRequest::~SendErrorCodeRequest() {
}

inline SendErrorCodeRequest& SendErrorCodeRequest::operator = (const SendErrorCodeRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasError_code()) {
            setError_code(rhs.getError_code());
        } else {
            clearError_code();
        }
    }
    return *this;
}

inline bool SendErrorCodeRequest::operator == (const SendErrorCodeRequest& rhs) const {
    return (((!hasError_code() && !rhs.hasError_code()) || getError_code() == rhs.getError_code()));
}

inline bool SendErrorCodeRequest::operator != (const SendErrorCodeRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool SendErrorCodeRequest::operator < (const SendErrorCodeRequest& rhs) const {
    if (hasError_code() || rhs.hasError_code()) {
        if (getError_code() < rhs.getError_code()) return true;
        if (getError_code() > rhs.getError_code()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SendErrorCodeRequest::clone() {
    return new SendErrorCodeRequest(*this);
}

inline bool SendErrorCodeRequest::operator > (const SendErrorCodeRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SendErrorCodeRequest::clear() {
    clearError_code();
}

inline void SendErrorCodeRequest::clearError_code() {
    if (hasError_code()) {
         clear_has_error_code();
        _error_code.clear();
     }
}

inline bool SendErrorCodeRequest::hasError_code () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& SendErrorCodeRequest::getError_code () const {
    return _error_code;
}

inline ::std::string& SendErrorCodeRequest::getError_codeMutable () {
    set_has_error_code();
    return _error_code;
}

inline void SendErrorCodeRequest::setError_code (const ::std::string& error_code_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (error_code_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_error_code();
    this->_error_code = error_code_;
}

inline void SendErrorCodeRequest::setError_code (const char* error_code_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (error_code_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_error_code();
    this->_error_code.assign(error_code_);
}

inline void SendErrorCodeRequest::setError_code (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_error_code();
    this->_error_code.assign(value, size);
}

inline void SendErrorCodeRequest::set_has_error_code () {
    _has_bits_[0] |= 1u << 0;
}

inline void SendErrorCodeRequest::clear_has_error_code () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  AllowAccessRequest::AllowAccessRequest ()  :
    _accept (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AllowAccessRequest::AllowAccessRequest (const AllowAccessRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _accept (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AllowAccessRequest::AllowAccessRequest (bool accept_)  :
    _accept (accept_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AllowAccessRequest::~AllowAccessRequest() {
}

inline AllowAccessRequest& AllowAccessRequest::operator = (const AllowAccessRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAccept()) {
            setAccept(rhs.getAccept());
        } else {
            clearAccept();
        }
    }
    return *this;
}

inline bool AllowAccessRequest::operator == (const AllowAccessRequest& rhs) const {
    return (((!hasAccept() && !rhs.hasAccept()) || getAccept() == rhs.getAccept()));
}

inline bool AllowAccessRequest::operator != (const AllowAccessRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool AllowAccessRequest::operator < (const AllowAccessRequest& rhs) const {
    if (hasAccept() || rhs.hasAccept()) {
        if (getAccept() < rhs.getAccept()) return true;
        if (getAccept() > rhs.getAccept()) return false;
    }
    return false;
}

inline ::asf::core::Payload* AllowAccessRequest::clone() {
    return new AllowAccessRequest(*this);
}

inline bool AllowAccessRequest::operator > (const AllowAccessRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AllowAccessRequest::clear() {
    clearAccept();
}

inline void AllowAccessRequest::clearAccept() {
    if (hasAccept()) {
         clear_has_accept();
        _accept = false;
     }
}

inline bool AllowAccessRequest::hasAccept () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool AllowAccessRequest::getAccept () const {
    return _accept;
}

inline void AllowAccessRequest::setAccept (bool accept_) {
    set_has_accept();
    this->_accept = accept_;
}

inline void AllowAccessRequest::set_has_accept () {
    _has_bits_[0] |= 1u << 0;
}

inline void AllowAccessRequest::clear_has_accept () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  PairingDataUpdate::PairingDataUpdate ()  :
    _PairingData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  PairingDataUpdate::PairingDataUpdate (const PairingDataUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _PairingData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  PairingDataUpdate::PairingDataUpdate (const ::std::vector< uint8 >& PairingData_)  :
    _PairingData (PairingData_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  PairingDataUpdate::~PairingDataUpdate() {
}

inline PairingDataUpdate& PairingDataUpdate::operator = (const PairingDataUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPairingData()) {
            setPairingData(rhs.getPairingData());
        } else {
            clearPairingData();
        }
    }
    return *this;
}

inline bool PairingDataUpdate::operator == (const PairingDataUpdate& rhs) const {
    return (((!hasPairingData() && !rhs.hasPairingData()) || getPairingData() == rhs.getPairingData()));
}

inline bool PairingDataUpdate::operator != (const PairingDataUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool PairingDataUpdate::operator < (const PairingDataUpdate& rhs) const {
    if (hasPairingData() || rhs.hasPairingData()) {
        if (getPairingData() < rhs.getPairingData()) return true;
        if (getPairingData() > rhs.getPairingData()) return false;
    }
    return false;
}

inline ::asf::core::Payload* PairingDataUpdate::clone() {
    return new PairingDataUpdate(*this);
}

inline bool PairingDataUpdate::operator > (const PairingDataUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void PairingDataUpdate::clear() {
    clearPairingData();
}

inline void PairingDataUpdate::clearPairingData() {
    if (hasPairingData()) {
         clear_has_PairingData();
        _PairingData.clear();
     }
}

inline bool PairingDataUpdate::hasPairingData () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< uint8 >& PairingDataUpdate::getPairingData () const {
    return _PairingData;
}

inline ::std::vector< uint8 >& PairingDataUpdate::getPairingDataMutable () {
    set_has_PairingData();
    return _PairingData;
}

inline void PairingDataUpdate::setPairingData (const ::std::vector< uint8 >& PairingData_) {
    set_has_PairingData();
    this->_PairingData = PairingData_;
}

inline void PairingDataUpdate::set_has_PairingData () {
    _has_bits_[0] |= 1u << 0;
}

inline void PairingDataUpdate::clear_has_PairingData () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  PairingDataRegister::PairingDataRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  PairingDataRegister::PairingDataRegister (const PairingDataRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  PairingDataRegister::~PairingDataRegister() {
}

inline PairingDataRegister& PairingDataRegister::operator = (const PairingDataRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool PairingDataRegister::operator == (const PairingDataRegister& ) const {
    return true;
}

inline bool PairingDataRegister::operator != (const PairingDataRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool PairingDataRegister::operator < (const PairingDataRegister& ) const {
    return false;
}

inline ::asf::core::Payload* PairingDataRegister::clone() {
    return new PairingDataRegister(*this);
}

inline bool PairingDataRegister::operator > (const PairingDataRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void PairingDataRegister::clear() {
}

inline  ErrorCodeReceivedSignal::ErrorCodeReceivedSignal ()  :
    _status (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ErrorCodeReceivedSignal::ErrorCodeReceivedSignal (const ErrorCodeReceivedSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _status (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ErrorCodeReceivedSignal::ErrorCodeReceivedSignal (uint8 status_)  :
    _status (status_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ErrorCodeReceivedSignal::~ErrorCodeReceivedSignal() {
}

inline ErrorCodeReceivedSignal& ErrorCodeReceivedSignal::operator = (const ErrorCodeReceivedSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool ErrorCodeReceivedSignal::operator == (const ErrorCodeReceivedSignal& rhs) const {
    return (((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool ErrorCodeReceivedSignal::operator != (const ErrorCodeReceivedSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool ErrorCodeReceivedSignal::operator < (const ErrorCodeReceivedSignal& rhs) const {
    if (hasStatus() || rhs.hasStatus()) {
        if (getStatus() < rhs.getStatus()) return true;
        if (getStatus() > rhs.getStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ErrorCodeReceivedSignal::clone() {
    return new ErrorCodeReceivedSignal(*this);
}

inline bool ErrorCodeReceivedSignal::operator > (const ErrorCodeReceivedSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ErrorCodeReceivedSignal::clear() {
    clearStatus();
}

inline void ErrorCodeReceivedSignal::clearStatus() {
    if (hasStatus()) {
         clear_has_status();
        _status = 0u;
     }
}

inline bool ErrorCodeReceivedSignal::hasStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 ErrorCodeReceivedSignal::getStatus () const {
    return _status;
}

inline void ErrorCodeReceivedSignal::setStatus (uint8 status_) {
    set_has_status();
    this->_status = status_;
}

inline void ErrorCodeReceivedSignal::set_has_status () {
    _has_bits_[0] |= 1u << 0;
}

inline void ErrorCodeReceivedSignal::clear_has_status () {
    _has_bits_[0] &= ~ (1u << 0);
}

} // namespace SeamlessPairing
} // namespace bluez
} // namespace org

#endif // ORG_BLUEZ_SEAMLESSPAIRING_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
