/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_BLUEZ_LE_DEVICE1STUB_H
#define ORG_BLUEZ_LE_DEVICE1STUB_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStub.h"
#include "asf/dbus/DBusVariant.h"
#include "boost/shared_ptr.hpp"
#include "org/bluez/LE_Device1.h"
#include <string>

namespace org {
namespace bluez {
namespace LE_Device1 {

class LE_Device1StubDelegate;

class LE_Device1Stub : public ::asf::dbus::DBusStub
{
public:

    /**
     * Create an instance of the LE_Device1Stub
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     */
    LE_Device1Stub (const std::string& portName);

    /**
     * Create an instance of the LE_Device1Stub
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     * @param objectPath the dbus object path, see
     * http://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-marshaling-object-path
     */
    LE_Device1Stub (const std::string& portName, const std::string& objectPath);

    virtual ~LE_Device1Stub();

    // signal 'DisconnectionComp'

    /**
     * Raise the signal 'DisconnectionComp' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'DisconnectionComp'</b>:
     *
     * If the meaning of "DisconnectionComp" isn't clear, then there should be a description here.
     */
    void sendDisconnectionCompSignal(uint8 status, uint8 reason);

    // property 'AddressType'

    /**
     * The method onAddressTypeGet() is called by ASF when a client invokes
     * the read method for the property 'AddressType'. The onAddressTypeGet()
     * method returns by default the current property value to the caller. In
     * case this default behavior doesn't match your needs feel free to
     * override this method.
     *
     * <b>Documentation of 'AddressType'</b>:
     *
     * If the meaning of "AddressType" isn't clear, then there should be a description here.
     */
    virtual void onAddressTypeGet(const ::boost::shared_ptr< AddressTypeGet >& payload);

    /**
     * Sends back the update to a previous onAddressTypeGet().
     *
     * <b>Documentation of 'AddressType'</b>:
     *
     * If the meaning of "AddressType" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onAddressTypeGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendAddressTypeGetUpdate(uint8 addressType, act_t act = 0);

    /**
     * Set the value of the property 'AddressType' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'AddressType'</b>:
     *
     * If the meaning of "AddressType" isn't clear, then there should be a description here.
     */
    void setAddressType(uint8 addressType);

    /**
     * Returns the current value of the property 'AddressType'.
     *
     * <b>Documentation of 'AddressType'</b>:
     *
     * If the meaning of "AddressType" isn't clear, then there should be a description here.
     */
    uint8 getAddressType() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendAddressTypeUpdate().
     *
     * <b>Documentation of 'AddressType'</b>:
     *
     * If the meaning of "AddressType" isn't clear, then there should be a description here.
     */
    void sendAddressTypeUpdate();

    // property 'Address'

    /**
     * The method onAddressGet() is called by ASF when a client invokes the
     * read method for the property 'Address'. The onAddressGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'Address'</b>:
     *
     * If the meaning of "Address" isn't clear, then there should be a description here.
     */
    virtual void onAddressGet(const ::boost::shared_ptr< AddressGet >& payload);

    /**
     * Sends back the update to a previous onAddressGet().
     *
     * <b>Documentation of 'Address'</b>:
     *
     * If the meaning of "Address" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onAddressGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendAddressGetUpdate(const ::std::string& address, act_t act = 0);

    /**
     * Set the value of the property 'Address' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'Address'</b>:
     *
     * If the meaning of "Address" isn't clear, then there should be a description here.
     */
    void setAddress(const ::std::string& address);

    /**
     * Returns the current value of the property 'Address'.
     *
     * <b>Documentation of 'Address'</b>:
     *
     * If the meaning of "Address" isn't clear, then there should be a description here.
     */
    const ::std::string& getAddress() const;

    /**
     * Returns the current value of the property 'Address' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendAddressUpdate() method.
     *
     * <b>Documentation of 'Address'</b>:
     *
     * If the meaning of "Address" isn't clear, then there should be a description here.
     */
    ::std::string& getAddressMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendAddressUpdate().
     *
     * <b>Documentation of 'Address'</b>:
     *
     * If the meaning of "Address" isn't clear, then there should be a description here.
     */
    void sendAddressUpdate();

    // property 'Connected'

    /**
     * The method onConnectedGet() is called by ASF when a client invokes the
     * read method for the property 'Connected'. The onConnectedGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'Connected'</b>:
     *
     * If the meaning of "Connected" isn't clear, then there should be a description here.
     */
    virtual void onConnectedGet(const ::boost::shared_ptr< ConnectedGet >& payload);

    /**
     * Sends back the update to a previous onConnectedGet().
     *
     * <b>Documentation of 'Connected'</b>:
     *
     * If the meaning of "Connected" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onConnectedGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendConnectedGetUpdate(bool connected, act_t act = 0);

    /**
     * Set the value of the property 'Connected' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'Connected'</b>:
     *
     * If the meaning of "Connected" isn't clear, then there should be a description here.
     */
    void setConnected(bool connected);

    /**
     * Returns the current value of the property 'Connected'.
     *
     * <b>Documentation of 'Connected'</b>:
     *
     * If the meaning of "Connected" isn't clear, then there should be a description here.
     */
    bool getConnected() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendConnectedUpdate().
     *
     * <b>Documentation of 'Connected'</b>:
     *
     * If the meaning of "Connected" isn't clear, then there should be a description here.
     */
    void sendConnectedUpdate();

    // method 'Disconnect'

    /**
     * The method onDisconnect() is called by ASF when a client invokes the
     * method 'Disconnect'. A subclass has to implement this method and send
     * back a response to the client either with the sendDisconnect() or
     * sendDisconnectError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'Disconnect'</b>:
     *
     * If the meaning of "Disconnect" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onDisconnectRequest (const ::boost::shared_ptr< DisconnectRequest >& request) = 0;

    /**
     * The method sendDisconnectResponse() sends a response of a previous
     * method invocation of 'Disconnect' back to the client.
     *
     * <b>Documentation of 'Disconnect'</b>:
     *
     * If the meaning of "Disconnect" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onDisconnect(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendDisconnectResponse (act_t act = 0);

    /**
     * The method sendDisconnectError() sends an error response of a previous
     * method invocation of 'Disconnect' back to the client.
     *
     * <b>Documentation of 'Disconnect'</b>:
     *
     * If the meaning of "Disconnect" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onDisconnect(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendDisconnectError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

private:
    void onGetAll(std::map<std::basic_string<char>, ::asf::dbus::DBusVariant>&) const;

    AddressTypeUpdate _AddressTypeProperty;

    AddressUpdate _AddressProperty;

    ConnectedUpdate _ConnectedProperty;

    friend class LE_Device1StubDelegate;

    DECLARE_CLASS_LOGGER();
};

} // namespace LE_Device1
} // namespace bluez
} // namespace org

#endif // ORG_BLUEZ_LE_DEVICE1STUB_H
