/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "org/bluez/LE_Device1.h"
#include "org/bluez/LE_Device1DBus.h"
#include "org/bluez/LE_Device1Json.h"
#include "org/bluez/LE_Device1Proxy.h"
#include <string>

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace org {
namespace bluez {
namespace LE_Device1 {

DEFINE_CLASS_LOGGER("//org/bluez/hci1/dev_addr/created/during/runtime/org/bluez/LE_Device1", LE_Device1Proxy);

class LE_Device1ProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    LE_Device1ProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< LE_Device1Proxy >& proxyShared = ::boost::static_pointer_cast< LE_Device1Proxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_DisconnectionComp:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DisconnectionCompSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "DisconnectionComp", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<DisconnectionCompSignal> payload = ::boost::static_pointer_cast<DisconnectionCompSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((DisconnectionCompCallbackIF*) _callback)->onDisconnectionCompSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_AddressType:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AddressTypeError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "AddressType", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AddressTypeError> payload = ::boost::static_pointer_cast<AddressTypeError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((AddressTypeCallbackIF*) _callback)->onAddressTypeError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AddressTypeUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "AddressType", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AddressTypeUpdate> payload = ::boost::static_pointer_cast<AddressTypeUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((AddressTypeCallbackIF*) _callback)->onAddressTypeUpdate(proxyShared, payload);
                        proxyShared->_addressType = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_Address:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AddressError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Address", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AddressError> payload = ::boost::static_pointer_cast<AddressError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((AddressCallbackIF*) _callback)->onAddressError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AddressUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Address", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AddressUpdate> payload = ::boost::static_pointer_cast<AddressUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((AddressCallbackIF*) _callback)->onAddressUpdate(proxyShared, payload);
                        proxyShared->_address = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_Connected:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ConnectedError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Connected", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ConnectedError> payload = ::boost::static_pointer_cast<ConnectedError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((ConnectedCallbackIF*) _callback)->onConnectedError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ConnectedUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Connected", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ConnectedUpdate> payload = ::boost::static_pointer_cast<ConnectedUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((ConnectedCallbackIF*) _callback)->onConnectedUpdate(proxyShared, payload);
                        proxyShared->_connected = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_Disconnect:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), DisconnectError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "Disconnect", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DisconnectError> payload = ::boost::static_pointer_cast<DisconnectError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((DisconnectCallbackIF*) _callback)->onDisconnectError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DisconnectResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "Disconnect", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DisconnectResponse> payload = ::boost::static_pointer_cast<DisconnectResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((DisconnectCallbackIF*) _callback)->onDisconnectResponse (proxyShared, payload);
                        return true;
                    }
                }
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_DisconnectionComp: {
                ::boost::shared_ptr< DisconnectionCompError > payload = ::boost::shared_ptr< DisconnectionCompError >
                (new DisconnectionCompError(DBUS_ERROR_NO_SERVER, "The DBus service LE_Device1 is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "DisconnectionComp", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<LE_Device1Proxy> proxyShared = ::boost::static_pointer_cast<LE_Device1Proxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((DisconnectionCompCallbackIF*) _callback)->onDisconnectionCompError (proxyShared,payload);
                return true;
            }
            break;
            case ID_AddressType: {
                ::boost::shared_ptr< AddressTypeError > payload = ::boost::shared_ptr< AddressTypeError >
                (new AddressTypeError(DBUS_ERROR_NO_SERVER, "The DBus service LE_Device1 is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "AddressType", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<LE_Device1Proxy> proxyShared = ::boost::static_pointer_cast<LE_Device1Proxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((AddressTypeCallbackIF*) _callback)->onAddressTypeError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Address: {
                ::boost::shared_ptr< AddressError > payload = ::boost::shared_ptr< AddressError >
                (new AddressError(DBUS_ERROR_NO_SERVER, "The DBus service LE_Device1 is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Address", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<LE_Device1Proxy> proxyShared = ::boost::static_pointer_cast<LE_Device1Proxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((AddressCallbackIF*) _callback)->onAddressError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Connected: {
                ::boost::shared_ptr< ConnectedError > payload = ::boost::shared_ptr< ConnectedError >
                (new ConnectedError(DBUS_ERROR_NO_SERVER, "The DBus service LE_Device1 is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Connected", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<LE_Device1Proxy> proxyShared = ::boost::static_pointer_cast<LE_Device1Proxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ConnectedCallbackIF*) _callback)->onConnectedError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Disconnect: {
                ::boost::shared_ptr< DisconnectError > payload = ::boost::shared_ptr< DisconnectError >
                (new DisconnectError(DBUS_ERROR_NO_SERVER, "The DBus service LE_Device1 is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Disconnect", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<LE_Device1Proxy> proxyShared = ::boost::static_pointer_cast<LE_Device1Proxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((DisconnectCallbackIF*) _callback)->onDisconnectError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& LE_Device1ProxyCallback::_logger (LE_Device1Proxy::_logger);

LE_Device1Proxy::LE_Device1Proxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "org.bluez.LE_Device1", serviceAvailable, _logger) {
}

LE_Device1Proxy::~LE_Device1Proxy()
{
    sendDeregisterAll();
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< LE_Device1Proxy > LE_Device1Proxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<LE_Device1Proxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< LE_Device1Proxy > proxyNew(new LE_Device1Proxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(true);
    return proxyNew;
}

act_t LE_Device1Proxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    LE_Device1ProxyCallback* callback = new LE_Device1ProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t LE_Device1Proxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    LE_Device1ProxyCallback* callback = new LE_Device1ProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void LE_Device1Proxy::clearAllProperties ()
{
    _addressType = ::asf::core::nullable< AddressTypeUpdate >();
    _address = ::asf::core::nullable< AddressUpdate >();
    _connected = ::asf::core::nullable< ConnectedUpdate >();
}

void LE_Device1Proxy::sendDeregisterAll () const
{
    sendAddressTypeDeregisterAll();
    sendAddressDeregisterAll();
    sendConnectedDeregisterAll();
    sendDisconnectionCompDeregisterAll();
}

act_t LE_Device1Proxy::sendDisconnectionCompRegister(DisconnectionCompCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "DisconnectionComp");
    act_t act = addSignalCallback(ID_DisconnectionComp, "DisconnectionComp", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "DisconnectionComp", &cb, act);
    return act;
}

bool LE_Device1Proxy::sendDisconnectionCompDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("DisconnectionComp", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "DisconnectionComp", act, static_cast<int>(rv));
    return rv;
}

void LE_Device1Proxy::sendDisconnectionCompDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "DisconnectionComp");
    _dbusProxyDelegate->deregisterSignalCallback("DisconnectionComp", 0, _dbusDaemonProxy.get(), false);
}

act_t LE_Device1Proxy::sendAddressTypeRegister(AddressTypeCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_AddressType, "AddressType", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "AddressType", &cb, act);
    return act;
}

bool LE_Device1Proxy::sendAddressTypeDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("AddressType", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "AddressType", act, static_cast<int>(rv));
    return rv;
}

act_t LE_Device1Proxy::sendAddressTypeGet(AddressTypeCallbackIF& cb) {
    LE_Device1ProxyCallback* callback = new LE_Device1ProxyCallback(ID_AddressType, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "AddressType", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("AddressType", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint8 LE_Device1Proxy::getAddressType() const {
    return _addressType.get().getAddressType();
}

bool LE_Device1Proxy::hasAddressType() const {
    return _addressType.hasValue();
}

void LE_Device1Proxy::sendAddressTypeDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "AddressType");
    _dbusProxyDelegate->deregisterSignalCallback("AddressType", 0, _dbusDaemonProxy.get(), true);
}

act_t LE_Device1Proxy::sendAddressRegister(AddressCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_Address, "Address", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Address", &cb, act);
    return act;
}

bool LE_Device1Proxy::sendAddressDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("Address", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Address", act, static_cast<int>(rv));
    return rv;
}

act_t LE_Device1Proxy::sendAddressGet(AddressCallbackIF& cb) {
    LE_Device1ProxyCallback* callback = new LE_Device1ProxyCallback(ID_Address, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "Address", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("Address", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::string& LE_Device1Proxy::getAddress() const {
    return _address.get().getAddress();
}

bool LE_Device1Proxy::hasAddress() const {
    return _address.hasValue();
}

void LE_Device1Proxy::sendAddressDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Address");
    _dbusProxyDelegate->deregisterSignalCallback("Address", 0, _dbusDaemonProxy.get(), true);
}

act_t LE_Device1Proxy::sendConnectedRegister(ConnectedCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_Connected, "Connected", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Connected", &cb, act);
    return act;
}

bool LE_Device1Proxy::sendConnectedDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("Connected", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Connected", act, static_cast<int>(rv));
    return rv;
}

act_t LE_Device1Proxy::sendConnectedGet(ConnectedCallbackIF& cb) {
    LE_Device1ProxyCallback* callback = new LE_Device1ProxyCallback(ID_Connected, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "Connected", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("Connected", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


bool LE_Device1Proxy::getConnected() const {
    return _connected.get().getConnected();
}

bool LE_Device1Proxy::hasConnected() const {
    return _connected.hasValue();
}

void LE_Device1Proxy::sendConnectedDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Connected");
    _dbusProxyDelegate->deregisterSignalCallback("Connected", 0, _dbusDaemonProxy.get(), true);
}

act_t LE_Device1Proxy::sendDisconnectRequest(DisconnectCallbackIF& cb) const {
    DisconnectRequest* payload = new DisconnectRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "Disconnect", DisconnectRequest, payload, true)
    act_t act = addMethodCallback(ID_Disconnect, dbusMessage.getUniqueSerial(), "Disconnect", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "Disconnect", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

} // namespace LE_Device1
} // namespace bluez
} // namespace org
