#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_BLUEZ_LE_DEVICE1_H
#define ORG_BLUEZ_LE_DEVICE1_H

#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "asf/dbus/DBusTypes.h"
#include <cstddef>
#include <cstring>
#include <string>

/**
 * If the meaning of "LE_Device1" isn't clear, then there should be a description here.
 */

namespace org {
namespace bluez {
namespace LE_Device1 {

// method IDs
static const uint16 ID_Disconnect = 0;

// signal IDs
static const uint16 ID_DisconnectionComp = 1;

// property IDs
static const uint16 ID_AddressType = 2;
static const uint16 ID_Address = 3;
static const uint16 ID_Connected = 4;

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class AddressTypeUpdate;

class AddressTypeRegister;

class AddressUpdate;

class AddressRegister;

class ConnectedUpdate;

class ConnectedRegister;

class DisconnectionCompSignal;

// type definitions
/**
 * If the meaning of "DisconnectRequest" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage DisconnectRequest;

/**
 * If the meaning of "DisconnectResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage DisconnectResponse;

/**
 * If the meaning of "DisconnectError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError DisconnectError;

/**
 * If the meaning of "AddressTypeSet" isn't clear, then there should be a description here.
 */
typedef AddressTypeUpdate AddressTypeSet;

/**
 * If the meaning of "AddressTypeGet" isn't clear, then there should be a description here.
 */
typedef AddressTypeUpdate AddressTypeGet;

/**
 * If the meaning of "AddressTypeError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError AddressTypeError;

/**
 * If the meaning of "AddressSet" isn't clear, then there should be a description here.
 */
typedef AddressUpdate AddressSet;

/**
 * If the meaning of "AddressGet" isn't clear, then there should be a description here.
 */
typedef AddressUpdate AddressGet;

/**
 * If the meaning of "AddressError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError AddressError;

/**
 * If the meaning of "ConnectedSet" isn't clear, then there should be a description here.
 */
typedef ConnectedUpdate ConnectedSet;

/**
 * If the meaning of "ConnectedGet" isn't clear, then there should be a description here.
 */
typedef ConnectedUpdate ConnectedGet;

/**
 * If the meaning of "ConnectedError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ConnectedError;

/**
 * If the meaning of "DisconnectionCompError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError DisconnectionCompError;


/**
 * If the meaning of "AddressTypeUpdate" isn't clear, then there should be a description here.
 */
class AddressTypeUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AddressTypeUpdate ();

    /**
     * Copy constructor
     */
    inline  AddressTypeUpdate (const AddressTypeUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  AddressTypeUpdate (uint8 AddressType_);

    /**
     * Destructor
     */
    inline virtual  ~AddressTypeUpdate();

    /**
     * Assignment operator
     */
    inline AddressTypeUpdate& operator = (const AddressTypeUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AddressTypeUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AddressTypeUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AddressTypeUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AddressTypeUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "AddressType"

    static const int kAddressType = 0;

    /**
     * Clears the field "AddressType".
     *
     * The field will be set to its default value. The hasAddressType()
     * method will return false.
     */
    inline void clearAddressType();

    /**
     * Checks whether the field "AddressType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAddressType()). Otherwise it will return false.
     */
    inline bool hasAddressType () const;

    /**
     * Returns the value of the member "AddressType".
     *
     * If the meaning of "AddressType" isn't clear, then there should be a description here.
     *
     * @return The value of the field "AddressType"
     */
    inline uint8 getAddressType () const;

    /**
     * Sets the value of the member "AddressType".
     *
     * If the meaning of "AddressType" isn't clear, then there should be a description here.
     *
     * @param AddressType The value which will be set
     */
    inline void setAddressType (uint8 AddressType_);

    static const AddressTypeUpdate &getDefaultInstance();

private:

    inline void set_has_AddressType ();

    inline void clear_has_AddressType ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _AddressType;

};

/**
 * If the meaning of "AddressTypeRegister" isn't clear, then there should be a description here.
 */
class AddressTypeRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AddressTypeRegister ();

    /**
     * Copy constructor
     */
    inline  AddressTypeRegister (const AddressTypeRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~AddressTypeRegister();

    /**
     * Assignment operator
     */
    inline AddressTypeRegister& operator = (const AddressTypeRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AddressTypeRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AddressTypeRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AddressTypeRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AddressTypeRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const AddressTypeRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "AddressUpdate" isn't clear, then there should be a description here.
 */
class AddressUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AddressUpdate ();

    /**
     * Copy constructor
     */
    inline  AddressUpdate (const AddressUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  AddressUpdate (const ::std::string& Address_);

    /**
     * Destructor
     */
    inline virtual  ~AddressUpdate();

    /**
     * Assignment operator
     */
    inline AddressUpdate& operator = (const AddressUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AddressUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AddressUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AddressUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AddressUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Address"

    static const int kAddress = 0;

    /**
     * Clears the field "Address".
     *
     * The field will be set to its default value. The hasAddress()
     * method will return false.
     */
    inline void clearAddress();

    /**
     * Checks whether the field "Address" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAddress()). Otherwise it will return false.
     */
    inline bool hasAddress () const;

    /**
     * Returns the value of the member "Address".
     *
     * If the meaning of "Address" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Address"
     */
    inline const ::std::string& getAddress () const;

    /**
     * Retrieves the value of the field "Address" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Address".
     */
    inline ::std::string& getAddressMutable ();

    /**
     * Sets the value of the member "Address".
     *
     * If the meaning of "Address" isn't clear, then there should be a description here.
     *
     * @param Address The value which will be set
     */
    inline void setAddress (const ::std::string& Address_);

    /**
     * Sets the value of the member "Address".
     *
     * If the meaning of "Address" isn't clear, then there should be a description here.
     *
     * @param Address The value which will be set
     */
    inline void setAddress (const char* Address_);

    /**
     * Sets the value of the member "Address".
     *
     * If the meaning of "Address" isn't clear, then there should be a description here.
     *
     * @param Address The value which will be set
     */
    inline void setAddress (const char* value, size_t size);

    static const AddressUpdate &getDefaultInstance();

private:

    inline void set_has_Address ();

    inline void clear_has_Address ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _Address;

};

/**
 * If the meaning of "AddressRegister" isn't clear, then there should be a description here.
 */
class AddressRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AddressRegister ();

    /**
     * Copy constructor
     */
    inline  AddressRegister (const AddressRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~AddressRegister();

    /**
     * Assignment operator
     */
    inline AddressRegister& operator = (const AddressRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AddressRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AddressRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AddressRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AddressRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const AddressRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "ConnectedUpdate" isn't clear, then there should be a description here.
 */
class ConnectedUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ConnectedUpdate ();

    /**
     * Copy constructor
     */
    inline  ConnectedUpdate (const ConnectedUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  ConnectedUpdate (bool Connected_);

    /**
     * Destructor
     */
    inline virtual  ~ConnectedUpdate();

    /**
     * Assignment operator
     */
    inline ConnectedUpdate& operator = (const ConnectedUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ConnectedUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ConnectedUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ConnectedUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ConnectedUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Connected"

    static const int kConnected = 0;

    /**
     * Clears the field "Connected".
     *
     * The field will be set to its default value. The hasConnected()
     * method will return false.
     */
    inline void clearConnected();

    /**
     * Checks whether the field "Connected" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setConnected()). Otherwise it will return false.
     */
    inline bool hasConnected () const;

    /**
     * Returns the value of the member "Connected".
     *
     * If the meaning of "Connected" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Connected"
     */
    inline bool getConnected () const;

    /**
     * Sets the value of the member "Connected".
     *
     * If the meaning of "Connected" isn't clear, then there should be a description here.
     *
     * @param Connected The value which will be set
     */
    inline void setConnected (bool Connected_);

    static const ConnectedUpdate &getDefaultInstance();

private:

    inline void set_has_Connected ();

    inline void clear_has_Connected ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _Connected;

};

/**
 * If the meaning of "ConnectedRegister" isn't clear, then there should be a description here.
 */
class ConnectedRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ConnectedRegister ();

    /**
     * Copy constructor
     */
    inline  ConnectedRegister (const ConnectedRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~ConnectedRegister();

    /**
     * Assignment operator
     */
    inline ConnectedRegister& operator = (const ConnectedRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ConnectedRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ConnectedRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ConnectedRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ConnectedRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const ConnectedRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "DisconnectionCompSignal" isn't clear, then there should be a description here.
 */
class DisconnectionCompSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DisconnectionCompSignal ();

    /**
     * Copy constructor
     */
    inline  DisconnectionCompSignal (const DisconnectionCompSignal &rhs);

    /**
     * All fields constructor
     */
    inline  DisconnectionCompSignal (uint8 status_, uint8 reason_);

    /**
     * Destructor
     */
    inline virtual  ~DisconnectionCompSignal();

    /**
     * Assignment operator
     */
    inline DisconnectionCompSignal& operator = (const DisconnectionCompSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DisconnectionCompSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DisconnectionCompSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DisconnectionCompSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DisconnectionCompSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "status"

    static const int kStatus = 0;

    /**
     * Clears the field "status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @return The value of the field "status"
     */
    inline uint8 getStatus () const;

    /**
     * Sets the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @param status The value which will be set
     */
    inline void setStatus (uint8 status_);

    // API of field "reason"

    static const int kReason = 1;

    /**
     * Clears the field "reason".
     *
     * The field will be set to its default value. The hasReason()
     * method will return false.
     */
    inline void clearReason();

    /**
     * Checks whether the field "reason" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setReason()). Otherwise it will return false.
     */
    inline bool hasReason () const;

    /**
     * Returns the value of the member "reason".
     *
     * If the meaning of "reason" isn't clear, then there should be a description here.
     *
     * @return The value of the field "reason"
     */
    inline uint8 getReason () const;

    /**
     * Sets the value of the member "reason".
     *
     * If the meaning of "reason" isn't clear, then there should be a description here.
     *
     * @param reason The value which will be set
     */
    inline void setReason (uint8 reason_);

    static const DisconnectionCompSignal &getDefaultInstance();

private:

    inline void set_has_status ();

    inline void clear_has_status ();

    inline void set_has_reason ();

    inline void clear_has_reason ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _status;

    uint8 _reason;

};

inline  AddressTypeUpdate::AddressTypeUpdate ()  :
    _AddressType (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AddressTypeUpdate::AddressTypeUpdate (const AddressTypeUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _AddressType (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AddressTypeUpdate::AddressTypeUpdate (uint8 AddressType_)  :
    _AddressType (AddressType_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AddressTypeUpdate::~AddressTypeUpdate() {
}

inline AddressTypeUpdate& AddressTypeUpdate::operator = (const AddressTypeUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAddressType()) {
            setAddressType(rhs.getAddressType());
        } else {
            clearAddressType();
        }
    }
    return *this;
}

inline bool AddressTypeUpdate::operator == (const AddressTypeUpdate& rhs) const {
    return (((!hasAddressType() && !rhs.hasAddressType()) || getAddressType() == rhs.getAddressType()));
}

inline bool AddressTypeUpdate::operator != (const AddressTypeUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool AddressTypeUpdate::operator < (const AddressTypeUpdate& rhs) const {
    if (hasAddressType() || rhs.hasAddressType()) {
        if (getAddressType() < rhs.getAddressType()) return true;
        if (getAddressType() > rhs.getAddressType()) return false;
    }
    return false;
}

inline ::asf::core::Payload* AddressTypeUpdate::clone() {
    return new AddressTypeUpdate(*this);
}

inline bool AddressTypeUpdate::operator > (const AddressTypeUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AddressTypeUpdate::clear() {
    clearAddressType();
}

inline void AddressTypeUpdate::clearAddressType() {
    if (hasAddressType()) {
         clear_has_AddressType();
        _AddressType = 0u;
     }
}

inline bool AddressTypeUpdate::hasAddressType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 AddressTypeUpdate::getAddressType () const {
    return _AddressType;
}

inline void AddressTypeUpdate::setAddressType (uint8 AddressType_) {
    set_has_AddressType();
    this->_AddressType = AddressType_;
}

inline void AddressTypeUpdate::set_has_AddressType () {
    _has_bits_[0] |= 1u << 0;
}

inline void AddressTypeUpdate::clear_has_AddressType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  AddressTypeRegister::AddressTypeRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AddressTypeRegister::AddressTypeRegister (const AddressTypeRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AddressTypeRegister::~AddressTypeRegister() {
}

inline AddressTypeRegister& AddressTypeRegister::operator = (const AddressTypeRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool AddressTypeRegister::operator == (const AddressTypeRegister& ) const {
    return true;
}

inline bool AddressTypeRegister::operator != (const AddressTypeRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool AddressTypeRegister::operator < (const AddressTypeRegister& ) const {
    return false;
}

inline ::asf::core::Payload* AddressTypeRegister::clone() {
    return new AddressTypeRegister(*this);
}

inline bool AddressTypeRegister::operator > (const AddressTypeRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AddressTypeRegister::clear() {
}

inline  AddressUpdate::AddressUpdate ()  :
    _Address ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AddressUpdate::AddressUpdate (const AddressUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _Address ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AddressUpdate::AddressUpdate (const ::std::string& Address_)  :
    _Address (Address_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Address_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AddressUpdate::~AddressUpdate() {
}

inline AddressUpdate& AddressUpdate::operator = (const AddressUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAddress()) {
            setAddress(rhs.getAddress());
        } else {
            clearAddress();
        }
    }
    return *this;
}

inline bool AddressUpdate::operator == (const AddressUpdate& rhs) const {
    return (((!hasAddress() && !rhs.hasAddress()) || getAddress() == rhs.getAddress()));
}

inline bool AddressUpdate::operator != (const AddressUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool AddressUpdate::operator < (const AddressUpdate& rhs) const {
    if (hasAddress() || rhs.hasAddress()) {
        if (getAddress() < rhs.getAddress()) return true;
        if (getAddress() > rhs.getAddress()) return false;
    }
    return false;
}

inline ::asf::core::Payload* AddressUpdate::clone() {
    return new AddressUpdate(*this);
}

inline bool AddressUpdate::operator > (const AddressUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AddressUpdate::clear() {
    clearAddress();
}

inline void AddressUpdate::clearAddress() {
    if (hasAddress()) {
         clear_has_Address();
        _Address.clear();
     }
}

inline bool AddressUpdate::hasAddress () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& AddressUpdate::getAddress () const {
    return _Address;
}

inline ::std::string& AddressUpdate::getAddressMutable () {
    set_has_Address();
    return _Address;
}

inline void AddressUpdate::setAddress (const ::std::string& Address_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Address_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Address();
    this->_Address = Address_;
}

inline void AddressUpdate::setAddress (const char* Address_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Address_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Address();
    this->_Address.assign(Address_);
}

inline void AddressUpdate::setAddress (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Address();
    this->_Address.assign(value, size);
}

inline void AddressUpdate::set_has_Address () {
    _has_bits_[0] |= 1u << 0;
}

inline void AddressUpdate::clear_has_Address () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  AddressRegister::AddressRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AddressRegister::AddressRegister (const AddressRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AddressRegister::~AddressRegister() {
}

inline AddressRegister& AddressRegister::operator = (const AddressRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool AddressRegister::operator == (const AddressRegister& ) const {
    return true;
}

inline bool AddressRegister::operator != (const AddressRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool AddressRegister::operator < (const AddressRegister& ) const {
    return false;
}

inline ::asf::core::Payload* AddressRegister::clone() {
    return new AddressRegister(*this);
}

inline bool AddressRegister::operator > (const AddressRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AddressRegister::clear() {
}

inline  ConnectedUpdate::ConnectedUpdate ()  :
    _Connected (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ConnectedUpdate::ConnectedUpdate (const ConnectedUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _Connected (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ConnectedUpdate::ConnectedUpdate (bool Connected_)  :
    _Connected (Connected_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ConnectedUpdate::~ConnectedUpdate() {
}

inline ConnectedUpdate& ConnectedUpdate::operator = (const ConnectedUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasConnected()) {
            setConnected(rhs.getConnected());
        } else {
            clearConnected();
        }
    }
    return *this;
}

inline bool ConnectedUpdate::operator == (const ConnectedUpdate& rhs) const {
    return (((!hasConnected() && !rhs.hasConnected()) || getConnected() == rhs.getConnected()));
}

inline bool ConnectedUpdate::operator != (const ConnectedUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool ConnectedUpdate::operator < (const ConnectedUpdate& rhs) const {
    if (hasConnected() || rhs.hasConnected()) {
        if (getConnected() < rhs.getConnected()) return true;
        if (getConnected() > rhs.getConnected()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ConnectedUpdate::clone() {
    return new ConnectedUpdate(*this);
}

inline bool ConnectedUpdate::operator > (const ConnectedUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ConnectedUpdate::clear() {
    clearConnected();
}

inline void ConnectedUpdate::clearConnected() {
    if (hasConnected()) {
         clear_has_Connected();
        _Connected = false;
     }
}

inline bool ConnectedUpdate::hasConnected () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool ConnectedUpdate::getConnected () const {
    return _Connected;
}

inline void ConnectedUpdate::setConnected (bool Connected_) {
    set_has_Connected();
    this->_Connected = Connected_;
}

inline void ConnectedUpdate::set_has_Connected () {
    _has_bits_[0] |= 1u << 0;
}

inline void ConnectedUpdate::clear_has_Connected () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ConnectedRegister::ConnectedRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ConnectedRegister::ConnectedRegister (const ConnectedRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ConnectedRegister::~ConnectedRegister() {
}

inline ConnectedRegister& ConnectedRegister::operator = (const ConnectedRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool ConnectedRegister::operator == (const ConnectedRegister& ) const {
    return true;
}

inline bool ConnectedRegister::operator != (const ConnectedRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool ConnectedRegister::operator < (const ConnectedRegister& ) const {
    return false;
}

inline ::asf::core::Payload* ConnectedRegister::clone() {
    return new ConnectedRegister(*this);
}

inline bool ConnectedRegister::operator > (const ConnectedRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ConnectedRegister::clear() {
}

inline  DisconnectionCompSignal::DisconnectionCompSignal ()  :
    _status (0u),
    _reason (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DisconnectionCompSignal::DisconnectionCompSignal (const DisconnectionCompSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _status (0u),
    _reason (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DisconnectionCompSignal::DisconnectionCompSignal (uint8 status_, uint8 reason_)  :
    _status (status_),
    _reason (reason_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DisconnectionCompSignal::~DisconnectionCompSignal() {
}

inline DisconnectionCompSignal& DisconnectionCompSignal::operator = (const DisconnectionCompSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
        if (rhs.hasReason()) {
            setReason(rhs.getReason());
        } else {
            clearReason();
        }
    }
    return *this;
}

inline bool DisconnectionCompSignal::operator == (const DisconnectionCompSignal& rhs) const {
    return (((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()) &&
        ((!hasReason() && !rhs.hasReason()) || getReason() == rhs.getReason()));
}

inline bool DisconnectionCompSignal::operator != (const DisconnectionCompSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool DisconnectionCompSignal::operator < (const DisconnectionCompSignal& rhs) const {
    if (hasStatus() || rhs.hasStatus()) {
        if (getStatus() < rhs.getStatus()) return true;
        if (getStatus() > rhs.getStatus()) return false;
    }
    if (hasReason() || rhs.hasReason()) {
        if (getReason() < rhs.getReason()) return true;
        if (getReason() > rhs.getReason()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DisconnectionCompSignal::clone() {
    return new DisconnectionCompSignal(*this);
}

inline bool DisconnectionCompSignal::operator > (const DisconnectionCompSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DisconnectionCompSignal::clear() {
    clearStatus();
    clearReason();
}

inline void DisconnectionCompSignal::clearStatus() {
    if (hasStatus()) {
         clear_has_status();
        _status = 0u;
     }
}

inline bool DisconnectionCompSignal::hasStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 DisconnectionCompSignal::getStatus () const {
    return _status;
}

inline void DisconnectionCompSignal::setStatus (uint8 status_) {
    set_has_status();
    this->_status = status_;
}

inline void DisconnectionCompSignal::clearReason() {
    if (hasReason()) {
         clear_has_reason();
        _reason = 0u;
     }
}

inline bool DisconnectionCompSignal::hasReason () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 DisconnectionCompSignal::getReason () const {
    return _reason;
}

inline void DisconnectionCompSignal::setReason (uint8 reason_) {
    set_has_reason();
    this->_reason = reason_;
}

inline void DisconnectionCompSignal::set_has_status () {
    _has_bits_[0] |= 1u << 0;
}

inline void DisconnectionCompSignal::clear_has_status () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void DisconnectionCompSignal::set_has_reason () {
    _has_bits_[0] |= 1u << 1;
}

inline void DisconnectionCompSignal::clear_has_reason () {
    _has_bits_[0] &= ~ (1u << 1);
}

} // namespace LE_Device1
} // namespace bluez
} // namespace org

#endif // ORG_BLUEZ_LE_DEVICE1_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
