/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "org/bluez/LE_Adapter1.h"
#include "org/bluez/LE_Adapter1DBus.h"
#include "org/bluez/LE_Adapter1Json.h"
#include "org/bluez/LE_Adapter1Stub.h"
#include <string>
#include <vector>

#include "asf/dbus/DBusMessage.h"

namespace org {
namespace bluez {
namespace LE_Adapter1 {

DEFINE_CLASS_LOGGER("//org/bluez/hci1/org/bluez/LE_Adapter1", LE_Adapter1Stub);

static ::asf::dbus::DBusUtils::stringEntry methodsTable[] = {
    { 14, "CreateLeDevice", 0 },
    { 14, "RemoveLeDevice", 1 },
};

static ::asf::dbus::DBusUtils::stringEntry propertiesTable[] = {
    { 5, "Alias", 2 },
    { 7, "Address", 1 },
    { 11, "AddressType", 0 },
    { 15, "AdvertiseEnable", 6 },
    { 15, "AdvertisingData", 5 },
    { 16, "DiscoverableMode", 4 },
    { 18, "AdvertisingTimeout", 3 },
};

class LE_Adapter1StubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    LE_Adapter1StubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    LE_Adapter1StubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    LE_Adapter1StubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "org.bluez.LE_Adapter1"),
          _logger(logger) {}

    virtual ~LE_Adapter1StubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void LE_Adapter1StubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    unsigned int methodIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (message.getMemberName().c_str(), message.getMemberName().length(), methodsTable, 2, methodIndex)) {
        switch (methodIndex) {
        case 0: {

            // method 'CreateLeDevice'

            LOG_DEBUG_STUB("process method '%s'", "CreateLeDevice");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CreateLeDeviceRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "CreateLeDevice", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< CreateLeDeviceRequest > payload = ::boost::static_pointer_cast<CreateLeDeviceRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<LE_Adapter1Stub*>(getStub())->onCreateLeDeviceRequest(payload);
            return;
        }
        case 1: {

            // method 'RemoveLeDevice'

            LOG_DEBUG_STUB("process method '%s'", "RemoveLeDevice");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RemoveLeDeviceRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "RemoveLeDevice", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< RemoveLeDeviceRequest > payload = ::boost::static_pointer_cast<RemoveLeDeviceRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<LE_Adapter1Stub*>(getStub())->onRemoveLeDeviceRequest(payload);
            return;
        }
        default:
            break;
        }
    }
    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* LE_Adapter1StubDelegate::introspect() const {
    return     "<interface name=\"org.bluez.LE_Adapter1\">\n"
            "      <method name=\"CreateLeDevice\">\n"
            "        <arg direction=\"in\" name=\"address\" type=\"s\"/>\n"
            "        <arg direction=\"out\" name=\"device\" type=\"o\"/>\n"
            "      </method>\n"
            "      <method name=\"RemoveLeDevice\">\n"
            "        <arg direction=\"in\" name=\"device\" type=\"o\"/>\n"
            "      </method>\n"
            "      <signal name=\"LeAdapterInitialization\"/>\n"
            "      <signal name=\"LeDeviceCreated\">\n"
            "        <arg name=\"device\" type=\"o\"/>\n"
            "      </signal>\n"
            "      <signal name=\"LeDeviceRemoved\">\n"
            "        <arg name=\"device\" type=\"o\"/>\n"
            "      </signal>\n"
            "      <property access=\"read\" name=\"AddressType\" type=\"y\"/>\n"
            "      <property access=\"read\" name=\"Address\" type=\"s\"/>\n"
            "      <property access=\"readwrite\" name=\"Alias\" type=\"s\"/>\n"
            "      <property access=\"readwrite\" name=\"AdvertisingTimeout\" type=\"y\"/>\n"
            "      <property access=\"readwrite\" name=\"DiscoverableMode\" type=\"y\"/>\n"
            "      <property access=\"readwrite\" name=\"AdvertisingData\" type=\"ay\"/>\n"
            "      <property access=\"readwrite\" name=\"AdvertiseEnable\" type=\"b\"/>\n"
            "</interface>\n";
}

void LE_Adapter1StubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<LE_Adapter1Stub*>(getStub()))->onGetAll (properties);
}

void LE_Adapter1StubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 7, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "AddressType");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 1: {
            LOG_DEBUG_STUB("process property '%s'", "Address");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 2: {
            LOG_DEBUG_STUB("process property '%s'", "Alias");
            ::boost::shared_ptr< AliasSet > payload(new AliasSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<LE_Adapter1Stub*>(getStub())->onAliasSet (payload);
            return;
        }
        case 3: {
            LOG_DEBUG_STUB("process property '%s'", "AdvertisingTimeout");
            ::boost::shared_ptr< AdvertisingTimeoutSet > payload(new AdvertisingTimeoutSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<LE_Adapter1Stub*>(getStub())->onAdvertisingTimeoutSet (payload);
            return;
        }
        case 4: {
            LOG_DEBUG_STUB("process property '%s'", "DiscoverableMode");
            ::boost::shared_ptr< DiscoverableModeSet > payload(new DiscoverableModeSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<LE_Adapter1Stub*>(getStub())->onDiscoverableModeSet (payload);
            return;
        }
        case 5: {
            LOG_DEBUG_STUB("process property '%s'", "AdvertisingData");
            ::boost::shared_ptr< AdvertisingDataSet > payload(new AdvertisingDataSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<LE_Adapter1Stub*>(getStub())->onAdvertisingDataSet (payload);
            return;
        }
        case 6: {
            LOG_DEBUG_STUB("process property '%s'", "AdvertiseEnable");
            ::boost::shared_ptr< AdvertiseEnableSet > payload(new AdvertiseEnableSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<LE_Adapter1Stub*>(getStub())->onAdvertiseEnableSet (payload);
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void LE_Adapter1StubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 7, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "AddressType");
            ::boost::shared_ptr< AddressTypeGet > payload(new AddressTypeGet());
            payload->setAct(act);
            static_cast<LE_Adapter1Stub*>(getStub())->onAddressTypeGet (payload);
            return;
        }
        case 1: {
            LOG_DEBUG_STUB("process property '%s'", "Address");
            ::boost::shared_ptr< AddressGet > payload(new AddressGet());
            payload->setAct(act);
            static_cast<LE_Adapter1Stub*>(getStub())->onAddressGet (payload);
            return;
        }
        case 2: {
            LOG_DEBUG_STUB("process property '%s'", "Alias");
            ::boost::shared_ptr< AliasGet > payload(new AliasGet());
            payload->setAct(act);
            static_cast<LE_Adapter1Stub*>(getStub())->onAliasGet (payload);
            return;
        }
        case 3: {
            LOG_DEBUG_STUB("process property '%s'", "AdvertisingTimeout");
            ::boost::shared_ptr< AdvertisingTimeoutGet > payload(new AdvertisingTimeoutGet());
            payload->setAct(act);
            static_cast<LE_Adapter1Stub*>(getStub())->onAdvertisingTimeoutGet (payload);
            return;
        }
        case 4: {
            LOG_DEBUG_STUB("process property '%s'", "DiscoverableMode");
            ::boost::shared_ptr< DiscoverableModeGet > payload(new DiscoverableModeGet());
            payload->setAct(act);
            static_cast<LE_Adapter1Stub*>(getStub())->onDiscoverableModeGet (payload);
            return;
        }
        case 5: {
            LOG_DEBUG_STUB("process property '%s'", "AdvertisingData");
            ::boost::shared_ptr< AdvertisingDataGet > payload(new AdvertisingDataGet());
            payload->setAct(act);
            static_cast<LE_Adapter1Stub*>(getStub())->onAdvertisingDataGet (payload);
            return;
        }
        case 6: {
            LOG_DEBUG_STUB("process property '%s'", "AdvertiseEnable");
            ::boost::shared_ptr< AdvertiseEnableGet > payload(new AdvertiseEnableGet());
            payload->setAct(act);
            static_cast<LE_Adapter1Stub*>(getStub())->onAdvertiseEnableGet (payload);
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

LE_Adapter1Stub::LE_Adapter1Stub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new LE_Adapter1StubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

LE_Adapter1Stub::LE_Adapter1Stub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new LE_Adapter1StubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

LE_Adapter1Stub::~LE_Adapter1Stub() {
    delete _stubDelegate;
}

void LE_Adapter1Stub::sendLeAdapterInitializationSignal() {
    if (_stubDelegate->isConnected()) {
        LeAdapterInitializationSignal* payload = new LeAdapterInitializationSignal;
        DBUS_MESSAGE_SIGNAL(dbusMessage, "LeAdapterInitialization", LeAdapterInitializationSignal, payload)
        LOG_INFO ("-> send%sSignal", "LeAdapterInitialization");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "LeAdapterInitialization");
    }
}

void LE_Adapter1Stub::sendLeDeviceCreatedSignal(const ::std::string& device) {
    if (_stubDelegate->isConnected()) {
        LeDeviceCreatedSignal* payload = new LeDeviceCreatedSignal(device);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "LeDeviceCreated", LeDeviceCreatedSignal, payload)
        LOG_INFO ("-> send%sSignal", "LeDeviceCreated");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "LeDeviceCreated");
    }
}

void LE_Adapter1Stub::sendLeDeviceRemovedSignal(const ::std::string& device) {
    if (_stubDelegate->isConnected()) {
        LeDeviceRemovedSignal* payload = new LeDeviceRemovedSignal(device);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "LeDeviceRemoved", LeDeviceRemovedSignal, payload)
        LOG_INFO ("-> send%sSignal", "LeDeviceRemoved");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "LeDeviceRemoved");
    }
}

void LE_Adapter1Stub::sendAddressTypeUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        AddressTypeUpdate payload(_AddressTypeProperty);

        LOG_INFO ("-> send%s", "AddressTypeUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("AddressType", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bluez.LE_Adapter1", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "AddressTypeUpdate");
    }
}

void LE_Adapter1Stub::onAddressTypeGet(const ::boost::shared_ptr< AddressTypeGet >& addressType) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "AddressTypeGet", addressType->getAct());
    sendAddressTypeGetUpdate(_AddressTypeProperty.getAddressType(), addressType->getAct());
}

void LE_Adapter1Stub::sendAddressTypeGetUpdate(uint8 addressType, act_t act) {
    ::asf::dbus::DBusVariant variant;
    AddressTypeGet payload(addressType);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "AddressTypeGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void LE_Adapter1Stub::setAddressType(uint8 addressType) {
    if(addressType!=_AddressTypeProperty.getAddressType()) {
        _AddressTypeProperty.setAddressType(addressType);
        sendAddressTypeUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint8 LE_Adapter1Stub::getAddressType() const {
    return _AddressTypeProperty.getAddressType();
}

void LE_Adapter1Stub::sendAddressUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        AddressUpdate payload(_AddressProperty);

        LOG_INFO ("-> send%s", "AddressUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Address", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bluez.LE_Adapter1", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "AddressUpdate");
    }
}

void LE_Adapter1Stub::onAddressGet(const ::boost::shared_ptr< AddressGet >& address) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "AddressGet", address->getAct());
    sendAddressGetUpdate(_AddressProperty.getAddress(), address->getAct());
}

void LE_Adapter1Stub::sendAddressGetUpdate(const ::std::string& address, act_t act) {
    ::asf::dbus::DBusVariant variant;
    AddressGet payload(address);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "AddressGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void LE_Adapter1Stub::setAddress(const ::std::string& address) {
    if(address!=_AddressProperty.getAddress()) {
        _AddressProperty.setAddress(address);
        sendAddressUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& LE_Adapter1Stub::getAddress() const {
    return _AddressProperty.getAddress();
}

::std::string& LE_Adapter1Stub::getAddressMutable() {
    return _AddressProperty.getAddressMutable();
}

void LE_Adapter1Stub::sendAliasUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        AliasUpdate payload(_AliasProperty);

        LOG_INFO ("-> send%s", "AliasUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Alias", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bluez.LE_Adapter1", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "AliasUpdate");
    }
}

void LE_Adapter1Stub::onAliasGet(const ::boost::shared_ptr< AliasGet >& alias) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "AliasGet", alias->getAct());
    sendAliasGetUpdate(_AliasProperty.getAlias(), alias->getAct());
}

void LE_Adapter1Stub::sendAliasGetUpdate(const ::std::string& alias, act_t act) {
    ::asf::dbus::DBusVariant variant;
    AliasGet payload(alias);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "AliasGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void LE_Adapter1Stub::onAliasSet(const ::boost::shared_ptr< AliasSet >& alias) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "AliasSet", alias->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*alias, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setAlias (alias->getAlias());
    sendAliasSetUpdate(alias->getAct());
}

void LE_Adapter1Stub::sendAliasSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "AliasSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void LE_Adapter1Stub::setAlias(const ::std::string& alias) {
    if(alias!=_AliasProperty.getAlias()) {
        _AliasProperty.setAlias(alias);
        sendAliasUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& LE_Adapter1Stub::getAlias() const {
    return _AliasProperty.getAlias();
}

::std::string& LE_Adapter1Stub::getAliasMutable() {
    return _AliasProperty.getAliasMutable();
}

void LE_Adapter1Stub::sendAdvertisingTimeoutUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        AdvertisingTimeoutUpdate payload(_AdvertisingTimeoutProperty);

        LOG_INFO ("-> send%s", "AdvertisingTimeoutUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("AdvertisingTimeout", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bluez.LE_Adapter1", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "AdvertisingTimeoutUpdate");
    }
}

void LE_Adapter1Stub::onAdvertisingTimeoutGet(const ::boost::shared_ptr< AdvertisingTimeoutGet >& advertisingTimeout) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "AdvertisingTimeoutGet", advertisingTimeout->getAct());
    sendAdvertisingTimeoutGetUpdate(_AdvertisingTimeoutProperty.getAdvertisingTimeout(), advertisingTimeout->getAct());
}

void LE_Adapter1Stub::sendAdvertisingTimeoutGetUpdate(uint8 advertisingTimeout, act_t act) {
    ::asf::dbus::DBusVariant variant;
    AdvertisingTimeoutGet payload(advertisingTimeout);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "AdvertisingTimeoutGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void LE_Adapter1Stub::onAdvertisingTimeoutSet(const ::boost::shared_ptr< AdvertisingTimeoutSet >& advertisingTimeout) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "AdvertisingTimeoutSet", advertisingTimeout->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*advertisingTimeout, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setAdvertisingTimeout (advertisingTimeout->getAdvertisingTimeout());
    sendAdvertisingTimeoutSetUpdate(advertisingTimeout->getAct());
}

void LE_Adapter1Stub::sendAdvertisingTimeoutSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "AdvertisingTimeoutSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void LE_Adapter1Stub::setAdvertisingTimeout(uint8 advertisingTimeout) {
    if(advertisingTimeout!=_AdvertisingTimeoutProperty.getAdvertisingTimeout()) {
        _AdvertisingTimeoutProperty.setAdvertisingTimeout(advertisingTimeout);
        sendAdvertisingTimeoutUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint8 LE_Adapter1Stub::getAdvertisingTimeout() const {
    return _AdvertisingTimeoutProperty.getAdvertisingTimeout();
}

void LE_Adapter1Stub::sendDiscoverableModeUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        DiscoverableModeUpdate payload(_DiscoverableModeProperty);

        LOG_INFO ("-> send%s", "DiscoverableModeUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("DiscoverableMode", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bluez.LE_Adapter1", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "DiscoverableModeUpdate");
    }
}

void LE_Adapter1Stub::onDiscoverableModeGet(const ::boost::shared_ptr< DiscoverableModeGet >& discoverableMode) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "DiscoverableModeGet", discoverableMode->getAct());
    sendDiscoverableModeGetUpdate(_DiscoverableModeProperty.getDiscoverableMode(), discoverableMode->getAct());
}

void LE_Adapter1Stub::sendDiscoverableModeGetUpdate(uint8 discoverableMode, act_t act) {
    ::asf::dbus::DBusVariant variant;
    DiscoverableModeGet payload(discoverableMode);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "DiscoverableModeGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void LE_Adapter1Stub::onDiscoverableModeSet(const ::boost::shared_ptr< DiscoverableModeSet >& discoverableMode) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "DiscoverableModeSet", discoverableMode->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*discoverableMode, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setDiscoverableMode (discoverableMode->getDiscoverableMode());
    sendDiscoverableModeSetUpdate(discoverableMode->getAct());
}

void LE_Adapter1Stub::sendDiscoverableModeSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "DiscoverableModeSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void LE_Adapter1Stub::setDiscoverableMode(uint8 discoverableMode) {
    if(discoverableMode!=_DiscoverableModeProperty.getDiscoverableMode()) {
        _DiscoverableModeProperty.setDiscoverableMode(discoverableMode);
        sendDiscoverableModeUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint8 LE_Adapter1Stub::getDiscoverableMode() const {
    return _DiscoverableModeProperty.getDiscoverableMode();
}

void LE_Adapter1Stub::sendAdvertisingDataUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        AdvertisingDataUpdate payload(_AdvertisingDataProperty);

        LOG_INFO ("-> send%s", "AdvertisingDataUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("AdvertisingData", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bluez.LE_Adapter1", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "AdvertisingDataUpdate");
    }
}

void LE_Adapter1Stub::onAdvertisingDataGet(const ::boost::shared_ptr< AdvertisingDataGet >& advertisingData) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "AdvertisingDataGet", advertisingData->getAct());
    sendAdvertisingDataGetUpdate(_AdvertisingDataProperty.getAdvertisingData(), advertisingData->getAct());
}

void LE_Adapter1Stub::sendAdvertisingDataGetUpdate(const ::std::vector< uint8 >& advertisingData, act_t act) {
    ::asf::dbus::DBusVariant variant;
    AdvertisingDataGet payload(advertisingData);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "AdvertisingDataGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void LE_Adapter1Stub::onAdvertisingDataSet(const ::boost::shared_ptr< AdvertisingDataSet >& advertisingData) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "AdvertisingDataSet", advertisingData->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*advertisingData, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setAdvertisingData (advertisingData->getAdvertisingData());
    sendAdvertisingDataSetUpdate(advertisingData->getAct());
}

void LE_Adapter1Stub::sendAdvertisingDataSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "AdvertisingDataSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void LE_Adapter1Stub::setAdvertisingData(const ::std::vector< uint8 >& advertisingData) {
    if(advertisingData!=_AdvertisingDataProperty.getAdvertisingData()) {
        _AdvertisingDataProperty.setAdvertisingData(advertisingData);
        sendAdvertisingDataUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< uint8 >& LE_Adapter1Stub::getAdvertisingData() const {
    return _AdvertisingDataProperty.getAdvertisingData();
}

::std::vector< uint8 >& LE_Adapter1Stub::getAdvertisingDataMutable() {
    return _AdvertisingDataProperty.getAdvertisingDataMutable();
}

void LE_Adapter1Stub::sendAdvertiseEnableUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        AdvertiseEnableUpdate payload(_AdvertiseEnableProperty);

        LOG_INFO ("-> send%s", "AdvertiseEnableUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("AdvertiseEnable", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bluez.LE_Adapter1", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "AdvertiseEnableUpdate");
    }
}

void LE_Adapter1Stub::onAdvertiseEnableGet(const ::boost::shared_ptr< AdvertiseEnableGet >& advertiseEnable) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "AdvertiseEnableGet", advertiseEnable->getAct());
    sendAdvertiseEnableGetUpdate(_AdvertiseEnableProperty.getAdvertiseEnable(), advertiseEnable->getAct());
}

void LE_Adapter1Stub::sendAdvertiseEnableGetUpdate(bool advertiseEnable, act_t act) {
    ::asf::dbus::DBusVariant variant;
    AdvertiseEnableGet payload(advertiseEnable);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "AdvertiseEnableGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void LE_Adapter1Stub::onAdvertiseEnableSet(const ::boost::shared_ptr< AdvertiseEnableSet >& advertiseEnable) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "AdvertiseEnableSet", advertiseEnable->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*advertiseEnable, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setAdvertiseEnable (advertiseEnable->getAdvertiseEnable());
    sendAdvertiseEnableSetUpdate(advertiseEnable->getAct());
}

void LE_Adapter1Stub::sendAdvertiseEnableSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "AdvertiseEnableSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void LE_Adapter1Stub::setAdvertiseEnable(bool advertiseEnable) {
    if(advertiseEnable!=_AdvertiseEnableProperty.getAdvertiseEnable()) {
        _AdvertiseEnableProperty.setAdvertiseEnable(advertiseEnable);
        sendAdvertiseEnableUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

bool LE_Adapter1Stub::getAdvertiseEnable() const {
    return _AdvertiseEnableProperty.getAdvertiseEnable();
}

void  LE_Adapter1Stub::sendCreateLeDeviceResponse (const ::std::string& device, act_t act) {
    CreateLeDeviceResponse* payload = new CreateLeDeviceResponse(device);
    DBUS_MESSAGE_REPLY(dbusMessage, "CreateLeDevice", CreateLeDeviceResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "CreateLeDevice", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  LE_Adapter1Stub::sendCreateLeDeviceError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    CreateLeDeviceError* payload = new CreateLeDeviceError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "CreateLeDevice", CreateLeDeviceError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "CreateLeDevice", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  LE_Adapter1Stub::sendRemoveLeDeviceResponse (act_t act) {
    RemoveLeDeviceResponse* payload = new RemoveLeDeviceResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "RemoveLeDevice", RemoveLeDeviceResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "RemoveLeDevice", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  LE_Adapter1Stub::sendRemoveLeDeviceError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    RemoveLeDeviceError* payload = new RemoveLeDeviceError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "RemoveLeDevice", RemoveLeDeviceError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "RemoveLeDevice", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void LE_Adapter1Stub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {

    //property 'AddressType'
    {
        ::asf::dbus::DBusVariant variant;
        AddressTypeGet payload(_AddressTypeProperty.getAddressType());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("AddressType", variant));
    }

    //property 'Address'
    {
        ::asf::dbus::DBusVariant variant;
        AddressGet payload(_AddressProperty.getAddress());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Address", variant));
    }

    //property 'Alias'
    {
        ::asf::dbus::DBusVariant variant;
        AliasGet payload(_AliasProperty.getAlias());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Alias", variant));
    }

    //property 'AdvertisingTimeout'
    {
        ::asf::dbus::DBusVariant variant;
        AdvertisingTimeoutGet payload(_AdvertisingTimeoutProperty.getAdvertisingTimeout());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("AdvertisingTimeout", variant));
    }

    //property 'DiscoverableMode'
    {
        ::asf::dbus::DBusVariant variant;
        DiscoverableModeGet payload(_DiscoverableModeProperty.getDiscoverableMode());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("DiscoverableMode", variant));
    }

    //property 'AdvertisingData'
    {
        ::asf::dbus::DBusVariant variant;
        AdvertisingDataGet payload(_AdvertisingDataProperty.getAdvertisingData());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("AdvertisingData", variant));
    }

    //property 'AdvertiseEnable'
    {
        ::asf::dbus::DBusVariant variant;
        AdvertiseEnableGet payload(_AdvertiseEnableProperty.getAdvertiseEnable());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("AdvertiseEnable", variant));
    }
}

} // namespace LE_Adapter1
} // namespace bluez
} // namespace org
