#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_BLUEZ_LE_ADAPTER1_H
#define ORG_BLUEZ_LE_ADAPTER1_H

#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "asf/dbus/DBusTypes.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

/**
 * If the meaning of "LE_Adapter1" isn't clear, then there should be a description here.
 */

namespace org {
namespace bluez {
namespace LE_Adapter1 {

// method IDs
static const uint16 ID_CreateLeDevice = 0;
static const uint16 ID_RemoveLeDevice = 1;

// signal IDs
static const uint16 ID_LeAdapterInitialization = 2;
static const uint16 ID_LeDeviceCreated = 3;
static const uint16 ID_LeDeviceRemoved = 4;

// property IDs
static const uint16 ID_AddressType = 5;
static const uint16 ID_Address = 6;
static const uint16 ID_Alias = 7;
static const uint16 ID_AdvertisingTimeout = 8;
static const uint16 ID_DiscoverableMode = 9;
static const uint16 ID_AdvertisingData = 10;
static const uint16 ID_AdvertiseEnable = 11;

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class CreateLeDeviceRequest;

class CreateLeDeviceResponse;

class RemoveLeDeviceRequest;

class AddressTypeUpdate;

class AddressTypeRegister;

class AddressUpdate;

class AddressRegister;

class AliasUpdate;

class AliasRegister;

class AdvertisingTimeoutUpdate;

class AdvertisingTimeoutRegister;

class DiscoverableModeUpdate;

class DiscoverableModeRegister;

class AdvertisingDataUpdate;

class AdvertisingDataRegister;

class AdvertiseEnableUpdate;

class AdvertiseEnableRegister;

class LeDeviceCreatedSignal;

class LeDeviceRemovedSignal;

// type definitions
/**
 * If the meaning of "CreateLeDeviceError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError CreateLeDeviceError;

/**
 * If the meaning of "RemoveLeDeviceResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage RemoveLeDeviceResponse;

/**
 * If the meaning of "RemoveLeDeviceError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError RemoveLeDeviceError;

/**
 * If the meaning of "AddressTypeSet" isn't clear, then there should be a description here.
 */
typedef AddressTypeUpdate AddressTypeSet;

/**
 * If the meaning of "AddressTypeGet" isn't clear, then there should be a description here.
 */
typedef AddressTypeUpdate AddressTypeGet;

/**
 * If the meaning of "AddressTypeError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError AddressTypeError;

/**
 * If the meaning of "AddressSet" isn't clear, then there should be a description here.
 */
typedef AddressUpdate AddressSet;

/**
 * If the meaning of "AddressGet" isn't clear, then there should be a description here.
 */
typedef AddressUpdate AddressGet;

/**
 * If the meaning of "AddressError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError AddressError;

/**
 * If the meaning of "AliasSet" isn't clear, then there should be a description here.
 */
typedef AliasUpdate AliasSet;

/**
 * If the meaning of "AliasGet" isn't clear, then there should be a description here.
 */
typedef AliasUpdate AliasGet;

/**
 * If the meaning of "AliasError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError AliasError;

/**
 * If the meaning of "AdvertisingTimeoutSet" isn't clear, then there should be a description here.
 */
typedef AdvertisingTimeoutUpdate AdvertisingTimeoutSet;

/**
 * If the meaning of "AdvertisingTimeoutGet" isn't clear, then there should be a description here.
 */
typedef AdvertisingTimeoutUpdate AdvertisingTimeoutGet;

/**
 * If the meaning of "AdvertisingTimeoutError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError AdvertisingTimeoutError;

/**
 * If the meaning of "DiscoverableModeSet" isn't clear, then there should be a description here.
 */
typedef DiscoverableModeUpdate DiscoverableModeSet;

/**
 * If the meaning of "DiscoverableModeGet" isn't clear, then there should be a description here.
 */
typedef DiscoverableModeUpdate DiscoverableModeGet;

/**
 * If the meaning of "DiscoverableModeError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError DiscoverableModeError;

/**
 * If the meaning of "AdvertisingDataSet" isn't clear, then there should be a description here.
 */
typedef AdvertisingDataUpdate AdvertisingDataSet;

/**
 * If the meaning of "AdvertisingDataGet" isn't clear, then there should be a description here.
 */
typedef AdvertisingDataUpdate AdvertisingDataGet;

/**
 * If the meaning of "AdvertisingDataError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError AdvertisingDataError;

/**
 * If the meaning of "AdvertiseEnableSet" isn't clear, then there should be a description here.
 */
typedef AdvertiseEnableUpdate AdvertiseEnableSet;

/**
 * If the meaning of "AdvertiseEnableGet" isn't clear, then there should be a description here.
 */
typedef AdvertiseEnableUpdate AdvertiseEnableGet;

/**
 * If the meaning of "AdvertiseEnableError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError AdvertiseEnableError;

/**
 * If the meaning of "LeAdapterInitializationSignal" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage LeAdapterInitializationSignal;

/**
 * If the meaning of "LeAdapterInitializationError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError LeAdapterInitializationError;

/**
 * If the meaning of "LeDeviceCreatedError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError LeDeviceCreatedError;

/**
 * If the meaning of "LeDeviceRemovedError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError LeDeviceRemovedError;


/**
 * If the meaning of "CreateLeDeviceRequest" isn't clear, then there should be a description here.
 */
class CreateLeDeviceRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CreateLeDeviceRequest ();

    /**
     * Copy constructor
     */
    inline  CreateLeDeviceRequest (const CreateLeDeviceRequest &rhs);

    /**
     * All fields constructor
     */
    inline  CreateLeDeviceRequest (const ::std::string& address_);

    /**
     * Destructor
     */
    inline virtual  ~CreateLeDeviceRequest();

    /**
     * Assignment operator
     */
    inline CreateLeDeviceRequest& operator = (const CreateLeDeviceRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CreateLeDeviceRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CreateLeDeviceRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CreateLeDeviceRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CreateLeDeviceRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "address"

    static const int kAddress = 0;

    /**
     * Clears the field "address".
     *
     * The field will be set to its default value. The hasAddress()
     * method will return false.
     */
    inline void clearAddress();

    /**
     * Checks whether the field "address" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAddress()). Otherwise it will return false.
     */
    inline bool hasAddress () const;

    /**
     * Returns the value of the member "address".
     *
     * If the meaning of "address" isn't clear, then there should be a description here.
     *
     * @return The value of the field "address"
     */
    inline const ::std::string& getAddress () const;

    /**
     * Retrieves the value of the field "address" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "address".
     */
    inline ::std::string& getAddressMutable ();

    /**
     * Sets the value of the member "address".
     *
     * If the meaning of "address" isn't clear, then there should be a description here.
     *
     * @param address The value which will be set
     */
    inline void setAddress (const ::std::string& address_);

    /**
     * Sets the value of the member "address".
     *
     * If the meaning of "address" isn't clear, then there should be a description here.
     *
     * @param address The value which will be set
     */
    inline void setAddress (const char* address_);

    /**
     * Sets the value of the member "address".
     *
     * If the meaning of "address" isn't clear, then there should be a description here.
     *
     * @param address The value which will be set
     */
    inline void setAddress (const char* value, size_t size);

    static const CreateLeDeviceRequest &getDefaultInstance();

private:

    inline void set_has_address ();

    inline void clear_has_address ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _address;

};

/**
 * If the meaning of "CreateLeDeviceResponse" isn't clear, then there should be a description here.
 */
class CreateLeDeviceResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CreateLeDeviceResponse ();

    /**
     * Copy constructor
     */
    inline  CreateLeDeviceResponse (const CreateLeDeviceResponse &rhs);

    /**
     * All fields constructor
     */
    inline  CreateLeDeviceResponse (const ::std::string& device_);

    /**
     * Destructor
     */
    inline virtual  ~CreateLeDeviceResponse();

    /**
     * Assignment operator
     */
    inline CreateLeDeviceResponse& operator = (const CreateLeDeviceResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CreateLeDeviceResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CreateLeDeviceResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CreateLeDeviceResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CreateLeDeviceResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "device"

    static const int kDevice = 0;

    /**
     * Clears the field "device".
     *
     * The field will be set to its default value. The hasDevice()
     * method will return false.
     */
    inline void clearDevice();

    /**
     * Checks whether the field "device" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDevice()). Otherwise it will return false.
     */
    inline bool hasDevice () const;

    /**
     * Returns the value of the member "device".
     *
     * If the meaning of "device" isn't clear, then there should be a description here.
     *
     * @return The value of the field "device"
     */
    inline const ::std::string& getDevice () const;

    /**
     * Retrieves the value of the field "device" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "device".
     */
    inline ::std::string& getDeviceMutable ();

    /**
     * Sets the value of the member "device".
     *
     * If the meaning of "device" isn't clear, then there should be a description here.
     *
     * @param device The value which will be set
     */
    inline void setDevice (const ::std::string& device_);

    /**
     * Sets the value of the member "device".
     *
     * If the meaning of "device" isn't clear, then there should be a description here.
     *
     * @param device The value which will be set
     */
    inline void setDevice (const char* device_);

    /**
     * Sets the value of the member "device".
     *
     * If the meaning of "device" isn't clear, then there should be a description here.
     *
     * @param device The value which will be set
     */
    inline void setDevice (const char* value, size_t size);

    static const CreateLeDeviceResponse &getDefaultInstance();

private:

    inline void set_has_device ();

    inline void clear_has_device ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _device;

};

/**
 * If the meaning of "RemoveLeDeviceRequest" isn't clear, then there should be a description here.
 */
class RemoveLeDeviceRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RemoveLeDeviceRequest ();

    /**
     * Copy constructor
     */
    inline  RemoveLeDeviceRequest (const RemoveLeDeviceRequest &rhs);

    /**
     * All fields constructor
     */
    inline  RemoveLeDeviceRequest (const ::std::string& device_);

    /**
     * Destructor
     */
    inline virtual  ~RemoveLeDeviceRequest();

    /**
     * Assignment operator
     */
    inline RemoveLeDeviceRequest& operator = (const RemoveLeDeviceRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RemoveLeDeviceRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RemoveLeDeviceRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RemoveLeDeviceRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RemoveLeDeviceRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "device"

    static const int kDevice = 0;

    /**
     * Clears the field "device".
     *
     * The field will be set to its default value. The hasDevice()
     * method will return false.
     */
    inline void clearDevice();

    /**
     * Checks whether the field "device" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDevice()). Otherwise it will return false.
     */
    inline bool hasDevice () const;

    /**
     * Returns the value of the member "device".
     *
     * If the meaning of "device" isn't clear, then there should be a description here.
     *
     * @return The value of the field "device"
     */
    inline const ::std::string& getDevice () const;

    /**
     * Retrieves the value of the field "device" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "device".
     */
    inline ::std::string& getDeviceMutable ();

    /**
     * Sets the value of the member "device".
     *
     * If the meaning of "device" isn't clear, then there should be a description here.
     *
     * @param device The value which will be set
     */
    inline void setDevice (const ::std::string& device_);

    /**
     * Sets the value of the member "device".
     *
     * If the meaning of "device" isn't clear, then there should be a description here.
     *
     * @param device The value which will be set
     */
    inline void setDevice (const char* device_);

    /**
     * Sets the value of the member "device".
     *
     * If the meaning of "device" isn't clear, then there should be a description here.
     *
     * @param device The value which will be set
     */
    inline void setDevice (const char* value, size_t size);

    static const RemoveLeDeviceRequest &getDefaultInstance();

private:

    inline void set_has_device ();

    inline void clear_has_device ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _device;

};

/**
 * If the meaning of "AddressTypeUpdate" isn't clear, then there should be a description here.
 */
class AddressTypeUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AddressTypeUpdate ();

    /**
     * Copy constructor
     */
    inline  AddressTypeUpdate (const AddressTypeUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  AddressTypeUpdate (uint8 AddressType_);

    /**
     * Destructor
     */
    inline virtual  ~AddressTypeUpdate();

    /**
     * Assignment operator
     */
    inline AddressTypeUpdate& operator = (const AddressTypeUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AddressTypeUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AddressTypeUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AddressTypeUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AddressTypeUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "AddressType"

    static const int kAddressType = 0;

    /**
     * Clears the field "AddressType".
     *
     * The field will be set to its default value. The hasAddressType()
     * method will return false.
     */
    inline void clearAddressType();

    /**
     * Checks whether the field "AddressType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAddressType()). Otherwise it will return false.
     */
    inline bool hasAddressType () const;

    /**
     * Returns the value of the member "AddressType".
     *
     * If the meaning of "AddressType" isn't clear, then there should be a description here.
     *
     * @return The value of the field "AddressType"
     */
    inline uint8 getAddressType () const;

    /**
     * Sets the value of the member "AddressType".
     *
     * If the meaning of "AddressType" isn't clear, then there should be a description here.
     *
     * @param AddressType The value which will be set
     */
    inline void setAddressType (uint8 AddressType_);

    static const AddressTypeUpdate &getDefaultInstance();

private:

    inline void set_has_AddressType ();

    inline void clear_has_AddressType ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _AddressType;

};

/**
 * If the meaning of "AddressTypeRegister" isn't clear, then there should be a description here.
 */
class AddressTypeRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AddressTypeRegister ();

    /**
     * Copy constructor
     */
    inline  AddressTypeRegister (const AddressTypeRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~AddressTypeRegister();

    /**
     * Assignment operator
     */
    inline AddressTypeRegister& operator = (const AddressTypeRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AddressTypeRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AddressTypeRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AddressTypeRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AddressTypeRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const AddressTypeRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "AddressUpdate" isn't clear, then there should be a description here.
 */
class AddressUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AddressUpdate ();

    /**
     * Copy constructor
     */
    inline  AddressUpdate (const AddressUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  AddressUpdate (const ::std::string& Address_);

    /**
     * Destructor
     */
    inline virtual  ~AddressUpdate();

    /**
     * Assignment operator
     */
    inline AddressUpdate& operator = (const AddressUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AddressUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AddressUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AddressUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AddressUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Address"

    static const int kAddress = 0;

    /**
     * Clears the field "Address".
     *
     * The field will be set to its default value. The hasAddress()
     * method will return false.
     */
    inline void clearAddress();

    /**
     * Checks whether the field "Address" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAddress()). Otherwise it will return false.
     */
    inline bool hasAddress () const;

    /**
     * Returns the value of the member "Address".
     *
     * If the meaning of "Address" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Address"
     */
    inline const ::std::string& getAddress () const;

    /**
     * Retrieves the value of the field "Address" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Address".
     */
    inline ::std::string& getAddressMutable ();

    /**
     * Sets the value of the member "Address".
     *
     * If the meaning of "Address" isn't clear, then there should be a description here.
     *
     * @param Address The value which will be set
     */
    inline void setAddress (const ::std::string& Address_);

    /**
     * Sets the value of the member "Address".
     *
     * If the meaning of "Address" isn't clear, then there should be a description here.
     *
     * @param Address The value which will be set
     */
    inline void setAddress (const char* Address_);

    /**
     * Sets the value of the member "Address".
     *
     * If the meaning of "Address" isn't clear, then there should be a description here.
     *
     * @param Address The value which will be set
     */
    inline void setAddress (const char* value, size_t size);

    static const AddressUpdate &getDefaultInstance();

private:

    inline void set_has_Address ();

    inline void clear_has_Address ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _Address;

};

/**
 * If the meaning of "AddressRegister" isn't clear, then there should be a description here.
 */
class AddressRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AddressRegister ();

    /**
     * Copy constructor
     */
    inline  AddressRegister (const AddressRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~AddressRegister();

    /**
     * Assignment operator
     */
    inline AddressRegister& operator = (const AddressRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AddressRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AddressRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AddressRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AddressRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const AddressRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "AliasUpdate" isn't clear, then there should be a description here.
 */
class AliasUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AliasUpdate ();

    /**
     * Copy constructor
     */
    inline  AliasUpdate (const AliasUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  AliasUpdate (const ::std::string& Alias_);

    /**
     * Destructor
     */
    inline virtual  ~AliasUpdate();

    /**
     * Assignment operator
     */
    inline AliasUpdate& operator = (const AliasUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AliasUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AliasUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AliasUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AliasUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Alias"

    static const int kAlias = 0;

    /**
     * Clears the field "Alias".
     *
     * The field will be set to its default value. The hasAlias()
     * method will return false.
     */
    inline void clearAlias();

    /**
     * Checks whether the field "Alias" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAlias()). Otherwise it will return false.
     */
    inline bool hasAlias () const;

    /**
     * Returns the value of the member "Alias".
     *
     * If the meaning of "Alias" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Alias"
     */
    inline const ::std::string& getAlias () const;

    /**
     * Retrieves the value of the field "Alias" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Alias".
     */
    inline ::std::string& getAliasMutable ();

    /**
     * Sets the value of the member "Alias".
     *
     * If the meaning of "Alias" isn't clear, then there should be a description here.
     *
     * @param Alias The value which will be set
     */
    inline void setAlias (const ::std::string& Alias_);

    /**
     * Sets the value of the member "Alias".
     *
     * If the meaning of "Alias" isn't clear, then there should be a description here.
     *
     * @param Alias The value which will be set
     */
    inline void setAlias (const char* Alias_);

    /**
     * Sets the value of the member "Alias".
     *
     * If the meaning of "Alias" isn't clear, then there should be a description here.
     *
     * @param Alias The value which will be set
     */
    inline void setAlias (const char* value, size_t size);

    static const AliasUpdate &getDefaultInstance();

private:

    inline void set_has_Alias ();

    inline void clear_has_Alias ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _Alias;

};

/**
 * If the meaning of "AliasRegister" isn't clear, then there should be a description here.
 */
class AliasRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AliasRegister ();

    /**
     * Copy constructor
     */
    inline  AliasRegister (const AliasRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~AliasRegister();

    /**
     * Assignment operator
     */
    inline AliasRegister& operator = (const AliasRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AliasRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AliasRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AliasRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AliasRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const AliasRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "AdvertisingTimeoutUpdate" isn't clear, then there should be a description here.
 */
class AdvertisingTimeoutUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AdvertisingTimeoutUpdate ();

    /**
     * Copy constructor
     */
    inline  AdvertisingTimeoutUpdate (const AdvertisingTimeoutUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  AdvertisingTimeoutUpdate (uint8 AdvertisingTimeout_);

    /**
     * Destructor
     */
    inline virtual  ~AdvertisingTimeoutUpdate();

    /**
     * Assignment operator
     */
    inline AdvertisingTimeoutUpdate& operator = (const AdvertisingTimeoutUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AdvertisingTimeoutUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AdvertisingTimeoutUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AdvertisingTimeoutUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AdvertisingTimeoutUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "AdvertisingTimeout"

    static const int kAdvertisingTimeout = 0;

    /**
     * Clears the field "AdvertisingTimeout".
     *
     * The field will be set to its default value. The hasAdvertisingTimeout()
     * method will return false.
     */
    inline void clearAdvertisingTimeout();

    /**
     * Checks whether the field "AdvertisingTimeout" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAdvertisingTimeout()). Otherwise it will return false.
     */
    inline bool hasAdvertisingTimeout () const;

    /**
     * Returns the value of the member "AdvertisingTimeout".
     *
     * If the meaning of "AdvertisingTimeout" isn't clear, then there should be a description here.
     *
     * @return The value of the field "AdvertisingTimeout"
     */
    inline uint8 getAdvertisingTimeout () const;

    /**
     * Sets the value of the member "AdvertisingTimeout".
     *
     * If the meaning of "AdvertisingTimeout" isn't clear, then there should be a description here.
     *
     * @param AdvertisingTimeout The value which will be set
     */
    inline void setAdvertisingTimeout (uint8 AdvertisingTimeout_);

    static const AdvertisingTimeoutUpdate &getDefaultInstance();

private:

    inline void set_has_AdvertisingTimeout ();

    inline void clear_has_AdvertisingTimeout ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _AdvertisingTimeout;

};

/**
 * If the meaning of "AdvertisingTimeoutRegister" isn't clear, then there should be a description here.
 */
class AdvertisingTimeoutRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AdvertisingTimeoutRegister ();

    /**
     * Copy constructor
     */
    inline  AdvertisingTimeoutRegister (const AdvertisingTimeoutRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~AdvertisingTimeoutRegister();

    /**
     * Assignment operator
     */
    inline AdvertisingTimeoutRegister& operator = (const AdvertisingTimeoutRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AdvertisingTimeoutRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AdvertisingTimeoutRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AdvertisingTimeoutRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AdvertisingTimeoutRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const AdvertisingTimeoutRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "DiscoverableModeUpdate" isn't clear, then there should be a description here.
 */
class DiscoverableModeUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DiscoverableModeUpdate ();

    /**
     * Copy constructor
     */
    inline  DiscoverableModeUpdate (const DiscoverableModeUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  DiscoverableModeUpdate (uint8 DiscoverableMode_);

    /**
     * Destructor
     */
    inline virtual  ~DiscoverableModeUpdate();

    /**
     * Assignment operator
     */
    inline DiscoverableModeUpdate& operator = (const DiscoverableModeUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DiscoverableModeUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DiscoverableModeUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DiscoverableModeUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DiscoverableModeUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DiscoverableMode"

    static const int kDiscoverableMode = 0;

    /**
     * Clears the field "DiscoverableMode".
     *
     * The field will be set to its default value. The hasDiscoverableMode()
     * method will return false.
     */
    inline void clearDiscoverableMode();

    /**
     * Checks whether the field "DiscoverableMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDiscoverableMode()). Otherwise it will return false.
     */
    inline bool hasDiscoverableMode () const;

    /**
     * Returns the value of the member "DiscoverableMode".
     *
     * If the meaning of "DiscoverableMode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DiscoverableMode"
     */
    inline uint8 getDiscoverableMode () const;

    /**
     * Sets the value of the member "DiscoverableMode".
     *
     * If the meaning of "DiscoverableMode" isn't clear, then there should be a description here.
     *
     * @param DiscoverableMode The value which will be set
     */
    inline void setDiscoverableMode (uint8 DiscoverableMode_);

    static const DiscoverableModeUpdate &getDefaultInstance();

private:

    inline void set_has_DiscoverableMode ();

    inline void clear_has_DiscoverableMode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _DiscoverableMode;

};

/**
 * If the meaning of "DiscoverableModeRegister" isn't clear, then there should be a description here.
 */
class DiscoverableModeRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DiscoverableModeRegister ();

    /**
     * Copy constructor
     */
    inline  DiscoverableModeRegister (const DiscoverableModeRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~DiscoverableModeRegister();

    /**
     * Assignment operator
     */
    inline DiscoverableModeRegister& operator = (const DiscoverableModeRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DiscoverableModeRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DiscoverableModeRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DiscoverableModeRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DiscoverableModeRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const DiscoverableModeRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "AdvertisingDataUpdate" isn't clear, then there should be a description here.
 */
class AdvertisingDataUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AdvertisingDataUpdate ();

    /**
     * Copy constructor
     */
    inline  AdvertisingDataUpdate (const AdvertisingDataUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  AdvertisingDataUpdate (const ::std::vector< uint8 >& AdvertisingData_);

    /**
     * Destructor
     */
    inline virtual  ~AdvertisingDataUpdate();

    /**
     * Assignment operator
     */
    inline AdvertisingDataUpdate& operator = (const AdvertisingDataUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AdvertisingDataUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AdvertisingDataUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AdvertisingDataUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AdvertisingDataUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "AdvertisingData"

    static const int kAdvertisingData = 0;

    /**
     * Clears the field "AdvertisingData".
     *
     * The field will be set to its default value. The hasAdvertisingData()
     * method will return false.
     */
    inline void clearAdvertisingData();

    /**
     * Checks whether the field "AdvertisingData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAdvertisingData()). Otherwise it will return false.
     */
    inline bool hasAdvertisingData () const;

    /**
     * Returns the value of the member "AdvertisingData".
     *
     * If the meaning of "AdvertisingData" isn't clear, then there should be a description here.
     *
     * @return The value of the field "AdvertisingData"
     */
    inline const ::std::vector< uint8 >& getAdvertisingData () const;

    /**
     * Retrieves the value of the field "AdvertisingData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "AdvertisingData".
     */
    inline ::std::vector< uint8 >& getAdvertisingDataMutable ();

    /**
     * Sets the value of the member "AdvertisingData".
     *
     * If the meaning of "AdvertisingData" isn't clear, then there should be a description here.
     *
     * @param AdvertisingData The value which will be set
     */
    inline void setAdvertisingData (const ::std::vector< uint8 >& AdvertisingData_);

    static const AdvertisingDataUpdate &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_AdvertisingData ();

    inline void clear_has_AdvertisingData ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< uint8 > _AdvertisingData;

};

/**
 * If the meaning of "AdvertisingDataRegister" isn't clear, then there should be a description here.
 */
class AdvertisingDataRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AdvertisingDataRegister ();

    /**
     * Copy constructor
     */
    inline  AdvertisingDataRegister (const AdvertisingDataRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~AdvertisingDataRegister();

    /**
     * Assignment operator
     */
    inline AdvertisingDataRegister& operator = (const AdvertisingDataRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AdvertisingDataRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AdvertisingDataRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AdvertisingDataRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AdvertisingDataRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const AdvertisingDataRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "AdvertiseEnableUpdate" isn't clear, then there should be a description here.
 */
class AdvertiseEnableUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AdvertiseEnableUpdate ();

    /**
     * Copy constructor
     */
    inline  AdvertiseEnableUpdate (const AdvertiseEnableUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  AdvertiseEnableUpdate (bool AdvertiseEnable_);

    /**
     * Destructor
     */
    inline virtual  ~AdvertiseEnableUpdate();

    /**
     * Assignment operator
     */
    inline AdvertiseEnableUpdate& operator = (const AdvertiseEnableUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AdvertiseEnableUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AdvertiseEnableUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AdvertiseEnableUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AdvertiseEnableUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "AdvertiseEnable"

    static const int kAdvertiseEnable = 0;

    /**
     * Clears the field "AdvertiseEnable".
     *
     * The field will be set to its default value. The hasAdvertiseEnable()
     * method will return false.
     */
    inline void clearAdvertiseEnable();

    /**
     * Checks whether the field "AdvertiseEnable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAdvertiseEnable()). Otherwise it will return false.
     */
    inline bool hasAdvertiseEnable () const;

    /**
     * Returns the value of the member "AdvertiseEnable".
     *
     * If the meaning of "AdvertiseEnable" isn't clear, then there should be a description here.
     *
     * @return The value of the field "AdvertiseEnable"
     */
    inline bool getAdvertiseEnable () const;

    /**
     * Sets the value of the member "AdvertiseEnable".
     *
     * If the meaning of "AdvertiseEnable" isn't clear, then there should be a description here.
     *
     * @param AdvertiseEnable The value which will be set
     */
    inline void setAdvertiseEnable (bool AdvertiseEnable_);

    static const AdvertiseEnableUpdate &getDefaultInstance();

private:

    inline void set_has_AdvertiseEnable ();

    inline void clear_has_AdvertiseEnable ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _AdvertiseEnable;

};

/**
 * If the meaning of "AdvertiseEnableRegister" isn't clear, then there should be a description here.
 */
class AdvertiseEnableRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AdvertiseEnableRegister ();

    /**
     * Copy constructor
     */
    inline  AdvertiseEnableRegister (const AdvertiseEnableRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~AdvertiseEnableRegister();

    /**
     * Assignment operator
     */
    inline AdvertiseEnableRegister& operator = (const AdvertiseEnableRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AdvertiseEnableRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AdvertiseEnableRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AdvertiseEnableRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AdvertiseEnableRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const AdvertiseEnableRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "LeDeviceCreatedSignal" isn't clear, then there should be a description here.
 */
class LeDeviceCreatedSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  LeDeviceCreatedSignal ();

    /**
     * Copy constructor
     */
    inline  LeDeviceCreatedSignal (const LeDeviceCreatedSignal &rhs);

    /**
     * All fields constructor
     */
    inline  LeDeviceCreatedSignal (const ::std::string& device_);

    /**
     * Destructor
     */
    inline virtual  ~LeDeviceCreatedSignal();

    /**
     * Assignment operator
     */
    inline LeDeviceCreatedSignal& operator = (const LeDeviceCreatedSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const LeDeviceCreatedSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const LeDeviceCreatedSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const LeDeviceCreatedSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const LeDeviceCreatedSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "device"

    static const int kDevice = 0;

    /**
     * Clears the field "device".
     *
     * The field will be set to its default value. The hasDevice()
     * method will return false.
     */
    inline void clearDevice();

    /**
     * Checks whether the field "device" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDevice()). Otherwise it will return false.
     */
    inline bool hasDevice () const;

    /**
     * Returns the value of the member "device".
     *
     * If the meaning of "device" isn't clear, then there should be a description here.
     *
     * @return The value of the field "device"
     */
    inline const ::std::string& getDevice () const;

    /**
     * Retrieves the value of the field "device" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "device".
     */
    inline ::std::string& getDeviceMutable ();

    /**
     * Sets the value of the member "device".
     *
     * If the meaning of "device" isn't clear, then there should be a description here.
     *
     * @param device The value which will be set
     */
    inline void setDevice (const ::std::string& device_);

    /**
     * Sets the value of the member "device".
     *
     * If the meaning of "device" isn't clear, then there should be a description here.
     *
     * @param device The value which will be set
     */
    inline void setDevice (const char* device_);

    /**
     * Sets the value of the member "device".
     *
     * If the meaning of "device" isn't clear, then there should be a description here.
     *
     * @param device The value which will be set
     */
    inline void setDevice (const char* value, size_t size);

    static const LeDeviceCreatedSignal &getDefaultInstance();

private:

    inline void set_has_device ();

    inline void clear_has_device ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _device;

};

/**
 * If the meaning of "LeDeviceRemovedSignal" isn't clear, then there should be a description here.
 */
class LeDeviceRemovedSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  LeDeviceRemovedSignal ();

    /**
     * Copy constructor
     */
    inline  LeDeviceRemovedSignal (const LeDeviceRemovedSignal &rhs);

    /**
     * All fields constructor
     */
    inline  LeDeviceRemovedSignal (const ::std::string& device_);

    /**
     * Destructor
     */
    inline virtual  ~LeDeviceRemovedSignal();

    /**
     * Assignment operator
     */
    inline LeDeviceRemovedSignal& operator = (const LeDeviceRemovedSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const LeDeviceRemovedSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const LeDeviceRemovedSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const LeDeviceRemovedSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const LeDeviceRemovedSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "device"

    static const int kDevice = 0;

    /**
     * Clears the field "device".
     *
     * The field will be set to its default value. The hasDevice()
     * method will return false.
     */
    inline void clearDevice();

    /**
     * Checks whether the field "device" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDevice()). Otherwise it will return false.
     */
    inline bool hasDevice () const;

    /**
     * Returns the value of the member "device".
     *
     * If the meaning of "device" isn't clear, then there should be a description here.
     *
     * @return The value of the field "device"
     */
    inline const ::std::string& getDevice () const;

    /**
     * Retrieves the value of the field "device" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "device".
     */
    inline ::std::string& getDeviceMutable ();

    /**
     * Sets the value of the member "device".
     *
     * If the meaning of "device" isn't clear, then there should be a description here.
     *
     * @param device The value which will be set
     */
    inline void setDevice (const ::std::string& device_);

    /**
     * Sets the value of the member "device".
     *
     * If the meaning of "device" isn't clear, then there should be a description here.
     *
     * @param device The value which will be set
     */
    inline void setDevice (const char* device_);

    /**
     * Sets the value of the member "device".
     *
     * If the meaning of "device" isn't clear, then there should be a description here.
     *
     * @param device The value which will be set
     */
    inline void setDevice (const char* value, size_t size);

    static const LeDeviceRemovedSignal &getDefaultInstance();

private:

    inline void set_has_device ();

    inline void clear_has_device ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _device;

};

inline  CreateLeDeviceRequest::CreateLeDeviceRequest ()  :
    _address ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  CreateLeDeviceRequest::CreateLeDeviceRequest (const CreateLeDeviceRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _address ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  CreateLeDeviceRequest::CreateLeDeviceRequest (const ::std::string& address_)  :
    _address (address_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (address_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  CreateLeDeviceRequest::~CreateLeDeviceRequest() {
}

inline CreateLeDeviceRequest& CreateLeDeviceRequest::operator = (const CreateLeDeviceRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAddress()) {
            setAddress(rhs.getAddress());
        } else {
            clearAddress();
        }
    }
    return *this;
}

inline bool CreateLeDeviceRequest::operator == (const CreateLeDeviceRequest& rhs) const {
    return (((!hasAddress() && !rhs.hasAddress()) || getAddress() == rhs.getAddress()));
}

inline bool CreateLeDeviceRequest::operator != (const CreateLeDeviceRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool CreateLeDeviceRequest::operator < (const CreateLeDeviceRequest& rhs) const {
    if (hasAddress() || rhs.hasAddress()) {
        if (getAddress() < rhs.getAddress()) return true;
        if (getAddress() > rhs.getAddress()) return false;
    }
    return false;
}

inline ::asf::core::Payload* CreateLeDeviceRequest::clone() {
    return new CreateLeDeviceRequest(*this);
}

inline bool CreateLeDeviceRequest::operator > (const CreateLeDeviceRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void CreateLeDeviceRequest::clear() {
    clearAddress();
}

inline void CreateLeDeviceRequest::clearAddress() {
    if (hasAddress()) {
         clear_has_address();
        _address.clear();
     }
}

inline bool CreateLeDeviceRequest::hasAddress () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& CreateLeDeviceRequest::getAddress () const {
    return _address;
}

inline ::std::string& CreateLeDeviceRequest::getAddressMutable () {
    set_has_address();
    return _address;
}

inline void CreateLeDeviceRequest::setAddress (const ::std::string& address_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (address_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_address();
    this->_address = address_;
}

inline void CreateLeDeviceRequest::setAddress (const char* address_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (address_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_address();
    this->_address.assign(address_);
}

inline void CreateLeDeviceRequest::setAddress (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_address();
    this->_address.assign(value, size);
}

inline void CreateLeDeviceRequest::set_has_address () {
    _has_bits_[0] |= 1u << 0;
}

inline void CreateLeDeviceRequest::clear_has_address () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  CreateLeDeviceResponse::CreateLeDeviceResponse ()  :
    _device ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  CreateLeDeviceResponse::CreateLeDeviceResponse (const CreateLeDeviceResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _device ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  CreateLeDeviceResponse::CreateLeDeviceResponse (const ::std::string& device_)  :
    _device (device_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (device_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  CreateLeDeviceResponse::~CreateLeDeviceResponse() {
}

inline CreateLeDeviceResponse& CreateLeDeviceResponse::operator = (const CreateLeDeviceResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDevice()) {
            setDevice(rhs.getDevice());
        } else {
            clearDevice();
        }
    }
    return *this;
}

inline bool CreateLeDeviceResponse::operator == (const CreateLeDeviceResponse& rhs) const {
    return (((!hasDevice() && !rhs.hasDevice()) || getDevice() == rhs.getDevice()));
}

inline bool CreateLeDeviceResponse::operator != (const CreateLeDeviceResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool CreateLeDeviceResponse::operator < (const CreateLeDeviceResponse& rhs) const {
    if (hasDevice() || rhs.hasDevice()) {
        if (getDevice() < rhs.getDevice()) return true;
        if (getDevice() > rhs.getDevice()) return false;
    }
    return false;
}

inline ::asf::core::Payload* CreateLeDeviceResponse::clone() {
    return new CreateLeDeviceResponse(*this);
}

inline bool CreateLeDeviceResponse::operator > (const CreateLeDeviceResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void CreateLeDeviceResponse::clear() {
    clearDevice();
}

inline void CreateLeDeviceResponse::clearDevice() {
    if (hasDevice()) {
         clear_has_device();
        _device.clear();
     }
}

inline bool CreateLeDeviceResponse::hasDevice () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& CreateLeDeviceResponse::getDevice () const {
    return _device;
}

inline ::std::string& CreateLeDeviceResponse::getDeviceMutable () {
    set_has_device();
    return _device;
}

inline void CreateLeDeviceResponse::setDevice (const ::std::string& device_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (device_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_device();
    this->_device = device_;
}

inline void CreateLeDeviceResponse::setDevice (const char* device_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (device_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_device();
    this->_device.assign(device_);
}

inline void CreateLeDeviceResponse::setDevice (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_device();
    this->_device.assign(value, size);
}

inline void CreateLeDeviceResponse::set_has_device () {
    _has_bits_[0] |= 1u << 0;
}

inline void CreateLeDeviceResponse::clear_has_device () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  RemoveLeDeviceRequest::RemoveLeDeviceRequest ()  :
    _device ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RemoveLeDeviceRequest::RemoveLeDeviceRequest (const RemoveLeDeviceRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _device ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RemoveLeDeviceRequest::RemoveLeDeviceRequest (const ::std::string& device_)  :
    _device (device_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (device_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RemoveLeDeviceRequest::~RemoveLeDeviceRequest() {
}

inline RemoveLeDeviceRequest& RemoveLeDeviceRequest::operator = (const RemoveLeDeviceRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDevice()) {
            setDevice(rhs.getDevice());
        } else {
            clearDevice();
        }
    }
    return *this;
}

inline bool RemoveLeDeviceRequest::operator == (const RemoveLeDeviceRequest& rhs) const {
    return (((!hasDevice() && !rhs.hasDevice()) || getDevice() == rhs.getDevice()));
}

inline bool RemoveLeDeviceRequest::operator != (const RemoveLeDeviceRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool RemoveLeDeviceRequest::operator < (const RemoveLeDeviceRequest& rhs) const {
    if (hasDevice() || rhs.hasDevice()) {
        if (getDevice() < rhs.getDevice()) return true;
        if (getDevice() > rhs.getDevice()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RemoveLeDeviceRequest::clone() {
    return new RemoveLeDeviceRequest(*this);
}

inline bool RemoveLeDeviceRequest::operator > (const RemoveLeDeviceRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RemoveLeDeviceRequest::clear() {
    clearDevice();
}

inline void RemoveLeDeviceRequest::clearDevice() {
    if (hasDevice()) {
         clear_has_device();
        _device.clear();
     }
}

inline bool RemoveLeDeviceRequest::hasDevice () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& RemoveLeDeviceRequest::getDevice () const {
    return _device;
}

inline ::std::string& RemoveLeDeviceRequest::getDeviceMutable () {
    set_has_device();
    return _device;
}

inline void RemoveLeDeviceRequest::setDevice (const ::std::string& device_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (device_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_device();
    this->_device = device_;
}

inline void RemoveLeDeviceRequest::setDevice (const char* device_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (device_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_device();
    this->_device.assign(device_);
}

inline void RemoveLeDeviceRequest::setDevice (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_device();
    this->_device.assign(value, size);
}

inline void RemoveLeDeviceRequest::set_has_device () {
    _has_bits_[0] |= 1u << 0;
}

inline void RemoveLeDeviceRequest::clear_has_device () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  AddressTypeUpdate::AddressTypeUpdate ()  :
    _AddressType (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AddressTypeUpdate::AddressTypeUpdate (const AddressTypeUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _AddressType (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AddressTypeUpdate::AddressTypeUpdate (uint8 AddressType_)  :
    _AddressType (AddressType_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AddressTypeUpdate::~AddressTypeUpdate() {
}

inline AddressTypeUpdate& AddressTypeUpdate::operator = (const AddressTypeUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAddressType()) {
            setAddressType(rhs.getAddressType());
        } else {
            clearAddressType();
        }
    }
    return *this;
}

inline bool AddressTypeUpdate::operator == (const AddressTypeUpdate& rhs) const {
    return (((!hasAddressType() && !rhs.hasAddressType()) || getAddressType() == rhs.getAddressType()));
}

inline bool AddressTypeUpdate::operator != (const AddressTypeUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool AddressTypeUpdate::operator < (const AddressTypeUpdate& rhs) const {
    if (hasAddressType() || rhs.hasAddressType()) {
        if (getAddressType() < rhs.getAddressType()) return true;
        if (getAddressType() > rhs.getAddressType()) return false;
    }
    return false;
}

inline ::asf::core::Payload* AddressTypeUpdate::clone() {
    return new AddressTypeUpdate(*this);
}

inline bool AddressTypeUpdate::operator > (const AddressTypeUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AddressTypeUpdate::clear() {
    clearAddressType();
}

inline void AddressTypeUpdate::clearAddressType() {
    if (hasAddressType()) {
         clear_has_AddressType();
        _AddressType = 0u;
     }
}

inline bool AddressTypeUpdate::hasAddressType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 AddressTypeUpdate::getAddressType () const {
    return _AddressType;
}

inline void AddressTypeUpdate::setAddressType (uint8 AddressType_) {
    set_has_AddressType();
    this->_AddressType = AddressType_;
}

inline void AddressTypeUpdate::set_has_AddressType () {
    _has_bits_[0] |= 1u << 0;
}

inline void AddressTypeUpdate::clear_has_AddressType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  AddressTypeRegister::AddressTypeRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AddressTypeRegister::AddressTypeRegister (const AddressTypeRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AddressTypeRegister::~AddressTypeRegister() {
}

inline AddressTypeRegister& AddressTypeRegister::operator = (const AddressTypeRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool AddressTypeRegister::operator == (const AddressTypeRegister& ) const {
    return true;
}

inline bool AddressTypeRegister::operator != (const AddressTypeRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool AddressTypeRegister::operator < (const AddressTypeRegister& ) const {
    return false;
}

inline ::asf::core::Payload* AddressTypeRegister::clone() {
    return new AddressTypeRegister(*this);
}

inline bool AddressTypeRegister::operator > (const AddressTypeRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AddressTypeRegister::clear() {
}

inline  AddressUpdate::AddressUpdate ()  :
    _Address ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AddressUpdate::AddressUpdate (const AddressUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _Address ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AddressUpdate::AddressUpdate (const ::std::string& Address_)  :
    _Address (Address_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Address_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AddressUpdate::~AddressUpdate() {
}

inline AddressUpdate& AddressUpdate::operator = (const AddressUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAddress()) {
            setAddress(rhs.getAddress());
        } else {
            clearAddress();
        }
    }
    return *this;
}

inline bool AddressUpdate::operator == (const AddressUpdate& rhs) const {
    return (((!hasAddress() && !rhs.hasAddress()) || getAddress() == rhs.getAddress()));
}

inline bool AddressUpdate::operator != (const AddressUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool AddressUpdate::operator < (const AddressUpdate& rhs) const {
    if (hasAddress() || rhs.hasAddress()) {
        if (getAddress() < rhs.getAddress()) return true;
        if (getAddress() > rhs.getAddress()) return false;
    }
    return false;
}

inline ::asf::core::Payload* AddressUpdate::clone() {
    return new AddressUpdate(*this);
}

inline bool AddressUpdate::operator > (const AddressUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AddressUpdate::clear() {
    clearAddress();
}

inline void AddressUpdate::clearAddress() {
    if (hasAddress()) {
         clear_has_Address();
        _Address.clear();
     }
}

inline bool AddressUpdate::hasAddress () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& AddressUpdate::getAddress () const {
    return _Address;
}

inline ::std::string& AddressUpdate::getAddressMutable () {
    set_has_Address();
    return _Address;
}

inline void AddressUpdate::setAddress (const ::std::string& Address_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Address_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Address();
    this->_Address = Address_;
}

inline void AddressUpdate::setAddress (const char* Address_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Address_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Address();
    this->_Address.assign(Address_);
}

inline void AddressUpdate::setAddress (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Address();
    this->_Address.assign(value, size);
}

inline void AddressUpdate::set_has_Address () {
    _has_bits_[0] |= 1u << 0;
}

inline void AddressUpdate::clear_has_Address () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  AddressRegister::AddressRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AddressRegister::AddressRegister (const AddressRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AddressRegister::~AddressRegister() {
}

inline AddressRegister& AddressRegister::operator = (const AddressRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool AddressRegister::operator == (const AddressRegister& ) const {
    return true;
}

inline bool AddressRegister::operator != (const AddressRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool AddressRegister::operator < (const AddressRegister& ) const {
    return false;
}

inline ::asf::core::Payload* AddressRegister::clone() {
    return new AddressRegister(*this);
}

inline bool AddressRegister::operator > (const AddressRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AddressRegister::clear() {
}

inline  AliasUpdate::AliasUpdate ()  :
    _Alias ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AliasUpdate::AliasUpdate (const AliasUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _Alias ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AliasUpdate::AliasUpdate (const ::std::string& Alias_)  :
    _Alias (Alias_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Alias_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AliasUpdate::~AliasUpdate() {
}

inline AliasUpdate& AliasUpdate::operator = (const AliasUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAlias()) {
            setAlias(rhs.getAlias());
        } else {
            clearAlias();
        }
    }
    return *this;
}

inline bool AliasUpdate::operator == (const AliasUpdate& rhs) const {
    return (((!hasAlias() && !rhs.hasAlias()) || getAlias() == rhs.getAlias()));
}

inline bool AliasUpdate::operator != (const AliasUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool AliasUpdate::operator < (const AliasUpdate& rhs) const {
    if (hasAlias() || rhs.hasAlias()) {
        if (getAlias() < rhs.getAlias()) return true;
        if (getAlias() > rhs.getAlias()) return false;
    }
    return false;
}

inline ::asf::core::Payload* AliasUpdate::clone() {
    return new AliasUpdate(*this);
}

inline bool AliasUpdate::operator > (const AliasUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AliasUpdate::clear() {
    clearAlias();
}

inline void AliasUpdate::clearAlias() {
    if (hasAlias()) {
         clear_has_Alias();
        _Alias.clear();
     }
}

inline bool AliasUpdate::hasAlias () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& AliasUpdate::getAlias () const {
    return _Alias;
}

inline ::std::string& AliasUpdate::getAliasMutable () {
    set_has_Alias();
    return _Alias;
}

inline void AliasUpdate::setAlias (const ::std::string& Alias_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Alias_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Alias();
    this->_Alias = Alias_;
}

inline void AliasUpdate::setAlias (const char* Alias_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Alias_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Alias();
    this->_Alias.assign(Alias_);
}

inline void AliasUpdate::setAlias (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Alias();
    this->_Alias.assign(value, size);
}

inline void AliasUpdate::set_has_Alias () {
    _has_bits_[0] |= 1u << 0;
}

inline void AliasUpdate::clear_has_Alias () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  AliasRegister::AliasRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AliasRegister::AliasRegister (const AliasRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AliasRegister::~AliasRegister() {
}

inline AliasRegister& AliasRegister::operator = (const AliasRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool AliasRegister::operator == (const AliasRegister& ) const {
    return true;
}

inline bool AliasRegister::operator != (const AliasRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool AliasRegister::operator < (const AliasRegister& ) const {
    return false;
}

inline ::asf::core::Payload* AliasRegister::clone() {
    return new AliasRegister(*this);
}

inline bool AliasRegister::operator > (const AliasRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AliasRegister::clear() {
}

inline  AdvertisingTimeoutUpdate::AdvertisingTimeoutUpdate ()  :
    _AdvertisingTimeout (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AdvertisingTimeoutUpdate::AdvertisingTimeoutUpdate (const AdvertisingTimeoutUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _AdvertisingTimeout (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AdvertisingTimeoutUpdate::AdvertisingTimeoutUpdate (uint8 AdvertisingTimeout_)  :
    _AdvertisingTimeout (AdvertisingTimeout_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AdvertisingTimeoutUpdate::~AdvertisingTimeoutUpdate() {
}

inline AdvertisingTimeoutUpdate& AdvertisingTimeoutUpdate::operator = (const AdvertisingTimeoutUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAdvertisingTimeout()) {
            setAdvertisingTimeout(rhs.getAdvertisingTimeout());
        } else {
            clearAdvertisingTimeout();
        }
    }
    return *this;
}

inline bool AdvertisingTimeoutUpdate::operator == (const AdvertisingTimeoutUpdate& rhs) const {
    return (((!hasAdvertisingTimeout() && !rhs.hasAdvertisingTimeout()) || getAdvertisingTimeout() == rhs.getAdvertisingTimeout()));
}

inline bool AdvertisingTimeoutUpdate::operator != (const AdvertisingTimeoutUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool AdvertisingTimeoutUpdate::operator < (const AdvertisingTimeoutUpdate& rhs) const {
    if (hasAdvertisingTimeout() || rhs.hasAdvertisingTimeout()) {
        if (getAdvertisingTimeout() < rhs.getAdvertisingTimeout()) return true;
        if (getAdvertisingTimeout() > rhs.getAdvertisingTimeout()) return false;
    }
    return false;
}

inline ::asf::core::Payload* AdvertisingTimeoutUpdate::clone() {
    return new AdvertisingTimeoutUpdate(*this);
}

inline bool AdvertisingTimeoutUpdate::operator > (const AdvertisingTimeoutUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AdvertisingTimeoutUpdate::clear() {
    clearAdvertisingTimeout();
}

inline void AdvertisingTimeoutUpdate::clearAdvertisingTimeout() {
    if (hasAdvertisingTimeout()) {
         clear_has_AdvertisingTimeout();
        _AdvertisingTimeout = 0u;
     }
}

inline bool AdvertisingTimeoutUpdate::hasAdvertisingTimeout () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 AdvertisingTimeoutUpdate::getAdvertisingTimeout () const {
    return _AdvertisingTimeout;
}

inline void AdvertisingTimeoutUpdate::setAdvertisingTimeout (uint8 AdvertisingTimeout_) {
    set_has_AdvertisingTimeout();
    this->_AdvertisingTimeout = AdvertisingTimeout_;
}

inline void AdvertisingTimeoutUpdate::set_has_AdvertisingTimeout () {
    _has_bits_[0] |= 1u << 0;
}

inline void AdvertisingTimeoutUpdate::clear_has_AdvertisingTimeout () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  AdvertisingTimeoutRegister::AdvertisingTimeoutRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AdvertisingTimeoutRegister::AdvertisingTimeoutRegister (const AdvertisingTimeoutRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AdvertisingTimeoutRegister::~AdvertisingTimeoutRegister() {
}

inline AdvertisingTimeoutRegister& AdvertisingTimeoutRegister::operator = (const AdvertisingTimeoutRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool AdvertisingTimeoutRegister::operator == (const AdvertisingTimeoutRegister& ) const {
    return true;
}

inline bool AdvertisingTimeoutRegister::operator != (const AdvertisingTimeoutRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool AdvertisingTimeoutRegister::operator < (const AdvertisingTimeoutRegister& ) const {
    return false;
}

inline ::asf::core::Payload* AdvertisingTimeoutRegister::clone() {
    return new AdvertisingTimeoutRegister(*this);
}

inline bool AdvertisingTimeoutRegister::operator > (const AdvertisingTimeoutRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AdvertisingTimeoutRegister::clear() {
}

inline  DiscoverableModeUpdate::DiscoverableModeUpdate ()  :
    _DiscoverableMode (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DiscoverableModeUpdate::DiscoverableModeUpdate (const DiscoverableModeUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _DiscoverableMode (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DiscoverableModeUpdate::DiscoverableModeUpdate (uint8 DiscoverableMode_)  :
    _DiscoverableMode (DiscoverableMode_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DiscoverableModeUpdate::~DiscoverableModeUpdate() {
}

inline DiscoverableModeUpdate& DiscoverableModeUpdate::operator = (const DiscoverableModeUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDiscoverableMode()) {
            setDiscoverableMode(rhs.getDiscoverableMode());
        } else {
            clearDiscoverableMode();
        }
    }
    return *this;
}

inline bool DiscoverableModeUpdate::operator == (const DiscoverableModeUpdate& rhs) const {
    return (((!hasDiscoverableMode() && !rhs.hasDiscoverableMode()) || getDiscoverableMode() == rhs.getDiscoverableMode()));
}

inline bool DiscoverableModeUpdate::operator != (const DiscoverableModeUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool DiscoverableModeUpdate::operator < (const DiscoverableModeUpdate& rhs) const {
    if (hasDiscoverableMode() || rhs.hasDiscoverableMode()) {
        if (getDiscoverableMode() < rhs.getDiscoverableMode()) return true;
        if (getDiscoverableMode() > rhs.getDiscoverableMode()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DiscoverableModeUpdate::clone() {
    return new DiscoverableModeUpdate(*this);
}

inline bool DiscoverableModeUpdate::operator > (const DiscoverableModeUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DiscoverableModeUpdate::clear() {
    clearDiscoverableMode();
}

inline void DiscoverableModeUpdate::clearDiscoverableMode() {
    if (hasDiscoverableMode()) {
         clear_has_DiscoverableMode();
        _DiscoverableMode = 0u;
     }
}

inline bool DiscoverableModeUpdate::hasDiscoverableMode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 DiscoverableModeUpdate::getDiscoverableMode () const {
    return _DiscoverableMode;
}

inline void DiscoverableModeUpdate::setDiscoverableMode (uint8 DiscoverableMode_) {
    set_has_DiscoverableMode();
    this->_DiscoverableMode = DiscoverableMode_;
}

inline void DiscoverableModeUpdate::set_has_DiscoverableMode () {
    _has_bits_[0] |= 1u << 0;
}

inline void DiscoverableModeUpdate::clear_has_DiscoverableMode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DiscoverableModeRegister::DiscoverableModeRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DiscoverableModeRegister::DiscoverableModeRegister (const DiscoverableModeRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DiscoverableModeRegister::~DiscoverableModeRegister() {
}

inline DiscoverableModeRegister& DiscoverableModeRegister::operator = (const DiscoverableModeRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool DiscoverableModeRegister::operator == (const DiscoverableModeRegister& ) const {
    return true;
}

inline bool DiscoverableModeRegister::operator != (const DiscoverableModeRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool DiscoverableModeRegister::operator < (const DiscoverableModeRegister& ) const {
    return false;
}

inline ::asf::core::Payload* DiscoverableModeRegister::clone() {
    return new DiscoverableModeRegister(*this);
}

inline bool DiscoverableModeRegister::operator > (const DiscoverableModeRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DiscoverableModeRegister::clear() {
}

inline  AdvertisingDataUpdate::AdvertisingDataUpdate ()  :
    _AdvertisingData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AdvertisingDataUpdate::AdvertisingDataUpdate (const AdvertisingDataUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _AdvertisingData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AdvertisingDataUpdate::AdvertisingDataUpdate (const ::std::vector< uint8 >& AdvertisingData_)  :
    _AdvertisingData (AdvertisingData_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AdvertisingDataUpdate::~AdvertisingDataUpdate() {
}

inline AdvertisingDataUpdate& AdvertisingDataUpdate::operator = (const AdvertisingDataUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAdvertisingData()) {
            setAdvertisingData(rhs.getAdvertisingData());
        } else {
            clearAdvertisingData();
        }
    }
    return *this;
}

inline bool AdvertisingDataUpdate::operator == (const AdvertisingDataUpdate& rhs) const {
    return (((!hasAdvertisingData() && !rhs.hasAdvertisingData()) || getAdvertisingData() == rhs.getAdvertisingData()));
}

inline bool AdvertisingDataUpdate::operator != (const AdvertisingDataUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool AdvertisingDataUpdate::operator < (const AdvertisingDataUpdate& rhs) const {
    if (hasAdvertisingData() || rhs.hasAdvertisingData()) {
        if (getAdvertisingData() < rhs.getAdvertisingData()) return true;
        if (getAdvertisingData() > rhs.getAdvertisingData()) return false;
    }
    return false;
}

inline ::asf::core::Payload* AdvertisingDataUpdate::clone() {
    return new AdvertisingDataUpdate(*this);
}

inline bool AdvertisingDataUpdate::operator > (const AdvertisingDataUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AdvertisingDataUpdate::clear() {
    clearAdvertisingData();
}

inline void AdvertisingDataUpdate::clearAdvertisingData() {
    if (hasAdvertisingData()) {
         clear_has_AdvertisingData();
        _AdvertisingData.clear();
     }
}

inline bool AdvertisingDataUpdate::hasAdvertisingData () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< uint8 >& AdvertisingDataUpdate::getAdvertisingData () const {
    return _AdvertisingData;
}

inline ::std::vector< uint8 >& AdvertisingDataUpdate::getAdvertisingDataMutable () {
    set_has_AdvertisingData();
    return _AdvertisingData;
}

inline void AdvertisingDataUpdate::setAdvertisingData (const ::std::vector< uint8 >& AdvertisingData_) {
    set_has_AdvertisingData();
    this->_AdvertisingData = AdvertisingData_;
}

inline void AdvertisingDataUpdate::set_has_AdvertisingData () {
    _has_bits_[0] |= 1u << 0;
}

inline void AdvertisingDataUpdate::clear_has_AdvertisingData () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  AdvertisingDataRegister::AdvertisingDataRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AdvertisingDataRegister::AdvertisingDataRegister (const AdvertisingDataRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AdvertisingDataRegister::~AdvertisingDataRegister() {
}

inline AdvertisingDataRegister& AdvertisingDataRegister::operator = (const AdvertisingDataRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool AdvertisingDataRegister::operator == (const AdvertisingDataRegister& ) const {
    return true;
}

inline bool AdvertisingDataRegister::operator != (const AdvertisingDataRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool AdvertisingDataRegister::operator < (const AdvertisingDataRegister& ) const {
    return false;
}

inline ::asf::core::Payload* AdvertisingDataRegister::clone() {
    return new AdvertisingDataRegister(*this);
}

inline bool AdvertisingDataRegister::operator > (const AdvertisingDataRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AdvertisingDataRegister::clear() {
}

inline  AdvertiseEnableUpdate::AdvertiseEnableUpdate ()  :
    _AdvertiseEnable (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AdvertiseEnableUpdate::AdvertiseEnableUpdate (const AdvertiseEnableUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _AdvertiseEnable (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AdvertiseEnableUpdate::AdvertiseEnableUpdate (bool AdvertiseEnable_)  :
    _AdvertiseEnable (AdvertiseEnable_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AdvertiseEnableUpdate::~AdvertiseEnableUpdate() {
}

inline AdvertiseEnableUpdate& AdvertiseEnableUpdate::operator = (const AdvertiseEnableUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAdvertiseEnable()) {
            setAdvertiseEnable(rhs.getAdvertiseEnable());
        } else {
            clearAdvertiseEnable();
        }
    }
    return *this;
}

inline bool AdvertiseEnableUpdate::operator == (const AdvertiseEnableUpdate& rhs) const {
    return (((!hasAdvertiseEnable() && !rhs.hasAdvertiseEnable()) || getAdvertiseEnable() == rhs.getAdvertiseEnable()));
}

inline bool AdvertiseEnableUpdate::operator != (const AdvertiseEnableUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool AdvertiseEnableUpdate::operator < (const AdvertiseEnableUpdate& rhs) const {
    if (hasAdvertiseEnable() || rhs.hasAdvertiseEnable()) {
        if (getAdvertiseEnable() < rhs.getAdvertiseEnable()) return true;
        if (getAdvertiseEnable() > rhs.getAdvertiseEnable()) return false;
    }
    return false;
}

inline ::asf::core::Payload* AdvertiseEnableUpdate::clone() {
    return new AdvertiseEnableUpdate(*this);
}

inline bool AdvertiseEnableUpdate::operator > (const AdvertiseEnableUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AdvertiseEnableUpdate::clear() {
    clearAdvertiseEnable();
}

inline void AdvertiseEnableUpdate::clearAdvertiseEnable() {
    if (hasAdvertiseEnable()) {
         clear_has_AdvertiseEnable();
        _AdvertiseEnable = false;
     }
}

inline bool AdvertiseEnableUpdate::hasAdvertiseEnable () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool AdvertiseEnableUpdate::getAdvertiseEnable () const {
    return _AdvertiseEnable;
}

inline void AdvertiseEnableUpdate::setAdvertiseEnable (bool AdvertiseEnable_) {
    set_has_AdvertiseEnable();
    this->_AdvertiseEnable = AdvertiseEnable_;
}

inline void AdvertiseEnableUpdate::set_has_AdvertiseEnable () {
    _has_bits_[0] |= 1u << 0;
}

inline void AdvertiseEnableUpdate::clear_has_AdvertiseEnable () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  AdvertiseEnableRegister::AdvertiseEnableRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AdvertiseEnableRegister::AdvertiseEnableRegister (const AdvertiseEnableRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AdvertiseEnableRegister::~AdvertiseEnableRegister() {
}

inline AdvertiseEnableRegister& AdvertiseEnableRegister::operator = (const AdvertiseEnableRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool AdvertiseEnableRegister::operator == (const AdvertiseEnableRegister& ) const {
    return true;
}

inline bool AdvertiseEnableRegister::operator != (const AdvertiseEnableRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool AdvertiseEnableRegister::operator < (const AdvertiseEnableRegister& ) const {
    return false;
}

inline ::asf::core::Payload* AdvertiseEnableRegister::clone() {
    return new AdvertiseEnableRegister(*this);
}

inline bool AdvertiseEnableRegister::operator > (const AdvertiseEnableRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AdvertiseEnableRegister::clear() {
}

inline  LeDeviceCreatedSignal::LeDeviceCreatedSignal ()  :
    _device ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  LeDeviceCreatedSignal::LeDeviceCreatedSignal (const LeDeviceCreatedSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _device ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  LeDeviceCreatedSignal::LeDeviceCreatedSignal (const ::std::string& device_)  :
    _device (device_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (device_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  LeDeviceCreatedSignal::~LeDeviceCreatedSignal() {
}

inline LeDeviceCreatedSignal& LeDeviceCreatedSignal::operator = (const LeDeviceCreatedSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDevice()) {
            setDevice(rhs.getDevice());
        } else {
            clearDevice();
        }
    }
    return *this;
}

inline bool LeDeviceCreatedSignal::operator == (const LeDeviceCreatedSignal& rhs) const {
    return (((!hasDevice() && !rhs.hasDevice()) || getDevice() == rhs.getDevice()));
}

inline bool LeDeviceCreatedSignal::operator != (const LeDeviceCreatedSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool LeDeviceCreatedSignal::operator < (const LeDeviceCreatedSignal& rhs) const {
    if (hasDevice() || rhs.hasDevice()) {
        if (getDevice() < rhs.getDevice()) return true;
        if (getDevice() > rhs.getDevice()) return false;
    }
    return false;
}

inline ::asf::core::Payload* LeDeviceCreatedSignal::clone() {
    return new LeDeviceCreatedSignal(*this);
}

inline bool LeDeviceCreatedSignal::operator > (const LeDeviceCreatedSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void LeDeviceCreatedSignal::clear() {
    clearDevice();
}

inline void LeDeviceCreatedSignal::clearDevice() {
    if (hasDevice()) {
         clear_has_device();
        _device.clear();
     }
}

inline bool LeDeviceCreatedSignal::hasDevice () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& LeDeviceCreatedSignal::getDevice () const {
    return _device;
}

inline ::std::string& LeDeviceCreatedSignal::getDeviceMutable () {
    set_has_device();
    return _device;
}

inline void LeDeviceCreatedSignal::setDevice (const ::std::string& device_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (device_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_device();
    this->_device = device_;
}

inline void LeDeviceCreatedSignal::setDevice (const char* device_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (device_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_device();
    this->_device.assign(device_);
}

inline void LeDeviceCreatedSignal::setDevice (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_device();
    this->_device.assign(value, size);
}

inline void LeDeviceCreatedSignal::set_has_device () {
    _has_bits_[0] |= 1u << 0;
}

inline void LeDeviceCreatedSignal::clear_has_device () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  LeDeviceRemovedSignal::LeDeviceRemovedSignal ()  :
    _device ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  LeDeviceRemovedSignal::LeDeviceRemovedSignal (const LeDeviceRemovedSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _device ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  LeDeviceRemovedSignal::LeDeviceRemovedSignal (const ::std::string& device_)  :
    _device (device_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (device_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  LeDeviceRemovedSignal::~LeDeviceRemovedSignal() {
}

inline LeDeviceRemovedSignal& LeDeviceRemovedSignal::operator = (const LeDeviceRemovedSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDevice()) {
            setDevice(rhs.getDevice());
        } else {
            clearDevice();
        }
    }
    return *this;
}

inline bool LeDeviceRemovedSignal::operator == (const LeDeviceRemovedSignal& rhs) const {
    return (((!hasDevice() && !rhs.hasDevice()) || getDevice() == rhs.getDevice()));
}

inline bool LeDeviceRemovedSignal::operator != (const LeDeviceRemovedSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool LeDeviceRemovedSignal::operator < (const LeDeviceRemovedSignal& rhs) const {
    if (hasDevice() || rhs.hasDevice()) {
        if (getDevice() < rhs.getDevice()) return true;
        if (getDevice() > rhs.getDevice()) return false;
    }
    return false;
}

inline ::asf::core::Payload* LeDeviceRemovedSignal::clone() {
    return new LeDeviceRemovedSignal(*this);
}

inline bool LeDeviceRemovedSignal::operator > (const LeDeviceRemovedSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void LeDeviceRemovedSignal::clear() {
    clearDevice();
}

inline void LeDeviceRemovedSignal::clearDevice() {
    if (hasDevice()) {
         clear_has_device();
        _device.clear();
     }
}

inline bool LeDeviceRemovedSignal::hasDevice () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& LeDeviceRemovedSignal::getDevice () const {
    return _device;
}

inline ::std::string& LeDeviceRemovedSignal::getDeviceMutable () {
    set_has_device();
    return _device;
}

inline void LeDeviceRemovedSignal::setDevice (const ::std::string& device_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (device_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_device();
    this->_device = device_;
}

inline void LeDeviceRemovedSignal::setDevice (const char* device_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (device_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_device();
    this->_device.assign(device_);
}

inline void LeDeviceRemovedSignal::setDevice (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_device();
    this->_device.assign(value, size);
}

inline void LeDeviceRemovedSignal::set_has_device () {
    _has_bits_[0] |= 1u << 0;
}

inline void LeDeviceRemovedSignal::clear_has_device () {
    _has_bits_[0] &= ~ (1u << 0);
}

} // namespace LE_Adapter1
} // namespace bluez
} // namespace org

#endif // ORG_BLUEZ_LE_ADAPTER1_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
