/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "org/ofono/VoiceCall.h"
#include "org/ofono/VoiceCallDBus.h"
#include "org/ofono/VoiceCallJson.h"
#include "org/ofono/VoiceCallProxy.h"

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace org {
namespace ofono {
namespace VoiceCall {

DEFINE_CLASS_LOGGER("//hfp/adapter_addr/dev_addr/voice_call/created/during/runtime/org/ofono/VoiceCall", VoiceCallProxy);

class VoiceCallProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    VoiceCallProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< VoiceCallProxy >& proxyShared = ::boost::static_pointer_cast< VoiceCallProxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_PropertyChanged:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), PropertyChangedSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "PropertyChanged", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<PropertyChangedSignal> payload = ::boost::static_pointer_cast<PropertyChangedSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((PropertyChangedCallbackIF*) _callback)->onPropertyChangedSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_GetProperties:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), GetPropertiesError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetProperties", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetPropertiesError> payload = ::boost::static_pointer_cast<GetPropertiesError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetPropertiesCallbackIF*) _callback)->onGetPropertiesError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetPropertiesResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetProperties", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetPropertiesResponse> payload = ::boost::static_pointer_cast<GetPropertiesResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetPropertiesCallbackIF*) _callback)->onGetPropertiesResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_Hangup:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), HangupError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "Hangup", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<HangupError> payload = ::boost::static_pointer_cast<HangupError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((HangupCallbackIF*) _callback)->onHangupError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), HangupResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "Hangup", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<HangupResponse> payload = ::boost::static_pointer_cast<HangupResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((HangupCallbackIF*) _callback)->onHangupResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_Answer:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), AnswerError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "Answer", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AnswerError> payload = ::boost::static_pointer_cast<AnswerError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((AnswerCallbackIF*) _callback)->onAnswerError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AnswerResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "Answer", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AnswerResponse> payload = ::boost::static_pointer_cast<AnswerResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((AnswerCallbackIF*) _callback)->onAnswerResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_Hold:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), HoldError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "Hold", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<HoldError> payload = ::boost::static_pointer_cast<HoldError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((HoldCallbackIF*) _callback)->onHoldError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), HoldResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "Hold", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<HoldResponse> payload = ::boost::static_pointer_cast<HoldResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((HoldCallbackIF*) _callback)->onHoldResponse (proxyShared, payload);
                        return true;
                    }
                }
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_PropertyChanged: {
                ::boost::shared_ptr< PropertyChangedError > payload = ::boost::shared_ptr< PropertyChangedError >
                (new PropertyChangedError(DBUS_ERROR_NO_SERVER, "The DBus service VoiceCall is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "PropertyChanged", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<VoiceCallProxy> proxyShared = ::boost::static_pointer_cast<VoiceCallProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((PropertyChangedCallbackIF*) _callback)->onPropertyChangedError (proxyShared,payload);
                return true;
            }
            break;
            case ID_GetProperties: {
                ::boost::shared_ptr< GetPropertiesError > payload = ::boost::shared_ptr< GetPropertiesError >
                (new GetPropertiesError(DBUS_ERROR_NO_SERVER, "The DBus service VoiceCall is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "GetProperties", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<VoiceCallProxy> proxyShared = ::boost::static_pointer_cast<VoiceCallProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((GetPropertiesCallbackIF*) _callback)->onGetPropertiesError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Hangup: {
                ::boost::shared_ptr< HangupError > payload = ::boost::shared_ptr< HangupError >
                (new HangupError(DBUS_ERROR_NO_SERVER, "The DBus service VoiceCall is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Hangup", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<VoiceCallProxy> proxyShared = ::boost::static_pointer_cast<VoiceCallProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((HangupCallbackIF*) _callback)->onHangupError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Answer: {
                ::boost::shared_ptr< AnswerError > payload = ::boost::shared_ptr< AnswerError >
                (new AnswerError(DBUS_ERROR_NO_SERVER, "The DBus service VoiceCall is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Answer", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<VoiceCallProxy> proxyShared = ::boost::static_pointer_cast<VoiceCallProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((AnswerCallbackIF*) _callback)->onAnswerError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Hold: {
                ::boost::shared_ptr< HoldError > payload = ::boost::shared_ptr< HoldError >
                (new HoldError(DBUS_ERROR_NO_SERVER, "The DBus service VoiceCall is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Hold", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<VoiceCallProxy> proxyShared = ::boost::static_pointer_cast<VoiceCallProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((HoldCallbackIF*) _callback)->onHoldError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& VoiceCallProxyCallback::_logger (VoiceCallProxy::_logger);

VoiceCallProxy::VoiceCallProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "org.ofono.VoiceCall", serviceAvailable, _logger) {
}

VoiceCallProxy::~VoiceCallProxy()
{
    sendDeregisterAll();
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< VoiceCallProxy > VoiceCallProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<VoiceCallProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< VoiceCallProxy > proxyNew(new VoiceCallProxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(false);
    return proxyNew;
}

act_t VoiceCallProxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    VoiceCallProxyCallback* callback = new VoiceCallProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t VoiceCallProxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    VoiceCallProxyCallback* callback = new VoiceCallProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


void VoiceCallProxy::sendDeregisterAll () const
{
    sendPropertyChangedDeregisterAll();
}

act_t VoiceCallProxy::sendPropertyChangedRegister(PropertyChangedCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "PropertyChanged");
    act_t act = addSignalCallback(ID_PropertyChanged, "PropertyChanged", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "PropertyChanged", &cb, act);
    return act;
}

bool VoiceCallProxy::sendPropertyChangedDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("PropertyChanged", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "PropertyChanged", act, static_cast<int>(rv));
    return rv;
}

void VoiceCallProxy::sendPropertyChangedDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "PropertyChanged");
    _dbusProxyDelegate->deregisterSignalCallback("PropertyChanged", 0, _dbusDaemonProxy.get(), false);
}

act_t VoiceCallProxy::sendGetPropertiesRequest(GetPropertiesCallbackIF& cb) const {
    GetPropertiesRequest* payload = new GetPropertiesRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "GetProperties", GetPropertiesRequest, payload, true)
    act_t act = addMethodCallback(ID_GetProperties, dbusMessage.getUniqueSerial(), "GetProperties", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "GetProperties", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t VoiceCallProxy::sendHangupRequest(HangupCallbackIF& cb) const {
    HangupRequest* payload = new HangupRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "Hangup", HangupRequest, payload, true)
    act_t act = addMethodCallback(ID_Hangup, dbusMessage.getUniqueSerial(), "Hangup", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "Hangup", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t VoiceCallProxy::sendAnswerRequest(AnswerCallbackIF& cb) const {
    AnswerRequest* payload = new AnswerRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "Answer", AnswerRequest, payload, true)
    act_t act = addMethodCallback(ID_Answer, dbusMessage.getUniqueSerial(), "Answer", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "Answer", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t VoiceCallProxy::sendHoldRequest(HoldCallbackIF& cb) const {
    HoldRequest* payload = new HoldRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "Hold", HoldRequest, payload, true)
    act_t act = addMethodCallback(ID_Hold, dbusMessage.getUniqueSerial(), "Hold", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "Hold", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

} // namespace VoiceCall
} // namespace ofono
} // namespace org
