/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_OFONO_MANAGERSTUB_H
#define ORG_OFONO_MANAGERSTUB_H

#include "asf/core/Logger.h"
#include "asf/dbus/DBusStub.h"
#include "asf/dbus/DBusVariant.h"
#include "boost/shared_ptr.hpp"
#include "org/ofono/Manager.h"
#include <map>
#include <string>
#include <vector>

namespace org {
namespace ofono {
namespace Manager {

class ManagerStubDelegate;

class ManagerStub : public ::asf::dbus::DBusStub
{
public:

    /**
     * Create an instance of the ManagerStub
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     */
    ManagerStub (const std::string& portName);

    /**
     * Create an instance of the ManagerStub
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     * @param objectPath the dbus object path, see
     * http://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-marshaling-object-path
     */
    ManagerStub (const std::string& portName, const std::string& objectPath);

    virtual ~ManagerStub();

    // signal 'ModemAdded'

    /**
     * Raise the signal 'ModemAdded' and send an update message to registered
     * clients.
     *
     * <b>Documentation of 'ModemAdded'</b>:
     *
     * If the meaning of "ModemAdded" isn't clear, then there should be a description here.
     */
    void sendModemAddedSignal(const ::std::string& path, const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    // signal 'ModemRemoved'

    /**
     * Raise the signal 'ModemRemoved' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'ModemRemoved'</b>:
     *
     * If the meaning of "ModemRemoved" isn't clear, then there should be a description here.
     */
    void sendModemRemovedSignal(const ::std::string& path);

    // method 'GetModems'

    /**
     * The method onGetModems() is called by ASF when a client invokes the
     * method 'GetModems'. A subclass has to implement this method and send
     * back a response to the client either with the sendGetModems() or
     * sendGetModemsError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'GetModems'</b>:
     *
     * If the meaning of "GetModems" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onGetModemsRequest (const ::boost::shared_ptr< GetModemsRequest >& request) = 0;

    /**
     * The method sendGetModemsResponse() sends a response of a previous
     * method invocation of 'GetModems' back to the client.
     *
     * <b>Documentation of 'GetModems'</b>:
     *
     * If the meaning of "GetModems" isn't clear, then there should be a description here.
     *
     * @param modems If the meaning of "modems" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onGetModems(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendGetModemsResponse (const ::std::vector< GetModemsResponseModemsStruct >& modems, act_t act = 0);

    /**
     * The method sendGetModemsError() sends an error response of a previous
     * method invocation of 'GetModems' back to the client.
     *
     * <b>Documentation of 'GetModems'</b>:
     *
     * If the meaning of "GetModems" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onGetModems(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendGetModemsError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

private:
    void onGetAll(std::map<std::basic_string<char>, ::asf::dbus::DBusVariant>&) const;

    friend class ManagerStubDelegate;

    DECLARE_CLASS_LOGGER();
};

} // namespace Manager
} // namespace ofono
} // namespace org

#endif // ORG_OFONO_MANAGERSTUB_H
