/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DBusVariant.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "org/ofono/Manager.h"
#include "org/ofono/ManagerDBus.h"
#include "org/ofono/ManagerJson.h"
#include "org/ofono/ManagerStub.h"
#include <map>
#include <string>
#include <vector>

#include "asf/dbus/DBusMessage.h"

namespace org {
namespace ofono {
namespace Manager {

DEFINE_CLASS_LOGGER("///org/ofono/Manager", ManagerStub);

static ::asf::dbus::DBusUtils::stringEntry methodsTable[] = {
    { 9, "GetModems", 0 },
};


class ManagerStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    ManagerStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    ManagerStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    ManagerStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "org.ofono.Manager"),
          _logger(logger) {}

    virtual ~ManagerStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void ManagerStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    unsigned int methodIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (message.getMemberName().c_str(), message.getMemberName().length(), methodsTable, 1, methodIndex)) {
        switch (methodIndex) {
        case 0: {

            // method 'GetModems'

            LOG_DEBUG_STUB("process method '%s'", "GetModems");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetModemsRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "GetModems", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< GetModemsRequest > payload = ::boost::static_pointer_cast<GetModemsRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ManagerStub*>(getStub())->onGetModemsRequest(payload);
            return;
        }
        default:
            break;
        }
    }
    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* ManagerStubDelegate::introspect() const {
    return     "<interface name=\"org.ofono.Manager\">\n"
            "      <method name=\"GetModems\">\n"
            "        <arg direction=\"out\" name=\"modems\" type=\"a(oa{sv})\"/>\n"
            "      </method>\n"
            "      <signal name=\"ModemAdded\">\n"
            "        <arg name=\"path\" type=\"o\"/>\n"
            "        <arg name=\"properties\" type=\"a{sv}\"/>\n"
            "      </signal>\n"
            "      <signal name=\"ModemRemoved\">\n"
            "        <arg name=\"path\" type=\"o\"/>\n"
            "      </signal>\n"
            "</interface>\n";
}

void ManagerStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<ManagerStub*>(getStub()))->onGetAll (properties);
}

void ManagerStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    ((void)value);  // to get rid of unused variable warning
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void ManagerStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

ManagerStub::ManagerStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new ManagerStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

ManagerStub::ManagerStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new ManagerStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

ManagerStub::~ManagerStub() {
    delete _stubDelegate;
}

void ManagerStub::sendModemAddedSignal(const ::std::string& path, const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    if (_stubDelegate->isConnected()) {
        ModemAddedSignal* payload = new ModemAddedSignal(path, properties);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "ModemAdded", ModemAddedSignal, payload)
        LOG_INFO ("-> send%sSignal", "ModemAdded");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "ModemAdded");
    }
}

void ManagerStub::sendModemRemovedSignal(const ::std::string& path) {
    if (_stubDelegate->isConnected()) {
        ModemRemovedSignal* payload = new ModemRemovedSignal(path);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "ModemRemoved", ModemRemovedSignal, payload)
        LOG_INFO ("-> send%sSignal", "ModemRemoved");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "ModemRemoved");
    }
}

void  ManagerStub::sendGetModemsResponse (const ::std::vector< GetModemsResponseModemsStruct >& modems, act_t act) {
    GetModemsResponse* payload = new GetModemsResponse(modems);
    DBUS_MESSAGE_REPLY(dbusMessage, "GetModems", GetModemsResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "GetModems", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendGetModemsError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    GetModemsError* payload = new GetModemsError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "GetModems", GetModemsError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "GetModems", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void ManagerStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {
    ((void)properties);  // to get rid of unused variable warning
}

} // namespace Manager
} // namespace ofono
} // namespace org
