/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_OFONO_MANAGERPROXY_H
#define ORG_OFONO_MANAGERPROXY_H

#include "asf/core/Logger.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusProxy.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "org/ofono/Manager.h"
#include <dbus/dbus.h>

namespace org {
namespace ofono {
namespace Manager {

class ManagerProxy;

class GetModemsCallbackIF {
public:
    virtual ~GetModemsCallbackIF() {}

    virtual void onGetModemsError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< GetModemsError >& error) = 0;

    virtual void onGetModemsResponse(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< GetModemsResponse >& response) = 0;
};

class ModemAddedCallbackIF {
public:
    virtual ~ModemAddedCallbackIF() {}

    virtual void onModemAddedError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< ModemAddedError >& error) = 0;

    virtual void onModemAddedSignal(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< ModemAddedSignal >& signal) = 0;
};

class ModemRemovedCallbackIF {
public:
    virtual ~ModemRemovedCallbackIF() {}

    virtual void onModemRemovedError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< ModemRemovedError >& error) = 0;

    virtual void onModemRemovedSignal(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< ModemRemovedSignal >& signal) = 0;
};


/**
 * ManagerProxy is the client side representation of the D-Bus service
 * interface 'org.ofono.Manager' (specified in file
 * handsfree_manager.xml).
 *
 * If the meaning of "org.ofono.Manager" isn't clear, then there should be a description here.
 */
class ManagerProxy : public ::asf::dbus::DBusProxy
{
public:
    /**
     * Create a new instance of ManagerProxy.
     */
    static ::boost::shared_ptr< ManagerProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Create a new instance of ManagerProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @deprecated use the createProxy() method with the parameter
     * ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector instead.
     */
    static ::boost::shared_ptr< ManagerProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        ::DBusBusType busType,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector connectorOptions;
        connectorOptions.setBusType(::asf::dbus::DBusUtils::toOptions(busType).getBusType());
        return createProxy(portName, busName, objectPath, connectorOptions, serviceAvailable);
    }

    /**
     * Create a new instance of ManagerProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     */
    static ::boost::shared_ptr< ManagerProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        const ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector& connectorOptions,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< ManagerProxy > proxyNew(new ManagerProxy(portName, serviceAvailable));
        ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew, busName, objectPath, connectorOptions);
        proxyNew->createHelperProxies(false);
        return proxyNew;
    }

    virtual ~ManagerProxy ();


    // Signal 'ModemAdded'

    /**
     * Notify on the signal 'ModemAdded'. This method registers for signal
     * changes by D-Bus service.
     *
     * <b>Documentation of 'ModemAdded'</b>:
     *
     * If the meaning of "ModemAdded" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendModemAddedRegister(ModemAddedCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'ModemAdded'. This method deregisters
     * signal changes from the D-Bus service.
     *
     * <b>Documentation of 'ModemAdded'</b>:
     *
     * If the meaning of "ModemAdded" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendModemAddedRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendModemAddedDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'ModemAdded'.
     */
    void sendModemAddedDeregisterAll () const;

    // Signal 'ModemRemoved'

    /**
     * Notify on the signal 'ModemRemoved'. This method registers for signal
     * changes by D-Bus service.
     *
     * <b>Documentation of 'ModemRemoved'</b>:
     *
     * If the meaning of "ModemRemoved" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendModemRemovedRegister(ModemRemovedCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'ModemRemoved'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'ModemRemoved'</b>:
     *
     * If the meaning of "ModemRemoved" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendModemRemovedRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendModemRemovedDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'ModemRemoved'.
     */
    void sendModemRemovedDeregisterAll () const;



    // Method 'GetModems'

    /**
     * Call the method 'GetModems'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'GetModems'</b>:
     *
     * If the meaning of "GetModems" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetModemsRequest(GetModemsCallbackIF& cb) const;

    /**
     * Release all property and signal notifications.
     */
    void sendDeregisterAll () const;

private:

    ManagerProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    act_t addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const;

    act_t addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const;


    DECLARE_CLASS_LOGGER();

    friend class ManagerProxyCallback;
};

} // namespace Manager
} // namespace ofono
} // namespace org

#endif // ORG_OFONO_MANAGERPROXY_H
