/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "org/ofono/Manager.h"
#include "org/ofono/ManagerDBus.h"
#include "org/ofono/ManagerJson.h"
#include "org/ofono/ManagerProxy.h"

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace org {
namespace ofono {
namespace Manager {

DEFINE_CLASS_LOGGER("///org/ofono/Manager", ManagerProxy);

class ManagerProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    ManagerProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< ManagerProxy >& proxyShared = ::boost::static_pointer_cast< ManagerProxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_ModemAdded:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ModemAddedSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ModemAdded", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<ModemAddedSignal> payload = ::boost::static_pointer_cast<ModemAddedSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((ModemAddedCallbackIF*) _callback)->onModemAddedSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_ModemRemoved:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ModemRemovedSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ModemRemoved", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<ModemRemovedSignal> payload = ::boost::static_pointer_cast<ModemRemovedSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((ModemRemovedCallbackIF*) _callback)->onModemRemovedSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_GetModems:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), GetModemsError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetModems", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetModemsError> payload = ::boost::static_pointer_cast<GetModemsError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetModemsCallbackIF*) _callback)->onGetModemsError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetModemsResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetModems", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetModemsResponse> payload = ::boost::static_pointer_cast<GetModemsResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetModemsCallbackIF*) _callback)->onGetModemsResponse (proxyShared, payload);
                        return true;
                    }
                }
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_ModemAdded: {
                ::boost::shared_ptr< ModemAddedError > payload = ::boost::shared_ptr< ModemAddedError >
                (new ModemAddedError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ModemAdded", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ModemAddedCallbackIF*) _callback)->onModemAddedError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ModemRemoved: {
                ::boost::shared_ptr< ModemRemovedError > payload = ::boost::shared_ptr< ModemRemovedError >
                (new ModemRemovedError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ModemRemoved", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ModemRemovedCallbackIF*) _callback)->onModemRemovedError (proxyShared,payload);
                return true;
            }
            break;
            case ID_GetModems: {
                ::boost::shared_ptr< GetModemsError > payload = ::boost::shared_ptr< GetModemsError >
                (new GetModemsError(DBUS_ERROR_NO_SERVER, "The DBus service Manager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "GetModems", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ManagerProxy> proxyShared = ::boost::static_pointer_cast<ManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((GetModemsCallbackIF*) _callback)->onGetModemsError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& ManagerProxyCallback::_logger (ManagerProxy::_logger);

ManagerProxy::ManagerProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "org.ofono.Manager", serviceAvailable, _logger) {
}

ManagerProxy::~ManagerProxy()
{
    sendDeregisterAll();
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< ManagerProxy > ManagerProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<ManagerProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< ManagerProxy > proxyNew(new ManagerProxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(false);
    return proxyNew;
}

act_t ManagerProxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    ManagerProxyCallback* callback = new ManagerProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t ManagerProxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    ManagerProxyCallback* callback = new ManagerProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


void ManagerProxy::sendDeregisterAll () const
{
    sendModemAddedDeregisterAll();
    sendModemRemovedDeregisterAll();
}

act_t ManagerProxy::sendModemAddedRegister(ModemAddedCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "ModemAdded");
    act_t act = addSignalCallback(ID_ModemAdded, "ModemAdded", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "ModemAdded", &cb, act);
    return act;
}

bool ManagerProxy::sendModemAddedDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("ModemAdded", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "ModemAdded", act, static_cast<int>(rv));
    return rv;
}

void ManagerProxy::sendModemAddedDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "ModemAdded");
    _dbusProxyDelegate->deregisterSignalCallback("ModemAdded", 0, _dbusDaemonProxy.get(), false);
}

act_t ManagerProxy::sendModemRemovedRegister(ModemRemovedCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "ModemRemoved");
    act_t act = addSignalCallback(ID_ModemRemoved, "ModemRemoved", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "ModemRemoved", &cb, act);
    return act;
}

bool ManagerProxy::sendModemRemovedDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("ModemRemoved", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "ModemRemoved", act, static_cast<int>(rv));
    return rv;
}

void ManagerProxy::sendModemRemovedDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "ModemRemoved");
    _dbusProxyDelegate->deregisterSignalCallback("ModemRemoved", 0, _dbusDaemonProxy.get(), false);
}

act_t ManagerProxy::sendGetModemsRequest(GetModemsCallbackIF& cb) const {
    GetModemsRequest* payload = new GetModemsRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "GetModems", GetModemsRequest, payload, true)
    act_t act = addMethodCallback(ID_GetModems, dbusMessage.getUniqueSerial(), "GetModems", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "GetModems", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

} // namespace Manager
} // namespace ofono
} // namespace org
