/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_OFONO_HANDSFREESTUB_H
#define ORG_OFONO_HANDSFREESTUB_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStub.h"
#include "asf/dbus/DBusVariant.h"
#include "boost/shared_ptr.hpp"
#include "org/ofono/Handsfree.h"
#include <map>
#include <string>
#include <vector>

namespace org {
namespace ofono {
namespace Handsfree {

class HandsfreeStubDelegate;

class HandsfreeStub : public ::asf::dbus::DBusStub
{
public:

    /**
     * Create an instance of the HandsfreeStub
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     */
    HandsfreeStub (const std::string& portName);

    /**
     * Create an instance of the HandsfreeStub
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     * @param objectPath the dbus object path, see
     * http://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-marshaling-object-path
     */
    HandsfreeStub (const std::string& portName, const std::string& objectPath);

    virtual ~HandsfreeStub();

    // signal 'PropertyChanged'

    /**
     * Raise the signal 'PropertyChanged' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'PropertyChanged'</b>:
     *
     * If the meaning of "PropertyChanged" isn't clear, then there should be a description here.
     */
    void sendPropertyChangedSignal(const ::std::string& name, const ::asf::dbus::DBusVariant& value);

    // signal 'RecvATCommand'

    /**
     * Raise the signal 'RecvATCommand' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'RecvATCommand'</b>:
     *
     * If the meaning of "RecvATCommand" isn't clear, then there should be a description here.
     */
    void sendRecvATCommandSignal(const ::std::vector< uint8 >& data);

    // signal 'AgSupportedHFindicatorsInd'

    /**
     * Raise the signal 'AgSupportedHFindicatorsInd' and send an update
     * message to registered clients.
     *
     * <b>Documentation of 'AgSupportedHFindicatorsInd'</b>:
     *
     * If the meaning of "AgSupportedHFindicatorsInd" isn't clear, then there should be a description here.
     */
    void sendAgSupportedHFindicatorsIndSignal(const ::std::vector< uint8 >& indicators_anum);

    // signal 'AgHFindicatorsStateInd'

    /**
     * Raise the signal 'AgHFindicatorsStateInd' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'AgHFindicatorsStateInd'</b>:
     *
     * If the meaning of "AgHFindicatorsStateInd" isn't clear, then there should be a description here.
     */
    void sendAgHFindicatorsStateIndSignal(uint16 number, uint16 state);

    // method 'GetProperties'

    /**
     * The method onGetProperties() is called by ASF when a client invokes the
     * method 'GetProperties'. A subclass has to implement this method and
     * send back a response to the client either with the sendGetProperties()
     * or sendGetPropertiesError() method. Do not invoke this method on your
     * own.
     *
     * <b>Documentation of 'GetProperties'</b>:
     *
     * If the meaning of "GetProperties" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onGetPropertiesRequest (const ::boost::shared_ptr< GetPropertiesRequest >& request) = 0;

    /**
     * The method sendGetPropertiesResponse() sends a response of a previous
     * method invocation of 'GetProperties' back to the client.
     *
     * <b>Documentation of 'GetProperties'</b>:
     *
     * If the meaning of "GetProperties" isn't clear, then there should be a description here.
     *
     * @param properties If the meaning of "properties" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onGetProperties(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendGetPropertiesResponse (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties, act_t act = 0);

    /**
     * The method sendGetPropertiesError() sends an error response of a
     * previous method invocation of 'GetProperties' back to the client.
     *
     * <b>Documentation of 'GetProperties'</b>:
     *
     * If the meaning of "GetProperties" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onGetProperties(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendGetPropertiesError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'SetProperty'

    /**
     * The method onSetProperty() is called by ASF when a client invokes the
     * method 'SetProperty'. A subclass has to implement this method and send
     * back a response to the client either with the sendSetProperty() or
     * sendSetPropertyError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'SetProperty'</b>:
     *
     * If the meaning of "SetProperty" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onSetPropertyRequest (const ::boost::shared_ptr< SetPropertyRequest >& request) = 0;

    /**
     * The method sendSetPropertyResponse() sends a response of a previous
     * method invocation of 'SetProperty' back to the client.
     *
     * <b>Documentation of 'SetProperty'</b>:
     *
     * If the meaning of "SetProperty" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onSetProperty(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendSetPropertyResponse (act_t act = 0);

    /**
     * The method sendSetPropertyError() sends an error response of a previous
     * method invocation of 'SetProperty' back to the client.
     *
     * <b>Documentation of 'SetProperty'</b>:
     *
     * If the meaning of "SetProperty" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onSetProperty(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendSetPropertyError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'RequestPhoneNumber'

    /**
     * The method onRequestPhoneNumber() is called by ASF when a client
     * invokes the method 'RequestPhoneNumber'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendRequestPhoneNumber() or sendRequestPhoneNumberError() method. Do
     * not invoke this method on your own.
     *
     * <b>Documentation of 'RequestPhoneNumber'</b>:
     *
     * If the meaning of "RequestPhoneNumber" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onRequestPhoneNumberRequest (const ::boost::shared_ptr< RequestPhoneNumberRequest >& request) = 0;

    /**
     * The method sendRequestPhoneNumberResponse() sends a response of a
     * previous method invocation of 'RequestPhoneNumber' back to the client.
     *
     * <b>Documentation of 'RequestPhoneNumber'</b>:
     *
     * If the meaning of "RequestPhoneNumber" isn't clear, then there should be a description here.
     *
     * @param number If the meaning of "number" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onRequestPhoneNumber(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendRequestPhoneNumberResponse (const ::std::string& number, act_t act = 0);

    /**
     * The method sendRequestPhoneNumberError() sends an error response of a
     * previous method invocation of 'RequestPhoneNumber' back to the client.
     *
     * <b>Documentation of 'RequestPhoneNumber'</b>:
     *
     * If the meaning of "RequestPhoneNumber" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onRequestPhoneNumber().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendRequestPhoneNumberError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'GetSubscriber'

    /**
     * The method onGetSubscriber() is called by ASF when a client invokes the
     * method 'GetSubscriber'. A subclass has to implement this method and
     * send back a response to the client either with the sendGetSubscriber()
     * or sendGetSubscriberError() method. Do not invoke this method on your
     * own.
     *
     * <b>Documentation of 'GetSubscriber'</b>:
     *
     * If the meaning of "GetSubscriber" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onGetSubscriberRequest (const ::boost::shared_ptr< GetSubscriberRequest >& request) = 0;

    /**
     * The method sendGetSubscriberResponse() sends a response of a previous
     * method invocation of 'GetSubscriber' back to the client.
     *
     * <b>Documentation of 'GetSubscriber'</b>:
     *
     * If the meaning of "GetSubscriber" isn't clear, then there should be a description here.
     *
     * @param type If the meaning of "type" isn't clear, then there should be a description here.
     *
     * @param number If the meaning of "number" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onGetSubscriber(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendGetSubscriberResponse (uint8 type, const ::std::string& number, act_t act = 0);

    /**
     * The method sendGetSubscriberError() sends an error response of a
     * previous method invocation of 'GetSubscriber' back to the client.
     *
     * <b>Documentation of 'GetSubscriber'</b>:
     *
     * If the meaning of "GetSubscriber" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onGetSubscriber(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendGetSubscriberError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'SendCustomATCommand'

    /**
     * The method onSendCustomATCommand() is called by ASF when a client
     * invokes the method 'SendCustomATCommand'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendSendCustomATCommand() or sendSendCustomATCommandError() method. Do
     * not invoke this method on your own.
     *
     * <b>Documentation of 'SendCustomATCommand'</b>:
     *
     * If the meaning of "SendCustomATCommand" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onSendCustomATCommandRequest (const ::boost::shared_ptr< SendCustomATCommandRequest >& request) = 0;

    /**
     * The method sendSendCustomATCommandResponse() sends a response of a
     * previous method invocation of 'SendCustomATCommand' back to the client.
     *
     * <b>Documentation of 'SendCustomATCommand'</b>:
     *
     * If the meaning of "SendCustomATCommand" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onSendCustomATCommand(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendSendCustomATCommandResponse (act_t act = 0);

    /**
     * The method sendSendCustomATCommandError() sends an error response of a
     * previous method invocation of 'SendCustomATCommand' back to the client.
     *
     * <b>Documentation of 'SendCustomATCommand'</b>:
     *
     * If the meaning of "SendCustomATCommand" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onSendCustomATCommand().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendSendCustomATCommandError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'HFUpdateIndicatorsValue'

    /**
     * The method onHFUpdateIndicatorsValue() is called by ASF when a client
     * invokes the method 'HFUpdateIndicatorsValue'. A subclass has to
     * implement this method and send back a response to the client either
     * with the sendHFUpdateIndicatorsValue() or
     * sendHFUpdateIndicatorsValueError() method. Do not invoke this method on
     * your own.
     *
     * <b>Documentation of 'HFUpdateIndicatorsValue'</b>:
     *
     * If the meaning of "HFUpdateIndicatorsValue" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onHFUpdateIndicatorsValueRequest (const ::boost::shared_ptr< HFUpdateIndicatorsValueRequest >& request) = 0;

    /**
     * The method sendHFUpdateIndicatorsValueResponse() sends a response of a
     * previous method invocation of 'HFUpdateIndicatorsValue' back to the
     * client.
     *
     * <b>Documentation of 'HFUpdateIndicatorsValue'</b>:
     *
     * If the meaning of "HFUpdateIndicatorsValue" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onHFUpdateIndicatorsValue(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendHFUpdateIndicatorsValueResponse (act_t act = 0);

    /**
     * The method sendHFUpdateIndicatorsValueError() sends an error response
     * of a previous method invocation of 'HFUpdateIndicatorsValue' back to
     * the client.
     *
     * <b>Documentation of 'HFUpdateIndicatorsValue'</b>:
     *
     * If the meaning of "HFUpdateIndicatorsValue" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onHFUpdateIndicatorsValue(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendHFUpdateIndicatorsValueError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

private:
    void onGetAll(std::map<std::basic_string<char>, ::asf::dbus::DBusVariant>&) const;

    friend class HandsfreeStubDelegate;

    DECLARE_CLASS_LOGGER();
};

} // namespace Handsfree
} // namespace ofono
} // namespace org

#endif // ORG_OFONO_HANDSFREESTUB_H
