/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DBusVariant.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "org/ofono/Handsfree.h"
#include "org/ofono/HandsfreeDBus.h"
#include "org/ofono/HandsfreeJson.h"
#include "org/ofono/HandsfreeStub.h"
#include <map>
#include <string>
#include <vector>

#include "asf/dbus/DBusMessage.h"

namespace org {
namespace ofono {
namespace Handsfree {

DEFINE_CLASS_LOGGER("//hfp/adapter_addr/dev_addr/created/during/runtime/org/ofono/Handsfree", HandsfreeStub);

static ::asf::dbus::DBusUtils::stringEntry methodsTable[] = {
    { 11, "SetProperty", 1 },
    { 13, "GetProperties", 0 },
    { 13, "GetSubscriber", 3 },
    { 18, "RequestPhoneNumber", 2 },
    { 19, "SendCustomATCommand", 4 },
    { 23, "HFUpdateIndicatorsValue", 5 },
};


class HandsfreeStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    HandsfreeStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    HandsfreeStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    HandsfreeStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "org.ofono.Handsfree"),
          _logger(logger) {}

    virtual ~HandsfreeStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void HandsfreeStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    unsigned int methodIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (message.getMemberName().c_str(), message.getMemberName().length(), methodsTable, 6, methodIndex)) {
        switch (methodIndex) {
        case 0: {

            // method 'GetProperties'

            LOG_DEBUG_STUB("process method '%s'", "GetProperties");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetPropertiesRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "GetProperties", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< GetPropertiesRequest > payload = ::boost::static_pointer_cast<GetPropertiesRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<HandsfreeStub*>(getStub())->onGetPropertiesRequest(payload);
            return;
        }
        case 1: {

            // method 'SetProperty'

            LOG_DEBUG_STUB("process method '%s'", "SetProperty");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetPropertyRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SetProperty", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SetPropertyRequest > payload = ::boost::static_pointer_cast<SetPropertyRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<HandsfreeStub*>(getStub())->onSetPropertyRequest(payload);
            return;
        }
        case 2: {

            // method 'RequestPhoneNumber'

            LOG_DEBUG_STUB("process method '%s'", "RequestPhoneNumber");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RequestPhoneNumberRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "RequestPhoneNumber", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< RequestPhoneNumberRequest > payload = ::boost::static_pointer_cast<RequestPhoneNumberRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<HandsfreeStub*>(getStub())->onRequestPhoneNumberRequest(payload);
            return;
        }
        case 3: {

            // method 'GetSubscriber'

            LOG_DEBUG_STUB("process method '%s'", "GetSubscriber");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetSubscriberRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "GetSubscriber", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< GetSubscriberRequest > payload = ::boost::static_pointer_cast<GetSubscriberRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<HandsfreeStub*>(getStub())->onGetSubscriberRequest(payload);
            return;
        }
        case 4: {

            // method 'SendCustomATCommand'

            LOG_DEBUG_STUB("process method '%s'", "SendCustomATCommand");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SendCustomATCommandRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SendCustomATCommand", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SendCustomATCommandRequest > payload = ::boost::static_pointer_cast<SendCustomATCommandRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<HandsfreeStub*>(getStub())->onSendCustomATCommandRequest(payload);
            return;
        }
        case 5: {

            // method 'HFUpdateIndicatorsValue'

            LOG_DEBUG_STUB("process method '%s'", "HFUpdateIndicatorsValue");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), HFUpdateIndicatorsValueRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "HFUpdateIndicatorsValue", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< HFUpdateIndicatorsValueRequest > payload = ::boost::static_pointer_cast<HFUpdateIndicatorsValueRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<HandsfreeStub*>(getStub())->onHFUpdateIndicatorsValueRequest(payload);
            return;
        }
        default:
            break;
        }
    }
    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* HandsfreeStubDelegate::introspect() const {
    return     "<interface name=\"org.ofono.Handsfree\">\n"
            "      <method name=\"GetProperties\">\n"
            "        <arg direction=\"out\" name=\"properties\" type=\"a{sv}\"/>\n"
            "      </method>\n"
            "      <method name=\"SetProperty\">\n"
            "        <arg direction=\"in\" name=\"property\" type=\"s\"/>\n"
            "        <arg direction=\"in\" name=\"value\" type=\"v\"/>\n"
            "      </method>\n"
            "      <method name=\"RequestPhoneNumber\">\n"
            "        <arg direction=\"out\" name=\"number\" type=\"s\"/>\n"
            "      </method>\n"
            "      <method name=\"GetSubscriber\">\n"
            "        <arg direction=\"out\" name=\"type\" type=\"y\"/>\n"
            "        <arg direction=\"out\" name=\"number\" type=\"s\"/>\n"
            "      </method>\n"
            "      <method name=\"SendCustomATCommand\">\n"
            "        <arg direction=\"in\" name=\"data\" type=\"ay\"/>\n"
            "      </method>\n"
            "      <method name=\"HFUpdateIndicatorsValue\">\n"
            "        <arg direction=\"in\" name=\"number\" type=\"q\"/>\n"
            "        <arg direction=\"in\" name=\"value\" type=\"u\"/>\n"
            "      </method>\n"
            "      <signal name=\"PropertyChanged\">\n"
            "        <arg name=\"name\" type=\"s\"/>\n"
            "        <arg name=\"value\" type=\"v\"/>\n"
            "      </signal>\n"
            "      <signal name=\"RecvATCommand\">\n"
            "        <arg name=\"data\" type=\"ay\"/>\n"
            "      </signal>\n"
            "      <signal name=\"AgSupportedHFindicatorsInd\">\n"
            "        <arg name=\"indicators_anum\" type=\"ay\"/>\n"
            "      </signal>\n"
            "      <signal name=\"AgHFindicatorsStateInd\">\n"
            "        <arg name=\"number\" type=\"q\"/>\n"
            "        <arg name=\"state\" type=\"q\"/>\n"
            "      </signal>\n"
            "</interface>\n";
}

void HandsfreeStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<HandsfreeStub*>(getStub()))->onGetAll (properties);
}

void HandsfreeStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    ((void)value);  // to get rid of unused variable warning
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void HandsfreeStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

HandsfreeStub::HandsfreeStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new HandsfreeStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

HandsfreeStub::HandsfreeStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new HandsfreeStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

HandsfreeStub::~HandsfreeStub() {
    delete _stubDelegate;
}

void HandsfreeStub::sendPropertyChangedSignal(const ::std::string& name, const ::asf::dbus::DBusVariant& value) {
    if (_stubDelegate->isConnected()) {
        PropertyChangedSignal* payload = new PropertyChangedSignal(name, value);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "PropertyChanged", PropertyChangedSignal, payload)
        LOG_INFO ("-> send%sSignal", "PropertyChanged");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "PropertyChanged");
    }
}

void HandsfreeStub::sendRecvATCommandSignal(const ::std::vector< uint8 >& data) {
    if (_stubDelegate->isConnected()) {
        RecvATCommandSignal* payload = new RecvATCommandSignal(data);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "RecvATCommand", RecvATCommandSignal, payload)
        LOG_INFO ("-> send%sSignal", "RecvATCommand");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "RecvATCommand");
    }
}

void HandsfreeStub::sendAgSupportedHFindicatorsIndSignal(const ::std::vector< uint8 >& indicators_anum) {
    if (_stubDelegate->isConnected()) {
        AgSupportedHFindicatorsIndSignal* payload = new AgSupportedHFindicatorsIndSignal(indicators_anum);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "AgSupportedHFindicatorsInd", AgSupportedHFindicatorsIndSignal, payload)
        LOG_INFO ("-> send%sSignal", "AgSupportedHFindicatorsInd");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "AgSupportedHFindicatorsInd");
    }
}

void HandsfreeStub::sendAgHFindicatorsStateIndSignal(uint16 number, uint16 state) {
    if (_stubDelegate->isConnected()) {
        AgHFindicatorsStateIndSignal* payload = new AgHFindicatorsStateIndSignal(number, state);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "AgHFindicatorsStateInd", AgHFindicatorsStateIndSignal, payload)
        LOG_INFO ("-> send%sSignal", "AgHFindicatorsStateInd");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "AgHFindicatorsStateInd");
    }
}

void  HandsfreeStub::sendGetPropertiesResponse (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties, act_t act) {
    GetPropertiesResponse* payload = new GetPropertiesResponse(properties);
    DBUS_MESSAGE_REPLY(dbusMessage, "GetProperties", GetPropertiesResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "GetProperties", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  HandsfreeStub::sendGetPropertiesError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    GetPropertiesError* payload = new GetPropertiesError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "GetProperties", GetPropertiesError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "GetProperties", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  HandsfreeStub::sendSetPropertyResponse (act_t act) {
    SetPropertyResponse* payload = new SetPropertyResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "SetProperty", SetPropertyResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SetProperty", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  HandsfreeStub::sendSetPropertyError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SetPropertyError* payload = new SetPropertyError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "SetProperty", SetPropertyError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SetProperty", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  HandsfreeStub::sendRequestPhoneNumberResponse (const ::std::string& number, act_t act) {
    RequestPhoneNumberResponse* payload = new RequestPhoneNumberResponse(number);
    DBUS_MESSAGE_REPLY(dbusMessage, "RequestPhoneNumber", RequestPhoneNumberResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "RequestPhoneNumber", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  HandsfreeStub::sendRequestPhoneNumberError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    RequestPhoneNumberError* payload = new RequestPhoneNumberError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "RequestPhoneNumber", RequestPhoneNumberError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "RequestPhoneNumber", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  HandsfreeStub::sendGetSubscriberResponse (uint8 type, const ::std::string& number, act_t act) {
    GetSubscriberResponse* payload = new GetSubscriberResponse(type, number);
    DBUS_MESSAGE_REPLY(dbusMessage, "GetSubscriber", GetSubscriberResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "GetSubscriber", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  HandsfreeStub::sendGetSubscriberError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    GetSubscriberError* payload = new GetSubscriberError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "GetSubscriber", GetSubscriberError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "GetSubscriber", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  HandsfreeStub::sendSendCustomATCommandResponse (act_t act) {
    SendCustomATCommandResponse* payload = new SendCustomATCommandResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "SendCustomATCommand", SendCustomATCommandResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SendCustomATCommand", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  HandsfreeStub::sendSendCustomATCommandError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SendCustomATCommandError* payload = new SendCustomATCommandError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "SendCustomATCommand", SendCustomATCommandError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SendCustomATCommand", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  HandsfreeStub::sendHFUpdateIndicatorsValueResponse (act_t act) {
    HFUpdateIndicatorsValueResponse* payload = new HFUpdateIndicatorsValueResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "HFUpdateIndicatorsValue", HFUpdateIndicatorsValueResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "HFUpdateIndicatorsValue", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  HandsfreeStub::sendHFUpdateIndicatorsValueError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    HFUpdateIndicatorsValueError* payload = new HFUpdateIndicatorsValueError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "HFUpdateIndicatorsValue", HFUpdateIndicatorsValueError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "HFUpdateIndicatorsValue", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void HandsfreeStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {
    ((void)properties);  // to get rid of unused variable warning
}

} // namespace Handsfree
} // namespace ofono
} // namespace org
