/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusVariant.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "org/ofono/Handsfree.h"
#include "org/ofono/HandsfreeDBus.h"
#include "org/ofono/HandsfreeJson.h"
#include "org/ofono/HandsfreeProxy.h"
#include <string>
#include <vector>

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace org {
namespace ofono {
namespace Handsfree {

DEFINE_CLASS_LOGGER("//hfp/adapter_addr/dev_addr/created/during/runtime/org/ofono/Handsfree", HandsfreeProxy);

class HandsfreeProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    HandsfreeProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< HandsfreeProxy >& proxyShared = ::boost::static_pointer_cast< HandsfreeProxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_PropertyChanged:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), PropertyChangedSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "PropertyChanged", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<PropertyChangedSignal> payload = ::boost::static_pointer_cast<PropertyChangedSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((PropertyChangedCallbackIF*) _callback)->onPropertyChangedSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_RecvATCommand:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RecvATCommandSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "RecvATCommand", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<RecvATCommandSignal> payload = ::boost::static_pointer_cast<RecvATCommandSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((RecvATCommandCallbackIF*) _callback)->onRecvATCommandSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_AgSupportedHFindicatorsInd:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AgSupportedHFindicatorsIndSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "AgSupportedHFindicatorsInd", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<AgSupportedHFindicatorsIndSignal> payload = ::boost::static_pointer_cast<AgSupportedHFindicatorsIndSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((AgSupportedHFindicatorsIndCallbackIF*) _callback)->onAgSupportedHFindicatorsIndSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_AgHFindicatorsStateInd:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AgHFindicatorsStateIndSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "AgHFindicatorsStateInd", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<AgHFindicatorsStateIndSignal> payload = ::boost::static_pointer_cast<AgHFindicatorsStateIndSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((AgHFindicatorsStateIndCallbackIF*) _callback)->onAgHFindicatorsStateIndSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_GetProperties:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), GetPropertiesError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetProperties", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetPropertiesError> payload = ::boost::static_pointer_cast<GetPropertiesError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetPropertiesCallbackIF*) _callback)->onGetPropertiesError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetPropertiesResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetProperties", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetPropertiesResponse> payload = ::boost::static_pointer_cast<GetPropertiesResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetPropertiesCallbackIF*) _callback)->onGetPropertiesResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_SetProperty:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), SetPropertyError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetProperty", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetPropertyError> payload = ::boost::static_pointer_cast<SetPropertyError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetPropertyCallbackIF*) _callback)->onSetPropertyError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetPropertyResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetProperty", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetPropertyResponse> payload = ::boost::static_pointer_cast<SetPropertyResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetPropertyCallbackIF*) _callback)->onSetPropertyResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_RequestPhoneNumber:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), RequestPhoneNumberError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "RequestPhoneNumber", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RequestPhoneNumberError> payload = ::boost::static_pointer_cast<RequestPhoneNumberError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((RequestPhoneNumberCallbackIF*) _callback)->onRequestPhoneNumberError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RequestPhoneNumberResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "RequestPhoneNumber", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RequestPhoneNumberResponse> payload = ::boost::static_pointer_cast<RequestPhoneNumberResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((RequestPhoneNumberCallbackIF*) _callback)->onRequestPhoneNumberResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_GetSubscriber:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), GetSubscriberError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetSubscriber", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetSubscriberError> payload = ::boost::static_pointer_cast<GetSubscriberError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetSubscriberCallbackIF*) _callback)->onGetSubscriberError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetSubscriberResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetSubscriber", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetSubscriberResponse> payload = ::boost::static_pointer_cast<GetSubscriberResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetSubscriberCallbackIF*) _callback)->onGetSubscriberResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_SendCustomATCommand:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), SendCustomATCommandError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SendCustomATCommand", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SendCustomATCommandError> payload = ::boost::static_pointer_cast<SendCustomATCommandError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SendCustomATCommandCallbackIF*) _callback)->onSendCustomATCommandError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SendCustomATCommandResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "SendCustomATCommand", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SendCustomATCommandResponse> payload = ::boost::static_pointer_cast<SendCustomATCommandResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SendCustomATCommandCallbackIF*) _callback)->onSendCustomATCommandResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_HFUpdateIndicatorsValue:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), HFUpdateIndicatorsValueError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "HFUpdateIndicatorsValue", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<HFUpdateIndicatorsValueError> payload = ::boost::static_pointer_cast<HFUpdateIndicatorsValueError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((HFUpdateIndicatorsValueCallbackIF*) _callback)->onHFUpdateIndicatorsValueError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), HFUpdateIndicatorsValueResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "HFUpdateIndicatorsValue", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<HFUpdateIndicatorsValueResponse> payload = ::boost::static_pointer_cast<HFUpdateIndicatorsValueResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((HFUpdateIndicatorsValueCallbackIF*) _callback)->onHFUpdateIndicatorsValueResponse (proxyShared, payload);
                        return true;
                    }
                }
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_PropertyChanged: {
                ::boost::shared_ptr< PropertyChangedError > payload = ::boost::shared_ptr< PropertyChangedError >
                (new PropertyChangedError(DBUS_ERROR_NO_SERVER, "The DBus service Handsfree is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "PropertyChanged", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<HandsfreeProxy> proxyShared = ::boost::static_pointer_cast<HandsfreeProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((PropertyChangedCallbackIF*) _callback)->onPropertyChangedError (proxyShared,payload);
                return true;
            }
            break;
            case ID_RecvATCommand: {
                ::boost::shared_ptr< RecvATCommandError > payload = ::boost::shared_ptr< RecvATCommandError >
                (new RecvATCommandError(DBUS_ERROR_NO_SERVER, "The DBus service Handsfree is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "RecvATCommand", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<HandsfreeProxy> proxyShared = ::boost::static_pointer_cast<HandsfreeProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((RecvATCommandCallbackIF*) _callback)->onRecvATCommandError (proxyShared,payload);
                return true;
            }
            break;
            case ID_AgSupportedHFindicatorsInd: {
                ::boost::shared_ptr< AgSupportedHFindicatorsIndError > payload = ::boost::shared_ptr< AgSupportedHFindicatorsIndError >
                (new AgSupportedHFindicatorsIndError(DBUS_ERROR_NO_SERVER, "The DBus service Handsfree is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "AgSupportedHFindicatorsInd", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<HandsfreeProxy> proxyShared = ::boost::static_pointer_cast<HandsfreeProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((AgSupportedHFindicatorsIndCallbackIF*) _callback)->onAgSupportedHFindicatorsIndError (proxyShared,payload);
                return true;
            }
            break;
            case ID_AgHFindicatorsStateInd: {
                ::boost::shared_ptr< AgHFindicatorsStateIndError > payload = ::boost::shared_ptr< AgHFindicatorsStateIndError >
                (new AgHFindicatorsStateIndError(DBUS_ERROR_NO_SERVER, "The DBus service Handsfree is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "AgHFindicatorsStateInd", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<HandsfreeProxy> proxyShared = ::boost::static_pointer_cast<HandsfreeProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((AgHFindicatorsStateIndCallbackIF*) _callback)->onAgHFindicatorsStateIndError (proxyShared,payload);
                return true;
            }
            break;
            case ID_GetProperties: {
                ::boost::shared_ptr< GetPropertiesError > payload = ::boost::shared_ptr< GetPropertiesError >
                (new GetPropertiesError(DBUS_ERROR_NO_SERVER, "The DBus service Handsfree is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "GetProperties", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<HandsfreeProxy> proxyShared = ::boost::static_pointer_cast<HandsfreeProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((GetPropertiesCallbackIF*) _callback)->onGetPropertiesError (proxyShared,payload);
                return true;
            }
            break;
            case ID_SetProperty: {
                ::boost::shared_ptr< SetPropertyError > payload = ::boost::shared_ptr< SetPropertyError >
                (new SetPropertyError(DBUS_ERROR_NO_SERVER, "The DBus service Handsfree is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SetProperty", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<HandsfreeProxy> proxyShared = ::boost::static_pointer_cast<HandsfreeProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SetPropertyCallbackIF*) _callback)->onSetPropertyError (proxyShared,payload);
                return true;
            }
            break;
            case ID_RequestPhoneNumber: {
                ::boost::shared_ptr< RequestPhoneNumberError > payload = ::boost::shared_ptr< RequestPhoneNumberError >
                (new RequestPhoneNumberError(DBUS_ERROR_NO_SERVER, "The DBus service Handsfree is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "RequestPhoneNumber", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<HandsfreeProxy> proxyShared = ::boost::static_pointer_cast<HandsfreeProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((RequestPhoneNumberCallbackIF*) _callback)->onRequestPhoneNumberError (proxyShared,payload);
                return true;
            }
            break;
            case ID_GetSubscriber: {
                ::boost::shared_ptr< GetSubscriberError > payload = ::boost::shared_ptr< GetSubscriberError >
                (new GetSubscriberError(DBUS_ERROR_NO_SERVER, "The DBus service Handsfree is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "GetSubscriber", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<HandsfreeProxy> proxyShared = ::boost::static_pointer_cast<HandsfreeProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((GetSubscriberCallbackIF*) _callback)->onGetSubscriberError (proxyShared,payload);
                return true;
            }
            break;
            case ID_SendCustomATCommand: {
                ::boost::shared_ptr< SendCustomATCommandError > payload = ::boost::shared_ptr< SendCustomATCommandError >
                (new SendCustomATCommandError(DBUS_ERROR_NO_SERVER, "The DBus service Handsfree is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SendCustomATCommand", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<HandsfreeProxy> proxyShared = ::boost::static_pointer_cast<HandsfreeProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SendCustomATCommandCallbackIF*) _callback)->onSendCustomATCommandError (proxyShared,payload);
                return true;
            }
            break;
            case ID_HFUpdateIndicatorsValue: {
                ::boost::shared_ptr< HFUpdateIndicatorsValueError > payload = ::boost::shared_ptr< HFUpdateIndicatorsValueError >
                (new HFUpdateIndicatorsValueError(DBUS_ERROR_NO_SERVER, "The DBus service Handsfree is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "HFUpdateIndicatorsValue", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<HandsfreeProxy> proxyShared = ::boost::static_pointer_cast<HandsfreeProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((HFUpdateIndicatorsValueCallbackIF*) _callback)->onHFUpdateIndicatorsValueError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& HandsfreeProxyCallback::_logger (HandsfreeProxy::_logger);

HandsfreeProxy::HandsfreeProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "org.ofono.Handsfree", serviceAvailable, _logger) {
}

HandsfreeProxy::~HandsfreeProxy()
{
    sendDeregisterAll();
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< HandsfreeProxy > HandsfreeProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<HandsfreeProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< HandsfreeProxy > proxyNew(new HandsfreeProxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(false);
    return proxyNew;
}

act_t HandsfreeProxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    HandsfreeProxyCallback* callback = new HandsfreeProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t HandsfreeProxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    HandsfreeProxyCallback* callback = new HandsfreeProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


void HandsfreeProxy::sendDeregisterAll () const
{
    sendPropertyChangedDeregisterAll();
    sendRecvATCommandDeregisterAll();
    sendAgSupportedHFindicatorsIndDeregisterAll();
    sendAgHFindicatorsStateIndDeregisterAll();
}

act_t HandsfreeProxy::sendPropertyChangedRegister(PropertyChangedCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "PropertyChanged");
    act_t act = addSignalCallback(ID_PropertyChanged, "PropertyChanged", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "PropertyChanged", &cb, act);
    return act;
}

bool HandsfreeProxy::sendPropertyChangedDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("PropertyChanged", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "PropertyChanged", act, static_cast<int>(rv));
    return rv;
}

void HandsfreeProxy::sendPropertyChangedDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "PropertyChanged");
    _dbusProxyDelegate->deregisterSignalCallback("PropertyChanged", 0, _dbusDaemonProxy.get(), false);
}

act_t HandsfreeProxy::sendRecvATCommandRegister(RecvATCommandCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "RecvATCommand");
    act_t act = addSignalCallback(ID_RecvATCommand, "RecvATCommand", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "RecvATCommand", &cb, act);
    return act;
}

bool HandsfreeProxy::sendRecvATCommandDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("RecvATCommand", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "RecvATCommand", act, static_cast<int>(rv));
    return rv;
}

void HandsfreeProxy::sendRecvATCommandDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "RecvATCommand");
    _dbusProxyDelegate->deregisterSignalCallback("RecvATCommand", 0, _dbusDaemonProxy.get(), false);
}

act_t HandsfreeProxy::sendAgSupportedHFindicatorsIndRegister(AgSupportedHFindicatorsIndCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "AgSupportedHFindicatorsInd");
    act_t act = addSignalCallback(ID_AgSupportedHFindicatorsInd, "AgSupportedHFindicatorsInd", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "AgSupportedHFindicatorsInd", &cb, act);
    return act;
}

bool HandsfreeProxy::sendAgSupportedHFindicatorsIndDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("AgSupportedHFindicatorsInd", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "AgSupportedHFindicatorsInd", act, static_cast<int>(rv));
    return rv;
}

void HandsfreeProxy::sendAgSupportedHFindicatorsIndDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "AgSupportedHFindicatorsInd");
    _dbusProxyDelegate->deregisterSignalCallback("AgSupportedHFindicatorsInd", 0, _dbusDaemonProxy.get(), false);
}

act_t HandsfreeProxy::sendAgHFindicatorsStateIndRegister(AgHFindicatorsStateIndCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "AgHFindicatorsStateInd");
    act_t act = addSignalCallback(ID_AgHFindicatorsStateInd, "AgHFindicatorsStateInd", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "AgHFindicatorsStateInd", &cb, act);
    return act;
}

bool HandsfreeProxy::sendAgHFindicatorsStateIndDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("AgHFindicatorsStateInd", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "AgHFindicatorsStateInd", act, static_cast<int>(rv));
    return rv;
}

void HandsfreeProxy::sendAgHFindicatorsStateIndDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "AgHFindicatorsStateInd");
    _dbusProxyDelegate->deregisterSignalCallback("AgHFindicatorsStateInd", 0, _dbusDaemonProxy.get(), false);
}

act_t HandsfreeProxy::sendGetPropertiesRequest(GetPropertiesCallbackIF& cb) const {
    GetPropertiesRequest* payload = new GetPropertiesRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "GetProperties", GetPropertiesRequest, payload, true)
    act_t act = addMethodCallback(ID_GetProperties, dbusMessage.getUniqueSerial(), "GetProperties", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "GetProperties", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t HandsfreeProxy::sendSetPropertyRequest(SetPropertyCallbackIF& cb, const ::std::string& property, const ::asf::dbus::DBusVariant& value) const {
    SetPropertyRequest* payload = new SetPropertyRequest();
    CHECK_ALLOCATION(payload);
    payload->setProperty(property);
    payload->setValue(value);
    DBUS_MESSAGE_CALL(dbusMessage, "SetProperty", SetPropertyRequest, payload, true)
    act_t act = addMethodCallback(ID_SetProperty, dbusMessage.getUniqueSerial(), "SetProperty", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "SetProperty", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t HandsfreeProxy::sendRequestPhoneNumberRequest(RequestPhoneNumberCallbackIF& cb) const {
    RequestPhoneNumberRequest* payload = new RequestPhoneNumberRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "RequestPhoneNumber", RequestPhoneNumberRequest, payload, true)
    act_t act = addMethodCallback(ID_RequestPhoneNumber, dbusMessage.getUniqueSerial(), "RequestPhoneNumber", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "RequestPhoneNumber", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t HandsfreeProxy::sendGetSubscriberRequest(GetSubscriberCallbackIF& cb) const {
    GetSubscriberRequest* payload = new GetSubscriberRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "GetSubscriber", GetSubscriberRequest, payload, true)
    act_t act = addMethodCallback(ID_GetSubscriber, dbusMessage.getUniqueSerial(), "GetSubscriber", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "GetSubscriber", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t HandsfreeProxy::sendSendCustomATCommandRequest(SendCustomATCommandCallbackIF& cb, const ::std::vector< uint8 >& data) const {
    SendCustomATCommandRequest* payload = new SendCustomATCommandRequest();
    CHECK_ALLOCATION(payload);
    payload->setData(data);
    DBUS_MESSAGE_CALL(dbusMessage, "SendCustomATCommand", SendCustomATCommandRequest, payload, true)
    act_t act = addMethodCallback(ID_SendCustomATCommand, dbusMessage.getUniqueSerial(), "SendCustomATCommand", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "SendCustomATCommand", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t HandsfreeProxy::sendHFUpdateIndicatorsValueRequest(HFUpdateIndicatorsValueCallbackIF& cb, uint16 number, uint32 value) const {
    HFUpdateIndicatorsValueRequest* payload = new HFUpdateIndicatorsValueRequest();
    CHECK_ALLOCATION(payload);
    payload->setNumber(number);
    payload->setValue(value);
    DBUS_MESSAGE_CALL(dbusMessage, "HFUpdateIndicatorsValue", HFUpdateIndicatorsValueRequest, payload, true)
    act_t act = addMethodCallback(ID_HFUpdateIndicatorsValue, dbusMessage.getUniqueSerial(), "HFUpdateIndicatorsValue", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "HFUpdateIndicatorsValue", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

} // namespace Handsfree
} // namespace ofono
} // namespace org
