#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_OFONO_HANDSFREE_H
#define ORG_OFONO_HANDSFREE_H

#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "asf/dbus/DBusTypes.h"
#include "asf/dbus/DBusVariant.h"
#include <cstddef>
#include <cstring>
#include <map>
#include <string>
#include <vector>

/**
 * If the meaning of "Handsfree" isn't clear, then there should be a description here.
 */

namespace org {
namespace ofono {
namespace Handsfree {

// method IDs
static const uint16 ID_GetProperties = 0;
static const uint16 ID_SetProperty = 1;
static const uint16 ID_RequestPhoneNumber = 2;
static const uint16 ID_GetSubscriber = 3;
static const uint16 ID_SendCustomATCommand = 4;
static const uint16 ID_HFUpdateIndicatorsValue = 5;

// signal IDs
static const uint16 ID_PropertyChanged = 6;
static const uint16 ID_RecvATCommand = 7;
static const uint16 ID_AgSupportedHFindicatorsInd = 8;
static const uint16 ID_AgHFindicatorsStateInd = 9;

// property IDs

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class GetPropertiesResponse;

class SetPropertyRequest;

class RequestPhoneNumberResponse;

class GetSubscriberResponse;

class SendCustomATCommandRequest;

class HFUpdateIndicatorsValueRequest;

class PropertyChangedSignal;

class RecvATCommandSignal;

class AgSupportedHFindicatorsIndSignal;

class AgHFindicatorsStateIndSignal;

// type definitions
/**
 * If the meaning of "GetPropertiesRequest" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage GetPropertiesRequest;

/**
 * If the meaning of "GetPropertiesError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError GetPropertiesError;

/**
 * If the meaning of "SetPropertyResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage SetPropertyResponse;

/**
 * If the meaning of "SetPropertyError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SetPropertyError;

/**
 * If the meaning of "RequestPhoneNumberRequest" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage RequestPhoneNumberRequest;

/**
 * If the meaning of "RequestPhoneNumberError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError RequestPhoneNumberError;

/**
 * If the meaning of "GetSubscriberRequest" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage GetSubscriberRequest;

/**
 * If the meaning of "GetSubscriberError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError GetSubscriberError;

/**
 * If the meaning of "SendCustomATCommandResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage SendCustomATCommandResponse;

/**
 * If the meaning of "SendCustomATCommandError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SendCustomATCommandError;

/**
 * If the meaning of "HFUpdateIndicatorsValueResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage HFUpdateIndicatorsValueResponse;

/**
 * If the meaning of "HFUpdateIndicatorsValueError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError HFUpdateIndicatorsValueError;

/**
 * If the meaning of "PropertyChangedError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError PropertyChangedError;

/**
 * If the meaning of "RecvATCommandError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError RecvATCommandError;

/**
 * If the meaning of "AgSupportedHFindicatorsIndError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError AgSupportedHFindicatorsIndError;

/**
 * If the meaning of "AgHFindicatorsStateIndError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError AgHFindicatorsStateIndError;


/**
 * If the meaning of "GetPropertiesResponse" isn't clear, then there should be a description here.
 */
class GetPropertiesResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetPropertiesResponse ();

    /**
     * Copy constructor
     */
    inline  GetPropertiesResponse (const GetPropertiesResponse &rhs);

    /**
     * All fields constructor
     */
    inline  GetPropertiesResponse (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties_);

    /**
     * Destructor
     */
    inline virtual  ~GetPropertiesResponse();

    /**
     * Assignment operator
     */
    inline GetPropertiesResponse& operator = (const GetPropertiesResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetPropertiesResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetPropertiesResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetPropertiesResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetPropertiesResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "properties"

    static const int kProperties = 0;

    /**
     * Clears the field "properties".
     *
     * The field will be set to its default value. The hasProperties()
     * method will return false.
     */
    inline void clearProperties();

    /**
     * Checks whether the field "properties" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setProperties()). Otherwise it will return false.
     */
    inline bool hasProperties () const;

    /**
     * Returns the value of the member "properties".
     *
     * If the meaning of "properties" isn't clear, then there should be a description here.
     *
     * @return The value of the field "properties"
     */
    inline const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getProperties () const;

    /**
     * Retrieves the value of the field "properties" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "properties".
     */
    inline ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getPropertiesMutable ();

    /**
     * Sets the value of the member "properties".
     *
     * If the meaning of "properties" isn't clear, then there should be a description here.
     *
     * @param properties The value which will be set
     */
    inline void setProperties (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties_);

    static const GetPropertiesResponse &getDefaultInstance();

private:

    static const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getStringTo__asf__dbus__DBusVariantMap_DefaultInstance ();

    inline void set_has_properties ();

    inline void clear_has_properties ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::map< ::std::string, ::asf::dbus::DBusVariant > _properties;

};

/**
 * If the meaning of "SetPropertyRequest" isn't clear, then there should be a description here.
 */
class SetPropertyRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetPropertyRequest ();

    /**
     * Copy constructor
     */
    inline  SetPropertyRequest (const SetPropertyRequest &rhs);

    /**
     * All fields constructor
     */
    inline  SetPropertyRequest (const ::std::string& property_, const ::asf::dbus::DBusVariant& value_);

    /**
     * Destructor
     */
    inline virtual  ~SetPropertyRequest();

    /**
     * Assignment operator
     */
    inline SetPropertyRequest& operator = (const SetPropertyRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetPropertyRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetPropertyRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetPropertyRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetPropertyRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "property"

    static const int kProperty = 0;

    /**
     * Clears the field "property".
     *
     * The field will be set to its default value. The hasProperty()
     * method will return false.
     */
    inline void clearProperty();

    /**
     * Checks whether the field "property" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setProperty()). Otherwise it will return false.
     */
    inline bool hasProperty () const;

    /**
     * Returns the value of the member "property".
     *
     * If the meaning of "property" isn't clear, then there should be a description here.
     *
     * @return The value of the field "property"
     */
    inline const ::std::string& getProperty () const;

    /**
     * Retrieves the value of the field "property" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "property".
     */
    inline ::std::string& getPropertyMutable ();

    /**
     * Sets the value of the member "property".
     *
     * If the meaning of "property" isn't clear, then there should be a description here.
     *
     * @param property The value which will be set
     */
    inline void setProperty (const ::std::string& property_);

    /**
     * Sets the value of the member "property".
     *
     * If the meaning of "property" isn't clear, then there should be a description here.
     *
     * @param property The value which will be set
     */
    inline void setProperty (const char* property_);

    /**
     * Sets the value of the member "property".
     *
     * If the meaning of "property" isn't clear, then there should be a description here.
     *
     * @param property The value which will be set
     */
    inline void setProperty (const char* value, size_t size);

    // API of field "value"

    static const int kValue = 1;

    /**
     * Clears the field "value".
     *
     * The field will be set to its default value. The hasValue()
     * method will return false.
     */
    inline void clearValue();

    /**
     * Checks whether the field "value" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setValue()). Otherwise it will return false.
     */
    inline bool hasValue () const;

    /**
     * Returns the value of the member "value".
     *
     * If the meaning of "value" isn't clear, then there should be a description here.
     *
     * @return The value of the field "value"
     */
    inline const ::asf::dbus::DBusVariant& getValue () const;

    /**
     * Retrieves the value of the field "value" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "value".
     */
    inline ::asf::dbus::DBusVariant& getValueMutable ();

    /**
     * Sets the value of the member "value".
     *
     * If the meaning of "value" isn't clear, then there should be a description here.
     *
     * @param value The value which will be set
     */
    inline void setValue (const ::asf::dbus::DBusVariant& value_);

    static const SetPropertyRequest &getDefaultInstance();

private:

    inline void set_has_property ();

    inline void clear_has_property ();

    inline void set_has_value ();

    inline void clear_has_value ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _property;

    ::asf::dbus::DBusVariant _value;

};

/**
 * If the meaning of "RequestPhoneNumberResponse" isn't clear, then there should be a description here.
 */
class RequestPhoneNumberResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequestPhoneNumberResponse ();

    /**
     * Copy constructor
     */
    inline  RequestPhoneNumberResponse (const RequestPhoneNumberResponse &rhs);

    /**
     * All fields constructor
     */
    inline  RequestPhoneNumberResponse (const ::std::string& number_);

    /**
     * Destructor
     */
    inline virtual  ~RequestPhoneNumberResponse();

    /**
     * Assignment operator
     */
    inline RequestPhoneNumberResponse& operator = (const RequestPhoneNumberResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestPhoneNumberResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestPhoneNumberResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestPhoneNumberResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestPhoneNumberResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "number"

    static const int kNumber = 0;

    /**
     * Clears the field "number".
     *
     * The field will be set to its default value. The hasNumber()
     * method will return false.
     */
    inline void clearNumber();

    /**
     * Checks whether the field "number" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNumber()). Otherwise it will return false.
     */
    inline bool hasNumber () const;

    /**
     * Returns the value of the member "number".
     *
     * If the meaning of "number" isn't clear, then there should be a description here.
     *
     * @return The value of the field "number"
     */
    inline const ::std::string& getNumber () const;

    /**
     * Retrieves the value of the field "number" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "number".
     */
    inline ::std::string& getNumberMutable ();

    /**
     * Sets the value of the member "number".
     *
     * If the meaning of "number" isn't clear, then there should be a description here.
     *
     * @param number The value which will be set
     */
    inline void setNumber (const ::std::string& number_);

    /**
     * Sets the value of the member "number".
     *
     * If the meaning of "number" isn't clear, then there should be a description here.
     *
     * @param number The value which will be set
     */
    inline void setNumber (const char* number_);

    /**
     * Sets the value of the member "number".
     *
     * If the meaning of "number" isn't clear, then there should be a description here.
     *
     * @param number The value which will be set
     */
    inline void setNumber (const char* value, size_t size);

    static const RequestPhoneNumberResponse &getDefaultInstance();

private:

    inline void set_has_number ();

    inline void clear_has_number ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _number;

};

/**
 * If the meaning of "GetSubscriberResponse" isn't clear, then there should be a description here.
 */
class GetSubscriberResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetSubscriberResponse ();

    /**
     * Copy constructor
     */
    inline  GetSubscriberResponse (const GetSubscriberResponse &rhs);

    /**
     * All fields constructor
     */
    inline  GetSubscriberResponse (uint8 type_, const ::std::string& number_);

    /**
     * Destructor
     */
    inline virtual  ~GetSubscriberResponse();

    /**
     * Assignment operator
     */
    inline GetSubscriberResponse& operator = (const GetSubscriberResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetSubscriberResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetSubscriberResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetSubscriberResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetSubscriberResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "type"

    static const int kType = 0;

    /**
     * Clears the field "type".
     *
     * The field will be set to its default value. The hasType()
     * method will return false.
     */
    inline void clearType();

    /**
     * Checks whether the field "type" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setType()). Otherwise it will return false.
     */
    inline bool hasType () const;

    /**
     * Returns the value of the member "type".
     *
     * If the meaning of "type" isn't clear, then there should be a description here.
     *
     * @return The value of the field "type"
     */
    inline uint8 getType () const;

    /**
     * Sets the value of the member "type".
     *
     * If the meaning of "type" isn't clear, then there should be a description here.
     *
     * @param type The value which will be set
     */
    inline void setType (uint8 type_);

    // API of field "number"

    static const int kNumber = 1;

    /**
     * Clears the field "number".
     *
     * The field will be set to its default value. The hasNumber()
     * method will return false.
     */
    inline void clearNumber();

    /**
     * Checks whether the field "number" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNumber()). Otherwise it will return false.
     */
    inline bool hasNumber () const;

    /**
     * Returns the value of the member "number".
     *
     * If the meaning of "number" isn't clear, then there should be a description here.
     *
     * @return The value of the field "number"
     */
    inline const ::std::string& getNumber () const;

    /**
     * Retrieves the value of the field "number" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "number".
     */
    inline ::std::string& getNumberMutable ();

    /**
     * Sets the value of the member "number".
     *
     * If the meaning of "number" isn't clear, then there should be a description here.
     *
     * @param number The value which will be set
     */
    inline void setNumber (const ::std::string& number_);

    /**
     * Sets the value of the member "number".
     *
     * If the meaning of "number" isn't clear, then there should be a description here.
     *
     * @param number The value which will be set
     */
    inline void setNumber (const char* number_);

    /**
     * Sets the value of the member "number".
     *
     * If the meaning of "number" isn't clear, then there should be a description here.
     *
     * @param number The value which will be set
     */
    inline void setNumber (const char* value, size_t size);

    static const GetSubscriberResponse &getDefaultInstance();

private:

    inline void set_has_type ();

    inline void clear_has_type ();

    inline void set_has_number ();

    inline void clear_has_number ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _type;

    ::std::string _number;

};

/**
 * If the meaning of "SendCustomATCommandRequest" isn't clear, then there should be a description here.
 */
class SendCustomATCommandRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SendCustomATCommandRequest ();

    /**
     * Copy constructor
     */
    inline  SendCustomATCommandRequest (const SendCustomATCommandRequest &rhs);

    /**
     * All fields constructor
     */
    inline  SendCustomATCommandRequest (const ::std::vector< uint8 >& data_);

    /**
     * Destructor
     */
    inline virtual  ~SendCustomATCommandRequest();

    /**
     * Assignment operator
     */
    inline SendCustomATCommandRequest& operator = (const SendCustomATCommandRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SendCustomATCommandRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SendCustomATCommandRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SendCustomATCommandRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SendCustomATCommandRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "data"

    static const int kData = 0;

    /**
     * Clears the field "data".
     *
     * The field will be set to its default value. The hasData()
     * method will return false.
     */
    inline void clearData();

    /**
     * Checks whether the field "data" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setData()). Otherwise it will return false.
     */
    inline bool hasData () const;

    /**
     * Returns the value of the member "data".
     *
     * If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @return The value of the field "data"
     */
    inline const ::std::vector< uint8 >& getData () const;

    /**
     * Retrieves the value of the field "data" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "data".
     */
    inline ::std::vector< uint8 >& getDataMutable ();

    /**
     * Sets the value of the member "data".
     *
     * If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @param data The value which will be set
     */
    inline void setData (const ::std::vector< uint8 >& data_);

    static const SendCustomATCommandRequest &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_data ();

    inline void clear_has_data ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< uint8 > _data;

};

/**
 * If the meaning of "HFUpdateIndicatorsValueRequest" isn't clear, then there should be a description here.
 */
class HFUpdateIndicatorsValueRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  HFUpdateIndicatorsValueRequest ();

    /**
     * Copy constructor
     */
    inline  HFUpdateIndicatorsValueRequest (const HFUpdateIndicatorsValueRequest &rhs);

    /**
     * All fields constructor
     */
    inline  HFUpdateIndicatorsValueRequest (uint16 number_, uint32 value_);

    /**
     * Destructor
     */
    inline virtual  ~HFUpdateIndicatorsValueRequest();

    /**
     * Assignment operator
     */
    inline HFUpdateIndicatorsValueRequest& operator = (const HFUpdateIndicatorsValueRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const HFUpdateIndicatorsValueRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const HFUpdateIndicatorsValueRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const HFUpdateIndicatorsValueRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const HFUpdateIndicatorsValueRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "number"

    static const int kNumber = 0;

    /**
     * Clears the field "number".
     *
     * The field will be set to its default value. The hasNumber()
     * method will return false.
     */
    inline void clearNumber();

    /**
     * Checks whether the field "number" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNumber()). Otherwise it will return false.
     */
    inline bool hasNumber () const;

    /**
     * Returns the value of the member "number".
     *
     * If the meaning of "number" isn't clear, then there should be a description here.
     *
     * @return The value of the field "number"
     */
    inline uint16 getNumber () const;

    /**
     * Sets the value of the member "number".
     *
     * If the meaning of "number" isn't clear, then there should be a description here.
     *
     * @param number The value which will be set
     */
    inline void setNumber (uint16 number_);

    // API of field "value"

    static const int kValue = 1;

    /**
     * Clears the field "value".
     *
     * The field will be set to its default value. The hasValue()
     * method will return false.
     */
    inline void clearValue();

    /**
     * Checks whether the field "value" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setValue()). Otherwise it will return false.
     */
    inline bool hasValue () const;

    /**
     * Returns the value of the member "value".
     *
     * If the meaning of "value" isn't clear, then there should be a description here.
     *
     * @return The value of the field "value"
     */
    inline uint32 getValue () const;

    /**
     * Sets the value of the member "value".
     *
     * If the meaning of "value" isn't clear, then there should be a description here.
     *
     * @param value The value which will be set
     */
    inline void setValue (uint32 value_);

    static const HFUpdateIndicatorsValueRequest &getDefaultInstance();

private:

    inline void set_has_number ();

    inline void clear_has_number ();

    inline void set_has_value ();

    inline void clear_has_value ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint16 _number;

    uint32 _value;

};

/**
 * If the meaning of "PropertyChangedSignal" isn't clear, then there should be a description here.
 */
class PropertyChangedSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PropertyChangedSignal ();

    /**
     * Copy constructor
     */
    inline  PropertyChangedSignal (const PropertyChangedSignal &rhs);

    /**
     * All fields constructor
     */
    inline  PropertyChangedSignal (const ::std::string& name_, const ::asf::dbus::DBusVariant& value_);

    /**
     * Destructor
     */
    inline virtual  ~PropertyChangedSignal();

    /**
     * Assignment operator
     */
    inline PropertyChangedSignal& operator = (const PropertyChangedSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PropertyChangedSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PropertyChangedSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PropertyChangedSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PropertyChangedSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "name"

    static const int kName = 0;

    /**
     * Clears the field "name".
     *
     * The field will be set to its default value. The hasName()
     * method will return false.
     */
    inline void clearName();

    /**
     * Checks whether the field "name" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setName()). Otherwise it will return false.
     */
    inline bool hasName () const;

    /**
     * Returns the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @return The value of the field "name"
     */
    inline const ::std::string& getName () const;

    /**
     * Retrieves the value of the field "name" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "name".
     */
    inline ::std::string& getNameMutable ();

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const ::std::string& name_);

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const char* name_);

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const char* value, size_t size);

    // API of field "value"

    static const int kValue = 1;

    /**
     * Clears the field "value".
     *
     * The field will be set to its default value. The hasValue()
     * method will return false.
     */
    inline void clearValue();

    /**
     * Checks whether the field "value" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setValue()). Otherwise it will return false.
     */
    inline bool hasValue () const;

    /**
     * Returns the value of the member "value".
     *
     * If the meaning of "value" isn't clear, then there should be a description here.
     *
     * @return The value of the field "value"
     */
    inline const ::asf::dbus::DBusVariant& getValue () const;

    /**
     * Retrieves the value of the field "value" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "value".
     */
    inline ::asf::dbus::DBusVariant& getValueMutable ();

    /**
     * Sets the value of the member "value".
     *
     * If the meaning of "value" isn't clear, then there should be a description here.
     *
     * @param value The value which will be set
     */
    inline void setValue (const ::asf::dbus::DBusVariant& value_);

    static const PropertyChangedSignal &getDefaultInstance();

private:

    inline void set_has_name ();

    inline void clear_has_name ();

    inline void set_has_value ();

    inline void clear_has_value ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _name;

    ::asf::dbus::DBusVariant _value;

};

/**
 * If the meaning of "RecvATCommandSignal" isn't clear, then there should be a description here.
 */
class RecvATCommandSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RecvATCommandSignal ();

    /**
     * Copy constructor
     */
    inline  RecvATCommandSignal (const RecvATCommandSignal &rhs);

    /**
     * All fields constructor
     */
    inline  RecvATCommandSignal (const ::std::vector< uint8 >& data_);

    /**
     * Destructor
     */
    inline virtual  ~RecvATCommandSignal();

    /**
     * Assignment operator
     */
    inline RecvATCommandSignal& operator = (const RecvATCommandSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RecvATCommandSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RecvATCommandSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RecvATCommandSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RecvATCommandSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "data"

    static const int kData = 0;

    /**
     * Clears the field "data".
     *
     * The field will be set to its default value. The hasData()
     * method will return false.
     */
    inline void clearData();

    /**
     * Checks whether the field "data" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setData()). Otherwise it will return false.
     */
    inline bool hasData () const;

    /**
     * Returns the value of the member "data".
     *
     * If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @return The value of the field "data"
     */
    inline const ::std::vector< uint8 >& getData () const;

    /**
     * Retrieves the value of the field "data" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "data".
     */
    inline ::std::vector< uint8 >& getDataMutable ();

    /**
     * Sets the value of the member "data".
     *
     * If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @param data The value which will be set
     */
    inline void setData (const ::std::vector< uint8 >& data_);

    static const RecvATCommandSignal &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_data ();

    inline void clear_has_data ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< uint8 > _data;

};

/**
 * If the meaning of "AgSupportedHFindicatorsIndSignal" isn't clear, then there should be a description here.
 */
class AgSupportedHFindicatorsIndSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AgSupportedHFindicatorsIndSignal ();

    /**
     * Copy constructor
     */
    inline  AgSupportedHFindicatorsIndSignal (const AgSupportedHFindicatorsIndSignal &rhs);

    /**
     * All fields constructor
     */
    inline  AgSupportedHFindicatorsIndSignal (const ::std::vector< uint8 >& indicators_anum_);

    /**
     * Destructor
     */
    inline virtual  ~AgSupportedHFindicatorsIndSignal();

    /**
     * Assignment operator
     */
    inline AgSupportedHFindicatorsIndSignal& operator = (const AgSupportedHFindicatorsIndSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AgSupportedHFindicatorsIndSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AgSupportedHFindicatorsIndSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AgSupportedHFindicatorsIndSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AgSupportedHFindicatorsIndSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "indicators_anum"

    static const int kIndicators_anum = 0;

    /**
     * Clears the field "indicators_anum".
     *
     * The field will be set to its default value. The hasIndicators_anum()
     * method will return false.
     */
    inline void clearIndicators_anum();

    /**
     * Checks whether the field "indicators_anum" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIndicators_anum()). Otherwise it will return false.
     */
    inline bool hasIndicators_anum () const;

    /**
     * Returns the value of the member "indicators_anum".
     *
     * If the meaning of "indicators_anum" isn't clear, then there should be a description here.
     *
     * @return The value of the field "indicators_anum"
     */
    inline const ::std::vector< uint8 >& getIndicators_anum () const;

    /**
     * Retrieves the value of the field "indicators_anum" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "indicators_anum".
     */
    inline ::std::vector< uint8 >& getIndicators_anumMutable ();

    /**
     * Sets the value of the member "indicators_anum".
     *
     * If the meaning of "indicators_anum" isn't clear, then there should be a description here.
     *
     * @param indicators_anum The value which will be set
     */
    inline void setIndicators_anum (const ::std::vector< uint8 >& indicators_anum_);

    static const AgSupportedHFindicatorsIndSignal &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_indicators_anum ();

    inline void clear_has_indicators_anum ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< uint8 > _indicators_anum;

};

/**
 * If the meaning of "AgHFindicatorsStateIndSignal" isn't clear, then there should be a description here.
 */
class AgHFindicatorsStateIndSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AgHFindicatorsStateIndSignal ();

    /**
     * Copy constructor
     */
    inline  AgHFindicatorsStateIndSignal (const AgHFindicatorsStateIndSignal &rhs);

    /**
     * All fields constructor
     */
    inline  AgHFindicatorsStateIndSignal (uint16 number_, uint16 state_);

    /**
     * Destructor
     */
    inline virtual  ~AgHFindicatorsStateIndSignal();

    /**
     * Assignment operator
     */
    inline AgHFindicatorsStateIndSignal& operator = (const AgHFindicatorsStateIndSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AgHFindicatorsStateIndSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AgHFindicatorsStateIndSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AgHFindicatorsStateIndSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AgHFindicatorsStateIndSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "number"

    static const int kNumber = 0;

    /**
     * Clears the field "number".
     *
     * The field will be set to its default value. The hasNumber()
     * method will return false.
     */
    inline void clearNumber();

    /**
     * Checks whether the field "number" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNumber()). Otherwise it will return false.
     */
    inline bool hasNumber () const;

    /**
     * Returns the value of the member "number".
     *
     * If the meaning of "number" isn't clear, then there should be a description here.
     *
     * @return The value of the field "number"
     */
    inline uint16 getNumber () const;

    /**
     * Sets the value of the member "number".
     *
     * If the meaning of "number" isn't clear, then there should be a description here.
     *
     * @param number The value which will be set
     */
    inline void setNumber (uint16 number_);

    // API of field "state"

    static const int kState = 1;

    /**
     * Clears the field "state".
     *
     * The field will be set to its default value. The hasState()
     * method will return false.
     */
    inline void clearState();

    /**
     * Checks whether the field "state" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setState()). Otherwise it will return false.
     */
    inline bool hasState () const;

    /**
     * Returns the value of the member "state".
     *
     * If the meaning of "state" isn't clear, then there should be a description here.
     *
     * @return The value of the field "state"
     */
    inline uint16 getState () const;

    /**
     * Sets the value of the member "state".
     *
     * If the meaning of "state" isn't clear, then there should be a description here.
     *
     * @param state The value which will be set
     */
    inline void setState (uint16 state_);

    static const AgHFindicatorsStateIndSignal &getDefaultInstance();

private:

    inline void set_has_number ();

    inline void clear_has_number ();

    inline void set_has_state ();

    inline void clear_has_state ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint16 _number;

    uint16 _state;

};

inline  GetPropertiesResponse::GetPropertiesResponse ()  :
    _properties ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetPropertiesResponse::GetPropertiesResponse (const GetPropertiesResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _properties ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetPropertiesResponse::GetPropertiesResponse (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties_)  :
    _properties (properties_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetPropertiesResponse::~GetPropertiesResponse() {
}

inline GetPropertiesResponse& GetPropertiesResponse::operator = (const GetPropertiesResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasProperties()) {
            setProperties(rhs.getProperties());
        } else {
            clearProperties();
        }
    }
    return *this;
}

inline bool GetPropertiesResponse::operator == (const GetPropertiesResponse& rhs) const {
    return (((!hasProperties() && !rhs.hasProperties()) || getProperties() == rhs.getProperties()));
}

inline bool GetPropertiesResponse::operator != (const GetPropertiesResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool GetPropertiesResponse::operator < (const GetPropertiesResponse& rhs) const {
    if (hasProperties() || rhs.hasProperties()) {
        if (getProperties() < rhs.getProperties()) return true;
        if (getProperties() > rhs.getProperties()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetPropertiesResponse::clone() {
    return new GetPropertiesResponse(*this);
}

inline bool GetPropertiesResponse::operator > (const GetPropertiesResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetPropertiesResponse::clear() {
    clearProperties();
}

inline void GetPropertiesResponse::clearProperties() {
    if (hasProperties()) {
         clear_has_properties();
        _properties.clear();
     }
}

inline bool GetPropertiesResponse::hasProperties () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& GetPropertiesResponse::getProperties () const {
    return _properties;
}

inline ::std::map< ::std::string, ::asf::dbus::DBusVariant >& GetPropertiesResponse::getPropertiesMutable () {
    set_has_properties();
    return _properties;
}

inline void GetPropertiesResponse::setProperties (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties_) {
    set_has_properties();
    this->_properties = properties_;
}

inline void GetPropertiesResponse::set_has_properties () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetPropertiesResponse::clear_has_properties () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SetPropertyRequest::SetPropertyRequest ()  :
    _property (),
    _value ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetPropertyRequest::SetPropertyRequest (const SetPropertyRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _property (),
    _value ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetPropertyRequest::SetPropertyRequest (const ::std::string& property_, const ::asf::dbus::DBusVariant& value_)  :
    _property (property_),
    _value (value_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (property_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetPropertyRequest::~SetPropertyRequest() {
}

inline SetPropertyRequest& SetPropertyRequest::operator = (const SetPropertyRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasProperty()) {
            setProperty(rhs.getProperty());
        } else {
            clearProperty();
        }
        if (rhs.hasValue()) {
            setValue(rhs.getValue());
        } else {
            clearValue();
        }
    }
    return *this;
}

inline bool SetPropertyRequest::operator == (const SetPropertyRequest& rhs) const {
    return (((!hasProperty() && !rhs.hasProperty()) || getProperty() == rhs.getProperty()) &&
        ((!hasValue() && !rhs.hasValue()) || getValue() == rhs.getValue()));
}

inline bool SetPropertyRequest::operator != (const SetPropertyRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool SetPropertyRequest::operator < (const SetPropertyRequest& rhs) const {
    if (hasProperty() || rhs.hasProperty()) {
        if (getProperty() < rhs.getProperty()) return true;
        if (getProperty() > rhs.getProperty()) return false;
    }
    if (hasValue() || rhs.hasValue()) {
        if (getValue() < rhs.getValue()) return true;
        if (getValue() > rhs.getValue()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetPropertyRequest::clone() {
    return new SetPropertyRequest(*this);
}

inline bool SetPropertyRequest::operator > (const SetPropertyRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetPropertyRequest::clear() {
    clearProperty();
    clearValue();
}

inline void SetPropertyRequest::clearProperty() {
    if (hasProperty()) {
         clear_has_property();
        _property.clear();
     }
}

inline bool SetPropertyRequest::hasProperty () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& SetPropertyRequest::getProperty () const {
    return _property;
}

inline ::std::string& SetPropertyRequest::getPropertyMutable () {
    set_has_property();
    return _property;
}

inline void SetPropertyRequest::setProperty (const ::std::string& property_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (property_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_property();
    this->_property = property_;
}

inline void SetPropertyRequest::setProperty (const char* property_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (property_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_property();
    this->_property.assign(property_);
}

inline void SetPropertyRequest::setProperty (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_property();
    this->_property.assign(value, size);
}

inline void SetPropertyRequest::clearValue() {
    if (hasValue()) {
         clear_has_value();
        _value = ::asf::dbus::DBusVariant ();
     }
}

inline bool SetPropertyRequest::hasValue () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::asf::dbus::DBusVariant& SetPropertyRequest::getValue () const {
    return _value;
}

inline ::asf::dbus::DBusVariant& SetPropertyRequest::getValueMutable () {
    set_has_value();
    return _value;
}

inline void SetPropertyRequest::setValue (const ::asf::dbus::DBusVariant& value_) {
    set_has_value();
    this->_value = value_;
}

inline void SetPropertyRequest::set_has_property () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetPropertyRequest::clear_has_property () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SetPropertyRequest::set_has_value () {
    _has_bits_[0] |= 1u << 1;
}

inline void SetPropertyRequest::clear_has_value () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  RequestPhoneNumberResponse::RequestPhoneNumberResponse ()  :
    _number ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RequestPhoneNumberResponse::RequestPhoneNumberResponse (const RequestPhoneNumberResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _number ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RequestPhoneNumberResponse::RequestPhoneNumberResponse (const ::std::string& number_)  :
    _number (number_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (number_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RequestPhoneNumberResponse::~RequestPhoneNumberResponse() {
}

inline RequestPhoneNumberResponse& RequestPhoneNumberResponse::operator = (const RequestPhoneNumberResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasNumber()) {
            setNumber(rhs.getNumber());
        } else {
            clearNumber();
        }
    }
    return *this;
}

inline bool RequestPhoneNumberResponse::operator == (const RequestPhoneNumberResponse& rhs) const {
    return (((!hasNumber() && !rhs.hasNumber()) || getNumber() == rhs.getNumber()));
}

inline bool RequestPhoneNumberResponse::operator != (const RequestPhoneNumberResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool RequestPhoneNumberResponse::operator < (const RequestPhoneNumberResponse& rhs) const {
    if (hasNumber() || rhs.hasNumber()) {
        if (getNumber() < rhs.getNumber()) return true;
        if (getNumber() > rhs.getNumber()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RequestPhoneNumberResponse::clone() {
    return new RequestPhoneNumberResponse(*this);
}

inline bool RequestPhoneNumberResponse::operator > (const RequestPhoneNumberResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RequestPhoneNumberResponse::clear() {
    clearNumber();
}

inline void RequestPhoneNumberResponse::clearNumber() {
    if (hasNumber()) {
         clear_has_number();
        _number.clear();
     }
}

inline bool RequestPhoneNumberResponse::hasNumber () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& RequestPhoneNumberResponse::getNumber () const {
    return _number;
}

inline ::std::string& RequestPhoneNumberResponse::getNumberMutable () {
    set_has_number();
    return _number;
}

inline void RequestPhoneNumberResponse::setNumber (const ::std::string& number_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (number_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_number();
    this->_number = number_;
}

inline void RequestPhoneNumberResponse::setNumber (const char* number_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (number_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_number();
    this->_number.assign(number_);
}

inline void RequestPhoneNumberResponse::setNumber (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_number();
    this->_number.assign(value, size);
}

inline void RequestPhoneNumberResponse::set_has_number () {
    _has_bits_[0] |= 1u << 0;
}

inline void RequestPhoneNumberResponse::clear_has_number () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GetSubscriberResponse::GetSubscriberResponse ()  :
    _type (0u),
    _number ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetSubscriberResponse::GetSubscriberResponse (const GetSubscriberResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _type (0u),
    _number ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetSubscriberResponse::GetSubscriberResponse (uint8 type_, const ::std::string& number_)  :
    _type (type_),
    _number (number_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (number_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetSubscriberResponse::~GetSubscriberResponse() {
}

inline GetSubscriberResponse& GetSubscriberResponse::operator = (const GetSubscriberResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasType()) {
            setType(rhs.getType());
        } else {
            clearType();
        }
        if (rhs.hasNumber()) {
            setNumber(rhs.getNumber());
        } else {
            clearNumber();
        }
    }
    return *this;
}

inline bool GetSubscriberResponse::operator == (const GetSubscriberResponse& rhs) const {
    return (((!hasType() && !rhs.hasType()) || getType() == rhs.getType()) &&
        ((!hasNumber() && !rhs.hasNumber()) || getNumber() == rhs.getNumber()));
}

inline bool GetSubscriberResponse::operator != (const GetSubscriberResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool GetSubscriberResponse::operator < (const GetSubscriberResponse& rhs) const {
    if (hasType() || rhs.hasType()) {
        if (getType() < rhs.getType()) return true;
        if (getType() > rhs.getType()) return false;
    }
    if (hasNumber() || rhs.hasNumber()) {
        if (getNumber() < rhs.getNumber()) return true;
        if (getNumber() > rhs.getNumber()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetSubscriberResponse::clone() {
    return new GetSubscriberResponse(*this);
}

inline bool GetSubscriberResponse::operator > (const GetSubscriberResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetSubscriberResponse::clear() {
    clearType();
    clearNumber();
}

inline void GetSubscriberResponse::clearType() {
    if (hasType()) {
         clear_has_type();
        _type = 0u;
     }
}

inline bool GetSubscriberResponse::hasType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 GetSubscriberResponse::getType () const {
    return _type;
}

inline void GetSubscriberResponse::setType (uint8 type_) {
    set_has_type();
    this->_type = type_;
}

inline void GetSubscriberResponse::clearNumber() {
    if (hasNumber()) {
         clear_has_number();
        _number.clear();
     }
}

inline bool GetSubscriberResponse::hasNumber () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& GetSubscriberResponse::getNumber () const {
    return _number;
}

inline ::std::string& GetSubscriberResponse::getNumberMutable () {
    set_has_number();
    return _number;
}

inline void GetSubscriberResponse::setNumber (const ::std::string& number_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (number_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_number();
    this->_number = number_;
}

inline void GetSubscriberResponse::setNumber (const char* number_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (number_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_number();
    this->_number.assign(number_);
}

inline void GetSubscriberResponse::setNumber (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_number();
    this->_number.assign(value, size);
}

inline void GetSubscriberResponse::set_has_type () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetSubscriberResponse::clear_has_type () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GetSubscriberResponse::set_has_number () {
    _has_bits_[0] |= 1u << 1;
}

inline void GetSubscriberResponse::clear_has_number () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  SendCustomATCommandRequest::SendCustomATCommandRequest ()  :
    _data ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SendCustomATCommandRequest::SendCustomATCommandRequest (const SendCustomATCommandRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _data ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SendCustomATCommandRequest::SendCustomATCommandRequest (const ::std::vector< uint8 >& data_)  :
    _data (data_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SendCustomATCommandRequest::~SendCustomATCommandRequest() {
}

inline SendCustomATCommandRequest& SendCustomATCommandRequest::operator = (const SendCustomATCommandRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasData()) {
            setData(rhs.getData());
        } else {
            clearData();
        }
    }
    return *this;
}

inline bool SendCustomATCommandRequest::operator == (const SendCustomATCommandRequest& rhs) const {
    return (((!hasData() && !rhs.hasData()) || getData() == rhs.getData()));
}

inline bool SendCustomATCommandRequest::operator != (const SendCustomATCommandRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool SendCustomATCommandRequest::operator < (const SendCustomATCommandRequest& rhs) const {
    if (hasData() || rhs.hasData()) {
        if (getData() < rhs.getData()) return true;
        if (getData() > rhs.getData()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SendCustomATCommandRequest::clone() {
    return new SendCustomATCommandRequest(*this);
}

inline bool SendCustomATCommandRequest::operator > (const SendCustomATCommandRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SendCustomATCommandRequest::clear() {
    clearData();
}

inline void SendCustomATCommandRequest::clearData() {
    if (hasData()) {
         clear_has_data();
        _data.clear();
     }
}

inline bool SendCustomATCommandRequest::hasData () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< uint8 >& SendCustomATCommandRequest::getData () const {
    return _data;
}

inline ::std::vector< uint8 >& SendCustomATCommandRequest::getDataMutable () {
    set_has_data();
    return _data;
}

inline void SendCustomATCommandRequest::setData (const ::std::vector< uint8 >& data_) {
    set_has_data();
    this->_data = data_;
}

inline void SendCustomATCommandRequest::set_has_data () {
    _has_bits_[0] |= 1u << 0;
}

inline void SendCustomATCommandRequest::clear_has_data () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  HFUpdateIndicatorsValueRequest::HFUpdateIndicatorsValueRequest ()  :
    _number (0u),
    _value (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  HFUpdateIndicatorsValueRequest::HFUpdateIndicatorsValueRequest (const HFUpdateIndicatorsValueRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _number (0u),
    _value (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  HFUpdateIndicatorsValueRequest::HFUpdateIndicatorsValueRequest (uint16 number_, uint32 value_)  :
    _number (number_),
    _value (value_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  HFUpdateIndicatorsValueRequest::~HFUpdateIndicatorsValueRequest() {
}

inline HFUpdateIndicatorsValueRequest& HFUpdateIndicatorsValueRequest::operator = (const HFUpdateIndicatorsValueRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasNumber()) {
            setNumber(rhs.getNumber());
        } else {
            clearNumber();
        }
        if (rhs.hasValue()) {
            setValue(rhs.getValue());
        } else {
            clearValue();
        }
    }
    return *this;
}

inline bool HFUpdateIndicatorsValueRequest::operator == (const HFUpdateIndicatorsValueRequest& rhs) const {
    return (((!hasNumber() && !rhs.hasNumber()) || getNumber() == rhs.getNumber()) &&
        ((!hasValue() && !rhs.hasValue()) || getValue() == rhs.getValue()));
}

inline bool HFUpdateIndicatorsValueRequest::operator != (const HFUpdateIndicatorsValueRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool HFUpdateIndicatorsValueRequest::operator < (const HFUpdateIndicatorsValueRequest& rhs) const {
    if (hasNumber() || rhs.hasNumber()) {
        if (getNumber() < rhs.getNumber()) return true;
        if (getNumber() > rhs.getNumber()) return false;
    }
    if (hasValue() || rhs.hasValue()) {
        if (getValue() < rhs.getValue()) return true;
        if (getValue() > rhs.getValue()) return false;
    }
    return false;
}

inline ::asf::core::Payload* HFUpdateIndicatorsValueRequest::clone() {
    return new HFUpdateIndicatorsValueRequest(*this);
}

inline bool HFUpdateIndicatorsValueRequest::operator > (const HFUpdateIndicatorsValueRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void HFUpdateIndicatorsValueRequest::clear() {
    clearNumber();
    clearValue();
}

inline void HFUpdateIndicatorsValueRequest::clearNumber() {
    if (hasNumber()) {
         clear_has_number();
        _number = 0u;
     }
}

inline bool HFUpdateIndicatorsValueRequest::hasNumber () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 HFUpdateIndicatorsValueRequest::getNumber () const {
    return _number;
}

inline void HFUpdateIndicatorsValueRequest::setNumber (uint16 number_) {
    set_has_number();
    this->_number = number_;
}

inline void HFUpdateIndicatorsValueRequest::clearValue() {
    if (hasValue()) {
         clear_has_value();
        _value = 0u;
     }
}

inline bool HFUpdateIndicatorsValueRequest::hasValue () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 HFUpdateIndicatorsValueRequest::getValue () const {
    return _value;
}

inline void HFUpdateIndicatorsValueRequest::setValue (uint32 value_) {
    set_has_value();
    this->_value = value_;
}

inline void HFUpdateIndicatorsValueRequest::set_has_number () {
    _has_bits_[0] |= 1u << 0;
}

inline void HFUpdateIndicatorsValueRequest::clear_has_number () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void HFUpdateIndicatorsValueRequest::set_has_value () {
    _has_bits_[0] |= 1u << 1;
}

inline void HFUpdateIndicatorsValueRequest::clear_has_value () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  PropertyChangedSignal::PropertyChangedSignal ()  :
    _name (),
    _value ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  PropertyChangedSignal::PropertyChangedSignal (const PropertyChangedSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _name (),
    _value ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  PropertyChangedSignal::PropertyChangedSignal (const ::std::string& name_, const ::asf::dbus::DBusVariant& value_)  :
    _name (name_),
    _value (value_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  PropertyChangedSignal::~PropertyChangedSignal() {
}

inline PropertyChangedSignal& PropertyChangedSignal::operator = (const PropertyChangedSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasName()) {
            setName(rhs.getName());
        } else {
            clearName();
        }
        if (rhs.hasValue()) {
            setValue(rhs.getValue());
        } else {
            clearValue();
        }
    }
    return *this;
}

inline bool PropertyChangedSignal::operator == (const PropertyChangedSignal& rhs) const {
    return (((!hasName() && !rhs.hasName()) || getName() == rhs.getName()) &&
        ((!hasValue() && !rhs.hasValue()) || getValue() == rhs.getValue()));
}

inline bool PropertyChangedSignal::operator != (const PropertyChangedSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool PropertyChangedSignal::operator < (const PropertyChangedSignal& rhs) const {
    if (hasName() || rhs.hasName()) {
        if (getName() < rhs.getName()) return true;
        if (getName() > rhs.getName()) return false;
    }
    if (hasValue() || rhs.hasValue()) {
        if (getValue() < rhs.getValue()) return true;
        if (getValue() > rhs.getValue()) return false;
    }
    return false;
}

inline ::asf::core::Payload* PropertyChangedSignal::clone() {
    return new PropertyChangedSignal(*this);
}

inline bool PropertyChangedSignal::operator > (const PropertyChangedSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void PropertyChangedSignal::clear() {
    clearName();
    clearValue();
}

inline void PropertyChangedSignal::clearName() {
    if (hasName()) {
         clear_has_name();
        _name.clear();
     }
}

inline bool PropertyChangedSignal::hasName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& PropertyChangedSignal::getName () const {
    return _name;
}

inline ::std::string& PropertyChangedSignal::getNameMutable () {
    set_has_name();
    return _name;
}

inline void PropertyChangedSignal::setName (const ::std::string& name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name = name_;
}

inline void PropertyChangedSignal::setName (const char* name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name.assign(name_);
}

inline void PropertyChangedSignal::setName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name.assign(value, size);
}

inline void PropertyChangedSignal::clearValue() {
    if (hasValue()) {
         clear_has_value();
        _value = ::asf::dbus::DBusVariant ();
     }
}

inline bool PropertyChangedSignal::hasValue () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::asf::dbus::DBusVariant& PropertyChangedSignal::getValue () const {
    return _value;
}

inline ::asf::dbus::DBusVariant& PropertyChangedSignal::getValueMutable () {
    set_has_value();
    return _value;
}

inline void PropertyChangedSignal::setValue (const ::asf::dbus::DBusVariant& value_) {
    set_has_value();
    this->_value = value_;
}

inline void PropertyChangedSignal::set_has_name () {
    _has_bits_[0] |= 1u << 0;
}

inline void PropertyChangedSignal::clear_has_name () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void PropertyChangedSignal::set_has_value () {
    _has_bits_[0] |= 1u << 1;
}

inline void PropertyChangedSignal::clear_has_value () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  RecvATCommandSignal::RecvATCommandSignal ()  :
    _data ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RecvATCommandSignal::RecvATCommandSignal (const RecvATCommandSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _data ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RecvATCommandSignal::RecvATCommandSignal (const ::std::vector< uint8 >& data_)  :
    _data (data_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RecvATCommandSignal::~RecvATCommandSignal() {
}

inline RecvATCommandSignal& RecvATCommandSignal::operator = (const RecvATCommandSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasData()) {
            setData(rhs.getData());
        } else {
            clearData();
        }
    }
    return *this;
}

inline bool RecvATCommandSignal::operator == (const RecvATCommandSignal& rhs) const {
    return (((!hasData() && !rhs.hasData()) || getData() == rhs.getData()));
}

inline bool RecvATCommandSignal::operator != (const RecvATCommandSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool RecvATCommandSignal::operator < (const RecvATCommandSignal& rhs) const {
    if (hasData() || rhs.hasData()) {
        if (getData() < rhs.getData()) return true;
        if (getData() > rhs.getData()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RecvATCommandSignal::clone() {
    return new RecvATCommandSignal(*this);
}

inline bool RecvATCommandSignal::operator > (const RecvATCommandSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RecvATCommandSignal::clear() {
    clearData();
}

inline void RecvATCommandSignal::clearData() {
    if (hasData()) {
         clear_has_data();
        _data.clear();
     }
}

inline bool RecvATCommandSignal::hasData () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< uint8 >& RecvATCommandSignal::getData () const {
    return _data;
}

inline ::std::vector< uint8 >& RecvATCommandSignal::getDataMutable () {
    set_has_data();
    return _data;
}

inline void RecvATCommandSignal::setData (const ::std::vector< uint8 >& data_) {
    set_has_data();
    this->_data = data_;
}

inline void RecvATCommandSignal::set_has_data () {
    _has_bits_[0] |= 1u << 0;
}

inline void RecvATCommandSignal::clear_has_data () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  AgSupportedHFindicatorsIndSignal::AgSupportedHFindicatorsIndSignal ()  :
    _indicators_anum ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AgSupportedHFindicatorsIndSignal::AgSupportedHFindicatorsIndSignal (const AgSupportedHFindicatorsIndSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _indicators_anum ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AgSupportedHFindicatorsIndSignal::AgSupportedHFindicatorsIndSignal (const ::std::vector< uint8 >& indicators_anum_)  :
    _indicators_anum (indicators_anum_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AgSupportedHFindicatorsIndSignal::~AgSupportedHFindicatorsIndSignal() {
}

inline AgSupportedHFindicatorsIndSignal& AgSupportedHFindicatorsIndSignal::operator = (const AgSupportedHFindicatorsIndSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasIndicators_anum()) {
            setIndicators_anum(rhs.getIndicators_anum());
        } else {
            clearIndicators_anum();
        }
    }
    return *this;
}

inline bool AgSupportedHFindicatorsIndSignal::operator == (const AgSupportedHFindicatorsIndSignal& rhs) const {
    return (((!hasIndicators_anum() && !rhs.hasIndicators_anum()) || getIndicators_anum() == rhs.getIndicators_anum()));
}

inline bool AgSupportedHFindicatorsIndSignal::operator != (const AgSupportedHFindicatorsIndSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool AgSupportedHFindicatorsIndSignal::operator < (const AgSupportedHFindicatorsIndSignal& rhs) const {
    if (hasIndicators_anum() || rhs.hasIndicators_anum()) {
        if (getIndicators_anum() < rhs.getIndicators_anum()) return true;
        if (getIndicators_anum() > rhs.getIndicators_anum()) return false;
    }
    return false;
}

inline ::asf::core::Payload* AgSupportedHFindicatorsIndSignal::clone() {
    return new AgSupportedHFindicatorsIndSignal(*this);
}

inline bool AgSupportedHFindicatorsIndSignal::operator > (const AgSupportedHFindicatorsIndSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AgSupportedHFindicatorsIndSignal::clear() {
    clearIndicators_anum();
}

inline void AgSupportedHFindicatorsIndSignal::clearIndicators_anum() {
    if (hasIndicators_anum()) {
         clear_has_indicators_anum();
        _indicators_anum.clear();
     }
}

inline bool AgSupportedHFindicatorsIndSignal::hasIndicators_anum () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< uint8 >& AgSupportedHFindicatorsIndSignal::getIndicators_anum () const {
    return _indicators_anum;
}

inline ::std::vector< uint8 >& AgSupportedHFindicatorsIndSignal::getIndicators_anumMutable () {
    set_has_indicators_anum();
    return _indicators_anum;
}

inline void AgSupportedHFindicatorsIndSignal::setIndicators_anum (const ::std::vector< uint8 >& indicators_anum_) {
    set_has_indicators_anum();
    this->_indicators_anum = indicators_anum_;
}

inline void AgSupportedHFindicatorsIndSignal::set_has_indicators_anum () {
    _has_bits_[0] |= 1u << 0;
}

inline void AgSupportedHFindicatorsIndSignal::clear_has_indicators_anum () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  AgHFindicatorsStateIndSignal::AgHFindicatorsStateIndSignal ()  :
    _number (0u),
    _state (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AgHFindicatorsStateIndSignal::AgHFindicatorsStateIndSignal (const AgHFindicatorsStateIndSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _number (0u),
    _state (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AgHFindicatorsStateIndSignal::AgHFindicatorsStateIndSignal (uint16 number_, uint16 state_)  :
    _number (number_),
    _state (state_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AgHFindicatorsStateIndSignal::~AgHFindicatorsStateIndSignal() {
}

inline AgHFindicatorsStateIndSignal& AgHFindicatorsStateIndSignal::operator = (const AgHFindicatorsStateIndSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasNumber()) {
            setNumber(rhs.getNumber());
        } else {
            clearNumber();
        }
        if (rhs.hasState()) {
            setState(rhs.getState());
        } else {
            clearState();
        }
    }
    return *this;
}

inline bool AgHFindicatorsStateIndSignal::operator == (const AgHFindicatorsStateIndSignal& rhs) const {
    return (((!hasNumber() && !rhs.hasNumber()) || getNumber() == rhs.getNumber()) &&
        ((!hasState() && !rhs.hasState()) || getState() == rhs.getState()));
}

inline bool AgHFindicatorsStateIndSignal::operator != (const AgHFindicatorsStateIndSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool AgHFindicatorsStateIndSignal::operator < (const AgHFindicatorsStateIndSignal& rhs) const {
    if (hasNumber() || rhs.hasNumber()) {
        if (getNumber() < rhs.getNumber()) return true;
        if (getNumber() > rhs.getNumber()) return false;
    }
    if (hasState() || rhs.hasState()) {
        if (getState() < rhs.getState()) return true;
        if (getState() > rhs.getState()) return false;
    }
    return false;
}

inline ::asf::core::Payload* AgHFindicatorsStateIndSignal::clone() {
    return new AgHFindicatorsStateIndSignal(*this);
}

inline bool AgHFindicatorsStateIndSignal::operator > (const AgHFindicatorsStateIndSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AgHFindicatorsStateIndSignal::clear() {
    clearNumber();
    clearState();
}

inline void AgHFindicatorsStateIndSignal::clearNumber() {
    if (hasNumber()) {
         clear_has_number();
        _number = 0u;
     }
}

inline bool AgHFindicatorsStateIndSignal::hasNumber () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 AgHFindicatorsStateIndSignal::getNumber () const {
    return _number;
}

inline void AgHFindicatorsStateIndSignal::setNumber (uint16 number_) {
    set_has_number();
    this->_number = number_;
}

inline void AgHFindicatorsStateIndSignal::clearState() {
    if (hasState()) {
         clear_has_state();
        _state = 0u;
     }
}

inline bool AgHFindicatorsStateIndSignal::hasState () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint16 AgHFindicatorsStateIndSignal::getState () const {
    return _state;
}

inline void AgHFindicatorsStateIndSignal::setState (uint16 state_) {
    set_has_state();
    this->_state = state_;
}

inline void AgHFindicatorsStateIndSignal::set_has_number () {
    _has_bits_[0] |= 1u << 0;
}

inline void AgHFindicatorsStateIndSignal::clear_has_number () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void AgHFindicatorsStateIndSignal::set_has_state () {
    _has_bits_[0] |= 1u << 1;
}

inline void AgHFindicatorsStateIndSignal::clear_has_state () {
    _has_bits_[0] &= ~ (1u << 1);
}

} // namespace Handsfree
} // namespace ofono
} // namespace org

#endif // ORG_OFONO_HANDSFREE_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
