/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "org/bluez/obex/Transfer.h"
#include "org/bluez/obex/TransferDBus.h"
#include "org/bluez/obex/TransferJson.h"
#include "org/bluez/obex/TransferStub.h"
#include <string>

#include "asf/dbus/DBusMessage.h"

namespace org {
namespace bluez {
namespace obex {
namespace Transfer {

DEFINE_CLASS_LOGGER("//org/bluez/obex/client/session/transfer/created/during/runtime/org/bluez/obex/Transfer", TransferStub);

static ::asf::dbus::DBusUtils::stringEntry methodsTable[] = {
    { 6, "Cancel", 0 },
};

static ::asf::dbus::DBusUtils::stringEntry propertiesTable[] = {
    { 4, "Name", 2 },
    { 4, "Size", 5 },
    { 4, "Time", 4 },
    { 4, "Type", 3 },
    { 6, "Status", 0 },
    { 7, "Session", 1 },
    { 8, "Filename", 7 },
    { 11, "Transferred", 6 },
};

class TransferStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    TransferStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    TransferStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    TransferStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "org.bluez.obex.Transfer"),
          _logger(logger) {}

    virtual ~TransferStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void TransferStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    unsigned int methodIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (message.getMemberName().c_str(), message.getMemberName().length(), methodsTable, 1, methodIndex)) {
        switch (methodIndex) {
        case 0: {

            // method 'Cancel'

            LOG_DEBUG_STUB("process method '%s'", "Cancel");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CancelRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "Cancel", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< CancelRequest > payload = ::boost::static_pointer_cast<CancelRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<TransferStub*>(getStub())->onCancelRequest(payload);
            return;
        }
        default:
            break;
        }
    }
    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* TransferStubDelegate::introspect() const {
    return     "<interface name=\"org.bluez.obex.Transfer\">\n"
            "      <method name=\"Cancel\"/>\n"
            "      <property access=\"read\" name=\"Status\" type=\"s\"/>\n"
            "      <property access=\"read\" name=\"Session\" type=\"o\"/>\n"
            "      <property access=\"read\" name=\"Name\" type=\"s\"/>\n"
            "      <property access=\"read\" name=\"Type\" type=\"s\"/>\n"
            "      <property access=\"read\" name=\"Time\" type=\"y\"/>\n"
            "      <property access=\"read\" name=\"Size\" type=\"t\"/>\n"
            "      <property access=\"read\" name=\"Transferred\" type=\"t\"/>\n"
            "      <property access=\"read\" name=\"Filename\" type=\"s\"/>\n"
            "</interface>\n";
}

void TransferStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<TransferStub*>(getStub()))->onGetAll (properties);
}

void TransferStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 8, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "Status");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 1: {
            LOG_DEBUG_STUB("process property '%s'", "Session");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 2: {
            LOG_DEBUG_STUB("process property '%s'", "Name");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 3: {
            LOG_DEBUG_STUB("process property '%s'", "Type");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 4: {
            LOG_DEBUG_STUB("process property '%s'", "Time");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 5: {
            LOG_DEBUG_STUB("process property '%s'", "Size");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 6: {
            LOG_DEBUG_STUB("process property '%s'", "Transferred");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 7: {
            LOG_DEBUG_STUB("process property '%s'", "Filename");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void TransferStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 8, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "Status");
            ::boost::shared_ptr< StatusGet > payload(new StatusGet());
            payload->setAct(act);
            static_cast<TransferStub*>(getStub())->onStatusGet (payload);
            return;
        }
        case 1: {
            LOG_DEBUG_STUB("process property '%s'", "Session");
            ::boost::shared_ptr< SessionGet > payload(new SessionGet());
            payload->setAct(act);
            static_cast<TransferStub*>(getStub())->onSessionGet (payload);
            return;
        }
        case 2: {
            LOG_DEBUG_STUB("process property '%s'", "Name");
            ::boost::shared_ptr< NameGet > payload(new NameGet());
            payload->setAct(act);
            static_cast<TransferStub*>(getStub())->onNameGet (payload);
            return;
        }
        case 3: {
            LOG_DEBUG_STUB("process property '%s'", "Type");
            ::boost::shared_ptr< TypeGet > payload(new TypeGet());
            payload->setAct(act);
            static_cast<TransferStub*>(getStub())->onTypeGet (payload);
            return;
        }
        case 4: {
            LOG_DEBUG_STUB("process property '%s'", "Time");
            ::boost::shared_ptr< TimeGet > payload(new TimeGet());
            payload->setAct(act);
            static_cast<TransferStub*>(getStub())->onTimeGet (payload);
            return;
        }
        case 5: {
            LOG_DEBUG_STUB("process property '%s'", "Size");
            ::boost::shared_ptr< SizeGet > payload(new SizeGet());
            payload->setAct(act);
            static_cast<TransferStub*>(getStub())->onSizeGet (payload);
            return;
        }
        case 6: {
            LOG_DEBUG_STUB("process property '%s'", "Transferred");
            ::boost::shared_ptr< TransferredGet > payload(new TransferredGet());
            payload->setAct(act);
            static_cast<TransferStub*>(getStub())->onTransferredGet (payload);
            return;
        }
        case 7: {
            LOG_DEBUG_STUB("process property '%s'", "Filename");
            ::boost::shared_ptr< FilenameGet > payload(new FilenameGet());
            payload->setAct(act);
            static_cast<TransferStub*>(getStub())->onFilenameGet (payload);
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

TransferStub::TransferStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new TransferStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

TransferStub::TransferStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new TransferStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

TransferStub::~TransferStub() {
    delete _stubDelegate;
}

void TransferStub::sendStatusUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        StatusUpdate payload(_StatusProperty);

        LOG_INFO ("-> send%s", "StatusUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Status", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bluez.obex.Transfer", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "StatusUpdate");
    }
}

void TransferStub::onStatusGet(const ::boost::shared_ptr< StatusGet >& status) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "StatusGet", status->getAct());
    sendStatusGetUpdate(_StatusProperty.getStatus(), status->getAct());
}

void TransferStub::sendStatusGetUpdate(const ::std::string& status, act_t act) {
    ::asf::dbus::DBusVariant variant;
    StatusGet payload(status);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "StatusGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void TransferStub::setStatus(const ::std::string& status) {
    if(status!=_StatusProperty.getStatus()) {
        _StatusProperty.setStatus(status);
        sendStatusUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& TransferStub::getStatus() const {
    return _StatusProperty.getStatus();
}

::std::string& TransferStub::getStatusMutable() {
    return _StatusProperty.getStatusMutable();
}

void TransferStub::sendSessionUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        SessionUpdate payload(_SessionProperty);

        LOG_INFO ("-> send%s", "SessionUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Session", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bluez.obex.Transfer", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "SessionUpdate");
    }
}

void TransferStub::onSessionGet(const ::boost::shared_ptr< SessionGet >& session) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "SessionGet", session->getAct());
    sendSessionGetUpdate(_SessionProperty.getSession(), session->getAct());
}

void TransferStub::sendSessionGetUpdate(const ::std::string& session, act_t act) {
    ::asf::dbus::DBusVariant variant;
    SessionGet payload(session);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "SessionGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void TransferStub::setSession(const ::std::string& session) {
    if(session!=_SessionProperty.getSession()) {
        _SessionProperty.setSession(session);
        sendSessionUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& TransferStub::getSession() const {
    return _SessionProperty.getSession();
}

::std::string& TransferStub::getSessionMutable() {
    return _SessionProperty.getSessionMutable();
}

void TransferStub::sendNameUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        NameUpdate payload(_NameProperty);

        LOG_INFO ("-> send%s", "NameUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Name", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bluez.obex.Transfer", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "NameUpdate");
    }
}

void TransferStub::onNameGet(const ::boost::shared_ptr< NameGet >& name) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "NameGet", name->getAct());
    sendNameGetUpdate(_NameProperty.getName(), name->getAct());
}

void TransferStub::sendNameGetUpdate(const ::std::string& name, act_t act) {
    ::asf::dbus::DBusVariant variant;
    NameGet payload(name);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "NameGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void TransferStub::setName(const ::std::string& name) {
    if(name!=_NameProperty.getName()) {
        _NameProperty.setName(name);
        sendNameUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& TransferStub::getName() const {
    return _NameProperty.getName();
}

::std::string& TransferStub::getNameMutable() {
    return _NameProperty.getNameMutable();
}

void TransferStub::sendTypeUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        TypeUpdate payload(_TypeProperty);

        LOG_INFO ("-> send%s", "TypeUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Type", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bluez.obex.Transfer", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "TypeUpdate");
    }
}

void TransferStub::onTypeGet(const ::boost::shared_ptr< TypeGet >& type) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "TypeGet", type->getAct());
    sendTypeGetUpdate(_TypeProperty.getType(), type->getAct());
}

void TransferStub::sendTypeGetUpdate(const ::std::string& type, act_t act) {
    ::asf::dbus::DBusVariant variant;
    TypeGet payload(type);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "TypeGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void TransferStub::setType(const ::std::string& type) {
    if(type!=_TypeProperty.getType()) {
        _TypeProperty.setType(type);
        sendTypeUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& TransferStub::getType() const {
    return _TypeProperty.getType();
}

::std::string& TransferStub::getTypeMutable() {
    return _TypeProperty.getTypeMutable();
}

void TransferStub::sendTimeUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        TimeUpdate payload(_TimeProperty);

        LOG_INFO ("-> send%s", "TimeUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Time", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bluez.obex.Transfer", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "TimeUpdate");
    }
}

void TransferStub::onTimeGet(const ::boost::shared_ptr< TimeGet >& time) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "TimeGet", time->getAct());
    sendTimeGetUpdate(_TimeProperty.getTime(), time->getAct());
}

void TransferStub::sendTimeGetUpdate(uint8 time, act_t act) {
    ::asf::dbus::DBusVariant variant;
    TimeGet payload(time);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "TimeGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void TransferStub::setTime(uint8 time) {
    if(time!=_TimeProperty.getTime()) {
        _TimeProperty.setTime(time);
        sendTimeUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint8 TransferStub::getTime() const {
    return _TimeProperty.getTime();
}

void TransferStub::sendSizeUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        SizeUpdate payload(_SizeProperty);

        LOG_INFO ("-> send%s", "SizeUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Size", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bluez.obex.Transfer", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "SizeUpdate");
    }
}

void TransferStub::onSizeGet(const ::boost::shared_ptr< SizeGet >& size) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "SizeGet", size->getAct());
    sendSizeGetUpdate(_SizeProperty.getSize(), size->getAct());
}

void TransferStub::sendSizeGetUpdate(uint64 size, act_t act) {
    ::asf::dbus::DBusVariant variant;
    SizeGet payload(size);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "SizeGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void TransferStub::setSize(uint64 size) {
    if(size!=_SizeProperty.getSize()) {
        _SizeProperty.setSize(size);
        sendSizeUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint64 TransferStub::getSize() const {
    return _SizeProperty.getSize();
}

void TransferStub::sendTransferredUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        TransferredUpdate payload(_TransferredProperty);

        LOG_INFO ("-> send%s", "TransferredUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Transferred", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bluez.obex.Transfer", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "TransferredUpdate");
    }
}

void TransferStub::onTransferredGet(const ::boost::shared_ptr< TransferredGet >& transferred) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "TransferredGet", transferred->getAct());
    sendTransferredGetUpdate(_TransferredProperty.getTransferred(), transferred->getAct());
}

void TransferStub::sendTransferredGetUpdate(uint64 transferred, act_t act) {
    ::asf::dbus::DBusVariant variant;
    TransferredGet payload(transferred);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "TransferredGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void TransferStub::setTransferred(uint64 transferred) {
    if(transferred!=_TransferredProperty.getTransferred()) {
        _TransferredProperty.setTransferred(transferred);
        sendTransferredUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint64 TransferStub::getTransferred() const {
    return _TransferredProperty.getTransferred();
}

void TransferStub::sendFilenameUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        FilenameUpdate payload(_FilenameProperty);

        LOG_INFO ("-> send%s", "FilenameUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Filename", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bluez.obex.Transfer", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "FilenameUpdate");
    }
}

void TransferStub::onFilenameGet(const ::boost::shared_ptr< FilenameGet >& filename) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "FilenameGet", filename->getAct());
    sendFilenameGetUpdate(_FilenameProperty.getFilename(), filename->getAct());
}

void TransferStub::sendFilenameGetUpdate(const ::std::string& filename, act_t act) {
    ::asf::dbus::DBusVariant variant;
    FilenameGet payload(filename);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "FilenameGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void TransferStub::setFilename(const ::std::string& filename) {
    if(filename!=_FilenameProperty.getFilename()) {
        _FilenameProperty.setFilename(filename);
        sendFilenameUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& TransferStub::getFilename() const {
    return _FilenameProperty.getFilename();
}

::std::string& TransferStub::getFilenameMutable() {
    return _FilenameProperty.getFilenameMutable();
}

void  TransferStub::sendCancelResponse (act_t act) {
    CancelResponse* payload = new CancelResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "Cancel", CancelResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "Cancel", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  TransferStub::sendCancelError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    CancelError* payload = new CancelError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "Cancel", CancelError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "Cancel", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void TransferStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {

    //property 'Status'
    {
        ::asf::dbus::DBusVariant variant;
        StatusGet payload(_StatusProperty.getStatus());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Status", variant));
    }

    //property 'Session'
    {
        ::asf::dbus::DBusVariant variant;
        SessionGet payload(_SessionProperty.getSession());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Session", variant));
    }

    //property 'Name'
    {
        ::asf::dbus::DBusVariant variant;
        NameGet payload(_NameProperty.getName());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Name", variant));
    }

    //property 'Type'
    {
        ::asf::dbus::DBusVariant variant;
        TypeGet payload(_TypeProperty.getType());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Type", variant));
    }

    //property 'Time'
    {
        ::asf::dbus::DBusVariant variant;
        TimeGet payload(_TimeProperty.getTime());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Time", variant));
    }

    //property 'Size'
    {
        ::asf::dbus::DBusVariant variant;
        SizeGet payload(_SizeProperty.getSize());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Size", variant));
    }

    //property 'Transferred'
    {
        ::asf::dbus::DBusVariant variant;
        TransferredGet payload(_TransferredProperty.getTransferred());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Transferred", variant));
    }

    //property 'Filename'
    {
        ::asf::dbus::DBusVariant variant;
        FilenameGet payload(_FilenameProperty.getFilename());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Filename", variant));
    }
}

} // namespace Transfer
} // namespace obex
} // namespace bluez
} // namespace org
