/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_BLUEZ_OBEX_TRANSFERPROXY_H
#define ORG_BLUEZ_OBEX_TRANSFERPROXY_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/nullable.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusProxy.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "org/bluez/obex/Transfer.h"
#include <dbus/dbus.h>
#include <string>

namespace org {
namespace bluez {
namespace obex {
namespace Transfer {

class TransferProxy;

class CancelCallbackIF {
public:
    virtual ~CancelCallbackIF() {}

    virtual void onCancelError(const ::boost::shared_ptr< TransferProxy >& proxy, const ::boost::shared_ptr< CancelError >& error) = 0;

    virtual void onCancelResponse(const ::boost::shared_ptr< TransferProxy >& proxy, const ::boost::shared_ptr< CancelResponse >& response) = 0;
};

class FilenameCallbackIF {
public:
    virtual ~FilenameCallbackIF() {}

    virtual void onFilenameError(const ::boost::shared_ptr< TransferProxy >& proxy, const ::boost::shared_ptr< FilenameError >& error) = 0;

    virtual void onFilenameUpdate(const ::boost::shared_ptr< TransferProxy >& proxy, const ::boost::shared_ptr< FilenameUpdate >& update) = 0;
};

class NameCallbackIF {
public:
    virtual ~NameCallbackIF() {}

    virtual void onNameError(const ::boost::shared_ptr< TransferProxy >& proxy, const ::boost::shared_ptr< NameError >& error) = 0;

    virtual void onNameUpdate(const ::boost::shared_ptr< TransferProxy >& proxy, const ::boost::shared_ptr< NameUpdate >& update) = 0;
};

class SessionCallbackIF {
public:
    virtual ~SessionCallbackIF() {}

    virtual void onSessionError(const ::boost::shared_ptr< TransferProxy >& proxy, const ::boost::shared_ptr< SessionError >& error) = 0;

    virtual void onSessionUpdate(const ::boost::shared_ptr< TransferProxy >& proxy, const ::boost::shared_ptr< SessionUpdate >& update) = 0;
};

class SizeCallbackIF {
public:
    virtual ~SizeCallbackIF() {}

    virtual void onSizeError(const ::boost::shared_ptr< TransferProxy >& proxy, const ::boost::shared_ptr< SizeError >& error) = 0;

    virtual void onSizeUpdate(const ::boost::shared_ptr< TransferProxy >& proxy, const ::boost::shared_ptr< SizeUpdate >& update) = 0;
};

class StatusCallbackIF {
public:
    virtual ~StatusCallbackIF() {}

    virtual void onStatusError(const ::boost::shared_ptr< TransferProxy >& proxy, const ::boost::shared_ptr< StatusError >& error) = 0;

    virtual void onStatusUpdate(const ::boost::shared_ptr< TransferProxy >& proxy, const ::boost::shared_ptr< StatusUpdate >& update) = 0;
};

class TimeCallbackIF {
public:
    virtual ~TimeCallbackIF() {}

    virtual void onTimeError(const ::boost::shared_ptr< TransferProxy >& proxy, const ::boost::shared_ptr< TimeError >& error) = 0;

    virtual void onTimeUpdate(const ::boost::shared_ptr< TransferProxy >& proxy, const ::boost::shared_ptr< TimeUpdate >& update) = 0;
};

class TransferredCallbackIF {
public:
    virtual ~TransferredCallbackIF() {}

    virtual void onTransferredError(const ::boost::shared_ptr< TransferProxy >& proxy, const ::boost::shared_ptr< TransferredError >& error) = 0;

    virtual void onTransferredUpdate(const ::boost::shared_ptr< TransferProxy >& proxy, const ::boost::shared_ptr< TransferredUpdate >& update) = 0;
};

class TypeCallbackIF {
public:
    virtual ~TypeCallbackIF() {}

    virtual void onTypeError(const ::boost::shared_ptr< TransferProxy >& proxy, const ::boost::shared_ptr< TypeError >& error) = 0;

    virtual void onTypeUpdate(const ::boost::shared_ptr< TransferProxy >& proxy, const ::boost::shared_ptr< TypeUpdate >& update) = 0;
};


/**
 * TransferProxy is the client side representation of the D-Bus service
 * interface 'org.bluez.obex.Transfer' (specified in file
 * obex_transfer.xml).
 *
 * If the meaning of "org.bluez.obex.Transfer" isn't clear, then there should be a description here.
 */
class TransferProxy : public ::asf::dbus::DBusProxy
{
public:
    /**
     * Create a new instance of TransferProxy.
     */
    static ::boost::shared_ptr< TransferProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Create a new instance of TransferProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @deprecated use the createProxy() method with the parameter
     * ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector instead.
     */
    static ::boost::shared_ptr< TransferProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        ::DBusBusType busType,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector connectorOptions;
        connectorOptions.setBusType(::asf::dbus::DBusUtils::toOptions(busType).getBusType());
        return createProxy(portName, busName, objectPath, connectorOptions, serviceAvailable);
    }

    /**
     * Create a new instance of TransferProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     */
    static ::boost::shared_ptr< TransferProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        const ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector& connectorOptions,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< TransferProxy > proxyNew(new TransferProxy(portName, serviceAvailable));
        ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew, busName, objectPath, connectorOptions);
        proxyNew->createHelperProxies(true);
        return proxyNew;
    }

    virtual ~TransferProxy ();



    // Property 'Status'

    /**
     * Notify on the property 'Status'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'Status'</b>:
     *
     * If the meaning of "Status" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendStatusRegister(StatusCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'Status'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'Status'</b>:
     *
     * If the meaning of "Status" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendStatusRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendStatusDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'Status'.
     */
    void sendStatusDeregisterAll() const;

    /**
     * Request the value of the property 'Status' from the D-Bus server. This
     * method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'Status'</b>:
     *
     * If the meaning of "Status" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendStatusGet(StatusCallbackIF& cb);


    /**
     * Returns the current value of the property 'Status' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasStatus()
     * returns true.
     *
     * @return the previously received value of the property 'Status'.
     */
    const ::std::string& getStatus() const;

    /**
     * Determines whether a status message for the property 'Status' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasStatus() const;

    // Property 'Session'

    /**
     * Notify on the property 'Session'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'Session'</b>:
     *
     * If the meaning of "Session" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSessionRegister(SessionCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'Session'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'Session'</b>:
     *
     * If the meaning of "Session" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendSessionRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendSessionDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'Session'.
     */
    void sendSessionDeregisterAll() const;

    /**
     * Request the value of the property 'Session' from the D-Bus server. This
     * method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'Session'</b>:
     *
     * If the meaning of "Session" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSessionGet(SessionCallbackIF& cb);


    /**
     * Returns the current value of the property 'Session' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasSession()
     * returns true.
     *
     * @return the previously received value of the property 'Session'.
     */
    const ::std::string& getSession() const;

    /**
     * Determines whether a status message for the property 'Session' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasSession() const;

    // Property 'Name'

    /**
     * Notify on the property 'Name'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'Name'</b>:
     *
     * If the meaning of "Name" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendNameRegister(NameCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'Name'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'Name'</b>:
     *
     * If the meaning of "Name" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendNameRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendNameDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'Name'.
     */
    void sendNameDeregisterAll() const;

    /**
     * Request the value of the property 'Name' from the D-Bus server. This
     * method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'Name'</b>:
     *
     * If the meaning of "Name" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendNameGet(NameCallbackIF& cb);


    /**
     * Returns the current value of the property 'Name' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasName()
     * returns true.
     *
     * @return the previously received value of the property 'Name'.
     */
    const ::std::string& getName() const;

    /**
     * Determines whether a status message for the property 'Name' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasName() const;

    // Property 'Type'

    /**
     * Notify on the property 'Type'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'Type'</b>:
     *
     * If the meaning of "Type" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendTypeRegister(TypeCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'Type'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'Type'</b>:
     *
     * If the meaning of "Type" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendTypeRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendTypeDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'Type'.
     */
    void sendTypeDeregisterAll() const;

    /**
     * Request the value of the property 'Type' from the D-Bus server. This
     * method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'Type'</b>:
     *
     * If the meaning of "Type" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendTypeGet(TypeCallbackIF& cb);


    /**
     * Returns the current value of the property 'Type' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasType()
     * returns true.
     *
     * @return the previously received value of the property 'Type'.
     */
    const ::std::string& getType() const;

    /**
     * Determines whether a status message for the property 'Type' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasType() const;

    // Property 'Time'

    /**
     * Notify on the property 'Time'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'Time'</b>:
     *
     * If the meaning of "Time" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendTimeRegister(TimeCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'Time'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'Time'</b>:
     *
     * If the meaning of "Time" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendTimeRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendTimeDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'Time'.
     */
    void sendTimeDeregisterAll() const;

    /**
     * Request the value of the property 'Time' from the D-Bus server. This
     * method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'Time'</b>:
     *
     * If the meaning of "Time" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendTimeGet(TimeCallbackIF& cb);


    /**
     * Returns the current value of the property 'Time' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasTime()
     * returns true.
     *
     * @return the previously received value of the property 'Time'.
     */
    uint8 getTime() const;

    /**
     * Determines whether a status message for the property 'Time' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasTime() const;

    // Property 'Size'

    /**
     * Notify on the property 'Size'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'Size'</b>:
     *
     * If the meaning of "Size" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSizeRegister(SizeCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'Size'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'Size'</b>:
     *
     * If the meaning of "Size" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendSizeRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendSizeDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'Size'.
     */
    void sendSizeDeregisterAll() const;

    /**
     * Request the value of the property 'Size' from the D-Bus server. This
     * method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'Size'</b>:
     *
     * If the meaning of "Size" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSizeGet(SizeCallbackIF& cb);


    /**
     * Returns the current value of the property 'Size' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasSize()
     * returns true.
     *
     * @return the previously received value of the property 'Size'.
     */
    uint64 getSize() const;

    /**
     * Determines whether a status message for the property 'Size' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasSize() const;

    // Property 'Transferred'

    /**
     * Notify on the property 'Transferred'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'Transferred'</b>:
     *
     * If the meaning of "Transferred" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendTransferredRegister(TransferredCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'Transferred'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'Transferred'</b>:
     *
     * If the meaning of "Transferred" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendTransferredRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendTransferredDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'Transferred'.
     */
    void sendTransferredDeregisterAll() const;

    /**
     * Request the value of the property 'Transferred' from the D-Bus server.
     * This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'Transferred'</b>:
     *
     * If the meaning of "Transferred" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendTransferredGet(TransferredCallbackIF& cb);


    /**
     * Returns the current value of the property 'Transferred' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasTransferred() returns true.
     *
     * @return the previously received value of the property 'Transferred'.
     */
    uint64 getTransferred() const;

    /**
     * Determines whether a status message for the property 'Transferred' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasTransferred() const;

    // Property 'Filename'

    /**
     * Notify on the property 'Filename'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'Filename'</b>:
     *
     * If the meaning of "Filename" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendFilenameRegister(FilenameCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'Filename'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'Filename'</b>:
     *
     * If the meaning of "Filename" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendFilenameRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendFilenameDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'Filename'.
     */
    void sendFilenameDeregisterAll() const;

    /**
     * Request the value of the property 'Filename' from the D-Bus server.
     * This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'Filename'</b>:
     *
     * If the meaning of "Filename" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendFilenameGet(FilenameCallbackIF& cb);


    /**
     * Returns the current value of the property 'Filename' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasFilename()
     * returns true.
     *
     * @return the previously received value of the property 'Filename'.
     */
    const ::std::string& getFilename() const;

    /**
     * Determines whether a status message for the property 'Filename' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasFilename() const;


    // Method 'Cancel'

    /**
     * Call the method 'Cancel'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'Cancel'</b>:
     *
     * If the meaning of "Cancel" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendCancelRequest(CancelCallbackIF& cb) const;

    /**
     * Release all property and signal notifications.
     */
    void sendDeregisterAll () const;

private:

    TransferProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    act_t addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const;

    act_t addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const;

    virtual void clearAllProperties ();

    // Property 'Status'

    ::asf::core::nullable< StatusUpdate > _status;

    // Property 'Session'

    ::asf::core::nullable< SessionUpdate > _session;

    // Property 'Name'

    ::asf::core::nullable< NameUpdate > _name;

    // Property 'Type'

    ::asf::core::nullable< TypeUpdate > _type;

    // Property 'Time'

    ::asf::core::nullable< TimeUpdate > _time;

    // Property 'Size'

    ::asf::core::nullable< SizeUpdate > _size;

    // Property 'Transferred'

    ::asf::core::nullable< TransferredUpdate > _transferred;

    // Property 'Filename'

    ::asf::core::nullable< FilenameUpdate > _filename;

    DECLARE_CLASS_LOGGER();

    friend class TransferProxyCallback;
};

} // namespace Transfer
} // namespace obex
} // namespace bluez
} // namespace org

#endif // ORG_BLUEZ_OBEX_TRANSFERPROXY_H
