/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_BLUEZ_OBEX_SESSIONSTUB_H
#define ORG_BLUEZ_OBEX_SESSIONSTUB_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStub.h"
#include "asf/dbus/DBusVariant.h"
#include "boost/shared_ptr.hpp"
#include "org/bluez/obex/Session.h"
#include <string>

namespace org {
namespace bluez {
namespace obex {
namespace Session {

class SessionStubDelegate;

class SessionStub : public ::asf::dbus::DBusStub
{
public:

    /**
     * Create an instance of the SessionStub
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     */
    SessionStub (const std::string& portName);

    /**
     * Create an instance of the SessionStub
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     * @param objectPath the dbus object path, see
     * http://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-marshaling-object-path
     */
    SessionStub (const std::string& portName, const std::string& objectPath);

    virtual ~SessionStub();

    // property 'Source'

    /**
     * The method onSourceGet() is called by ASF when a client invokes the
     * read method for the property 'Source'. The onSourceGet() method returns
     * by default the current property value to the caller. In case this
     * default behavior doesn't match your needs feel free to override this
     * method.
     *
     * <b>Documentation of 'Source'</b>:
     *
     * If the meaning of "Source" isn't clear, then there should be a description here.
     */
    virtual void onSourceGet(const ::boost::shared_ptr< SourceGet >& payload);

    /**
     * Sends back the update to a previous onSourceGet().
     *
     * <b>Documentation of 'Source'</b>:
     *
     * If the meaning of "Source" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onSourceGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendSourceGetUpdate(const ::std::string& source, act_t act = 0);

    /**
     * Set the value of the property 'Source' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'Source'</b>:
     *
     * If the meaning of "Source" isn't clear, then there should be a description here.
     */
    void setSource(const ::std::string& source);

    /**
     * Returns the current value of the property 'Source'.
     *
     * <b>Documentation of 'Source'</b>:
     *
     * If the meaning of "Source" isn't clear, then there should be a description here.
     */
    const ::std::string& getSource() const;

    /**
     * Returns the current value of the property 'Source' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendSourceUpdate() method.
     *
     * <b>Documentation of 'Source'</b>:
     *
     * If the meaning of "Source" isn't clear, then there should be a description here.
     */
    ::std::string& getSourceMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendSourceUpdate().
     *
     * <b>Documentation of 'Source'</b>:
     *
     * If the meaning of "Source" isn't clear, then there should be a description here.
     */
    void sendSourceUpdate();

    // property 'Destination'

    /**
     * The method onDestinationGet() is called by ASF when a client invokes
     * the read method for the property 'Destination'. The onDestinationGet()
     * method returns by default the current property value to the caller. In
     * case this default behavior doesn't match your needs feel free to
     * override this method.
     *
     * <b>Documentation of 'Destination'</b>:
     *
     * If the meaning of "Destination" isn't clear, then there should be a description here.
     */
    virtual void onDestinationGet(const ::boost::shared_ptr< DestinationGet >& payload);

    /**
     * Sends back the update to a previous onDestinationGet().
     *
     * <b>Documentation of 'Destination'</b>:
     *
     * If the meaning of "Destination" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onDestinationGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendDestinationGetUpdate(const ::std::string& destination, act_t act = 0);

    /**
     * Set the value of the property 'Destination' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'Destination'</b>:
     *
     * If the meaning of "Destination" isn't clear, then there should be a description here.
     */
    void setDestination(const ::std::string& destination);

    /**
     * Returns the current value of the property 'Destination'.
     *
     * <b>Documentation of 'Destination'</b>:
     *
     * If the meaning of "Destination" isn't clear, then there should be a description here.
     */
    const ::std::string& getDestination() const;

    /**
     * Returns the current value of the property 'Destination' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendDestinationUpdate() method.
     *
     * <b>Documentation of 'Destination'</b>:
     *
     * If the meaning of "Destination" isn't clear, then there should be a description here.
     */
    ::std::string& getDestinationMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendDestinationUpdate().
     *
     * <b>Documentation of 'Destination'</b>:
     *
     * If the meaning of "Destination" isn't clear, then there should be a description here.
     */
    void sendDestinationUpdate();

    // property 'Channel'

    /**
     * The method onChannelGet() is called by ASF when a client invokes the
     * read method for the property 'Channel'. The onChannelGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'Channel'</b>:
     *
     * If the meaning of "Channel" isn't clear, then there should be a description here.
     */
    virtual void onChannelGet(const ::boost::shared_ptr< ChannelGet >& payload);

    /**
     * Sends back the update to a previous onChannelGet().
     *
     * <b>Documentation of 'Channel'</b>:
     *
     * If the meaning of "Channel" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onChannelGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendChannelGetUpdate(uint8 channel, act_t act = 0);

    /**
     * Set the value of the property 'Channel' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'Channel'</b>:
     *
     * If the meaning of "Channel" isn't clear, then there should be a description here.
     */
    void setChannel(uint8 channel);

    /**
     * Returns the current value of the property 'Channel'.
     *
     * <b>Documentation of 'Channel'</b>:
     *
     * If the meaning of "Channel" isn't clear, then there should be a description here.
     */
    uint8 getChannel() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendChannelUpdate().
     *
     * <b>Documentation of 'Channel'</b>:
     *
     * If the meaning of "Channel" isn't clear, then there should be a description here.
     */
    void sendChannelUpdate();

    // property 'Target'

    /**
     * The method onTargetGet() is called by ASF when a client invokes the
     * read method for the property 'Target'. The onTargetGet() method returns
     * by default the current property value to the caller. In case this
     * default behavior doesn't match your needs feel free to override this
     * method.
     *
     * <b>Documentation of 'Target'</b>:
     *
     * If the meaning of "Target" isn't clear, then there should be a description here.
     */
    virtual void onTargetGet(const ::boost::shared_ptr< TargetGet >& payload);

    /**
     * Sends back the update to a previous onTargetGet().
     *
     * <b>Documentation of 'Target'</b>:
     *
     * If the meaning of "Target" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onTargetGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendTargetGetUpdate(const ::std::string& target, act_t act = 0);

    /**
     * Set the value of the property 'Target' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'Target'</b>:
     *
     * If the meaning of "Target" isn't clear, then there should be a description here.
     */
    void setTarget(const ::std::string& target);

    /**
     * Returns the current value of the property 'Target'.
     *
     * <b>Documentation of 'Target'</b>:
     *
     * If the meaning of "Target" isn't clear, then there should be a description here.
     */
    const ::std::string& getTarget() const;

    /**
     * Returns the current value of the property 'Target' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendTargetUpdate() method.
     *
     * <b>Documentation of 'Target'</b>:
     *
     * If the meaning of "Target" isn't clear, then there should be a description here.
     */
    ::std::string& getTargetMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendTargetUpdate().
     *
     * <b>Documentation of 'Target'</b>:
     *
     * If the meaning of "Target" isn't clear, then there should be a description here.
     */
    void sendTargetUpdate();

    // property 'InstanceID'

    /**
     * The method onInstanceIDGet() is called by ASF when a client invokes the
     * read method for the property 'InstanceID'. The onInstanceIDGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'InstanceID'</b>:
     *
     * If the meaning of "InstanceID" isn't clear, then there should be a description here.
     */
    virtual void onInstanceIDGet(const ::boost::shared_ptr< InstanceIDGet >& payload);

    /**
     * Sends back the update to a previous onInstanceIDGet().
     *
     * <b>Documentation of 'InstanceID'</b>:
     *
     * If the meaning of "InstanceID" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onInstanceIDGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendInstanceIDGetUpdate(int32 instanceID, act_t act = 0);

    /**
     * Set the value of the property 'InstanceID' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'InstanceID'</b>:
     *
     * If the meaning of "InstanceID" isn't clear, then there should be a description here.
     */
    void setInstanceID(int32 instanceID);

    /**
     * Returns the current value of the property 'InstanceID'.
     *
     * <b>Documentation of 'InstanceID'</b>:
     *
     * If the meaning of "InstanceID" isn't clear, then there should be a description here.
     */
    int32 getInstanceID() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendInstanceIDUpdate().
     *
     * <b>Documentation of 'InstanceID'</b>:
     *
     * If the meaning of "InstanceID" isn't clear, then there should be a description here.
     */
    void sendInstanceIDUpdate();

private:
    void onGetAll(std::map<std::basic_string<char>, ::asf::dbus::DBusVariant>&) const;

    SourceUpdate _SourceProperty;

    DestinationUpdate _DestinationProperty;

    ChannelUpdate _ChannelProperty;

    TargetUpdate _TargetProperty;

    InstanceIDUpdate _InstanceIDProperty;

    friend class SessionStubDelegate;

    DECLARE_CLASS_LOGGER();
};

} // namespace Session
} // namespace obex
} // namespace bluez
} // namespace org

#endif // ORG_BLUEZ_OBEX_SESSIONSTUB_H
