/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "org/bluez/obex/Session.h"
#include "org/bluez/obex/SessionDBus.h"
#include "org/bluez/obex/SessionJson.h"
#include "org/bluez/obex/SessionStub.h"
#include <string>

#include "asf/dbus/DBusMessage.h"

namespace org {
namespace bluez {
namespace obex {
namespace Session {

DEFINE_CLASS_LOGGER("//org/bluez/obex/client/session/created/during/runtime/org/bluez/obex/Session", SessionStub);


static ::asf::dbus::DBusUtils::stringEntry propertiesTable[] = {
    { 6, "Source", 0 },
    { 6, "Target", 3 },
    { 7, "Channel", 2 },
    { 10, "InstanceID", 4 },
    { 11, "Destination", 1 },
};

class SessionStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    SessionStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    SessionStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    SessionStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "org.bluez.obex.Session"),
          _logger(logger) {}

    virtual ~SessionStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void SessionStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* SessionStubDelegate::introspect() const {
    return     "<interface name=\"org.bluez.obex.Session\">\n"
            "      <property access=\"read\" name=\"Source\" type=\"s\"/>\n"
            "      <property access=\"read\" name=\"Destination\" type=\"s\"/>\n"
            "      <property access=\"read\" name=\"Channel\" type=\"y\"/>\n"
            "      <property access=\"read\" name=\"Target\" type=\"s\"/>\n"
            "      <property access=\"read\" name=\"InstanceID\" type=\"i\"/>\n"
            "</interface>\n";
}

void SessionStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<SessionStub*>(getStub()))->onGetAll (properties);
}

void SessionStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 5, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "Source");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 1: {
            LOG_DEBUG_STUB("process property '%s'", "Destination");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 2: {
            LOG_DEBUG_STUB("process property '%s'", "Channel");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 3: {
            LOG_DEBUG_STUB("process property '%s'", "Target");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 4: {
            LOG_DEBUG_STUB("process property '%s'", "InstanceID");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void SessionStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 5, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "Source");
            ::boost::shared_ptr< SourceGet > payload(new SourceGet());
            payload->setAct(act);
            static_cast<SessionStub*>(getStub())->onSourceGet (payload);
            return;
        }
        case 1: {
            LOG_DEBUG_STUB("process property '%s'", "Destination");
            ::boost::shared_ptr< DestinationGet > payload(new DestinationGet());
            payload->setAct(act);
            static_cast<SessionStub*>(getStub())->onDestinationGet (payload);
            return;
        }
        case 2: {
            LOG_DEBUG_STUB("process property '%s'", "Channel");
            ::boost::shared_ptr< ChannelGet > payload(new ChannelGet());
            payload->setAct(act);
            static_cast<SessionStub*>(getStub())->onChannelGet (payload);
            return;
        }
        case 3: {
            LOG_DEBUG_STUB("process property '%s'", "Target");
            ::boost::shared_ptr< TargetGet > payload(new TargetGet());
            payload->setAct(act);
            static_cast<SessionStub*>(getStub())->onTargetGet (payload);
            return;
        }
        case 4: {
            LOG_DEBUG_STUB("process property '%s'", "InstanceID");
            ::boost::shared_ptr< InstanceIDGet > payload(new InstanceIDGet());
            payload->setAct(act);
            static_cast<SessionStub*>(getStub())->onInstanceIDGet (payload);
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

SessionStub::SessionStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new SessionStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

SessionStub::SessionStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new SessionStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

SessionStub::~SessionStub() {
    delete _stubDelegate;
}

void SessionStub::sendSourceUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        SourceUpdate payload(_SourceProperty);

        LOG_INFO ("-> send%s", "SourceUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Source", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bluez.obex.Session", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "SourceUpdate");
    }
}

void SessionStub::onSourceGet(const ::boost::shared_ptr< SourceGet >& source) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "SourceGet", source->getAct());
    sendSourceGetUpdate(_SourceProperty.getSource(), source->getAct());
}

void SessionStub::sendSourceGetUpdate(const ::std::string& source, act_t act) {
    ::asf::dbus::DBusVariant variant;
    SourceGet payload(source);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "SourceGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void SessionStub::setSource(const ::std::string& source) {
    if(source!=_SourceProperty.getSource()) {
        _SourceProperty.setSource(source);
        sendSourceUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& SessionStub::getSource() const {
    return _SourceProperty.getSource();
}

::std::string& SessionStub::getSourceMutable() {
    return _SourceProperty.getSourceMutable();
}

void SessionStub::sendDestinationUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        DestinationUpdate payload(_DestinationProperty);

        LOG_INFO ("-> send%s", "DestinationUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Destination", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bluez.obex.Session", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "DestinationUpdate");
    }
}

void SessionStub::onDestinationGet(const ::boost::shared_ptr< DestinationGet >& destination) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "DestinationGet", destination->getAct());
    sendDestinationGetUpdate(_DestinationProperty.getDestination(), destination->getAct());
}

void SessionStub::sendDestinationGetUpdate(const ::std::string& destination, act_t act) {
    ::asf::dbus::DBusVariant variant;
    DestinationGet payload(destination);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "DestinationGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void SessionStub::setDestination(const ::std::string& destination) {
    if(destination!=_DestinationProperty.getDestination()) {
        _DestinationProperty.setDestination(destination);
        sendDestinationUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& SessionStub::getDestination() const {
    return _DestinationProperty.getDestination();
}

::std::string& SessionStub::getDestinationMutable() {
    return _DestinationProperty.getDestinationMutable();
}

void SessionStub::sendChannelUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        ChannelUpdate payload(_ChannelProperty);

        LOG_INFO ("-> send%s", "ChannelUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Channel", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bluez.obex.Session", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "ChannelUpdate");
    }
}

void SessionStub::onChannelGet(const ::boost::shared_ptr< ChannelGet >& channel) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ChannelGet", channel->getAct());
    sendChannelGetUpdate(_ChannelProperty.getChannel(), channel->getAct());
}

void SessionStub::sendChannelGetUpdate(uint8 channel, act_t act) {
    ::asf::dbus::DBusVariant variant;
    ChannelGet payload(channel);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ChannelGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void SessionStub::setChannel(uint8 channel) {
    if(channel!=_ChannelProperty.getChannel()) {
        _ChannelProperty.setChannel(channel);
        sendChannelUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint8 SessionStub::getChannel() const {
    return _ChannelProperty.getChannel();
}

void SessionStub::sendTargetUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        TargetUpdate payload(_TargetProperty);

        LOG_INFO ("-> send%s", "TargetUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Target", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bluez.obex.Session", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "TargetUpdate");
    }
}

void SessionStub::onTargetGet(const ::boost::shared_ptr< TargetGet >& target) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "TargetGet", target->getAct());
    sendTargetGetUpdate(_TargetProperty.getTarget(), target->getAct());
}

void SessionStub::sendTargetGetUpdate(const ::std::string& target, act_t act) {
    ::asf::dbus::DBusVariant variant;
    TargetGet payload(target);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "TargetGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void SessionStub::setTarget(const ::std::string& target) {
    if(target!=_TargetProperty.getTarget()) {
        _TargetProperty.setTarget(target);
        sendTargetUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& SessionStub::getTarget() const {
    return _TargetProperty.getTarget();
}

::std::string& SessionStub::getTargetMutable() {
    return _TargetProperty.getTargetMutable();
}

void SessionStub::sendInstanceIDUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        InstanceIDUpdate payload(_InstanceIDProperty);

        LOG_INFO ("-> send%s", "InstanceIDUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("InstanceID", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bluez.obex.Session", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "InstanceIDUpdate");
    }
}

void SessionStub::onInstanceIDGet(const ::boost::shared_ptr< InstanceIDGet >& instanceID) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "InstanceIDGet", instanceID->getAct());
    sendInstanceIDGetUpdate(_InstanceIDProperty.getInstanceID(), instanceID->getAct());
}

void SessionStub::sendInstanceIDGetUpdate(int32 instanceID, act_t act) {
    ::asf::dbus::DBusVariant variant;
    InstanceIDGet payload(instanceID);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "InstanceIDGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void SessionStub::setInstanceID(int32 instanceID) {
    if(instanceID!=_InstanceIDProperty.getInstanceID()) {
        _InstanceIDProperty.setInstanceID(instanceID);
        sendInstanceIDUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

int32 SessionStub::getInstanceID() const {
    return _InstanceIDProperty.getInstanceID();
}

void SessionStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {

    //property 'Source'
    {
        ::asf::dbus::DBusVariant variant;
        SourceGet payload(_SourceProperty.getSource());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Source", variant));
    }

    //property 'Destination'
    {
        ::asf::dbus::DBusVariant variant;
        DestinationGet payload(_DestinationProperty.getDestination());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Destination", variant));
    }

    //property 'Channel'
    {
        ::asf::dbus::DBusVariant variant;
        ChannelGet payload(_ChannelProperty.getChannel());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Channel", variant));
    }

    //property 'Target'
    {
        ::asf::dbus::DBusVariant variant;
        TargetGet payload(_TargetProperty.getTarget());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Target", variant));
    }

    //property 'InstanceID'
    {
        ::asf::dbus::DBusVariant variant;
        InstanceIDGet payload(_InstanceIDProperty.getInstanceID());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("InstanceID", variant));
    }
}

} // namespace Session
} // namespace obex
} // namespace bluez
} // namespace org
