/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "boost/shared_ptr.hpp"
#include "org/bluez/obex/Session.h"
#include "org/bluez/obex/SessionDBus.h"
#include "org/bluez/obex/SessionJson.h"
#include "org/bluez/obex/SessionProxy.h"
#include <string>

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace org {
namespace bluez {
namespace obex {
namespace Session {

DEFINE_CLASS_LOGGER("//org/bluez/obex/client/session/created/during/runtime/org/bluez/obex/Session", SessionProxy);

class SessionProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    SessionProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< SessionProxy >& proxyShared = ::boost::static_pointer_cast< SessionProxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_Source:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SourceError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Source", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SourceError> payload = ::boost::static_pointer_cast<SourceError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((SourceCallbackIF*) _callback)->onSourceError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SourceUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Source", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SourceUpdate> payload = ::boost::static_pointer_cast<SourceUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((SourceCallbackIF*) _callback)->onSourceUpdate(proxyShared, payload);
                        proxyShared->_source = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_Destination:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DestinationError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Destination", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DestinationError> payload = ::boost::static_pointer_cast<DestinationError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((DestinationCallbackIF*) _callback)->onDestinationError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DestinationUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Destination", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DestinationUpdate> payload = ::boost::static_pointer_cast<DestinationUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((DestinationCallbackIF*) _callback)->onDestinationUpdate(proxyShared, payload);
                        proxyShared->_destination = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_Channel:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ChannelError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Channel", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ChannelError> payload = ::boost::static_pointer_cast<ChannelError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((ChannelCallbackIF*) _callback)->onChannelError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ChannelUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Channel", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ChannelUpdate> payload = ::boost::static_pointer_cast<ChannelUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((ChannelCallbackIF*) _callback)->onChannelUpdate(proxyShared, payload);
                        proxyShared->_channel = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_Target:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), TargetError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Target", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<TargetError> payload = ::boost::static_pointer_cast<TargetError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((TargetCallbackIF*) _callback)->onTargetError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), TargetUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Target", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<TargetUpdate> payload = ::boost::static_pointer_cast<TargetUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((TargetCallbackIF*) _callback)->onTargetUpdate(proxyShared, payload);
                        proxyShared->_target = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_InstanceID:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), InstanceIDError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "InstanceID", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<InstanceIDError> payload = ::boost::static_pointer_cast<InstanceIDError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((InstanceIDCallbackIF*) _callback)->onInstanceIDError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), InstanceIDUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "InstanceID", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<InstanceIDUpdate> payload = ::boost::static_pointer_cast<InstanceIDUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((InstanceIDCallbackIF*) _callback)->onInstanceIDUpdate(proxyShared, payload);
                        proxyShared->_instanceID = *payload.get();
                        return true;
                    }
                }
                break;
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_Source: {
                ::boost::shared_ptr< SourceError > payload = ::boost::shared_ptr< SourceError >
                (new SourceError(DBUS_ERROR_NO_SERVER, "The DBus service Session is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Source", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SessionProxy> proxyShared = ::boost::static_pointer_cast<SessionProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SourceCallbackIF*) _callback)->onSourceError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Destination: {
                ::boost::shared_ptr< DestinationError > payload = ::boost::shared_ptr< DestinationError >
                (new DestinationError(DBUS_ERROR_NO_SERVER, "The DBus service Session is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Destination", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SessionProxy> proxyShared = ::boost::static_pointer_cast<SessionProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((DestinationCallbackIF*) _callback)->onDestinationError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Channel: {
                ::boost::shared_ptr< ChannelError > payload = ::boost::shared_ptr< ChannelError >
                (new ChannelError(DBUS_ERROR_NO_SERVER, "The DBus service Session is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Channel", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SessionProxy> proxyShared = ::boost::static_pointer_cast<SessionProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ChannelCallbackIF*) _callback)->onChannelError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Target: {
                ::boost::shared_ptr< TargetError > payload = ::boost::shared_ptr< TargetError >
                (new TargetError(DBUS_ERROR_NO_SERVER, "The DBus service Session is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Target", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SessionProxy> proxyShared = ::boost::static_pointer_cast<SessionProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((TargetCallbackIF*) _callback)->onTargetError (proxyShared,payload);
                return true;
            }
            break;
            case ID_InstanceID: {
                ::boost::shared_ptr< InstanceIDError > payload = ::boost::shared_ptr< InstanceIDError >
                (new InstanceIDError(DBUS_ERROR_NO_SERVER, "The DBus service Session is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "InstanceID", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SessionProxy> proxyShared = ::boost::static_pointer_cast<SessionProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((InstanceIDCallbackIF*) _callback)->onInstanceIDError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& SessionProxyCallback::_logger (SessionProxy::_logger);

SessionProxy::SessionProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "org.bluez.obex.Session", serviceAvailable, _logger) {
}

SessionProxy::~SessionProxy()
{
    sendDeregisterAll();
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< SessionProxy > SessionProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<SessionProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< SessionProxy > proxyNew(new SessionProxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(true);
    return proxyNew;
}

act_t SessionProxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    SessionProxyCallback* callback = new SessionProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t SessionProxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    SessionProxyCallback* callback = new SessionProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void SessionProxy::clearAllProperties ()
{
    _source = ::asf::core::nullable< SourceUpdate >();
    _destination = ::asf::core::nullable< DestinationUpdate >();
    _channel = ::asf::core::nullable< ChannelUpdate >();
    _target = ::asf::core::nullable< TargetUpdate >();
    _instanceID = ::asf::core::nullable< InstanceIDUpdate >();
}

void SessionProxy::sendDeregisterAll () const
{
    sendSourceDeregisterAll();
    sendDestinationDeregisterAll();
    sendChannelDeregisterAll();
    sendTargetDeregisterAll();
    sendInstanceIDDeregisterAll();
}

act_t SessionProxy::sendSourceRegister(SourceCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_Source, "Source", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Source", &cb, act);
    return act;
}

bool SessionProxy::sendSourceDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("Source", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Source", act, static_cast<int>(rv));
    return rv;
}

act_t SessionProxy::sendSourceGet(SourceCallbackIF& cb) {
    SessionProxyCallback* callback = new SessionProxyCallback(ID_Source, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "Source", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("Source", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::string& SessionProxy::getSource() const {
    return _source.get().getSource();
}

bool SessionProxy::hasSource() const {
    return _source.hasValue();
}

void SessionProxy::sendSourceDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Source");
    _dbusProxyDelegate->deregisterSignalCallback("Source", 0, _dbusDaemonProxy.get(), true);
}

act_t SessionProxy::sendDestinationRegister(DestinationCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_Destination, "Destination", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Destination", &cb, act);
    return act;
}

bool SessionProxy::sendDestinationDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("Destination", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Destination", act, static_cast<int>(rv));
    return rv;
}

act_t SessionProxy::sendDestinationGet(DestinationCallbackIF& cb) {
    SessionProxyCallback* callback = new SessionProxyCallback(ID_Destination, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "Destination", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("Destination", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::string& SessionProxy::getDestination() const {
    return _destination.get().getDestination();
}

bool SessionProxy::hasDestination() const {
    return _destination.hasValue();
}

void SessionProxy::sendDestinationDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Destination");
    _dbusProxyDelegate->deregisterSignalCallback("Destination", 0, _dbusDaemonProxy.get(), true);
}

act_t SessionProxy::sendChannelRegister(ChannelCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_Channel, "Channel", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Channel", &cb, act);
    return act;
}

bool SessionProxy::sendChannelDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("Channel", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Channel", act, static_cast<int>(rv));
    return rv;
}

act_t SessionProxy::sendChannelGet(ChannelCallbackIF& cb) {
    SessionProxyCallback* callback = new SessionProxyCallback(ID_Channel, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "Channel", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("Channel", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint8 SessionProxy::getChannel() const {
    return _channel.get().getChannel();
}

bool SessionProxy::hasChannel() const {
    return _channel.hasValue();
}

void SessionProxy::sendChannelDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Channel");
    _dbusProxyDelegate->deregisterSignalCallback("Channel", 0, _dbusDaemonProxy.get(), true);
}

act_t SessionProxy::sendTargetRegister(TargetCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_Target, "Target", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Target", &cb, act);
    return act;
}

bool SessionProxy::sendTargetDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("Target", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Target", act, static_cast<int>(rv));
    return rv;
}

act_t SessionProxy::sendTargetGet(TargetCallbackIF& cb) {
    SessionProxyCallback* callback = new SessionProxyCallback(ID_Target, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "Target", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("Target", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::string& SessionProxy::getTarget() const {
    return _target.get().getTarget();
}

bool SessionProxy::hasTarget() const {
    return _target.hasValue();
}

void SessionProxy::sendTargetDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Target");
    _dbusProxyDelegate->deregisterSignalCallback("Target", 0, _dbusDaemonProxy.get(), true);
}

act_t SessionProxy::sendInstanceIDRegister(InstanceIDCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_InstanceID, "InstanceID", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "InstanceID", &cb, act);
    return act;
}

bool SessionProxy::sendInstanceIDDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("InstanceID", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "InstanceID", act, static_cast<int>(rv));
    return rv;
}

act_t SessionProxy::sendInstanceIDGet(InstanceIDCallbackIF& cb) {
    SessionProxyCallback* callback = new SessionProxyCallback(ID_InstanceID, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "InstanceID", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("InstanceID", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


int32 SessionProxy::getInstanceID() const {
    return _instanceID.get().getInstanceID();
}

bool SessionProxy::hasInstanceID() const {
    return _instanceID.hasValue();
}

void SessionProxy::sendInstanceIDDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "InstanceID");
    _dbusProxyDelegate->deregisterSignalCallback("InstanceID", 0, _dbusDaemonProxy.get(), true);
}

} // namespace Session
} // namespace obex
} // namespace bluez
} // namespace org
