/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusVariant.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "org/bluez/obex/PhonebookAccess.h"
#include "org/bluez/obex/PhonebookAccessDBus.h"
#include "org/bluez/obex/PhonebookAccessJson.h"
#include "org/bluez/obex/PhonebookAccessProxy.h"
#include <map>
#include <string>

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace org {
namespace bluez {
namespace obex {
namespace PhonebookAccess {

DEFINE_CLASS_LOGGER("//org/bluez/obex/client/session/created/during/runtime/org/bluez/obex/PhonebookAccess", PhonebookAccessProxy);

class PhonebookAccessProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    PhonebookAccessProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< PhonebookAccessProxy >& proxyShared = ::boost::static_pointer_cast< PhonebookAccessProxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_Select:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), SelectError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "Select", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SelectError> payload = ::boost::static_pointer_cast<SelectError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SelectCallbackIF*) _callback)->onSelectError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SelectResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "Select", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SelectResponse> payload = ::boost::static_pointer_cast<SelectResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SelectCallbackIF*) _callback)->onSelectResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_PullAll:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), PullAllError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "PullAll", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<PullAllError> payload = ::boost::static_pointer_cast<PullAllError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((PullAllCallbackIF*) _callback)->onPullAllError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), PullAllResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "PullAll", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<PullAllResponse> payload = ::boost::static_pointer_cast<PullAllResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((PullAllCallbackIF*) _callback)->onPullAllResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_Pull:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), PullError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "Pull", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<PullError> payload = ::boost::static_pointer_cast<PullError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((PullCallbackIF*) _callback)->onPullError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), PullResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "Pull", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<PullResponse> payload = ::boost::static_pointer_cast<PullResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((PullCallbackIF*) _callback)->onPullResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_List:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), ListError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "List", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ListError> payload = ::boost::static_pointer_cast<ListError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ListCallbackIF*) _callback)->onListError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ListResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "List", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ListResponse> payload = ::boost::static_pointer_cast<ListResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ListCallbackIF*) _callback)->onListResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_GetSize:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), GetSizeError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetSize", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetSizeError> payload = ::boost::static_pointer_cast<GetSizeError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetSizeCallbackIF*) _callback)->onGetSizeError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetSizeResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetSize", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetSizeResponse> payload = ::boost::static_pointer_cast<GetSizeResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetSizeCallbackIF*) _callback)->onGetSizeResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_ListFilterFields:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), ListFilterFieldsError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ListFilterFields", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ListFilterFieldsError> payload = ::boost::static_pointer_cast<ListFilterFieldsError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ListFilterFieldsCallbackIF*) _callback)->onListFilterFieldsError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ListFilterFieldsResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "ListFilterFields", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ListFilterFieldsResponse> payload = ::boost::static_pointer_cast<ListFilterFieldsResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ListFilterFieldsCallbackIF*) _callback)->onListFilterFieldsResponse (proxyShared, payload);
                        return true;
                    }
                }
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_Select: {
                ::boost::shared_ptr< SelectError > payload = ::boost::shared_ptr< SelectError >
                (new SelectError(DBUS_ERROR_NO_SERVER, "The DBus service PhonebookAccess is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Select", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<PhonebookAccessProxy> proxyShared = ::boost::static_pointer_cast<PhonebookAccessProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SelectCallbackIF*) _callback)->onSelectError (proxyShared,payload);
                return true;
            }
            break;
            case ID_PullAll: {
                ::boost::shared_ptr< PullAllError > payload = ::boost::shared_ptr< PullAllError >
                (new PullAllError(DBUS_ERROR_NO_SERVER, "The DBus service PhonebookAccess is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "PullAll", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<PhonebookAccessProxy> proxyShared = ::boost::static_pointer_cast<PhonebookAccessProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((PullAllCallbackIF*) _callback)->onPullAllError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Pull: {
                ::boost::shared_ptr< PullError > payload = ::boost::shared_ptr< PullError >
                (new PullError(DBUS_ERROR_NO_SERVER, "The DBus service PhonebookAccess is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Pull", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<PhonebookAccessProxy> proxyShared = ::boost::static_pointer_cast<PhonebookAccessProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((PullCallbackIF*) _callback)->onPullError (proxyShared,payload);
                return true;
            }
            break;
            case ID_List: {
                ::boost::shared_ptr< ListError > payload = ::boost::shared_ptr< ListError >
                (new ListError(DBUS_ERROR_NO_SERVER, "The DBus service PhonebookAccess is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "List", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<PhonebookAccessProxy> proxyShared = ::boost::static_pointer_cast<PhonebookAccessProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ListCallbackIF*) _callback)->onListError (proxyShared,payload);
                return true;
            }
            break;
            case ID_GetSize: {
                ::boost::shared_ptr< GetSizeError > payload = ::boost::shared_ptr< GetSizeError >
                (new GetSizeError(DBUS_ERROR_NO_SERVER, "The DBus service PhonebookAccess is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "GetSize", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<PhonebookAccessProxy> proxyShared = ::boost::static_pointer_cast<PhonebookAccessProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((GetSizeCallbackIF*) _callback)->onGetSizeError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ListFilterFields: {
                ::boost::shared_ptr< ListFilterFieldsError > payload = ::boost::shared_ptr< ListFilterFieldsError >
                (new ListFilterFieldsError(DBUS_ERROR_NO_SERVER, "The DBus service PhonebookAccess is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ListFilterFields", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<PhonebookAccessProxy> proxyShared = ::boost::static_pointer_cast<PhonebookAccessProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ListFilterFieldsCallbackIF*) _callback)->onListFilterFieldsError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& PhonebookAccessProxyCallback::_logger (PhonebookAccessProxy::_logger);

PhonebookAccessProxy::PhonebookAccessProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "org.bluez.obex.PhonebookAccess", serviceAvailable, _logger) {
}

PhonebookAccessProxy::~PhonebookAccessProxy()
{
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< PhonebookAccessProxy > PhonebookAccessProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<PhonebookAccessProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< PhonebookAccessProxy > proxyNew(new PhonebookAccessProxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(false);
    return proxyNew;
}

act_t PhonebookAccessProxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    PhonebookAccessProxyCallback* callback = new PhonebookAccessProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t PhonebookAccessProxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    PhonebookAccessProxyCallback* callback = new PhonebookAccessProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}



act_t PhonebookAccessProxy::sendSelectRequest(SelectCallbackIF& cb, const ::std::string& location, const ::std::string& phonebook) const {
    SelectRequest* payload = new SelectRequest();
    CHECK_ALLOCATION(payload);
    payload->setLocation(location);
    payload->setPhonebook(phonebook);
    DBUS_MESSAGE_CALL(dbusMessage, "Select", SelectRequest, payload, true)
    act_t act = addMethodCallback(ID_Select, dbusMessage.getUniqueSerial(), "Select", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "Select", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t PhonebookAccessProxy::sendPullAllRequest(PullAllCallbackIF& cb, const ::std::string& targetfile, const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& filter) const {
    PullAllRequest* payload = new PullAllRequest();
    CHECK_ALLOCATION(payload);
    payload->setTargetfile(targetfile);
    payload->setFilter(filter);
    DBUS_MESSAGE_CALL(dbusMessage, "PullAll", PullAllRequest, payload, true)
    act_t act = addMethodCallback(ID_PullAll, dbusMessage.getUniqueSerial(), "PullAll", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "PullAll", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t PhonebookAccessProxy::sendPullRequest(PullCallbackIF& cb, const ::std::string& vcard, const ::std::string& targetfile, const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& filter) const {
    PullRequest* payload = new PullRequest();
    CHECK_ALLOCATION(payload);
    payload->setVcard(vcard);
    payload->setTargetfile(targetfile);
    payload->setFilter(filter);
    DBUS_MESSAGE_CALL(dbusMessage, "Pull", PullRequest, payload, true)
    act_t act = addMethodCallback(ID_Pull, dbusMessage.getUniqueSerial(), "Pull", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "Pull", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t PhonebookAccessProxy::sendListRequest(ListCallbackIF& cb, const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& filter) const {
    ListRequest* payload = new ListRequest();
    CHECK_ALLOCATION(payload);
    payload->setFilter(filter);
    DBUS_MESSAGE_CALL(dbusMessage, "List", ListRequest, payload, true)
    act_t act = addMethodCallback(ID_List, dbusMessage.getUniqueSerial(), "List", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "List", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t PhonebookAccessProxy::sendGetSizeRequest(GetSizeCallbackIF& cb) const {
    GetSizeRequest* payload = new GetSizeRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "GetSize", GetSizeRequest, payload, true)
    act_t act = addMethodCallback(ID_GetSize, dbusMessage.getUniqueSerial(), "GetSize", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "GetSize", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t PhonebookAccessProxy::sendListFilterFieldsRequest(ListFilterFieldsCallbackIF& cb) const {
    ListFilterFieldsRequest* payload = new ListFilterFieldsRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "ListFilterFields", ListFilterFieldsRequest, payload, true)
    act_t act = addMethodCallback(ID_ListFilterFields, dbusMessage.getUniqueSerial(), "ListFilterFields", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "ListFilterFields", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

} // namespace PhonebookAccess
} // namespace obex
} // namespace bluez
} // namespace org
