#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_BLUEZ_OBEX_PHONEBOOKACCESS_H
#define ORG_BLUEZ_OBEX_PHONEBOOKACCESS_H

#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "asf/dbus/DBusTypes.h"
#include "asf/dbus/DBusVariant.h"
#include <cstddef>
#include <cstring>
#include <map>
#include <string>
#include <vector>

/**
 * If the meaning of "PhonebookAccess" isn't clear, then there should be a description here.
 */

namespace org {
namespace bluez {
namespace obex {
namespace PhonebookAccess {

// method IDs
static const uint16 ID_Select = 0;
static const uint16 ID_PullAll = 1;
static const uint16 ID_Pull = 2;
static const uint16 ID_List = 3;
static const uint16 ID_GetSize = 4;
static const uint16 ID_ListFilterFields = 5;

// signal IDs

// property IDs

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class SelectRequest;

class PullAllRequest;

class PullAllResponse;

class PullRequest;

class PullResponse;

class ListRequest;

class ListResponseVcard_listingStruct;

class ListResponse;

class GetSizeResponse;

class ListFilterFieldsResponse;

// type definitions
/**
 * If the meaning of "SelectResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage SelectResponse;

/**
 * If the meaning of "SelectError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SelectError;

/**
 * If the meaning of "PullAllError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError PullAllError;

/**
 * If the meaning of "PullError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError PullError;

/**
 * If the meaning of "ListError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ListError;

/**
 * If the meaning of "GetSizeRequest" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage GetSizeRequest;

/**
 * If the meaning of "GetSizeError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError GetSizeError;

/**
 * If the meaning of "ListFilterFieldsRequest" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage ListFilterFieldsRequest;

/**
 * If the meaning of "ListFilterFieldsError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ListFilterFieldsError;


/**
 * If the meaning of "SelectRequest" isn't clear, then there should be a description here.
 */
class SelectRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SelectRequest ();

    /**
     * Copy constructor
     */
    inline  SelectRequest (const SelectRequest &rhs);

    /**
     * All fields constructor
     */
    inline  SelectRequest (const ::std::string& location_, const ::std::string& phonebook_);

    /**
     * Destructor
     */
    inline virtual  ~SelectRequest();

    /**
     * Assignment operator
     */
    inline SelectRequest& operator = (const SelectRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SelectRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SelectRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SelectRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SelectRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "location"

    static const int kLocation = 0;

    /**
     * Clears the field "location".
     *
     * The field will be set to its default value. The hasLocation()
     * method will return false.
     */
    inline void clearLocation();

    /**
     * Checks whether the field "location" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLocation()). Otherwise it will return false.
     */
    inline bool hasLocation () const;

    /**
     * Returns the value of the member "location".
     *
     * If the meaning of "location" isn't clear, then there should be a description here.
     *
     * @return The value of the field "location"
     */
    inline const ::std::string& getLocation () const;

    /**
     * Retrieves the value of the field "location" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "location".
     */
    inline ::std::string& getLocationMutable ();

    /**
     * Sets the value of the member "location".
     *
     * If the meaning of "location" isn't clear, then there should be a description here.
     *
     * @param location The value which will be set
     */
    inline void setLocation (const ::std::string& location_);

    /**
     * Sets the value of the member "location".
     *
     * If the meaning of "location" isn't clear, then there should be a description here.
     *
     * @param location The value which will be set
     */
    inline void setLocation (const char* location_);

    /**
     * Sets the value of the member "location".
     *
     * If the meaning of "location" isn't clear, then there should be a description here.
     *
     * @param location The value which will be set
     */
    inline void setLocation (const char* value, size_t size);

    // API of field "phonebook"

    static const int kPhonebook = 1;

    /**
     * Clears the field "phonebook".
     *
     * The field will be set to its default value. The hasPhonebook()
     * method will return false.
     */
    inline void clearPhonebook();

    /**
     * Checks whether the field "phonebook" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPhonebook()). Otherwise it will return false.
     */
    inline bool hasPhonebook () const;

    /**
     * Returns the value of the member "phonebook".
     *
     * If the meaning of "phonebook" isn't clear, then there should be a description here.
     *
     * @return The value of the field "phonebook"
     */
    inline const ::std::string& getPhonebook () const;

    /**
     * Retrieves the value of the field "phonebook" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "phonebook".
     */
    inline ::std::string& getPhonebookMutable ();

    /**
     * Sets the value of the member "phonebook".
     *
     * If the meaning of "phonebook" isn't clear, then there should be a description here.
     *
     * @param phonebook The value which will be set
     */
    inline void setPhonebook (const ::std::string& phonebook_);

    /**
     * Sets the value of the member "phonebook".
     *
     * If the meaning of "phonebook" isn't clear, then there should be a description here.
     *
     * @param phonebook The value which will be set
     */
    inline void setPhonebook (const char* phonebook_);

    /**
     * Sets the value of the member "phonebook".
     *
     * If the meaning of "phonebook" isn't clear, then there should be a description here.
     *
     * @param phonebook The value which will be set
     */
    inline void setPhonebook (const char* value, size_t size);

    static const SelectRequest &getDefaultInstance();

private:

    inline void set_has_location ();

    inline void clear_has_location ();

    inline void set_has_phonebook ();

    inline void clear_has_phonebook ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _location;

    ::std::string _phonebook;

};

/**
 * If the meaning of "PullAllRequest" isn't clear, then there should be a description here.
 */
class PullAllRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PullAllRequest ();

    /**
     * Copy constructor
     */
    inline  PullAllRequest (const PullAllRequest &rhs);

    /**
     * All fields constructor
     */
    inline  PullAllRequest (const ::std::string& targetfile_, const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& filter_);

    /**
     * Destructor
     */
    inline virtual  ~PullAllRequest();

    /**
     * Assignment operator
     */
    inline PullAllRequest& operator = (const PullAllRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PullAllRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PullAllRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PullAllRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PullAllRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "targetfile"

    static const int kTargetfile = 0;

    /**
     * Clears the field "targetfile".
     *
     * The field will be set to its default value. The hasTargetfile()
     * method will return false.
     */
    inline void clearTargetfile();

    /**
     * Checks whether the field "targetfile" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTargetfile()). Otherwise it will return false.
     */
    inline bool hasTargetfile () const;

    /**
     * Returns the value of the member "targetfile".
     *
     * If the meaning of "targetfile" isn't clear, then there should be a description here.
     *
     * @return The value of the field "targetfile"
     */
    inline const ::std::string& getTargetfile () const;

    /**
     * Retrieves the value of the field "targetfile" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "targetfile".
     */
    inline ::std::string& getTargetfileMutable ();

    /**
     * Sets the value of the member "targetfile".
     *
     * If the meaning of "targetfile" isn't clear, then there should be a description here.
     *
     * @param targetfile The value which will be set
     */
    inline void setTargetfile (const ::std::string& targetfile_);

    /**
     * Sets the value of the member "targetfile".
     *
     * If the meaning of "targetfile" isn't clear, then there should be a description here.
     *
     * @param targetfile The value which will be set
     */
    inline void setTargetfile (const char* targetfile_);

    /**
     * Sets the value of the member "targetfile".
     *
     * If the meaning of "targetfile" isn't clear, then there should be a description here.
     *
     * @param targetfile The value which will be set
     */
    inline void setTargetfile (const char* value, size_t size);

    // API of field "filter"

    static const int kFilter = 1;

    /**
     * Clears the field "filter".
     *
     * The field will be set to its default value. The hasFilter()
     * method will return false.
     */
    inline void clearFilter();

    /**
     * Checks whether the field "filter" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFilter()). Otherwise it will return false.
     */
    inline bool hasFilter () const;

    /**
     * Returns the value of the member "filter".
     *
     * If the meaning of "filter" isn't clear, then there should be a description here.
     *
     * @return The value of the field "filter"
     */
    inline const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getFilter () const;

    /**
     * Retrieves the value of the field "filter" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "filter".
     */
    inline ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getFilterMutable ();

    /**
     * Sets the value of the member "filter".
     *
     * If the meaning of "filter" isn't clear, then there should be a description here.
     *
     * @param filter The value which will be set
     */
    inline void setFilter (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& filter_);

    static const PullAllRequest &getDefaultInstance();

private:

    static const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getStringTo__asf__dbus__DBusVariantMap_DefaultInstance ();

    inline void set_has_targetfile ();

    inline void clear_has_targetfile ();

    inline void set_has_filter ();

    inline void clear_has_filter ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _targetfile;

    ::std::map< ::std::string, ::asf::dbus::DBusVariant > _filter;

};

/**
 * If the meaning of "PullAllResponse" isn't clear, then there should be a description here.
 */
class PullAllResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PullAllResponse ();

    /**
     * Copy constructor
     */
    inline  PullAllResponse (const PullAllResponse &rhs);

    /**
     * All fields constructor
     */
    inline  PullAllResponse (const ::std::string& transfer_);

    /**
     * Destructor
     */
    inline virtual  ~PullAllResponse();

    /**
     * Assignment operator
     */
    inline PullAllResponse& operator = (const PullAllResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PullAllResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PullAllResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PullAllResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PullAllResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "transfer"

    static const int kTransfer = 0;

    /**
     * Clears the field "transfer".
     *
     * The field will be set to its default value. The hasTransfer()
     * method will return false.
     */
    inline void clearTransfer();

    /**
     * Checks whether the field "transfer" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTransfer()). Otherwise it will return false.
     */
    inline bool hasTransfer () const;

    /**
     * Returns the value of the member "transfer".
     *
     * If the meaning of "transfer" isn't clear, then there should be a description here.
     *
     * @return The value of the field "transfer"
     */
    inline const ::std::string& getTransfer () const;

    /**
     * Retrieves the value of the field "transfer" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "transfer".
     */
    inline ::std::string& getTransferMutable ();

    /**
     * Sets the value of the member "transfer".
     *
     * If the meaning of "transfer" isn't clear, then there should be a description here.
     *
     * @param transfer The value which will be set
     */
    inline void setTransfer (const ::std::string& transfer_);

    /**
     * Sets the value of the member "transfer".
     *
     * If the meaning of "transfer" isn't clear, then there should be a description here.
     *
     * @param transfer The value which will be set
     */
    inline void setTransfer (const char* transfer_);

    /**
     * Sets the value of the member "transfer".
     *
     * If the meaning of "transfer" isn't clear, then there should be a description here.
     *
     * @param transfer The value which will be set
     */
    inline void setTransfer (const char* value, size_t size);

    static const PullAllResponse &getDefaultInstance();

private:

    inline void set_has_transfer ();

    inline void clear_has_transfer ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _transfer;

};

/**
 * If the meaning of "PullRequest" isn't clear, then there should be a description here.
 */
class PullRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PullRequest ();

    /**
     * Copy constructor
     */
    inline  PullRequest (const PullRequest &rhs);

    /**
     * All fields constructor
     */
    inline  PullRequest (const ::std::string& vcard_, const ::std::string& targetfile_, const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& filter_);

    /**
     * Destructor
     */
    inline virtual  ~PullRequest();

    /**
     * Assignment operator
     */
    inline PullRequest& operator = (const PullRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PullRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PullRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PullRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PullRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "vcard"

    static const int kVcard = 0;

    /**
     * Clears the field "vcard".
     *
     * The field will be set to its default value. The hasVcard()
     * method will return false.
     */
    inline void clearVcard();

    /**
     * Checks whether the field "vcard" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVcard()). Otherwise it will return false.
     */
    inline bool hasVcard () const;

    /**
     * Returns the value of the member "vcard".
     *
     * If the meaning of "vcard" isn't clear, then there should be a description here.
     *
     * @return The value of the field "vcard"
     */
    inline const ::std::string& getVcard () const;

    /**
     * Retrieves the value of the field "vcard" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "vcard".
     */
    inline ::std::string& getVcardMutable ();

    /**
     * Sets the value of the member "vcard".
     *
     * If the meaning of "vcard" isn't clear, then there should be a description here.
     *
     * @param vcard The value which will be set
     */
    inline void setVcard (const ::std::string& vcard_);

    /**
     * Sets the value of the member "vcard".
     *
     * If the meaning of "vcard" isn't clear, then there should be a description here.
     *
     * @param vcard The value which will be set
     */
    inline void setVcard (const char* vcard_);

    /**
     * Sets the value of the member "vcard".
     *
     * If the meaning of "vcard" isn't clear, then there should be a description here.
     *
     * @param vcard The value which will be set
     */
    inline void setVcard (const char* value, size_t size);

    // API of field "targetfile"

    static const int kTargetfile = 1;

    /**
     * Clears the field "targetfile".
     *
     * The field will be set to its default value. The hasTargetfile()
     * method will return false.
     */
    inline void clearTargetfile();

    /**
     * Checks whether the field "targetfile" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTargetfile()). Otherwise it will return false.
     */
    inline bool hasTargetfile () const;

    /**
     * Returns the value of the member "targetfile".
     *
     * If the meaning of "targetfile" isn't clear, then there should be a description here.
     *
     * @return The value of the field "targetfile"
     */
    inline const ::std::string& getTargetfile () const;

    /**
     * Retrieves the value of the field "targetfile" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "targetfile".
     */
    inline ::std::string& getTargetfileMutable ();

    /**
     * Sets the value of the member "targetfile".
     *
     * If the meaning of "targetfile" isn't clear, then there should be a description here.
     *
     * @param targetfile The value which will be set
     */
    inline void setTargetfile (const ::std::string& targetfile_);

    /**
     * Sets the value of the member "targetfile".
     *
     * If the meaning of "targetfile" isn't clear, then there should be a description here.
     *
     * @param targetfile The value which will be set
     */
    inline void setTargetfile (const char* targetfile_);

    /**
     * Sets the value of the member "targetfile".
     *
     * If the meaning of "targetfile" isn't clear, then there should be a description here.
     *
     * @param targetfile The value which will be set
     */
    inline void setTargetfile (const char* value, size_t size);

    // API of field "filter"

    static const int kFilter = 2;

    /**
     * Clears the field "filter".
     *
     * The field will be set to its default value. The hasFilter()
     * method will return false.
     */
    inline void clearFilter();

    /**
     * Checks whether the field "filter" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFilter()). Otherwise it will return false.
     */
    inline bool hasFilter () const;

    /**
     * Returns the value of the member "filter".
     *
     * If the meaning of "filter" isn't clear, then there should be a description here.
     *
     * @return The value of the field "filter"
     */
    inline const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getFilter () const;

    /**
     * Retrieves the value of the field "filter" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "filter".
     */
    inline ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getFilterMutable ();

    /**
     * Sets the value of the member "filter".
     *
     * If the meaning of "filter" isn't clear, then there should be a description here.
     *
     * @param filter The value which will be set
     */
    inline void setFilter (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& filter_);

    static const PullRequest &getDefaultInstance();

private:

    static const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getStringTo__asf__dbus__DBusVariantMap_DefaultInstance ();

    inline void set_has_vcard ();

    inline void clear_has_vcard ();

    inline void set_has_targetfile ();

    inline void clear_has_targetfile ();

    inline void set_has_filter ();

    inline void clear_has_filter ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::std::string _vcard;

    ::std::string _targetfile;

    ::std::map< ::std::string, ::asf::dbus::DBusVariant > _filter;

};

/**
 * If the meaning of "PullResponse" isn't clear, then there should be a description here.
 */
class PullResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PullResponse ();

    /**
     * Copy constructor
     */
    inline  PullResponse (const PullResponse &rhs);

    /**
     * All fields constructor
     */
    inline  PullResponse (const ::std::string& transfer_);

    /**
     * Destructor
     */
    inline virtual  ~PullResponse();

    /**
     * Assignment operator
     */
    inline PullResponse& operator = (const PullResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PullResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PullResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PullResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PullResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "transfer"

    static const int kTransfer = 0;

    /**
     * Clears the field "transfer".
     *
     * The field will be set to its default value. The hasTransfer()
     * method will return false.
     */
    inline void clearTransfer();

    /**
     * Checks whether the field "transfer" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTransfer()). Otherwise it will return false.
     */
    inline bool hasTransfer () const;

    /**
     * Returns the value of the member "transfer".
     *
     * If the meaning of "transfer" isn't clear, then there should be a description here.
     *
     * @return The value of the field "transfer"
     */
    inline const ::std::string& getTransfer () const;

    /**
     * Retrieves the value of the field "transfer" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "transfer".
     */
    inline ::std::string& getTransferMutable ();

    /**
     * Sets the value of the member "transfer".
     *
     * If the meaning of "transfer" isn't clear, then there should be a description here.
     *
     * @param transfer The value which will be set
     */
    inline void setTransfer (const ::std::string& transfer_);

    /**
     * Sets the value of the member "transfer".
     *
     * If the meaning of "transfer" isn't clear, then there should be a description here.
     *
     * @param transfer The value which will be set
     */
    inline void setTransfer (const char* transfer_);

    /**
     * Sets the value of the member "transfer".
     *
     * If the meaning of "transfer" isn't clear, then there should be a description here.
     *
     * @param transfer The value which will be set
     */
    inline void setTransfer (const char* value, size_t size);

    static const PullResponse &getDefaultInstance();

private:

    inline void set_has_transfer ();

    inline void clear_has_transfer ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _transfer;

};

/**
 * If the meaning of "ListRequest" isn't clear, then there should be a description here.
 */
class ListRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ListRequest ();

    /**
     * Copy constructor
     */
    inline  ListRequest (const ListRequest &rhs);

    /**
     * All fields constructor
     */
    inline  ListRequest (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& filter_);

    /**
     * Destructor
     */
    inline virtual  ~ListRequest();

    /**
     * Assignment operator
     */
    inline ListRequest& operator = (const ListRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ListRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ListRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ListRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ListRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "filter"

    static const int kFilter = 0;

    /**
     * Clears the field "filter".
     *
     * The field will be set to its default value. The hasFilter()
     * method will return false.
     */
    inline void clearFilter();

    /**
     * Checks whether the field "filter" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFilter()). Otherwise it will return false.
     */
    inline bool hasFilter () const;

    /**
     * Returns the value of the member "filter".
     *
     * If the meaning of "filter" isn't clear, then there should be a description here.
     *
     * @return The value of the field "filter"
     */
    inline const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getFilter () const;

    /**
     * Retrieves the value of the field "filter" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "filter".
     */
    inline ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getFilterMutable ();

    /**
     * Sets the value of the member "filter".
     *
     * If the meaning of "filter" isn't clear, then there should be a description here.
     *
     * @param filter The value which will be set
     */
    inline void setFilter (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& filter_);

    static const ListRequest &getDefaultInstance();

private:

    static const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getStringTo__asf__dbus__DBusVariantMap_DefaultInstance ();

    inline void set_has_filter ();

    inline void clear_has_filter ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::map< ::std::string, ::asf::dbus::DBusVariant > _filter;

};

/**
 * If the meaning of "ListResponseVcard_listingStruct" isn't clear, then there should be a description here.
 */
class ListResponseVcard_listingStruct {
public:

    /**
     * Default constructor
     */
    inline  ListResponseVcard_listingStruct ();

    /**
     * Copy constructor
     */
    inline  ListResponseVcard_listingStruct (const ListResponseVcard_listingStruct &rhs);

    /**
     * All fields constructor
     */
    inline  ListResponseVcard_listingStruct (const ::std::string& elem1_, const ::std::string& elem2_);

    /**
     * Destructor
     */
    inline  ~ListResponseVcard_listingStruct();

    /**
     * Assignment operator
     */
    inline ListResponseVcard_listingStruct& operator = (const ListResponseVcard_listingStruct& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ListResponseVcard_listingStruct& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ListResponseVcard_listingStruct& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ListResponseVcard_listingStruct& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ListResponseVcard_listingStruct& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "elem1"

    static const int kElem1 = 0;

    /**
     * Clears the field "elem1".
     *
     * The field will be set to its default value. The hasElem1()
     * method will return false.
     */
    inline void clearElem1();

    /**
     * Checks whether the field "elem1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem1()). Otherwise it will return false.
     */
    inline bool hasElem1 () const;

    /**
     * Returns the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem1"
     */
    inline const ::std::string& getElem1 () const;

    /**
     * Retrieves the value of the field "elem1" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "elem1".
     */
    inline ::std::string& getElem1Mutable ();

    /**
     * Sets the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @param elem1 The value which will be set
     */
    inline void setElem1 (const ::std::string& elem1_);

    /**
     * Sets the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @param elem1 The value which will be set
     */
    inline void setElem1 (const char* elem1_);

    /**
     * Sets the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @param elem1 The value which will be set
     */
    inline void setElem1 (const char* value, size_t size);

    // API of field "elem2"

    static const int kElem2 = 1;

    /**
     * Clears the field "elem2".
     *
     * The field will be set to its default value. The hasElem2()
     * method will return false.
     */
    inline void clearElem2();

    /**
     * Checks whether the field "elem2" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem2()). Otherwise it will return false.
     */
    inline bool hasElem2 () const;

    /**
     * Returns the value of the member "elem2".
     *
     * If the meaning of "elem2" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem2"
     */
    inline const ::std::string& getElem2 () const;

    /**
     * Retrieves the value of the field "elem2" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "elem2".
     */
    inline ::std::string& getElem2Mutable ();

    /**
     * Sets the value of the member "elem2".
     *
     * If the meaning of "elem2" isn't clear, then there should be a description here.
     *
     * @param elem2 The value which will be set
     */
    inline void setElem2 (const ::std::string& elem2_);

    /**
     * Sets the value of the member "elem2".
     *
     * If the meaning of "elem2" isn't clear, then there should be a description here.
     *
     * @param elem2 The value which will be set
     */
    inline void setElem2 (const char* elem2_);

    /**
     * Sets the value of the member "elem2".
     *
     * If the meaning of "elem2" isn't clear, then there should be a description here.
     *
     * @param elem2 The value which will be set
     */
    inline void setElem2 (const char* value, size_t size);

    static const ListResponseVcard_listingStruct &getDefaultInstance();

private:

    inline void set_has_elem1 ();

    inline void clear_has_elem1 ();

    inline void set_has_elem2 ();

    inline void clear_has_elem2 ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _elem1;

    ::std::string _elem2;

};

/**
 * If the meaning of "ListResponse" isn't clear, then there should be a description here.
 */
class ListResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ListResponse ();

    /**
     * Copy constructor
     */
    inline  ListResponse (const ListResponse &rhs);

    /**
     * All fields constructor
     */
    inline  ListResponse (const ::std::vector< ListResponseVcard_listingStruct >& vcard_listing_);

    /**
     * Destructor
     */
    inline virtual  ~ListResponse();

    /**
     * Assignment operator
     */
    inline ListResponse& operator = (const ListResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ListResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ListResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ListResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ListResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "vcard_listing"

    static const int kVcard_listing = 0;

    /**
     * Clears the field "vcard_listing".
     *
     * The field will be set to its default value. The hasVcard_listing()
     * method will return false.
     */
    inline void clearVcard_listing();

    /**
     * Checks whether the field "vcard_listing" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVcard_listing()). Otherwise it will return false.
     */
    inline bool hasVcard_listing () const;

    /**
     * Returns the value of the member "vcard_listing".
     *
     * If the meaning of "vcard_listing" isn't clear, then there should be a description here.
     *
     * @return The value of the field "vcard_listing"
     */
    inline const ::std::vector< ListResponseVcard_listingStruct >& getVcard_listing () const;

    /**
     * Retrieves the value of the field "vcard_listing" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "vcard_listing".
     */
    inline ::std::vector< ListResponseVcard_listingStruct >& getVcard_listingMutable ();

    /**
     * Sets the value of the member "vcard_listing".
     *
     * If the meaning of "vcard_listing" isn't clear, then there should be a description here.
     *
     * @param vcard_listing The value which will be set
     */
    inline void setVcard_listing (const ::std::vector< ListResponseVcard_listingStruct >& vcard_listing_);

    static const ListResponse &getDefaultInstance();

private:

    static const ::std::vector< ListResponseVcard_listingStruct >& getListResponseVcard_listingStructList_DefaultInstance ();

    inline void set_has_vcard_listing ();

    inline void clear_has_vcard_listing ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ListResponseVcard_listingStruct > _vcard_listing;

};

/**
 * If the meaning of "GetSizeResponse" isn't clear, then there should be a description here.
 */
class GetSizeResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetSizeResponse ();

    /**
     * Copy constructor
     */
    inline  GetSizeResponse (const GetSizeResponse &rhs);

    /**
     * All fields constructor
     */
    inline  GetSizeResponse (uint16 size_);

    /**
     * Destructor
     */
    inline virtual  ~GetSizeResponse();

    /**
     * Assignment operator
     */
    inline GetSizeResponse& operator = (const GetSizeResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetSizeResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetSizeResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetSizeResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetSizeResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "size"

    static const int kSize = 0;

    /**
     * Clears the field "size".
     *
     * The field will be set to its default value. The hasSize()
     * method will return false.
     */
    inline void clearSize();

    /**
     * Checks whether the field "size" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSize()). Otherwise it will return false.
     */
    inline bool hasSize () const;

    /**
     * Returns the value of the member "size".
     *
     * If the meaning of "size" isn't clear, then there should be a description here.
     *
     * @return The value of the field "size"
     */
    inline uint16 getSize () const;

    /**
     * Sets the value of the member "size".
     *
     * If the meaning of "size" isn't clear, then there should be a description here.
     *
     * @param size The value which will be set
     */
    inline void setSize (uint16 size_);

    static const GetSizeResponse &getDefaultInstance();

private:

    inline void set_has_size ();

    inline void clear_has_size ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _size;

};

/**
 * If the meaning of "ListFilterFieldsResponse" isn't clear, then there should be a description here.
 */
class ListFilterFieldsResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ListFilterFieldsResponse ();

    /**
     * Copy constructor
     */
    inline  ListFilterFieldsResponse (const ListFilterFieldsResponse &rhs);

    /**
     * All fields constructor
     */
    inline  ListFilterFieldsResponse (const ::std::vector< ::std::string >& filterFields_);

    /**
     * Destructor
     */
    inline virtual  ~ListFilterFieldsResponse();

    /**
     * Assignment operator
     */
    inline ListFilterFieldsResponse& operator = (const ListFilterFieldsResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ListFilterFieldsResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ListFilterFieldsResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ListFilterFieldsResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ListFilterFieldsResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "filterFields"

    static const int kFilterFields = 0;

    /**
     * Clears the field "filterFields".
     *
     * The field will be set to its default value. The hasFilterFields()
     * method will return false.
     */
    inline void clearFilterFields();

    /**
     * Checks whether the field "filterFields" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFilterFields()). Otherwise it will return false.
     */
    inline bool hasFilterFields () const;

    /**
     * Returns the value of the member "filterFields".
     *
     * If the meaning of "filterFields" isn't clear, then there should be a description here.
     *
     * @return The value of the field "filterFields"
     */
    inline const ::std::vector< ::std::string >& getFilterFields () const;

    /**
     * Retrieves the value of the field "filterFields" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "filterFields".
     */
    inline ::std::vector< ::std::string >& getFilterFieldsMutable ();

    /**
     * Sets the value of the member "filterFields".
     *
     * If the meaning of "filterFields" isn't clear, then there should be a description here.
     *
     * @param filterFields The value which will be set
     */
    inline void setFilterFields (const ::std::vector< ::std::string >& filterFields_);

    static const ListFilterFieldsResponse &getDefaultInstance();

private:

    static const ::std::vector< ::std::string >& getStringList_DefaultInstance ();

    inline void set_has_filterFields ();

    inline void clear_has_filterFields ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::std::string > _filterFields;

};

inline  SelectRequest::SelectRequest ()  :
    _location (),
    _phonebook ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SelectRequest::SelectRequest (const SelectRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _location (),
    _phonebook ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SelectRequest::SelectRequest (const ::std::string& location_, const ::std::string& phonebook_)  :
    _location (location_),
    _phonebook (phonebook_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (location_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (phonebook_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SelectRequest::~SelectRequest() {
}

inline SelectRequest& SelectRequest::operator = (const SelectRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasLocation()) {
            setLocation(rhs.getLocation());
        } else {
            clearLocation();
        }
        if (rhs.hasPhonebook()) {
            setPhonebook(rhs.getPhonebook());
        } else {
            clearPhonebook();
        }
    }
    return *this;
}

inline bool SelectRequest::operator == (const SelectRequest& rhs) const {
    return (((!hasLocation() && !rhs.hasLocation()) || getLocation() == rhs.getLocation()) &&
        ((!hasPhonebook() && !rhs.hasPhonebook()) || getPhonebook() == rhs.getPhonebook()));
}

inline bool SelectRequest::operator != (const SelectRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool SelectRequest::operator < (const SelectRequest& rhs) const {
    if (hasLocation() || rhs.hasLocation()) {
        if (getLocation() < rhs.getLocation()) return true;
        if (getLocation() > rhs.getLocation()) return false;
    }
    if (hasPhonebook() || rhs.hasPhonebook()) {
        if (getPhonebook() < rhs.getPhonebook()) return true;
        if (getPhonebook() > rhs.getPhonebook()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SelectRequest::clone() {
    return new SelectRequest(*this);
}

inline bool SelectRequest::operator > (const SelectRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SelectRequest::clear() {
    clearLocation();
    clearPhonebook();
}

inline void SelectRequest::clearLocation() {
    if (hasLocation()) {
         clear_has_location();
        _location.clear();
     }
}

inline bool SelectRequest::hasLocation () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& SelectRequest::getLocation () const {
    return _location;
}

inline ::std::string& SelectRequest::getLocationMutable () {
    set_has_location();
    return _location;
}

inline void SelectRequest::setLocation (const ::std::string& location_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (location_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_location();
    this->_location = location_;
}

inline void SelectRequest::setLocation (const char* location_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (location_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_location();
    this->_location.assign(location_);
}

inline void SelectRequest::setLocation (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_location();
    this->_location.assign(value, size);
}

inline void SelectRequest::clearPhonebook() {
    if (hasPhonebook()) {
         clear_has_phonebook();
        _phonebook.clear();
     }
}

inline bool SelectRequest::hasPhonebook () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& SelectRequest::getPhonebook () const {
    return _phonebook;
}

inline ::std::string& SelectRequest::getPhonebookMutable () {
    set_has_phonebook();
    return _phonebook;
}

inline void SelectRequest::setPhonebook (const ::std::string& phonebook_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (phonebook_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_phonebook();
    this->_phonebook = phonebook_;
}

inline void SelectRequest::setPhonebook (const char* phonebook_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (phonebook_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_phonebook();
    this->_phonebook.assign(phonebook_);
}

inline void SelectRequest::setPhonebook (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_phonebook();
    this->_phonebook.assign(value, size);
}

inline void SelectRequest::set_has_location () {
    _has_bits_[0] |= 1u << 0;
}

inline void SelectRequest::clear_has_location () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SelectRequest::set_has_phonebook () {
    _has_bits_[0] |= 1u << 1;
}

inline void SelectRequest::clear_has_phonebook () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  PullAllRequest::PullAllRequest ()  :
    _targetfile (),
    _filter ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  PullAllRequest::PullAllRequest (const PullAllRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _targetfile (),
    _filter ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  PullAllRequest::PullAllRequest (const ::std::string& targetfile_, const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& filter_)  :
    _targetfile (targetfile_),
    _filter (filter_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (targetfile_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  PullAllRequest::~PullAllRequest() {
}

inline PullAllRequest& PullAllRequest::operator = (const PullAllRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTargetfile()) {
            setTargetfile(rhs.getTargetfile());
        } else {
            clearTargetfile();
        }
        if (rhs.hasFilter()) {
            setFilter(rhs.getFilter());
        } else {
            clearFilter();
        }
    }
    return *this;
}

inline bool PullAllRequest::operator == (const PullAllRequest& rhs) const {
    return (((!hasTargetfile() && !rhs.hasTargetfile()) || getTargetfile() == rhs.getTargetfile()) &&
        ((!hasFilter() && !rhs.hasFilter()) || getFilter() == rhs.getFilter()));
}

inline bool PullAllRequest::operator != (const PullAllRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool PullAllRequest::operator < (const PullAllRequest& rhs) const {
    if (hasTargetfile() || rhs.hasTargetfile()) {
        if (getTargetfile() < rhs.getTargetfile()) return true;
        if (getTargetfile() > rhs.getTargetfile()) return false;
    }
    if (hasFilter() || rhs.hasFilter()) {
        if (getFilter() < rhs.getFilter()) return true;
        if (getFilter() > rhs.getFilter()) return false;
    }
    return false;
}

inline ::asf::core::Payload* PullAllRequest::clone() {
    return new PullAllRequest(*this);
}

inline bool PullAllRequest::operator > (const PullAllRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void PullAllRequest::clear() {
    clearTargetfile();
    clearFilter();
}

inline void PullAllRequest::clearTargetfile() {
    if (hasTargetfile()) {
         clear_has_targetfile();
        _targetfile.clear();
     }
}

inline bool PullAllRequest::hasTargetfile () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& PullAllRequest::getTargetfile () const {
    return _targetfile;
}

inline ::std::string& PullAllRequest::getTargetfileMutable () {
    set_has_targetfile();
    return _targetfile;
}

inline void PullAllRequest::setTargetfile (const ::std::string& targetfile_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (targetfile_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_targetfile();
    this->_targetfile = targetfile_;
}

inline void PullAllRequest::setTargetfile (const char* targetfile_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (targetfile_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_targetfile();
    this->_targetfile.assign(targetfile_);
}

inline void PullAllRequest::setTargetfile (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_targetfile();
    this->_targetfile.assign(value, size);
}

inline void PullAllRequest::clearFilter() {
    if (hasFilter()) {
         clear_has_filter();
        _filter.clear();
     }
}

inline bool PullAllRequest::hasFilter () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& PullAllRequest::getFilter () const {
    return _filter;
}

inline ::std::map< ::std::string, ::asf::dbus::DBusVariant >& PullAllRequest::getFilterMutable () {
    set_has_filter();
    return _filter;
}

inline void PullAllRequest::setFilter (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& filter_) {
    set_has_filter();
    this->_filter = filter_;
}

inline void PullAllRequest::set_has_targetfile () {
    _has_bits_[0] |= 1u << 0;
}

inline void PullAllRequest::clear_has_targetfile () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void PullAllRequest::set_has_filter () {
    _has_bits_[0] |= 1u << 1;
}

inline void PullAllRequest::clear_has_filter () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  PullAllResponse::PullAllResponse ()  :
    _transfer ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  PullAllResponse::PullAllResponse (const PullAllResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _transfer ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  PullAllResponse::PullAllResponse (const ::std::string& transfer_)  :
    _transfer (transfer_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (transfer_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  PullAllResponse::~PullAllResponse() {
}

inline PullAllResponse& PullAllResponse::operator = (const PullAllResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTransfer()) {
            setTransfer(rhs.getTransfer());
        } else {
            clearTransfer();
        }
    }
    return *this;
}

inline bool PullAllResponse::operator == (const PullAllResponse& rhs) const {
    return (((!hasTransfer() && !rhs.hasTransfer()) || getTransfer() == rhs.getTransfer()));
}

inline bool PullAllResponse::operator != (const PullAllResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool PullAllResponse::operator < (const PullAllResponse& rhs) const {
    if (hasTransfer() || rhs.hasTransfer()) {
        if (getTransfer() < rhs.getTransfer()) return true;
        if (getTransfer() > rhs.getTransfer()) return false;
    }
    return false;
}

inline ::asf::core::Payload* PullAllResponse::clone() {
    return new PullAllResponse(*this);
}

inline bool PullAllResponse::operator > (const PullAllResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void PullAllResponse::clear() {
    clearTransfer();
}

inline void PullAllResponse::clearTransfer() {
    if (hasTransfer()) {
         clear_has_transfer();
        _transfer.clear();
     }
}

inline bool PullAllResponse::hasTransfer () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& PullAllResponse::getTransfer () const {
    return _transfer;
}

inline ::std::string& PullAllResponse::getTransferMutable () {
    set_has_transfer();
    return _transfer;
}

inline void PullAllResponse::setTransfer (const ::std::string& transfer_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (transfer_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_transfer();
    this->_transfer = transfer_;
}

inline void PullAllResponse::setTransfer (const char* transfer_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (transfer_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_transfer();
    this->_transfer.assign(transfer_);
}

inline void PullAllResponse::setTransfer (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_transfer();
    this->_transfer.assign(value, size);
}

inline void PullAllResponse::set_has_transfer () {
    _has_bits_[0] |= 1u << 0;
}

inline void PullAllResponse::clear_has_transfer () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  PullRequest::PullRequest ()  :
    _vcard (),
    _targetfile (),
    _filter ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  PullRequest::PullRequest (const PullRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _vcard (),
    _targetfile (),
    _filter ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  PullRequest::PullRequest (const ::std::string& vcard_, const ::std::string& targetfile_, const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& filter_)  :
    _vcard (vcard_),
    _targetfile (targetfile_),
    _filter (filter_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (vcard_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (targetfile_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  PullRequest::~PullRequest() {
}

inline PullRequest& PullRequest::operator = (const PullRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasVcard()) {
            setVcard(rhs.getVcard());
        } else {
            clearVcard();
        }
        if (rhs.hasTargetfile()) {
            setTargetfile(rhs.getTargetfile());
        } else {
            clearTargetfile();
        }
        if (rhs.hasFilter()) {
            setFilter(rhs.getFilter());
        } else {
            clearFilter();
        }
    }
    return *this;
}

inline bool PullRequest::operator == (const PullRequest& rhs) const {
    return (((!hasVcard() && !rhs.hasVcard()) || getVcard() == rhs.getVcard()) &&
        ((!hasTargetfile() && !rhs.hasTargetfile()) || getTargetfile() == rhs.getTargetfile()) &&
        ((!hasFilter() && !rhs.hasFilter()) || getFilter() == rhs.getFilter()));
}

inline bool PullRequest::operator != (const PullRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool PullRequest::operator < (const PullRequest& rhs) const {
    if (hasVcard() || rhs.hasVcard()) {
        if (getVcard() < rhs.getVcard()) return true;
        if (getVcard() > rhs.getVcard()) return false;
    }
    if (hasTargetfile() || rhs.hasTargetfile()) {
        if (getTargetfile() < rhs.getTargetfile()) return true;
        if (getTargetfile() > rhs.getTargetfile()) return false;
    }
    if (hasFilter() || rhs.hasFilter()) {
        if (getFilter() < rhs.getFilter()) return true;
        if (getFilter() > rhs.getFilter()) return false;
    }
    return false;
}

inline ::asf::core::Payload* PullRequest::clone() {
    return new PullRequest(*this);
}

inline bool PullRequest::operator > (const PullRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void PullRequest::clear() {
    clearVcard();
    clearTargetfile();
    clearFilter();
}

inline void PullRequest::clearVcard() {
    if (hasVcard()) {
         clear_has_vcard();
        _vcard.clear();
     }
}

inline bool PullRequest::hasVcard () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& PullRequest::getVcard () const {
    return _vcard;
}

inline ::std::string& PullRequest::getVcardMutable () {
    set_has_vcard();
    return _vcard;
}

inline void PullRequest::setVcard (const ::std::string& vcard_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (vcard_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_vcard();
    this->_vcard = vcard_;
}

inline void PullRequest::setVcard (const char* vcard_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (vcard_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_vcard();
    this->_vcard.assign(vcard_);
}

inline void PullRequest::setVcard (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_vcard();
    this->_vcard.assign(value, size);
}

inline void PullRequest::clearTargetfile() {
    if (hasTargetfile()) {
         clear_has_targetfile();
        _targetfile.clear();
     }
}

inline bool PullRequest::hasTargetfile () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& PullRequest::getTargetfile () const {
    return _targetfile;
}

inline ::std::string& PullRequest::getTargetfileMutable () {
    set_has_targetfile();
    return _targetfile;
}

inline void PullRequest::setTargetfile (const ::std::string& targetfile_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (targetfile_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_targetfile();
    this->_targetfile = targetfile_;
}

inline void PullRequest::setTargetfile (const char* targetfile_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (targetfile_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_targetfile();
    this->_targetfile.assign(targetfile_);
}

inline void PullRequest::setTargetfile (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_targetfile();
    this->_targetfile.assign(value, size);
}

inline void PullRequest::clearFilter() {
    if (hasFilter()) {
         clear_has_filter();
        _filter.clear();
     }
}

inline bool PullRequest::hasFilter () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& PullRequest::getFilter () const {
    return _filter;
}

inline ::std::map< ::std::string, ::asf::dbus::DBusVariant >& PullRequest::getFilterMutable () {
    set_has_filter();
    return _filter;
}

inline void PullRequest::setFilter (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& filter_) {
    set_has_filter();
    this->_filter = filter_;
}

inline void PullRequest::set_has_vcard () {
    _has_bits_[0] |= 1u << 0;
}

inline void PullRequest::clear_has_vcard () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void PullRequest::set_has_targetfile () {
    _has_bits_[0] |= 1u << 1;
}

inline void PullRequest::clear_has_targetfile () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void PullRequest::set_has_filter () {
    _has_bits_[0] |= 1u << 2;
}

inline void PullRequest::clear_has_filter () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  PullResponse::PullResponse ()  :
    _transfer ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  PullResponse::PullResponse (const PullResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _transfer ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  PullResponse::PullResponse (const ::std::string& transfer_)  :
    _transfer (transfer_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (transfer_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  PullResponse::~PullResponse() {
}

inline PullResponse& PullResponse::operator = (const PullResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTransfer()) {
            setTransfer(rhs.getTransfer());
        } else {
            clearTransfer();
        }
    }
    return *this;
}

inline bool PullResponse::operator == (const PullResponse& rhs) const {
    return (((!hasTransfer() && !rhs.hasTransfer()) || getTransfer() == rhs.getTransfer()));
}

inline bool PullResponse::operator != (const PullResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool PullResponse::operator < (const PullResponse& rhs) const {
    if (hasTransfer() || rhs.hasTransfer()) {
        if (getTransfer() < rhs.getTransfer()) return true;
        if (getTransfer() > rhs.getTransfer()) return false;
    }
    return false;
}

inline ::asf::core::Payload* PullResponse::clone() {
    return new PullResponse(*this);
}

inline bool PullResponse::operator > (const PullResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void PullResponse::clear() {
    clearTransfer();
}

inline void PullResponse::clearTransfer() {
    if (hasTransfer()) {
         clear_has_transfer();
        _transfer.clear();
     }
}

inline bool PullResponse::hasTransfer () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& PullResponse::getTransfer () const {
    return _transfer;
}

inline ::std::string& PullResponse::getTransferMutable () {
    set_has_transfer();
    return _transfer;
}

inline void PullResponse::setTransfer (const ::std::string& transfer_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (transfer_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_transfer();
    this->_transfer = transfer_;
}

inline void PullResponse::setTransfer (const char* transfer_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (transfer_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_transfer();
    this->_transfer.assign(transfer_);
}

inline void PullResponse::setTransfer (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_transfer();
    this->_transfer.assign(value, size);
}

inline void PullResponse::set_has_transfer () {
    _has_bits_[0] |= 1u << 0;
}

inline void PullResponse::clear_has_transfer () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ListRequest::ListRequest ()  :
    _filter ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ListRequest::ListRequest (const ListRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _filter ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ListRequest::ListRequest (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& filter_)  :
    _filter (filter_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ListRequest::~ListRequest() {
}

inline ListRequest& ListRequest::operator = (const ListRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasFilter()) {
            setFilter(rhs.getFilter());
        } else {
            clearFilter();
        }
    }
    return *this;
}

inline bool ListRequest::operator == (const ListRequest& rhs) const {
    return (((!hasFilter() && !rhs.hasFilter()) || getFilter() == rhs.getFilter()));
}

inline bool ListRequest::operator != (const ListRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool ListRequest::operator < (const ListRequest& rhs) const {
    if (hasFilter() || rhs.hasFilter()) {
        if (getFilter() < rhs.getFilter()) return true;
        if (getFilter() > rhs.getFilter()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ListRequest::clone() {
    return new ListRequest(*this);
}

inline bool ListRequest::operator > (const ListRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ListRequest::clear() {
    clearFilter();
}

inline void ListRequest::clearFilter() {
    if (hasFilter()) {
         clear_has_filter();
        _filter.clear();
     }
}

inline bool ListRequest::hasFilter () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& ListRequest::getFilter () const {
    return _filter;
}

inline ::std::map< ::std::string, ::asf::dbus::DBusVariant >& ListRequest::getFilterMutable () {
    set_has_filter();
    return _filter;
}

inline void ListRequest::setFilter (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& filter_) {
    set_has_filter();
    this->_filter = filter_;
}

inline void ListRequest::set_has_filter () {
    _has_bits_[0] |= 1u << 0;
}

inline void ListRequest::clear_has_filter () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ListResponseVcard_listingStruct::ListResponseVcard_listingStruct ()  :
    _elem1 (),
    _elem2 ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ListResponseVcard_listingStruct::ListResponseVcard_listingStruct (const ListResponseVcard_listingStruct &rhs)  :
    _elem1 (),
    _elem2 ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ListResponseVcard_listingStruct::ListResponseVcard_listingStruct (const ::std::string& elem1_, const ::std::string& elem2_)  :
    _elem1 (elem1_),
    _elem2 (elem2_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (elem1_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (elem2_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ListResponseVcard_listingStruct::~ListResponseVcard_listingStruct() {
}

inline ListResponseVcard_listingStruct& ListResponseVcard_listingStruct::operator = (const ListResponseVcard_listingStruct& rhs) {
    if( this != &rhs ) {
        if (rhs.hasElem1()) {
            setElem1(rhs.getElem1());
        } else {
            clearElem1();
        }
        if (rhs.hasElem2()) {
            setElem2(rhs.getElem2());
        } else {
            clearElem2();
        }
    }
    return *this;
}

inline bool ListResponseVcard_listingStruct::operator == (const ListResponseVcard_listingStruct& rhs) const {
    return (((!hasElem1() && !rhs.hasElem1()) || getElem1() == rhs.getElem1()) &&
        ((!hasElem2() && !rhs.hasElem2()) || getElem2() == rhs.getElem2()));
}

inline bool ListResponseVcard_listingStruct::operator != (const ListResponseVcard_listingStruct& rhs) const {
    return ! (*this == rhs);
}

inline bool ListResponseVcard_listingStruct::operator < (const ListResponseVcard_listingStruct& rhs) const {
    if (hasElem1() || rhs.hasElem1()) {
        if (getElem1() < rhs.getElem1()) return true;
        if (getElem1() > rhs.getElem1()) return false;
    }
    if (hasElem2() || rhs.hasElem2()) {
        if (getElem2() < rhs.getElem2()) return true;
        if (getElem2() > rhs.getElem2()) return false;
    }
    return false;
}

inline bool ListResponseVcard_listingStruct::operator > (const ListResponseVcard_listingStruct& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ListResponseVcard_listingStruct::clear() {
    clearElem1();
    clearElem2();
}

inline void ListResponseVcard_listingStruct::clearElem1() {
    if (hasElem1()) {
         clear_has_elem1();
        _elem1.clear();
     }
}

inline bool ListResponseVcard_listingStruct::hasElem1 () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& ListResponseVcard_listingStruct::getElem1 () const {
    return _elem1;
}

inline ::std::string& ListResponseVcard_listingStruct::getElem1Mutable () {
    set_has_elem1();
    return _elem1;
}

inline void ListResponseVcard_listingStruct::setElem1 (const ::std::string& elem1_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (elem1_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_elem1();
    this->_elem1 = elem1_;
}

inline void ListResponseVcard_listingStruct::setElem1 (const char* elem1_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (elem1_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_elem1();
    this->_elem1.assign(elem1_);
}

inline void ListResponseVcard_listingStruct::setElem1 (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_elem1();
    this->_elem1.assign(value, size);
}

inline void ListResponseVcard_listingStruct::clearElem2() {
    if (hasElem2()) {
         clear_has_elem2();
        _elem2.clear();
     }
}

inline bool ListResponseVcard_listingStruct::hasElem2 () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& ListResponseVcard_listingStruct::getElem2 () const {
    return _elem2;
}

inline ::std::string& ListResponseVcard_listingStruct::getElem2Mutable () {
    set_has_elem2();
    return _elem2;
}

inline void ListResponseVcard_listingStruct::setElem2 (const ::std::string& elem2_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (elem2_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_elem2();
    this->_elem2 = elem2_;
}

inline void ListResponseVcard_listingStruct::setElem2 (const char* elem2_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (elem2_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_elem2();
    this->_elem2.assign(elem2_);
}

inline void ListResponseVcard_listingStruct::setElem2 (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_elem2();
    this->_elem2.assign(value, size);
}

inline void ListResponseVcard_listingStruct::set_has_elem1 () {
    _has_bits_[0] |= 1u << 0;
}

inline void ListResponseVcard_listingStruct::clear_has_elem1 () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void ListResponseVcard_listingStruct::set_has_elem2 () {
    _has_bits_[0] |= 1u << 1;
}

inline void ListResponseVcard_listingStruct::clear_has_elem2 () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  ListResponse::ListResponse ()  :
    _vcard_listing ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ListResponse::ListResponse (const ListResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _vcard_listing ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ListResponse::ListResponse (const ::std::vector< ListResponseVcard_listingStruct >& vcard_listing_)  :
    _vcard_listing (vcard_listing_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ListResponse::~ListResponse() {
}

inline ListResponse& ListResponse::operator = (const ListResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasVcard_listing()) {
            setVcard_listing(rhs.getVcard_listing());
        } else {
            clearVcard_listing();
        }
    }
    return *this;
}

inline bool ListResponse::operator == (const ListResponse& rhs) const {
    return (((!hasVcard_listing() && !rhs.hasVcard_listing()) || getVcard_listing() == rhs.getVcard_listing()));
}

inline bool ListResponse::operator != (const ListResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool ListResponse::operator < (const ListResponse& rhs) const {
    if (hasVcard_listing() || rhs.hasVcard_listing()) {
        if (getVcard_listing() < rhs.getVcard_listing()) return true;
        if (getVcard_listing() > rhs.getVcard_listing()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ListResponse::clone() {
    return new ListResponse(*this);
}

inline bool ListResponse::operator > (const ListResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ListResponse::clear() {
    clearVcard_listing();
}

inline void ListResponse::clearVcard_listing() {
    if (hasVcard_listing()) {
         clear_has_vcard_listing();
        _vcard_listing.clear();
     }
}

inline bool ListResponse::hasVcard_listing () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ListResponseVcard_listingStruct >& ListResponse::getVcard_listing () const {
    return _vcard_listing;
}

inline ::std::vector< ListResponseVcard_listingStruct >& ListResponse::getVcard_listingMutable () {
    set_has_vcard_listing();
    return _vcard_listing;
}

inline void ListResponse::setVcard_listing (const ::std::vector< ListResponseVcard_listingStruct >& vcard_listing_) {
    set_has_vcard_listing();
    this->_vcard_listing = vcard_listing_;
}

inline void ListResponse::set_has_vcard_listing () {
    _has_bits_[0] |= 1u << 0;
}

inline void ListResponse::clear_has_vcard_listing () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GetSizeResponse::GetSizeResponse ()  :
    _size (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetSizeResponse::GetSizeResponse (const GetSizeResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _size (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetSizeResponse::GetSizeResponse (uint16 size_)  :
    _size (size_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetSizeResponse::~GetSizeResponse() {
}

inline GetSizeResponse& GetSizeResponse::operator = (const GetSizeResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSize()) {
            setSize(rhs.getSize());
        } else {
            clearSize();
        }
    }
    return *this;
}

inline bool GetSizeResponse::operator == (const GetSizeResponse& rhs) const {
    return (((!hasSize() && !rhs.hasSize()) || getSize() == rhs.getSize()));
}

inline bool GetSizeResponse::operator != (const GetSizeResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool GetSizeResponse::operator < (const GetSizeResponse& rhs) const {
    if (hasSize() || rhs.hasSize()) {
        if (getSize() < rhs.getSize()) return true;
        if (getSize() > rhs.getSize()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetSizeResponse::clone() {
    return new GetSizeResponse(*this);
}

inline bool GetSizeResponse::operator > (const GetSizeResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetSizeResponse::clear() {
    clearSize();
}

inline void GetSizeResponse::clearSize() {
    if (hasSize()) {
         clear_has_size();
        _size = 0u;
     }
}

inline bool GetSizeResponse::hasSize () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 GetSizeResponse::getSize () const {
    return _size;
}

inline void GetSizeResponse::setSize (uint16 size_) {
    set_has_size();
    this->_size = size_;
}

inline void GetSizeResponse::set_has_size () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetSizeResponse::clear_has_size () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ListFilterFieldsResponse::ListFilterFieldsResponse ()  :
    _filterFields ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ListFilterFieldsResponse::ListFilterFieldsResponse (const ListFilterFieldsResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _filterFields ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ListFilterFieldsResponse::ListFilterFieldsResponse (const ::std::vector< ::std::string >& filterFields_)  :
    _filterFields (filterFields_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ListFilterFieldsResponse::~ListFilterFieldsResponse() {
}

inline ListFilterFieldsResponse& ListFilterFieldsResponse::operator = (const ListFilterFieldsResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasFilterFields()) {
            setFilterFields(rhs.getFilterFields());
        } else {
            clearFilterFields();
        }
    }
    return *this;
}

inline bool ListFilterFieldsResponse::operator == (const ListFilterFieldsResponse& rhs) const {
    return (((!hasFilterFields() && !rhs.hasFilterFields()) || getFilterFields() == rhs.getFilterFields()));
}

inline bool ListFilterFieldsResponse::operator != (const ListFilterFieldsResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool ListFilterFieldsResponse::operator < (const ListFilterFieldsResponse& rhs) const {
    if (hasFilterFields() || rhs.hasFilterFields()) {
        if (getFilterFields() < rhs.getFilterFields()) return true;
        if (getFilterFields() > rhs.getFilterFields()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ListFilterFieldsResponse::clone() {
    return new ListFilterFieldsResponse(*this);
}

inline bool ListFilterFieldsResponse::operator > (const ListFilterFieldsResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ListFilterFieldsResponse::clear() {
    clearFilterFields();
}

inline void ListFilterFieldsResponse::clearFilterFields() {
    if (hasFilterFields()) {
         clear_has_filterFields();
        _filterFields.clear();
     }
}

inline bool ListFilterFieldsResponse::hasFilterFields () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ::std::string >& ListFilterFieldsResponse::getFilterFields () const {
    return _filterFields;
}

inline ::std::vector< ::std::string >& ListFilterFieldsResponse::getFilterFieldsMutable () {
    set_has_filterFields();
    return _filterFields;
}

inline void ListFilterFieldsResponse::setFilterFields (const ::std::vector< ::std::string >& filterFields_) {
    set_has_filterFields();
    this->_filterFields = filterFields_;
}

inline void ListFilterFieldsResponse::set_has_filterFields () {
    _has_bits_[0] |= 1u << 0;
}

inline void ListFilterFieldsResponse::clear_has_filterFields () {
    _has_bits_[0] &= ~ (1u << 0);
}

} // namespace PhonebookAccess
} // namespace obex
} // namespace bluez
} // namespace org

#endif // ORG_BLUEZ_OBEX_PHONEBOOKACCESS_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
