/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_BLUEZ_OBEX_MESSAGEPROXY_H
#define ORG_BLUEZ_OBEX_MESSAGEPROXY_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/nullable.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusProxy.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "org/bluez/obex/Message.h"
#include <dbus/dbus.h>
#include <string>

namespace org {
namespace bluez {
namespace obex {
namespace Message {

class MessageProxy;

class AttachmentSizeCallbackIF {
public:
    virtual ~AttachmentSizeCallbackIF() {}

    virtual void onAttachmentSizeError(const ::boost::shared_ptr< MessageProxy >& proxy, const ::boost::shared_ptr< AttachmentSizeError >& error) = 0;

    virtual void onAttachmentSizeUpdate(const ::boost::shared_ptr< MessageProxy >& proxy, const ::boost::shared_ptr< AttachmentSizeUpdate >& update) = 0;
};

class DeletedCallbackIF {
public:
    virtual ~DeletedCallbackIF() {}

    virtual void onDeletedError(const ::boost::shared_ptr< MessageProxy >& proxy, const ::boost::shared_ptr< DeletedError >& error) = 0;

    virtual void onDeletedUpdate(const ::boost::shared_ptr< MessageProxy >& proxy, const ::boost::shared_ptr< DeletedUpdate >& update) = 0;
};

class FolderCallbackIF {
public:
    virtual ~FolderCallbackIF() {}

    virtual void onFolderError(const ::boost::shared_ptr< MessageProxy >& proxy, const ::boost::shared_ptr< FolderError >& error) = 0;

    virtual void onFolderUpdate(const ::boost::shared_ptr< MessageProxy >& proxy, const ::boost::shared_ptr< FolderUpdate >& update) = 0;
};

class GetCallbackIF {
public:
    virtual ~GetCallbackIF() {}

    virtual void onGetError(const ::boost::shared_ptr< MessageProxy >& proxy, const ::boost::shared_ptr< GetError >& error) = 0;

    virtual void onGetResponse(const ::boost::shared_ptr< MessageProxy >& proxy, const ::boost::shared_ptr< GetResponse >& response) = 0;
};

class PriorityCallbackIF {
public:
    virtual ~PriorityCallbackIF() {}

    virtual void onPriorityError(const ::boost::shared_ptr< MessageProxy >& proxy, const ::boost::shared_ptr< PriorityError >& error) = 0;

    virtual void onPriorityUpdate(const ::boost::shared_ptr< MessageProxy >& proxy, const ::boost::shared_ptr< PriorityUpdate >& update) = 0;
};

class ProtectedCallbackIF {
public:
    virtual ~ProtectedCallbackIF() {}

    virtual void onProtectedError(const ::boost::shared_ptr< MessageProxy >& proxy, const ::boost::shared_ptr< ProtectedError >& error) = 0;

    virtual void onProtectedUpdate(const ::boost::shared_ptr< MessageProxy >& proxy, const ::boost::shared_ptr< ProtectedUpdate >& update) = 0;
};

class ReadCallbackIF {
public:
    virtual ~ReadCallbackIF() {}

    virtual void onReadError(const ::boost::shared_ptr< MessageProxy >& proxy, const ::boost::shared_ptr< ReadError >& error) = 0;

    virtual void onReadUpdate(const ::boost::shared_ptr< MessageProxy >& proxy, const ::boost::shared_ptr< ReadUpdate >& update) = 0;
};

class RecipientAddressCallbackIF {
public:
    virtual ~RecipientAddressCallbackIF() {}

    virtual void onRecipientAddressError(const ::boost::shared_ptr< MessageProxy >& proxy, const ::boost::shared_ptr< RecipientAddressError >& error) = 0;

    virtual void onRecipientAddressUpdate(const ::boost::shared_ptr< MessageProxy >& proxy, const ::boost::shared_ptr< RecipientAddressUpdate >& update) = 0;
};

class RecipientCallbackIF {
public:
    virtual ~RecipientCallbackIF() {}

    virtual void onRecipientError(const ::boost::shared_ptr< MessageProxy >& proxy, const ::boost::shared_ptr< RecipientError >& error) = 0;

    virtual void onRecipientUpdate(const ::boost::shared_ptr< MessageProxy >& proxy, const ::boost::shared_ptr< RecipientUpdate >& update) = 0;
};

class ReplyToCallbackIF {
public:
    virtual ~ReplyToCallbackIF() {}

    virtual void onReplyToError(const ::boost::shared_ptr< MessageProxy >& proxy, const ::boost::shared_ptr< ReplyToError >& error) = 0;

    virtual void onReplyToUpdate(const ::boost::shared_ptr< MessageProxy >& proxy, const ::boost::shared_ptr< ReplyToUpdate >& update) = 0;
};

class SenderAddressCallbackIF {
public:
    virtual ~SenderAddressCallbackIF() {}

    virtual void onSenderAddressError(const ::boost::shared_ptr< MessageProxy >& proxy, const ::boost::shared_ptr< SenderAddressError >& error) = 0;

    virtual void onSenderAddressUpdate(const ::boost::shared_ptr< MessageProxy >& proxy, const ::boost::shared_ptr< SenderAddressUpdate >& update) = 0;
};

class SenderCallbackIF {
public:
    virtual ~SenderCallbackIF() {}

    virtual void onSenderError(const ::boost::shared_ptr< MessageProxy >& proxy, const ::boost::shared_ptr< SenderError >& error) = 0;

    virtual void onSenderUpdate(const ::boost::shared_ptr< MessageProxy >& proxy, const ::boost::shared_ptr< SenderUpdate >& update) = 0;
};

class SentCallbackIF {
public:
    virtual ~SentCallbackIF() {}

    virtual void onSentError(const ::boost::shared_ptr< MessageProxy >& proxy, const ::boost::shared_ptr< SentError >& error) = 0;

    virtual void onSentUpdate(const ::boost::shared_ptr< MessageProxy >& proxy, const ::boost::shared_ptr< SentUpdate >& update) = 0;
};

class SizeCallbackIF {
public:
    virtual ~SizeCallbackIF() {}

    virtual void onSizeError(const ::boost::shared_ptr< MessageProxy >& proxy, const ::boost::shared_ptr< SizeError >& error) = 0;

    virtual void onSizeUpdate(const ::boost::shared_ptr< MessageProxy >& proxy, const ::boost::shared_ptr< SizeUpdate >& update) = 0;
};

class StatusCallbackIF {
public:
    virtual ~StatusCallbackIF() {}

    virtual void onStatusError(const ::boost::shared_ptr< MessageProxy >& proxy, const ::boost::shared_ptr< StatusError >& error) = 0;

    virtual void onStatusUpdate(const ::boost::shared_ptr< MessageProxy >& proxy, const ::boost::shared_ptr< StatusUpdate >& update) = 0;
};

class SubjectCallbackIF {
public:
    virtual ~SubjectCallbackIF() {}

    virtual void onSubjectError(const ::boost::shared_ptr< MessageProxy >& proxy, const ::boost::shared_ptr< SubjectError >& error) = 0;

    virtual void onSubjectUpdate(const ::boost::shared_ptr< MessageProxy >& proxy, const ::boost::shared_ptr< SubjectUpdate >& update) = 0;
};

class TextCallbackIF {
public:
    virtual ~TextCallbackIF() {}

    virtual void onTextError(const ::boost::shared_ptr< MessageProxy >& proxy, const ::boost::shared_ptr< TextError >& error) = 0;

    virtual void onTextUpdate(const ::boost::shared_ptr< MessageProxy >& proxy, const ::boost::shared_ptr< TextUpdate >& update) = 0;
};

class TimestampCallbackIF {
public:
    virtual ~TimestampCallbackIF() {}

    virtual void onTimestampError(const ::boost::shared_ptr< MessageProxy >& proxy, const ::boost::shared_ptr< TimestampError >& error) = 0;

    virtual void onTimestampUpdate(const ::boost::shared_ptr< MessageProxy >& proxy, const ::boost::shared_ptr< TimestampUpdate >& update) = 0;
};

class TypeCallbackIF {
public:
    virtual ~TypeCallbackIF() {}

    virtual void onTypeError(const ::boost::shared_ptr< MessageProxy >& proxy, const ::boost::shared_ptr< TypeError >& error) = 0;

    virtual void onTypeUpdate(const ::boost::shared_ptr< MessageProxy >& proxy, const ::boost::shared_ptr< TypeUpdate >& update) = 0;
};


/**
 * MessageProxy is the client side representation of the D-Bus service
 * interface 'org.bluez.obex.Message' (specified in file map_message.xml).
 *
 * If the meaning of "org.bluez.obex.Message" isn't clear, then there should be a description here.
 */
class MessageProxy : public ::asf::dbus::DBusProxy
{
public:
    /**
     * Create a new instance of MessageProxy.
     */
    static ::boost::shared_ptr< MessageProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Create a new instance of MessageProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @deprecated use the createProxy() method with the parameter
     * ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector instead.
     */
    static ::boost::shared_ptr< MessageProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        ::DBusBusType busType,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector connectorOptions;
        connectorOptions.setBusType(::asf::dbus::DBusUtils::toOptions(busType).getBusType());
        return createProxy(portName, busName, objectPath, connectorOptions, serviceAvailable);
    }

    /**
     * Create a new instance of MessageProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     */
    static ::boost::shared_ptr< MessageProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        const ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector& connectorOptions,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< MessageProxy > proxyNew(new MessageProxy(portName, serviceAvailable));
        ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew, busName, objectPath, connectorOptions);
        proxyNew->createHelperProxies(true);
        return proxyNew;
    }

    virtual ~MessageProxy ();



    // Property 'Folder'

    /**
     * Notify on the property 'Folder'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'Folder'</b>:
     *
     * If the meaning of "Folder" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendFolderRegister(FolderCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'Folder'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'Folder'</b>:
     *
     * If the meaning of "Folder" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendFolderRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendFolderDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'Folder'.
     */
    void sendFolderDeregisterAll() const;

    /**
     * Request the value of the property 'Folder' from the D-Bus server. This
     * method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'Folder'</b>:
     *
     * If the meaning of "Folder" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendFolderGet(FolderCallbackIF& cb);


    /**
     * Returns the current value of the property 'Folder' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasFolder()
     * returns true.
     *
     * @return the previously received value of the property 'Folder'.
     */
    const ::std::string& getFolder() const;

    /**
     * Determines whether a status message for the property 'Folder' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasFolder() const;

    // Property 'Subject'

    /**
     * Notify on the property 'Subject'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'Subject'</b>:
     *
     * If the meaning of "Subject" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSubjectRegister(SubjectCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'Subject'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'Subject'</b>:
     *
     * If the meaning of "Subject" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendSubjectRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendSubjectDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'Subject'.
     */
    void sendSubjectDeregisterAll() const;

    /**
     * Request the value of the property 'Subject' from the D-Bus server. This
     * method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'Subject'</b>:
     *
     * If the meaning of "Subject" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSubjectGet(SubjectCallbackIF& cb);


    /**
     * Returns the current value of the property 'Subject' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasSubject()
     * returns true.
     *
     * @return the previously received value of the property 'Subject'.
     */
    const ::std::string& getSubject() const;

    /**
     * Determines whether a status message for the property 'Subject' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasSubject() const;

    // Property 'Timestamp'

    /**
     * Notify on the property 'Timestamp'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'Timestamp'</b>:
     *
     * If the meaning of "Timestamp" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendTimestampRegister(TimestampCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'Timestamp'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'Timestamp'</b>:
     *
     * If the meaning of "Timestamp" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendTimestampRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendTimestampDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'Timestamp'.
     */
    void sendTimestampDeregisterAll() const;

    /**
     * Request the value of the property 'Timestamp' from the D-Bus server.
     * This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'Timestamp'</b>:
     *
     * If the meaning of "Timestamp" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendTimestampGet(TimestampCallbackIF& cb);


    /**
     * Returns the current value of the property 'Timestamp' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasTimestamp()
     * returns true.
     *
     * @return the previously received value of the property 'Timestamp'.
     */
    const ::std::string& getTimestamp() const;

    /**
     * Determines whether a status message for the property 'Timestamp' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasTimestamp() const;

    // Property 'Sender'

    /**
     * Notify on the property 'Sender'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'Sender'</b>:
     *
     * If the meaning of "Sender" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSenderRegister(SenderCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'Sender'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'Sender'</b>:
     *
     * If the meaning of "Sender" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendSenderRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendSenderDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'Sender'.
     */
    void sendSenderDeregisterAll() const;

    /**
     * Request the value of the property 'Sender' from the D-Bus server. This
     * method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'Sender'</b>:
     *
     * If the meaning of "Sender" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSenderGet(SenderCallbackIF& cb);


    /**
     * Returns the current value of the property 'Sender' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasSender()
     * returns true.
     *
     * @return the previously received value of the property 'Sender'.
     */
    const ::std::string& getSender() const;

    /**
     * Determines whether a status message for the property 'Sender' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasSender() const;

    // Property 'SenderAddress'

    /**
     * Notify on the property 'SenderAddress'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'SenderAddress'</b>:
     *
     * If the meaning of "SenderAddress" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSenderAddressRegister(SenderAddressCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'SenderAddress'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'SenderAddress'</b>:
     *
     * If the meaning of "SenderAddress" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendSenderAddressRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendSenderAddressDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'SenderAddress'.
     */
    void sendSenderAddressDeregisterAll() const;

    /**
     * Request the value of the property 'SenderAddress' from the D-Bus
     * server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'SenderAddress'</b>:
     *
     * If the meaning of "SenderAddress" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSenderAddressGet(SenderAddressCallbackIF& cb);


    /**
     * Returns the current value of the property 'SenderAddress' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasSenderAddress() returns true.
     *
     * @return the previously received value of the property 'SenderAddress'.
     */
    const ::std::string& getSenderAddress() const;

    /**
     * Determines whether a status message for the property 'SenderAddress'
     * was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasSenderAddress() const;

    // Property 'ReplyTo'

    /**
     * Notify on the property 'ReplyTo'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'ReplyTo'</b>:
     *
     * If the meaning of "ReplyTo" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendReplyToRegister(ReplyToCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'ReplyTo'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'ReplyTo'</b>:
     *
     * If the meaning of "ReplyTo" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendReplyToRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendReplyToDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'ReplyTo'.
     */
    void sendReplyToDeregisterAll() const;

    /**
     * Request the value of the property 'ReplyTo' from the D-Bus server. This
     * method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'ReplyTo'</b>:
     *
     * If the meaning of "ReplyTo" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendReplyToGet(ReplyToCallbackIF& cb);


    /**
     * Returns the current value of the property 'ReplyTo' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasReplyTo()
     * returns true.
     *
     * @return the previously received value of the property 'ReplyTo'.
     */
    const ::std::string& getReplyTo() const;

    /**
     * Determines whether a status message for the property 'ReplyTo' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasReplyTo() const;

    // Property 'Recipient'

    /**
     * Notify on the property 'Recipient'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'Recipient'</b>:
     *
     * If the meaning of "Recipient" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRecipientRegister(RecipientCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'Recipient'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'Recipient'</b>:
     *
     * If the meaning of "Recipient" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendRecipientRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendRecipientDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'Recipient'.
     */
    void sendRecipientDeregisterAll() const;

    /**
     * Request the value of the property 'Recipient' from the D-Bus server.
     * This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'Recipient'</b>:
     *
     * If the meaning of "Recipient" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRecipientGet(RecipientCallbackIF& cb);


    /**
     * Returns the current value of the property 'Recipient' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasRecipient()
     * returns true.
     *
     * @return the previously received value of the property 'Recipient'.
     */
    const ::std::string& getRecipient() const;

    /**
     * Determines whether a status message for the property 'Recipient' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasRecipient() const;

    // Property 'RecipientAddress'

    /**
     * Notify on the property 'RecipientAddress'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'RecipientAddress'</b>:
     *
     * If the meaning of "RecipientAddress" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRecipientAddressRegister(RecipientAddressCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'RecipientAddress'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'RecipientAddress'</b>:
     *
     * If the meaning of "RecipientAddress" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendRecipientAddressRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendRecipientAddressDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'RecipientAddress'.
     */
    void sendRecipientAddressDeregisterAll() const;

    /**
     * Request the value of the property 'RecipientAddress' from the D-Bus
     * server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'RecipientAddress'</b>:
     *
     * If the meaning of "RecipientAddress" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRecipientAddressGet(RecipientAddressCallbackIF& cb);


    /**
     * Returns the current value of the property 'RecipientAddress' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasRecipientAddress() returns true.
     *
     * @return the previously received value of the property 'RecipientAddress'.
     */
    const ::std::string& getRecipientAddress() const;

    /**
     * Determines whether a status message for the property 'RecipientAddress'
     * was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasRecipientAddress() const;

    // Property 'Type'

    /**
     * Notify on the property 'Type'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'Type'</b>:
     *
     * If the meaning of "Type" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendTypeRegister(TypeCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'Type'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'Type'</b>:
     *
     * If the meaning of "Type" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendTypeRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendTypeDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'Type'.
     */
    void sendTypeDeregisterAll() const;

    /**
     * Request the value of the property 'Type' from the D-Bus server. This
     * method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'Type'</b>:
     *
     * If the meaning of "Type" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendTypeGet(TypeCallbackIF& cb);


    /**
     * Returns the current value of the property 'Type' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasType()
     * returns true.
     *
     * @return the previously received value of the property 'Type'.
     */
    const ::std::string& getType() const;

    /**
     * Determines whether a status message for the property 'Type' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasType() const;

    // Property 'Size'

    /**
     * Notify on the property 'Size'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'Size'</b>:
     *
     * If the meaning of "Size" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSizeRegister(SizeCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'Size'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'Size'</b>:
     *
     * If the meaning of "Size" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendSizeRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendSizeDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'Size'.
     */
    void sendSizeDeregisterAll() const;

    /**
     * Request the value of the property 'Size' from the D-Bus server. This
     * method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'Size'</b>:
     *
     * If the meaning of "Size" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSizeGet(SizeCallbackIF& cb);


    /**
     * Returns the current value of the property 'Size' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasSize()
     * returns true.
     *
     * @return the previously received value of the property 'Size'.
     */
    uint64 getSize() const;

    /**
     * Determines whether a status message for the property 'Size' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasSize() const;

    // Property 'AttachmentSize'

    /**
     * Notify on the property 'AttachmentSize'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'AttachmentSize'</b>:
     *
     * If the meaning of "AttachmentSize" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAttachmentSizeRegister(AttachmentSizeCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'AttachmentSize'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'AttachmentSize'</b>:
     *
     * If the meaning of "AttachmentSize" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendAttachmentSizeRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendAttachmentSizeDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'AttachmentSize'.
     */
    void sendAttachmentSizeDeregisterAll() const;

    /**
     * Request the value of the property 'AttachmentSize' from the D-Bus
     * server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'AttachmentSize'</b>:
     *
     * If the meaning of "AttachmentSize" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAttachmentSizeGet(AttachmentSizeCallbackIF& cb);


    /**
     * Returns the current value of the property 'AttachmentSize' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasAttachmentSize() returns true.
     *
     * @return the previously received value of the property 'AttachmentSize'.
     */
    uint64 getAttachmentSize() const;

    /**
     * Determines whether a status message for the property 'AttachmentSize'
     * was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasAttachmentSize() const;

    // Property 'Status'

    /**
     * Notify on the property 'Status'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'Status'</b>:
     *
     * If the meaning of "Status" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendStatusRegister(StatusCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'Status'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'Status'</b>:
     *
     * If the meaning of "Status" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendStatusRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendStatusDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'Status'.
     */
    void sendStatusDeregisterAll() const;

    /**
     * Request the value of the property 'Status' from the D-Bus server. This
     * method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'Status'</b>:
     *
     * If the meaning of "Status" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendStatusGet(StatusCallbackIF& cb);


    /**
     * Returns the current value of the property 'Status' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasStatus()
     * returns true.
     *
     * @return the previously received value of the property 'Status'.
     */
    const ::std::string& getStatus() const;

    /**
     * Determines whether a status message for the property 'Status' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasStatus() const;

    // Property 'Priority'

    /**
     * Notify on the property 'Priority'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'Priority'</b>:
     *
     * If the meaning of "Priority" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendPriorityRegister(PriorityCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'Priority'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'Priority'</b>:
     *
     * If the meaning of "Priority" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendPriorityRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendPriorityDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'Priority'.
     */
    void sendPriorityDeregisterAll() const;

    /**
     * Request the value of the property 'Priority' from the D-Bus server.
     * This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'Priority'</b>:
     *
     * If the meaning of "Priority" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendPriorityGet(PriorityCallbackIF& cb);


    /**
     * Returns the current value of the property 'Priority' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasPriority()
     * returns true.
     *
     * @return the previously received value of the property 'Priority'.
     */
    bool getPriority() const;

    /**
     * Determines whether a status message for the property 'Priority' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasPriority() const;

    // Property 'Read'

    /**
     * Notify on the property 'Read'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'Read'</b>:
     *
     * If the meaning of "Read" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendReadRegister(ReadCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'Read'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'Read'</b>:
     *
     * If the meaning of "Read" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendReadRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendReadDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'Read'.
     */
    void sendReadDeregisterAll() const;

    /**
     * Request the value of the property 'Read' from the D-Bus server. This
     * method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'Read'</b>:
     *
     * If the meaning of "Read" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendReadGet(ReadCallbackIF& cb);

    /**
     * Set the value of the property 'Read'. This method sends a Set message
     * to the D-Bus server.
     *
     * @deprecated use the sendReadSet(ReadCallbackIF& cb, bool read) method
     * instead.
     *
     * <b>Documentation of 'Read'</b>:
     *
     * If the meaning of "Read" isn't clear, then there should be a description here.
     */
    void sendReadSet(bool read);

    /**
     * Set the value of the property 'Read'. This method sends a Set message
     * to the D-Bus server.
     *
     * <b>Documentation of 'Read'</b>:
     *
     * If the meaning of "Read" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Set message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendReadSet(ReadCallbackIF& cb, bool read);

    /**
     * Returns the current value of the property 'Read' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasRead()
     * returns true.
     *
     * @return the previously received value of the property 'Read'.
     */
    bool getRead() const;

    /**
     * Determines whether a status message for the property 'Read' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasRead() const;

    // Property 'Deleted'

    /**
     * Notify on the property 'Deleted'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'Deleted'</b>:
     *
     * If the meaning of "Deleted" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDeletedRegister(DeletedCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'Deleted'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'Deleted'</b>:
     *
     * If the meaning of "Deleted" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendDeletedRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendDeletedDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'Deleted'.
     */
    void sendDeletedDeregisterAll() const;


    /**
     * Set the value of the property 'Deleted'. This method sends a Set
     * message to the D-Bus server.
     *
     * @deprecated use the sendDeletedSet(DeletedCallbackIF& cb, bool deleted)
     * method instead.
     *
     * <b>Documentation of 'Deleted'</b>:
     *
     * If the meaning of "Deleted" isn't clear, then there should be a description here.
     */
    void sendDeletedSet(bool deleted);

    /**
     * Set the value of the property 'Deleted'. This method sends a Set
     * message to the D-Bus server.
     *
     * <b>Documentation of 'Deleted'</b>:
     *
     * If the meaning of "Deleted" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Set message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDeletedSet(DeletedCallbackIF& cb, bool deleted);

    /**
     * Returns the current value of the property 'Deleted' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasDeleted()
     * returns true.
     *
     * @return the previously received value of the property 'Deleted'.
     */
    bool getDeleted() const;

    /**
     * Determines whether a status message for the property 'Deleted' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasDeleted() const;

    // Property 'Sent'

    /**
     * Notify on the property 'Sent'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'Sent'</b>:
     *
     * If the meaning of "Sent" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSentRegister(SentCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'Sent'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'Sent'</b>:
     *
     * If the meaning of "Sent" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendSentRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendSentDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'Sent'.
     */
    void sendSentDeregisterAll() const;

    /**
     * Request the value of the property 'Sent' from the D-Bus server. This
     * method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'Sent'</b>:
     *
     * If the meaning of "Sent" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSentGet(SentCallbackIF& cb);


    /**
     * Returns the current value of the property 'Sent' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasSent()
     * returns true.
     *
     * @return the previously received value of the property 'Sent'.
     */
    bool getSent() const;

    /**
     * Determines whether a status message for the property 'Sent' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasSent() const;

    // Property 'Protected'

    /**
     * Notify on the property 'Protected'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'Protected'</b>:
     *
     * If the meaning of "Protected" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendProtectedRegister(ProtectedCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'Protected'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'Protected'</b>:
     *
     * If the meaning of "Protected" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendProtectedRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendProtectedDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'Protected'.
     */
    void sendProtectedDeregisterAll() const;

    /**
     * Request the value of the property 'Protected' from the D-Bus server.
     * This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'Protected'</b>:
     *
     * If the meaning of "Protected" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendProtectedGet(ProtectedCallbackIF& cb);


    /**
     * Returns the current value of the property 'Protected' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasProtected()
     * returns true.
     *
     * @return the previously received value of the property 'Protected'.
     */
    bool getProtected() const;

    /**
     * Determines whether a status message for the property 'Protected' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasProtected() const;

    // Property 'Text'

    /**
     * Notify on the property 'Text'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'Text'</b>:
     *
     * If the meaning of "Text" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendTextRegister(TextCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'Text'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'Text'</b>:
     *
     * If the meaning of "Text" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendTextRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendTextDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'Text'.
     */
    void sendTextDeregisterAll() const;

    /**
     * Request the value of the property 'Text' from the D-Bus server. This
     * method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'Text'</b>:
     *
     * If the meaning of "Text" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendTextGet(TextCallbackIF& cb);


    /**
     * Returns the current value of the property 'Text' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasText()
     * returns true.
     *
     * @return the previously received value of the property 'Text'.
     */
    bool getText() const;

    /**
     * Determines whether a status message for the property 'Text' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasText() const;


    // Method 'Get'

    /**
     * Call the method 'Get'. This method sends a message to the D-Bus server.
     *
     * <b>Documentation of 'Get'</b>:
     *
     * If the meaning of "Get" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param targetfile If the meaning of "targetfile" isn't clear, then there should be a description here.
     *
     * @param attachment If the meaning of "attachment" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetRequest(GetCallbackIF& cb, const ::std::string& targetfile, bool attachment) const;

    /**
     * Release all property and signal notifications.
     */
    void sendDeregisterAll () const;

private:

    MessageProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    act_t addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const;

    act_t addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const;

    virtual void clearAllProperties ();

    // Property 'Folder'

    ::asf::core::nullable< FolderUpdate > _folder;

    // Property 'Subject'

    ::asf::core::nullable< SubjectUpdate > _subject;

    // Property 'Timestamp'

    ::asf::core::nullable< TimestampUpdate > _timestamp;

    // Property 'Sender'

    ::asf::core::nullable< SenderUpdate > _sender;

    // Property 'SenderAddress'

    ::asf::core::nullable< SenderAddressUpdate > _senderAddress;

    // Property 'ReplyTo'

    ::asf::core::nullable< ReplyToUpdate > _replyTo;

    // Property 'Recipient'

    ::asf::core::nullable< RecipientUpdate > _recipient;

    // Property 'RecipientAddress'

    ::asf::core::nullable< RecipientAddressUpdate > _recipientAddress;

    // Property 'Type'

    ::asf::core::nullable< TypeUpdate > _type;

    // Property 'Size'

    ::asf::core::nullable< SizeUpdate > _size;

    // Property 'AttachmentSize'

    ::asf::core::nullable< AttachmentSizeUpdate > _attachmentSize;

    // Property 'Status'

    ::asf::core::nullable< StatusUpdate > _status;

    // Property 'Priority'

    ::asf::core::nullable< PriorityUpdate > _priority;

    // Property 'Read'

    ::asf::core::nullable< ReadUpdate > _read;

    // Property 'Deleted'

    ::asf::core::nullable< DeletedUpdate > _deleted;

    // Property 'Sent'

    ::asf::core::nullable< SentUpdate > _sent;

    // Property 'Protected'

    ::asf::core::nullable< ProtectedUpdate > _protected;

    // Property 'Text'

    ::asf::core::nullable< TextUpdate > _text;

    DECLARE_CLASS_LOGGER();

    friend class MessageProxyCallback;
};

} // namespace Message
} // namespace obex
} // namespace bluez
} // namespace org

#endif // ORG_BLUEZ_OBEX_MESSAGEPROXY_H
