/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_BLUEZ_OBEX_MESSAGEACCESSSTUB_H
#define ORG_BLUEZ_OBEX_MESSAGEACCESSSTUB_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStub.h"
#include "asf/dbus/DBusVariant.h"
#include "boost/shared_ptr.hpp"
#include "org/bluez/obex/MessageAccess.h"
#include <map>
#include <string>
#include <vector>

namespace org {
namespace bluez {
namespace obex {
namespace MessageAccess {

class MessageAccessStubDelegate;

class MessageAccessStub : public ::asf::dbus::DBusStub
{
public:

    /**
     * Create an instance of the MessageAccessStub
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     */
    MessageAccessStub (const std::string& portName);

    /**
     * Create an instance of the MessageAccessStub
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     * @param objectPath the dbus object path, see
     * http://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-marshaling-object-path
     */
    MessageAccessStub (const std::string& portName, const std::string& objectPath);

    virtual ~MessageAccessStub();

    // signal 'NewMessageNotification'

    /**
     * Raise the signal 'NewMessageNotification' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'NewMessageNotification'</b>:
     *
     * If the meaning of "NewMessageNotification" isn't clear, then there should be a description here.
     */
    void sendNewMessageNotificationSignal(const ::std::vector< uint8 >& data, const ::std::string& path);

    // property 'Notification'

    /**
     * The method onNotificationGet() is called by ASF when a client invokes
     * the read method for the property 'Notification'. The
     * onNotificationGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'Notification'</b>:
     *
     * If the meaning of "Notification" isn't clear, then there should be a description here.
     */
    virtual void onNotificationGet(const ::boost::shared_ptr< NotificationGet >& payload);

    /**
     * Sends back the update to a previous onNotificationGet().
     *
     * <b>Documentation of 'Notification'</b>:
     *
     * If the meaning of "Notification" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onNotificationGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendNotificationGetUpdate(const ::std::string& notification, act_t act = 0);

    /**
     * Set the value of the property 'Notification' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'Notification'</b>:
     *
     * If the meaning of "Notification" isn't clear, then there should be a description here.
     */
    void setNotification(const ::std::string& notification);

    /**
     * Returns the current value of the property 'Notification'.
     *
     * <b>Documentation of 'Notification'</b>:
     *
     * If the meaning of "Notification" isn't clear, then there should be a description here.
     */
    const ::std::string& getNotification() const;

    /**
     * Returns the current value of the property 'Notification' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendNotificationUpdate() method.
     *
     * <b>Documentation of 'Notification'</b>:
     *
     * If the meaning of "Notification" isn't clear, then there should be a description here.
     */
    ::std::string& getNotificationMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendNotificationUpdate().
     *
     * <b>Documentation of 'Notification'</b>:
     *
     * If the meaning of "Notification" isn't clear, then there should be a description here.
     */
    void sendNotificationUpdate();

    // method 'SetFolder'

    /**
     * The method onSetFolder() is called by ASF when a client invokes the
     * method 'SetFolder'. A subclass has to implement this method and send
     * back a response to the client either with the sendSetFolder() or
     * sendSetFolderError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'SetFolder'</b>:
     *
     * If the meaning of "SetFolder" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onSetFolderRequest (const ::boost::shared_ptr< SetFolderRequest >& request) = 0;

    /**
     * The method sendSetFolderResponse() sends a response of a previous
     * method invocation of 'SetFolder' back to the client.
     *
     * <b>Documentation of 'SetFolder'</b>:
     *
     * If the meaning of "SetFolder" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onSetFolder(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendSetFolderResponse (act_t act = 0);

    /**
     * The method sendSetFolderError() sends an error response of a previous
     * method invocation of 'SetFolder' back to the client.
     *
     * <b>Documentation of 'SetFolder'</b>:
     *
     * If the meaning of "SetFolder" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onSetFolder(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendSetFolderError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'ListFolders'

    /**
     * The method onListFolders() is called by ASF when a client invokes the
     * method 'ListFolders'. A subclass has to implement this method and send
     * back a response to the client either with the sendListFolders() or
     * sendListFoldersError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'ListFolders'</b>:
     *
     * If the meaning of "ListFolders" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onListFoldersRequest (const ::boost::shared_ptr< ListFoldersRequest >& request) = 0;

    /**
     * The method sendListFoldersResponse() sends a response of a previous
     * method invocation of 'ListFolders' back to the client.
     *
     * <b>Documentation of 'ListFolders'</b>:
     *
     * If the meaning of "ListFolders" isn't clear, then there should be a description here.
     *
     * @param folderList If the meaning of "folderList" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onListFolders(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendListFoldersResponse (const ::std::vector< ::std::map< ::std::string, ::asf::dbus::DBusVariant > >& folderList, act_t act = 0);

    /**
     * The method sendListFoldersError() sends an error response of a previous
     * method invocation of 'ListFolders' back to the client.
     *
     * <b>Documentation of 'ListFolders'</b>:
     *
     * If the meaning of "ListFolders" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onListFolders(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendListFoldersError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'ListFilterFields'

    /**
     * The method onListFilterFields() is called by ASF when a client invokes
     * the method 'ListFilterFields'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendListFilterFields() or sendListFilterFieldsError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'ListFilterFields'</b>:
     *
     * If the meaning of "ListFilterFields" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onListFilterFieldsRequest (const ::boost::shared_ptr< ListFilterFieldsRequest >& request) = 0;

    /**
     * The method sendListFilterFieldsResponse() sends a response of a
     * previous method invocation of 'ListFilterFields' back to the client.
     *
     * <b>Documentation of 'ListFilterFields'</b>:
     *
     * If the meaning of "ListFilterFields" isn't clear, then there should be a description here.
     *
     * @param fields If the meaning of "fields" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onListFilterFields(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendListFilterFieldsResponse (const ::std::vector< ::std::string >& fields, act_t act = 0);

    /**
     * The method sendListFilterFieldsError() sends an error response of a
     * previous method invocation of 'ListFilterFields' back to the client.
     *
     * <b>Documentation of 'ListFilterFields'</b>:
     *
     * If the meaning of "ListFilterFields" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onListFilterFields(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendListFilterFieldsError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'ListMessages'

    /**
     * The method onListMessages() is called by ASF when a client invokes the
     * method 'ListMessages'. A subclass has to implement this method and send
     * back a response to the client either with the sendListMessages() or
     * sendListMessagesError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'ListMessages'</b>:
     *
     * If the meaning of "ListMessages" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onListMessagesRequest (const ::boost::shared_ptr< ListMessagesRequest >& request) = 0;

    /**
     * The method sendListMessagesResponse() sends a response of a previous
     * method invocation of 'ListMessages' back to the client.
     *
     * <b>Documentation of 'ListMessages'</b>:
     *
     * If the meaning of "ListMessages" isn't clear, then there should be a description here.
     *
     * @param messages If the meaning of "messages" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onListMessages(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendListMessagesResponse (const ::std::map< ::std::string, ::std::map< ::std::string, ::asf::dbus::DBusVariant > >& messages, act_t act = 0);

    /**
     * The method sendListMessagesError() sends an error response of a
     * previous method invocation of 'ListMessages' back to the client.
     *
     * <b>Documentation of 'ListMessages'</b>:
     *
     * If the meaning of "ListMessages" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onListMessages(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendListMessagesError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'PushMessage'

    /**
     * The method onPushMessage() is called by ASF when a client invokes the
     * method 'PushMessage'. A subclass has to implement this method and send
     * back a response to the client either with the sendPushMessage() or
     * sendPushMessageError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'PushMessage'</b>:
     *
     * If the meaning of "PushMessage" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onPushMessageRequest (const ::boost::shared_ptr< PushMessageRequest >& request) = 0;

    /**
     * The method sendPushMessageResponse() sends a response of a previous
     * method invocation of 'PushMessage' back to the client.
     *
     * <b>Documentation of 'PushMessage'</b>:
     *
     * If the meaning of "PushMessage" isn't clear, then there should be a description here.
     *
     * @param transfer If the meaning of "transfer" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onPushMessage(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendPushMessageResponse (const ::std::string& transfer, act_t act = 0);

    /**
     * The method sendPushMessageError() sends an error response of a previous
     * method invocation of 'PushMessage' back to the client.
     *
     * <b>Documentation of 'PushMessage'</b>:
     *
     * If the meaning of "PushMessage" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onPushMessage(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendPushMessageError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'UpdateInbox'

    /**
     * The method onUpdateInbox() is called by ASF when a client invokes the
     * method 'UpdateInbox'. A subclass has to implement this method and send
     * back a response to the client either with the sendUpdateInbox() or
     * sendUpdateInboxError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'UpdateInbox'</b>:
     *
     * If the meaning of "UpdateInbox" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onUpdateInboxRequest (const ::boost::shared_ptr< UpdateInboxRequest >& request) = 0;

    /**
     * The method sendUpdateInboxResponse() sends a response of a previous
     * method invocation of 'UpdateInbox' back to the client.
     *
     * <b>Documentation of 'UpdateInbox'</b>:
     *
     * If the meaning of "UpdateInbox" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onUpdateInbox(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendUpdateInboxResponse (act_t act = 0);

    /**
     * The method sendUpdateInboxError() sends an error response of a previous
     * method invocation of 'UpdateInbox' back to the client.
     *
     * <b>Documentation of 'UpdateInbox'</b>:
     *
     * If the meaning of "UpdateInbox" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onUpdateInbox(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendUpdateInboxError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'NotificationRegistry'

    /**
     * The method onNotificationRegistry() is called by ASF when a client
     * invokes the method 'NotificationRegistry'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendNotificationRegistry() or sendNotificationRegistryError() method.
     * Do not invoke this method on your own.
     *
     * <b>Documentation of 'NotificationRegistry'</b>:
     *
     * If the meaning of "NotificationRegistry" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onNotificationRegistryRequest (const ::boost::shared_ptr< NotificationRegistryRequest >& request) = 0;

    /**
     * The method sendNotificationRegistryResponse() sends a response of a
     * previous method invocation of 'NotificationRegistry' back to the
     * client.
     *
     * <b>Documentation of 'NotificationRegistry'</b>:
     *
     * If the meaning of "NotificationRegistry" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onNotificationRegistry(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendNotificationRegistryResponse (act_t act = 0);

    /**
     * The method sendNotificationRegistryError() sends an error response of a
     * previous method invocation of 'NotificationRegistry' back to the
     * client.
     *
     * <b>Documentation of 'NotificationRegistry'</b>:
     *
     * If the meaning of "NotificationRegistry" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onNotificationRegistry(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendNotificationRegistryError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

private:
    void onGetAll(std::map<std::basic_string<char>, ::asf::dbus::DBusVariant>&) const;

    NotificationUpdate _NotificationProperty;

    friend class MessageAccessStubDelegate;

    DECLARE_CLASS_LOGGER();
};

} // namespace MessageAccess
} // namespace obex
} // namespace bluez
} // namespace org

#endif // ORG_BLUEZ_OBEX_MESSAGEACCESSSTUB_H
