/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/Types.h"
#include "asf/dbus/DBusAssert.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DBusVariant.h"
#include "asf/dbus/DBusVariantDBus.h"
#include "org/bluez/obex/MessageAccess.h"
#include "org/bluez/obex/MessageAccessDBus.h"
#include <dbus/dbus.h>
#include <map>
#include <string>
#include <vector>

static ::asf::core::Logger& _logger =  ::asf::core::Logger::_systemLogger;


// D-Bus serialize and deserialize functions of SetFolderRequest

void serializeDBus (const ::org::bluez::obex::MessageAccess::SetFolderRequest& in, DBusMessageIter* out) {
    const char* o0 = in.getName().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o0));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bluez::obex::MessageAccess::SetFolderRequest& out) {
    {
        ::std::string nameValue;
        ::std::string &nameTmpValue = nameValue;
        {
            char* o1 = 0;
            dbus_message_iter_get_basic(in, &o1);
            nameTmpValue.assign (o1);
        }
        out.setName(nameValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ListFoldersRequest

void serializeDBus (const ::org::bluez::obex::MessageAccess::ListFoldersRequest& in, DBusMessageIter* out) {
    DBusMessageIter o2ArrayIter;
    DBusMessageIter o3DictIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "{sv}", &o2ArrayIter));
    const ::std::map< ::std::string, ::asf::dbus::DBusVariant >* o4 = &in.getFilter();
    ::std::map< ::std::string, ::asf::dbus::DBusVariant >::const_iterator o5 = o4->end();
    for (::std::map< ::std::string, ::asf::dbus::DBusVariant >::const_iterator o6 = o4->begin(); o6 != o5; ++o6) {
        DBUS_ASSERT(dbus_message_iter_open_container(&o2ArrayIter, DBUS_TYPE_DICT_ENTRY, 0, &o3DictIter));
        const char* o7 = o6->first.c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o3DictIter, DBUS_TYPE_STRING, &o7));
        serializeDBus(o6->second, &o3DictIter);
        DBUS_ASSERT(dbus_message_iter_close_container(&o2ArrayIter, &o3DictIter)); // close dict container
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o2ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bluez::obex::MessageAccess::ListFoldersRequest& out) {
    {
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > filterValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o8ArrayIter;
            DBusMessageIter o9DictIter;
            dbus_message_iter_recurse (in, &o8ArrayIter);

            if (dbus_message_iter_get_arg_type(&o8ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::std::string o10Key;
                    ::asf::dbus::DBusVariant o10Value;
                    dbus_message_iter_recurse (&o8ArrayIter, &o9DictIter);
                    {
                        char* o11 = 0;
                        dbus_message_iter_get_basic(&o9DictIter, &o11);
                        o10Key.assign (o11);
                    }
                    dbus_message_iter_next(&o9DictIter);
                    {
                        DBusMessageIter o12;
                        char* signature = dbus_message_iter_get_signature(&o9DictIter);

                        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
                            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(&o9DictIter)) {
                                dbus_message_iter_recurse (&o9DictIter, &o12);

                                if (!deserializeDBus(&o12, o10Value)) {
                                    dbus_free(signature);
                                    return false;
                                }
                            }
                        }
                        dbus_free(signature);
                    }
                    filterValue.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant >(o10Key, o10Value));
                } while (dbus_message_iter_next(&o8ArrayIter));
            }
        }
        out.setFilter(filterValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ListFoldersResponse

void serializeDBus (const ::org::bluez::obex::MessageAccess::ListFoldersResponse& in, DBusMessageIter* out) {
    DBusMessageIter o13ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "a{sv}", &o13ArrayIter));
    const ::std::vector< ::std::map< ::std::string, ::asf::dbus::DBusVariant > >* o14 = &in.getFolderList();
    ::std::vector< ::std::map< ::std::string, ::asf::dbus::DBusVariant > >::const_iterator o15 = o14->end();
    for (::std::vector< ::std::map< ::std::string, ::asf::dbus::DBusVariant > >::const_iterator o16 = o14->begin(); o16 != o15; ++o16) {
        DBusMessageIter o17ArrayIter;
        DBusMessageIter o18DictIter;
        DBUS_ASSERT(dbus_message_iter_open_container(&o13ArrayIter, DBUS_TYPE_ARRAY, "{sv}", &o17ArrayIter));
        const ::std::map< ::std::string, ::asf::dbus::DBusVariant >* o19 = &(*o16);
        ::std::map< ::std::string, ::asf::dbus::DBusVariant >::const_iterator o20 = o19->end();
        for (::std::map< ::std::string, ::asf::dbus::DBusVariant >::const_iterator o21 = o19->begin(); o21 != o20; ++o21) {
            DBUS_ASSERT(dbus_message_iter_open_container(&o17ArrayIter, DBUS_TYPE_DICT_ENTRY, 0, &o18DictIter));
            const char* o22 = o21->first.c_str();
            DBUS_ASSERT(dbus_message_iter_append_basic(&o18DictIter, DBUS_TYPE_STRING, &o22));
            serializeDBus(o21->second, &o18DictIter);
            DBUS_ASSERT(dbus_message_iter_close_container(&o17ArrayIter, &o18DictIter)); // close dict container
        }
        DBUS_ASSERT(dbus_message_iter_close_container(&o13ArrayIter, &o17ArrayIter));
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o13ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bluez::obex::MessageAccess::ListFoldersResponse& out) {
    {
        ::std::vector< ::std::map< ::std::string, ::asf::dbus::DBusVariant > > folderListValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o23ArrayIter;
            dbus_message_iter_recurse (in, &o23ArrayIter);

            if(dbus_message_iter_get_arg_type(&o23ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::std::map< ::std::string, ::asf::dbus::DBusVariant > o24;

                    if (dbus_message_iter_get_arg_type(&o23ArrayIter) != DBUS_TYPE_INVALID) {
                        DBusMessageIter o25ArrayIter;
                        DBusMessageIter o26DictIter;
                        dbus_message_iter_recurse (&o23ArrayIter, &o25ArrayIter);

                        if (dbus_message_iter_get_arg_type(&o25ArrayIter) != DBUS_TYPE_INVALID) {
                            do {
                                ::std::string o27Key;
                                ::asf::dbus::DBusVariant o27Value;
                                dbus_message_iter_recurse (&o25ArrayIter, &o26DictIter);
                                {
                                    char* o28 = 0;
                                    dbus_message_iter_get_basic(&o26DictIter, &o28);
                                    o27Key.assign (o28);
                                }
                                dbus_message_iter_next(&o26DictIter);
                                {
                                    DBusMessageIter o29;
                                    char* signature = dbus_message_iter_get_signature(&o26DictIter);

                                    if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
                                        if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(&o26DictIter)) {
                                            dbus_message_iter_recurse (&o26DictIter, &o29);

                                            if (!deserializeDBus(&o29, o27Value)) {
                                                dbus_free(signature);
                                                return false;
                                            }
                                        }
                                    }
                                    dbus_free(signature);
                                }
                                o24.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant >(o27Key, o27Value));
                            } while (dbus_message_iter_next(&o25ArrayIter));
                        }
                    }
                    folderListValue.push_back(o24);
                } while (dbus_message_iter_next(&o23ArrayIter));
            }
        }
        out.setFolderList(folderListValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ListFilterFieldsResponse

void serializeDBus (const ::org::bluez::obex::MessageAccess::ListFilterFieldsResponse& in, DBusMessageIter* out) {
    DBusMessageIter o30ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "s", &o30ArrayIter));
    const ::std::vector< ::std::string >* o31 = &in.getFields();
    ::std::vector< ::std::string >::const_iterator o32 = o31->end();
    for (::std::vector< ::std::string >::const_iterator o33 = o31->begin(); o33 != o32; ++o33) {
        const char* o34 = (*o33).c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o30ArrayIter, DBUS_TYPE_STRING, &o34));
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o30ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bluez::obex::MessageAccess::ListFilterFieldsResponse& out) {
    {
        ::std::vector< ::std::string > fieldsValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o35ArrayIter;
            dbus_message_iter_recurse (in, &o35ArrayIter);

            if(dbus_message_iter_get_arg_type(&o35ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::std::string o36;
                    {
                        char* o37 = 0;
                        dbus_message_iter_get_basic(&o35ArrayIter, &o37);
                        o36.assign (o37);
                    }
                    fieldsValue.push_back(o36);
                } while (dbus_message_iter_next(&o35ArrayIter));
            }
        }
        out.setFields(fieldsValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ListMessagesRequest

void serializeDBus (const ::org::bluez::obex::MessageAccess::ListMessagesRequest& in, DBusMessageIter* out) {
    const char* o38 = in.getFolder().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o38));
    DBusMessageIter o39ArrayIter;
    DBusMessageIter o40DictIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "{sv}", &o39ArrayIter));
    const ::std::map< ::std::string, ::asf::dbus::DBusVariant >* o41 = &in.getFilter();
    ::std::map< ::std::string, ::asf::dbus::DBusVariant >::const_iterator o42 = o41->end();
    for (::std::map< ::std::string, ::asf::dbus::DBusVariant >::const_iterator o43 = o41->begin(); o43 != o42; ++o43) {
        DBUS_ASSERT(dbus_message_iter_open_container(&o39ArrayIter, DBUS_TYPE_DICT_ENTRY, 0, &o40DictIter));
        const char* o44 = o43->first.c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o40DictIter, DBUS_TYPE_STRING, &o44));
        serializeDBus(o43->second, &o40DictIter);
        DBUS_ASSERT(dbus_message_iter_close_container(&o39ArrayIter, &o40DictIter)); // close dict container
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o39ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bluez::obex::MessageAccess::ListMessagesRequest& out) {
    {
        ::std::string folderValue;
        ::std::string &folderTmpValue = folderValue;
        {
            char* o45 = 0;
            dbus_message_iter_get_basic(in, &o45);
            folderTmpValue.assign (o45);
        }
        out.setFolder(folderValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > filterValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o46ArrayIter;
            DBusMessageIter o47DictIter;
            dbus_message_iter_recurse (in, &o46ArrayIter);

            if (dbus_message_iter_get_arg_type(&o46ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::std::string o48Key;
                    ::asf::dbus::DBusVariant o48Value;
                    dbus_message_iter_recurse (&o46ArrayIter, &o47DictIter);
                    {
                        char* o49 = 0;
                        dbus_message_iter_get_basic(&o47DictIter, &o49);
                        o48Key.assign (o49);
                    }
                    dbus_message_iter_next(&o47DictIter);
                    {
                        DBusMessageIter o50;
                        char* signature = dbus_message_iter_get_signature(&o47DictIter);

                        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
                            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(&o47DictIter)) {
                                dbus_message_iter_recurse (&o47DictIter, &o50);

                                if (!deserializeDBus(&o50, o48Value)) {
                                    dbus_free(signature);
                                    return false;
                                }
                            }
                        }
                        dbus_free(signature);
                    }
                    filterValue.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant >(o48Key, o48Value));
                } while (dbus_message_iter_next(&o46ArrayIter));
            }
        }
        out.setFilter(filterValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ListMessagesResponse

void serializeDBus (const ::org::bluez::obex::MessageAccess::ListMessagesResponse& in, DBusMessageIter* out) {
    DBusMessageIter o51ArrayIter;
    DBusMessageIter o52DictIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "{oa{sv}}", &o51ArrayIter));
    const ::std::map< ::std::string, ::std::map< ::std::string, ::asf::dbus::DBusVariant > >* o53 = &in.getMessages();
    ::std::map< ::std::string, ::std::map< ::std::string, ::asf::dbus::DBusVariant > >::const_iterator o54 = o53->end();
    for (::std::map< ::std::string, ::std::map< ::std::string, ::asf::dbus::DBusVariant > >::const_iterator o55 = o53->begin(); o55 != o54; ++o55) {
        DBUS_ASSERT(dbus_message_iter_open_container(&o51ArrayIter, DBUS_TYPE_DICT_ENTRY, 0, &o52DictIter));
        DBUS_ASSERT(::asf::dbus::DBusUtils::isObjectPathValid(std::string(o55->first)));
        DBUS_ASSERT(dbus_message_iter_append_basic(&o52DictIter, DBUS_TYPE_OBJECT_PATH, &o55->first));
        DBusMessageIter o56ArrayIter;
        DBusMessageIter o57DictIter;
        DBUS_ASSERT(dbus_message_iter_open_container(&o52DictIter, DBUS_TYPE_ARRAY, "{sv}", &o56ArrayIter));
        const ::std::map< ::std::string, ::asf::dbus::DBusVariant >* o58 = &o55->second;
        ::std::map< ::std::string, ::asf::dbus::DBusVariant >::const_iterator o59 = o58->end();
        for (::std::map< ::std::string, ::asf::dbus::DBusVariant >::const_iterator o60 = o58->begin(); o60 != o59; ++o60) {
            DBUS_ASSERT(dbus_message_iter_open_container(&o56ArrayIter, DBUS_TYPE_DICT_ENTRY, 0, &o57DictIter));
            const char* o61 = o60->first.c_str();
            DBUS_ASSERT(dbus_message_iter_append_basic(&o57DictIter, DBUS_TYPE_STRING, &o61));
            serializeDBus(o60->second, &o57DictIter);
            DBUS_ASSERT(dbus_message_iter_close_container(&o56ArrayIter, &o57DictIter)); // close dict container
        }
        DBUS_ASSERT(dbus_message_iter_close_container(&o52DictIter, &o56ArrayIter));
        DBUS_ASSERT(dbus_message_iter_close_container(&o51ArrayIter, &o52DictIter)); // close dict container
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o51ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bluez::obex::MessageAccess::ListMessagesResponse& out) {
    {
        ::std::map< ::std::string, ::std::map< ::std::string, ::asf::dbus::DBusVariant > > messagesValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o62ArrayIter;
            DBusMessageIter o63DictIter;
            dbus_message_iter_recurse (in, &o62ArrayIter);

            if (dbus_message_iter_get_arg_type(&o62ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::std::string o64Key;
                    ::std::map< ::std::string, ::asf::dbus::DBusVariant > o64Value;
                    dbus_message_iter_recurse (&o62ArrayIter, &o63DictIter);
                    {
                        char* o65 = 0;
                        dbus_message_iter_get_basic(&o63DictIter, &o65);
                        o64Key.assign (o65);
                    }
                    dbus_message_iter_next(&o63DictIter);

                    if (dbus_message_iter_get_arg_type(&o63DictIter) != DBUS_TYPE_INVALID) {
                        DBusMessageIter o66ArrayIter;
                        DBusMessageIter o67DictIter;
                        dbus_message_iter_recurse (&o63DictIter, &o66ArrayIter);

                        if (dbus_message_iter_get_arg_type(&o66ArrayIter) != DBUS_TYPE_INVALID) {
                            do {
                                ::std::string o68Key;
                                ::asf::dbus::DBusVariant o68Value;
                                dbus_message_iter_recurse (&o66ArrayIter, &o67DictIter);
                                {
                                    char* o69 = 0;
                                    dbus_message_iter_get_basic(&o67DictIter, &o69);
                                    o68Key.assign (o69);
                                }
                                dbus_message_iter_next(&o67DictIter);
                                {
                                    DBusMessageIter o70;
                                    char* signature = dbus_message_iter_get_signature(&o67DictIter);

                                    if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
                                        if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(&o67DictIter)) {
                                            dbus_message_iter_recurse (&o67DictIter, &o70);

                                            if (!deserializeDBus(&o70, o68Value)) {
                                                dbus_free(signature);
                                                return false;
                                            }
                                        }
                                    }
                                    dbus_free(signature);
                                }
                                o64Value.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant >(o68Key, o68Value));
                            } while (dbus_message_iter_next(&o66ArrayIter));
                        }
                    }
                    messagesValue.insert(std::pair< ::std::string, ::std::map< ::std::string, ::asf::dbus::DBusVariant > >(o64Key, o64Value));
                } while (dbus_message_iter_next(&o62ArrayIter));
            }
        }
        out.setMessages(messagesValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of PushMessageRequest

void serializeDBus (const ::org::bluez::obex::MessageAccess::PushMessageRequest& in, DBusMessageIter* out) {
    const char* o71 = in.getSourcefile().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o71));
    const char* o72 = in.getFolder().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o72));
    DBusMessageIter o73ArrayIter;
    DBusMessageIter o74DictIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "{sv}", &o73ArrayIter));
    const ::std::map< ::std::string, ::asf::dbus::DBusVariant >* o75 = &in.getArgs();
    ::std::map< ::std::string, ::asf::dbus::DBusVariant >::const_iterator o76 = o75->end();
    for (::std::map< ::std::string, ::asf::dbus::DBusVariant >::const_iterator o77 = o75->begin(); o77 != o76; ++o77) {
        DBUS_ASSERT(dbus_message_iter_open_container(&o73ArrayIter, DBUS_TYPE_DICT_ENTRY, 0, &o74DictIter));
        const char* o78 = o77->first.c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o74DictIter, DBUS_TYPE_STRING, &o78));
        serializeDBus(o77->second, &o74DictIter);
        DBUS_ASSERT(dbus_message_iter_close_container(&o73ArrayIter, &o74DictIter)); // close dict container
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o73ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bluez::obex::MessageAccess::PushMessageRequest& out) {
    {
        ::std::string sourcefileValue;
        ::std::string &sourcefileTmpValue = sourcefileValue;
        {
            char* o79 = 0;
            dbus_message_iter_get_basic(in, &o79);
            sourcefileTmpValue.assign (o79);
        }
        out.setSourcefile(sourcefileValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::string folderValue;
        ::std::string &folderTmpValue = folderValue;
        {
            char* o80 = 0;
            dbus_message_iter_get_basic(in, &o80);
            folderTmpValue.assign (o80);
        }
        out.setFolder(folderValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > argsValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o81ArrayIter;
            DBusMessageIter o82DictIter;
            dbus_message_iter_recurse (in, &o81ArrayIter);

            if (dbus_message_iter_get_arg_type(&o81ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::std::string o83Key;
                    ::asf::dbus::DBusVariant o83Value;
                    dbus_message_iter_recurse (&o81ArrayIter, &o82DictIter);
                    {
                        char* o84 = 0;
                        dbus_message_iter_get_basic(&o82DictIter, &o84);
                        o83Key.assign (o84);
                    }
                    dbus_message_iter_next(&o82DictIter);
                    {
                        DBusMessageIter o85;
                        char* signature = dbus_message_iter_get_signature(&o82DictIter);

                        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
                            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(&o82DictIter)) {
                                dbus_message_iter_recurse (&o82DictIter, &o85);

                                if (!deserializeDBus(&o85, o83Value)) {
                                    dbus_free(signature);
                                    return false;
                                }
                            }
                        }
                        dbus_free(signature);
                    }
                    argsValue.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant >(o83Key, o83Value));
                } while (dbus_message_iter_next(&o81ArrayIter));
            }
        }
        out.setArgs(argsValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of PushMessageResponse

void serializeDBus (const ::org::bluez::obex::MessageAccess::PushMessageResponse& in, DBusMessageIter* out) {
    DBUS_ASSERT(::asf::dbus::DBusUtils::isObjectPathValid(std::string(in.getTransfer())));
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_OBJECT_PATH, &in.getTransfer()));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bluez::obex::MessageAccess::PushMessageResponse& out) {
    {
        ::std::string transferValue;
        ::std::string &transferTmpValue = transferValue;
        {
            char* o86 = 0;
            dbus_message_iter_get_basic(in, &o86);
            transferTmpValue.assign (o86);
        }
        out.setTransfer(transferValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of NotificationRegistryRequest

void serializeDBus (const ::org::bluez::obex::MessageAccess::NotificationRegistryRequest& in, DBusMessageIter* out) {
    dbus_bool_t o87 = in.getAction() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o87));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bluez::obex::MessageAccess::NotificationRegistryRequest& out) {
    {
        bool actionValue;
        bool &actionTmpValue = actionValue;
        {
            dbus_bool_t o88;
            dbus_message_iter_get_basic(in, &o88);
            actionTmpValue = o88 ? true : false;
        }
        out.setAction(actionValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of NotificationUpdate

void serializeDBus (const ::org::bluez::obex::MessageAccess::NotificationUpdate& in, DBusMessageIter* out) {
    const char* o89 = in.getNotification().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o89));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bluez::obex::MessageAccess::NotificationUpdate& out) {
    {
        ::std::string NotificationValue;
        ::std::string &NotificationTmpValue = NotificationValue;
        {
            char* o90 = 0;
            dbus_message_iter_get_basic(in, &o90);
            NotificationTmpValue.assign (o90);
        }
        out.setNotification(NotificationValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of NotificationRegister

void serializeDBus (const ::org::bluez::obex::MessageAccess::NotificationRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bluez::obex::MessageAccess::NotificationRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of NewMessageNotificationSignal

void serializeDBus (const ::org::bluez::obex::MessageAccess::NewMessageNotificationSignal& in, DBusMessageIter* out) {
    DBusMessageIter o91ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "y", &o91ArrayIter));
    const ::std::vector< uint8 >* o92 = &in.getData();
    ::std::vector< uint8 >::const_iterator o93 = o92->end();
    for (::std::vector< uint8 >::const_iterator o94 = o92->begin(); o94 != o93; ++o94) {
        DBUS_ASSERT(dbus_message_iter_append_basic(&o91ArrayIter, DBUS_TYPE_BYTE, &(*o94)));
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o91ArrayIter));
    DBUS_ASSERT(::asf::dbus::DBusUtils::isObjectPathValid(std::string(in.getPath())));
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_OBJECT_PATH, &in.getPath()));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bluez::obex::MessageAccess::NewMessageNotificationSignal& out) {
    {
        ::std::vector< uint8 > dataValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o95ArrayIter;
            dbus_message_iter_recurse (in, &o95ArrayIter);

            if(dbus_message_iter_get_arg_type(&o95ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    uint8 o96;
                    dbus_message_iter_get_basic(&o95ArrayIter, &o96);
                    dataValue.push_back(o96);
                } while (dbus_message_iter_next(&o95ArrayIter));
            }
        }
        out.setData(dataValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::string pathValue;
        ::std::string &pathTmpValue = pathValue;
        {
            char* o97 = 0;
            dbus_message_iter_get_basic(in, &o97);
            pathTmpValue.assign (o97);
        }
        out.setPath(pathValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

