#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_BLUEZ_OBEX_MESSAGEACCESS_H
#define ORG_BLUEZ_OBEX_MESSAGEACCESS_H

#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "asf/dbus/DBusTypes.h"
#include "asf/dbus/DBusVariant.h"
#include <cstddef>
#include <cstring>
#include <map>
#include <string>
#include <vector>

/**
 * If the meaning of "MessageAccess" isn't clear, then there should be a description here.
 */

namespace org {
namespace bluez {
namespace obex {
namespace MessageAccess {

// method IDs
static const uint16 ID_SetFolder = 0;
static const uint16 ID_ListFolders = 1;
static const uint16 ID_ListFilterFields = 2;
static const uint16 ID_ListMessages = 3;
static const uint16 ID_PushMessage = 4;
static const uint16 ID_UpdateInbox = 5;
static const uint16 ID_NotificationRegistry = 6;

// signal IDs
static const uint16 ID_NewMessageNotification = 7;

// property IDs
static const uint16 ID_Notification = 8;

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class SetFolderRequest;

class ListFoldersRequest;

class ListFoldersResponse;

class ListFilterFieldsResponse;

class ListMessagesRequest;

class ListMessagesResponse;

class PushMessageRequest;

class PushMessageResponse;

class NotificationRegistryRequest;

class NotificationUpdate;

class NotificationRegister;

class NewMessageNotificationSignal;

// type definitions
/**
 * If the meaning of "SetFolderResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage SetFolderResponse;

/**
 * If the meaning of "SetFolderError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SetFolderError;

/**
 * If the meaning of "ListFoldersError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ListFoldersError;

/**
 * If the meaning of "ListFilterFieldsRequest" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage ListFilterFieldsRequest;

/**
 * If the meaning of "ListFilterFieldsError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ListFilterFieldsError;

/**
 * If the meaning of "ListMessagesError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ListMessagesError;

/**
 * If the meaning of "PushMessageError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError PushMessageError;

/**
 * If the meaning of "UpdateInboxRequest" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage UpdateInboxRequest;

/**
 * If the meaning of "UpdateInboxResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage UpdateInboxResponse;

/**
 * If the meaning of "UpdateInboxError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError UpdateInboxError;

/**
 * If the meaning of "NotificationRegistryResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage NotificationRegistryResponse;

/**
 * If the meaning of "NotificationRegistryError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError NotificationRegistryError;

/**
 * If the meaning of "NotificationSet" isn't clear, then there should be a description here.
 */
typedef NotificationUpdate NotificationSet;

/**
 * If the meaning of "NotificationGet" isn't clear, then there should be a description here.
 */
typedef NotificationUpdate NotificationGet;

/**
 * If the meaning of "NotificationError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError NotificationError;

/**
 * If the meaning of "NewMessageNotificationError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError NewMessageNotificationError;


/**
 * If the meaning of "SetFolderRequest" isn't clear, then there should be a description here.
 */
class SetFolderRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetFolderRequest ();

    /**
     * Copy constructor
     */
    inline  SetFolderRequest (const SetFolderRequest &rhs);

    /**
     * All fields constructor
     */
    inline  SetFolderRequest (const ::std::string& name_);

    /**
     * Destructor
     */
    inline virtual  ~SetFolderRequest();

    /**
     * Assignment operator
     */
    inline SetFolderRequest& operator = (const SetFolderRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetFolderRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetFolderRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetFolderRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetFolderRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "name"

    static const int kName = 0;

    /**
     * Clears the field "name".
     *
     * The field will be set to its default value. The hasName()
     * method will return false.
     */
    inline void clearName();

    /**
     * Checks whether the field "name" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setName()). Otherwise it will return false.
     */
    inline bool hasName () const;

    /**
     * Returns the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @return The value of the field "name"
     */
    inline const ::std::string& getName () const;

    /**
     * Retrieves the value of the field "name" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "name".
     */
    inline ::std::string& getNameMutable ();

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const ::std::string& name_);

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const char* name_);

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const char* value, size_t size);

    static const SetFolderRequest &getDefaultInstance();

private:

    inline void set_has_name ();

    inline void clear_has_name ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _name;

};

/**
 * If the meaning of "ListFoldersRequest" isn't clear, then there should be a description here.
 */
class ListFoldersRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ListFoldersRequest ();

    /**
     * Copy constructor
     */
    inline  ListFoldersRequest (const ListFoldersRequest &rhs);

    /**
     * All fields constructor
     */
    inline  ListFoldersRequest (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& filter_);

    /**
     * Destructor
     */
    inline virtual  ~ListFoldersRequest();

    /**
     * Assignment operator
     */
    inline ListFoldersRequest& operator = (const ListFoldersRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ListFoldersRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ListFoldersRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ListFoldersRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ListFoldersRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "filter"

    static const int kFilter = 0;

    /**
     * Clears the field "filter".
     *
     * The field will be set to its default value. The hasFilter()
     * method will return false.
     */
    inline void clearFilter();

    /**
     * Checks whether the field "filter" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFilter()). Otherwise it will return false.
     */
    inline bool hasFilter () const;

    /**
     * Returns the value of the member "filter".
     *
     * If the meaning of "filter" isn't clear, then there should be a description here.
     *
     * @return The value of the field "filter"
     */
    inline const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getFilter () const;

    /**
     * Retrieves the value of the field "filter" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "filter".
     */
    inline ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getFilterMutable ();

    /**
     * Sets the value of the member "filter".
     *
     * If the meaning of "filter" isn't clear, then there should be a description here.
     *
     * @param filter The value which will be set
     */
    inline void setFilter (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& filter_);

    static const ListFoldersRequest &getDefaultInstance();

private:

    static const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getStringTo__asf__dbus__DBusVariantMap_DefaultInstance ();

    inline void set_has_filter ();

    inline void clear_has_filter ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::map< ::std::string, ::asf::dbus::DBusVariant > _filter;

};

/**
 * If the meaning of "ListFoldersResponse" isn't clear, then there should be a description here.
 */
class ListFoldersResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ListFoldersResponse ();

    /**
     * Copy constructor
     */
    inline  ListFoldersResponse (const ListFoldersResponse &rhs);

    /**
     * All fields constructor
     */
    inline  ListFoldersResponse (const ::std::vector< ::std::map< ::std::string, ::asf::dbus::DBusVariant > >& folderList_);

    /**
     * Destructor
     */
    inline virtual  ~ListFoldersResponse();

    /**
     * Assignment operator
     */
    inline ListFoldersResponse& operator = (const ListFoldersResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ListFoldersResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ListFoldersResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ListFoldersResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ListFoldersResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "folderList"

    static const int kFolderList = 0;

    /**
     * Clears the field "folderList".
     *
     * The field will be set to its default value. The hasFolderList()
     * method will return false.
     */
    inline void clearFolderList();

    /**
     * Checks whether the field "folderList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFolderList()). Otherwise it will return false.
     */
    inline bool hasFolderList () const;

    /**
     * Returns the value of the member "folderList".
     *
     * If the meaning of "folderList" isn't clear, then there should be a description here.
     *
     * @return The value of the field "folderList"
     */
    inline const ::std::vector< ::std::map< ::std::string, ::asf::dbus::DBusVariant > >& getFolderList () const;

    /**
     * Retrieves the value of the field "folderList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "folderList".
     */
    inline ::std::vector< ::std::map< ::std::string, ::asf::dbus::DBusVariant > >& getFolderListMutable ();

    /**
     * Sets the value of the member "folderList".
     *
     * If the meaning of "folderList" isn't clear, then there should be a description here.
     *
     * @param folderList The value which will be set
     */
    inline void setFolderList (const ::std::vector< ::std::map< ::std::string, ::asf::dbus::DBusVariant > >& folderList_);

    static const ListFoldersResponse &getDefaultInstance();

private:

    static const ::std::vector< ::std::map< ::std::string, ::asf::dbus::DBusVariant > >& getStringTo__asf__dbus__DBusVariantMap_List_DefaultInstance ();

    inline void set_has_folderList ();

    inline void clear_has_folderList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::std::map< ::std::string, ::asf::dbus::DBusVariant > > _folderList;

};

/**
 * If the meaning of "ListFilterFieldsResponse" isn't clear, then there should be a description here.
 */
class ListFilterFieldsResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ListFilterFieldsResponse ();

    /**
     * Copy constructor
     */
    inline  ListFilterFieldsResponse (const ListFilterFieldsResponse &rhs);

    /**
     * All fields constructor
     */
    inline  ListFilterFieldsResponse (const ::std::vector< ::std::string >& fields_);

    /**
     * Destructor
     */
    inline virtual  ~ListFilterFieldsResponse();

    /**
     * Assignment operator
     */
    inline ListFilterFieldsResponse& operator = (const ListFilterFieldsResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ListFilterFieldsResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ListFilterFieldsResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ListFilterFieldsResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ListFilterFieldsResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "fields"

    static const int kFields = 0;

    /**
     * Clears the field "fields".
     *
     * The field will be set to its default value. The hasFields()
     * method will return false.
     */
    inline void clearFields();

    /**
     * Checks whether the field "fields" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFields()). Otherwise it will return false.
     */
    inline bool hasFields () const;

    /**
     * Returns the value of the member "fields".
     *
     * If the meaning of "fields" isn't clear, then there should be a description here.
     *
     * @return The value of the field "fields"
     */
    inline const ::std::vector< ::std::string >& getFields () const;

    /**
     * Retrieves the value of the field "fields" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "fields".
     */
    inline ::std::vector< ::std::string >& getFieldsMutable ();

    /**
     * Sets the value of the member "fields".
     *
     * If the meaning of "fields" isn't clear, then there should be a description here.
     *
     * @param fields The value which will be set
     */
    inline void setFields (const ::std::vector< ::std::string >& fields_);

    static const ListFilterFieldsResponse &getDefaultInstance();

private:

    static const ::std::vector< ::std::string >& getStringList_DefaultInstance ();

    inline void set_has_fields ();

    inline void clear_has_fields ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::std::string > _fields;

};

/**
 * If the meaning of "ListMessagesRequest" isn't clear, then there should be a description here.
 */
class ListMessagesRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ListMessagesRequest ();

    /**
     * Copy constructor
     */
    inline  ListMessagesRequest (const ListMessagesRequest &rhs);

    /**
     * All fields constructor
     */
    inline  ListMessagesRequest (const ::std::string& folder_, const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& filter_);

    /**
     * Destructor
     */
    inline virtual  ~ListMessagesRequest();

    /**
     * Assignment operator
     */
    inline ListMessagesRequest& operator = (const ListMessagesRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ListMessagesRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ListMessagesRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ListMessagesRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ListMessagesRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "folder"

    static const int kFolder = 0;

    /**
     * Clears the field "folder".
     *
     * The field will be set to its default value. The hasFolder()
     * method will return false.
     */
    inline void clearFolder();

    /**
     * Checks whether the field "folder" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFolder()). Otherwise it will return false.
     */
    inline bool hasFolder () const;

    /**
     * Returns the value of the member "folder".
     *
     * If the meaning of "folder" isn't clear, then there should be a description here.
     *
     * @return The value of the field "folder"
     */
    inline const ::std::string& getFolder () const;

    /**
     * Retrieves the value of the field "folder" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "folder".
     */
    inline ::std::string& getFolderMutable ();

    /**
     * Sets the value of the member "folder".
     *
     * If the meaning of "folder" isn't clear, then there should be a description here.
     *
     * @param folder The value which will be set
     */
    inline void setFolder (const ::std::string& folder_);

    /**
     * Sets the value of the member "folder".
     *
     * If the meaning of "folder" isn't clear, then there should be a description here.
     *
     * @param folder The value which will be set
     */
    inline void setFolder (const char* folder_);

    /**
     * Sets the value of the member "folder".
     *
     * If the meaning of "folder" isn't clear, then there should be a description here.
     *
     * @param folder The value which will be set
     */
    inline void setFolder (const char* value, size_t size);

    // API of field "filter"

    static const int kFilter = 1;

    /**
     * Clears the field "filter".
     *
     * The field will be set to its default value. The hasFilter()
     * method will return false.
     */
    inline void clearFilter();

    /**
     * Checks whether the field "filter" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFilter()). Otherwise it will return false.
     */
    inline bool hasFilter () const;

    /**
     * Returns the value of the member "filter".
     *
     * If the meaning of "filter" isn't clear, then there should be a description here.
     *
     * @return The value of the field "filter"
     */
    inline const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getFilter () const;

    /**
     * Retrieves the value of the field "filter" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "filter".
     */
    inline ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getFilterMutable ();

    /**
     * Sets the value of the member "filter".
     *
     * If the meaning of "filter" isn't clear, then there should be a description here.
     *
     * @param filter The value which will be set
     */
    inline void setFilter (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& filter_);

    static const ListMessagesRequest &getDefaultInstance();

private:

    static const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getStringTo__asf__dbus__DBusVariantMap_DefaultInstance ();

    inline void set_has_folder ();

    inline void clear_has_folder ();

    inline void set_has_filter ();

    inline void clear_has_filter ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _folder;

    ::std::map< ::std::string, ::asf::dbus::DBusVariant > _filter;

};

/**
 * If the meaning of "ListMessagesResponse" isn't clear, then there should be a description here.
 */
class ListMessagesResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ListMessagesResponse ();

    /**
     * Copy constructor
     */
    inline  ListMessagesResponse (const ListMessagesResponse &rhs);

    /**
     * All fields constructor
     */
    inline  ListMessagesResponse (const ::std::map< ::std::string, ::std::map< ::std::string, ::asf::dbus::DBusVariant > >& messages_);

    /**
     * Destructor
     */
    inline virtual  ~ListMessagesResponse();

    /**
     * Assignment operator
     */
    inline ListMessagesResponse& operator = (const ListMessagesResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ListMessagesResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ListMessagesResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ListMessagesResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ListMessagesResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "messages"

    static const int kMessages = 0;

    /**
     * Clears the field "messages".
     *
     * The field will be set to its default value. The hasMessages()
     * method will return false.
     */
    inline void clearMessages();

    /**
     * Checks whether the field "messages" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMessages()). Otherwise it will return false.
     */
    inline bool hasMessages () const;

    /**
     * Returns the value of the member "messages".
     *
     * If the meaning of "messages" isn't clear, then there should be a description here.
     *
     * @return The value of the field "messages"
     */
    inline const ::std::map< ::std::string, ::std::map< ::std::string, ::asf::dbus::DBusVariant > >& getMessages () const;

    /**
     * Retrieves the value of the field "messages" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "messages".
     */
    inline ::std::map< ::std::string, ::std::map< ::std::string, ::asf::dbus::DBusVariant > >& getMessagesMutable ();

    /**
     * Sets the value of the member "messages".
     *
     * If the meaning of "messages" isn't clear, then there should be a description here.
     *
     * @param messages The value which will be set
     */
    inline void setMessages (const ::std::map< ::std::string, ::std::map< ::std::string, ::asf::dbus::DBusVariant > >& messages_);

    static const ListMessagesResponse &getDefaultInstance();

private:

    static const ::std::map< ::std::string, ::std::map< ::std::string, ::asf::dbus::DBusVariant > >& getStringToStringTo__asf__dbus__DBusVariantMap_Map_DefaultInstance ();

    inline void set_has_messages ();

    inline void clear_has_messages ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::map< ::std::string, ::std::map< ::std::string, ::asf::dbus::DBusVariant > > _messages;

};

/**
 * If the meaning of "PushMessageRequest" isn't clear, then there should be a description here.
 */
class PushMessageRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PushMessageRequest ();

    /**
     * Copy constructor
     */
    inline  PushMessageRequest (const PushMessageRequest &rhs);

    /**
     * All fields constructor
     */
    inline  PushMessageRequest (const ::std::string& sourcefile_, const ::std::string& folder_, const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& args_);

    /**
     * Destructor
     */
    inline virtual  ~PushMessageRequest();

    /**
     * Assignment operator
     */
    inline PushMessageRequest& operator = (const PushMessageRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PushMessageRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PushMessageRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PushMessageRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PushMessageRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sourcefile"

    static const int kSourcefile = 0;

    /**
     * Clears the field "sourcefile".
     *
     * The field will be set to its default value. The hasSourcefile()
     * method will return false.
     */
    inline void clearSourcefile();

    /**
     * Checks whether the field "sourcefile" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSourcefile()). Otherwise it will return false.
     */
    inline bool hasSourcefile () const;

    /**
     * Returns the value of the member "sourcefile".
     *
     * If the meaning of "sourcefile" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sourcefile"
     */
    inline const ::std::string& getSourcefile () const;

    /**
     * Retrieves the value of the field "sourcefile" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sourcefile".
     */
    inline ::std::string& getSourcefileMutable ();

    /**
     * Sets the value of the member "sourcefile".
     *
     * If the meaning of "sourcefile" isn't clear, then there should be a description here.
     *
     * @param sourcefile The value which will be set
     */
    inline void setSourcefile (const ::std::string& sourcefile_);

    /**
     * Sets the value of the member "sourcefile".
     *
     * If the meaning of "sourcefile" isn't clear, then there should be a description here.
     *
     * @param sourcefile The value which will be set
     */
    inline void setSourcefile (const char* sourcefile_);

    /**
     * Sets the value of the member "sourcefile".
     *
     * If the meaning of "sourcefile" isn't clear, then there should be a description here.
     *
     * @param sourcefile The value which will be set
     */
    inline void setSourcefile (const char* value, size_t size);

    // API of field "folder"

    static const int kFolder = 1;

    /**
     * Clears the field "folder".
     *
     * The field will be set to its default value. The hasFolder()
     * method will return false.
     */
    inline void clearFolder();

    /**
     * Checks whether the field "folder" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFolder()). Otherwise it will return false.
     */
    inline bool hasFolder () const;

    /**
     * Returns the value of the member "folder".
     *
     * If the meaning of "folder" isn't clear, then there should be a description here.
     *
     * @return The value of the field "folder"
     */
    inline const ::std::string& getFolder () const;

    /**
     * Retrieves the value of the field "folder" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "folder".
     */
    inline ::std::string& getFolderMutable ();

    /**
     * Sets the value of the member "folder".
     *
     * If the meaning of "folder" isn't clear, then there should be a description here.
     *
     * @param folder The value which will be set
     */
    inline void setFolder (const ::std::string& folder_);

    /**
     * Sets the value of the member "folder".
     *
     * If the meaning of "folder" isn't clear, then there should be a description here.
     *
     * @param folder The value which will be set
     */
    inline void setFolder (const char* folder_);

    /**
     * Sets the value of the member "folder".
     *
     * If the meaning of "folder" isn't clear, then there should be a description here.
     *
     * @param folder The value which will be set
     */
    inline void setFolder (const char* value, size_t size);

    // API of field "args"

    static const int kArgs = 2;

    /**
     * Clears the field "args".
     *
     * The field will be set to its default value. The hasArgs()
     * method will return false.
     */
    inline void clearArgs();

    /**
     * Checks whether the field "args" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setArgs()). Otherwise it will return false.
     */
    inline bool hasArgs () const;

    /**
     * Returns the value of the member "args".
     *
     * If the meaning of "args" isn't clear, then there should be a description here.
     *
     * @return The value of the field "args"
     */
    inline const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getArgs () const;

    /**
     * Retrieves the value of the field "args" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "args".
     */
    inline ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getArgsMutable ();

    /**
     * Sets the value of the member "args".
     *
     * If the meaning of "args" isn't clear, then there should be a description here.
     *
     * @param args The value which will be set
     */
    inline void setArgs (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& args_);

    static const PushMessageRequest &getDefaultInstance();

private:

    static const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getStringTo__asf__dbus__DBusVariantMap_DefaultInstance ();

    inline void set_has_sourcefile ();

    inline void clear_has_sourcefile ();

    inline void set_has_folder ();

    inline void clear_has_folder ();

    inline void set_has_args ();

    inline void clear_has_args ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::std::string _sourcefile;

    ::std::string _folder;

    ::std::map< ::std::string, ::asf::dbus::DBusVariant > _args;

};

/**
 * If the meaning of "PushMessageResponse" isn't clear, then there should be a description here.
 */
class PushMessageResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PushMessageResponse ();

    /**
     * Copy constructor
     */
    inline  PushMessageResponse (const PushMessageResponse &rhs);

    /**
     * All fields constructor
     */
    inline  PushMessageResponse (const ::std::string& transfer_);

    /**
     * Destructor
     */
    inline virtual  ~PushMessageResponse();

    /**
     * Assignment operator
     */
    inline PushMessageResponse& operator = (const PushMessageResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PushMessageResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PushMessageResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PushMessageResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PushMessageResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "transfer"

    static const int kTransfer = 0;

    /**
     * Clears the field "transfer".
     *
     * The field will be set to its default value. The hasTransfer()
     * method will return false.
     */
    inline void clearTransfer();

    /**
     * Checks whether the field "transfer" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTransfer()). Otherwise it will return false.
     */
    inline bool hasTransfer () const;

    /**
     * Returns the value of the member "transfer".
     *
     * If the meaning of "transfer" isn't clear, then there should be a description here.
     *
     * @return The value of the field "transfer"
     */
    inline const ::std::string& getTransfer () const;

    /**
     * Retrieves the value of the field "transfer" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "transfer".
     */
    inline ::std::string& getTransferMutable ();

    /**
     * Sets the value of the member "transfer".
     *
     * If the meaning of "transfer" isn't clear, then there should be a description here.
     *
     * @param transfer The value which will be set
     */
    inline void setTransfer (const ::std::string& transfer_);

    /**
     * Sets the value of the member "transfer".
     *
     * If the meaning of "transfer" isn't clear, then there should be a description here.
     *
     * @param transfer The value which will be set
     */
    inline void setTransfer (const char* transfer_);

    /**
     * Sets the value of the member "transfer".
     *
     * If the meaning of "transfer" isn't clear, then there should be a description here.
     *
     * @param transfer The value which will be set
     */
    inline void setTransfer (const char* value, size_t size);

    static const PushMessageResponse &getDefaultInstance();

private:

    inline void set_has_transfer ();

    inline void clear_has_transfer ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _transfer;

};

/**
 * If the meaning of "NotificationRegistryRequest" isn't clear, then there should be a description here.
 */
class NotificationRegistryRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  NotificationRegistryRequest ();

    /**
     * Copy constructor
     */
    inline  NotificationRegistryRequest (const NotificationRegistryRequest &rhs);

    /**
     * All fields constructor
     */
    inline  NotificationRegistryRequest (bool action_);

    /**
     * Destructor
     */
    inline virtual  ~NotificationRegistryRequest();

    /**
     * Assignment operator
     */
    inline NotificationRegistryRequest& operator = (const NotificationRegistryRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const NotificationRegistryRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const NotificationRegistryRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const NotificationRegistryRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const NotificationRegistryRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "action"

    static const int kAction = 0;

    /**
     * Clears the field "action".
     *
     * The field will be set to its default value. The hasAction()
     * method will return false.
     */
    inline void clearAction();

    /**
     * Checks whether the field "action" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAction()). Otherwise it will return false.
     */
    inline bool hasAction () const;

    /**
     * Returns the value of the member "action".
     *
     * If the meaning of "action" isn't clear, then there should be a description here.
     *
     * @return The value of the field "action"
     */
    inline bool getAction () const;

    /**
     * Sets the value of the member "action".
     *
     * If the meaning of "action" isn't clear, then there should be a description here.
     *
     * @param action The value which will be set
     */
    inline void setAction (bool action_);

    static const NotificationRegistryRequest &getDefaultInstance();

private:

    inline void set_has_action ();

    inline void clear_has_action ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _action;

};

/**
 * If the meaning of "NotificationUpdate" isn't clear, then there should be a description here.
 */
class NotificationUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  NotificationUpdate ();

    /**
     * Copy constructor
     */
    inline  NotificationUpdate (const NotificationUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  NotificationUpdate (const ::std::string& Notification_);

    /**
     * Destructor
     */
    inline virtual  ~NotificationUpdate();

    /**
     * Assignment operator
     */
    inline NotificationUpdate& operator = (const NotificationUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const NotificationUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const NotificationUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const NotificationUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const NotificationUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Notification"

    static const int kNotification = 0;

    /**
     * Clears the field "Notification".
     *
     * The field will be set to its default value. The hasNotification()
     * method will return false.
     */
    inline void clearNotification();

    /**
     * Checks whether the field "Notification" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNotification()). Otherwise it will return false.
     */
    inline bool hasNotification () const;

    /**
     * Returns the value of the member "Notification".
     *
     * If the meaning of "Notification" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Notification"
     */
    inline const ::std::string& getNotification () const;

    /**
     * Retrieves the value of the field "Notification" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Notification".
     */
    inline ::std::string& getNotificationMutable ();

    /**
     * Sets the value of the member "Notification".
     *
     * If the meaning of "Notification" isn't clear, then there should be a description here.
     *
     * @param Notification The value which will be set
     */
    inline void setNotification (const ::std::string& Notification_);

    /**
     * Sets the value of the member "Notification".
     *
     * If the meaning of "Notification" isn't clear, then there should be a description here.
     *
     * @param Notification The value which will be set
     */
    inline void setNotification (const char* Notification_);

    /**
     * Sets the value of the member "Notification".
     *
     * If the meaning of "Notification" isn't clear, then there should be a description here.
     *
     * @param Notification The value which will be set
     */
    inline void setNotification (const char* value, size_t size);

    static const NotificationUpdate &getDefaultInstance();

private:

    inline void set_has_Notification ();

    inline void clear_has_Notification ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _Notification;

};

/**
 * If the meaning of "NotificationRegister" isn't clear, then there should be a description here.
 */
class NotificationRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  NotificationRegister ();

    /**
     * Copy constructor
     */
    inline  NotificationRegister (const NotificationRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~NotificationRegister();

    /**
     * Assignment operator
     */
    inline NotificationRegister& operator = (const NotificationRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const NotificationRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const NotificationRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const NotificationRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const NotificationRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const NotificationRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "NewMessageNotificationSignal" isn't clear, then there should be a description here.
 */
class NewMessageNotificationSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  NewMessageNotificationSignal ();

    /**
     * Copy constructor
     */
    inline  NewMessageNotificationSignal (const NewMessageNotificationSignal &rhs);

    /**
     * All fields constructor
     */
    inline  NewMessageNotificationSignal (const ::std::vector< uint8 >& data_, const ::std::string& path_);

    /**
     * Destructor
     */
    inline virtual  ~NewMessageNotificationSignal();

    /**
     * Assignment operator
     */
    inline NewMessageNotificationSignal& operator = (const NewMessageNotificationSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const NewMessageNotificationSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const NewMessageNotificationSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const NewMessageNotificationSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const NewMessageNotificationSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "data"

    static const int kData = 0;

    /**
     * Clears the field "data".
     *
     * The field will be set to its default value. The hasData()
     * method will return false.
     */
    inline void clearData();

    /**
     * Checks whether the field "data" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setData()). Otherwise it will return false.
     */
    inline bool hasData () const;

    /**
     * Returns the value of the member "data".
     *
     * If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @return The value of the field "data"
     */
    inline const ::std::vector< uint8 >& getData () const;

    /**
     * Retrieves the value of the field "data" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "data".
     */
    inline ::std::vector< uint8 >& getDataMutable ();

    /**
     * Sets the value of the member "data".
     *
     * If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @param data The value which will be set
     */
    inline void setData (const ::std::vector< uint8 >& data_);

    // API of field "path"

    static const int kPath = 1;

    /**
     * Clears the field "path".
     *
     * The field will be set to its default value. The hasPath()
     * method will return false.
     */
    inline void clearPath();

    /**
     * Checks whether the field "path" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPath()). Otherwise it will return false.
     */
    inline bool hasPath () const;

    /**
     * Returns the value of the member "path".
     *
     * If the meaning of "path" isn't clear, then there should be a description here.
     *
     * @return The value of the field "path"
     */
    inline const ::std::string& getPath () const;

    /**
     * Retrieves the value of the field "path" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "path".
     */
    inline ::std::string& getPathMutable ();

    /**
     * Sets the value of the member "path".
     *
     * If the meaning of "path" isn't clear, then there should be a description here.
     *
     * @param path The value which will be set
     */
    inline void setPath (const ::std::string& path_);

    /**
     * Sets the value of the member "path".
     *
     * If the meaning of "path" isn't clear, then there should be a description here.
     *
     * @param path The value which will be set
     */
    inline void setPath (const char* path_);

    /**
     * Sets the value of the member "path".
     *
     * If the meaning of "path" isn't clear, then there should be a description here.
     *
     * @param path The value which will be set
     */
    inline void setPath (const char* value, size_t size);

    static const NewMessageNotificationSignal &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_data ();

    inline void clear_has_data ();

    inline void set_has_path ();

    inline void clear_has_path ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::vector< uint8 > _data;

    ::std::string _path;

};

inline  SetFolderRequest::SetFolderRequest ()  :
    _name ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetFolderRequest::SetFolderRequest (const SetFolderRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _name ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetFolderRequest::SetFolderRequest (const ::std::string& name_)  :
    _name (name_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetFolderRequest::~SetFolderRequest() {
}

inline SetFolderRequest& SetFolderRequest::operator = (const SetFolderRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasName()) {
            setName(rhs.getName());
        } else {
            clearName();
        }
    }
    return *this;
}

inline bool SetFolderRequest::operator == (const SetFolderRequest& rhs) const {
    return (((!hasName() && !rhs.hasName()) || getName() == rhs.getName()));
}

inline bool SetFolderRequest::operator != (const SetFolderRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool SetFolderRequest::operator < (const SetFolderRequest& rhs) const {
    if (hasName() || rhs.hasName()) {
        if (getName() < rhs.getName()) return true;
        if (getName() > rhs.getName()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetFolderRequest::clone() {
    return new SetFolderRequest(*this);
}

inline bool SetFolderRequest::operator > (const SetFolderRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetFolderRequest::clear() {
    clearName();
}

inline void SetFolderRequest::clearName() {
    if (hasName()) {
         clear_has_name();
        _name.clear();
     }
}

inline bool SetFolderRequest::hasName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& SetFolderRequest::getName () const {
    return _name;
}

inline ::std::string& SetFolderRequest::getNameMutable () {
    set_has_name();
    return _name;
}

inline void SetFolderRequest::setName (const ::std::string& name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name = name_;
}

inline void SetFolderRequest::setName (const char* name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name.assign(name_);
}

inline void SetFolderRequest::setName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name.assign(value, size);
}

inline void SetFolderRequest::set_has_name () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetFolderRequest::clear_has_name () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ListFoldersRequest::ListFoldersRequest ()  :
    _filter ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ListFoldersRequest::ListFoldersRequest (const ListFoldersRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _filter ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ListFoldersRequest::ListFoldersRequest (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& filter_)  :
    _filter (filter_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ListFoldersRequest::~ListFoldersRequest() {
}

inline ListFoldersRequest& ListFoldersRequest::operator = (const ListFoldersRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasFilter()) {
            setFilter(rhs.getFilter());
        } else {
            clearFilter();
        }
    }
    return *this;
}

inline bool ListFoldersRequest::operator == (const ListFoldersRequest& rhs) const {
    return (((!hasFilter() && !rhs.hasFilter()) || getFilter() == rhs.getFilter()));
}

inline bool ListFoldersRequest::operator != (const ListFoldersRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool ListFoldersRequest::operator < (const ListFoldersRequest& rhs) const {
    if (hasFilter() || rhs.hasFilter()) {
        if (getFilter() < rhs.getFilter()) return true;
        if (getFilter() > rhs.getFilter()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ListFoldersRequest::clone() {
    return new ListFoldersRequest(*this);
}

inline bool ListFoldersRequest::operator > (const ListFoldersRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ListFoldersRequest::clear() {
    clearFilter();
}

inline void ListFoldersRequest::clearFilter() {
    if (hasFilter()) {
         clear_has_filter();
        _filter.clear();
     }
}

inline bool ListFoldersRequest::hasFilter () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& ListFoldersRequest::getFilter () const {
    return _filter;
}

inline ::std::map< ::std::string, ::asf::dbus::DBusVariant >& ListFoldersRequest::getFilterMutable () {
    set_has_filter();
    return _filter;
}

inline void ListFoldersRequest::setFilter (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& filter_) {
    set_has_filter();
    this->_filter = filter_;
}

inline void ListFoldersRequest::set_has_filter () {
    _has_bits_[0] |= 1u << 0;
}

inline void ListFoldersRequest::clear_has_filter () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ListFoldersResponse::ListFoldersResponse ()  :
    _folderList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ListFoldersResponse::ListFoldersResponse (const ListFoldersResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _folderList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ListFoldersResponse::ListFoldersResponse (const ::std::vector< ::std::map< ::std::string, ::asf::dbus::DBusVariant > >& folderList_)  :
    _folderList (folderList_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ListFoldersResponse::~ListFoldersResponse() {
}

inline ListFoldersResponse& ListFoldersResponse::operator = (const ListFoldersResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasFolderList()) {
            setFolderList(rhs.getFolderList());
        } else {
            clearFolderList();
        }
    }
    return *this;
}

inline bool ListFoldersResponse::operator == (const ListFoldersResponse& rhs) const {
    return (((!hasFolderList() && !rhs.hasFolderList()) || getFolderList() == rhs.getFolderList()));
}

inline bool ListFoldersResponse::operator != (const ListFoldersResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool ListFoldersResponse::operator < (const ListFoldersResponse& rhs) const {
    if (hasFolderList() || rhs.hasFolderList()) {
        if (getFolderList() < rhs.getFolderList()) return true;
        if (getFolderList() > rhs.getFolderList()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ListFoldersResponse::clone() {
    return new ListFoldersResponse(*this);
}

inline bool ListFoldersResponse::operator > (const ListFoldersResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ListFoldersResponse::clear() {
    clearFolderList();
}

inline void ListFoldersResponse::clearFolderList() {
    if (hasFolderList()) {
         clear_has_folderList();
        _folderList.clear();
     }
}

inline bool ListFoldersResponse::hasFolderList () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ::std::map< ::std::string, ::asf::dbus::DBusVariant > >& ListFoldersResponse::getFolderList () const {
    return _folderList;
}

inline ::std::vector< ::std::map< ::std::string, ::asf::dbus::DBusVariant > >& ListFoldersResponse::getFolderListMutable () {
    set_has_folderList();
    return _folderList;
}

inline void ListFoldersResponse::setFolderList (const ::std::vector< ::std::map< ::std::string, ::asf::dbus::DBusVariant > >& folderList_) {
    set_has_folderList();
    this->_folderList = folderList_;
}

inline void ListFoldersResponse::set_has_folderList () {
    _has_bits_[0] |= 1u << 0;
}

inline void ListFoldersResponse::clear_has_folderList () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ListFilterFieldsResponse::ListFilterFieldsResponse ()  :
    _fields ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ListFilterFieldsResponse::ListFilterFieldsResponse (const ListFilterFieldsResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _fields ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ListFilterFieldsResponse::ListFilterFieldsResponse (const ::std::vector< ::std::string >& fields_)  :
    _fields (fields_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ListFilterFieldsResponse::~ListFilterFieldsResponse() {
}

inline ListFilterFieldsResponse& ListFilterFieldsResponse::operator = (const ListFilterFieldsResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasFields()) {
            setFields(rhs.getFields());
        } else {
            clearFields();
        }
    }
    return *this;
}

inline bool ListFilterFieldsResponse::operator == (const ListFilterFieldsResponse& rhs) const {
    return (((!hasFields() && !rhs.hasFields()) || getFields() == rhs.getFields()));
}

inline bool ListFilterFieldsResponse::operator != (const ListFilterFieldsResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool ListFilterFieldsResponse::operator < (const ListFilterFieldsResponse& rhs) const {
    if (hasFields() || rhs.hasFields()) {
        if (getFields() < rhs.getFields()) return true;
        if (getFields() > rhs.getFields()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ListFilterFieldsResponse::clone() {
    return new ListFilterFieldsResponse(*this);
}

inline bool ListFilterFieldsResponse::operator > (const ListFilterFieldsResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ListFilterFieldsResponse::clear() {
    clearFields();
}

inline void ListFilterFieldsResponse::clearFields() {
    if (hasFields()) {
         clear_has_fields();
        _fields.clear();
     }
}

inline bool ListFilterFieldsResponse::hasFields () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ::std::string >& ListFilterFieldsResponse::getFields () const {
    return _fields;
}

inline ::std::vector< ::std::string >& ListFilterFieldsResponse::getFieldsMutable () {
    set_has_fields();
    return _fields;
}

inline void ListFilterFieldsResponse::setFields (const ::std::vector< ::std::string >& fields_) {
    set_has_fields();
    this->_fields = fields_;
}

inline void ListFilterFieldsResponse::set_has_fields () {
    _has_bits_[0] |= 1u << 0;
}

inline void ListFilterFieldsResponse::clear_has_fields () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ListMessagesRequest::ListMessagesRequest ()  :
    _folder (),
    _filter ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ListMessagesRequest::ListMessagesRequest (const ListMessagesRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _folder (),
    _filter ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ListMessagesRequest::ListMessagesRequest (const ::std::string& folder_, const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& filter_)  :
    _folder (folder_),
    _filter (filter_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (folder_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ListMessagesRequest::~ListMessagesRequest() {
}

inline ListMessagesRequest& ListMessagesRequest::operator = (const ListMessagesRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasFolder()) {
            setFolder(rhs.getFolder());
        } else {
            clearFolder();
        }
        if (rhs.hasFilter()) {
            setFilter(rhs.getFilter());
        } else {
            clearFilter();
        }
    }
    return *this;
}

inline bool ListMessagesRequest::operator == (const ListMessagesRequest& rhs) const {
    return (((!hasFolder() && !rhs.hasFolder()) || getFolder() == rhs.getFolder()) &&
        ((!hasFilter() && !rhs.hasFilter()) || getFilter() == rhs.getFilter()));
}

inline bool ListMessagesRequest::operator != (const ListMessagesRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool ListMessagesRequest::operator < (const ListMessagesRequest& rhs) const {
    if (hasFolder() || rhs.hasFolder()) {
        if (getFolder() < rhs.getFolder()) return true;
        if (getFolder() > rhs.getFolder()) return false;
    }
    if (hasFilter() || rhs.hasFilter()) {
        if (getFilter() < rhs.getFilter()) return true;
        if (getFilter() > rhs.getFilter()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ListMessagesRequest::clone() {
    return new ListMessagesRequest(*this);
}

inline bool ListMessagesRequest::operator > (const ListMessagesRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ListMessagesRequest::clear() {
    clearFolder();
    clearFilter();
}

inline void ListMessagesRequest::clearFolder() {
    if (hasFolder()) {
         clear_has_folder();
        _folder.clear();
     }
}

inline bool ListMessagesRequest::hasFolder () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& ListMessagesRequest::getFolder () const {
    return _folder;
}

inline ::std::string& ListMessagesRequest::getFolderMutable () {
    set_has_folder();
    return _folder;
}

inline void ListMessagesRequest::setFolder (const ::std::string& folder_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (folder_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_folder();
    this->_folder = folder_;
}

inline void ListMessagesRequest::setFolder (const char* folder_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (folder_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_folder();
    this->_folder.assign(folder_);
}

inline void ListMessagesRequest::setFolder (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_folder();
    this->_folder.assign(value, size);
}

inline void ListMessagesRequest::clearFilter() {
    if (hasFilter()) {
         clear_has_filter();
        _filter.clear();
     }
}

inline bool ListMessagesRequest::hasFilter () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& ListMessagesRequest::getFilter () const {
    return _filter;
}

inline ::std::map< ::std::string, ::asf::dbus::DBusVariant >& ListMessagesRequest::getFilterMutable () {
    set_has_filter();
    return _filter;
}

inline void ListMessagesRequest::setFilter (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& filter_) {
    set_has_filter();
    this->_filter = filter_;
}

inline void ListMessagesRequest::set_has_folder () {
    _has_bits_[0] |= 1u << 0;
}

inline void ListMessagesRequest::clear_has_folder () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void ListMessagesRequest::set_has_filter () {
    _has_bits_[0] |= 1u << 1;
}

inline void ListMessagesRequest::clear_has_filter () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  ListMessagesResponse::ListMessagesResponse ()  :
    _messages ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ListMessagesResponse::ListMessagesResponse (const ListMessagesResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _messages ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ListMessagesResponse::ListMessagesResponse (const ::std::map< ::std::string, ::std::map< ::std::string, ::asf::dbus::DBusVariant > >& messages_)  :
    _messages (messages_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ListMessagesResponse::~ListMessagesResponse() {
}

inline ListMessagesResponse& ListMessagesResponse::operator = (const ListMessagesResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasMessages()) {
            setMessages(rhs.getMessages());
        } else {
            clearMessages();
        }
    }
    return *this;
}

inline bool ListMessagesResponse::operator == (const ListMessagesResponse& rhs) const {
    return (((!hasMessages() && !rhs.hasMessages()) || getMessages() == rhs.getMessages()));
}

inline bool ListMessagesResponse::operator != (const ListMessagesResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool ListMessagesResponse::operator < (const ListMessagesResponse& rhs) const {
    if (hasMessages() || rhs.hasMessages()) {
        if (getMessages() < rhs.getMessages()) return true;
        if (getMessages() > rhs.getMessages()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ListMessagesResponse::clone() {
    return new ListMessagesResponse(*this);
}

inline bool ListMessagesResponse::operator > (const ListMessagesResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ListMessagesResponse::clear() {
    clearMessages();
}

inline void ListMessagesResponse::clearMessages() {
    if (hasMessages()) {
         clear_has_messages();
        _messages.clear();
     }
}

inline bool ListMessagesResponse::hasMessages () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::map< ::std::string, ::std::map< ::std::string, ::asf::dbus::DBusVariant > >& ListMessagesResponse::getMessages () const {
    return _messages;
}

inline ::std::map< ::std::string, ::std::map< ::std::string, ::asf::dbus::DBusVariant > >& ListMessagesResponse::getMessagesMutable () {
    set_has_messages();
    return _messages;
}

inline void ListMessagesResponse::setMessages (const ::std::map< ::std::string, ::std::map< ::std::string, ::asf::dbus::DBusVariant > >& messages_) {
    set_has_messages();
    this->_messages = messages_;
}

inline void ListMessagesResponse::set_has_messages () {
    _has_bits_[0] |= 1u << 0;
}

inline void ListMessagesResponse::clear_has_messages () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  PushMessageRequest::PushMessageRequest ()  :
    _sourcefile (),
    _folder (),
    _args ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  PushMessageRequest::PushMessageRequest (const PushMessageRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _sourcefile (),
    _folder (),
    _args ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  PushMessageRequest::PushMessageRequest (const ::std::string& sourcefile_, const ::std::string& folder_, const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& args_)  :
    _sourcefile (sourcefile_),
    _folder (folder_),
    _args (args_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sourcefile_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (folder_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  PushMessageRequest::~PushMessageRequest() {
}

inline PushMessageRequest& PushMessageRequest::operator = (const PushMessageRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSourcefile()) {
            setSourcefile(rhs.getSourcefile());
        } else {
            clearSourcefile();
        }
        if (rhs.hasFolder()) {
            setFolder(rhs.getFolder());
        } else {
            clearFolder();
        }
        if (rhs.hasArgs()) {
            setArgs(rhs.getArgs());
        } else {
            clearArgs();
        }
    }
    return *this;
}

inline bool PushMessageRequest::operator == (const PushMessageRequest& rhs) const {
    return (((!hasSourcefile() && !rhs.hasSourcefile()) || getSourcefile() == rhs.getSourcefile()) &&
        ((!hasFolder() && !rhs.hasFolder()) || getFolder() == rhs.getFolder()) &&
        ((!hasArgs() && !rhs.hasArgs()) || getArgs() == rhs.getArgs()));
}

inline bool PushMessageRequest::operator != (const PushMessageRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool PushMessageRequest::operator < (const PushMessageRequest& rhs) const {
    if (hasSourcefile() || rhs.hasSourcefile()) {
        if (getSourcefile() < rhs.getSourcefile()) return true;
        if (getSourcefile() > rhs.getSourcefile()) return false;
    }
    if (hasFolder() || rhs.hasFolder()) {
        if (getFolder() < rhs.getFolder()) return true;
        if (getFolder() > rhs.getFolder()) return false;
    }
    if (hasArgs() || rhs.hasArgs()) {
        if (getArgs() < rhs.getArgs()) return true;
        if (getArgs() > rhs.getArgs()) return false;
    }
    return false;
}

inline ::asf::core::Payload* PushMessageRequest::clone() {
    return new PushMessageRequest(*this);
}

inline bool PushMessageRequest::operator > (const PushMessageRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void PushMessageRequest::clear() {
    clearSourcefile();
    clearFolder();
    clearArgs();
}

inline void PushMessageRequest::clearSourcefile() {
    if (hasSourcefile()) {
         clear_has_sourcefile();
        _sourcefile.clear();
     }
}

inline bool PushMessageRequest::hasSourcefile () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& PushMessageRequest::getSourcefile () const {
    return _sourcefile;
}

inline ::std::string& PushMessageRequest::getSourcefileMutable () {
    set_has_sourcefile();
    return _sourcefile;
}

inline void PushMessageRequest::setSourcefile (const ::std::string& sourcefile_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sourcefile_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sourcefile();
    this->_sourcefile = sourcefile_;
}

inline void PushMessageRequest::setSourcefile (const char* sourcefile_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sourcefile_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sourcefile();
    this->_sourcefile.assign(sourcefile_);
}

inline void PushMessageRequest::setSourcefile (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sourcefile();
    this->_sourcefile.assign(value, size);
}

inline void PushMessageRequest::clearFolder() {
    if (hasFolder()) {
         clear_has_folder();
        _folder.clear();
     }
}

inline bool PushMessageRequest::hasFolder () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& PushMessageRequest::getFolder () const {
    return _folder;
}

inline ::std::string& PushMessageRequest::getFolderMutable () {
    set_has_folder();
    return _folder;
}

inline void PushMessageRequest::setFolder (const ::std::string& folder_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (folder_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_folder();
    this->_folder = folder_;
}

inline void PushMessageRequest::setFolder (const char* folder_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (folder_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_folder();
    this->_folder.assign(folder_);
}

inline void PushMessageRequest::setFolder (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_folder();
    this->_folder.assign(value, size);
}

inline void PushMessageRequest::clearArgs() {
    if (hasArgs()) {
         clear_has_args();
        _args.clear();
     }
}

inline bool PushMessageRequest::hasArgs () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& PushMessageRequest::getArgs () const {
    return _args;
}

inline ::std::map< ::std::string, ::asf::dbus::DBusVariant >& PushMessageRequest::getArgsMutable () {
    set_has_args();
    return _args;
}

inline void PushMessageRequest::setArgs (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& args_) {
    set_has_args();
    this->_args = args_;
}

inline void PushMessageRequest::set_has_sourcefile () {
    _has_bits_[0] |= 1u << 0;
}

inline void PushMessageRequest::clear_has_sourcefile () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void PushMessageRequest::set_has_folder () {
    _has_bits_[0] |= 1u << 1;
}

inline void PushMessageRequest::clear_has_folder () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void PushMessageRequest::set_has_args () {
    _has_bits_[0] |= 1u << 2;
}

inline void PushMessageRequest::clear_has_args () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  PushMessageResponse::PushMessageResponse ()  :
    _transfer ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  PushMessageResponse::PushMessageResponse (const PushMessageResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _transfer ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  PushMessageResponse::PushMessageResponse (const ::std::string& transfer_)  :
    _transfer (transfer_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (transfer_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  PushMessageResponse::~PushMessageResponse() {
}

inline PushMessageResponse& PushMessageResponse::operator = (const PushMessageResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTransfer()) {
            setTransfer(rhs.getTransfer());
        } else {
            clearTransfer();
        }
    }
    return *this;
}

inline bool PushMessageResponse::operator == (const PushMessageResponse& rhs) const {
    return (((!hasTransfer() && !rhs.hasTransfer()) || getTransfer() == rhs.getTransfer()));
}

inline bool PushMessageResponse::operator != (const PushMessageResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool PushMessageResponse::operator < (const PushMessageResponse& rhs) const {
    if (hasTransfer() || rhs.hasTransfer()) {
        if (getTransfer() < rhs.getTransfer()) return true;
        if (getTransfer() > rhs.getTransfer()) return false;
    }
    return false;
}

inline ::asf::core::Payload* PushMessageResponse::clone() {
    return new PushMessageResponse(*this);
}

inline bool PushMessageResponse::operator > (const PushMessageResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void PushMessageResponse::clear() {
    clearTransfer();
}

inline void PushMessageResponse::clearTransfer() {
    if (hasTransfer()) {
         clear_has_transfer();
        _transfer.clear();
     }
}

inline bool PushMessageResponse::hasTransfer () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& PushMessageResponse::getTransfer () const {
    return _transfer;
}

inline ::std::string& PushMessageResponse::getTransferMutable () {
    set_has_transfer();
    return _transfer;
}

inline void PushMessageResponse::setTransfer (const ::std::string& transfer_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (transfer_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_transfer();
    this->_transfer = transfer_;
}

inline void PushMessageResponse::setTransfer (const char* transfer_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (transfer_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_transfer();
    this->_transfer.assign(transfer_);
}

inline void PushMessageResponse::setTransfer (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_transfer();
    this->_transfer.assign(value, size);
}

inline void PushMessageResponse::set_has_transfer () {
    _has_bits_[0] |= 1u << 0;
}

inline void PushMessageResponse::clear_has_transfer () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  NotificationRegistryRequest::NotificationRegistryRequest ()  :
    _action (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  NotificationRegistryRequest::NotificationRegistryRequest (const NotificationRegistryRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _action (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  NotificationRegistryRequest::NotificationRegistryRequest (bool action_)  :
    _action (action_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  NotificationRegistryRequest::~NotificationRegistryRequest() {
}

inline NotificationRegistryRequest& NotificationRegistryRequest::operator = (const NotificationRegistryRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAction()) {
            setAction(rhs.getAction());
        } else {
            clearAction();
        }
    }
    return *this;
}

inline bool NotificationRegistryRequest::operator == (const NotificationRegistryRequest& rhs) const {
    return (((!hasAction() && !rhs.hasAction()) || getAction() == rhs.getAction()));
}

inline bool NotificationRegistryRequest::operator != (const NotificationRegistryRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool NotificationRegistryRequest::operator < (const NotificationRegistryRequest& rhs) const {
    if (hasAction() || rhs.hasAction()) {
        if (getAction() < rhs.getAction()) return true;
        if (getAction() > rhs.getAction()) return false;
    }
    return false;
}

inline ::asf::core::Payload* NotificationRegistryRequest::clone() {
    return new NotificationRegistryRequest(*this);
}

inline bool NotificationRegistryRequest::operator > (const NotificationRegistryRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void NotificationRegistryRequest::clear() {
    clearAction();
}

inline void NotificationRegistryRequest::clearAction() {
    if (hasAction()) {
         clear_has_action();
        _action = false;
     }
}

inline bool NotificationRegistryRequest::hasAction () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool NotificationRegistryRequest::getAction () const {
    return _action;
}

inline void NotificationRegistryRequest::setAction (bool action_) {
    set_has_action();
    this->_action = action_;
}

inline void NotificationRegistryRequest::set_has_action () {
    _has_bits_[0] |= 1u << 0;
}

inline void NotificationRegistryRequest::clear_has_action () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  NotificationUpdate::NotificationUpdate ()  :
    _Notification ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  NotificationUpdate::NotificationUpdate (const NotificationUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _Notification ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  NotificationUpdate::NotificationUpdate (const ::std::string& Notification_)  :
    _Notification (Notification_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Notification_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  NotificationUpdate::~NotificationUpdate() {
}

inline NotificationUpdate& NotificationUpdate::operator = (const NotificationUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasNotification()) {
            setNotification(rhs.getNotification());
        } else {
            clearNotification();
        }
    }
    return *this;
}

inline bool NotificationUpdate::operator == (const NotificationUpdate& rhs) const {
    return (((!hasNotification() && !rhs.hasNotification()) || getNotification() == rhs.getNotification()));
}

inline bool NotificationUpdate::operator != (const NotificationUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool NotificationUpdate::operator < (const NotificationUpdate& rhs) const {
    if (hasNotification() || rhs.hasNotification()) {
        if (getNotification() < rhs.getNotification()) return true;
        if (getNotification() > rhs.getNotification()) return false;
    }
    return false;
}

inline ::asf::core::Payload* NotificationUpdate::clone() {
    return new NotificationUpdate(*this);
}

inline bool NotificationUpdate::operator > (const NotificationUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void NotificationUpdate::clear() {
    clearNotification();
}

inline void NotificationUpdate::clearNotification() {
    if (hasNotification()) {
         clear_has_Notification();
        _Notification.clear();
     }
}

inline bool NotificationUpdate::hasNotification () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& NotificationUpdate::getNotification () const {
    return _Notification;
}

inline ::std::string& NotificationUpdate::getNotificationMutable () {
    set_has_Notification();
    return _Notification;
}

inline void NotificationUpdate::setNotification (const ::std::string& Notification_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Notification_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Notification();
    this->_Notification = Notification_;
}

inline void NotificationUpdate::setNotification (const char* Notification_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Notification_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Notification();
    this->_Notification.assign(Notification_);
}

inline void NotificationUpdate::setNotification (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Notification();
    this->_Notification.assign(value, size);
}

inline void NotificationUpdate::set_has_Notification () {
    _has_bits_[0] |= 1u << 0;
}

inline void NotificationUpdate::clear_has_Notification () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  NotificationRegister::NotificationRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  NotificationRegister::NotificationRegister (const NotificationRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  NotificationRegister::~NotificationRegister() {
}

inline NotificationRegister& NotificationRegister::operator = (const NotificationRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool NotificationRegister::operator == (const NotificationRegister& ) const {
    return true;
}

inline bool NotificationRegister::operator != (const NotificationRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool NotificationRegister::operator < (const NotificationRegister& ) const {
    return false;
}

inline ::asf::core::Payload* NotificationRegister::clone() {
    return new NotificationRegister(*this);
}

inline bool NotificationRegister::operator > (const NotificationRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void NotificationRegister::clear() {
}

inline  NewMessageNotificationSignal::NewMessageNotificationSignal ()  :
    _data (),
    _path ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  NewMessageNotificationSignal::NewMessageNotificationSignal (const NewMessageNotificationSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _data (),
    _path ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  NewMessageNotificationSignal::NewMessageNotificationSignal (const ::std::vector< uint8 >& data_, const ::std::string& path_)  :
    _data (data_),
    _path (path_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (path_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  NewMessageNotificationSignal::~NewMessageNotificationSignal() {
}

inline NewMessageNotificationSignal& NewMessageNotificationSignal::operator = (const NewMessageNotificationSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasData()) {
            setData(rhs.getData());
        } else {
            clearData();
        }
        if (rhs.hasPath()) {
            setPath(rhs.getPath());
        } else {
            clearPath();
        }
    }
    return *this;
}

inline bool NewMessageNotificationSignal::operator == (const NewMessageNotificationSignal& rhs) const {
    return (((!hasData() && !rhs.hasData()) || getData() == rhs.getData()) &&
        ((!hasPath() && !rhs.hasPath()) || getPath() == rhs.getPath()));
}

inline bool NewMessageNotificationSignal::operator != (const NewMessageNotificationSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool NewMessageNotificationSignal::operator < (const NewMessageNotificationSignal& rhs) const {
    if (hasData() || rhs.hasData()) {
        if (getData() < rhs.getData()) return true;
        if (getData() > rhs.getData()) return false;
    }
    if (hasPath() || rhs.hasPath()) {
        if (getPath() < rhs.getPath()) return true;
        if (getPath() > rhs.getPath()) return false;
    }
    return false;
}

inline ::asf::core::Payload* NewMessageNotificationSignal::clone() {
    return new NewMessageNotificationSignal(*this);
}

inline bool NewMessageNotificationSignal::operator > (const NewMessageNotificationSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void NewMessageNotificationSignal::clear() {
    clearData();
    clearPath();
}

inline void NewMessageNotificationSignal::clearData() {
    if (hasData()) {
         clear_has_data();
        _data.clear();
     }
}

inline bool NewMessageNotificationSignal::hasData () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< uint8 >& NewMessageNotificationSignal::getData () const {
    return _data;
}

inline ::std::vector< uint8 >& NewMessageNotificationSignal::getDataMutable () {
    set_has_data();
    return _data;
}

inline void NewMessageNotificationSignal::setData (const ::std::vector< uint8 >& data_) {
    set_has_data();
    this->_data = data_;
}

inline void NewMessageNotificationSignal::clearPath() {
    if (hasPath()) {
         clear_has_path();
        _path.clear();
     }
}

inline bool NewMessageNotificationSignal::hasPath () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& NewMessageNotificationSignal::getPath () const {
    return _path;
}

inline ::std::string& NewMessageNotificationSignal::getPathMutable () {
    set_has_path();
    return _path;
}

inline void NewMessageNotificationSignal::setPath (const ::std::string& path_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (path_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_path();
    this->_path = path_;
}

inline void NewMessageNotificationSignal::setPath (const char* path_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (path_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_path();
    this->_path.assign(path_);
}

inline void NewMessageNotificationSignal::setPath (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_path();
    this->_path.assign(value, size);
}

inline void NewMessageNotificationSignal::set_has_data () {
    _has_bits_[0] |= 1u << 0;
}

inline void NewMessageNotificationSignal::clear_has_data () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void NewMessageNotificationSignal::set_has_path () {
    _has_bits_[0] |= 1u << 1;
}

inline void NewMessageNotificationSignal::clear_has_path () {
    _has_bits_[0] &= ~ (1u << 1);
}

} // namespace MessageAccess
} // namespace obex
} // namespace bluez
} // namespace org

#endif // ORG_BLUEZ_OBEX_MESSAGEACCESS_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
