#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_BLUEZ_OBEX_MESSAGE_H
#define ORG_BLUEZ_OBEX_MESSAGE_H

#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "asf/dbus/DBusTypes.h"
#include <cstddef>
#include <cstring>
#include <string>

/**
 * If the meaning of "Message" isn't clear, then there should be a description here.
 */

namespace org {
namespace bluez {
namespace obex {
namespace Message {

// method IDs
static const uint16 ID_Get = 0;

// signal IDs

// property IDs
static const uint16 ID_Folder = 1;
static const uint16 ID_Subject = 2;
static const uint16 ID_Timestamp = 3;
static const uint16 ID_Sender = 4;
static const uint16 ID_SenderAddress = 5;
static const uint16 ID_ReplyTo = 6;
static const uint16 ID_Recipient = 7;
static const uint16 ID_RecipientAddress = 8;
static const uint16 ID_Type = 9;
static const uint16 ID_Size = 10;
static const uint16 ID_AttachmentSize = 11;
static const uint16 ID_Status = 12;
static const uint16 ID_Priority = 13;
static const uint16 ID_Read = 14;
static const uint16 ID_Deleted = 15;
static const uint16 ID_Sent = 16;
static const uint16 ID_Protected = 17;
static const uint16 ID_Text = 18;

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class GetRequest;

class GetResponse;

class FolderUpdate;

class FolderRegister;

class SubjectUpdate;

class SubjectRegister;

class TimestampUpdate;

class TimestampRegister;

class SenderUpdate;

class SenderRegister;

class SenderAddressUpdate;

class SenderAddressRegister;

class ReplyToUpdate;

class ReplyToRegister;

class RecipientUpdate;

class RecipientRegister;

class RecipientAddressUpdate;

class RecipientAddressRegister;

class TypeUpdate;

class TypeRegister;

class SizeUpdate;

class SizeRegister;

class AttachmentSizeUpdate;

class AttachmentSizeRegister;

class StatusUpdate;

class StatusRegister;

class PriorityUpdate;

class PriorityRegister;

class ReadUpdate;

class ReadRegister;

class DeletedUpdate;

class DeletedRegister;

class SentUpdate;

class SentRegister;

class ProtectedUpdate;

class ProtectedRegister;

class TextUpdate;

class TextRegister;

// type definitions
/**
 * If the meaning of "GetError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError GetError;

/**
 * If the meaning of "FolderSet" isn't clear, then there should be a description here.
 */
typedef FolderUpdate FolderSet;

/**
 * If the meaning of "FolderGet" isn't clear, then there should be a description here.
 */
typedef FolderUpdate FolderGet;

/**
 * If the meaning of "FolderError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError FolderError;

/**
 * If the meaning of "SubjectSet" isn't clear, then there should be a description here.
 */
typedef SubjectUpdate SubjectSet;

/**
 * If the meaning of "SubjectGet" isn't clear, then there should be a description here.
 */
typedef SubjectUpdate SubjectGet;

/**
 * If the meaning of "SubjectError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SubjectError;

/**
 * If the meaning of "TimestampSet" isn't clear, then there should be a description here.
 */
typedef TimestampUpdate TimestampSet;

/**
 * If the meaning of "TimestampGet" isn't clear, then there should be a description here.
 */
typedef TimestampUpdate TimestampGet;

/**
 * If the meaning of "TimestampError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError TimestampError;

/**
 * If the meaning of "SenderSet" isn't clear, then there should be a description here.
 */
typedef SenderUpdate SenderSet;

/**
 * If the meaning of "SenderGet" isn't clear, then there should be a description here.
 */
typedef SenderUpdate SenderGet;

/**
 * If the meaning of "SenderError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SenderError;

/**
 * If the meaning of "SenderAddressSet" isn't clear, then there should be a description here.
 */
typedef SenderAddressUpdate SenderAddressSet;

/**
 * If the meaning of "SenderAddressGet" isn't clear, then there should be a description here.
 */
typedef SenderAddressUpdate SenderAddressGet;

/**
 * If the meaning of "SenderAddressError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SenderAddressError;

/**
 * If the meaning of "ReplyToSet" isn't clear, then there should be a description here.
 */
typedef ReplyToUpdate ReplyToSet;

/**
 * If the meaning of "ReplyToGet" isn't clear, then there should be a description here.
 */
typedef ReplyToUpdate ReplyToGet;

/**
 * If the meaning of "ReplyToError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ReplyToError;

/**
 * If the meaning of "RecipientSet" isn't clear, then there should be a description here.
 */
typedef RecipientUpdate RecipientSet;

/**
 * If the meaning of "RecipientGet" isn't clear, then there should be a description here.
 */
typedef RecipientUpdate RecipientGet;

/**
 * If the meaning of "RecipientError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError RecipientError;

/**
 * If the meaning of "RecipientAddressSet" isn't clear, then there should be a description here.
 */
typedef RecipientAddressUpdate RecipientAddressSet;

/**
 * If the meaning of "RecipientAddressGet" isn't clear, then there should be a description here.
 */
typedef RecipientAddressUpdate RecipientAddressGet;

/**
 * If the meaning of "RecipientAddressError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError RecipientAddressError;

/**
 * If the meaning of "TypeSet" isn't clear, then there should be a description here.
 */
typedef TypeUpdate TypeSet;

/**
 * If the meaning of "TypeGet" isn't clear, then there should be a description here.
 */
typedef TypeUpdate TypeGet;

/**
 * If the meaning of "TypeError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError TypeError;

/**
 * If the meaning of "SizeSet" isn't clear, then there should be a description here.
 */
typedef SizeUpdate SizeSet;

/**
 * If the meaning of "SizeGet" isn't clear, then there should be a description here.
 */
typedef SizeUpdate SizeGet;

/**
 * If the meaning of "SizeError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SizeError;

/**
 * If the meaning of "AttachmentSizeSet" isn't clear, then there should be a description here.
 */
typedef AttachmentSizeUpdate AttachmentSizeSet;

/**
 * If the meaning of "AttachmentSizeGet" isn't clear, then there should be a description here.
 */
typedef AttachmentSizeUpdate AttachmentSizeGet;

/**
 * If the meaning of "AttachmentSizeError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError AttachmentSizeError;

/**
 * If the meaning of "StatusSet" isn't clear, then there should be a description here.
 */
typedef StatusUpdate StatusSet;

/**
 * If the meaning of "StatusGet" isn't clear, then there should be a description here.
 */
typedef StatusUpdate StatusGet;

/**
 * If the meaning of "StatusError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError StatusError;

/**
 * If the meaning of "PrioritySet" isn't clear, then there should be a description here.
 */
typedef PriorityUpdate PrioritySet;

/**
 * If the meaning of "PriorityGet" isn't clear, then there should be a description here.
 */
typedef PriorityUpdate PriorityGet;

/**
 * If the meaning of "PriorityError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError PriorityError;

/**
 * If the meaning of "ReadSet" isn't clear, then there should be a description here.
 */
typedef ReadUpdate ReadSet;

/**
 * If the meaning of "ReadGet" isn't clear, then there should be a description here.
 */
typedef ReadUpdate ReadGet;

/**
 * If the meaning of "ReadError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ReadError;

/**
 * If the meaning of "DeletedSet" isn't clear, then there should be a description here.
 */
typedef DeletedUpdate DeletedSet;

/**
 * If the meaning of "DeletedGet" isn't clear, then there should be a description here.
 */
typedef DeletedUpdate DeletedGet;

/**
 * If the meaning of "DeletedError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError DeletedError;

/**
 * If the meaning of "SentSet" isn't clear, then there should be a description here.
 */
typedef SentUpdate SentSet;

/**
 * If the meaning of "SentGet" isn't clear, then there should be a description here.
 */
typedef SentUpdate SentGet;

/**
 * If the meaning of "SentError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SentError;

/**
 * If the meaning of "ProtectedSet" isn't clear, then there should be a description here.
 */
typedef ProtectedUpdate ProtectedSet;

/**
 * If the meaning of "ProtectedGet" isn't clear, then there should be a description here.
 */
typedef ProtectedUpdate ProtectedGet;

/**
 * If the meaning of "ProtectedError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ProtectedError;

/**
 * If the meaning of "TextSet" isn't clear, then there should be a description here.
 */
typedef TextUpdate TextSet;

/**
 * If the meaning of "TextGet" isn't clear, then there should be a description here.
 */
typedef TextUpdate TextGet;

/**
 * If the meaning of "TextError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError TextError;


/**
 * If the meaning of "GetRequest" isn't clear, then there should be a description here.
 */
class GetRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetRequest ();

    /**
     * Copy constructor
     */
    inline  GetRequest (const GetRequest &rhs);

    /**
     * All fields constructor
     */
    inline  GetRequest (const ::std::string& targetfile_, bool attachment_);

    /**
     * Destructor
     */
    inline virtual  ~GetRequest();

    /**
     * Assignment operator
     */
    inline GetRequest& operator = (const GetRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "targetfile"

    static const int kTargetfile = 0;

    /**
     * Clears the field "targetfile".
     *
     * The field will be set to its default value. The hasTargetfile()
     * method will return false.
     */
    inline void clearTargetfile();

    /**
     * Checks whether the field "targetfile" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTargetfile()). Otherwise it will return false.
     */
    inline bool hasTargetfile () const;

    /**
     * Returns the value of the member "targetfile".
     *
     * If the meaning of "targetfile" isn't clear, then there should be a description here.
     *
     * @return The value of the field "targetfile"
     */
    inline const ::std::string& getTargetfile () const;

    /**
     * Retrieves the value of the field "targetfile" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "targetfile".
     */
    inline ::std::string& getTargetfileMutable ();

    /**
     * Sets the value of the member "targetfile".
     *
     * If the meaning of "targetfile" isn't clear, then there should be a description here.
     *
     * @param targetfile The value which will be set
     */
    inline void setTargetfile (const ::std::string& targetfile_);

    /**
     * Sets the value of the member "targetfile".
     *
     * If the meaning of "targetfile" isn't clear, then there should be a description here.
     *
     * @param targetfile The value which will be set
     */
    inline void setTargetfile (const char* targetfile_);

    /**
     * Sets the value of the member "targetfile".
     *
     * If the meaning of "targetfile" isn't clear, then there should be a description here.
     *
     * @param targetfile The value which will be set
     */
    inline void setTargetfile (const char* value, size_t size);

    // API of field "attachment"

    static const int kAttachment = 1;

    /**
     * Clears the field "attachment".
     *
     * The field will be set to its default value. The hasAttachment()
     * method will return false.
     */
    inline void clearAttachment();

    /**
     * Checks whether the field "attachment" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAttachment()). Otherwise it will return false.
     */
    inline bool hasAttachment () const;

    /**
     * Returns the value of the member "attachment".
     *
     * If the meaning of "attachment" isn't clear, then there should be a description here.
     *
     * @return The value of the field "attachment"
     */
    inline bool getAttachment () const;

    /**
     * Sets the value of the member "attachment".
     *
     * If the meaning of "attachment" isn't clear, then there should be a description here.
     *
     * @param attachment The value which will be set
     */
    inline void setAttachment (bool attachment_);

    static const GetRequest &getDefaultInstance();

private:

    inline void set_has_targetfile ();

    inline void clear_has_targetfile ();

    inline void set_has_attachment ();

    inline void clear_has_attachment ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _targetfile;

    bool _attachment;

};

/**
 * If the meaning of "GetResponse" isn't clear, then there should be a description here.
 */
class GetResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetResponse ();

    /**
     * Copy constructor
     */
    inline  GetResponse (const GetResponse &rhs);

    /**
     * All fields constructor
     */
    inline  GetResponse (const ::std::string& transfer_);

    /**
     * Destructor
     */
    inline virtual  ~GetResponse();

    /**
     * Assignment operator
     */
    inline GetResponse& operator = (const GetResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "transfer"

    static const int kTransfer = 0;

    /**
     * Clears the field "transfer".
     *
     * The field will be set to its default value. The hasTransfer()
     * method will return false.
     */
    inline void clearTransfer();

    /**
     * Checks whether the field "transfer" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTransfer()). Otherwise it will return false.
     */
    inline bool hasTransfer () const;

    /**
     * Returns the value of the member "transfer".
     *
     * If the meaning of "transfer" isn't clear, then there should be a description here.
     *
     * @return The value of the field "transfer"
     */
    inline const ::std::string& getTransfer () const;

    /**
     * Retrieves the value of the field "transfer" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "transfer".
     */
    inline ::std::string& getTransferMutable ();

    /**
     * Sets the value of the member "transfer".
     *
     * If the meaning of "transfer" isn't clear, then there should be a description here.
     *
     * @param transfer The value which will be set
     */
    inline void setTransfer (const ::std::string& transfer_);

    /**
     * Sets the value of the member "transfer".
     *
     * If the meaning of "transfer" isn't clear, then there should be a description here.
     *
     * @param transfer The value which will be set
     */
    inline void setTransfer (const char* transfer_);

    /**
     * Sets the value of the member "transfer".
     *
     * If the meaning of "transfer" isn't clear, then there should be a description here.
     *
     * @param transfer The value which will be set
     */
    inline void setTransfer (const char* value, size_t size);

    static const GetResponse &getDefaultInstance();

private:

    inline void set_has_transfer ();

    inline void clear_has_transfer ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _transfer;

};

/**
 * If the meaning of "FolderUpdate" isn't clear, then there should be a description here.
 */
class FolderUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FolderUpdate ();

    /**
     * Copy constructor
     */
    inline  FolderUpdate (const FolderUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  FolderUpdate (const ::std::string& Folder_);

    /**
     * Destructor
     */
    inline virtual  ~FolderUpdate();

    /**
     * Assignment operator
     */
    inline FolderUpdate& operator = (const FolderUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FolderUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FolderUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FolderUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FolderUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Folder"

    static const int kFolder = 0;

    /**
     * Clears the field "Folder".
     *
     * The field will be set to its default value. The hasFolder()
     * method will return false.
     */
    inline void clearFolder();

    /**
     * Checks whether the field "Folder" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFolder()). Otherwise it will return false.
     */
    inline bool hasFolder () const;

    /**
     * Returns the value of the member "Folder".
     *
     * If the meaning of "Folder" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Folder"
     */
    inline const ::std::string& getFolder () const;

    /**
     * Retrieves the value of the field "Folder" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Folder".
     */
    inline ::std::string& getFolderMutable ();

    /**
     * Sets the value of the member "Folder".
     *
     * If the meaning of "Folder" isn't clear, then there should be a description here.
     *
     * @param Folder The value which will be set
     */
    inline void setFolder (const ::std::string& Folder_);

    /**
     * Sets the value of the member "Folder".
     *
     * If the meaning of "Folder" isn't clear, then there should be a description here.
     *
     * @param Folder The value which will be set
     */
    inline void setFolder (const char* Folder_);

    /**
     * Sets the value of the member "Folder".
     *
     * If the meaning of "Folder" isn't clear, then there should be a description here.
     *
     * @param Folder The value which will be set
     */
    inline void setFolder (const char* value, size_t size);

    static const FolderUpdate &getDefaultInstance();

private:

    inline void set_has_Folder ();

    inline void clear_has_Folder ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _Folder;

};

/**
 * If the meaning of "FolderRegister" isn't clear, then there should be a description here.
 */
class FolderRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FolderRegister ();

    /**
     * Copy constructor
     */
    inline  FolderRegister (const FolderRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~FolderRegister();

    /**
     * Assignment operator
     */
    inline FolderRegister& operator = (const FolderRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FolderRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FolderRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FolderRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FolderRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const FolderRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "SubjectUpdate" isn't clear, then there should be a description here.
 */
class SubjectUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SubjectUpdate ();

    /**
     * Copy constructor
     */
    inline  SubjectUpdate (const SubjectUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  SubjectUpdate (const ::std::string& Subject_);

    /**
     * Destructor
     */
    inline virtual  ~SubjectUpdate();

    /**
     * Assignment operator
     */
    inline SubjectUpdate& operator = (const SubjectUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SubjectUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SubjectUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SubjectUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SubjectUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Subject"

    static const int kSubject = 0;

    /**
     * Clears the field "Subject".
     *
     * The field will be set to its default value. The hasSubject()
     * method will return false.
     */
    inline void clearSubject();

    /**
     * Checks whether the field "Subject" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSubject()). Otherwise it will return false.
     */
    inline bool hasSubject () const;

    /**
     * Returns the value of the member "Subject".
     *
     * If the meaning of "Subject" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Subject"
     */
    inline const ::std::string& getSubject () const;

    /**
     * Retrieves the value of the field "Subject" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Subject".
     */
    inline ::std::string& getSubjectMutable ();

    /**
     * Sets the value of the member "Subject".
     *
     * If the meaning of "Subject" isn't clear, then there should be a description here.
     *
     * @param Subject The value which will be set
     */
    inline void setSubject (const ::std::string& Subject_);

    /**
     * Sets the value of the member "Subject".
     *
     * If the meaning of "Subject" isn't clear, then there should be a description here.
     *
     * @param Subject The value which will be set
     */
    inline void setSubject (const char* Subject_);

    /**
     * Sets the value of the member "Subject".
     *
     * If the meaning of "Subject" isn't clear, then there should be a description here.
     *
     * @param Subject The value which will be set
     */
    inline void setSubject (const char* value, size_t size);

    static const SubjectUpdate &getDefaultInstance();

private:

    inline void set_has_Subject ();

    inline void clear_has_Subject ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _Subject;

};

/**
 * If the meaning of "SubjectRegister" isn't clear, then there should be a description here.
 */
class SubjectRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SubjectRegister ();

    /**
     * Copy constructor
     */
    inline  SubjectRegister (const SubjectRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~SubjectRegister();

    /**
     * Assignment operator
     */
    inline SubjectRegister& operator = (const SubjectRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SubjectRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SubjectRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SubjectRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SubjectRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const SubjectRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "TimestampUpdate" isn't clear, then there should be a description here.
 */
class TimestampUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TimestampUpdate ();

    /**
     * Copy constructor
     */
    inline  TimestampUpdate (const TimestampUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  TimestampUpdate (const ::std::string& Timestamp_);

    /**
     * Destructor
     */
    inline virtual  ~TimestampUpdate();

    /**
     * Assignment operator
     */
    inline TimestampUpdate& operator = (const TimestampUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TimestampUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TimestampUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TimestampUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TimestampUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Timestamp"

    static const int kTimestamp = 0;

    /**
     * Clears the field "Timestamp".
     *
     * The field will be set to its default value. The hasTimestamp()
     * method will return false.
     */
    inline void clearTimestamp();

    /**
     * Checks whether the field "Timestamp" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTimestamp()). Otherwise it will return false.
     */
    inline bool hasTimestamp () const;

    /**
     * Returns the value of the member "Timestamp".
     *
     * If the meaning of "Timestamp" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Timestamp"
     */
    inline const ::std::string& getTimestamp () const;

    /**
     * Retrieves the value of the field "Timestamp" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Timestamp".
     */
    inline ::std::string& getTimestampMutable ();

    /**
     * Sets the value of the member "Timestamp".
     *
     * If the meaning of "Timestamp" isn't clear, then there should be a description here.
     *
     * @param Timestamp The value which will be set
     */
    inline void setTimestamp (const ::std::string& Timestamp_);

    /**
     * Sets the value of the member "Timestamp".
     *
     * If the meaning of "Timestamp" isn't clear, then there should be a description here.
     *
     * @param Timestamp The value which will be set
     */
    inline void setTimestamp (const char* Timestamp_);

    /**
     * Sets the value of the member "Timestamp".
     *
     * If the meaning of "Timestamp" isn't clear, then there should be a description here.
     *
     * @param Timestamp The value which will be set
     */
    inline void setTimestamp (const char* value, size_t size);

    static const TimestampUpdate &getDefaultInstance();

private:

    inline void set_has_Timestamp ();

    inline void clear_has_Timestamp ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _Timestamp;

};

/**
 * If the meaning of "TimestampRegister" isn't clear, then there should be a description here.
 */
class TimestampRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TimestampRegister ();

    /**
     * Copy constructor
     */
    inline  TimestampRegister (const TimestampRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~TimestampRegister();

    /**
     * Assignment operator
     */
    inline TimestampRegister& operator = (const TimestampRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TimestampRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TimestampRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TimestampRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TimestampRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const TimestampRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "SenderUpdate" isn't clear, then there should be a description here.
 */
class SenderUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SenderUpdate ();

    /**
     * Copy constructor
     */
    inline  SenderUpdate (const SenderUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  SenderUpdate (const ::std::string& Sender_);

    /**
     * Destructor
     */
    inline virtual  ~SenderUpdate();

    /**
     * Assignment operator
     */
    inline SenderUpdate& operator = (const SenderUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SenderUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SenderUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SenderUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SenderUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Sender"

    static const int kSender = 0;

    /**
     * Clears the field "Sender".
     *
     * The field will be set to its default value. The hasSender()
     * method will return false.
     */
    inline void clearSender();

    /**
     * Checks whether the field "Sender" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSender()). Otherwise it will return false.
     */
    inline bool hasSender () const;

    /**
     * Returns the value of the member "Sender".
     *
     * If the meaning of "Sender" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Sender"
     */
    inline const ::std::string& getSender () const;

    /**
     * Retrieves the value of the field "Sender" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Sender".
     */
    inline ::std::string& getSenderMutable ();

    /**
     * Sets the value of the member "Sender".
     *
     * If the meaning of "Sender" isn't clear, then there should be a description here.
     *
     * @param Sender The value which will be set
     */
    inline void setSender (const ::std::string& Sender_);

    /**
     * Sets the value of the member "Sender".
     *
     * If the meaning of "Sender" isn't clear, then there should be a description here.
     *
     * @param Sender The value which will be set
     */
    inline void setSender (const char* Sender_);

    /**
     * Sets the value of the member "Sender".
     *
     * If the meaning of "Sender" isn't clear, then there should be a description here.
     *
     * @param Sender The value which will be set
     */
    inline void setSender (const char* value, size_t size);

    static const SenderUpdate &getDefaultInstance();

private:

    inline void set_has_Sender ();

    inline void clear_has_Sender ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _Sender;

};

/**
 * If the meaning of "SenderRegister" isn't clear, then there should be a description here.
 */
class SenderRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SenderRegister ();

    /**
     * Copy constructor
     */
    inline  SenderRegister (const SenderRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~SenderRegister();

    /**
     * Assignment operator
     */
    inline SenderRegister& operator = (const SenderRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SenderRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SenderRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SenderRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SenderRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const SenderRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "SenderAddressUpdate" isn't clear, then there should be a description here.
 */
class SenderAddressUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SenderAddressUpdate ();

    /**
     * Copy constructor
     */
    inline  SenderAddressUpdate (const SenderAddressUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  SenderAddressUpdate (const ::std::string& SenderAddress_);

    /**
     * Destructor
     */
    inline virtual  ~SenderAddressUpdate();

    /**
     * Assignment operator
     */
    inline SenderAddressUpdate& operator = (const SenderAddressUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SenderAddressUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SenderAddressUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SenderAddressUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SenderAddressUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SenderAddress"

    static const int kSenderAddress = 0;

    /**
     * Clears the field "SenderAddress".
     *
     * The field will be set to its default value. The hasSenderAddress()
     * method will return false.
     */
    inline void clearSenderAddress();

    /**
     * Checks whether the field "SenderAddress" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSenderAddress()). Otherwise it will return false.
     */
    inline bool hasSenderAddress () const;

    /**
     * Returns the value of the member "SenderAddress".
     *
     * If the meaning of "SenderAddress" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SenderAddress"
     */
    inline const ::std::string& getSenderAddress () const;

    /**
     * Retrieves the value of the field "SenderAddress" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "SenderAddress".
     */
    inline ::std::string& getSenderAddressMutable ();

    /**
     * Sets the value of the member "SenderAddress".
     *
     * If the meaning of "SenderAddress" isn't clear, then there should be a description here.
     *
     * @param SenderAddress The value which will be set
     */
    inline void setSenderAddress (const ::std::string& SenderAddress_);

    /**
     * Sets the value of the member "SenderAddress".
     *
     * If the meaning of "SenderAddress" isn't clear, then there should be a description here.
     *
     * @param SenderAddress The value which will be set
     */
    inline void setSenderAddress (const char* SenderAddress_);

    /**
     * Sets the value of the member "SenderAddress".
     *
     * If the meaning of "SenderAddress" isn't clear, then there should be a description here.
     *
     * @param SenderAddress The value which will be set
     */
    inline void setSenderAddress (const char* value, size_t size);

    static const SenderAddressUpdate &getDefaultInstance();

private:

    inline void set_has_SenderAddress ();

    inline void clear_has_SenderAddress ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _SenderAddress;

};

/**
 * If the meaning of "SenderAddressRegister" isn't clear, then there should be a description here.
 */
class SenderAddressRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SenderAddressRegister ();

    /**
     * Copy constructor
     */
    inline  SenderAddressRegister (const SenderAddressRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~SenderAddressRegister();

    /**
     * Assignment operator
     */
    inline SenderAddressRegister& operator = (const SenderAddressRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SenderAddressRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SenderAddressRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SenderAddressRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SenderAddressRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const SenderAddressRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "ReplyToUpdate" isn't clear, then there should be a description here.
 */
class ReplyToUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReplyToUpdate ();

    /**
     * Copy constructor
     */
    inline  ReplyToUpdate (const ReplyToUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  ReplyToUpdate (const ::std::string& ReplyTo_);

    /**
     * Destructor
     */
    inline virtual  ~ReplyToUpdate();

    /**
     * Assignment operator
     */
    inline ReplyToUpdate& operator = (const ReplyToUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReplyToUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReplyToUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReplyToUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReplyToUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ReplyTo"

    static const int kReplyTo = 0;

    /**
     * Clears the field "ReplyTo".
     *
     * The field will be set to its default value. The hasReplyTo()
     * method will return false.
     */
    inline void clearReplyTo();

    /**
     * Checks whether the field "ReplyTo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setReplyTo()). Otherwise it will return false.
     */
    inline bool hasReplyTo () const;

    /**
     * Returns the value of the member "ReplyTo".
     *
     * If the meaning of "ReplyTo" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ReplyTo"
     */
    inline const ::std::string& getReplyTo () const;

    /**
     * Retrieves the value of the field "ReplyTo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ReplyTo".
     */
    inline ::std::string& getReplyToMutable ();

    /**
     * Sets the value of the member "ReplyTo".
     *
     * If the meaning of "ReplyTo" isn't clear, then there should be a description here.
     *
     * @param ReplyTo The value which will be set
     */
    inline void setReplyTo (const ::std::string& ReplyTo_);

    /**
     * Sets the value of the member "ReplyTo".
     *
     * If the meaning of "ReplyTo" isn't clear, then there should be a description here.
     *
     * @param ReplyTo The value which will be set
     */
    inline void setReplyTo (const char* ReplyTo_);

    /**
     * Sets the value of the member "ReplyTo".
     *
     * If the meaning of "ReplyTo" isn't clear, then there should be a description here.
     *
     * @param ReplyTo The value which will be set
     */
    inline void setReplyTo (const char* value, size_t size);

    static const ReplyToUpdate &getDefaultInstance();

private:

    inline void set_has_ReplyTo ();

    inline void clear_has_ReplyTo ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _ReplyTo;

};

/**
 * If the meaning of "ReplyToRegister" isn't clear, then there should be a description here.
 */
class ReplyToRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReplyToRegister ();

    /**
     * Copy constructor
     */
    inline  ReplyToRegister (const ReplyToRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~ReplyToRegister();

    /**
     * Assignment operator
     */
    inline ReplyToRegister& operator = (const ReplyToRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReplyToRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReplyToRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReplyToRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReplyToRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const ReplyToRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "RecipientUpdate" isn't clear, then there should be a description here.
 */
class RecipientUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RecipientUpdate ();

    /**
     * Copy constructor
     */
    inline  RecipientUpdate (const RecipientUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  RecipientUpdate (const ::std::string& Recipient_);

    /**
     * Destructor
     */
    inline virtual  ~RecipientUpdate();

    /**
     * Assignment operator
     */
    inline RecipientUpdate& operator = (const RecipientUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RecipientUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RecipientUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RecipientUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RecipientUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Recipient"

    static const int kRecipient = 0;

    /**
     * Clears the field "Recipient".
     *
     * The field will be set to its default value. The hasRecipient()
     * method will return false.
     */
    inline void clearRecipient();

    /**
     * Checks whether the field "Recipient" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRecipient()). Otherwise it will return false.
     */
    inline bool hasRecipient () const;

    /**
     * Returns the value of the member "Recipient".
     *
     * If the meaning of "Recipient" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Recipient"
     */
    inline const ::std::string& getRecipient () const;

    /**
     * Retrieves the value of the field "Recipient" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Recipient".
     */
    inline ::std::string& getRecipientMutable ();

    /**
     * Sets the value of the member "Recipient".
     *
     * If the meaning of "Recipient" isn't clear, then there should be a description here.
     *
     * @param Recipient The value which will be set
     */
    inline void setRecipient (const ::std::string& Recipient_);

    /**
     * Sets the value of the member "Recipient".
     *
     * If the meaning of "Recipient" isn't clear, then there should be a description here.
     *
     * @param Recipient The value which will be set
     */
    inline void setRecipient (const char* Recipient_);

    /**
     * Sets the value of the member "Recipient".
     *
     * If the meaning of "Recipient" isn't clear, then there should be a description here.
     *
     * @param Recipient The value which will be set
     */
    inline void setRecipient (const char* value, size_t size);

    static const RecipientUpdate &getDefaultInstance();

private:

    inline void set_has_Recipient ();

    inline void clear_has_Recipient ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _Recipient;

};

/**
 * If the meaning of "RecipientRegister" isn't clear, then there should be a description here.
 */
class RecipientRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RecipientRegister ();

    /**
     * Copy constructor
     */
    inline  RecipientRegister (const RecipientRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~RecipientRegister();

    /**
     * Assignment operator
     */
    inline RecipientRegister& operator = (const RecipientRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RecipientRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RecipientRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RecipientRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RecipientRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const RecipientRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "RecipientAddressUpdate" isn't clear, then there should be a description here.
 */
class RecipientAddressUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RecipientAddressUpdate ();

    /**
     * Copy constructor
     */
    inline  RecipientAddressUpdate (const RecipientAddressUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  RecipientAddressUpdate (const ::std::string& RecipientAddress_);

    /**
     * Destructor
     */
    inline virtual  ~RecipientAddressUpdate();

    /**
     * Assignment operator
     */
    inline RecipientAddressUpdate& operator = (const RecipientAddressUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RecipientAddressUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RecipientAddressUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RecipientAddressUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RecipientAddressUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "RecipientAddress"

    static const int kRecipientAddress = 0;

    /**
     * Clears the field "RecipientAddress".
     *
     * The field will be set to its default value. The hasRecipientAddress()
     * method will return false.
     */
    inline void clearRecipientAddress();

    /**
     * Checks whether the field "RecipientAddress" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRecipientAddress()). Otherwise it will return false.
     */
    inline bool hasRecipientAddress () const;

    /**
     * Returns the value of the member "RecipientAddress".
     *
     * If the meaning of "RecipientAddress" isn't clear, then there should be a description here.
     *
     * @return The value of the field "RecipientAddress"
     */
    inline const ::std::string& getRecipientAddress () const;

    /**
     * Retrieves the value of the field "RecipientAddress" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "RecipientAddress".
     */
    inline ::std::string& getRecipientAddressMutable ();

    /**
     * Sets the value of the member "RecipientAddress".
     *
     * If the meaning of "RecipientAddress" isn't clear, then there should be a description here.
     *
     * @param RecipientAddress The value which will be set
     */
    inline void setRecipientAddress (const ::std::string& RecipientAddress_);

    /**
     * Sets the value of the member "RecipientAddress".
     *
     * If the meaning of "RecipientAddress" isn't clear, then there should be a description here.
     *
     * @param RecipientAddress The value which will be set
     */
    inline void setRecipientAddress (const char* RecipientAddress_);

    /**
     * Sets the value of the member "RecipientAddress".
     *
     * If the meaning of "RecipientAddress" isn't clear, then there should be a description here.
     *
     * @param RecipientAddress The value which will be set
     */
    inline void setRecipientAddress (const char* value, size_t size);

    static const RecipientAddressUpdate &getDefaultInstance();

private:

    inline void set_has_RecipientAddress ();

    inline void clear_has_RecipientAddress ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _RecipientAddress;

};

/**
 * If the meaning of "RecipientAddressRegister" isn't clear, then there should be a description here.
 */
class RecipientAddressRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RecipientAddressRegister ();

    /**
     * Copy constructor
     */
    inline  RecipientAddressRegister (const RecipientAddressRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~RecipientAddressRegister();

    /**
     * Assignment operator
     */
    inline RecipientAddressRegister& operator = (const RecipientAddressRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RecipientAddressRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RecipientAddressRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RecipientAddressRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RecipientAddressRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const RecipientAddressRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "TypeUpdate" isn't clear, then there should be a description here.
 */
class TypeUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TypeUpdate ();

    /**
     * Copy constructor
     */
    inline  TypeUpdate (const TypeUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  TypeUpdate (const ::std::string& Type_);

    /**
     * Destructor
     */
    inline virtual  ~TypeUpdate();

    /**
     * Assignment operator
     */
    inline TypeUpdate& operator = (const TypeUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TypeUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TypeUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TypeUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TypeUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Type"

    static const int kType = 0;

    /**
     * Clears the field "Type".
     *
     * The field will be set to its default value. The hasType()
     * method will return false.
     */
    inline void clearType();

    /**
     * Checks whether the field "Type" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setType()). Otherwise it will return false.
     */
    inline bool hasType () const;

    /**
     * Returns the value of the member "Type".
     *
     * If the meaning of "Type" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Type"
     */
    inline const ::std::string& getType () const;

    /**
     * Retrieves the value of the field "Type" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Type".
     */
    inline ::std::string& getTypeMutable ();

    /**
     * Sets the value of the member "Type".
     *
     * If the meaning of "Type" isn't clear, then there should be a description here.
     *
     * @param Type The value which will be set
     */
    inline void setType (const ::std::string& Type_);

    /**
     * Sets the value of the member "Type".
     *
     * If the meaning of "Type" isn't clear, then there should be a description here.
     *
     * @param Type The value which will be set
     */
    inline void setType (const char* Type_);

    /**
     * Sets the value of the member "Type".
     *
     * If the meaning of "Type" isn't clear, then there should be a description here.
     *
     * @param Type The value which will be set
     */
    inline void setType (const char* value, size_t size);

    static const TypeUpdate &getDefaultInstance();

private:

    inline void set_has_Type ();

    inline void clear_has_Type ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _Type;

};

/**
 * If the meaning of "TypeRegister" isn't clear, then there should be a description here.
 */
class TypeRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TypeRegister ();

    /**
     * Copy constructor
     */
    inline  TypeRegister (const TypeRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~TypeRegister();

    /**
     * Assignment operator
     */
    inline TypeRegister& operator = (const TypeRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TypeRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TypeRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TypeRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TypeRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const TypeRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "SizeUpdate" isn't clear, then there should be a description here.
 */
class SizeUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SizeUpdate ();

    /**
     * Copy constructor
     */
    inline  SizeUpdate (const SizeUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  SizeUpdate (uint64 Size_);

    /**
     * Destructor
     */
    inline virtual  ~SizeUpdate();

    /**
     * Assignment operator
     */
    inline SizeUpdate& operator = (const SizeUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SizeUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SizeUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SizeUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SizeUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Size"

    static const int kSize = 0;

    /**
     * Clears the field "Size".
     *
     * The field will be set to its default value. The hasSize()
     * method will return false.
     */
    inline void clearSize();

    /**
     * Checks whether the field "Size" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSize()). Otherwise it will return false.
     */
    inline bool hasSize () const;

    /**
     * Returns the value of the member "Size".
     *
     * If the meaning of "Size" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Size"
     */
    inline uint64 getSize () const;

    /**
     * Sets the value of the member "Size".
     *
     * If the meaning of "Size" isn't clear, then there should be a description here.
     *
     * @param Size The value which will be set
     */
    inline void setSize (uint64 Size_);

    static const SizeUpdate &getDefaultInstance();

private:

    inline void set_has_Size ();

    inline void clear_has_Size ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint64 _Size;

};

/**
 * If the meaning of "SizeRegister" isn't clear, then there should be a description here.
 */
class SizeRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SizeRegister ();

    /**
     * Copy constructor
     */
    inline  SizeRegister (const SizeRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~SizeRegister();

    /**
     * Assignment operator
     */
    inline SizeRegister& operator = (const SizeRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SizeRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SizeRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SizeRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SizeRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const SizeRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "AttachmentSizeUpdate" isn't clear, then there should be a description here.
 */
class AttachmentSizeUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AttachmentSizeUpdate ();

    /**
     * Copy constructor
     */
    inline  AttachmentSizeUpdate (const AttachmentSizeUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  AttachmentSizeUpdate (uint64 AttachmentSize_);

    /**
     * Destructor
     */
    inline virtual  ~AttachmentSizeUpdate();

    /**
     * Assignment operator
     */
    inline AttachmentSizeUpdate& operator = (const AttachmentSizeUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AttachmentSizeUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AttachmentSizeUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AttachmentSizeUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AttachmentSizeUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "AttachmentSize"

    static const int kAttachmentSize = 0;

    /**
     * Clears the field "AttachmentSize".
     *
     * The field will be set to its default value. The hasAttachmentSize()
     * method will return false.
     */
    inline void clearAttachmentSize();

    /**
     * Checks whether the field "AttachmentSize" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAttachmentSize()). Otherwise it will return false.
     */
    inline bool hasAttachmentSize () const;

    /**
     * Returns the value of the member "AttachmentSize".
     *
     * If the meaning of "AttachmentSize" isn't clear, then there should be a description here.
     *
     * @return The value of the field "AttachmentSize"
     */
    inline uint64 getAttachmentSize () const;

    /**
     * Sets the value of the member "AttachmentSize".
     *
     * If the meaning of "AttachmentSize" isn't clear, then there should be a description here.
     *
     * @param AttachmentSize The value which will be set
     */
    inline void setAttachmentSize (uint64 AttachmentSize_);

    static const AttachmentSizeUpdate &getDefaultInstance();

private:

    inline void set_has_AttachmentSize ();

    inline void clear_has_AttachmentSize ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint64 _AttachmentSize;

};

/**
 * If the meaning of "AttachmentSizeRegister" isn't clear, then there should be a description here.
 */
class AttachmentSizeRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AttachmentSizeRegister ();

    /**
     * Copy constructor
     */
    inline  AttachmentSizeRegister (const AttachmentSizeRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~AttachmentSizeRegister();

    /**
     * Assignment operator
     */
    inline AttachmentSizeRegister& operator = (const AttachmentSizeRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AttachmentSizeRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AttachmentSizeRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AttachmentSizeRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AttachmentSizeRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const AttachmentSizeRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "StatusUpdate" isn't clear, then there should be a description here.
 */
class StatusUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StatusUpdate ();

    /**
     * Copy constructor
     */
    inline  StatusUpdate (const StatusUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  StatusUpdate (const ::std::string& Status_);

    /**
     * Destructor
     */
    inline virtual  ~StatusUpdate();

    /**
     * Assignment operator
     */
    inline StatusUpdate& operator = (const StatusUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StatusUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StatusUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StatusUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StatusUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Status"

    static const int kStatus = 0;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     * If the meaning of "Status" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Status"
     */
    inline const ::std::string& getStatus () const;

    /**
     * Retrieves the value of the field "Status" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Status".
     */
    inline ::std::string& getStatusMutable ();

    /**
     * Sets the value of the member "Status".
     *
     * If the meaning of "Status" isn't clear, then there should be a description here.
     *
     * @param Status The value which will be set
     */
    inline void setStatus (const ::std::string& Status_);

    /**
     * Sets the value of the member "Status".
     *
     * If the meaning of "Status" isn't clear, then there should be a description here.
     *
     * @param Status The value which will be set
     */
    inline void setStatus (const char* Status_);

    /**
     * Sets the value of the member "Status".
     *
     * If the meaning of "Status" isn't clear, then there should be a description here.
     *
     * @param Status The value which will be set
     */
    inline void setStatus (const char* value, size_t size);

    static const StatusUpdate &getDefaultInstance();

private:

    inline void set_has_Status ();

    inline void clear_has_Status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _Status;

};

/**
 * If the meaning of "StatusRegister" isn't clear, then there should be a description here.
 */
class StatusRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StatusRegister ();

    /**
     * Copy constructor
     */
    inline  StatusRegister (const StatusRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~StatusRegister();

    /**
     * Assignment operator
     */
    inline StatusRegister& operator = (const StatusRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StatusRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StatusRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StatusRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StatusRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const StatusRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "PriorityUpdate" isn't clear, then there should be a description here.
 */
class PriorityUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PriorityUpdate ();

    /**
     * Copy constructor
     */
    inline  PriorityUpdate (const PriorityUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  PriorityUpdate (bool Priority_);

    /**
     * Destructor
     */
    inline virtual  ~PriorityUpdate();

    /**
     * Assignment operator
     */
    inline PriorityUpdate& operator = (const PriorityUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PriorityUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PriorityUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PriorityUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PriorityUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Priority"

    static const int kPriority = 0;

    /**
     * Clears the field "Priority".
     *
     * The field will be set to its default value. The hasPriority()
     * method will return false.
     */
    inline void clearPriority();

    /**
     * Checks whether the field "Priority" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPriority()). Otherwise it will return false.
     */
    inline bool hasPriority () const;

    /**
     * Returns the value of the member "Priority".
     *
     * If the meaning of "Priority" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Priority"
     */
    inline bool getPriority () const;

    /**
     * Sets the value of the member "Priority".
     *
     * If the meaning of "Priority" isn't clear, then there should be a description here.
     *
     * @param Priority The value which will be set
     */
    inline void setPriority (bool Priority_);

    static const PriorityUpdate &getDefaultInstance();

private:

    inline void set_has_Priority ();

    inline void clear_has_Priority ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _Priority;

};

/**
 * If the meaning of "PriorityRegister" isn't clear, then there should be a description here.
 */
class PriorityRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PriorityRegister ();

    /**
     * Copy constructor
     */
    inline  PriorityRegister (const PriorityRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~PriorityRegister();

    /**
     * Assignment operator
     */
    inline PriorityRegister& operator = (const PriorityRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PriorityRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PriorityRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PriorityRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PriorityRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const PriorityRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "ReadUpdate" isn't clear, then there should be a description here.
 */
class ReadUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReadUpdate ();

    /**
     * Copy constructor
     */
    inline  ReadUpdate (const ReadUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  ReadUpdate (bool Read_);

    /**
     * Destructor
     */
    inline virtual  ~ReadUpdate();

    /**
     * Assignment operator
     */
    inline ReadUpdate& operator = (const ReadUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReadUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReadUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReadUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReadUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Read"

    static const int kRead = 0;

    /**
     * Clears the field "Read".
     *
     * The field will be set to its default value. The hasRead()
     * method will return false.
     */
    inline void clearRead();

    /**
     * Checks whether the field "Read" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRead()). Otherwise it will return false.
     */
    inline bool hasRead () const;

    /**
     * Returns the value of the member "Read".
     *
     * If the meaning of "Read" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Read"
     */
    inline bool getRead () const;

    /**
     * Sets the value of the member "Read".
     *
     * If the meaning of "Read" isn't clear, then there should be a description here.
     *
     * @param Read The value which will be set
     */
    inline void setRead (bool Read_);

    static const ReadUpdate &getDefaultInstance();

private:

    inline void set_has_Read ();

    inline void clear_has_Read ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _Read;

};

/**
 * If the meaning of "ReadRegister" isn't clear, then there should be a description here.
 */
class ReadRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReadRegister ();

    /**
     * Copy constructor
     */
    inline  ReadRegister (const ReadRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~ReadRegister();

    /**
     * Assignment operator
     */
    inline ReadRegister& operator = (const ReadRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReadRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReadRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReadRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReadRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const ReadRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "DeletedUpdate" isn't clear, then there should be a description here.
 */
class DeletedUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DeletedUpdate ();

    /**
     * Copy constructor
     */
    inline  DeletedUpdate (const DeletedUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  DeletedUpdate (bool Deleted_);

    /**
     * Destructor
     */
    inline virtual  ~DeletedUpdate();

    /**
     * Assignment operator
     */
    inline DeletedUpdate& operator = (const DeletedUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeletedUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeletedUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeletedUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeletedUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Deleted"

    static const int kDeleted = 0;

    /**
     * Clears the field "Deleted".
     *
     * The field will be set to its default value. The hasDeleted()
     * method will return false.
     */
    inline void clearDeleted();

    /**
     * Checks whether the field "Deleted" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeleted()). Otherwise it will return false.
     */
    inline bool hasDeleted () const;

    /**
     * Returns the value of the member "Deleted".
     *
     * If the meaning of "Deleted" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Deleted"
     */
    inline bool getDeleted () const;

    /**
     * Sets the value of the member "Deleted".
     *
     * If the meaning of "Deleted" isn't clear, then there should be a description here.
     *
     * @param Deleted The value which will be set
     */
    inline void setDeleted (bool Deleted_);

    static const DeletedUpdate &getDefaultInstance();

private:

    inline void set_has_Deleted ();

    inline void clear_has_Deleted ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _Deleted;

};

/**
 * If the meaning of "DeletedRegister" isn't clear, then there should be a description here.
 */
class DeletedRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DeletedRegister ();

    /**
     * Copy constructor
     */
    inline  DeletedRegister (const DeletedRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~DeletedRegister();

    /**
     * Assignment operator
     */
    inline DeletedRegister& operator = (const DeletedRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeletedRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeletedRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeletedRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeletedRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const DeletedRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "SentUpdate" isn't clear, then there should be a description here.
 */
class SentUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SentUpdate ();

    /**
     * Copy constructor
     */
    inline  SentUpdate (const SentUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  SentUpdate (bool Sent_);

    /**
     * Destructor
     */
    inline virtual  ~SentUpdate();

    /**
     * Assignment operator
     */
    inline SentUpdate& operator = (const SentUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SentUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SentUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SentUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SentUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Sent"

    static const int kSent = 0;

    /**
     * Clears the field "Sent".
     *
     * The field will be set to its default value. The hasSent()
     * method will return false.
     */
    inline void clearSent();

    /**
     * Checks whether the field "Sent" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSent()). Otherwise it will return false.
     */
    inline bool hasSent () const;

    /**
     * Returns the value of the member "Sent".
     *
     * If the meaning of "Sent" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Sent"
     */
    inline bool getSent () const;

    /**
     * Sets the value of the member "Sent".
     *
     * If the meaning of "Sent" isn't clear, then there should be a description here.
     *
     * @param Sent The value which will be set
     */
    inline void setSent (bool Sent_);

    static const SentUpdate &getDefaultInstance();

private:

    inline void set_has_Sent ();

    inline void clear_has_Sent ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _Sent;

};

/**
 * If the meaning of "SentRegister" isn't clear, then there should be a description here.
 */
class SentRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SentRegister ();

    /**
     * Copy constructor
     */
    inline  SentRegister (const SentRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~SentRegister();

    /**
     * Assignment operator
     */
    inline SentRegister& operator = (const SentRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SentRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SentRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SentRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SentRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const SentRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "ProtectedUpdate" isn't clear, then there should be a description here.
 */
class ProtectedUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ProtectedUpdate ();

    /**
     * Copy constructor
     */
    inline  ProtectedUpdate (const ProtectedUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  ProtectedUpdate (bool Protected_);

    /**
     * Destructor
     */
    inline virtual  ~ProtectedUpdate();

    /**
     * Assignment operator
     */
    inline ProtectedUpdate& operator = (const ProtectedUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ProtectedUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ProtectedUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ProtectedUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ProtectedUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Protected"

    static const int kProtected = 0;

    /**
     * Clears the field "Protected".
     *
     * The field will be set to its default value. The hasProtected()
     * method will return false.
     */
    inline void clearProtected();

    /**
     * Checks whether the field "Protected" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setProtected()). Otherwise it will return false.
     */
    inline bool hasProtected () const;

    /**
     * Returns the value of the member "Protected".
     *
     * If the meaning of "Protected" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Protected"
     */
    inline bool getProtected () const;

    /**
     * Sets the value of the member "Protected".
     *
     * If the meaning of "Protected" isn't clear, then there should be a description here.
     *
     * @param Protected The value which will be set
     */
    inline void setProtected (bool Protected_);

    static const ProtectedUpdate &getDefaultInstance();

private:

    inline void set_has_Protected ();

    inline void clear_has_Protected ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _Protected;

};

/**
 * If the meaning of "ProtectedRegister" isn't clear, then there should be a description here.
 */
class ProtectedRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ProtectedRegister ();

    /**
     * Copy constructor
     */
    inline  ProtectedRegister (const ProtectedRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~ProtectedRegister();

    /**
     * Assignment operator
     */
    inline ProtectedRegister& operator = (const ProtectedRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ProtectedRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ProtectedRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ProtectedRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ProtectedRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const ProtectedRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "TextUpdate" isn't clear, then there should be a description here.
 */
class TextUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TextUpdate ();

    /**
     * Copy constructor
     */
    inline  TextUpdate (const TextUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  TextUpdate (bool Text_);

    /**
     * Destructor
     */
    inline virtual  ~TextUpdate();

    /**
     * Assignment operator
     */
    inline TextUpdate& operator = (const TextUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TextUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TextUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TextUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TextUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Text"

    static const int kText = 0;

    /**
     * Clears the field "Text".
     *
     * The field will be set to its default value. The hasText()
     * method will return false.
     */
    inline void clearText();

    /**
     * Checks whether the field "Text" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setText()). Otherwise it will return false.
     */
    inline bool hasText () const;

    /**
     * Returns the value of the member "Text".
     *
     * If the meaning of "Text" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Text"
     */
    inline bool getText () const;

    /**
     * Sets the value of the member "Text".
     *
     * If the meaning of "Text" isn't clear, then there should be a description here.
     *
     * @param Text The value which will be set
     */
    inline void setText (bool Text_);

    static const TextUpdate &getDefaultInstance();

private:

    inline void set_has_Text ();

    inline void clear_has_Text ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _Text;

};

/**
 * If the meaning of "TextRegister" isn't clear, then there should be a description here.
 */
class TextRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TextRegister ();

    /**
     * Copy constructor
     */
    inline  TextRegister (const TextRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~TextRegister();

    /**
     * Assignment operator
     */
    inline TextRegister& operator = (const TextRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TextRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TextRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TextRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TextRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const TextRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

inline  GetRequest::GetRequest ()  :
    _targetfile (),
    _attachment (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetRequest::GetRequest (const GetRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _targetfile (),
    _attachment (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetRequest::GetRequest (const ::std::string& targetfile_, bool attachment_)  :
    _targetfile (targetfile_),
    _attachment (attachment_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (targetfile_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetRequest::~GetRequest() {
}

inline GetRequest& GetRequest::operator = (const GetRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTargetfile()) {
            setTargetfile(rhs.getTargetfile());
        } else {
            clearTargetfile();
        }
        if (rhs.hasAttachment()) {
            setAttachment(rhs.getAttachment());
        } else {
            clearAttachment();
        }
    }
    return *this;
}

inline bool GetRequest::operator == (const GetRequest& rhs) const {
    return (((!hasTargetfile() && !rhs.hasTargetfile()) || getTargetfile() == rhs.getTargetfile()) &&
        ((!hasAttachment() && !rhs.hasAttachment()) || getAttachment() == rhs.getAttachment()));
}

inline bool GetRequest::operator != (const GetRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool GetRequest::operator < (const GetRequest& rhs) const {
    if (hasTargetfile() || rhs.hasTargetfile()) {
        if (getTargetfile() < rhs.getTargetfile()) return true;
        if (getTargetfile() > rhs.getTargetfile()) return false;
    }
    if (hasAttachment() || rhs.hasAttachment()) {
        if (getAttachment() < rhs.getAttachment()) return true;
        if (getAttachment() > rhs.getAttachment()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetRequest::clone() {
    return new GetRequest(*this);
}

inline bool GetRequest::operator > (const GetRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetRequest::clear() {
    clearTargetfile();
    clearAttachment();
}

inline void GetRequest::clearTargetfile() {
    if (hasTargetfile()) {
         clear_has_targetfile();
        _targetfile.clear();
     }
}

inline bool GetRequest::hasTargetfile () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& GetRequest::getTargetfile () const {
    return _targetfile;
}

inline ::std::string& GetRequest::getTargetfileMutable () {
    set_has_targetfile();
    return _targetfile;
}

inline void GetRequest::setTargetfile (const ::std::string& targetfile_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (targetfile_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_targetfile();
    this->_targetfile = targetfile_;
}

inline void GetRequest::setTargetfile (const char* targetfile_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (targetfile_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_targetfile();
    this->_targetfile.assign(targetfile_);
}

inline void GetRequest::setTargetfile (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_targetfile();
    this->_targetfile.assign(value, size);
}

inline void GetRequest::clearAttachment() {
    if (hasAttachment()) {
         clear_has_attachment();
        _attachment = false;
     }
}

inline bool GetRequest::hasAttachment () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline bool GetRequest::getAttachment () const {
    return _attachment;
}

inline void GetRequest::setAttachment (bool attachment_) {
    set_has_attachment();
    this->_attachment = attachment_;
}

inline void GetRequest::set_has_targetfile () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetRequest::clear_has_targetfile () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GetRequest::set_has_attachment () {
    _has_bits_[0] |= 1u << 1;
}

inline void GetRequest::clear_has_attachment () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  GetResponse::GetResponse ()  :
    _transfer ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetResponse::GetResponse (const GetResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _transfer ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetResponse::GetResponse (const ::std::string& transfer_)  :
    _transfer (transfer_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (transfer_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetResponse::~GetResponse() {
}

inline GetResponse& GetResponse::operator = (const GetResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTransfer()) {
            setTransfer(rhs.getTransfer());
        } else {
            clearTransfer();
        }
    }
    return *this;
}

inline bool GetResponse::operator == (const GetResponse& rhs) const {
    return (((!hasTransfer() && !rhs.hasTransfer()) || getTransfer() == rhs.getTransfer()));
}

inline bool GetResponse::operator != (const GetResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool GetResponse::operator < (const GetResponse& rhs) const {
    if (hasTransfer() || rhs.hasTransfer()) {
        if (getTransfer() < rhs.getTransfer()) return true;
        if (getTransfer() > rhs.getTransfer()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetResponse::clone() {
    return new GetResponse(*this);
}

inline bool GetResponse::operator > (const GetResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetResponse::clear() {
    clearTransfer();
}

inline void GetResponse::clearTransfer() {
    if (hasTransfer()) {
         clear_has_transfer();
        _transfer.clear();
     }
}

inline bool GetResponse::hasTransfer () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& GetResponse::getTransfer () const {
    return _transfer;
}

inline ::std::string& GetResponse::getTransferMutable () {
    set_has_transfer();
    return _transfer;
}

inline void GetResponse::setTransfer (const ::std::string& transfer_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (transfer_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_transfer();
    this->_transfer = transfer_;
}

inline void GetResponse::setTransfer (const char* transfer_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (transfer_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_transfer();
    this->_transfer.assign(transfer_);
}

inline void GetResponse::setTransfer (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_transfer();
    this->_transfer.assign(value, size);
}

inline void GetResponse::set_has_transfer () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetResponse::clear_has_transfer () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  FolderUpdate::FolderUpdate ()  :
    _Folder ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FolderUpdate::FolderUpdate (const FolderUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _Folder ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FolderUpdate::FolderUpdate (const ::std::string& Folder_)  :
    _Folder (Folder_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Folder_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  FolderUpdate::~FolderUpdate() {
}

inline FolderUpdate& FolderUpdate::operator = (const FolderUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasFolder()) {
            setFolder(rhs.getFolder());
        } else {
            clearFolder();
        }
    }
    return *this;
}

inline bool FolderUpdate::operator == (const FolderUpdate& rhs) const {
    return (((!hasFolder() && !rhs.hasFolder()) || getFolder() == rhs.getFolder()));
}

inline bool FolderUpdate::operator != (const FolderUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool FolderUpdate::operator < (const FolderUpdate& rhs) const {
    if (hasFolder() || rhs.hasFolder()) {
        if (getFolder() < rhs.getFolder()) return true;
        if (getFolder() > rhs.getFolder()) return false;
    }
    return false;
}

inline ::asf::core::Payload* FolderUpdate::clone() {
    return new FolderUpdate(*this);
}

inline bool FolderUpdate::operator > (const FolderUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FolderUpdate::clear() {
    clearFolder();
}

inline void FolderUpdate::clearFolder() {
    if (hasFolder()) {
         clear_has_Folder();
        _Folder.clear();
     }
}

inline bool FolderUpdate::hasFolder () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& FolderUpdate::getFolder () const {
    return _Folder;
}

inline ::std::string& FolderUpdate::getFolderMutable () {
    set_has_Folder();
    return _Folder;
}

inline void FolderUpdate::setFolder (const ::std::string& Folder_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Folder_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Folder();
    this->_Folder = Folder_;
}

inline void FolderUpdate::setFolder (const char* Folder_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Folder_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Folder();
    this->_Folder.assign(Folder_);
}

inline void FolderUpdate::setFolder (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Folder();
    this->_Folder.assign(value, size);
}

inline void FolderUpdate::set_has_Folder () {
    _has_bits_[0] |= 1u << 0;
}

inline void FolderUpdate::clear_has_Folder () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  FolderRegister::FolderRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FolderRegister::FolderRegister (const FolderRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FolderRegister::~FolderRegister() {
}

inline FolderRegister& FolderRegister::operator = (const FolderRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool FolderRegister::operator == (const FolderRegister& ) const {
    return true;
}

inline bool FolderRegister::operator != (const FolderRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool FolderRegister::operator < (const FolderRegister& ) const {
    return false;
}

inline ::asf::core::Payload* FolderRegister::clone() {
    return new FolderRegister(*this);
}

inline bool FolderRegister::operator > (const FolderRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FolderRegister::clear() {
}

inline  SubjectUpdate::SubjectUpdate ()  :
    _Subject ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SubjectUpdate::SubjectUpdate (const SubjectUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _Subject ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SubjectUpdate::SubjectUpdate (const ::std::string& Subject_)  :
    _Subject (Subject_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Subject_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SubjectUpdate::~SubjectUpdate() {
}

inline SubjectUpdate& SubjectUpdate::operator = (const SubjectUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSubject()) {
            setSubject(rhs.getSubject());
        } else {
            clearSubject();
        }
    }
    return *this;
}

inline bool SubjectUpdate::operator == (const SubjectUpdate& rhs) const {
    return (((!hasSubject() && !rhs.hasSubject()) || getSubject() == rhs.getSubject()));
}

inline bool SubjectUpdate::operator != (const SubjectUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool SubjectUpdate::operator < (const SubjectUpdate& rhs) const {
    if (hasSubject() || rhs.hasSubject()) {
        if (getSubject() < rhs.getSubject()) return true;
        if (getSubject() > rhs.getSubject()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SubjectUpdate::clone() {
    return new SubjectUpdate(*this);
}

inline bool SubjectUpdate::operator > (const SubjectUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SubjectUpdate::clear() {
    clearSubject();
}

inline void SubjectUpdate::clearSubject() {
    if (hasSubject()) {
         clear_has_Subject();
        _Subject.clear();
     }
}

inline bool SubjectUpdate::hasSubject () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& SubjectUpdate::getSubject () const {
    return _Subject;
}

inline ::std::string& SubjectUpdate::getSubjectMutable () {
    set_has_Subject();
    return _Subject;
}

inline void SubjectUpdate::setSubject (const ::std::string& Subject_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Subject_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Subject();
    this->_Subject = Subject_;
}

inline void SubjectUpdate::setSubject (const char* Subject_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Subject_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Subject();
    this->_Subject.assign(Subject_);
}

inline void SubjectUpdate::setSubject (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Subject();
    this->_Subject.assign(value, size);
}

inline void SubjectUpdate::set_has_Subject () {
    _has_bits_[0] |= 1u << 0;
}

inline void SubjectUpdate::clear_has_Subject () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SubjectRegister::SubjectRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SubjectRegister::SubjectRegister (const SubjectRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SubjectRegister::~SubjectRegister() {
}

inline SubjectRegister& SubjectRegister::operator = (const SubjectRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool SubjectRegister::operator == (const SubjectRegister& ) const {
    return true;
}

inline bool SubjectRegister::operator != (const SubjectRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool SubjectRegister::operator < (const SubjectRegister& ) const {
    return false;
}

inline ::asf::core::Payload* SubjectRegister::clone() {
    return new SubjectRegister(*this);
}

inline bool SubjectRegister::operator > (const SubjectRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SubjectRegister::clear() {
}

inline  TimestampUpdate::TimestampUpdate ()  :
    _Timestamp ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  TimestampUpdate::TimestampUpdate (const TimestampUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _Timestamp ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  TimestampUpdate::TimestampUpdate (const ::std::string& Timestamp_)  :
    _Timestamp (Timestamp_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Timestamp_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  TimestampUpdate::~TimestampUpdate() {
}

inline TimestampUpdate& TimestampUpdate::operator = (const TimestampUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTimestamp()) {
            setTimestamp(rhs.getTimestamp());
        } else {
            clearTimestamp();
        }
    }
    return *this;
}

inline bool TimestampUpdate::operator == (const TimestampUpdate& rhs) const {
    return (((!hasTimestamp() && !rhs.hasTimestamp()) || getTimestamp() == rhs.getTimestamp()));
}

inline bool TimestampUpdate::operator != (const TimestampUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool TimestampUpdate::operator < (const TimestampUpdate& rhs) const {
    if (hasTimestamp() || rhs.hasTimestamp()) {
        if (getTimestamp() < rhs.getTimestamp()) return true;
        if (getTimestamp() > rhs.getTimestamp()) return false;
    }
    return false;
}

inline ::asf::core::Payload* TimestampUpdate::clone() {
    return new TimestampUpdate(*this);
}

inline bool TimestampUpdate::operator > (const TimestampUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void TimestampUpdate::clear() {
    clearTimestamp();
}

inline void TimestampUpdate::clearTimestamp() {
    if (hasTimestamp()) {
         clear_has_Timestamp();
        _Timestamp.clear();
     }
}

inline bool TimestampUpdate::hasTimestamp () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& TimestampUpdate::getTimestamp () const {
    return _Timestamp;
}

inline ::std::string& TimestampUpdate::getTimestampMutable () {
    set_has_Timestamp();
    return _Timestamp;
}

inline void TimestampUpdate::setTimestamp (const ::std::string& Timestamp_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Timestamp_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Timestamp();
    this->_Timestamp = Timestamp_;
}

inline void TimestampUpdate::setTimestamp (const char* Timestamp_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Timestamp_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Timestamp();
    this->_Timestamp.assign(Timestamp_);
}

inline void TimestampUpdate::setTimestamp (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Timestamp();
    this->_Timestamp.assign(value, size);
}

inline void TimestampUpdate::set_has_Timestamp () {
    _has_bits_[0] |= 1u << 0;
}

inline void TimestampUpdate::clear_has_Timestamp () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  TimestampRegister::TimestampRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  TimestampRegister::TimestampRegister (const TimestampRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  TimestampRegister::~TimestampRegister() {
}

inline TimestampRegister& TimestampRegister::operator = (const TimestampRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool TimestampRegister::operator == (const TimestampRegister& ) const {
    return true;
}

inline bool TimestampRegister::operator != (const TimestampRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool TimestampRegister::operator < (const TimestampRegister& ) const {
    return false;
}

inline ::asf::core::Payload* TimestampRegister::clone() {
    return new TimestampRegister(*this);
}

inline bool TimestampRegister::operator > (const TimestampRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void TimestampRegister::clear() {
}

inline  SenderUpdate::SenderUpdate ()  :
    _Sender ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SenderUpdate::SenderUpdate (const SenderUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _Sender ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SenderUpdate::SenderUpdate (const ::std::string& Sender_)  :
    _Sender (Sender_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Sender_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SenderUpdate::~SenderUpdate() {
}

inline SenderUpdate& SenderUpdate::operator = (const SenderUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSender()) {
            setSender(rhs.getSender());
        } else {
            clearSender();
        }
    }
    return *this;
}

inline bool SenderUpdate::operator == (const SenderUpdate& rhs) const {
    return (((!hasSender() && !rhs.hasSender()) || getSender() == rhs.getSender()));
}

inline bool SenderUpdate::operator != (const SenderUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool SenderUpdate::operator < (const SenderUpdate& rhs) const {
    if (hasSender() || rhs.hasSender()) {
        if (getSender() < rhs.getSender()) return true;
        if (getSender() > rhs.getSender()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SenderUpdate::clone() {
    return new SenderUpdate(*this);
}

inline bool SenderUpdate::operator > (const SenderUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SenderUpdate::clear() {
    clearSender();
}

inline void SenderUpdate::clearSender() {
    if (hasSender()) {
         clear_has_Sender();
        _Sender.clear();
     }
}

inline bool SenderUpdate::hasSender () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& SenderUpdate::getSender () const {
    return _Sender;
}

inline ::std::string& SenderUpdate::getSenderMutable () {
    set_has_Sender();
    return _Sender;
}

inline void SenderUpdate::setSender (const ::std::string& Sender_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Sender_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Sender();
    this->_Sender = Sender_;
}

inline void SenderUpdate::setSender (const char* Sender_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Sender_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Sender();
    this->_Sender.assign(Sender_);
}

inline void SenderUpdate::setSender (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Sender();
    this->_Sender.assign(value, size);
}

inline void SenderUpdate::set_has_Sender () {
    _has_bits_[0] |= 1u << 0;
}

inline void SenderUpdate::clear_has_Sender () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SenderRegister::SenderRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SenderRegister::SenderRegister (const SenderRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SenderRegister::~SenderRegister() {
}

inline SenderRegister& SenderRegister::operator = (const SenderRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool SenderRegister::operator == (const SenderRegister& ) const {
    return true;
}

inline bool SenderRegister::operator != (const SenderRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool SenderRegister::operator < (const SenderRegister& ) const {
    return false;
}

inline ::asf::core::Payload* SenderRegister::clone() {
    return new SenderRegister(*this);
}

inline bool SenderRegister::operator > (const SenderRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SenderRegister::clear() {
}

inline  SenderAddressUpdate::SenderAddressUpdate ()  :
    _SenderAddress ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SenderAddressUpdate::SenderAddressUpdate (const SenderAddressUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _SenderAddress ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SenderAddressUpdate::SenderAddressUpdate (const ::std::string& SenderAddress_)  :
    _SenderAddress (SenderAddress_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (SenderAddress_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SenderAddressUpdate::~SenderAddressUpdate() {
}

inline SenderAddressUpdate& SenderAddressUpdate::operator = (const SenderAddressUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSenderAddress()) {
            setSenderAddress(rhs.getSenderAddress());
        } else {
            clearSenderAddress();
        }
    }
    return *this;
}

inline bool SenderAddressUpdate::operator == (const SenderAddressUpdate& rhs) const {
    return (((!hasSenderAddress() && !rhs.hasSenderAddress()) || getSenderAddress() == rhs.getSenderAddress()));
}

inline bool SenderAddressUpdate::operator != (const SenderAddressUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool SenderAddressUpdate::operator < (const SenderAddressUpdate& rhs) const {
    if (hasSenderAddress() || rhs.hasSenderAddress()) {
        if (getSenderAddress() < rhs.getSenderAddress()) return true;
        if (getSenderAddress() > rhs.getSenderAddress()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SenderAddressUpdate::clone() {
    return new SenderAddressUpdate(*this);
}

inline bool SenderAddressUpdate::operator > (const SenderAddressUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SenderAddressUpdate::clear() {
    clearSenderAddress();
}

inline void SenderAddressUpdate::clearSenderAddress() {
    if (hasSenderAddress()) {
         clear_has_SenderAddress();
        _SenderAddress.clear();
     }
}

inline bool SenderAddressUpdate::hasSenderAddress () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& SenderAddressUpdate::getSenderAddress () const {
    return _SenderAddress;
}

inline ::std::string& SenderAddressUpdate::getSenderAddressMutable () {
    set_has_SenderAddress();
    return _SenderAddress;
}

inline void SenderAddressUpdate::setSenderAddress (const ::std::string& SenderAddress_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (SenderAddress_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_SenderAddress();
    this->_SenderAddress = SenderAddress_;
}

inline void SenderAddressUpdate::setSenderAddress (const char* SenderAddress_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (SenderAddress_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_SenderAddress();
    this->_SenderAddress.assign(SenderAddress_);
}

inline void SenderAddressUpdate::setSenderAddress (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_SenderAddress();
    this->_SenderAddress.assign(value, size);
}

inline void SenderAddressUpdate::set_has_SenderAddress () {
    _has_bits_[0] |= 1u << 0;
}

inline void SenderAddressUpdate::clear_has_SenderAddress () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SenderAddressRegister::SenderAddressRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SenderAddressRegister::SenderAddressRegister (const SenderAddressRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SenderAddressRegister::~SenderAddressRegister() {
}

inline SenderAddressRegister& SenderAddressRegister::operator = (const SenderAddressRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool SenderAddressRegister::operator == (const SenderAddressRegister& ) const {
    return true;
}

inline bool SenderAddressRegister::operator != (const SenderAddressRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool SenderAddressRegister::operator < (const SenderAddressRegister& ) const {
    return false;
}

inline ::asf::core::Payload* SenderAddressRegister::clone() {
    return new SenderAddressRegister(*this);
}

inline bool SenderAddressRegister::operator > (const SenderAddressRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SenderAddressRegister::clear() {
}

inline  ReplyToUpdate::ReplyToUpdate ()  :
    _ReplyTo ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ReplyToUpdate::ReplyToUpdate (const ReplyToUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _ReplyTo ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ReplyToUpdate::ReplyToUpdate (const ::std::string& ReplyTo_)  :
    _ReplyTo (ReplyTo_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ReplyTo_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ReplyToUpdate::~ReplyToUpdate() {
}

inline ReplyToUpdate& ReplyToUpdate::operator = (const ReplyToUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasReplyTo()) {
            setReplyTo(rhs.getReplyTo());
        } else {
            clearReplyTo();
        }
    }
    return *this;
}

inline bool ReplyToUpdate::operator == (const ReplyToUpdate& rhs) const {
    return (((!hasReplyTo() && !rhs.hasReplyTo()) || getReplyTo() == rhs.getReplyTo()));
}

inline bool ReplyToUpdate::operator != (const ReplyToUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool ReplyToUpdate::operator < (const ReplyToUpdate& rhs) const {
    if (hasReplyTo() || rhs.hasReplyTo()) {
        if (getReplyTo() < rhs.getReplyTo()) return true;
        if (getReplyTo() > rhs.getReplyTo()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ReplyToUpdate::clone() {
    return new ReplyToUpdate(*this);
}

inline bool ReplyToUpdate::operator > (const ReplyToUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ReplyToUpdate::clear() {
    clearReplyTo();
}

inline void ReplyToUpdate::clearReplyTo() {
    if (hasReplyTo()) {
         clear_has_ReplyTo();
        _ReplyTo.clear();
     }
}

inline bool ReplyToUpdate::hasReplyTo () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& ReplyToUpdate::getReplyTo () const {
    return _ReplyTo;
}

inline ::std::string& ReplyToUpdate::getReplyToMutable () {
    set_has_ReplyTo();
    return _ReplyTo;
}

inline void ReplyToUpdate::setReplyTo (const ::std::string& ReplyTo_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ReplyTo_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ReplyTo();
    this->_ReplyTo = ReplyTo_;
}

inline void ReplyToUpdate::setReplyTo (const char* ReplyTo_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ReplyTo_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ReplyTo();
    this->_ReplyTo.assign(ReplyTo_);
}

inline void ReplyToUpdate::setReplyTo (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ReplyTo();
    this->_ReplyTo.assign(value, size);
}

inline void ReplyToUpdate::set_has_ReplyTo () {
    _has_bits_[0] |= 1u << 0;
}

inline void ReplyToUpdate::clear_has_ReplyTo () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ReplyToRegister::ReplyToRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ReplyToRegister::ReplyToRegister (const ReplyToRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ReplyToRegister::~ReplyToRegister() {
}

inline ReplyToRegister& ReplyToRegister::operator = (const ReplyToRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool ReplyToRegister::operator == (const ReplyToRegister& ) const {
    return true;
}

inline bool ReplyToRegister::operator != (const ReplyToRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool ReplyToRegister::operator < (const ReplyToRegister& ) const {
    return false;
}

inline ::asf::core::Payload* ReplyToRegister::clone() {
    return new ReplyToRegister(*this);
}

inline bool ReplyToRegister::operator > (const ReplyToRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ReplyToRegister::clear() {
}

inline  RecipientUpdate::RecipientUpdate ()  :
    _Recipient ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RecipientUpdate::RecipientUpdate (const RecipientUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _Recipient ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RecipientUpdate::RecipientUpdate (const ::std::string& Recipient_)  :
    _Recipient (Recipient_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Recipient_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RecipientUpdate::~RecipientUpdate() {
}

inline RecipientUpdate& RecipientUpdate::operator = (const RecipientUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasRecipient()) {
            setRecipient(rhs.getRecipient());
        } else {
            clearRecipient();
        }
    }
    return *this;
}

inline bool RecipientUpdate::operator == (const RecipientUpdate& rhs) const {
    return (((!hasRecipient() && !rhs.hasRecipient()) || getRecipient() == rhs.getRecipient()));
}

inline bool RecipientUpdate::operator != (const RecipientUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool RecipientUpdate::operator < (const RecipientUpdate& rhs) const {
    if (hasRecipient() || rhs.hasRecipient()) {
        if (getRecipient() < rhs.getRecipient()) return true;
        if (getRecipient() > rhs.getRecipient()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RecipientUpdate::clone() {
    return new RecipientUpdate(*this);
}

inline bool RecipientUpdate::operator > (const RecipientUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RecipientUpdate::clear() {
    clearRecipient();
}

inline void RecipientUpdate::clearRecipient() {
    if (hasRecipient()) {
         clear_has_Recipient();
        _Recipient.clear();
     }
}

inline bool RecipientUpdate::hasRecipient () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& RecipientUpdate::getRecipient () const {
    return _Recipient;
}

inline ::std::string& RecipientUpdate::getRecipientMutable () {
    set_has_Recipient();
    return _Recipient;
}

inline void RecipientUpdate::setRecipient (const ::std::string& Recipient_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Recipient_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Recipient();
    this->_Recipient = Recipient_;
}

inline void RecipientUpdate::setRecipient (const char* Recipient_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Recipient_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Recipient();
    this->_Recipient.assign(Recipient_);
}

inline void RecipientUpdate::setRecipient (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Recipient();
    this->_Recipient.assign(value, size);
}

inline void RecipientUpdate::set_has_Recipient () {
    _has_bits_[0] |= 1u << 0;
}

inline void RecipientUpdate::clear_has_Recipient () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  RecipientRegister::RecipientRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RecipientRegister::RecipientRegister (const RecipientRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RecipientRegister::~RecipientRegister() {
}

inline RecipientRegister& RecipientRegister::operator = (const RecipientRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool RecipientRegister::operator == (const RecipientRegister& ) const {
    return true;
}

inline bool RecipientRegister::operator != (const RecipientRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool RecipientRegister::operator < (const RecipientRegister& ) const {
    return false;
}

inline ::asf::core::Payload* RecipientRegister::clone() {
    return new RecipientRegister(*this);
}

inline bool RecipientRegister::operator > (const RecipientRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RecipientRegister::clear() {
}

inline  RecipientAddressUpdate::RecipientAddressUpdate ()  :
    _RecipientAddress ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RecipientAddressUpdate::RecipientAddressUpdate (const RecipientAddressUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _RecipientAddress ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RecipientAddressUpdate::RecipientAddressUpdate (const ::std::string& RecipientAddress_)  :
    _RecipientAddress (RecipientAddress_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (RecipientAddress_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RecipientAddressUpdate::~RecipientAddressUpdate() {
}

inline RecipientAddressUpdate& RecipientAddressUpdate::operator = (const RecipientAddressUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasRecipientAddress()) {
            setRecipientAddress(rhs.getRecipientAddress());
        } else {
            clearRecipientAddress();
        }
    }
    return *this;
}

inline bool RecipientAddressUpdate::operator == (const RecipientAddressUpdate& rhs) const {
    return (((!hasRecipientAddress() && !rhs.hasRecipientAddress()) || getRecipientAddress() == rhs.getRecipientAddress()));
}

inline bool RecipientAddressUpdate::operator != (const RecipientAddressUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool RecipientAddressUpdate::operator < (const RecipientAddressUpdate& rhs) const {
    if (hasRecipientAddress() || rhs.hasRecipientAddress()) {
        if (getRecipientAddress() < rhs.getRecipientAddress()) return true;
        if (getRecipientAddress() > rhs.getRecipientAddress()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RecipientAddressUpdate::clone() {
    return new RecipientAddressUpdate(*this);
}

inline bool RecipientAddressUpdate::operator > (const RecipientAddressUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RecipientAddressUpdate::clear() {
    clearRecipientAddress();
}

inline void RecipientAddressUpdate::clearRecipientAddress() {
    if (hasRecipientAddress()) {
         clear_has_RecipientAddress();
        _RecipientAddress.clear();
     }
}

inline bool RecipientAddressUpdate::hasRecipientAddress () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& RecipientAddressUpdate::getRecipientAddress () const {
    return _RecipientAddress;
}

inline ::std::string& RecipientAddressUpdate::getRecipientAddressMutable () {
    set_has_RecipientAddress();
    return _RecipientAddress;
}

inline void RecipientAddressUpdate::setRecipientAddress (const ::std::string& RecipientAddress_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (RecipientAddress_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_RecipientAddress();
    this->_RecipientAddress = RecipientAddress_;
}

inline void RecipientAddressUpdate::setRecipientAddress (const char* RecipientAddress_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (RecipientAddress_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_RecipientAddress();
    this->_RecipientAddress.assign(RecipientAddress_);
}

inline void RecipientAddressUpdate::setRecipientAddress (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_RecipientAddress();
    this->_RecipientAddress.assign(value, size);
}

inline void RecipientAddressUpdate::set_has_RecipientAddress () {
    _has_bits_[0] |= 1u << 0;
}

inline void RecipientAddressUpdate::clear_has_RecipientAddress () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  RecipientAddressRegister::RecipientAddressRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RecipientAddressRegister::RecipientAddressRegister (const RecipientAddressRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RecipientAddressRegister::~RecipientAddressRegister() {
}

inline RecipientAddressRegister& RecipientAddressRegister::operator = (const RecipientAddressRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool RecipientAddressRegister::operator == (const RecipientAddressRegister& ) const {
    return true;
}

inline bool RecipientAddressRegister::operator != (const RecipientAddressRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool RecipientAddressRegister::operator < (const RecipientAddressRegister& ) const {
    return false;
}

inline ::asf::core::Payload* RecipientAddressRegister::clone() {
    return new RecipientAddressRegister(*this);
}

inline bool RecipientAddressRegister::operator > (const RecipientAddressRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RecipientAddressRegister::clear() {
}

inline  TypeUpdate::TypeUpdate ()  :
    _Type ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  TypeUpdate::TypeUpdate (const TypeUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _Type ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  TypeUpdate::TypeUpdate (const ::std::string& Type_)  :
    _Type (Type_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Type_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  TypeUpdate::~TypeUpdate() {
}

inline TypeUpdate& TypeUpdate::operator = (const TypeUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasType()) {
            setType(rhs.getType());
        } else {
            clearType();
        }
    }
    return *this;
}

inline bool TypeUpdate::operator == (const TypeUpdate& rhs) const {
    return (((!hasType() && !rhs.hasType()) || getType() == rhs.getType()));
}

inline bool TypeUpdate::operator != (const TypeUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool TypeUpdate::operator < (const TypeUpdate& rhs) const {
    if (hasType() || rhs.hasType()) {
        if (getType() < rhs.getType()) return true;
        if (getType() > rhs.getType()) return false;
    }
    return false;
}

inline ::asf::core::Payload* TypeUpdate::clone() {
    return new TypeUpdate(*this);
}

inline bool TypeUpdate::operator > (const TypeUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void TypeUpdate::clear() {
    clearType();
}

inline void TypeUpdate::clearType() {
    if (hasType()) {
         clear_has_Type();
        _Type.clear();
     }
}

inline bool TypeUpdate::hasType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& TypeUpdate::getType () const {
    return _Type;
}

inline ::std::string& TypeUpdate::getTypeMutable () {
    set_has_Type();
    return _Type;
}

inline void TypeUpdate::setType (const ::std::string& Type_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Type_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Type();
    this->_Type = Type_;
}

inline void TypeUpdate::setType (const char* Type_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Type_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Type();
    this->_Type.assign(Type_);
}

inline void TypeUpdate::setType (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Type();
    this->_Type.assign(value, size);
}

inline void TypeUpdate::set_has_Type () {
    _has_bits_[0] |= 1u << 0;
}

inline void TypeUpdate::clear_has_Type () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  TypeRegister::TypeRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  TypeRegister::TypeRegister (const TypeRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  TypeRegister::~TypeRegister() {
}

inline TypeRegister& TypeRegister::operator = (const TypeRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool TypeRegister::operator == (const TypeRegister& ) const {
    return true;
}

inline bool TypeRegister::operator != (const TypeRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool TypeRegister::operator < (const TypeRegister& ) const {
    return false;
}

inline ::asf::core::Payload* TypeRegister::clone() {
    return new TypeRegister(*this);
}

inline bool TypeRegister::operator > (const TypeRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void TypeRegister::clear() {
}

inline  SizeUpdate::SizeUpdate ()  :
    _Size (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SizeUpdate::SizeUpdate (const SizeUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _Size (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SizeUpdate::SizeUpdate (uint64 Size_)  :
    _Size (Size_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SizeUpdate::~SizeUpdate() {
}

inline SizeUpdate& SizeUpdate::operator = (const SizeUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSize()) {
            setSize(rhs.getSize());
        } else {
            clearSize();
        }
    }
    return *this;
}

inline bool SizeUpdate::operator == (const SizeUpdate& rhs) const {
    return (((!hasSize() && !rhs.hasSize()) || getSize() == rhs.getSize()));
}

inline bool SizeUpdate::operator != (const SizeUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool SizeUpdate::operator < (const SizeUpdate& rhs) const {
    if (hasSize() || rhs.hasSize()) {
        if (getSize() < rhs.getSize()) return true;
        if (getSize() > rhs.getSize()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SizeUpdate::clone() {
    return new SizeUpdate(*this);
}

inline bool SizeUpdate::operator > (const SizeUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SizeUpdate::clear() {
    clearSize();
}

inline void SizeUpdate::clearSize() {
    if (hasSize()) {
         clear_has_Size();
        _Size = 0u;
     }
}

inline bool SizeUpdate::hasSize () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint64 SizeUpdate::getSize () const {
    return _Size;
}

inline void SizeUpdate::setSize (uint64 Size_) {
    set_has_Size();
    this->_Size = Size_;
}

inline void SizeUpdate::set_has_Size () {
    _has_bits_[0] |= 1u << 0;
}

inline void SizeUpdate::clear_has_Size () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SizeRegister::SizeRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SizeRegister::SizeRegister (const SizeRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SizeRegister::~SizeRegister() {
}

inline SizeRegister& SizeRegister::operator = (const SizeRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool SizeRegister::operator == (const SizeRegister& ) const {
    return true;
}

inline bool SizeRegister::operator != (const SizeRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool SizeRegister::operator < (const SizeRegister& ) const {
    return false;
}

inline ::asf::core::Payload* SizeRegister::clone() {
    return new SizeRegister(*this);
}

inline bool SizeRegister::operator > (const SizeRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SizeRegister::clear() {
}

inline  AttachmentSizeUpdate::AttachmentSizeUpdate ()  :
    _AttachmentSize (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AttachmentSizeUpdate::AttachmentSizeUpdate (const AttachmentSizeUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _AttachmentSize (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AttachmentSizeUpdate::AttachmentSizeUpdate (uint64 AttachmentSize_)  :
    _AttachmentSize (AttachmentSize_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AttachmentSizeUpdate::~AttachmentSizeUpdate() {
}

inline AttachmentSizeUpdate& AttachmentSizeUpdate::operator = (const AttachmentSizeUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAttachmentSize()) {
            setAttachmentSize(rhs.getAttachmentSize());
        } else {
            clearAttachmentSize();
        }
    }
    return *this;
}

inline bool AttachmentSizeUpdate::operator == (const AttachmentSizeUpdate& rhs) const {
    return (((!hasAttachmentSize() && !rhs.hasAttachmentSize()) || getAttachmentSize() == rhs.getAttachmentSize()));
}

inline bool AttachmentSizeUpdate::operator != (const AttachmentSizeUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool AttachmentSizeUpdate::operator < (const AttachmentSizeUpdate& rhs) const {
    if (hasAttachmentSize() || rhs.hasAttachmentSize()) {
        if (getAttachmentSize() < rhs.getAttachmentSize()) return true;
        if (getAttachmentSize() > rhs.getAttachmentSize()) return false;
    }
    return false;
}

inline ::asf::core::Payload* AttachmentSizeUpdate::clone() {
    return new AttachmentSizeUpdate(*this);
}

inline bool AttachmentSizeUpdate::operator > (const AttachmentSizeUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AttachmentSizeUpdate::clear() {
    clearAttachmentSize();
}

inline void AttachmentSizeUpdate::clearAttachmentSize() {
    if (hasAttachmentSize()) {
         clear_has_AttachmentSize();
        _AttachmentSize = 0u;
     }
}

inline bool AttachmentSizeUpdate::hasAttachmentSize () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint64 AttachmentSizeUpdate::getAttachmentSize () const {
    return _AttachmentSize;
}

inline void AttachmentSizeUpdate::setAttachmentSize (uint64 AttachmentSize_) {
    set_has_AttachmentSize();
    this->_AttachmentSize = AttachmentSize_;
}

inline void AttachmentSizeUpdate::set_has_AttachmentSize () {
    _has_bits_[0] |= 1u << 0;
}

inline void AttachmentSizeUpdate::clear_has_AttachmentSize () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  AttachmentSizeRegister::AttachmentSizeRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AttachmentSizeRegister::AttachmentSizeRegister (const AttachmentSizeRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AttachmentSizeRegister::~AttachmentSizeRegister() {
}

inline AttachmentSizeRegister& AttachmentSizeRegister::operator = (const AttachmentSizeRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool AttachmentSizeRegister::operator == (const AttachmentSizeRegister& ) const {
    return true;
}

inline bool AttachmentSizeRegister::operator != (const AttachmentSizeRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool AttachmentSizeRegister::operator < (const AttachmentSizeRegister& ) const {
    return false;
}

inline ::asf::core::Payload* AttachmentSizeRegister::clone() {
    return new AttachmentSizeRegister(*this);
}

inline bool AttachmentSizeRegister::operator > (const AttachmentSizeRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AttachmentSizeRegister::clear() {
}

inline  StatusUpdate::StatusUpdate ()  :
    _Status ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  StatusUpdate::StatusUpdate (const StatusUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _Status ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  StatusUpdate::StatusUpdate (const ::std::string& Status_)  :
    _Status (Status_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Status_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  StatusUpdate::~StatusUpdate() {
}

inline StatusUpdate& StatusUpdate::operator = (const StatusUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool StatusUpdate::operator == (const StatusUpdate& rhs) const {
    return (((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool StatusUpdate::operator != (const StatusUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool StatusUpdate::operator < (const StatusUpdate& rhs) const {
    if (hasStatus() || rhs.hasStatus()) {
        if (getStatus() < rhs.getStatus()) return true;
        if (getStatus() > rhs.getStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* StatusUpdate::clone() {
    return new StatusUpdate(*this);
}

inline bool StatusUpdate::operator > (const StatusUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void StatusUpdate::clear() {
    clearStatus();
}

inline void StatusUpdate::clearStatus() {
    if (hasStatus()) {
         clear_has_Status();
        _Status.clear();
     }
}

inline bool StatusUpdate::hasStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& StatusUpdate::getStatus () const {
    return _Status;
}

inline ::std::string& StatusUpdate::getStatusMutable () {
    set_has_Status();
    return _Status;
}

inline void StatusUpdate::setStatus (const ::std::string& Status_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Status_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Status();
    this->_Status = Status_;
}

inline void StatusUpdate::setStatus (const char* Status_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Status_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Status();
    this->_Status.assign(Status_);
}

inline void StatusUpdate::setStatus (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Status();
    this->_Status.assign(value, size);
}

inline void StatusUpdate::set_has_Status () {
    _has_bits_[0] |= 1u << 0;
}

inline void StatusUpdate::clear_has_Status () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  StatusRegister::StatusRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  StatusRegister::StatusRegister (const StatusRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  StatusRegister::~StatusRegister() {
}

inline StatusRegister& StatusRegister::operator = (const StatusRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool StatusRegister::operator == (const StatusRegister& ) const {
    return true;
}

inline bool StatusRegister::operator != (const StatusRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool StatusRegister::operator < (const StatusRegister& ) const {
    return false;
}

inline ::asf::core::Payload* StatusRegister::clone() {
    return new StatusRegister(*this);
}

inline bool StatusRegister::operator > (const StatusRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void StatusRegister::clear() {
}

inline  PriorityUpdate::PriorityUpdate ()  :
    _Priority (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  PriorityUpdate::PriorityUpdate (const PriorityUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _Priority (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  PriorityUpdate::PriorityUpdate (bool Priority_)  :
    _Priority (Priority_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  PriorityUpdate::~PriorityUpdate() {
}

inline PriorityUpdate& PriorityUpdate::operator = (const PriorityUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPriority()) {
            setPriority(rhs.getPriority());
        } else {
            clearPriority();
        }
    }
    return *this;
}

inline bool PriorityUpdate::operator == (const PriorityUpdate& rhs) const {
    return (((!hasPriority() && !rhs.hasPriority()) || getPriority() == rhs.getPriority()));
}

inline bool PriorityUpdate::operator != (const PriorityUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool PriorityUpdate::operator < (const PriorityUpdate& rhs) const {
    if (hasPriority() || rhs.hasPriority()) {
        if (getPriority() < rhs.getPriority()) return true;
        if (getPriority() > rhs.getPriority()) return false;
    }
    return false;
}

inline ::asf::core::Payload* PriorityUpdate::clone() {
    return new PriorityUpdate(*this);
}

inline bool PriorityUpdate::operator > (const PriorityUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void PriorityUpdate::clear() {
    clearPriority();
}

inline void PriorityUpdate::clearPriority() {
    if (hasPriority()) {
         clear_has_Priority();
        _Priority = false;
     }
}

inline bool PriorityUpdate::hasPriority () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool PriorityUpdate::getPriority () const {
    return _Priority;
}

inline void PriorityUpdate::setPriority (bool Priority_) {
    set_has_Priority();
    this->_Priority = Priority_;
}

inline void PriorityUpdate::set_has_Priority () {
    _has_bits_[0] |= 1u << 0;
}

inline void PriorityUpdate::clear_has_Priority () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  PriorityRegister::PriorityRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  PriorityRegister::PriorityRegister (const PriorityRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  PriorityRegister::~PriorityRegister() {
}

inline PriorityRegister& PriorityRegister::operator = (const PriorityRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool PriorityRegister::operator == (const PriorityRegister& ) const {
    return true;
}

inline bool PriorityRegister::operator != (const PriorityRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool PriorityRegister::operator < (const PriorityRegister& ) const {
    return false;
}

inline ::asf::core::Payload* PriorityRegister::clone() {
    return new PriorityRegister(*this);
}

inline bool PriorityRegister::operator > (const PriorityRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void PriorityRegister::clear() {
}

inline  ReadUpdate::ReadUpdate ()  :
    _Read (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ReadUpdate::ReadUpdate (const ReadUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _Read (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ReadUpdate::ReadUpdate (bool Read_)  :
    _Read (Read_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ReadUpdate::~ReadUpdate() {
}

inline ReadUpdate& ReadUpdate::operator = (const ReadUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasRead()) {
            setRead(rhs.getRead());
        } else {
            clearRead();
        }
    }
    return *this;
}

inline bool ReadUpdate::operator == (const ReadUpdate& rhs) const {
    return (((!hasRead() && !rhs.hasRead()) || getRead() == rhs.getRead()));
}

inline bool ReadUpdate::operator != (const ReadUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool ReadUpdate::operator < (const ReadUpdate& rhs) const {
    if (hasRead() || rhs.hasRead()) {
        if (getRead() < rhs.getRead()) return true;
        if (getRead() > rhs.getRead()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ReadUpdate::clone() {
    return new ReadUpdate(*this);
}

inline bool ReadUpdate::operator > (const ReadUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ReadUpdate::clear() {
    clearRead();
}

inline void ReadUpdate::clearRead() {
    if (hasRead()) {
         clear_has_Read();
        _Read = false;
     }
}

inline bool ReadUpdate::hasRead () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool ReadUpdate::getRead () const {
    return _Read;
}

inline void ReadUpdate::setRead (bool Read_) {
    set_has_Read();
    this->_Read = Read_;
}

inline void ReadUpdate::set_has_Read () {
    _has_bits_[0] |= 1u << 0;
}

inline void ReadUpdate::clear_has_Read () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ReadRegister::ReadRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ReadRegister::ReadRegister (const ReadRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ReadRegister::~ReadRegister() {
}

inline ReadRegister& ReadRegister::operator = (const ReadRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool ReadRegister::operator == (const ReadRegister& ) const {
    return true;
}

inline bool ReadRegister::operator != (const ReadRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool ReadRegister::operator < (const ReadRegister& ) const {
    return false;
}

inline ::asf::core::Payload* ReadRegister::clone() {
    return new ReadRegister(*this);
}

inline bool ReadRegister::operator > (const ReadRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ReadRegister::clear() {
}

inline  DeletedUpdate::DeletedUpdate ()  :
    _Deleted (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DeletedUpdate::DeletedUpdate (const DeletedUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _Deleted (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DeletedUpdate::DeletedUpdate (bool Deleted_)  :
    _Deleted (Deleted_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DeletedUpdate::~DeletedUpdate() {
}

inline DeletedUpdate& DeletedUpdate::operator = (const DeletedUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDeleted()) {
            setDeleted(rhs.getDeleted());
        } else {
            clearDeleted();
        }
    }
    return *this;
}

inline bool DeletedUpdate::operator == (const DeletedUpdate& rhs) const {
    return (((!hasDeleted() && !rhs.hasDeleted()) || getDeleted() == rhs.getDeleted()));
}

inline bool DeletedUpdate::operator != (const DeletedUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool DeletedUpdate::operator < (const DeletedUpdate& rhs) const {
    if (hasDeleted() || rhs.hasDeleted()) {
        if (getDeleted() < rhs.getDeleted()) return true;
        if (getDeleted() > rhs.getDeleted()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DeletedUpdate::clone() {
    return new DeletedUpdate(*this);
}

inline bool DeletedUpdate::operator > (const DeletedUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DeletedUpdate::clear() {
    clearDeleted();
}

inline void DeletedUpdate::clearDeleted() {
    if (hasDeleted()) {
         clear_has_Deleted();
        _Deleted = false;
     }
}

inline bool DeletedUpdate::hasDeleted () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool DeletedUpdate::getDeleted () const {
    return _Deleted;
}

inline void DeletedUpdate::setDeleted (bool Deleted_) {
    set_has_Deleted();
    this->_Deleted = Deleted_;
}

inline void DeletedUpdate::set_has_Deleted () {
    _has_bits_[0] |= 1u << 0;
}

inline void DeletedUpdate::clear_has_Deleted () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DeletedRegister::DeletedRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DeletedRegister::DeletedRegister (const DeletedRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DeletedRegister::~DeletedRegister() {
}

inline DeletedRegister& DeletedRegister::operator = (const DeletedRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool DeletedRegister::operator == (const DeletedRegister& ) const {
    return true;
}

inline bool DeletedRegister::operator != (const DeletedRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool DeletedRegister::operator < (const DeletedRegister& ) const {
    return false;
}

inline ::asf::core::Payload* DeletedRegister::clone() {
    return new DeletedRegister(*this);
}

inline bool DeletedRegister::operator > (const DeletedRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DeletedRegister::clear() {
}

inline  SentUpdate::SentUpdate ()  :
    _Sent (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SentUpdate::SentUpdate (const SentUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _Sent (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SentUpdate::SentUpdate (bool Sent_)  :
    _Sent (Sent_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SentUpdate::~SentUpdate() {
}

inline SentUpdate& SentUpdate::operator = (const SentUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSent()) {
            setSent(rhs.getSent());
        } else {
            clearSent();
        }
    }
    return *this;
}

inline bool SentUpdate::operator == (const SentUpdate& rhs) const {
    return (((!hasSent() && !rhs.hasSent()) || getSent() == rhs.getSent()));
}

inline bool SentUpdate::operator != (const SentUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool SentUpdate::operator < (const SentUpdate& rhs) const {
    if (hasSent() || rhs.hasSent()) {
        if (getSent() < rhs.getSent()) return true;
        if (getSent() > rhs.getSent()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SentUpdate::clone() {
    return new SentUpdate(*this);
}

inline bool SentUpdate::operator > (const SentUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SentUpdate::clear() {
    clearSent();
}

inline void SentUpdate::clearSent() {
    if (hasSent()) {
         clear_has_Sent();
        _Sent = false;
     }
}

inline bool SentUpdate::hasSent () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool SentUpdate::getSent () const {
    return _Sent;
}

inline void SentUpdate::setSent (bool Sent_) {
    set_has_Sent();
    this->_Sent = Sent_;
}

inline void SentUpdate::set_has_Sent () {
    _has_bits_[0] |= 1u << 0;
}

inline void SentUpdate::clear_has_Sent () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SentRegister::SentRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SentRegister::SentRegister (const SentRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SentRegister::~SentRegister() {
}

inline SentRegister& SentRegister::operator = (const SentRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool SentRegister::operator == (const SentRegister& ) const {
    return true;
}

inline bool SentRegister::operator != (const SentRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool SentRegister::operator < (const SentRegister& ) const {
    return false;
}

inline ::asf::core::Payload* SentRegister::clone() {
    return new SentRegister(*this);
}

inline bool SentRegister::operator > (const SentRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SentRegister::clear() {
}

inline  ProtectedUpdate::ProtectedUpdate ()  :
    _Protected (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ProtectedUpdate::ProtectedUpdate (const ProtectedUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _Protected (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ProtectedUpdate::ProtectedUpdate (bool Protected_)  :
    _Protected (Protected_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ProtectedUpdate::~ProtectedUpdate() {
}

inline ProtectedUpdate& ProtectedUpdate::operator = (const ProtectedUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasProtected()) {
            setProtected(rhs.getProtected());
        } else {
            clearProtected();
        }
    }
    return *this;
}

inline bool ProtectedUpdate::operator == (const ProtectedUpdate& rhs) const {
    return (((!hasProtected() && !rhs.hasProtected()) || getProtected() == rhs.getProtected()));
}

inline bool ProtectedUpdate::operator != (const ProtectedUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool ProtectedUpdate::operator < (const ProtectedUpdate& rhs) const {
    if (hasProtected() || rhs.hasProtected()) {
        if (getProtected() < rhs.getProtected()) return true;
        if (getProtected() > rhs.getProtected()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ProtectedUpdate::clone() {
    return new ProtectedUpdate(*this);
}

inline bool ProtectedUpdate::operator > (const ProtectedUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ProtectedUpdate::clear() {
    clearProtected();
}

inline void ProtectedUpdate::clearProtected() {
    if (hasProtected()) {
         clear_has_Protected();
        _Protected = false;
     }
}

inline bool ProtectedUpdate::hasProtected () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool ProtectedUpdate::getProtected () const {
    return _Protected;
}

inline void ProtectedUpdate::setProtected (bool Protected_) {
    set_has_Protected();
    this->_Protected = Protected_;
}

inline void ProtectedUpdate::set_has_Protected () {
    _has_bits_[0] |= 1u << 0;
}

inline void ProtectedUpdate::clear_has_Protected () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ProtectedRegister::ProtectedRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ProtectedRegister::ProtectedRegister (const ProtectedRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ProtectedRegister::~ProtectedRegister() {
}

inline ProtectedRegister& ProtectedRegister::operator = (const ProtectedRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool ProtectedRegister::operator == (const ProtectedRegister& ) const {
    return true;
}

inline bool ProtectedRegister::operator != (const ProtectedRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool ProtectedRegister::operator < (const ProtectedRegister& ) const {
    return false;
}

inline ::asf::core::Payload* ProtectedRegister::clone() {
    return new ProtectedRegister(*this);
}

inline bool ProtectedRegister::operator > (const ProtectedRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ProtectedRegister::clear() {
}

inline  TextUpdate::TextUpdate ()  :
    _Text (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  TextUpdate::TextUpdate (const TextUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _Text (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  TextUpdate::TextUpdate (bool Text_)  :
    _Text (Text_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  TextUpdate::~TextUpdate() {
}

inline TextUpdate& TextUpdate::operator = (const TextUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasText()) {
            setText(rhs.getText());
        } else {
            clearText();
        }
    }
    return *this;
}

inline bool TextUpdate::operator == (const TextUpdate& rhs) const {
    return (((!hasText() && !rhs.hasText()) || getText() == rhs.getText()));
}

inline bool TextUpdate::operator != (const TextUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool TextUpdate::operator < (const TextUpdate& rhs) const {
    if (hasText() || rhs.hasText()) {
        if (getText() < rhs.getText()) return true;
        if (getText() > rhs.getText()) return false;
    }
    return false;
}

inline ::asf::core::Payload* TextUpdate::clone() {
    return new TextUpdate(*this);
}

inline bool TextUpdate::operator > (const TextUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void TextUpdate::clear() {
    clearText();
}

inline void TextUpdate::clearText() {
    if (hasText()) {
         clear_has_Text();
        _Text = false;
     }
}

inline bool TextUpdate::hasText () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool TextUpdate::getText () const {
    return _Text;
}

inline void TextUpdate::setText (bool Text_) {
    set_has_Text();
    this->_Text = Text_;
}

inline void TextUpdate::set_has_Text () {
    _has_bits_[0] |= 1u << 0;
}

inline void TextUpdate::clear_has_Text () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  TextRegister::TextRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  TextRegister::TextRegister (const TextRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  TextRegister::~TextRegister() {
}

inline TextRegister& TextRegister::operator = (const TextRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool TextRegister::operator == (const TextRegister& ) const {
    return true;
}

inline bool TextRegister::operator != (const TextRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool TextRegister::operator < (const TextRegister& ) const {
    return false;
}

inline ::asf::core::Payload* TextRegister::clone() {
    return new TextRegister(*this);
}

inline bool TextRegister::operator > (const TextRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void TextRegister::clear() {
}

} // namespace Message
} // namespace obex
} // namespace bluez
} // namespace org

#endif // ORG_BLUEZ_OBEX_MESSAGE_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
