/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_BLUEZ_OBEX_CLIENTPROXY_H
#define ORG_BLUEZ_OBEX_CLIENTPROXY_H

#include "asf/core/Logger.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusProxy.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DBusVariant.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "org/bluez/obex/Client.h"
#include <dbus/dbus.h>
#include <map>
#include <string>

namespace org {
namespace bluez {
namespace obex {
namespace Client {

class ClientProxy;

class CancelSessionCallbackIF {
public:
    virtual ~CancelSessionCallbackIF() {}

    virtual void onCancelSessionError(const ::boost::shared_ptr< ClientProxy >& proxy, const ::boost::shared_ptr< CancelSessionError >& error) = 0;

    virtual void onCancelSessionResponse(const ::boost::shared_ptr< ClientProxy >& proxy, const ::boost::shared_ptr< CancelSessionResponse >& response) = 0;
};

class CreateSessionCallbackIF {
public:
    virtual ~CreateSessionCallbackIF() {}

    virtual void onCreateSessionError(const ::boost::shared_ptr< ClientProxy >& proxy, const ::boost::shared_ptr< CreateSessionError >& error) = 0;

    virtual void onCreateSessionResponse(const ::boost::shared_ptr< ClientProxy >& proxy, const ::boost::shared_ptr< CreateSessionResponse >& response) = 0;
};

class RemoveSessionCallbackIF {
public:
    virtual ~RemoveSessionCallbackIF() {}

    virtual void onRemoveSessionError(const ::boost::shared_ptr< ClientProxy >& proxy, const ::boost::shared_ptr< RemoveSessionError >& error) = 0;

    virtual void onRemoveSessionResponse(const ::boost::shared_ptr< ClientProxy >& proxy, const ::boost::shared_ptr< RemoveSessionResponse >& response) = 0;
};

class SessionCreatedCallbackIF {
public:
    virtual ~SessionCreatedCallbackIF() {}

    virtual void onSessionCreatedError(const ::boost::shared_ptr< ClientProxy >& proxy, const ::boost::shared_ptr< SessionCreatedError >& error) = 0;

    virtual void onSessionCreatedSignal(const ::boost::shared_ptr< ClientProxy >& proxy, const ::boost::shared_ptr< SessionCreatedSignal >& signal) = 0;
};

class SessionRemovedCallbackIF {
public:
    virtual ~SessionRemovedCallbackIF() {}

    virtual void onSessionRemovedError(const ::boost::shared_ptr< ClientProxy >& proxy, const ::boost::shared_ptr< SessionRemovedError >& error) = 0;

    virtual void onSessionRemovedSignal(const ::boost::shared_ptr< ClientProxy >& proxy, const ::boost::shared_ptr< SessionRemovedSignal >& signal) = 0;
};


/**
 * ClientProxy is the client side representation of the D-Bus service
 * interface 'org.bluez.obex.Client' (specified in file obex_client.xml).
 *
 * If the meaning of "org.bluez.obex.Client" isn't clear, then there should be a description here.
 */
class ClientProxy : public ::asf::dbus::DBusProxy
{
public:
    /**
     * Create a new instance of ClientProxy.
     */
    static ::boost::shared_ptr< ClientProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Create a new instance of ClientProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @deprecated use the createProxy() method with the parameter
     * ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector instead.
     */
    static ::boost::shared_ptr< ClientProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        ::DBusBusType busType,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector connectorOptions;
        connectorOptions.setBusType(::asf::dbus::DBusUtils::toOptions(busType).getBusType());
        return createProxy(portName, busName, objectPath, connectorOptions, serviceAvailable);
    }

    /**
     * Create a new instance of ClientProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     */
    static ::boost::shared_ptr< ClientProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        const ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector& connectorOptions,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< ClientProxy > proxyNew(new ClientProxy(portName, serviceAvailable));
        ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew, busName, objectPath, connectorOptions);
        proxyNew->createHelperProxies(false);
        return proxyNew;
    }

    virtual ~ClientProxy ();


    // Signal 'SessionCreated'

    /**
     * Notify on the signal 'SessionCreated'. This method registers for signal
     * changes by D-Bus service.
     *
     * <b>Documentation of 'SessionCreated'</b>:
     *
     * If the meaning of "SessionCreated" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSessionCreatedRegister(SessionCreatedCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'SessionCreated'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'SessionCreated'</b>:
     *
     * If the meaning of "SessionCreated" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendSessionCreatedRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendSessionCreatedDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'SessionCreated'.
     */
    void sendSessionCreatedDeregisterAll () const;

    // Signal 'SessionRemoved'

    /**
     * Notify on the signal 'SessionRemoved'. This method registers for signal
     * changes by D-Bus service.
     *
     * <b>Documentation of 'SessionRemoved'</b>:
     *
     * If the meaning of "SessionRemoved" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSessionRemovedRegister(SessionRemovedCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'SessionRemoved'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'SessionRemoved'</b>:
     *
     * If the meaning of "SessionRemoved" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendSessionRemovedRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendSessionRemovedDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'SessionRemoved'.
     */
    void sendSessionRemovedDeregisterAll () const;



    // Method 'CreateSession'

    /**
     * Call the method 'CreateSession'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'CreateSession'</b>:
     *
     * If the meaning of "CreateSession" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param destination If the meaning of "destination" isn't clear, then there should be a description here.
     *
     * @param args If the meaning of "args" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendCreateSessionRequest(CreateSessionCallbackIF& cb, const ::std::string& destination, const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& args) const;

    // Method 'RemoveSession'

    /**
     * Call the method 'RemoveSession'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'RemoveSession'</b>:
     *
     * If the meaning of "RemoveSession" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param session If the meaning of "session" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRemoveSessionRequest(RemoveSessionCallbackIF& cb, const ::std::string& session) const;

    // Method 'CancelSession'

    /**
     * Call the method 'CancelSession'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'CancelSession'</b>:
     *
     * If the meaning of "CancelSession" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param destination If the meaning of "destination" isn't clear, then there should be a description here.
     *
     * @param args If the meaning of "args" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendCancelSessionRequest(CancelSessionCallbackIF& cb, const ::std::string& destination, const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& args) const;

    /**
     * Release all property and signal notifications.
     */
    void sendDeregisterAll () const;

private:

    ClientProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    act_t addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const;

    act_t addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const;


    DECLARE_CLASS_LOGGER();

    friend class ClientProxyCallback;
};

} // namespace Client
} // namespace obex
} // namespace bluez
} // namespace org

#endif // ORG_BLUEZ_OBEX_CLIENTPROXY_H
