/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "org/bluez/Service.h"
#include "org/bluez/ServiceDBus.h"
#include "org/bluez/ServiceJson.h"
#include "org/bluez/ServiceStub.h"
#include <string>

#include "asf/dbus/DBusMessage.h"

namespace org {
namespace bluez {
namespace Service {

DEFINE_CLASS_LOGGER("//org/bluez/hci1/dev_addr/uuid/created/during/runtime/org/bluez/Service", ServiceStub);

static ::asf::dbus::DBusUtils::stringEntry methodsTable[] = {
    { 7, "Connect", 0 },
    { 10, "Disconnect", 1 },
};

static ::asf::dbus::DBusUtils::stringEntry propertiesTable[] = {
    { 5, "State", 1 },
    { 6, "Device", 2 },
    { 7, "Version", 3 },
    { 10, "RemoteUUID", 0 },
};

class ServiceStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    ServiceStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    ServiceStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    ServiceStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "org.bluez.Service"),
          _logger(logger) {}

    virtual ~ServiceStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void ServiceStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    unsigned int methodIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (message.getMemberName().c_str(), message.getMemberName().length(), methodsTable, 2, methodIndex)) {
        switch (methodIndex) {
        case 0: {

            // method 'Connect'

            LOG_DEBUG_STUB("process method '%s'", "Connect");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ConnectRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "Connect", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ConnectRequest > payload = ::boost::static_pointer_cast<ConnectRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ServiceStub*>(getStub())->onConnectRequest(payload);
            return;
        }
        case 1: {

            // method 'Disconnect'

            LOG_DEBUG_STUB("process method '%s'", "Disconnect");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DisconnectRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "Disconnect", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< DisconnectRequest > payload = ::boost::static_pointer_cast<DisconnectRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ServiceStub*>(getStub())->onDisconnectRequest(payload);
            return;
        }
        default:
            break;
        }
    }
    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* ServiceStubDelegate::introspect() const {
    return     "<interface name=\"org.bluez.Service\">\n"
            "      <method name=\"Connect\"/>\n"
            "      <method name=\"Disconnect\"/>\n"
            "      <property access=\"read\" name=\"RemoteUUID\" type=\"s\"/>\n"
            "      <property access=\"read\" name=\"State\" type=\"s\"/>\n"
            "      <property access=\"read\" name=\"Device\" type=\"o\"/>\n"
            "      <property access=\"read\" name=\"Version\" type=\"q\"/>\n"
            "</interface>\n";
}

void ServiceStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<ServiceStub*>(getStub()))->onGetAll (properties);
}

void ServiceStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 4, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "RemoteUUID");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 1: {
            LOG_DEBUG_STUB("process property '%s'", "State");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 2: {
            LOG_DEBUG_STUB("process property '%s'", "Device");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 3: {
            LOG_DEBUG_STUB("process property '%s'", "Version");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void ServiceStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 4, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "RemoteUUID");
            ::boost::shared_ptr< RemoteUUIDGet > payload(new RemoteUUIDGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onRemoteUUIDGet (payload);
            return;
        }
        case 1: {
            LOG_DEBUG_STUB("process property '%s'", "State");
            ::boost::shared_ptr< StateGet > payload(new StateGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onStateGet (payload);
            return;
        }
        case 2: {
            LOG_DEBUG_STUB("process property '%s'", "Device");
            ::boost::shared_ptr< DeviceGet > payload(new DeviceGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onDeviceGet (payload);
            return;
        }
        case 3: {
            LOG_DEBUG_STUB("process property '%s'", "Version");
            ::boost::shared_ptr< VersionGet > payload(new VersionGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onVersionGet (payload);
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

ServiceStub::ServiceStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new ServiceStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

ServiceStub::ServiceStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new ServiceStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

ServiceStub::~ServiceStub() {
    delete _stubDelegate;
}

void ServiceStub::sendRemoteUUIDUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        RemoteUUIDUpdate payload(_RemoteUUIDProperty);

        LOG_INFO ("-> send%s", "RemoteUUIDUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("RemoteUUID", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bluez.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "RemoteUUIDUpdate");
    }
}

void ServiceStub::onRemoteUUIDGet(const ::boost::shared_ptr< RemoteUUIDGet >& remoteUUID) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "RemoteUUIDGet", remoteUUID->getAct());
    sendRemoteUUIDGetUpdate(_RemoteUUIDProperty.getRemoteUUID(), remoteUUID->getAct());
}

void ServiceStub::sendRemoteUUIDGetUpdate(const ::std::string& remoteUUID, act_t act) {
    ::asf::dbus::DBusVariant variant;
    RemoteUUIDGet payload(remoteUUID);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "RemoteUUIDGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setRemoteUUID(const ::std::string& remoteUUID) {
    if(remoteUUID!=_RemoteUUIDProperty.getRemoteUUID()) {
        _RemoteUUIDProperty.setRemoteUUID(remoteUUID);
        sendRemoteUUIDUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& ServiceStub::getRemoteUUID() const {
    return _RemoteUUIDProperty.getRemoteUUID();
}

::std::string& ServiceStub::getRemoteUUIDMutable() {
    return _RemoteUUIDProperty.getRemoteUUIDMutable();
}

void ServiceStub::sendStateUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        StateUpdate payload(_StateProperty);

        LOG_INFO ("-> send%s", "StateUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("State", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bluez.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "StateUpdate");
    }
}

void ServiceStub::onStateGet(const ::boost::shared_ptr< StateGet >& state) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "StateGet", state->getAct());
    sendStateGetUpdate(_StateProperty.getState(), state->getAct());
}

void ServiceStub::sendStateGetUpdate(const ::std::string& state, act_t act) {
    ::asf::dbus::DBusVariant variant;
    StateGet payload(state);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "StateGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setState(const ::std::string& state) {
    if(state!=_StateProperty.getState()) {
        _StateProperty.setState(state);
        sendStateUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& ServiceStub::getState() const {
    return _StateProperty.getState();
}

::std::string& ServiceStub::getStateMutable() {
    return _StateProperty.getStateMutable();
}

void ServiceStub::sendDeviceUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        DeviceUpdate payload(_DeviceProperty);

        LOG_INFO ("-> send%s", "DeviceUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Device", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bluez.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "DeviceUpdate");
    }
}

void ServiceStub::onDeviceGet(const ::boost::shared_ptr< DeviceGet >& device) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "DeviceGet", device->getAct());
    sendDeviceGetUpdate(_DeviceProperty.getDevice(), device->getAct());
}

void ServiceStub::sendDeviceGetUpdate(const ::std::string& device, act_t act) {
    ::asf::dbus::DBusVariant variant;
    DeviceGet payload(device);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "DeviceGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setDevice(const ::std::string& device) {
    if(device!=_DeviceProperty.getDevice()) {
        _DeviceProperty.setDevice(device);
        sendDeviceUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& ServiceStub::getDevice() const {
    return _DeviceProperty.getDevice();
}

::std::string& ServiceStub::getDeviceMutable() {
    return _DeviceProperty.getDeviceMutable();
}

void ServiceStub::sendVersionUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        VersionUpdate payload(_VersionProperty);

        LOG_INFO ("-> send%s", "VersionUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Version", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bluez.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "VersionUpdate");
    }
}

void ServiceStub::onVersionGet(const ::boost::shared_ptr< VersionGet >& version) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "VersionGet", version->getAct());
    sendVersionGetUpdate(_VersionProperty.getVersion(), version->getAct());
}

void ServiceStub::sendVersionGetUpdate(uint16 version, act_t act) {
    ::asf::dbus::DBusVariant variant;
    VersionGet payload(version);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "VersionGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setVersion(uint16 version) {
    if(version!=_VersionProperty.getVersion()) {
        _VersionProperty.setVersion(version);
        sendVersionUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint16 ServiceStub::getVersion() const {
    return _VersionProperty.getVersion();
}

void  ServiceStub::sendConnectResponse (act_t act) {
    ConnectResponse* payload = new ConnectResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "Connect", ConnectResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "Connect", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ServiceStub::sendConnectError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ConnectError* payload = new ConnectError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "Connect", ConnectError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "Connect", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ServiceStub::sendDisconnectResponse (act_t act) {
    DisconnectResponse* payload = new DisconnectResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "Disconnect", DisconnectResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "Disconnect", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ServiceStub::sendDisconnectError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    DisconnectError* payload = new DisconnectError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "Disconnect", DisconnectError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "Disconnect", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void ServiceStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {

    //property 'RemoteUUID'
    {
        ::asf::dbus::DBusVariant variant;
        RemoteUUIDGet payload(_RemoteUUIDProperty.getRemoteUUID());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("RemoteUUID", variant));
    }

    //property 'State'
    {
        ::asf::dbus::DBusVariant variant;
        StateGet payload(_StateProperty.getState());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("State", variant));
    }

    //property 'Device'
    {
        ::asf::dbus::DBusVariant variant;
        DeviceGet payload(_DeviceProperty.getDevice());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Device", variant));
    }

    //property 'Version'
    {
        ::asf::dbus::DBusVariant variant;
        VersionGet payload(_VersionProperty.getVersion());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Version", variant));
    }
}

} // namespace Service
} // namespace bluez
} // namespace org
