/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_BLUEZ_DEVICE1STUB_H
#define ORG_BLUEZ_DEVICE1STUB_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStub.h"
#include "asf/dbus/DBusVariant.h"
#include "boost/shared_ptr.hpp"
#include "org/bluez/Device1.h"
#include <string>
#include <vector>

namespace org {
namespace bluez {
namespace Device1 {

class Device1StubDelegate;

class Device1Stub : public ::asf::dbus::DBusStub
{
public:

    /**
     * Create an instance of the Device1Stub
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     */
    Device1Stub (const std::string& portName);

    /**
     * Create an instance of the Device1Stub
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     * @param objectPath the dbus object path, see
     * http://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-marshaling-object-path
     */
    Device1Stub (const std::string& portName, const std::string& objectPath);

    virtual ~Device1Stub();

    // signal 'ReportLinkkey'

    /**
     * Raise the signal 'ReportLinkkey' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'ReportLinkkey'</b>:
     *
     * If the meaning of "ReportLinkkey" isn't clear, then there should be a description here.
     */
    void sendReportLinkkeySignal(const ::std::vector< uint8 >& linkkey);

    // signal 'IncomingPairingComp'

    /**
     * Raise the signal 'IncomingPairingComp' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'IncomingPairingComp'</b>:
     *
     * If the meaning of "IncomingPairingComp" isn't clear, then there should be a description here.
     */
    void sendIncomingPairingCompSignal(uint8 status);

    // signal 'SDPProcessReport'

    /**
     * Raise the signal 'SDPProcessReport' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'SDPProcessReport'</b>:
     *
     * If the meaning of "SDPProcessReport" isn't clear, then there should be a description here.
     */
    void sendSDPProcessReportSignal(uint8 status);

    // property 'Address'

    /**
     * The method onAddressGet() is called by ASF when a client invokes the
     * read method for the property 'Address'. The onAddressGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'Address'</b>:
     *
     * If the meaning of "Address" isn't clear, then there should be a description here.
     */
    virtual void onAddressGet(const ::boost::shared_ptr< AddressGet >& payload);

    /**
     * Sends back the update to a previous onAddressGet().
     *
     * <b>Documentation of 'Address'</b>:
     *
     * If the meaning of "Address" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onAddressGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendAddressGetUpdate(const ::std::string& address, act_t act = 0);

    /**
     * Set the value of the property 'Address' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'Address'</b>:
     *
     * If the meaning of "Address" isn't clear, then there should be a description here.
     */
    void setAddress(const ::std::string& address);

    /**
     * Returns the current value of the property 'Address'.
     *
     * <b>Documentation of 'Address'</b>:
     *
     * If the meaning of "Address" isn't clear, then there should be a description here.
     */
    const ::std::string& getAddress() const;

    /**
     * Returns the current value of the property 'Address' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendAddressUpdate() method.
     *
     * <b>Documentation of 'Address'</b>:
     *
     * If the meaning of "Address" isn't clear, then there should be a description here.
     */
    ::std::string& getAddressMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendAddressUpdate().
     *
     * <b>Documentation of 'Address'</b>:
     *
     * If the meaning of "Address" isn't clear, then there should be a description here.
     */
    void sendAddressUpdate();

    // property 'Class'

    /**
     * The method onClassGet() is called by ASF when a client invokes the read
     * method for the property 'Class'. The onClassGet() method returns by
     * default the current property value to the caller. In case this default
     * behavior doesn't match your needs feel free to override this method.
     *
     * <b>Documentation of 'Class'</b>:
     *
     * If the meaning of "Class" isn't clear, then there should be a description here.
     */
    virtual void onClassGet(const ::boost::shared_ptr< ClassGet >& payload);

    /**
     * Sends back the update to a previous onClassGet().
     *
     * <b>Documentation of 'Class'</b>:
     *
     * If the meaning of "Class" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onClassGet(). If the act
     * is not specified, i.e. the most recent invocation will be answered. In
     * case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendClassGetUpdate(uint32 class_, act_t act = 0);

    /**
     * Set the value of the property 'Class' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'Class'</b>:
     *
     * If the meaning of "Class" isn't clear, then there should be a description here.
     */
    void setClass(uint32 class_);

    /**
     * Returns the current value of the property 'Class'.
     *
     * <b>Documentation of 'Class'</b>:
     *
     * If the meaning of "Class" isn't clear, then there should be a description here.
     */
    uint32 getClass() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendClassUpdate().
     *
     * <b>Documentation of 'Class'</b>:
     *
     * If the meaning of "Class" isn't clear, then there should be a description here.
     */
    void sendClassUpdate();

    // property 'Icon'

    /**
     * The method onIconGet() is called by ASF when a client invokes the read
     * method for the property 'Icon'. The onIconGet() method returns by
     * default the current property value to the caller. In case this default
     * behavior doesn't match your needs feel free to override this method.
     *
     * <b>Documentation of 'Icon'</b>:
     *
     * If the meaning of "Icon" isn't clear, then there should be a description here.
     */
    virtual void onIconGet(const ::boost::shared_ptr< IconGet >& payload);

    /**
     * Sends back the update to a previous onIconGet().
     *
     * <b>Documentation of 'Icon'</b>:
     *
     * If the meaning of "Icon" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onIconGet(). If the act
     * is not specified, i.e. the most recent invocation will be answered. In
     * case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendIconGetUpdate(const ::std::string& icon, act_t act = 0);

    /**
     * Set the value of the property 'Icon' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'Icon'</b>:
     *
     * If the meaning of "Icon" isn't clear, then there should be a description here.
     */
    void setIcon(const ::std::string& icon);

    /**
     * Returns the current value of the property 'Icon'.
     *
     * <b>Documentation of 'Icon'</b>:
     *
     * If the meaning of "Icon" isn't clear, then there should be a description here.
     */
    const ::std::string& getIcon() const;

    /**
     * Returns the current value of the property 'Icon' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendIconUpdate() method.
     *
     * <b>Documentation of 'Icon'</b>:
     *
     * If the meaning of "Icon" isn't clear, then there should be a description here.
     */
    ::std::string& getIconMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendIconUpdate().
     *
     * <b>Documentation of 'Icon'</b>:
     *
     * If the meaning of "Icon" isn't clear, then there should be a description here.
     */
    void sendIconUpdate();

    // property 'UUIDs'

    /**
     * The method onUUIDsGet() is called by ASF when a client invokes the read
     * method for the property 'UUIDs'. The onUUIDsGet() method returns by
     * default the current property value to the caller. In case this default
     * behavior doesn't match your needs feel free to override this method.
     *
     * <b>Documentation of 'UUIDs'</b>:
     *
     * If the meaning of "UUIDs" isn't clear, then there should be a description here.
     */
    virtual void onUUIDsGet(const ::boost::shared_ptr< UUIDsGet >& payload);

    /**
     * Sends back the update to a previous onUUIDsGet().
     *
     * <b>Documentation of 'UUIDs'</b>:
     *
     * If the meaning of "UUIDs" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onUUIDsGet(). If the act
     * is not specified, i.e. the most recent invocation will be answered. In
     * case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendUUIDsGetUpdate(const ::std::vector< ::std::string >& uUIDs, act_t act = 0);

    /**
     * Set the value of the property 'UUIDs' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'UUIDs'</b>:
     *
     * If the meaning of "UUIDs" isn't clear, then there should be a description here.
     */
    void setUUIDs(const ::std::vector< ::std::string >& uUIDs);

    /**
     * Returns the current value of the property 'UUIDs'.
     *
     * <b>Documentation of 'UUIDs'</b>:
     *
     * If the meaning of "UUIDs" isn't clear, then there should be a description here.
     */
    const ::std::vector< ::std::string >& getUUIDs() const;

    /**
     * Returns the current value of the property 'UUIDs' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendUUIDsUpdate() method.
     *
     * <b>Documentation of 'UUIDs'</b>:
     *
     * If the meaning of "UUIDs" isn't clear, then there should be a description here.
     */
    ::std::vector< ::std::string >& getUUIDsMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendUUIDsUpdate().
     *
     * <b>Documentation of 'UUIDs'</b>:
     *
     * If the meaning of "UUIDs" isn't clear, then there should be a description here.
     */
    void sendUUIDsUpdate();

    // property 'Paired'

    /**
     * The method onPairedGet() is called by ASF when a client invokes the
     * read method for the property 'Paired'. The onPairedGet() method returns
     * by default the current property value to the caller. In case this
     * default behavior doesn't match your needs feel free to override this
     * method.
     *
     * <b>Documentation of 'Paired'</b>:
     *
     * If the meaning of "Paired" isn't clear, then there should be a description here.
     */
    virtual void onPairedGet(const ::boost::shared_ptr< PairedGet >& payload);

    /**
     * Sends back the update to a previous onPairedGet().
     *
     * <b>Documentation of 'Paired'</b>:
     *
     * If the meaning of "Paired" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onPairedGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendPairedGetUpdate(bool paired, act_t act = 0);

    /**
     * Set the value of the property 'Paired' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'Paired'</b>:
     *
     * If the meaning of "Paired" isn't clear, then there should be a description here.
     */
    void setPaired(bool paired);

    /**
     * Returns the current value of the property 'Paired'.
     *
     * <b>Documentation of 'Paired'</b>:
     *
     * If the meaning of "Paired" isn't clear, then there should be a description here.
     */
    bool getPaired() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendPairedUpdate().
     *
     * <b>Documentation of 'Paired'</b>:
     *
     * If the meaning of "Paired" isn't clear, then there should be a description here.
     */
    void sendPairedUpdate();

    // property 'Connected'

    /**
     * The method onConnectedGet() is called by ASF when a client invokes the
     * read method for the property 'Connected'. The onConnectedGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'Connected'</b>:
     *
     * If the meaning of "Connected" isn't clear, then there should be a description here.
     */
    virtual void onConnectedGet(const ::boost::shared_ptr< ConnectedGet >& payload);

    /**
     * Sends back the update to a previous onConnectedGet().
     *
     * <b>Documentation of 'Connected'</b>:
     *
     * If the meaning of "Connected" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onConnectedGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendConnectedGetUpdate(bool connected, act_t act = 0);

    /**
     * Set the value of the property 'Connected' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'Connected'</b>:
     *
     * If the meaning of "Connected" isn't clear, then there should be a description here.
     */
    void setConnected(bool connected);

    /**
     * Returns the current value of the property 'Connected'.
     *
     * <b>Documentation of 'Connected'</b>:
     *
     * If the meaning of "Connected" isn't clear, then there should be a description here.
     */
    bool getConnected() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendConnectedUpdate().
     *
     * <b>Documentation of 'Connected'</b>:
     *
     * If the meaning of "Connected" isn't clear, then there should be a description here.
     */
    void sendConnectedUpdate();

    // property 'Trusted'

    /**
     * The method onTrustedGet() is called by ASF when a client invokes the
     * read method for the property 'Trusted'. The onTrustedGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'Trusted'</b>:
     *
     * If the meaning of "Trusted" isn't clear, then there should be a description here.
     */
    virtual void onTrustedGet(const ::boost::shared_ptr< TrustedGet >& payload);

    /**
     * Sends back the update to a previous onTrustedGet().
     *
     * <b>Documentation of 'Trusted'</b>:
     *
     * If the meaning of "Trusted" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onTrustedGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendTrustedGetUpdate(bool trusted, act_t act = 0);

    /**
     * The method onTrustedSet() is called by ASF when a client invokes the
     * write method for the property 'Trusted'. The onTrustedSet() method set
     * property value to the given parameter Trusted by default. If this
     * default behavior doesn't match your needs feel free to override this
     * method.
     *
     * <b>Documentation of 'Trusted'</b>:
     *
     * If the meaning of "Trusted" isn't clear, then there should be a description here.
     */
    virtual void onTrustedSet(const ::boost::shared_ptr< TrustedSet >& payload);

    /**
     * Sends back the update to a previous onTrustedSet().
     *
     * <b>Documentation of 'Trusted'</b>:
     *
     * If the meaning of "Trusted" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onTrustedSet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendTrustedSetUpdate(act_t act = 0);

    /**
     * Set the value of the property 'Trusted' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'Trusted'</b>:
     *
     * If the meaning of "Trusted" isn't clear, then there should be a description here.
     */
    void setTrusted(bool trusted);

    /**
     * Returns the current value of the property 'Trusted'.
     *
     * <b>Documentation of 'Trusted'</b>:
     *
     * If the meaning of "Trusted" isn't clear, then there should be a description here.
     */
    bool getTrusted() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendTrustedUpdate().
     *
     * <b>Documentation of 'Trusted'</b>:
     *
     * If the meaning of "Trusted" isn't clear, then there should be a description here.
     */
    void sendTrustedUpdate();

    // property 'Blocked'

    /**
     * The method onBlockedGet() is called by ASF when a client invokes the
     * read method for the property 'Blocked'. The onBlockedGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'Blocked'</b>:
     *
     * If the meaning of "Blocked" isn't clear, then there should be a description here.
     */
    virtual void onBlockedGet(const ::boost::shared_ptr< BlockedGet >& payload);

    /**
     * Sends back the update to a previous onBlockedGet().
     *
     * <b>Documentation of 'Blocked'</b>:
     *
     * If the meaning of "Blocked" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onBlockedGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendBlockedGetUpdate(bool blocked, act_t act = 0);

    /**
     * The method onBlockedSet() is called by ASF when a client invokes the
     * write method for the property 'Blocked'. The onBlockedSet() method set
     * property value to the given parameter Blocked by default. If this
     * default behavior doesn't match your needs feel free to override this
     * method.
     *
     * <b>Documentation of 'Blocked'</b>:
     *
     * If the meaning of "Blocked" isn't clear, then there should be a description here.
     */
    virtual void onBlockedSet(const ::boost::shared_ptr< BlockedSet >& payload);

    /**
     * Sends back the update to a previous onBlockedSet().
     *
     * <b>Documentation of 'Blocked'</b>:
     *
     * If the meaning of "Blocked" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onBlockedSet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendBlockedSetUpdate(act_t act = 0);

    /**
     * Set the value of the property 'Blocked' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'Blocked'</b>:
     *
     * If the meaning of "Blocked" isn't clear, then there should be a description here.
     */
    void setBlocked(bool blocked);

    /**
     * Returns the current value of the property 'Blocked'.
     *
     * <b>Documentation of 'Blocked'</b>:
     *
     * If the meaning of "Blocked" isn't clear, then there should be a description here.
     */
    bool getBlocked() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendBlockedUpdate().
     *
     * <b>Documentation of 'Blocked'</b>:
     *
     * If the meaning of "Blocked" isn't clear, then there should be a description here.
     */
    void sendBlockedUpdate();

    // property 'Alias'

    /**
     * The method onAliasGet() is called by ASF when a client invokes the read
     * method for the property 'Alias'. The onAliasGet() method returns by
     * default the current property value to the caller. In case this default
     * behavior doesn't match your needs feel free to override this method.
     *
     * <b>Documentation of 'Alias'</b>:
     *
     * If the meaning of "Alias" isn't clear, then there should be a description here.
     */
    virtual void onAliasGet(const ::boost::shared_ptr< AliasGet >& payload);

    /**
     * Sends back the update to a previous onAliasGet().
     *
     * <b>Documentation of 'Alias'</b>:
     *
     * If the meaning of "Alias" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onAliasGet(). If the act
     * is not specified, i.e. the most recent invocation will be answered. In
     * case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendAliasGetUpdate(const ::std::string& alias, act_t act = 0);

    /**
     * The method onAliasSet() is called by ASF when a client invokes the
     * write method for the property 'Alias'. The onAliasSet() method set
     * property value to the given parameter Alias by default. If this default
     * behavior doesn't match your needs feel free to override this method.
     *
     * <b>Documentation of 'Alias'</b>:
     *
     * If the meaning of "Alias" isn't clear, then there should be a description here.
     */
    virtual void onAliasSet(const ::boost::shared_ptr< AliasSet >& payload);

    /**
     * Sends back the update to a previous onAliasSet().
     *
     * <b>Documentation of 'Alias'</b>:
     *
     * If the meaning of "Alias" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onAliasSet(). If the act
     * is not specified, i.e. the most recent invocation will be answered. In
     * case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendAliasSetUpdate(act_t act = 0);

    /**
     * Set the value of the property 'Alias' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'Alias'</b>:
     *
     * If the meaning of "Alias" isn't clear, then there should be a description here.
     */
    void setAlias(const ::std::string& alias);

    /**
     * Returns the current value of the property 'Alias'.
     *
     * <b>Documentation of 'Alias'</b>:
     *
     * If the meaning of "Alias" isn't clear, then there should be a description here.
     */
    const ::std::string& getAlias() const;

    /**
     * Returns the current value of the property 'Alias' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendAliasUpdate() method.
     *
     * <b>Documentation of 'Alias'</b>:
     *
     * If the meaning of "Alias" isn't clear, then there should be a description here.
     */
    ::std::string& getAliasMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendAliasUpdate().
     *
     * <b>Documentation of 'Alias'</b>:
     *
     * If the meaning of "Alias" isn't clear, then there should be a description here.
     */
    void sendAliasUpdate();

    // property 'Adapter'

    /**
     * The method onAdapterGet() is called by ASF when a client invokes the
     * read method for the property 'Adapter'. The onAdapterGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'Adapter'</b>:
     *
     * If the meaning of "Adapter" isn't clear, then there should be a description here.
     */
    virtual void onAdapterGet(const ::boost::shared_ptr< AdapterGet >& payload);

    /**
     * Sends back the update to a previous onAdapterGet().
     *
     * <b>Documentation of 'Adapter'</b>:
     *
     * If the meaning of "Adapter" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onAdapterGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendAdapterGetUpdate(const ::std::string& adapter, act_t act = 0);

    /**
     * Set the value of the property 'Adapter' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'Adapter'</b>:
     *
     * If the meaning of "Adapter" isn't clear, then there should be a description here.
     */
    void setAdapter(const ::std::string& adapter);

    /**
     * Returns the current value of the property 'Adapter'.
     *
     * <b>Documentation of 'Adapter'</b>:
     *
     * If the meaning of "Adapter" isn't clear, then there should be a description here.
     */
    const ::std::string& getAdapter() const;

    /**
     * Returns the current value of the property 'Adapter' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendAdapterUpdate() method.
     *
     * <b>Documentation of 'Adapter'</b>:
     *
     * If the meaning of "Adapter" isn't clear, then there should be a description here.
     */
    ::std::string& getAdapterMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendAdapterUpdate().
     *
     * <b>Documentation of 'Adapter'</b>:
     *
     * If the meaning of "Adapter" isn't clear, then there should be a description here.
     */
    void sendAdapterUpdate();

    // property 'Modalias'

    /**
     * The method onModaliasGet() is called by ASF when a client invokes the
     * read method for the property 'Modalias'. The onModaliasGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'Modalias'</b>:
     *
     * If the meaning of "Modalias" isn't clear, then there should be a description here.
     */
    virtual void onModaliasGet(const ::boost::shared_ptr< ModaliasGet >& payload);

    /**
     * Sends back the update to a previous onModaliasGet().
     *
     * <b>Documentation of 'Modalias'</b>:
     *
     * If the meaning of "Modalias" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onModaliasGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendModaliasGetUpdate(const ::std::string& modalias, act_t act = 0);

    /**
     * Set the value of the property 'Modalias' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'Modalias'</b>:
     *
     * If the meaning of "Modalias" isn't clear, then there should be a description here.
     */
    void setModalias(const ::std::string& modalias);

    /**
     * Returns the current value of the property 'Modalias'.
     *
     * <b>Documentation of 'Modalias'</b>:
     *
     * If the meaning of "Modalias" isn't clear, then there should be a description here.
     */
    const ::std::string& getModalias() const;

    /**
     * Returns the current value of the property 'Modalias' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendModaliasUpdate() method.
     *
     * <b>Documentation of 'Modalias'</b>:
     *
     * If the meaning of "Modalias" isn't clear, then there should be a description here.
     */
    ::std::string& getModaliasMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendModaliasUpdate().
     *
     * <b>Documentation of 'Modalias'</b>:
     *
     * If the meaning of "Modalias" isn't clear, then there should be a description here.
     */
    void sendModaliasUpdate();

    // property 'RSSI'

    /**
     * The method onRSSIGet() is called by ASF when a client invokes the read
     * method for the property 'RSSI'. The onRSSIGet() method returns by
     * default the current property value to the caller. In case this default
     * behavior doesn't match your needs feel free to override this method.
     *
     * <b>Documentation of 'RSSI'</b>:
     *
     * If the meaning of "RSSI" isn't clear, then there should be a description here.
     */
    virtual void onRSSIGet(const ::boost::shared_ptr< RSSIGet >& payload);

    /**
     * Sends back the update to a previous onRSSIGet().
     *
     * <b>Documentation of 'RSSI'</b>:
     *
     * If the meaning of "RSSI" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onRSSIGet(). If the act
     * is not specified, i.e. the most recent invocation will be answered. In
     * case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendRSSIGetUpdate(uint8 rSSI, act_t act = 0);

    /**
     * Set the value of the property 'RSSI' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'RSSI'</b>:
     *
     * If the meaning of "RSSI" isn't clear, then there should be a description here.
     */
    void setRSSI(uint8 rSSI);

    /**
     * Returns the current value of the property 'RSSI'.
     *
     * <b>Documentation of 'RSSI'</b>:
     *
     * If the meaning of "RSSI" isn't clear, then there should be a description here.
     */
    uint8 getRSSI() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendRSSIUpdate().
     *
     * <b>Documentation of 'RSSI'</b>:
     *
     * If the meaning of "RSSI" isn't clear, then there should be a description here.
     */
    void sendRSSIUpdate();

    // property 'Vendor'

    /**
     * The method onVendorGet() is called by ASF when a client invokes the
     * read method for the property 'Vendor'. The onVendorGet() method returns
     * by default the current property value to the caller. In case this
     * default behavior doesn't match your needs feel free to override this
     * method.
     *
     * <b>Documentation of 'Vendor'</b>:
     *
     * If the meaning of "Vendor" isn't clear, then there should be a description here.
     */
    virtual void onVendorGet(const ::boost::shared_ptr< VendorGet >& payload);

    /**
     * Sends back the update to a previous onVendorGet().
     *
     * <b>Documentation of 'Vendor'</b>:
     *
     * If the meaning of "Vendor" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onVendorGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendVendorGetUpdate(uint16 vendor, act_t act = 0);

    /**
     * Set the value of the property 'Vendor' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'Vendor'</b>:
     *
     * If the meaning of "Vendor" isn't clear, then there should be a description here.
     */
    void setVendor(uint16 vendor);

    /**
     * Returns the current value of the property 'Vendor'.
     *
     * <b>Documentation of 'Vendor'</b>:
     *
     * If the meaning of "Vendor" isn't clear, then there should be a description here.
     */
    uint16 getVendor() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendVendorUpdate().
     *
     * <b>Documentation of 'Vendor'</b>:
     *
     * If the meaning of "Vendor" isn't clear, then there should be a description here.
     */
    void sendVendorUpdate();

    // property 'VendorSource'

    /**
     * The method onVendorSourceGet() is called by ASF when a client invokes
     * the read method for the property 'VendorSource'. The
     * onVendorSourceGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'VendorSource'</b>:
     *
     * If the meaning of "VendorSource" isn't clear, then there should be a description here.
     */
    virtual void onVendorSourceGet(const ::boost::shared_ptr< VendorSourceGet >& payload);

    /**
     * Sends back the update to a previous onVendorSourceGet().
     *
     * <b>Documentation of 'VendorSource'</b>:
     *
     * If the meaning of "VendorSource" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onVendorSourceGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendVendorSourceGetUpdate(uint16 vendorSource, act_t act = 0);

    /**
     * Set the value of the property 'VendorSource' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'VendorSource'</b>:
     *
     * If the meaning of "VendorSource" isn't clear, then there should be a description here.
     */
    void setVendorSource(uint16 vendorSource);

    /**
     * Returns the current value of the property 'VendorSource'.
     *
     * <b>Documentation of 'VendorSource'</b>:
     *
     * If the meaning of "VendorSource" isn't clear, then there should be a description here.
     */
    uint16 getVendorSource() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendVendorSourceUpdate().
     *
     * <b>Documentation of 'VendorSource'</b>:
     *
     * If the meaning of "VendorSource" isn't clear, then there should be a description here.
     */
    void sendVendorSourceUpdate();

    // property 'Product'

    /**
     * The method onProductGet() is called by ASF when a client invokes the
     * read method for the property 'Product'. The onProductGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'Product'</b>:
     *
     * If the meaning of "Product" isn't clear, then there should be a description here.
     */
    virtual void onProductGet(const ::boost::shared_ptr< ProductGet >& payload);

    /**
     * Sends back the update to a previous onProductGet().
     *
     * <b>Documentation of 'Product'</b>:
     *
     * If the meaning of "Product" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onProductGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendProductGetUpdate(uint16 product, act_t act = 0);

    /**
     * Set the value of the property 'Product' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'Product'</b>:
     *
     * If the meaning of "Product" isn't clear, then there should be a description here.
     */
    void setProduct(uint16 product);

    /**
     * Returns the current value of the property 'Product'.
     *
     * <b>Documentation of 'Product'</b>:
     *
     * If the meaning of "Product" isn't clear, then there should be a description here.
     */
    uint16 getProduct() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendProductUpdate().
     *
     * <b>Documentation of 'Product'</b>:
     *
     * If the meaning of "Product" isn't clear, then there should be a description here.
     */
    void sendProductUpdate();

    // property 'MapInfo'

    /**
     * The method onMapInfoGet() is called by ASF when a client invokes the
     * read method for the property 'MapInfo'. The onMapInfoGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'MapInfo'</b>:
     *
     * If the meaning of "MapInfo" isn't clear, then there should be a description here.
     */
    virtual void onMapInfoGet(const ::boost::shared_ptr< MapInfoGet >& payload);

    /**
     * Sends back the update to a previous onMapInfoGet().
     *
     * <b>Documentation of 'MapInfo'</b>:
     *
     * If the meaning of "MapInfo" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onMapInfoGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendMapInfoGetUpdate(const ::std::vector< ::std::string >& mapInfo, act_t act = 0);

    /**
     * Set the value of the property 'MapInfo' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'MapInfo'</b>:
     *
     * If the meaning of "MapInfo" isn't clear, then there should be a description here.
     */
    void setMapInfo(const ::std::vector< ::std::string >& mapInfo);

    /**
     * Returns the current value of the property 'MapInfo'.
     *
     * <b>Documentation of 'MapInfo'</b>:
     *
     * If the meaning of "MapInfo" isn't clear, then there should be a description here.
     */
    const ::std::vector< ::std::string >& getMapInfo() const;

    /**
     * Returns the current value of the property 'MapInfo' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendMapInfoUpdate() method.
     *
     * <b>Documentation of 'MapInfo'</b>:
     *
     * If the meaning of "MapInfo" isn't clear, then there should be a description here.
     */
    ::std::vector< ::std::string >& getMapInfoMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendMapInfoUpdate().
     *
     * <b>Documentation of 'MapInfo'</b>:
     *
     * If the meaning of "MapInfo" isn't clear, then there should be a description here.
     */
    void sendMapInfoUpdate();

    // property 'ConnectedService'

    /**
     * The method onConnectedServiceGet() is called by ASF when a client
     * invokes the read method for the property 'ConnectedService'. The
     * onConnectedServiceGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'ConnectedService'</b>:
     *
     * If the meaning of "ConnectedService" isn't clear, then there should be a description here.
     */
    virtual void onConnectedServiceGet(const ::boost::shared_ptr< ConnectedServiceGet >& payload);

    /**
     * Sends back the update to a previous onConnectedServiceGet().
     *
     * <b>Documentation of 'ConnectedService'</b>:
     *
     * If the meaning of "ConnectedService" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onConnectedServiceGet().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendConnectedServiceGetUpdate(uint64 connectedService, act_t act = 0);

    /**
     * Set the value of the property 'ConnectedService' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'ConnectedService'</b>:
     *
     * If the meaning of "ConnectedService" isn't clear, then there should be a description here.
     */
    void setConnectedService(uint64 connectedService);

    /**
     * Returns the current value of the property 'ConnectedService'.
     *
     * <b>Documentation of 'ConnectedService'</b>:
     *
     * If the meaning of "ConnectedService" isn't clear, then there should be a description here.
     */
    uint64 getConnectedService() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendConnectedServiceUpdate().
     *
     * <b>Documentation of 'ConnectedService'</b>:
     *
     * If the meaning of "ConnectedService" isn't clear, then there should be a description here.
     */
    void sendConnectedServiceUpdate();

    // property 'Version'

    /**
     * The method onVersionGet() is called by ASF when a client invokes the
     * read method for the property 'Version'. The onVersionGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'Version'</b>:
     *
     * If the meaning of "Version" isn't clear, then there should be a description here.
     */
    virtual void onVersionGet(const ::boost::shared_ptr< VersionGet >& payload);

    /**
     * Sends back the update to a previous onVersionGet().
     *
     * <b>Documentation of 'Version'</b>:
     *
     * If the meaning of "Version" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onVersionGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendVersionGetUpdate(uint16 version, act_t act = 0);

    /**
     * Set the value of the property 'Version' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'Version'</b>:
     *
     * If the meaning of "Version" isn't clear, then there should be a description here.
     */
    void setVersion(uint16 version);

    /**
     * Returns the current value of the property 'Version'.
     *
     * <b>Documentation of 'Version'</b>:
     *
     * If the meaning of "Version" isn't clear, then there should be a description here.
     */
    uint16 getVersion() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendVersionUpdate().
     *
     * <b>Documentation of 'Version'</b>:
     *
     * If the meaning of "Version" isn't clear, then there should be a description here.
     */
    void sendVersionUpdate();

    // property 'PBAPInfo'

    /**
     * The method onPBAPInfoGet() is called by ASF when a client invokes the
     * read method for the property 'PBAPInfo'. The onPBAPInfoGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'PBAPInfo'</b>:
     *
     * If the meaning of "PBAPInfo" isn't clear, then there should be a description here.
     */
    virtual void onPBAPInfoGet(const ::boost::shared_ptr< PBAPInfoGet >& payload);

    /**
     * Sends back the update to a previous onPBAPInfoGet().
     *
     * <b>Documentation of 'PBAPInfo'</b>:
     *
     * If the meaning of "PBAPInfo" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onPBAPInfoGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendPBAPInfoGetUpdate(const ::std::string& pBAPInfo, act_t act = 0);

    /**
     * Set the value of the property 'PBAPInfo' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'PBAPInfo'</b>:
     *
     * If the meaning of "PBAPInfo" isn't clear, then there should be a description here.
     */
    void setPBAPInfo(const ::std::string& pBAPInfo);

    /**
     * Returns the current value of the property 'PBAPInfo'.
     *
     * <b>Documentation of 'PBAPInfo'</b>:
     *
     * If the meaning of "PBAPInfo" isn't clear, then there should be a description here.
     */
    const ::std::string& getPBAPInfo() const;

    /**
     * Returns the current value of the property 'PBAPInfo' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendPBAPInfoUpdate() method.
     *
     * <b>Documentation of 'PBAPInfo'</b>:
     *
     * If the meaning of "PBAPInfo" isn't clear, then there should be a description here.
     */
    ::std::string& getPBAPInfoMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendPBAPInfoUpdate().
     *
     * <b>Documentation of 'PBAPInfo'</b>:
     *
     * If the meaning of "PBAPInfo" isn't clear, then there should be a description here.
     */
    void sendPBAPInfoUpdate();

    // property 'Mode'

    /**
     * The method onModeGet() is called by ASF when a client invokes the read
     * method for the property 'Mode'. The onModeGet() method returns by
     * default the current property value to the caller. In case this default
     * behavior doesn't match your needs feel free to override this method.
     *
     * <b>Documentation of 'Mode'</b>:
     *
     * If the meaning of "Mode" isn't clear, then there should be a description here.
     */
    virtual void onModeGet(const ::boost::shared_ptr< ModeGet >& payload);

    /**
     * Sends back the update to a previous onModeGet().
     *
     * <b>Documentation of 'Mode'</b>:
     *
     * If the meaning of "Mode" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onModeGet(). If the act
     * is not specified, i.e. the most recent invocation will be answered. In
     * case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendModeGetUpdate(uint8 mode, act_t act = 0);

    /**
     * Set the value of the property 'Mode' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'Mode'</b>:
     *
     * If the meaning of "Mode" isn't clear, then there should be a description here.
     */
    void setMode(uint8 mode);

    /**
     * Returns the current value of the property 'Mode'.
     *
     * <b>Documentation of 'Mode'</b>:
     *
     * If the meaning of "Mode" isn't clear, then there should be a description here.
     */
    uint8 getMode() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendModeUpdate().
     *
     * <b>Documentation of 'Mode'</b>:
     *
     * If the meaning of "Mode" isn't clear, then there should be a description here.
     */
    void sendModeUpdate();

    // property 'Role'

    /**
     * The method onRoleGet() is called by ASF when a client invokes the read
     * method for the property 'Role'. The onRoleGet() method returns by
     * default the current property value to the caller. In case this default
     * behavior doesn't match your needs feel free to override this method.
     *
     * <b>Documentation of 'Role'</b>:
     *
     * If the meaning of "Role" isn't clear, then there should be a description here.
     */
    virtual void onRoleGet(const ::boost::shared_ptr< RoleGet >& payload);

    /**
     * Sends back the update to a previous onRoleGet().
     *
     * <b>Documentation of 'Role'</b>:
     *
     * If the meaning of "Role" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onRoleGet(). If the act
     * is not specified, i.e. the most recent invocation will be answered. In
     * case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendRoleGetUpdate(uint8 role, act_t act = 0);

    /**
     * Set the value of the property 'Role' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'Role'</b>:
     *
     * If the meaning of "Role" isn't clear, then there should be a description here.
     */
    void setRole(uint8 role);

    /**
     * Returns the current value of the property 'Role'.
     *
     * <b>Documentation of 'Role'</b>:
     *
     * If the meaning of "Role" isn't clear, then there should be a description here.
     */
    uint8 getRole() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendRoleUpdate().
     *
     * <b>Documentation of 'Role'</b>:
     *
     * If the meaning of "Role" isn't clear, then there should be a description here.
     */
    void sendRoleUpdate();

    // property 'EnableAvpPause'

    /**
     * The method onEnableAvpPauseGet() is called by ASF when a client invokes
     * the read method for the property 'EnableAvpPause'. The
     * onEnableAvpPauseGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'EnableAvpPause'</b>:
     *
     * If the meaning of "EnableAvpPause" isn't clear, then there should be a description here.
     */
    virtual void onEnableAvpPauseGet(const ::boost::shared_ptr< EnableAvpPauseGet >& payload);

    /**
     * Sends back the update to a previous onEnableAvpPauseGet().
     *
     * <b>Documentation of 'EnableAvpPause'</b>:
     *
     * If the meaning of "EnableAvpPause" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onEnableAvpPauseGet().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendEnableAvpPauseGetUpdate(bool enableAvpPause, act_t act = 0);

    /**
     * The method onEnableAvpPauseSet() is called by ASF when a client invokes
     * the write method for the property 'EnableAvpPause'. The
     * onEnableAvpPauseSet() method set property value to the given parameter
     * EnableAvpPause by default. If this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'EnableAvpPause'</b>:
     *
     * If the meaning of "EnableAvpPause" isn't clear, then there should be a description here.
     */
    virtual void onEnableAvpPauseSet(const ::boost::shared_ptr< EnableAvpPauseSet >& payload);

    /**
     * Sends back the update to a previous onEnableAvpPauseSet().
     *
     * <b>Documentation of 'EnableAvpPause'</b>:
     *
     * If the meaning of "EnableAvpPause" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onEnableAvpPauseSet().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendEnableAvpPauseSetUpdate(act_t act = 0);

    /**
     * Set the value of the property 'EnableAvpPause' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'EnableAvpPause'</b>:
     *
     * If the meaning of "EnableAvpPause" isn't clear, then there should be a description here.
     */
    void setEnableAvpPause(bool enableAvpPause);

    /**
     * Returns the current value of the property 'EnableAvpPause'.
     *
     * <b>Documentation of 'EnableAvpPause'</b>:
     *
     * If the meaning of "EnableAvpPause" isn't clear, then there should be a description here.
     */
    bool getEnableAvpPause() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendEnableAvpPauseUpdate().
     *
     * <b>Documentation of 'EnableAvpPause'</b>:
     *
     * If the meaning of "EnableAvpPause" isn't clear, then there should be a description here.
     */
    void sendEnableAvpPauseUpdate();

    // method 'Connect'

    /**
     * The method onConnect() is called by ASF when a client invokes the
     * method 'Connect'. A subclass has to implement this method and send back
     * a response to the client either with the sendConnect() or
     * sendConnectError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'Connect'</b>:
     *
     * If the meaning of "Connect" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onConnectRequest (const ::boost::shared_ptr< ConnectRequest >& request) = 0;

    /**
     * The method sendConnectResponse() sends a response of a previous method
     * invocation of 'Connect' back to the client.
     *
     * <b>Documentation of 'Connect'</b>:
     *
     * If the meaning of "Connect" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onConnect(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendConnectResponse (act_t act = 0);

    /**
     * The method sendConnectError() sends an error response of a previous
     * method invocation of 'Connect' back to the client.
     *
     * <b>Documentation of 'Connect'</b>:
     *
     * If the meaning of "Connect" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onConnect(). If the act
     * is not specified, i.e. the most recent invocation will be answered. In
     * case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendConnectError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'Disconnect'

    /**
     * The method onDisconnect() is called by ASF when a client invokes the
     * method 'Disconnect'. A subclass has to implement this method and send
     * back a response to the client either with the sendDisconnect() or
     * sendDisconnectError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'Disconnect'</b>:
     *
     * If the meaning of "Disconnect" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onDisconnectRequest (const ::boost::shared_ptr< DisconnectRequest >& request) = 0;

    /**
     * The method sendDisconnectResponse() sends a response of a previous
     * method invocation of 'Disconnect' back to the client.
     *
     * <b>Documentation of 'Disconnect'</b>:
     *
     * If the meaning of "Disconnect" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onDisconnect(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendDisconnectResponse (act_t act = 0);

    /**
     * The method sendDisconnectError() sends an error response of a previous
     * method invocation of 'Disconnect' back to the client.
     *
     * <b>Documentation of 'Disconnect'</b>:
     *
     * If the meaning of "Disconnect" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onDisconnect(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendDisconnectError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'Pair'

    /**
     * The method onPair() is called by ASF when a client invokes the method
     * 'Pair'. A subclass has to implement this method and send back a
     * response to the client either with the sendPair() or sendPairError()
     * method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'Pair'</b>:
     *
     * If the meaning of "Pair" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onPairRequest (const ::boost::shared_ptr< PairRequest >& request) = 0;

    /**
     * The method sendPairResponse() sends a response of a previous method
     * invocation of 'Pair' back to the client.
     *
     * <b>Documentation of 'Pair'</b>:
     *
     * If the meaning of "Pair" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onPair(). If the act is not specified, i.e. the most recent invocation
     * will be answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendPairResponse (act_t act = 0);

    /**
     * The method sendPairError() sends an error response of a previous method
     * invocation of 'Pair' back to the client.
     *
     * <b>Documentation of 'Pair'</b>:
     *
     * If the meaning of "Pair" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onPair(). If the act is
     * not specified, i.e. the most recent invocation will be answered. In
     * case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendPairError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'CancelPairing'

    /**
     * The method onCancelPairing() is called by ASF when a client invokes the
     * method 'CancelPairing'. A subclass has to implement this method and
     * send back a response to the client either with the sendCancelPairing()
     * or sendCancelPairingError() method. Do not invoke this method on your
     * own.
     *
     * <b>Documentation of 'CancelPairing'</b>:
     *
     * If the meaning of "CancelPairing" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onCancelPairingRequest (const ::boost::shared_ptr< CancelPairingRequest >& request) = 0;

    /**
     * The method sendCancelPairingResponse() sends a response of a previous
     * method invocation of 'CancelPairing' back to the client.
     *
     * <b>Documentation of 'CancelPairing'</b>:
     *
     * If the meaning of "CancelPairing" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onCancelPairing(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendCancelPairingResponse (act_t act = 0);

    /**
     * The method sendCancelPairingError() sends an error response of a
     * previous method invocation of 'CancelPairing' back to the client.
     *
     * <b>Documentation of 'CancelPairing'</b>:
     *
     * If the meaning of "CancelPairing" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onCancelPairing(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendCancelPairingError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'DiscoverServices'

    /**
     * The method onDiscoverServices() is called by ASF when a client invokes
     * the method 'DiscoverServices'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendDiscoverServices() or sendDiscoverServicesError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'DiscoverServices'</b>:
     *
     * If the meaning of "DiscoverServices" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onDiscoverServicesRequest (const ::boost::shared_ptr< DiscoverServicesRequest >& request) = 0;

    /**
     * The method sendDiscoverServicesResponse() sends a response of a
     * previous method invocation of 'DiscoverServices' back to the client.
     *
     * <b>Documentation of 'DiscoverServices'</b>:
     *
     * If the meaning of "DiscoverServices" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onDiscoverServices(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendDiscoverServicesResponse (act_t act = 0);

    /**
     * The method sendDiscoverServicesError() sends an error response of a
     * previous method invocation of 'DiscoverServices' back to the client.
     *
     * <b>Documentation of 'DiscoverServices'</b>:
     *
     * If the meaning of "DiscoverServices" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onDiscoverServices(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendDiscoverServicesError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'CancelDiscovery'

    /**
     * The method onCancelDiscovery() is called by ASF when a client invokes
     * the method 'CancelDiscovery'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendCancelDiscovery() or sendCancelDiscoveryError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'CancelDiscovery'</b>:
     *
     * If the meaning of "CancelDiscovery" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onCancelDiscoveryRequest (const ::boost::shared_ptr< CancelDiscoveryRequest >& request) = 0;

    /**
     * The method sendCancelDiscoveryResponse() sends a response of a previous
     * method invocation of 'CancelDiscovery' back to the client.
     *
     * <b>Documentation of 'CancelDiscovery'</b>:
     *
     * If the meaning of "CancelDiscovery" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onCancelDiscovery(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendCancelDiscoveryResponse (act_t act = 0);

    /**
     * The method sendCancelDiscoveryError() sends an error response of a
     * previous method invocation of 'CancelDiscovery' back to the client.
     *
     * <b>Documentation of 'CancelDiscovery'</b>:
     *
     * If the meaning of "CancelDiscovery" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onCancelDiscovery(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendCancelDiscoveryError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

private:
    void onGetAll(std::map<std::basic_string<char>, ::asf::dbus::DBusVariant>&) const;

    AddressUpdate _AddressProperty;

    ClassUpdate _ClassProperty;

    IconUpdate _IconProperty;

    UUIDsUpdate _UUIDsProperty;

    PairedUpdate _PairedProperty;

    ConnectedUpdate _ConnectedProperty;

    TrustedUpdate _TrustedProperty;

    BlockedUpdate _BlockedProperty;

    AliasUpdate _AliasProperty;

    AdapterUpdate _AdapterProperty;

    ModaliasUpdate _ModaliasProperty;

    RSSIUpdate _RSSIProperty;

    VendorUpdate _VendorProperty;

    VendorSourceUpdate _VendorSourceProperty;

    ProductUpdate _ProductProperty;

    MapInfoUpdate _MapInfoProperty;

    ConnectedServiceUpdate _ConnectedServiceProperty;

    VersionUpdate _VersionProperty;

    PBAPInfoUpdate _PBAPInfoProperty;

    ModeUpdate _ModeProperty;

    RoleUpdate _RoleProperty;

    EnableAvpPauseUpdate _EnableAvpPauseProperty;

    friend class Device1StubDelegate;

    DECLARE_CLASS_LOGGER();
};

} // namespace Device1
} // namespace bluez
} // namespace org

#endif // ORG_BLUEZ_DEVICE1STUB_H
