/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_BLUEZ_DEVICE1PROXY_H
#define ORG_BLUEZ_DEVICE1PROXY_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/nullable.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusProxy.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "org/bluez/Device1.h"
#include <dbus/dbus.h>
#include <string>
#include <vector>

namespace org {
namespace bluez {
namespace Device1 {

class Device1Proxy;

class AdapterCallbackIF {
public:
    virtual ~AdapterCallbackIF() {}

    virtual void onAdapterError(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< AdapterError >& error) = 0;

    virtual void onAdapterUpdate(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< AdapterUpdate >& update) = 0;
};

class AddressCallbackIF {
public:
    virtual ~AddressCallbackIF() {}

    virtual void onAddressError(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< AddressError >& error) = 0;

    virtual void onAddressUpdate(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< AddressUpdate >& update) = 0;
};

class AliasCallbackIF {
public:
    virtual ~AliasCallbackIF() {}

    virtual void onAliasError(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< AliasError >& error) = 0;

    virtual void onAliasUpdate(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< AliasUpdate >& update) = 0;
};

class BlockedCallbackIF {
public:
    virtual ~BlockedCallbackIF() {}

    virtual void onBlockedError(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< BlockedError >& error) = 0;

    virtual void onBlockedUpdate(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< BlockedUpdate >& update) = 0;
};

class CancelDiscoveryCallbackIF {
public:
    virtual ~CancelDiscoveryCallbackIF() {}

    virtual void onCancelDiscoveryError(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< CancelDiscoveryError >& error) = 0;

    virtual void onCancelDiscoveryResponse(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< CancelDiscoveryResponse >& response) = 0;
};

class CancelPairingCallbackIF {
public:
    virtual ~CancelPairingCallbackIF() {}

    virtual void onCancelPairingError(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< CancelPairingError >& error) = 0;

    virtual void onCancelPairingResponse(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< CancelPairingResponse >& response) = 0;
};

class ClassCallbackIF {
public:
    virtual ~ClassCallbackIF() {}

    virtual void onClassError(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< ClassError >& error) = 0;

    virtual void onClassUpdate(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< ClassUpdate >& update) = 0;
};

class ConnectCallbackIF {
public:
    virtual ~ConnectCallbackIF() {}

    virtual void onConnectError(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< ConnectError >& error) = 0;

    virtual void onConnectResponse(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< ConnectResponse >& response) = 0;
};

class ConnectedCallbackIF {
public:
    virtual ~ConnectedCallbackIF() {}

    virtual void onConnectedError(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< ConnectedError >& error) = 0;

    virtual void onConnectedUpdate(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< ConnectedUpdate >& update) = 0;
};

class ConnectedServiceCallbackIF {
public:
    virtual ~ConnectedServiceCallbackIF() {}

    virtual void onConnectedServiceError(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< ConnectedServiceError >& error) = 0;

    virtual void onConnectedServiceUpdate(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< ConnectedServiceUpdate >& update) = 0;
};

class DisconnectCallbackIF {
public:
    virtual ~DisconnectCallbackIF() {}

    virtual void onDisconnectError(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< DisconnectError >& error) = 0;

    virtual void onDisconnectResponse(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< DisconnectResponse >& response) = 0;
};

class DiscoverServicesCallbackIF {
public:
    virtual ~DiscoverServicesCallbackIF() {}

    virtual void onDiscoverServicesError(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< DiscoverServicesError >& error) = 0;

    virtual void onDiscoverServicesResponse(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< DiscoverServicesResponse >& response) = 0;
};

class EnableAvpPauseCallbackIF {
public:
    virtual ~EnableAvpPauseCallbackIF() {}

    virtual void onEnableAvpPauseError(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< EnableAvpPauseError >& error) = 0;

    virtual void onEnableAvpPauseUpdate(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< EnableAvpPauseUpdate >& update) = 0;
};

class IconCallbackIF {
public:
    virtual ~IconCallbackIF() {}

    virtual void onIconError(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< IconError >& error) = 0;

    virtual void onIconUpdate(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< IconUpdate >& update) = 0;
};

class IncomingPairingCompCallbackIF {
public:
    virtual ~IncomingPairingCompCallbackIF() {}

    virtual void onIncomingPairingCompError(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< IncomingPairingCompError >& error) = 0;

    virtual void onIncomingPairingCompSignal(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< IncomingPairingCompSignal >& signal) = 0;
};

class MapInfoCallbackIF {
public:
    virtual ~MapInfoCallbackIF() {}

    virtual void onMapInfoError(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< MapInfoError >& error) = 0;

    virtual void onMapInfoUpdate(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< MapInfoUpdate >& update) = 0;
};

class ModaliasCallbackIF {
public:
    virtual ~ModaliasCallbackIF() {}

    virtual void onModaliasError(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< ModaliasError >& error) = 0;

    virtual void onModaliasUpdate(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< ModaliasUpdate >& update) = 0;
};

class ModeCallbackIF {
public:
    virtual ~ModeCallbackIF() {}

    virtual void onModeError(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< ModeError >& error) = 0;

    virtual void onModeUpdate(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< ModeUpdate >& update) = 0;
};

class PBAPInfoCallbackIF {
public:
    virtual ~PBAPInfoCallbackIF() {}

    virtual void onPBAPInfoError(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< PBAPInfoError >& error) = 0;

    virtual void onPBAPInfoUpdate(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< PBAPInfoUpdate >& update) = 0;
};

class PairCallbackIF {
public:
    virtual ~PairCallbackIF() {}

    virtual void onPairError(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< PairError >& error) = 0;

    virtual void onPairResponse(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< PairResponse >& response) = 0;
};

class PairedCallbackIF {
public:
    virtual ~PairedCallbackIF() {}

    virtual void onPairedError(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< PairedError >& error) = 0;

    virtual void onPairedUpdate(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< PairedUpdate >& update) = 0;
};

class ProductCallbackIF {
public:
    virtual ~ProductCallbackIF() {}

    virtual void onProductError(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< ProductError >& error) = 0;

    virtual void onProductUpdate(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< ProductUpdate >& update) = 0;
};

class RSSICallbackIF {
public:
    virtual ~RSSICallbackIF() {}

    virtual void onRSSIError(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< RSSIError >& error) = 0;

    virtual void onRSSIUpdate(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< RSSIUpdate >& update) = 0;
};

class ReportLinkkeyCallbackIF {
public:
    virtual ~ReportLinkkeyCallbackIF() {}

    virtual void onReportLinkkeyError(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< ReportLinkkeyError >& error) = 0;

    virtual void onReportLinkkeySignal(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< ReportLinkkeySignal >& signal) = 0;
};

class RoleCallbackIF {
public:
    virtual ~RoleCallbackIF() {}

    virtual void onRoleError(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< RoleError >& error) = 0;

    virtual void onRoleUpdate(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< RoleUpdate >& update) = 0;
};

class SDPProcessReportCallbackIF {
public:
    virtual ~SDPProcessReportCallbackIF() {}

    virtual void onSDPProcessReportError(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< SDPProcessReportError >& error) = 0;

    virtual void onSDPProcessReportSignal(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< SDPProcessReportSignal >& signal) = 0;
};

class TrustedCallbackIF {
public:
    virtual ~TrustedCallbackIF() {}

    virtual void onTrustedError(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< TrustedError >& error) = 0;

    virtual void onTrustedUpdate(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< TrustedUpdate >& update) = 0;
};

class UUIDsCallbackIF {
public:
    virtual ~UUIDsCallbackIF() {}

    virtual void onUUIDsError(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< UUIDsError >& error) = 0;

    virtual void onUUIDsUpdate(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< UUIDsUpdate >& update) = 0;
};

class VendorCallbackIF {
public:
    virtual ~VendorCallbackIF() {}

    virtual void onVendorError(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< VendorError >& error) = 0;

    virtual void onVendorUpdate(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< VendorUpdate >& update) = 0;
};

class VendorSourceCallbackIF {
public:
    virtual ~VendorSourceCallbackIF() {}

    virtual void onVendorSourceError(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< VendorSourceError >& error) = 0;

    virtual void onVendorSourceUpdate(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< VendorSourceUpdate >& update) = 0;
};

class VersionCallbackIF {
public:
    virtual ~VersionCallbackIF() {}

    virtual void onVersionError(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< VersionError >& error) = 0;

    virtual void onVersionUpdate(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< VersionUpdate >& update) = 0;
};


/**
 * Device1Proxy is the client side representation of the D-Bus service
 * interface 'org.bluez.Device1' (specified in file
 * stack_component_device.xml).
 *
 * If the meaning of "org.bluez.Device1" isn't clear, then there should be a description here.
 */
class Device1Proxy : public ::asf::dbus::DBusProxy
{
public:
    /**
     * Create a new instance of Device1Proxy.
     */
    static ::boost::shared_ptr< Device1Proxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Create a new instance of Device1Proxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @deprecated use the createProxy() method with the parameter
     * ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector instead.
     */
    static ::boost::shared_ptr< Device1Proxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        ::DBusBusType busType,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector connectorOptions;
        connectorOptions.setBusType(::asf::dbus::DBusUtils::toOptions(busType).getBusType());
        return createProxy(portName, busName, objectPath, connectorOptions, serviceAvailable);
    }

    /**
     * Create a new instance of Device1Proxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     */
    static ::boost::shared_ptr< Device1Proxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        const ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector& connectorOptions,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< Device1Proxy > proxyNew(new Device1Proxy(portName, serviceAvailable));
        ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew, busName, objectPath, connectorOptions);
        proxyNew->createHelperProxies(true);
        return proxyNew;
    }

    virtual ~Device1Proxy ();


    // Signal 'ReportLinkkey'

    /**
     * Notify on the signal 'ReportLinkkey'. This method registers for signal
     * changes by D-Bus service.
     *
     * <b>Documentation of 'ReportLinkkey'</b>:
     *
     * If the meaning of "ReportLinkkey" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendReportLinkkeyRegister(ReportLinkkeyCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'ReportLinkkey'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'ReportLinkkey'</b>:
     *
     * If the meaning of "ReportLinkkey" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendReportLinkkeyRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendReportLinkkeyDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'ReportLinkkey'.
     */
    void sendReportLinkkeyDeregisterAll () const;

    // Signal 'IncomingPairingComp'

    /**
     * Notify on the signal 'IncomingPairingComp'. This method registers for
     * signal changes by D-Bus service.
     *
     * <b>Documentation of 'IncomingPairingComp'</b>:
     *
     * If the meaning of "IncomingPairingComp" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendIncomingPairingCompRegister(IncomingPairingCompCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'IncomingPairingComp'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'IncomingPairingComp'</b>:
     *
     * If the meaning of "IncomingPairingComp" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendIncomingPairingCompRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendIncomingPairingCompDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'IncomingPairingComp'.
     */
    void sendIncomingPairingCompDeregisterAll () const;

    // Signal 'SDPProcessReport'

    /**
     * Notify on the signal 'SDPProcessReport'. This method registers for
     * signal changes by D-Bus service.
     *
     * <b>Documentation of 'SDPProcessReport'</b>:
     *
     * If the meaning of "SDPProcessReport" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSDPProcessReportRegister(SDPProcessReportCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'SDPProcessReport'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'SDPProcessReport'</b>:
     *
     * If the meaning of "SDPProcessReport" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendSDPProcessReportRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendSDPProcessReportDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'SDPProcessReport'.
     */
    void sendSDPProcessReportDeregisterAll () const;


    // Property 'Address'

    /**
     * Notify on the property 'Address'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'Address'</b>:
     *
     * If the meaning of "Address" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAddressRegister(AddressCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'Address'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'Address'</b>:
     *
     * If the meaning of "Address" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendAddressRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendAddressDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'Address'.
     */
    void sendAddressDeregisterAll() const;

    /**
     * Request the value of the property 'Address' from the D-Bus server. This
     * method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'Address'</b>:
     *
     * If the meaning of "Address" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAddressGet(AddressCallbackIF& cb);


    /**
     * Returns the current value of the property 'Address' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasAddress()
     * returns true.
     *
     * @return the previously received value of the property 'Address'.
     */
    const ::std::string& getAddress() const;

    /**
     * Determines whether a status message for the property 'Address' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasAddress() const;

    // Property 'Class'

    /**
     * Notify on the property 'Class'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'Class'</b>:
     *
     * If the meaning of "Class" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendClassRegister(ClassCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'Class'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'Class'</b>:
     *
     * If the meaning of "Class" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendClassRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendClassDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'Class'.
     */
    void sendClassDeregisterAll() const;

    /**
     * Request the value of the property 'Class' from the D-Bus server. This
     * method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'Class'</b>:
     *
     * If the meaning of "Class" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendClassGet(ClassCallbackIF& cb);


    /**
     * Returns the current value of the property 'Class' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasClass()
     * returns true.
     *
     * @return the previously received value of the property 'Class'.
     */
    uint32 getClass() const;

    /**
     * Determines whether a status message for the property 'Class' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasClass() const;

    // Property 'Icon'

    /**
     * Notify on the property 'Icon'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'Icon'</b>:
     *
     * If the meaning of "Icon" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendIconRegister(IconCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'Icon'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'Icon'</b>:
     *
     * If the meaning of "Icon" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendIconRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendIconDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'Icon'.
     */
    void sendIconDeregisterAll() const;

    /**
     * Request the value of the property 'Icon' from the D-Bus server. This
     * method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'Icon'</b>:
     *
     * If the meaning of "Icon" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendIconGet(IconCallbackIF& cb);


    /**
     * Returns the current value of the property 'Icon' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasIcon()
     * returns true.
     *
     * @return the previously received value of the property 'Icon'.
     */
    const ::std::string& getIcon() const;

    /**
     * Determines whether a status message for the property 'Icon' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasIcon() const;

    // Property 'UUIDs'

    /**
     * Notify on the property 'UUIDs'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'UUIDs'</b>:
     *
     * If the meaning of "UUIDs" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendUUIDsRegister(UUIDsCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'UUIDs'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'UUIDs'</b>:
     *
     * If the meaning of "UUIDs" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendUUIDsRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendUUIDsDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'UUIDs'.
     */
    void sendUUIDsDeregisterAll() const;

    /**
     * Request the value of the property 'UUIDs' from the D-Bus server. This
     * method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'UUIDs'</b>:
     *
     * If the meaning of "UUIDs" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendUUIDsGet(UUIDsCallbackIF& cb);


    /**
     * Returns the current value of the property 'UUIDs' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasUUIDs()
     * returns true.
     *
     * @return the previously received value of the property 'UUIDs'.
     */
    const ::std::vector< ::std::string >& getUUIDs() const;

    /**
     * Determines whether a status message for the property 'UUIDs' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasUUIDs() const;

    // Property 'Paired'

    /**
     * Notify on the property 'Paired'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'Paired'</b>:
     *
     * If the meaning of "Paired" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendPairedRegister(PairedCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'Paired'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'Paired'</b>:
     *
     * If the meaning of "Paired" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendPairedRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendPairedDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'Paired'.
     */
    void sendPairedDeregisterAll() const;

    /**
     * Request the value of the property 'Paired' from the D-Bus server. This
     * method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'Paired'</b>:
     *
     * If the meaning of "Paired" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendPairedGet(PairedCallbackIF& cb);


    /**
     * Returns the current value of the property 'Paired' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasPaired()
     * returns true.
     *
     * @return the previously received value of the property 'Paired'.
     */
    bool getPaired() const;

    /**
     * Determines whether a status message for the property 'Paired' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasPaired() const;

    // Property 'Connected'

    /**
     * Notify on the property 'Connected'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'Connected'</b>:
     *
     * If the meaning of "Connected" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendConnectedRegister(ConnectedCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'Connected'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'Connected'</b>:
     *
     * If the meaning of "Connected" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendConnectedRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendConnectedDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'Connected'.
     */
    void sendConnectedDeregisterAll() const;

    /**
     * Request the value of the property 'Connected' from the D-Bus server.
     * This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'Connected'</b>:
     *
     * If the meaning of "Connected" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendConnectedGet(ConnectedCallbackIF& cb);


    /**
     * Returns the current value of the property 'Connected' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasConnected()
     * returns true.
     *
     * @return the previously received value of the property 'Connected'.
     */
    bool getConnected() const;

    /**
     * Determines whether a status message for the property 'Connected' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasConnected() const;

    // Property 'Trusted'

    /**
     * Notify on the property 'Trusted'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'Trusted'</b>:
     *
     * If the meaning of "Trusted" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendTrustedRegister(TrustedCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'Trusted'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'Trusted'</b>:
     *
     * If the meaning of "Trusted" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendTrustedRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendTrustedDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'Trusted'.
     */
    void sendTrustedDeregisterAll() const;

    /**
     * Request the value of the property 'Trusted' from the D-Bus server. This
     * method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'Trusted'</b>:
     *
     * If the meaning of "Trusted" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendTrustedGet(TrustedCallbackIF& cb);

    /**
     * Set the value of the property 'Trusted'. This method sends a Set
     * message to the D-Bus server.
     *
     * @deprecated use the sendTrustedSet(TrustedCallbackIF& cb, bool trusted)
     * method instead.
     *
     * <b>Documentation of 'Trusted'</b>:
     *
     * If the meaning of "Trusted" isn't clear, then there should be a description here.
     */
    void sendTrustedSet(bool trusted);

    /**
     * Set the value of the property 'Trusted'. This method sends a Set
     * message to the D-Bus server.
     *
     * <b>Documentation of 'Trusted'</b>:
     *
     * If the meaning of "Trusted" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Set message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendTrustedSet(TrustedCallbackIF& cb, bool trusted);

    /**
     * Returns the current value of the property 'Trusted' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasTrusted()
     * returns true.
     *
     * @return the previously received value of the property 'Trusted'.
     */
    bool getTrusted() const;

    /**
     * Determines whether a status message for the property 'Trusted' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasTrusted() const;

    // Property 'Blocked'

    /**
     * Notify on the property 'Blocked'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'Blocked'</b>:
     *
     * If the meaning of "Blocked" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendBlockedRegister(BlockedCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'Blocked'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'Blocked'</b>:
     *
     * If the meaning of "Blocked" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendBlockedRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendBlockedDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'Blocked'.
     */
    void sendBlockedDeregisterAll() const;

    /**
     * Request the value of the property 'Blocked' from the D-Bus server. This
     * method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'Blocked'</b>:
     *
     * If the meaning of "Blocked" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendBlockedGet(BlockedCallbackIF& cb);

    /**
     * Set the value of the property 'Blocked'. This method sends a Set
     * message to the D-Bus server.
     *
     * @deprecated use the sendBlockedSet(BlockedCallbackIF& cb, bool blocked)
     * method instead.
     *
     * <b>Documentation of 'Blocked'</b>:
     *
     * If the meaning of "Blocked" isn't clear, then there should be a description here.
     */
    void sendBlockedSet(bool blocked);

    /**
     * Set the value of the property 'Blocked'. This method sends a Set
     * message to the D-Bus server.
     *
     * <b>Documentation of 'Blocked'</b>:
     *
     * If the meaning of "Blocked" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Set message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendBlockedSet(BlockedCallbackIF& cb, bool blocked);

    /**
     * Returns the current value of the property 'Blocked' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasBlocked()
     * returns true.
     *
     * @return the previously received value of the property 'Blocked'.
     */
    bool getBlocked() const;

    /**
     * Determines whether a status message for the property 'Blocked' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasBlocked() const;

    // Property 'Alias'

    /**
     * Notify on the property 'Alias'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'Alias'</b>:
     *
     * If the meaning of "Alias" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAliasRegister(AliasCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'Alias'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'Alias'</b>:
     *
     * If the meaning of "Alias" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendAliasRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendAliasDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'Alias'.
     */
    void sendAliasDeregisterAll() const;

    /**
     * Request the value of the property 'Alias' from the D-Bus server. This
     * method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'Alias'</b>:
     *
     * If the meaning of "Alias" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAliasGet(AliasCallbackIF& cb);

    /**
     * Set the value of the property 'Alias'. This method sends a Set message
     * to the D-Bus server.
     *
     * @deprecated use the sendAliasSet(AliasCallbackIF& cb, const
     * ::std::string& alias) method instead.
     *
     * <b>Documentation of 'Alias'</b>:
     *
     * If the meaning of "Alias" isn't clear, then there should be a description here.
     */
    void sendAliasSet(const ::std::string& alias);

    /**
     * Set the value of the property 'Alias'. This method sends a Set message
     * to the D-Bus server.
     *
     * <b>Documentation of 'Alias'</b>:
     *
     * If the meaning of "Alias" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Set message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAliasSet(AliasCallbackIF& cb, const ::std::string& alias);

    /**
     * Returns the current value of the property 'Alias' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasAlias()
     * returns true.
     *
     * @return the previously received value of the property 'Alias'.
     */
    const ::std::string& getAlias() const;

    /**
     * Determines whether a status message for the property 'Alias' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasAlias() const;

    // Property 'Adapter'

    /**
     * Notify on the property 'Adapter'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'Adapter'</b>:
     *
     * If the meaning of "Adapter" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAdapterRegister(AdapterCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'Adapter'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'Adapter'</b>:
     *
     * If the meaning of "Adapter" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendAdapterRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendAdapterDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'Adapter'.
     */
    void sendAdapterDeregisterAll() const;

    /**
     * Request the value of the property 'Adapter' from the D-Bus server. This
     * method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'Adapter'</b>:
     *
     * If the meaning of "Adapter" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAdapterGet(AdapterCallbackIF& cb);


    /**
     * Returns the current value of the property 'Adapter' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasAdapter()
     * returns true.
     *
     * @return the previously received value of the property 'Adapter'.
     */
    const ::std::string& getAdapter() const;

    /**
     * Determines whether a status message for the property 'Adapter' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasAdapter() const;

    // Property 'Modalias'

    /**
     * Notify on the property 'Modalias'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'Modalias'</b>:
     *
     * If the meaning of "Modalias" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendModaliasRegister(ModaliasCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'Modalias'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'Modalias'</b>:
     *
     * If the meaning of "Modalias" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendModaliasRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendModaliasDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'Modalias'.
     */
    void sendModaliasDeregisterAll() const;

    /**
     * Request the value of the property 'Modalias' from the D-Bus server.
     * This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'Modalias'</b>:
     *
     * If the meaning of "Modalias" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendModaliasGet(ModaliasCallbackIF& cb);


    /**
     * Returns the current value of the property 'Modalias' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasModalias()
     * returns true.
     *
     * @return the previously received value of the property 'Modalias'.
     */
    const ::std::string& getModalias() const;

    /**
     * Determines whether a status message for the property 'Modalias' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasModalias() const;

    // Property 'RSSI'

    /**
     * Notify on the property 'RSSI'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'RSSI'</b>:
     *
     * If the meaning of "RSSI" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRSSIRegister(RSSICallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'RSSI'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'RSSI'</b>:
     *
     * If the meaning of "RSSI" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendRSSIRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendRSSIDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'RSSI'.
     */
    void sendRSSIDeregisterAll() const;

    /**
     * Request the value of the property 'RSSI' from the D-Bus server. This
     * method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'RSSI'</b>:
     *
     * If the meaning of "RSSI" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRSSIGet(RSSICallbackIF& cb);


    /**
     * Returns the current value of the property 'RSSI' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasRSSI()
     * returns true.
     *
     * @return the previously received value of the property 'RSSI'.
     */
    uint8 getRSSI() const;

    /**
     * Determines whether a status message for the property 'RSSI' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasRSSI() const;

    // Property 'Vendor'

    /**
     * Notify on the property 'Vendor'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'Vendor'</b>:
     *
     * If the meaning of "Vendor" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendVendorRegister(VendorCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'Vendor'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'Vendor'</b>:
     *
     * If the meaning of "Vendor" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendVendorRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendVendorDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'Vendor'.
     */
    void sendVendorDeregisterAll() const;

    /**
     * Request the value of the property 'Vendor' from the D-Bus server. This
     * method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'Vendor'</b>:
     *
     * If the meaning of "Vendor" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendVendorGet(VendorCallbackIF& cb);


    /**
     * Returns the current value of the property 'Vendor' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasVendor()
     * returns true.
     *
     * @return the previously received value of the property 'Vendor'.
     */
    uint16 getVendor() const;

    /**
     * Determines whether a status message for the property 'Vendor' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasVendor() const;

    // Property 'VendorSource'

    /**
     * Notify on the property 'VendorSource'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'VendorSource'</b>:
     *
     * If the meaning of "VendorSource" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendVendorSourceRegister(VendorSourceCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'VendorSource'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'VendorSource'</b>:
     *
     * If the meaning of "VendorSource" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendVendorSourceRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendVendorSourceDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'VendorSource'.
     */
    void sendVendorSourceDeregisterAll() const;

    /**
     * Request the value of the property 'VendorSource' from the D-Bus server.
     * This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'VendorSource'</b>:
     *
     * If the meaning of "VendorSource" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendVendorSourceGet(VendorSourceCallbackIF& cb);


    /**
     * Returns the current value of the property 'VendorSource' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasVendorSource() returns true.
     *
     * @return the previously received value of the property 'VendorSource'.
     */
    uint16 getVendorSource() const;

    /**
     * Determines whether a status message for the property 'VendorSource' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasVendorSource() const;

    // Property 'Product'

    /**
     * Notify on the property 'Product'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'Product'</b>:
     *
     * If the meaning of "Product" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendProductRegister(ProductCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'Product'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'Product'</b>:
     *
     * If the meaning of "Product" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendProductRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendProductDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'Product'.
     */
    void sendProductDeregisterAll() const;

    /**
     * Request the value of the property 'Product' from the D-Bus server. This
     * method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'Product'</b>:
     *
     * If the meaning of "Product" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendProductGet(ProductCallbackIF& cb);


    /**
     * Returns the current value of the property 'Product' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasProduct()
     * returns true.
     *
     * @return the previously received value of the property 'Product'.
     */
    uint16 getProduct() const;

    /**
     * Determines whether a status message for the property 'Product' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasProduct() const;

    // Property 'MapInfo'

    /**
     * Notify on the property 'MapInfo'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'MapInfo'</b>:
     *
     * If the meaning of "MapInfo" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendMapInfoRegister(MapInfoCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'MapInfo'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'MapInfo'</b>:
     *
     * If the meaning of "MapInfo" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendMapInfoRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendMapInfoDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'MapInfo'.
     */
    void sendMapInfoDeregisterAll() const;

    /**
     * Request the value of the property 'MapInfo' from the D-Bus server. This
     * method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'MapInfo'</b>:
     *
     * If the meaning of "MapInfo" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendMapInfoGet(MapInfoCallbackIF& cb);


    /**
     * Returns the current value of the property 'MapInfo' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasMapInfo()
     * returns true.
     *
     * @return the previously received value of the property 'MapInfo'.
     */
    const ::std::vector< ::std::string >& getMapInfo() const;

    /**
     * Determines whether a status message for the property 'MapInfo' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasMapInfo() const;

    // Property 'ConnectedService'

    /**
     * Notify on the property 'ConnectedService'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'ConnectedService'</b>:
     *
     * If the meaning of "ConnectedService" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendConnectedServiceRegister(ConnectedServiceCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'ConnectedService'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'ConnectedService'</b>:
     *
     * If the meaning of "ConnectedService" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendConnectedServiceRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendConnectedServiceDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'ConnectedService'.
     */
    void sendConnectedServiceDeregisterAll() const;

    /**
     * Request the value of the property 'ConnectedService' from the D-Bus
     * server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'ConnectedService'</b>:
     *
     * If the meaning of "ConnectedService" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendConnectedServiceGet(ConnectedServiceCallbackIF& cb);


    /**
     * Returns the current value of the property 'ConnectedService' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasConnectedService() returns true.
     *
     * @return the previously received value of the property 'ConnectedService'.
     */
    uint64 getConnectedService() const;

    /**
     * Determines whether a status message for the property 'ConnectedService'
     * was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasConnectedService() const;

    // Property 'Version'

    /**
     * Notify on the property 'Version'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'Version'</b>:
     *
     * If the meaning of "Version" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendVersionRegister(VersionCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'Version'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'Version'</b>:
     *
     * If the meaning of "Version" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendVersionRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendVersionDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'Version'.
     */
    void sendVersionDeregisterAll() const;

    /**
     * Request the value of the property 'Version' from the D-Bus server. This
     * method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'Version'</b>:
     *
     * If the meaning of "Version" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendVersionGet(VersionCallbackIF& cb);


    /**
     * Returns the current value of the property 'Version' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasVersion()
     * returns true.
     *
     * @return the previously received value of the property 'Version'.
     */
    uint16 getVersion() const;

    /**
     * Determines whether a status message for the property 'Version' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasVersion() const;

    // Property 'PBAPInfo'

    /**
     * Notify on the property 'PBAPInfo'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'PBAPInfo'</b>:
     *
     * If the meaning of "PBAPInfo" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendPBAPInfoRegister(PBAPInfoCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'PBAPInfo'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'PBAPInfo'</b>:
     *
     * If the meaning of "PBAPInfo" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendPBAPInfoRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendPBAPInfoDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'PBAPInfo'.
     */
    void sendPBAPInfoDeregisterAll() const;

    /**
     * Request the value of the property 'PBAPInfo' from the D-Bus server.
     * This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'PBAPInfo'</b>:
     *
     * If the meaning of "PBAPInfo" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendPBAPInfoGet(PBAPInfoCallbackIF& cb);


    /**
     * Returns the current value of the property 'PBAPInfo' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasPBAPInfo()
     * returns true.
     *
     * @return the previously received value of the property 'PBAPInfo'.
     */
    const ::std::string& getPBAPInfo() const;

    /**
     * Determines whether a status message for the property 'PBAPInfo' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasPBAPInfo() const;

    // Property 'Mode'

    /**
     * Notify on the property 'Mode'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'Mode'</b>:
     *
     * If the meaning of "Mode" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendModeRegister(ModeCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'Mode'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'Mode'</b>:
     *
     * If the meaning of "Mode" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendModeRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendModeDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'Mode'.
     */
    void sendModeDeregisterAll() const;

    /**
     * Request the value of the property 'Mode' from the D-Bus server. This
     * method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'Mode'</b>:
     *
     * If the meaning of "Mode" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendModeGet(ModeCallbackIF& cb);


    /**
     * Returns the current value of the property 'Mode' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasMode()
     * returns true.
     *
     * @return the previously received value of the property 'Mode'.
     */
    uint8 getMode() const;

    /**
     * Determines whether a status message for the property 'Mode' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasMode() const;

    // Property 'Role'

    /**
     * Notify on the property 'Role'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'Role'</b>:
     *
     * If the meaning of "Role" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRoleRegister(RoleCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'Role'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'Role'</b>:
     *
     * If the meaning of "Role" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendRoleRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendRoleDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'Role'.
     */
    void sendRoleDeregisterAll() const;

    /**
     * Request the value of the property 'Role' from the D-Bus server. This
     * method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'Role'</b>:
     *
     * If the meaning of "Role" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRoleGet(RoleCallbackIF& cb);


    /**
     * Returns the current value of the property 'Role' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasRole()
     * returns true.
     *
     * @return the previously received value of the property 'Role'.
     */
    uint8 getRole() const;

    /**
     * Determines whether a status message for the property 'Role' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasRole() const;

    // Property 'EnableAvpPause'

    /**
     * Notify on the property 'EnableAvpPause'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'EnableAvpPause'</b>:
     *
     * If the meaning of "EnableAvpPause" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendEnableAvpPauseRegister(EnableAvpPauseCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'EnableAvpPause'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'EnableAvpPause'</b>:
     *
     * If the meaning of "EnableAvpPause" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendEnableAvpPauseRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendEnableAvpPauseDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'EnableAvpPause'.
     */
    void sendEnableAvpPauseDeregisterAll() const;

    /**
     * Request the value of the property 'EnableAvpPause' from the D-Bus
     * server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'EnableAvpPause'</b>:
     *
     * If the meaning of "EnableAvpPause" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendEnableAvpPauseGet(EnableAvpPauseCallbackIF& cb);

    /**
     * Set the value of the property 'EnableAvpPause'. This method sends a Set
     * message to the D-Bus server.
     *
     * @deprecated use the sendEnableAvpPauseSet(EnableAvpPauseCallbackIF& cb,
     * bool enableAvpPause) method instead.
     *
     * <b>Documentation of 'EnableAvpPause'</b>:
     *
     * If the meaning of "EnableAvpPause" isn't clear, then there should be a description here.
     */
    void sendEnableAvpPauseSet(bool enableAvpPause);

    /**
     * Set the value of the property 'EnableAvpPause'. This method sends a Set
     * message to the D-Bus server.
     *
     * <b>Documentation of 'EnableAvpPause'</b>:
     *
     * If the meaning of "EnableAvpPause" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Set message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendEnableAvpPauseSet(EnableAvpPauseCallbackIF& cb, bool enableAvpPause);

    /**
     * Returns the current value of the property 'EnableAvpPause' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasEnableAvpPause() returns true.
     *
     * @return the previously received value of the property 'EnableAvpPause'.
     */
    bool getEnableAvpPause() const;

    /**
     * Determines whether a status message for the property 'EnableAvpPause'
     * was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasEnableAvpPause() const;


    // Method 'Connect'

    /**
     * Call the method 'Connect'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'Connect'</b>:
     *
     * If the meaning of "Connect" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendConnectRequest(ConnectCallbackIF& cb) const;

    // Method 'Disconnect'

    /**
     * Call the method 'Disconnect'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'Disconnect'</b>:
     *
     * If the meaning of "Disconnect" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDisconnectRequest(DisconnectCallbackIF& cb) const;

    // Method 'Pair'

    /**
     * Call the method 'Pair'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'Pair'</b>:
     *
     * If the meaning of "Pair" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendPairRequest(PairCallbackIF& cb) const;

    // Method 'CancelPairing'

    /**
     * Call the method 'CancelPairing'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'CancelPairing'</b>:
     *
     * If the meaning of "CancelPairing" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendCancelPairingRequest(CancelPairingCallbackIF& cb) const;

    // Method 'DiscoverServices'

    /**
     * Call the method 'DiscoverServices'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'DiscoverServices'</b>:
     *
     * If the meaning of "DiscoverServices" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param pattern If the meaning of "pattern" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDiscoverServicesRequest(DiscoverServicesCallbackIF& cb, const ::std::string& pattern) const;

    // Method 'CancelDiscovery'

    /**
     * Call the method 'CancelDiscovery'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'CancelDiscovery'</b>:
     *
     * If the meaning of "CancelDiscovery" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendCancelDiscoveryRequest(CancelDiscoveryCallbackIF& cb) const;

    /**
     * Release all property and signal notifications.
     */
    void sendDeregisterAll () const;

private:

    Device1Proxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    act_t addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const;

    act_t addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const;

    virtual void clearAllProperties ();

    // Property 'Address'

    ::asf::core::nullable< AddressUpdate > _address;

    // Property 'Class'

    ::asf::core::nullable< ClassUpdate > _class;

    // Property 'Icon'

    ::asf::core::nullable< IconUpdate > _icon;

    // Property 'UUIDs'

    ::asf::core::nullable< UUIDsUpdate > _uUIDs;

    // Property 'Paired'

    ::asf::core::nullable< PairedUpdate > _paired;

    // Property 'Connected'

    ::asf::core::nullable< ConnectedUpdate > _connected;

    // Property 'Trusted'

    ::asf::core::nullable< TrustedUpdate > _trusted;

    // Property 'Blocked'

    ::asf::core::nullable< BlockedUpdate > _blocked;

    // Property 'Alias'

    ::asf::core::nullable< AliasUpdate > _alias;

    // Property 'Adapter'

    ::asf::core::nullable< AdapterUpdate > _adapter;

    // Property 'Modalias'

    ::asf::core::nullable< ModaliasUpdate > _modalias;

    // Property 'RSSI'

    ::asf::core::nullable< RSSIUpdate > _rSSI;

    // Property 'Vendor'

    ::asf::core::nullable< VendorUpdate > _vendor;

    // Property 'VendorSource'

    ::asf::core::nullable< VendorSourceUpdate > _vendorSource;

    // Property 'Product'

    ::asf::core::nullable< ProductUpdate > _product;

    // Property 'MapInfo'

    ::asf::core::nullable< MapInfoUpdate > _mapInfo;

    // Property 'ConnectedService'

    ::asf::core::nullable< ConnectedServiceUpdate > _connectedService;

    // Property 'Version'

    ::asf::core::nullable< VersionUpdate > _version;

    // Property 'PBAPInfo'

    ::asf::core::nullable< PBAPInfoUpdate > _pBAPInfo;

    // Property 'Mode'

    ::asf::core::nullable< ModeUpdate > _mode;

    // Property 'Role'

    ::asf::core::nullable< RoleUpdate > _role;

    // Property 'EnableAvpPause'

    ::asf::core::nullable< EnableAvpPauseUpdate > _enableAvpPause;

    DECLARE_CLASS_LOGGER();

    friend class Device1ProxyCallback;
};

} // namespace Device1
} // namespace bluez
} // namespace org

#endif // ORG_BLUEZ_DEVICE1PROXY_H
