/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "org/bluez/Device1.h"
#include "org/bluez/Device1DBus.h"
#include "org/bluez/Device1Json.h"
#include "org/bluez/Device1Proxy.h"
#include <string>
#include <vector>

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace org {
namespace bluez {
namespace Device1 {

DEFINE_CLASS_LOGGER("//org/bluez/hci1/dev_addr/created/during/runtime/org/bluez/Device1", Device1Proxy);

class Device1ProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    Device1ProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< Device1Proxy >& proxyShared = ::boost::static_pointer_cast< Device1Proxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_ReportLinkkey:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ReportLinkkeySignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ReportLinkkey", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<ReportLinkkeySignal> payload = ::boost::static_pointer_cast<ReportLinkkeySignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((ReportLinkkeyCallbackIF*) _callback)->onReportLinkkeySignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_IncomingPairingComp:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), IncomingPairingCompSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "IncomingPairingComp", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<IncomingPairingCompSignal> payload = ::boost::static_pointer_cast<IncomingPairingCompSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((IncomingPairingCompCallbackIF*) _callback)->onIncomingPairingCompSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_SDPProcessReport:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SDPProcessReportSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SDPProcessReport", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<SDPProcessReportSignal> payload = ::boost::static_pointer_cast<SDPProcessReportSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((SDPProcessReportCallbackIF*) _callback)->onSDPProcessReportSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_Address:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AddressError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Address", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AddressError> payload = ::boost::static_pointer_cast<AddressError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((AddressCallbackIF*) _callback)->onAddressError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AddressUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Address", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AddressUpdate> payload = ::boost::static_pointer_cast<AddressUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((AddressCallbackIF*) _callback)->onAddressUpdate(proxyShared, payload);
                        proxyShared->_address = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_Class:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ClassError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Class", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ClassError> payload = ::boost::static_pointer_cast<ClassError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((ClassCallbackIF*) _callback)->onClassError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ClassUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Class", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ClassUpdate> payload = ::boost::static_pointer_cast<ClassUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((ClassCallbackIF*) _callback)->onClassUpdate(proxyShared, payload);
                        proxyShared->_class = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_Icon:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), IconError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Icon", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<IconError> payload = ::boost::static_pointer_cast<IconError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((IconCallbackIF*) _callback)->onIconError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), IconUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Icon", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<IconUpdate> payload = ::boost::static_pointer_cast<IconUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((IconCallbackIF*) _callback)->onIconUpdate(proxyShared, payload);
                        proxyShared->_icon = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_UUIDs:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UUIDsError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "UUIDs", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<UUIDsError> payload = ::boost::static_pointer_cast<UUIDsError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((UUIDsCallbackIF*) _callback)->onUUIDsError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UUIDsUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "UUIDs", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<UUIDsUpdate> payload = ::boost::static_pointer_cast<UUIDsUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((UUIDsCallbackIF*) _callback)->onUUIDsUpdate(proxyShared, payload);
                        proxyShared->_uUIDs = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_Paired:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), PairedError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Paired", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<PairedError> payload = ::boost::static_pointer_cast<PairedError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((PairedCallbackIF*) _callback)->onPairedError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), PairedUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Paired", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<PairedUpdate> payload = ::boost::static_pointer_cast<PairedUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((PairedCallbackIF*) _callback)->onPairedUpdate(proxyShared, payload);
                        proxyShared->_paired = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_Connected:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ConnectedError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Connected", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ConnectedError> payload = ::boost::static_pointer_cast<ConnectedError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((ConnectedCallbackIF*) _callback)->onConnectedError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ConnectedUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Connected", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ConnectedUpdate> payload = ::boost::static_pointer_cast<ConnectedUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((ConnectedCallbackIF*) _callback)->onConnectedUpdate(proxyShared, payload);
                        proxyShared->_connected = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_Trusted:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), TrustedError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Trusted", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<TrustedError> payload = ::boost::static_pointer_cast<TrustedError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((TrustedCallbackIF*) _callback)->onTrustedError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), TrustedUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Trusted", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<TrustedUpdate> payload = ::boost::static_pointer_cast<TrustedUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((TrustedCallbackIF*) _callback)->onTrustedUpdate(proxyShared, payload);
                        proxyShared->_trusted = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_Blocked:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BlockedError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Blocked", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<BlockedError> payload = ::boost::static_pointer_cast<BlockedError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((BlockedCallbackIF*) _callback)->onBlockedError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BlockedUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Blocked", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<BlockedUpdate> payload = ::boost::static_pointer_cast<BlockedUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((BlockedCallbackIF*) _callback)->onBlockedUpdate(proxyShared, payload);
                        proxyShared->_blocked = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_Alias:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AliasError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Alias", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AliasError> payload = ::boost::static_pointer_cast<AliasError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((AliasCallbackIF*) _callback)->onAliasError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AliasUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Alias", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AliasUpdate> payload = ::boost::static_pointer_cast<AliasUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((AliasCallbackIF*) _callback)->onAliasUpdate(proxyShared, payload);
                        proxyShared->_alias = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_Adapter:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AdapterError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Adapter", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AdapterError> payload = ::boost::static_pointer_cast<AdapterError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((AdapterCallbackIF*) _callback)->onAdapterError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AdapterUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Adapter", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AdapterUpdate> payload = ::boost::static_pointer_cast<AdapterUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((AdapterCallbackIF*) _callback)->onAdapterUpdate(proxyShared, payload);
                        proxyShared->_adapter = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_Modalias:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ModaliasError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Modalias", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ModaliasError> payload = ::boost::static_pointer_cast<ModaliasError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((ModaliasCallbackIF*) _callback)->onModaliasError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ModaliasUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Modalias", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ModaliasUpdate> payload = ::boost::static_pointer_cast<ModaliasUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((ModaliasCallbackIF*) _callback)->onModaliasUpdate(proxyShared, payload);
                        proxyShared->_modalias = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_RSSI:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RSSIError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "RSSI", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RSSIError> payload = ::boost::static_pointer_cast<RSSIError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((RSSICallbackIF*) _callback)->onRSSIError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RSSIUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "RSSI", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RSSIUpdate> payload = ::boost::static_pointer_cast<RSSIUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((RSSICallbackIF*) _callback)->onRSSIUpdate(proxyShared, payload);
                        proxyShared->_rSSI = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_Vendor:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), VendorError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Vendor", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<VendorError> payload = ::boost::static_pointer_cast<VendorError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((VendorCallbackIF*) _callback)->onVendorError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), VendorUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Vendor", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<VendorUpdate> payload = ::boost::static_pointer_cast<VendorUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((VendorCallbackIF*) _callback)->onVendorUpdate(proxyShared, payload);
                        proxyShared->_vendor = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_VendorSource:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), VendorSourceError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "VendorSource", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<VendorSourceError> payload = ::boost::static_pointer_cast<VendorSourceError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((VendorSourceCallbackIF*) _callback)->onVendorSourceError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), VendorSourceUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "VendorSource", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<VendorSourceUpdate> payload = ::boost::static_pointer_cast<VendorSourceUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((VendorSourceCallbackIF*) _callback)->onVendorSourceUpdate(proxyShared, payload);
                        proxyShared->_vendorSource = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_Product:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ProductError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Product", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ProductError> payload = ::boost::static_pointer_cast<ProductError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((ProductCallbackIF*) _callback)->onProductError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ProductUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Product", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ProductUpdate> payload = ::boost::static_pointer_cast<ProductUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((ProductCallbackIF*) _callback)->onProductUpdate(proxyShared, payload);
                        proxyShared->_product = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_MapInfo:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), MapInfoError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "MapInfo", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<MapInfoError> payload = ::boost::static_pointer_cast<MapInfoError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((MapInfoCallbackIF*) _callback)->onMapInfoError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), MapInfoUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "MapInfo", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<MapInfoUpdate> payload = ::boost::static_pointer_cast<MapInfoUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((MapInfoCallbackIF*) _callback)->onMapInfoUpdate(proxyShared, payload);
                        proxyShared->_mapInfo = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_ConnectedService:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ConnectedServiceError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ConnectedService", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ConnectedServiceError> payload = ::boost::static_pointer_cast<ConnectedServiceError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((ConnectedServiceCallbackIF*) _callback)->onConnectedServiceError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ConnectedServiceUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ConnectedService", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ConnectedServiceUpdate> payload = ::boost::static_pointer_cast<ConnectedServiceUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((ConnectedServiceCallbackIF*) _callback)->onConnectedServiceUpdate(proxyShared, payload);
                        proxyShared->_connectedService = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_Version:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), VersionError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Version", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<VersionError> payload = ::boost::static_pointer_cast<VersionError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((VersionCallbackIF*) _callback)->onVersionError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), VersionUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Version", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<VersionUpdate> payload = ::boost::static_pointer_cast<VersionUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((VersionCallbackIF*) _callback)->onVersionUpdate(proxyShared, payload);
                        proxyShared->_version = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_PBAPInfo:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), PBAPInfoError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "PBAPInfo", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<PBAPInfoError> payload = ::boost::static_pointer_cast<PBAPInfoError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((PBAPInfoCallbackIF*) _callback)->onPBAPInfoError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), PBAPInfoUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "PBAPInfo", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<PBAPInfoUpdate> payload = ::boost::static_pointer_cast<PBAPInfoUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((PBAPInfoCallbackIF*) _callback)->onPBAPInfoUpdate(proxyShared, payload);
                        proxyShared->_pBAPInfo = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_Mode:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ModeError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Mode", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ModeError> payload = ::boost::static_pointer_cast<ModeError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((ModeCallbackIF*) _callback)->onModeError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ModeUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Mode", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ModeUpdate> payload = ::boost::static_pointer_cast<ModeUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((ModeCallbackIF*) _callback)->onModeUpdate(proxyShared, payload);
                        proxyShared->_mode = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_Role:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RoleError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Role", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RoleError> payload = ::boost::static_pointer_cast<RoleError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((RoleCallbackIF*) _callback)->onRoleError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RoleUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Role", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RoleUpdate> payload = ::boost::static_pointer_cast<RoleUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((RoleCallbackIF*) _callback)->onRoleUpdate(proxyShared, payload);
                        proxyShared->_role = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_EnableAvpPause:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EnableAvpPauseError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "EnableAvpPause", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<EnableAvpPauseError> payload = ::boost::static_pointer_cast<EnableAvpPauseError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((EnableAvpPauseCallbackIF*) _callback)->onEnableAvpPauseError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EnableAvpPauseUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "EnableAvpPause", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<EnableAvpPauseUpdate> payload = ::boost::static_pointer_cast<EnableAvpPauseUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((EnableAvpPauseCallbackIF*) _callback)->onEnableAvpPauseUpdate(proxyShared, payload);
                        proxyShared->_enableAvpPause = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_Connect:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), ConnectError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "Connect", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ConnectError> payload = ::boost::static_pointer_cast<ConnectError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ConnectCallbackIF*) _callback)->onConnectError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ConnectResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "Connect", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ConnectResponse> payload = ::boost::static_pointer_cast<ConnectResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ConnectCallbackIF*) _callback)->onConnectResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_Disconnect:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), DisconnectError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "Disconnect", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DisconnectError> payload = ::boost::static_pointer_cast<DisconnectError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((DisconnectCallbackIF*) _callback)->onDisconnectError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DisconnectResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "Disconnect", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DisconnectResponse> payload = ::boost::static_pointer_cast<DisconnectResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((DisconnectCallbackIF*) _callback)->onDisconnectResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_Pair:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), PairError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "Pair", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<PairError> payload = ::boost::static_pointer_cast<PairError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((PairCallbackIF*) _callback)->onPairError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), PairResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "Pair", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<PairResponse> payload = ::boost::static_pointer_cast<PairResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((PairCallbackIF*) _callback)->onPairResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_CancelPairing:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), CancelPairingError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "CancelPairing", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CancelPairingError> payload = ::boost::static_pointer_cast<CancelPairingError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((CancelPairingCallbackIF*) _callback)->onCancelPairingError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CancelPairingResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "CancelPairing", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CancelPairingResponse> payload = ::boost::static_pointer_cast<CancelPairingResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((CancelPairingCallbackIF*) _callback)->onCancelPairingResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_DiscoverServices:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), DiscoverServicesError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "DiscoverServices", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DiscoverServicesError> payload = ::boost::static_pointer_cast<DiscoverServicesError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((DiscoverServicesCallbackIF*) _callback)->onDiscoverServicesError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DiscoverServicesResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "DiscoverServices", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DiscoverServicesResponse> payload = ::boost::static_pointer_cast<DiscoverServicesResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((DiscoverServicesCallbackIF*) _callback)->onDiscoverServicesResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_CancelDiscovery:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), CancelDiscoveryError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "CancelDiscovery", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CancelDiscoveryError> payload = ::boost::static_pointer_cast<CancelDiscoveryError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((CancelDiscoveryCallbackIF*) _callback)->onCancelDiscoveryError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CancelDiscoveryResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "CancelDiscovery", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CancelDiscoveryResponse> payload = ::boost::static_pointer_cast<CancelDiscoveryResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((CancelDiscoveryCallbackIF*) _callback)->onCancelDiscoveryResponse (proxyShared, payload);
                        return true;
                    }
                }
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_ReportLinkkey: {
                ::boost::shared_ptr< ReportLinkkeyError > payload = ::boost::shared_ptr< ReportLinkkeyError >
                (new ReportLinkkeyError(DBUS_ERROR_NO_SERVER, "The DBus service Device1 is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ReportLinkkey", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<Device1Proxy> proxyShared = ::boost::static_pointer_cast<Device1Proxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ReportLinkkeyCallbackIF*) _callback)->onReportLinkkeyError (proxyShared,payload);
                return true;
            }
            break;
            case ID_IncomingPairingComp: {
                ::boost::shared_ptr< IncomingPairingCompError > payload = ::boost::shared_ptr< IncomingPairingCompError >
                (new IncomingPairingCompError(DBUS_ERROR_NO_SERVER, "The DBus service Device1 is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "IncomingPairingComp", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<Device1Proxy> proxyShared = ::boost::static_pointer_cast<Device1Proxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((IncomingPairingCompCallbackIF*) _callback)->onIncomingPairingCompError (proxyShared,payload);
                return true;
            }
            break;
            case ID_SDPProcessReport: {
                ::boost::shared_ptr< SDPProcessReportError > payload = ::boost::shared_ptr< SDPProcessReportError >
                (new SDPProcessReportError(DBUS_ERROR_NO_SERVER, "The DBus service Device1 is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SDPProcessReport", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<Device1Proxy> proxyShared = ::boost::static_pointer_cast<Device1Proxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SDPProcessReportCallbackIF*) _callback)->onSDPProcessReportError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Address: {
                ::boost::shared_ptr< AddressError > payload = ::boost::shared_ptr< AddressError >
                (new AddressError(DBUS_ERROR_NO_SERVER, "The DBus service Device1 is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Address", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<Device1Proxy> proxyShared = ::boost::static_pointer_cast<Device1Proxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((AddressCallbackIF*) _callback)->onAddressError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Class: {
                ::boost::shared_ptr< ClassError > payload = ::boost::shared_ptr< ClassError >
                (new ClassError(DBUS_ERROR_NO_SERVER, "The DBus service Device1 is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Class", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<Device1Proxy> proxyShared = ::boost::static_pointer_cast<Device1Proxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ClassCallbackIF*) _callback)->onClassError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Icon: {
                ::boost::shared_ptr< IconError > payload = ::boost::shared_ptr< IconError >
                (new IconError(DBUS_ERROR_NO_SERVER, "The DBus service Device1 is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Icon", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<Device1Proxy> proxyShared = ::boost::static_pointer_cast<Device1Proxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((IconCallbackIF*) _callback)->onIconError (proxyShared,payload);
                return true;
            }
            break;
            case ID_UUIDs: {
                ::boost::shared_ptr< UUIDsError > payload = ::boost::shared_ptr< UUIDsError >
                (new UUIDsError(DBUS_ERROR_NO_SERVER, "The DBus service Device1 is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "UUIDs", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<Device1Proxy> proxyShared = ::boost::static_pointer_cast<Device1Proxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((UUIDsCallbackIF*) _callback)->onUUIDsError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Paired: {
                ::boost::shared_ptr< PairedError > payload = ::boost::shared_ptr< PairedError >
                (new PairedError(DBUS_ERROR_NO_SERVER, "The DBus service Device1 is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Paired", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<Device1Proxy> proxyShared = ::boost::static_pointer_cast<Device1Proxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((PairedCallbackIF*) _callback)->onPairedError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Connected: {
                ::boost::shared_ptr< ConnectedError > payload = ::boost::shared_ptr< ConnectedError >
                (new ConnectedError(DBUS_ERROR_NO_SERVER, "The DBus service Device1 is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Connected", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<Device1Proxy> proxyShared = ::boost::static_pointer_cast<Device1Proxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ConnectedCallbackIF*) _callback)->onConnectedError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Trusted: {
                ::boost::shared_ptr< TrustedError > payload = ::boost::shared_ptr< TrustedError >
                (new TrustedError(DBUS_ERROR_NO_SERVER, "The DBus service Device1 is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Trusted", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<Device1Proxy> proxyShared = ::boost::static_pointer_cast<Device1Proxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((TrustedCallbackIF*) _callback)->onTrustedError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Blocked: {
                ::boost::shared_ptr< BlockedError > payload = ::boost::shared_ptr< BlockedError >
                (new BlockedError(DBUS_ERROR_NO_SERVER, "The DBus service Device1 is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Blocked", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<Device1Proxy> proxyShared = ::boost::static_pointer_cast<Device1Proxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((BlockedCallbackIF*) _callback)->onBlockedError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Alias: {
                ::boost::shared_ptr< AliasError > payload = ::boost::shared_ptr< AliasError >
                (new AliasError(DBUS_ERROR_NO_SERVER, "The DBus service Device1 is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Alias", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<Device1Proxy> proxyShared = ::boost::static_pointer_cast<Device1Proxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((AliasCallbackIF*) _callback)->onAliasError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Adapter: {
                ::boost::shared_ptr< AdapterError > payload = ::boost::shared_ptr< AdapterError >
                (new AdapterError(DBUS_ERROR_NO_SERVER, "The DBus service Device1 is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Adapter", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<Device1Proxy> proxyShared = ::boost::static_pointer_cast<Device1Proxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((AdapterCallbackIF*) _callback)->onAdapterError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Modalias: {
                ::boost::shared_ptr< ModaliasError > payload = ::boost::shared_ptr< ModaliasError >
                (new ModaliasError(DBUS_ERROR_NO_SERVER, "The DBus service Device1 is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Modalias", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<Device1Proxy> proxyShared = ::boost::static_pointer_cast<Device1Proxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ModaliasCallbackIF*) _callback)->onModaliasError (proxyShared,payload);
                return true;
            }
            break;
            case ID_RSSI: {
                ::boost::shared_ptr< RSSIError > payload = ::boost::shared_ptr< RSSIError >
                (new RSSIError(DBUS_ERROR_NO_SERVER, "The DBus service Device1 is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "RSSI", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<Device1Proxy> proxyShared = ::boost::static_pointer_cast<Device1Proxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((RSSICallbackIF*) _callback)->onRSSIError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Vendor: {
                ::boost::shared_ptr< VendorError > payload = ::boost::shared_ptr< VendorError >
                (new VendorError(DBUS_ERROR_NO_SERVER, "The DBus service Device1 is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Vendor", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<Device1Proxy> proxyShared = ::boost::static_pointer_cast<Device1Proxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((VendorCallbackIF*) _callback)->onVendorError (proxyShared,payload);
                return true;
            }
            break;
            case ID_VendorSource: {
                ::boost::shared_ptr< VendorSourceError > payload = ::boost::shared_ptr< VendorSourceError >
                (new VendorSourceError(DBUS_ERROR_NO_SERVER, "The DBus service Device1 is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "VendorSource", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<Device1Proxy> proxyShared = ::boost::static_pointer_cast<Device1Proxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((VendorSourceCallbackIF*) _callback)->onVendorSourceError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Product: {
                ::boost::shared_ptr< ProductError > payload = ::boost::shared_ptr< ProductError >
                (new ProductError(DBUS_ERROR_NO_SERVER, "The DBus service Device1 is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Product", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<Device1Proxy> proxyShared = ::boost::static_pointer_cast<Device1Proxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ProductCallbackIF*) _callback)->onProductError (proxyShared,payload);
                return true;
            }
            break;
            case ID_MapInfo: {
                ::boost::shared_ptr< MapInfoError > payload = ::boost::shared_ptr< MapInfoError >
                (new MapInfoError(DBUS_ERROR_NO_SERVER, "The DBus service Device1 is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "MapInfo", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<Device1Proxy> proxyShared = ::boost::static_pointer_cast<Device1Proxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((MapInfoCallbackIF*) _callback)->onMapInfoError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ConnectedService: {
                ::boost::shared_ptr< ConnectedServiceError > payload = ::boost::shared_ptr< ConnectedServiceError >
                (new ConnectedServiceError(DBUS_ERROR_NO_SERVER, "The DBus service Device1 is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ConnectedService", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<Device1Proxy> proxyShared = ::boost::static_pointer_cast<Device1Proxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ConnectedServiceCallbackIF*) _callback)->onConnectedServiceError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Version: {
                ::boost::shared_ptr< VersionError > payload = ::boost::shared_ptr< VersionError >
                (new VersionError(DBUS_ERROR_NO_SERVER, "The DBus service Device1 is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Version", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<Device1Proxy> proxyShared = ::boost::static_pointer_cast<Device1Proxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((VersionCallbackIF*) _callback)->onVersionError (proxyShared,payload);
                return true;
            }
            break;
            case ID_PBAPInfo: {
                ::boost::shared_ptr< PBAPInfoError > payload = ::boost::shared_ptr< PBAPInfoError >
                (new PBAPInfoError(DBUS_ERROR_NO_SERVER, "The DBus service Device1 is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "PBAPInfo", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<Device1Proxy> proxyShared = ::boost::static_pointer_cast<Device1Proxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((PBAPInfoCallbackIF*) _callback)->onPBAPInfoError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Mode: {
                ::boost::shared_ptr< ModeError > payload = ::boost::shared_ptr< ModeError >
                (new ModeError(DBUS_ERROR_NO_SERVER, "The DBus service Device1 is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Mode", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<Device1Proxy> proxyShared = ::boost::static_pointer_cast<Device1Proxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ModeCallbackIF*) _callback)->onModeError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Role: {
                ::boost::shared_ptr< RoleError > payload = ::boost::shared_ptr< RoleError >
                (new RoleError(DBUS_ERROR_NO_SERVER, "The DBus service Device1 is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Role", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<Device1Proxy> proxyShared = ::boost::static_pointer_cast<Device1Proxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((RoleCallbackIF*) _callback)->onRoleError (proxyShared,payload);
                return true;
            }
            break;
            case ID_EnableAvpPause: {
                ::boost::shared_ptr< EnableAvpPauseError > payload = ::boost::shared_ptr< EnableAvpPauseError >
                (new EnableAvpPauseError(DBUS_ERROR_NO_SERVER, "The DBus service Device1 is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "EnableAvpPause", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<Device1Proxy> proxyShared = ::boost::static_pointer_cast<Device1Proxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((EnableAvpPauseCallbackIF*) _callback)->onEnableAvpPauseError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Connect: {
                ::boost::shared_ptr< ConnectError > payload = ::boost::shared_ptr< ConnectError >
                (new ConnectError(DBUS_ERROR_NO_SERVER, "The DBus service Device1 is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Connect", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<Device1Proxy> proxyShared = ::boost::static_pointer_cast<Device1Proxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ConnectCallbackIF*) _callback)->onConnectError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Disconnect: {
                ::boost::shared_ptr< DisconnectError > payload = ::boost::shared_ptr< DisconnectError >
                (new DisconnectError(DBUS_ERROR_NO_SERVER, "The DBus service Device1 is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Disconnect", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<Device1Proxy> proxyShared = ::boost::static_pointer_cast<Device1Proxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((DisconnectCallbackIF*) _callback)->onDisconnectError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Pair: {
                ::boost::shared_ptr< PairError > payload = ::boost::shared_ptr< PairError >
                (new PairError(DBUS_ERROR_NO_SERVER, "The DBus service Device1 is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Pair", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<Device1Proxy> proxyShared = ::boost::static_pointer_cast<Device1Proxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((PairCallbackIF*) _callback)->onPairError (proxyShared,payload);
                return true;
            }
            break;
            case ID_CancelPairing: {
                ::boost::shared_ptr< CancelPairingError > payload = ::boost::shared_ptr< CancelPairingError >
                (new CancelPairingError(DBUS_ERROR_NO_SERVER, "The DBus service Device1 is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "CancelPairing", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<Device1Proxy> proxyShared = ::boost::static_pointer_cast<Device1Proxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((CancelPairingCallbackIF*) _callback)->onCancelPairingError (proxyShared,payload);
                return true;
            }
            break;
            case ID_DiscoverServices: {
                ::boost::shared_ptr< DiscoverServicesError > payload = ::boost::shared_ptr< DiscoverServicesError >
                (new DiscoverServicesError(DBUS_ERROR_NO_SERVER, "The DBus service Device1 is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "DiscoverServices", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<Device1Proxy> proxyShared = ::boost::static_pointer_cast<Device1Proxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((DiscoverServicesCallbackIF*) _callback)->onDiscoverServicesError (proxyShared,payload);
                return true;
            }
            break;
            case ID_CancelDiscovery: {
                ::boost::shared_ptr< CancelDiscoveryError > payload = ::boost::shared_ptr< CancelDiscoveryError >
                (new CancelDiscoveryError(DBUS_ERROR_NO_SERVER, "The DBus service Device1 is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "CancelDiscovery", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<Device1Proxy> proxyShared = ::boost::static_pointer_cast<Device1Proxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((CancelDiscoveryCallbackIF*) _callback)->onCancelDiscoveryError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& Device1ProxyCallback::_logger (Device1Proxy::_logger);

Device1Proxy::Device1Proxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "org.bluez.Device1", serviceAvailable, _logger) {
}

Device1Proxy::~Device1Proxy()
{
    sendDeregisterAll();
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< Device1Proxy > Device1Proxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<Device1Proxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< Device1Proxy > proxyNew(new Device1Proxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(true);
    return proxyNew;
}

act_t Device1Proxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    Device1ProxyCallback* callback = new Device1ProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t Device1Proxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    Device1ProxyCallback* callback = new Device1ProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void Device1Proxy::clearAllProperties ()
{
    _address = ::asf::core::nullable< AddressUpdate >();
    _class = ::asf::core::nullable< ClassUpdate >();
    _icon = ::asf::core::nullable< IconUpdate >();
    _uUIDs = ::asf::core::nullable< UUIDsUpdate >();
    _paired = ::asf::core::nullable< PairedUpdate >();
    _connected = ::asf::core::nullable< ConnectedUpdate >();
    _trusted = ::asf::core::nullable< TrustedUpdate >();
    _blocked = ::asf::core::nullable< BlockedUpdate >();
    _alias = ::asf::core::nullable< AliasUpdate >();
    _adapter = ::asf::core::nullable< AdapterUpdate >();
    _modalias = ::asf::core::nullable< ModaliasUpdate >();
    _rSSI = ::asf::core::nullable< RSSIUpdate >();
    _vendor = ::asf::core::nullable< VendorUpdate >();
    _vendorSource = ::asf::core::nullable< VendorSourceUpdate >();
    _product = ::asf::core::nullable< ProductUpdate >();
    _mapInfo = ::asf::core::nullable< MapInfoUpdate >();
    _connectedService = ::asf::core::nullable< ConnectedServiceUpdate >();
    _version = ::asf::core::nullable< VersionUpdate >();
    _pBAPInfo = ::asf::core::nullable< PBAPInfoUpdate >();
    _mode = ::asf::core::nullable< ModeUpdate >();
    _role = ::asf::core::nullable< RoleUpdate >();
    _enableAvpPause = ::asf::core::nullable< EnableAvpPauseUpdate >();
}

void Device1Proxy::sendDeregisterAll () const
{
    sendAddressDeregisterAll();
    sendClassDeregisterAll();
    sendIconDeregisterAll();
    sendUUIDsDeregisterAll();
    sendPairedDeregisterAll();
    sendConnectedDeregisterAll();
    sendTrustedDeregisterAll();
    sendBlockedDeregisterAll();
    sendAliasDeregisterAll();
    sendAdapterDeregisterAll();
    sendModaliasDeregisterAll();
    sendRSSIDeregisterAll();
    sendVendorDeregisterAll();
    sendVendorSourceDeregisterAll();
    sendProductDeregisterAll();
    sendMapInfoDeregisterAll();
    sendConnectedServiceDeregisterAll();
    sendVersionDeregisterAll();
    sendPBAPInfoDeregisterAll();
    sendModeDeregisterAll();
    sendRoleDeregisterAll();
    sendEnableAvpPauseDeregisterAll();
    sendReportLinkkeyDeregisterAll();
    sendIncomingPairingCompDeregisterAll();
    sendSDPProcessReportDeregisterAll();
}

act_t Device1Proxy::sendReportLinkkeyRegister(ReportLinkkeyCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "ReportLinkkey");
    act_t act = addSignalCallback(ID_ReportLinkkey, "ReportLinkkey", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "ReportLinkkey", &cb, act);
    return act;
}

bool Device1Proxy::sendReportLinkkeyDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("ReportLinkkey", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "ReportLinkkey", act, static_cast<int>(rv));
    return rv;
}

void Device1Proxy::sendReportLinkkeyDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "ReportLinkkey");
    _dbusProxyDelegate->deregisterSignalCallback("ReportLinkkey", 0, _dbusDaemonProxy.get(), false);
}

act_t Device1Proxy::sendIncomingPairingCompRegister(IncomingPairingCompCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "IncomingPairingComp");
    act_t act = addSignalCallback(ID_IncomingPairingComp, "IncomingPairingComp", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "IncomingPairingComp", &cb, act);
    return act;
}

bool Device1Proxy::sendIncomingPairingCompDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("IncomingPairingComp", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "IncomingPairingComp", act, static_cast<int>(rv));
    return rv;
}

void Device1Proxy::sendIncomingPairingCompDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "IncomingPairingComp");
    _dbusProxyDelegate->deregisterSignalCallback("IncomingPairingComp", 0, _dbusDaemonProxy.get(), false);
}

act_t Device1Proxy::sendSDPProcessReportRegister(SDPProcessReportCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "SDPProcessReport");
    act_t act = addSignalCallback(ID_SDPProcessReport, "SDPProcessReport", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "SDPProcessReport", &cb, act);
    return act;
}

bool Device1Proxy::sendSDPProcessReportDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("SDPProcessReport", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "SDPProcessReport", act, static_cast<int>(rv));
    return rv;
}

void Device1Proxy::sendSDPProcessReportDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "SDPProcessReport");
    _dbusProxyDelegate->deregisterSignalCallback("SDPProcessReport", 0, _dbusDaemonProxy.get(), false);
}

act_t Device1Proxy::sendAddressRegister(AddressCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_Address, "Address", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Address", &cb, act);
    return act;
}

bool Device1Proxy::sendAddressDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("Address", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Address", act, static_cast<int>(rv));
    return rv;
}

act_t Device1Proxy::sendAddressGet(AddressCallbackIF& cb) {
    Device1ProxyCallback* callback = new Device1ProxyCallback(ID_Address, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "Address", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("Address", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::string& Device1Proxy::getAddress() const {
    return _address.get().getAddress();
}

bool Device1Proxy::hasAddress() const {
    return _address.hasValue();
}

void Device1Proxy::sendAddressDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Address");
    _dbusProxyDelegate->deregisterSignalCallback("Address", 0, _dbusDaemonProxy.get(), true);
}

act_t Device1Proxy::sendClassRegister(ClassCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_Class, "Class", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Class", &cb, act);
    return act;
}

bool Device1Proxy::sendClassDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("Class", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Class", act, static_cast<int>(rv));
    return rv;
}

act_t Device1Proxy::sendClassGet(ClassCallbackIF& cb) {
    Device1ProxyCallback* callback = new Device1ProxyCallback(ID_Class, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "Class", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("Class", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint32 Device1Proxy::getClass() const {
    return _class.get().getClass();
}

bool Device1Proxy::hasClass() const {
    return _class.hasValue();
}

void Device1Proxy::sendClassDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Class");
    _dbusProxyDelegate->deregisterSignalCallback("Class", 0, _dbusDaemonProxy.get(), true);
}

act_t Device1Proxy::sendIconRegister(IconCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_Icon, "Icon", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Icon", &cb, act);
    return act;
}

bool Device1Proxy::sendIconDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("Icon", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Icon", act, static_cast<int>(rv));
    return rv;
}

act_t Device1Proxy::sendIconGet(IconCallbackIF& cb) {
    Device1ProxyCallback* callback = new Device1ProxyCallback(ID_Icon, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "Icon", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("Icon", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::string& Device1Proxy::getIcon() const {
    return _icon.get().getIcon();
}

bool Device1Proxy::hasIcon() const {
    return _icon.hasValue();
}

void Device1Proxy::sendIconDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Icon");
    _dbusProxyDelegate->deregisterSignalCallback("Icon", 0, _dbusDaemonProxy.get(), true);
}

act_t Device1Proxy::sendUUIDsRegister(UUIDsCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_UUIDs, "UUIDs", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "UUIDs", &cb, act);
    return act;
}

bool Device1Proxy::sendUUIDsDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("UUIDs", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "UUIDs", act, static_cast<int>(rv));
    return rv;
}

act_t Device1Proxy::sendUUIDsGet(UUIDsCallbackIF& cb) {
    Device1ProxyCallback* callback = new Device1ProxyCallback(ID_UUIDs, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "UUIDs", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("UUIDs", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::vector< ::std::string >& Device1Proxy::getUUIDs() const {
    return _uUIDs.get().getUUIDs();
}

bool Device1Proxy::hasUUIDs() const {
    return _uUIDs.hasValue();
}

void Device1Proxy::sendUUIDsDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "UUIDs");
    _dbusProxyDelegate->deregisterSignalCallback("UUIDs", 0, _dbusDaemonProxy.get(), true);
}

act_t Device1Proxy::sendPairedRegister(PairedCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_Paired, "Paired", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Paired", &cb, act);
    return act;
}

bool Device1Proxy::sendPairedDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("Paired", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Paired", act, static_cast<int>(rv));
    return rv;
}

act_t Device1Proxy::sendPairedGet(PairedCallbackIF& cb) {
    Device1ProxyCallback* callback = new Device1ProxyCallback(ID_Paired, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "Paired", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("Paired", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


bool Device1Proxy::getPaired() const {
    return _paired.get().getPaired();
}

bool Device1Proxy::hasPaired() const {
    return _paired.hasValue();
}

void Device1Proxy::sendPairedDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Paired");
    _dbusProxyDelegate->deregisterSignalCallback("Paired", 0, _dbusDaemonProxy.get(), true);
}

act_t Device1Proxy::sendConnectedRegister(ConnectedCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_Connected, "Connected", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Connected", &cb, act);
    return act;
}

bool Device1Proxy::sendConnectedDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("Connected", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Connected", act, static_cast<int>(rv));
    return rv;
}

act_t Device1Proxy::sendConnectedGet(ConnectedCallbackIF& cb) {
    Device1ProxyCallback* callback = new Device1ProxyCallback(ID_Connected, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "Connected", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("Connected", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


bool Device1Proxy::getConnected() const {
    return _connected.get().getConnected();
}

bool Device1Proxy::hasConnected() const {
    return _connected.hasValue();
}

void Device1Proxy::sendConnectedDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Connected");
    _dbusProxyDelegate->deregisterSignalCallback("Connected", 0, _dbusDaemonProxy.get(), true);
}

act_t Device1Proxy::sendTrustedRegister(TrustedCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_Trusted, "Trusted", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Trusted", &cb, act);
    return act;
}

bool Device1Proxy::sendTrustedDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("Trusted", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Trusted", act, static_cast<int>(rv));
    return rv;
}

act_t Device1Proxy::sendTrustedGet(TrustedCallbackIF& cb) {
    Device1ProxyCallback* callback = new Device1ProxyCallback(ID_Trusted, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "Trusted", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("Trusted", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void Device1Proxy::sendTrustedSet(bool trusted) {
    TrustedSet parameter(trusted);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "Trusted");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "Trusted", propertyContent);
}

act_t Device1Proxy::sendTrustedSet(TrustedCallbackIF& cb, bool trusted) {
    Device1ProxyCallback* callback = new Device1ProxyCallback(ID_Trusted, &cb);
    TrustedSet parameter(trusted);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "Trusted", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "Trusted", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

bool Device1Proxy::getTrusted() const {
    return _trusted.get().getTrusted();
}

bool Device1Proxy::hasTrusted() const {
    return _trusted.hasValue();
}

void Device1Proxy::sendTrustedDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Trusted");
    _dbusProxyDelegate->deregisterSignalCallback("Trusted", 0, _dbusDaemonProxy.get(), true);
}

act_t Device1Proxy::sendBlockedRegister(BlockedCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_Blocked, "Blocked", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Blocked", &cb, act);
    return act;
}

bool Device1Proxy::sendBlockedDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("Blocked", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Blocked", act, static_cast<int>(rv));
    return rv;
}

act_t Device1Proxy::sendBlockedGet(BlockedCallbackIF& cb) {
    Device1ProxyCallback* callback = new Device1ProxyCallback(ID_Blocked, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "Blocked", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("Blocked", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void Device1Proxy::sendBlockedSet(bool blocked) {
    BlockedSet parameter(blocked);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "Blocked");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "Blocked", propertyContent);
}

act_t Device1Proxy::sendBlockedSet(BlockedCallbackIF& cb, bool blocked) {
    Device1ProxyCallback* callback = new Device1ProxyCallback(ID_Blocked, &cb);
    BlockedSet parameter(blocked);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "Blocked", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "Blocked", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

bool Device1Proxy::getBlocked() const {
    return _blocked.get().getBlocked();
}

bool Device1Proxy::hasBlocked() const {
    return _blocked.hasValue();
}

void Device1Proxy::sendBlockedDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Blocked");
    _dbusProxyDelegate->deregisterSignalCallback("Blocked", 0, _dbusDaemonProxy.get(), true);
}

act_t Device1Proxy::sendAliasRegister(AliasCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_Alias, "Alias", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Alias", &cb, act);
    return act;
}

bool Device1Proxy::sendAliasDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("Alias", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Alias", act, static_cast<int>(rv));
    return rv;
}

act_t Device1Proxy::sendAliasGet(AliasCallbackIF& cb) {
    Device1ProxyCallback* callback = new Device1ProxyCallback(ID_Alias, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "Alias", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("Alias", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void Device1Proxy::sendAliasSet(const ::std::string& alias) {
    AliasSet parameter(alias);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "Alias");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "Alias", propertyContent);
}

act_t Device1Proxy::sendAliasSet(AliasCallbackIF& cb, const ::std::string& alias) {
    Device1ProxyCallback* callback = new Device1ProxyCallback(ID_Alias, &cb);
    AliasSet parameter(alias);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "Alias", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "Alias", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

const ::std::string& Device1Proxy::getAlias() const {
    return _alias.get().getAlias();
}

bool Device1Proxy::hasAlias() const {
    return _alias.hasValue();
}

void Device1Proxy::sendAliasDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Alias");
    _dbusProxyDelegate->deregisterSignalCallback("Alias", 0, _dbusDaemonProxy.get(), true);
}

act_t Device1Proxy::sendAdapterRegister(AdapterCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_Adapter, "Adapter", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Adapter", &cb, act);
    return act;
}

bool Device1Proxy::sendAdapterDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("Adapter", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Adapter", act, static_cast<int>(rv));
    return rv;
}

act_t Device1Proxy::sendAdapterGet(AdapterCallbackIF& cb) {
    Device1ProxyCallback* callback = new Device1ProxyCallback(ID_Adapter, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "Adapter", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("Adapter", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::string& Device1Proxy::getAdapter() const {
    return _adapter.get().getAdapter();
}

bool Device1Proxy::hasAdapter() const {
    return _adapter.hasValue();
}

void Device1Proxy::sendAdapterDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Adapter");
    _dbusProxyDelegate->deregisterSignalCallback("Adapter", 0, _dbusDaemonProxy.get(), true);
}

act_t Device1Proxy::sendModaliasRegister(ModaliasCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_Modalias, "Modalias", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Modalias", &cb, act);
    return act;
}

bool Device1Proxy::sendModaliasDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("Modalias", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Modalias", act, static_cast<int>(rv));
    return rv;
}

act_t Device1Proxy::sendModaliasGet(ModaliasCallbackIF& cb) {
    Device1ProxyCallback* callback = new Device1ProxyCallback(ID_Modalias, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "Modalias", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("Modalias", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::string& Device1Proxy::getModalias() const {
    return _modalias.get().getModalias();
}

bool Device1Proxy::hasModalias() const {
    return _modalias.hasValue();
}

void Device1Proxy::sendModaliasDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Modalias");
    _dbusProxyDelegate->deregisterSignalCallback("Modalias", 0, _dbusDaemonProxy.get(), true);
}

act_t Device1Proxy::sendRSSIRegister(RSSICallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_RSSI, "RSSI", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "RSSI", &cb, act);
    return act;
}

bool Device1Proxy::sendRSSIDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("RSSI", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "RSSI", act, static_cast<int>(rv));
    return rv;
}

act_t Device1Proxy::sendRSSIGet(RSSICallbackIF& cb) {
    Device1ProxyCallback* callback = new Device1ProxyCallback(ID_RSSI, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "RSSI", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("RSSI", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint8 Device1Proxy::getRSSI() const {
    return _rSSI.get().getRSSI();
}

bool Device1Proxy::hasRSSI() const {
    return _rSSI.hasValue();
}

void Device1Proxy::sendRSSIDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "RSSI");
    _dbusProxyDelegate->deregisterSignalCallback("RSSI", 0, _dbusDaemonProxy.get(), true);
}

act_t Device1Proxy::sendVendorRegister(VendorCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_Vendor, "Vendor", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Vendor", &cb, act);
    return act;
}

bool Device1Proxy::sendVendorDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("Vendor", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Vendor", act, static_cast<int>(rv));
    return rv;
}

act_t Device1Proxy::sendVendorGet(VendorCallbackIF& cb) {
    Device1ProxyCallback* callback = new Device1ProxyCallback(ID_Vendor, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "Vendor", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("Vendor", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint16 Device1Proxy::getVendor() const {
    return _vendor.get().getVendor();
}

bool Device1Proxy::hasVendor() const {
    return _vendor.hasValue();
}

void Device1Proxy::sendVendorDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Vendor");
    _dbusProxyDelegate->deregisterSignalCallback("Vendor", 0, _dbusDaemonProxy.get(), true);
}

act_t Device1Proxy::sendVendorSourceRegister(VendorSourceCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_VendorSource, "VendorSource", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "VendorSource", &cb, act);
    return act;
}

bool Device1Proxy::sendVendorSourceDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("VendorSource", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "VendorSource", act, static_cast<int>(rv));
    return rv;
}

act_t Device1Proxy::sendVendorSourceGet(VendorSourceCallbackIF& cb) {
    Device1ProxyCallback* callback = new Device1ProxyCallback(ID_VendorSource, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "VendorSource", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("VendorSource", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint16 Device1Proxy::getVendorSource() const {
    return _vendorSource.get().getVendorSource();
}

bool Device1Proxy::hasVendorSource() const {
    return _vendorSource.hasValue();
}

void Device1Proxy::sendVendorSourceDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "VendorSource");
    _dbusProxyDelegate->deregisterSignalCallback("VendorSource", 0, _dbusDaemonProxy.get(), true);
}

act_t Device1Proxy::sendProductRegister(ProductCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_Product, "Product", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Product", &cb, act);
    return act;
}

bool Device1Proxy::sendProductDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("Product", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Product", act, static_cast<int>(rv));
    return rv;
}

act_t Device1Proxy::sendProductGet(ProductCallbackIF& cb) {
    Device1ProxyCallback* callback = new Device1ProxyCallback(ID_Product, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "Product", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("Product", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint16 Device1Proxy::getProduct() const {
    return _product.get().getProduct();
}

bool Device1Proxy::hasProduct() const {
    return _product.hasValue();
}

void Device1Proxy::sendProductDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Product");
    _dbusProxyDelegate->deregisterSignalCallback("Product", 0, _dbusDaemonProxy.get(), true);
}

act_t Device1Proxy::sendMapInfoRegister(MapInfoCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_MapInfo, "MapInfo", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "MapInfo", &cb, act);
    return act;
}

bool Device1Proxy::sendMapInfoDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("MapInfo", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "MapInfo", act, static_cast<int>(rv));
    return rv;
}

act_t Device1Proxy::sendMapInfoGet(MapInfoCallbackIF& cb) {
    Device1ProxyCallback* callback = new Device1ProxyCallback(ID_MapInfo, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "MapInfo", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("MapInfo", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::vector< ::std::string >& Device1Proxy::getMapInfo() const {
    return _mapInfo.get().getMapInfo();
}

bool Device1Proxy::hasMapInfo() const {
    return _mapInfo.hasValue();
}

void Device1Proxy::sendMapInfoDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "MapInfo");
    _dbusProxyDelegate->deregisterSignalCallback("MapInfo", 0, _dbusDaemonProxy.get(), true);
}

act_t Device1Proxy::sendConnectedServiceRegister(ConnectedServiceCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_ConnectedService, "ConnectedService", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "ConnectedService", &cb, act);
    return act;
}

bool Device1Proxy::sendConnectedServiceDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("ConnectedService", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "ConnectedService", act, static_cast<int>(rv));
    return rv;
}

act_t Device1Proxy::sendConnectedServiceGet(ConnectedServiceCallbackIF& cb) {
    Device1ProxyCallback* callback = new Device1ProxyCallback(ID_ConnectedService, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "ConnectedService", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("ConnectedService", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint64 Device1Proxy::getConnectedService() const {
    return _connectedService.get().getConnectedService();
}

bool Device1Proxy::hasConnectedService() const {
    return _connectedService.hasValue();
}

void Device1Proxy::sendConnectedServiceDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "ConnectedService");
    _dbusProxyDelegate->deregisterSignalCallback("ConnectedService", 0, _dbusDaemonProxy.get(), true);
}

act_t Device1Proxy::sendVersionRegister(VersionCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_Version, "Version", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Version", &cb, act);
    return act;
}

bool Device1Proxy::sendVersionDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("Version", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Version", act, static_cast<int>(rv));
    return rv;
}

act_t Device1Proxy::sendVersionGet(VersionCallbackIF& cb) {
    Device1ProxyCallback* callback = new Device1ProxyCallback(ID_Version, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "Version", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("Version", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint16 Device1Proxy::getVersion() const {
    return _version.get().getVersion();
}

bool Device1Proxy::hasVersion() const {
    return _version.hasValue();
}

void Device1Proxy::sendVersionDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Version");
    _dbusProxyDelegate->deregisterSignalCallback("Version", 0, _dbusDaemonProxy.get(), true);
}

act_t Device1Proxy::sendPBAPInfoRegister(PBAPInfoCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_PBAPInfo, "PBAPInfo", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "PBAPInfo", &cb, act);
    return act;
}

bool Device1Proxy::sendPBAPInfoDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("PBAPInfo", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "PBAPInfo", act, static_cast<int>(rv));
    return rv;
}

act_t Device1Proxy::sendPBAPInfoGet(PBAPInfoCallbackIF& cb) {
    Device1ProxyCallback* callback = new Device1ProxyCallback(ID_PBAPInfo, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "PBAPInfo", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("PBAPInfo", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::string& Device1Proxy::getPBAPInfo() const {
    return _pBAPInfo.get().getPBAPInfo();
}

bool Device1Proxy::hasPBAPInfo() const {
    return _pBAPInfo.hasValue();
}

void Device1Proxy::sendPBAPInfoDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "PBAPInfo");
    _dbusProxyDelegate->deregisterSignalCallback("PBAPInfo", 0, _dbusDaemonProxy.get(), true);
}

act_t Device1Proxy::sendModeRegister(ModeCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_Mode, "Mode", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Mode", &cb, act);
    return act;
}

bool Device1Proxy::sendModeDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("Mode", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Mode", act, static_cast<int>(rv));
    return rv;
}

act_t Device1Proxy::sendModeGet(ModeCallbackIF& cb) {
    Device1ProxyCallback* callback = new Device1ProxyCallback(ID_Mode, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "Mode", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("Mode", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint8 Device1Proxy::getMode() const {
    return _mode.get().getMode();
}

bool Device1Proxy::hasMode() const {
    return _mode.hasValue();
}

void Device1Proxy::sendModeDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Mode");
    _dbusProxyDelegate->deregisterSignalCallback("Mode", 0, _dbusDaemonProxy.get(), true);
}

act_t Device1Proxy::sendRoleRegister(RoleCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_Role, "Role", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Role", &cb, act);
    return act;
}

bool Device1Proxy::sendRoleDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("Role", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Role", act, static_cast<int>(rv));
    return rv;
}

act_t Device1Proxy::sendRoleGet(RoleCallbackIF& cb) {
    Device1ProxyCallback* callback = new Device1ProxyCallback(ID_Role, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "Role", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("Role", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint8 Device1Proxy::getRole() const {
    return _role.get().getRole();
}

bool Device1Proxy::hasRole() const {
    return _role.hasValue();
}

void Device1Proxy::sendRoleDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Role");
    _dbusProxyDelegate->deregisterSignalCallback("Role", 0, _dbusDaemonProxy.get(), true);
}

act_t Device1Proxy::sendEnableAvpPauseRegister(EnableAvpPauseCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_EnableAvpPause, "EnableAvpPause", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "EnableAvpPause", &cb, act);
    return act;
}

bool Device1Proxy::sendEnableAvpPauseDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("EnableAvpPause", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "EnableAvpPause", act, static_cast<int>(rv));
    return rv;
}

act_t Device1Proxy::sendEnableAvpPauseGet(EnableAvpPauseCallbackIF& cb) {
    Device1ProxyCallback* callback = new Device1ProxyCallback(ID_EnableAvpPause, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "EnableAvpPause", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("EnableAvpPause", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void Device1Proxy::sendEnableAvpPauseSet(bool enableAvpPause) {
    EnableAvpPauseSet parameter(enableAvpPause);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "EnableAvpPause");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "EnableAvpPause", propertyContent);
}

act_t Device1Proxy::sendEnableAvpPauseSet(EnableAvpPauseCallbackIF& cb, bool enableAvpPause) {
    Device1ProxyCallback* callback = new Device1ProxyCallback(ID_EnableAvpPause, &cb);
    EnableAvpPauseSet parameter(enableAvpPause);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "EnableAvpPause", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "EnableAvpPause", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

bool Device1Proxy::getEnableAvpPause() const {
    return _enableAvpPause.get().getEnableAvpPause();
}

bool Device1Proxy::hasEnableAvpPause() const {
    return _enableAvpPause.hasValue();
}

void Device1Proxy::sendEnableAvpPauseDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "EnableAvpPause");
    _dbusProxyDelegate->deregisterSignalCallback("EnableAvpPause", 0, _dbusDaemonProxy.get(), true);
}

act_t Device1Proxy::sendConnectRequest(ConnectCallbackIF& cb) const {
    ConnectRequest* payload = new ConnectRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "Connect", ConnectRequest, payload, true)
    act_t act = addMethodCallback(ID_Connect, dbusMessage.getUniqueSerial(), "Connect", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "Connect", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t Device1Proxy::sendDisconnectRequest(DisconnectCallbackIF& cb) const {
    DisconnectRequest* payload = new DisconnectRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "Disconnect", DisconnectRequest, payload, true)
    act_t act = addMethodCallback(ID_Disconnect, dbusMessage.getUniqueSerial(), "Disconnect", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "Disconnect", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t Device1Proxy::sendPairRequest(PairCallbackIF& cb) const {
    PairRequest* payload = new PairRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "Pair", PairRequest, payload, true)
    act_t act = addMethodCallback(ID_Pair, dbusMessage.getUniqueSerial(), "Pair", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "Pair", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t Device1Proxy::sendCancelPairingRequest(CancelPairingCallbackIF& cb) const {
    CancelPairingRequest* payload = new CancelPairingRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "CancelPairing", CancelPairingRequest, payload, true)
    act_t act = addMethodCallback(ID_CancelPairing, dbusMessage.getUniqueSerial(), "CancelPairing", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "CancelPairing", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t Device1Proxy::sendDiscoverServicesRequest(DiscoverServicesCallbackIF& cb, const ::std::string& pattern) const {
    DiscoverServicesRequest* payload = new DiscoverServicesRequest();
    CHECK_ALLOCATION(payload);
    payload->setPattern(pattern);
    DBUS_MESSAGE_CALL(dbusMessage, "DiscoverServices", DiscoverServicesRequest, payload, true)
    act_t act = addMethodCallback(ID_DiscoverServices, dbusMessage.getUniqueSerial(), "DiscoverServices", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "DiscoverServices", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t Device1Proxy::sendCancelDiscoveryRequest(CancelDiscoveryCallbackIF& cb) const {
    CancelDiscoveryRequest* payload = new CancelDiscoveryRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "CancelDiscovery", CancelDiscoveryRequest, payload, true)
    act_t act = addMethodCallback(ID_CancelDiscovery, dbusMessage.getUniqueSerial(), "CancelDiscovery", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "CancelDiscovery", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

} // namespace Device1
} // namespace bluez
} // namespace org
